#include "myonlinetimer.h"
#include "processa.h"

#include <QDebug>

MyOnlineTimer::MyOnlineTimer()
{
    timer = new QTimer(this);
    connect(timer,SIGNAL(timeout()),this,SLOT(MySlot()));
    Work=Processa();
    Type=PROCESS_NO;
    ENABLE_SCALE=NULL;
    ENABLE_BLUR=NULL;

    LABEL_MAX_COLORMAP=NULL;

    SPINBOX_BLUR_SIZE=NULL;

    ROI_LIN0=NULL;
    ROI_COL0=NULL;
    ROI_HEIGHT=NULL;
    ROI_WIDTH=NULL;
}


void MyOnlineTimer::MySlot()
{
    // contando o tempo
    current_time = (double)cv::getTickCount();
    double fps=cv::getTickFrequency()/(current_time-old_time);
    old_time=current_time;

    // se a camera nao estiver aberta então abro ela
    if(!(CAP->isOpened())) CAP->open(ID);

    // esta é a variavel que contem a imagem.
    cv::Mat frame;
    // tirando a imagem
    if(CAP->isOpened())
    {
        (*CAP) >> frame; // capturo uma imagem

        int    nc=frame.cols;
        int    nr=frame.rows;
        double l0=ROI_LIN0->value()*nr/100.0;
        double c0=ROI_COL0->value()*nc/100.0;
        double h =ROI_HEIGHT->value()*(nr-l0)/100.0;
        double w =ROI_WIDTH->value()*(nc-c0)/100.0;

        cv::Rect roi((int)c0,(int)l0,(int)w,(int)h);

        frame = frame(roi);

        cv::Mat framegray8b;
        cv::Mat framegray;
        cv::Mat framegray_filter;

        cv::cvtColor(frame,framegray8b,cv::COLOR_RGB2GRAY);
        framegray8b.convertTo(framegray, CV_32F);

        framegray_filter=Work.filter(framegray);// filtro a imagem de acordo ao tipo de filtro selecionado

        cv::Mat framegray_blur;
        if(true==*ENABLE_BLUR)
        {
            int N=SPINBOX_BLUR_SIZE->value();
            cv::blur(framegray_filter, framegray_blur, cv::Size(N,N));
        }
        else framegray_blur=framegray_filter;

        cv::minMaxIdx(framegray_blur, &minval, &maxval);// de 0 a 255, nunca de 0 a 1.0

        cv::Mat framemap;
        if(Type!=PROCESS_NO)
        {
            cv::Mat tmp;
            cv::Mat tmp8u;
            if((*ENABLE_SCALE)==true)
            {
                if(maxval>0)    tmp=framegray_blur*(255.0/maxval);
                else            tmp=framegray_blur;
            }
            else tmp=framegray_blur;

            tmp.convertTo(tmp8u, CV_8U);
            cv::applyColorMap(tmp8u, framemap, cv::COLORMAP_JET);
        }
        else
        {
            framegray_blur.convertTo(framemap, CV_8U);
        }

        //criando a a janela
        //cv::namedWindow("Online",cv::WINDOW_AUTOSIZE);
        cv::imshow("Online",framemap); // mostro a imagem

        if((*ENABLE_SCALE)==true)   LABEL_MAX_COLORMAP->setText(QString::number(maxval, 'f', 2));
        else                        LABEL_MAX_COLORMAP->setText("255");
        LABEL_FPS->setText(QString::number(fps, 'f', 2)+" FPS");
        LABEL_MAX->setText(QString::number(maxval, 'f', 2)+" MAX");

    }
    else
    {
        qDebug()<<"Error opening the cam with id: "+QString::number(ID);
        return;
    }
}

void MyOnlineTimer::start_online(QDoubleSpinBox *lin0,
                                 QDoubleSpinBox *col0,
                                 QDoubleSpinBox *height,
                                 QDoubleSpinBox *width,
                                 QSpinBox *spinBox_blur_size,
                                 QLabel *label_max_colormap,
                                 QLabel *label_fps,     // Label onde mostrarei os FPS
                                 QLabel *label_max,     // Label onde mostrarei max value
                                 cv::VideoCapture *cap, // Controlador de video
                                 int camid,             // O ID da camera que vou abrir
                                 int ms,                // O tempo de amostragem =1/Fs
                                 int type,              // Tipo de processamento
                                 int nbloks,            // Numero de blocos de buffer
                                 bool *blur_enable,// Habilita um filtro
                                 bool *scale_enable,    // Habilita escalar el colormap
                                 bool *reset)
{
    CAP=cap;

    LABEL_FPS=label_fps;
    LABEL_MAX=label_max;
    LABEL_MAX_COLORMAP=label_max_colormap;

    ID=camid;
    timer->start(ms);
    old_time = (double)cv::getTickCount();
    Type=type;
    ENABLE_SCALE=scale_enable;
    ENABLE_BLUR=blur_enable;

    SPINBOX_BLUR_SIZE=spinBox_blur_size;

    ROI_LIN0=lin0;
    ROI_COL0=col0;
    ROI_HEIGHT=height;
    ROI_WIDTH=width;

    cv::namedWindow("Online",cv::WINDOW_AUTOSIZE);
    cv::Mat frame;
    (*CAP) >> frame;
    cv::imshow("Online",frame); // mostro a imagem
    cv::moveWindow("Online", 700,0);

    Work.set_reset_handle(reset);
    Work.set_type(type);
    Work.set_nbloks(nbloks);
}

void MyOnlineTimer::stop_online(void)
{
    timer->stop();

    Work.mat_release();
    Work.set_count(0);
    cv::destroyWindow("Online");


}
