/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import jolon.xml.XMLObject;

class Book {
    public String name;
    public String fileName;
    public Vector chapters = new Vector();
    public int startChapter = -1;
    public int endChapter = -1;

    public Book(String name, int startChapter, int endChapter) {
        this.name = name;
        this.startChapter = startChapter;
        this.endChapter = endChapter;
    }

    public Book(XMLObject book, GoBibleCreator creator, String primaryBookNameAttribute, String secondaryBookNameAttribute) {
        this.name = book.getAttributeAsString(primaryBookNameAttribute, null);
        if (this.name == null) {
            if (secondaryBookNameAttribute != null) {
                this.name = book.getAttribute(secondaryBookNameAttribute, "*Error no book name*");
            } else {
                System.out.println("Error: no book name");
            }
        }
        try {
            String temp;
            byte[] shortNameBytes = this.name.getBytes("US-ASCII");
            this.fileName = new String(shortNameBytes, "US-ASCII");
            this.fileName = temp = this.fileName.replace('?', '_');
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e.toString());
        }
        int chapterNumber = 0;
        Enumeration e = book.getChildren();
        while (e.hasMoreElements()) {
            XMLObject xml = (XMLObject)e.nextElement();
            if (!creator.isChapter(xml)) continue;
            if (this.startChapter == -1) {
                chapterNumber = this.startChapter = creator.getChapterNumber(xml);
            }
            Chapter chapter = new Chapter();
            creator.parseChapter(xml, chapter);
            this.chapters.addElement(chapter);
            ++chapterNumber;
        }
    }

    public Book(String sFilename, char cSTYLE_RED, String fileCodepage, boolean useRedLettering, String sTitleTag) {
        try {
            String lineIn;
            File fIn = new File(sFilename);
            if (fileCodepage == null) {
                fileCodepage = "UTF-8";
            }
            this.fileName = fIn.getName();
            BufferedReader readerIn = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fIn), fileCodepage));
            StringBuffer strBuff = new StringBuffer();
            while ((lineIn = readerIn.readLine()) != null) {
                if (!USFM_Utilities.CheckIfWeKeepLine(lineIn)) continue;
                if (lineIn.startsWith("\\")) {
                    strBuff.append(lineIn);
                    continue;
                }
                strBuff.append(" " + lineIn);
            }
            readerIn.close();
            String sHtag = "";
            int iStart = strBuff.indexOf(sTitleTag);
            if (iStart != -1) {
                sHtag = strBuff.length() >= iStart + 200 ? strBuff.substring(iStart + 2, iStart + 200) : strBuff.substring(iStart + 2);
                iStart = sHtag.indexOf("\\");
                this.name = USFM_Utilities.CleanBookName(sHtag.substring(1, iStart).trim());
            }
            if (sHtag.equals("")) {
                System.out.println("ERROR: Can not process the following book as there are no " + sTitleTag + " tags");
                System.out.println("Filename:" + sFilename);
                System.out.println("Please remove the book from the collection or fix the tags...");
            }
            String[] sChapters = strBuff.toString().split("\\\\c ");
            for (int i = 0; i < sChapters.length; ++i) {
                if (!sChapters[i].trim().startsWith("1")) continue;
                iStart = i;
                break;
            }
            int iChapter = 0;
            for (int i = iStart; i < sChapters.length; ++i) {
                if (this.startChapter == -1) {
                    this.startChapter = i;
                }
                ++iChapter;
                Chapter chapter = new Chapter();
                String sTmp = sChapters[i].toString();
                sTmp = USFM_Utilities.RemoveChapterHeaders(sTmp);
                sTmp = USFM_Utilities.RemoveDoubleMarkerTags(sTmp);
                sTmp = USFM_Utilities.RemoveDoubleMarkerTagsFull(sTmp);
                sTmp = USFM_Utilities.RemoveSingularMarkerTags(sTmp);
                sTmp = USFM_Utilities.ReplaceWordsOfJesus(sTmp, cSTYLE_RED, useRedLettering);
                String[] sVerses = sTmp.split("\\\\v ");
                String verseString = "";
                for (int j = 0; j < sVerses.length; ++j) {
                    verseString = sVerses[j];
                    if (!verseString.equals("")) {
                        if ((verseString = USFM_Utilities.RemoveVerseNumbering(verseString)).indexOf("\\") != -1) {
                            int iTagStart = verseString.indexOf("\\");
                            int iTagEnd = verseString.indexOf(" ", iTagStart);
                            if (iTagEnd == -1) {
                                iTagEnd = verseString.length();
                            }
                            System.out.println("EXTRA UNPROCESSED TAGS: [" + verseString.substring(iTagStart, iTagEnd) + "] " + this.name + " " + String.valueOf(iChapter) + ":" + String.valueOf(j) + " in file: " + sFilename);
                        }
                        if (verseString.length() == 0 && GoBibleCreator.EmptyVerseString != null) {
                            verseString = GoBibleCreator.EmptyVerseString;
                        }
                        chapter.verses.addElement(verseString);
                        chapter.allVerses.append(verseString);
                        continue;
                    }
                    int asdf = 123;
                    ++asdf;
                }
                this.chapters.addElement(chapter);
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public boolean hasVerses() {
        int verseSize = 0;
        for (int i = 0; i < this.chapters.size(); ++i) {
            Chapter c = (Chapter)this.chapters.elementAt(i);
            if (GoBibleCreator.EmptyVerseString == null) {
                verseSize += c.allVerses.length();
            } else {
                Enumeration e = c.verses.elements();
                while (e.hasMoreElements()) {
                    String verse = (String)e.nextElement();
                    if (GoBibleCreator.EmptyVerseString.equals(verse) || verse.length() <= 0) continue;
                    verseSize += verse.length();
                    break;
                }
            }
            if (verseSize > 0) break;
        }
        return verseSize > 0;
    }
}

