# $Id: io.rb,v 1.5 2002/12/11 12:01:58 knu Exp $

require 'features/ruby18/base'
require 'features/ruby18/io_ruby18.so'

class << IO
  def for_fd(*x, &block)
    # XXX: block is ignored
    new(*x)
  end

  def read(filepath)
    f = open(filepath)

    begin
      return f.read
    ensure
      f.close
    end
  end
end

class IO
  alias __ruby16_read read
  alias __ruby16_sysread sysread

  def read(len = nil, buf = nil)
    if buf.nil?
      __ruby16_read(*[len].compact)
    else
      buf.replace(__ruby16_read(*[len].compact))
    end
  end

  def sysread(len, buf = nil)
    if buf.nil?
      __ruby16_sysread(len)
    else
      buf.replace(__ruby16_sysread(len))
    end
  end
end
