# $Id: tc_regexp.rb,v 1.4 2002/09/11 07:10:04 knu Exp $

require 'test/unit'
begin
  require 'features/ruby18/regexp'
rescue LoadError; end

class TC_Regexp < Test::Unit::TestCase
  def test_options
    re = /a/

    assert_equal(0,
		 re.options & (Regexp::IGNORECASE |
			       Regexp::EXTENDED |
			       Regexp::MULTILINE))

    re = /a/i

    assert_equal(Regexp::IGNORECASE,
		 re.options & (Regexp::IGNORECASE |
			       Regexp::EXTENDED |
			       Regexp::MULTILINE))

    re = /a/mix

    assert_equal(Regexp::IGNORECASE |
		 Regexp::EXTENDED |
		 Regexp::MULTILINE,
		 re.options & (Regexp::IGNORECASE |
			       Regexp::EXTENDED |
			       Regexp::MULTILINE))
  end

=begin
  def test_to_s
    re = /(a|b)*/

    assert_equal("(?-mix:(a|b)*)", re.to_s)

    re = /(a|b)*/i

    assert_equal("(?i-mx:(a|b)*)", re.to_s)

    re = /(a|b)*/mix

    assert_equal("(?mix:(a|b)*)", re.to_s)
  end
=end
end

class TC_MatchData < Test::Unit::TestCase
  def test_select
    m = /(.)(..)(...)(..)(.)/.match('abcdefghi')

    assert_equal(['a', 'def', 'i'], m.select(1, 3, 5))
  end

  def test_to_ary
    m = /(.)(..)(...)(..)(.)/.match('abcdefghi')

    assert_equal(['abcdefghi', 'a', 'bc', 'def', 'gh', 'i'], m.to_ary)

    s, a, b, = m

    assert_equal('abcdefghi', s)
    assert_equal('a', a)
    assert_equal('bc', b)
  end
end
