# $Id: tc_enumerable.rb,v 1.3 2002/05/03 21:03:56 knu Exp $

require 'test/unit'
begin
  require 'features/ruby18/enumerable'
rescue LoadError; end

class TC_Enumerable < Test::Unit::TestCase
  def test_all?
    assert_equal(true, [0, 2, 4, 6].all? {|i| i % 2 == 0})
    assert_equal(false, [0, 2, 4, 7].all? {|i| i % 2 == 0})
    assert_equal(true, ["", [], {}].all? {|i| i.empty?})
    assert_equal(false, ["", [], {}, "a"].all? {|i| i.empty?})
  end

  def test_any?
    assert_equal(true, [0, 2, 4, 7].any? {|i| i % 2 != 0})
    assert_equal(false, [0, 2, 4, 6].any? {|i| i % 2 != 0})
    assert_equal(false, ["", [], {}].any? {|i| !i.empty?})
    assert_equal(true, ["", [], {}, "a"].any? {|i| !i.empty?})
  end

  def test_inject
    a = (1..4)
    assert_equal(11, a.inject(1) {|x,y| x+y})
    assert_equal(10, a.inject {|x,y| x+y})

    assert_equal('abcde', ['a', 'b', 'c', 'd', 'e'].inject('') { |r, v| r << v })
  end

  def test_partition
    a, b = [10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0].partition { |i| i % 3 == 0 }

    assert_equal([9, 6, 3, 0], a)
    assert_equal([10, 8, 7, 5, 4, 2, 1], b)
  end

  def test_sort_by
    i = 0
    assert_equal(["BAR", "bar", "FOO", "foo"],
		 ["BAR", "FOO", "bar", "foo"].
		 sort_by { |v| [v.downcase, i += 1] })
  end
end
