/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.serialization;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.apache.tika.metadata.Metadata;

public class JsonStreamingSerializer
implements AutoCloseable {
    private final JsonWriter jsonWriter;
    boolean hasStartedArray = false;

    public JsonStreamingSerializer(Writer writer) {
        this.jsonWriter = new JsonWriter(writer);
    }

    public void add(Metadata metadata) throws IOException {
        if (!this.hasStartedArray) {
            this.jsonWriter.beginArray();
            this.hasStartedArray = true;
        }
        Object[] names = metadata.names();
        Arrays.sort(names);
        this.jsonWriter.beginObject();
        for (Object n : names) {
            this.jsonWriter.name((String)n);
            String[] values = metadata.getValues((String)n);
            if (values.length == 1) {
                this.jsonWriter.value(values[0]);
                continue;
            }
            this.jsonWriter.beginArray();
            for (String v : values) {
                this.jsonWriter.value(v);
            }
            this.jsonWriter.endArray();
        }
        this.jsonWriter.endObject();
    }

    @Override
    public void close() throws IOException {
        this.jsonWriter.endArray();
        this.jsonWriter.flush();
        this.jsonWriter.close();
    }
}

