/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.vfs2.provider.rar;

import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import com.github.junrar.vfs2.provider.rar.RARFileSystem;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;

public class RARFileObject
extends AbstractFileObject<RARFileSystem>
implements FileObject {
    protected Archive archive;
    protected FileHeader header;
    private final RARFileSystem fs;
    private final HashSet<String> children = new HashSet();

    protected RARFileObject(AbstractFileName name, Archive archive, FileHeader header, RARFileSystem fs) throws FileSystemException {
        super(name, (AbstractFileSystem)fs);
        this.fs = fs;
        this.archive = archive;
        this.header = header;
        archive.getMainHeader().isFirstVolume();
    }

    public boolean doIsWriteable() throws FileSystemException {
        return false;
    }

    protected FileType doGetType() {
        if (this.header == null || this.header.isDirectory()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected String[] doListChildren() {
        try {
            if (!this.getType().hasChildren()) {
                return null;
            }
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        return this.children.toArray(new String[this.children.size()]);
    }

    protected long doGetContentSize() {
        return this.header.getFullUnpackSize();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.header.getMTime().getTime();
    }

    protected InputStream doGetInputStream() throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", (Object)this.getName());
        }
        return this.archive.getInputStream(this.header);
    }

    public void attachChild(FileName childName) {
        this.children.add(childName.getBaseName());
    }

    public void setHeader(FileHeader header) {
        this.header = header;
    }
}

