// Generated by CoffeeScript 1.12.7

/*
LemonLDAP::NG Portal jQuery scripts
 */

(function() {
  var datas, delKey, displayIcon, getCookie, getQueryParam, getValues, isHiddenFormValueSet, ping, ppolicyResults, removeOidcConsent, restoreOrder, setCookie, setKey, setOrder, setResult, setSelector, translate, translatePage, translationFields, updateBorder,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  translationFields = {};

  ppolicyResults = {};

  setResult = function(field, result) {
    var ref, ref1;
    ppolicyResults[field] = result;
    displayIcon(field, result);
    if (Object.values(ppolicyResults).every((function(_this) {
      return function(value) {
        return value === "good" || value === "info";
      };
    })(this))) {
      if ((ref = $('#newpassword').get(0)) != null) {
        ref.setCustomValidity('');
      }
    } else {
      if ((ref1 = $('#newpassword').get(0)) != null) {
        ref1.setCustomValidity(translate('PE28'));
      }
    }
    return updateBorder();
  };

  displayIcon = function(field, result) {
    $("#" + field).removeClass('fa-times fa-check fa-spinner fa-pulse fa-info-circle fa-question-circle text-danger text-success text-info text-secondary');
    $("#" + field).attr('role', 'status');
    switch (result) {
      case "good":
        return $("#" + field).addClass('fa-check text-success');
      case "bad":
        $("#" + field).addClass('fa-times text-danger');
        return $("#" + field).attr('role', 'alert');
      case "unknown":
        return $("#" + field).addClass('fa-question-circle text-secondary');
      case "waiting":
        return $("#" + field).addClass('fa-spinner fa-pulse text-secondary');
      case "info":
        return $("#" + field).addClass('fa-info-circle text-info');
    }
  };

  updateBorder = function() {
    var ref, ref1;
    if (((ref = $('#newpassword').get(0)) != null ? ref.checkValidity() : void 0) && ((ref1 = $('#confirmpassword').get(0)) != null ? ref1.checkValidity() : void 0)) {
      return $('.ppolicy').removeClass('border-danger').addClass('border-success');
    } else {
      return $('.ppolicy').removeClass('border-success').addClass('border-danger');
    }
  };

  translatePage = function(lang) {
    return $.getJSON(window.staticPrefix + "languages/" + lang + ".json", function(data) {
      var k, ref, ref1, v;
      translationFields = data;
      ref = window.datas.trOver.all;
      for (k in ref) {
        v = ref[k];
        translationFields[k] = v;
      }
      if (window.datas.trOver[lang]) {
        ref1 = window.datas.trOver[lang];
        for (k in ref1) {
          v = ref1[k];
          translationFields[k] = v;
        }
      }
      $("[trspan]").each(function() {
        var args, i, len, txt;
        args = $(this).attr('trspan').split(',');
        txt = translate(args.shift());
        for (i = 0, len = args.length; i < len; i++) {
          v = args[i];
          txt = txt.replace(/%[sd]/, v);
        }
        return $(this).html(txt);
      });
      $("[trmsg]").each(function() {
        var msg;
        $(this).html(translate("PE" + ($(this).attr('trmsg'))));
        msg = translate("PE" + ($(this).attr('trmsg')));
        if (msg.match(/_hide_/)) {
          return $(this).parent().hide();
        }
      });
      $("[trattribute]").each(function() {
        var attribute, i, len, ref2, trattribute, trattributes, value;
        trattributes = $(this).attr('trattribute').trim().split(/\s+/);
        for (i = 0, len = trattributes.length; i < len; i++) {
          trattribute = trattributes[i];
          ref2 = trattribute.split(':'), attribute = ref2[0], value = ref2[1];
          if (attribute && value) {
            $(this).attr(attribute, translate(value));
          }
        }
        return true;
      });
      $("[trplaceholder]").each(function() {
        var tmp;
        tmp = translate($(this).attr('trplaceholder'));
        $(this).attr('placeholder', tmp);
        return $(this).attr('aria-label', tmp);
      });
      return $("[localtime]").each(function() {
        var d;
        d = new Date($(this).attr('localtime') * 1000);
        return $(this).text(d.toLocaleString());
      });
    });
  };

  translate = function(str) {
    if (translationFields[str]) {
      return translationFields[str];
    } else {
      return str;
    }
  };

  window.translate = translate;

  getValues = function() {
    var values;
    values = {};
    $("script[type='application/init']").each(function() {
      var e, k, results, tmp;
      try {
        tmp = JSON.parse($(this).text());
        results = [];
        for (k in tmp) {
          results.push(values[k] = tmp[k]);
        }
        return results;
      } catch (error1) {
        e = error1;
        console.log('Parsing error', e);
        return console.log('JSON', $(this).text());
      }
    });
    console.log(values);
    return values;
  };

  getQueryParam = function(name) {
    var match;
    match = RegExp('[?&]' + name + '=([^&]*)').exec(window.location.search);
    if (match) {
      return decodeURIComponent(match[1].replace(/\+/g, ' '));
    } else {
      return null;
    }
  };

  setSelector = "#appslist";

  setOrder = function() {
    return setKey('_appsListOrder', $(setSelector).sortable("toArray").join());
  };

  removeOidcConsent = function(partner) {
    var e;
    e = function(j, s, e) {
      return alert(s + " " + e);
    };
    return delKey("_oidcConsents", partner, function() {
      return $("[partner='" + partner + "']").hide();
    }, e);
  };

  setKey = function(key, val, success, error) {
    return $.ajax({
      type: "GET",
      url: scriptname + 'mysession/?gettoken',
      dataType: 'json',
      error: error,
      success: function(data) {
        var d;
        d = {
          token: data.token
        };
        d[key] = val;
        return $.ajax({
          type: "PUT",
          url: scriptname + 'mysession/persistent',
          dataType: 'json',
          data: d,
          success: success,
          error: error
        });
      }
    });
  };

  delKey = function(key, sub, success, error) {
    return $.ajax({
      type: "GET",
      url: scriptname + 'mysession/?gettoken',
      dataType: 'json',
      error: error,
      success: function(data) {
        return $.ajax({
          type: "DELETE",
          url: scriptname + "mysession/persistent/" + key + "?sub=" + sub + "&token=" + data.token,
          dataType: 'json',
          success: success,
          error: error
        });
      }
    });
  };

  restoreOrder = function() {
    var IDs, child, i, item, itemID, items, l, len, len1, list, rebuild, savedOrd, v;
    list = $(setSelector);
    if (!((list != null) && datas['appslistorder'])) {
      return null;
    }
    IDs = datas['appslistorder'].split(',');
    items = list.sortable("toArray");
    rebuild = [];
    for (i = 0, len = items.length; i < len; i++) {
      v = items[i];
      rebuild[v] = v;
    }
    for (l = 0, len1 = IDs.length; l < len1; l++) {
      itemID = IDs[l];
      if (rebuild[itemID]) {
        item = rebuild[itemID];
        child = $(setSelector + ".ui-sortable").children("#" + item);
        savedOrd = $(setSelector + ".ui-sortable").children("#" + itemID);
        child.remove();
        $(setSelector + ".ui-sortable").filter(":first").append(savedOrd);
      }
    }
    return 1;
  };

  isHiddenFormValueSet = function(option) {
    return $('#lmhidden_' + option).length;
  };

  ping = function() {
    return $.ajax({
      type: "POST",
      url: scriptname,
      data: {
        ping: 1
      },
      dataType: 'json',
      success: function(data) {
        if ((data.result != null) && data.result === 1) {
          return setTimeout(ping, datas['pingInterval']);
        } else {
          return location.reload(true);
        }
      },
      error: function(j, t, e) {
        return location.reload(true);
      }
    });
  };

  window.ping = ping;

  getCookie = function(cname) {
    var c, ca, i, len, name, re;
    name = cname + "=";
    ca = decodeURIComponent(document.cookie).split(';');
    re = new RegExp('^ *' + cname + '=');
    for (i = 0, len = ca.length; i < len; i++) {
      c = ca[i];
      if (c.match(re)) {
        c = c.replace(re, '');
        return c;
      }
    }
    return '';
  };

  setCookie = function(name, value, exdays) {
    var cookiestring, d, samesite, secure;
    samesite = datas['sameSite'];
    secure = datas['cookieSecure'];
    cookiestring = name + "=" + value + "; path=/; SameSite=" + samesite;
    if (exdays) {
      d = new Date();
      d.setTime(d.getTime() + exdays * 86400000);
      cookiestring += "; expires=" + (d.toUTCString());
    }
    if (secure) {
      cookiestring += "; Secure";
    }
    return document.cookie = cookiestring;
  };

  datas = {};

  $(window).on('load', function() {
    var action, al, authMenuIndex, authMenuTabs, back_url, checkpassword, checksamepass, field, hiddenParams, i, lang, langdiv, len, link, menuIndex, menuTabs, method, queryLang, ref, setCookieLang, togglecheckpassword;
    datas = getValues();
    if ("datas" in window && "choicetab" in window.datas) {
      datas.choicetab = window.datas.choicetab;
    }
    window.datas = datas;
    $("#appslist").sortable({
      axis: "y",
      cursor: "move",
      opacity: 0.5,
      revert: true,
      items: "> div.category",
      update: function() {
        return setOrder();
      }
    });
    restoreOrder();
    $("div.message").fadeIn('slow');
    $("input[name=timezone]").val(-(new Date().getTimezoneOffset() / 60));
    menuTabs = $("#menu").tabs({
      active: 0
    });
    menuIndex = $('#menu a[href="#' + datas['displaytab'] + '"]').parent().index();
    if (menuIndex < 0) {
      menuIndex = 0;
    }
    menuTabs.tabs("option", "active", menuIndex);
    authMenuTabs = $("#authMenu").tabs({
      active: 0
    });
    authMenuIndex = $('#authMenu a[href="#' + datas['displaytab'] + '"]').parent().index();
    if (authMenuIndex < 0) {
      authMenuIndex = 0;
    }
    authMenuTabs.tabs("option", "active", authMenuIndex);
    if (datas['choicetab']) {
      authMenuTabs.tabs("option", "active", $('#authMenu a[href="#' + datas['choicetab'] + '"]').parent().index());
    }
    if ($("input[autofocus]").length === 0) {
      $("input[type!=hidden]:first").focus();
    }
    if (datas['newwindow']) {
      $('#appslist a').attr("target", "_blank");
    }
    if ($("p.removeOther").length) {
      action = $("#form").attr("action");
      method = $("#form").attr("method");
      console.log('method=', method);
      hiddenParams = "";
      if ($("#form input[type=hidden]")) {
        console.log('Parse hidden values');
        $("#form input[type=hidden]").each(function(index) {
          console.log(' ->', $(this).attr("name"), $(this).val());
          return hiddenParams += "&" + $(this).attr("name") + "=" + $(this).val();
        });
      }
      back_url = "";
      if (action) {
        console.log('action=', action);
        if (action.indexOf("?") !== -1) {
          action.substring(0, action.indexOf("?")) + "?";
        } else {
          back_url = action + "?";
        }
        back_url += hiddenParams;
        hiddenParams = "";
      }
      link = $("p.removeOther a").attr("href") + "&method=" + method + hiddenParams;
      if (back_url) {
        link += "&url=" + btoa(back_url);
      }
      $("p.removeOther a").attr("href", link);
    }
    if (window.location.search) {
      queryLang = getQueryParam('llnglanguage');
      if (queryLang) {
        console.log('Get lang from parameter');
      }
      setCookieLang = getQueryParam('setCookieLang');
      if (setCookieLang === 1) {
        console.log('Set lang cookie');
      }
    }
    if (!lang) {
      lang = window.datas['language'];
      if (lang && !queryLang) {
        console.log('Get lang from server');
      }
    } else if (indexOf.call(window.availableLanguages, lang) < 0) {
      lang = window.datas['language'];
      if (!queryLang) {
        console.log('Lang not available -> Get lang from server');
      }
    }
    if (queryLang) {
      if (indexOf.call(window.availableLanguages, queryLang) < 0) {
        console.log('Lang not available -> Get lang from server');
        queryLang = window.language;
      }
      console.log('Selected lang ->', queryLang);
      if (setCookieLang) {
        console.log('Set cookie lang ->', queryLang);
        setCookie('llnglanguage', queryLang, 3650);
      }
      translatePage(queryLang);
    } else {
      console.log('Selected lang ->', lang);
      translatePage(lang);
    }
    langdiv = '';
    ref = window.availableLanguages;
    for (i = 0, len = ref.length; i < len; i++) {
      al = ref[i];
      langdiv += "<img class=\"langicon\" src=\"" + window.staticPrefix + "common/" + al + ".png\" title=\"" + al + "\" alt=\"[" + al + "]\"> ";
    }
    $('#languages').html(langdiv);
    $('.langicon').on('click', function() {
      lang = $(this).attr('title');
      setCookie('llnglanguage', lang, 3650);
      return translatePage(lang);
    });
    checkpassword = function(password, evType) {
      var e, info;
      e = jQuery.Event("checkpassword");
      info = {
        password: password,
        evType: evType,
        setResult: setResult
      };
      return $(document).trigger(e, info);
    };
    checksamepass = function() {
      var ref1, ref2, ref3, ref4, ref5;
      if (((ref1 = $('#confirmpassword').get(0)) != null ? ref1.value : void 0) && ((ref2 = $('#confirmpassword').get(0)) != null ? ref2.value : void 0) === ((ref3 = $('#newpassword').get(0)) != null ? ref3.value : void 0)) {
        if ((ref4 = $('#confirmpassword').get(0)) != null) {
          ref4.setCustomValidity('');
        }
        displayIcon("samepassword-feedback", "good");
        updateBorder();
        return true;
      } else {
        if ((ref5 = $('#confirmpassword').get(0)) != null) {
          ref5.setCustomValidity(translate('PE34'));
        }
        displayIcon("samepassword-feedback", "bad");
        updateBorder();
        return false;
      }
    };
    if ((window.datas.ppolicy != null) && $('#newpassword').length) {
      checkpassword('');
      checksamepass();
      $('#confirmpassword').keyup(function(e) {
        checksamepass();
      });
      $('#newpassword').keyup(function(e) {
        checkpassword(e.target.value);
        checksamepass();
      });
      $('#newpassword').focusout(function(e) {
        checkpassword(e.target.value, "focusout");
        checksamepass();
      });
    }
    togglecheckpassword = function(e) {
      var ref1;
      if (e.target.checked) {
        $('#newpassword').off('keyup');
        return (ref1 = $('#newpassword').get(0)) != null ? ref1.setCustomValidity('') : void 0;
      } else {
        $('#newpassword').keyup(function(e) {
          checkpassword(e.target.value);
        });
        return checkpassword('');
      }
    };
    $('#newpassword').change(checksamepass);
    $('#confirmpassword').change(checksamepass);
    if ((window.datas.ppolicy != null) && $('#newpassword').length) {
      $('#reset').change(togglecheckpassword);
    }
    $(".localeDate").each(function() {
      var s;
      s = new Date($(this).attr("val") * 1000);
      return $(this).text(s.toLocaleString());
    });
    $('.oidcConsent').on('click', function() {
      return removeOidcConsent($(this).attr('partner'));
    });
    if (datas['pingInterval'] && datas['pingInterval'] > 0) {
      window.setTimeout(ping, datas['pingInterval']);
    }
    if (datas['enablePasswordDisplay']) {
      field = '';
      if (datas['dontStorePassword']) {
        $(".toggle-password").on('mousedown touchstart', function() {
          field = $(this).attr('id');
          field = field.replace(/^toggle_/, '');
          console.log('Display', field);
          $(this).toggleClass("fa-eye fa-eye-slash");
          return $("input[name=" + field + "]").attr('class', 'form-control');
        });
        $(".toggle-password").on('mouseup touchend', function() {
          $(this).toggleClass("fa-eye fa-eye-slash");
          if ($("input[name=" + field + "]").get(0).value) {
            return $("input[name=" + field + "]").attr('class', 'form-control key');
          }
        });
      } else {
        $(".toggle-password").on('mousedown touchstart', function() {
          field = $(this).attr('id');
          field = field.replace(/^toggle_/, '');
          console.log('Display', field);
          $(this).toggleClass("fa-eye fa-eye-slash");
          return $("input[name=" + field + "]").attr("type", "text");
        });
        $(".toggle-password").on('mouseup touchend', function() {
          $(this).toggleClass("fa-eye fa-eye-slash");
          return $("input[name=" + field + "]").attr("type", "password");
        });
      }
    }
    $('#reset').change(function() {
      var checked, ref1, ref2, ref3, ref4, ref5;
      checked = $(this).prop('checked');
      console.log('Reset is checked', checked);
      if (checked === true) {
        $('#ppolicy').hide();
        $('#newpasswords').hide();
        $('#newpassword').removeAttr('required');
        $('#confirmpassword').removeAttr('required');
        return (ref1 = $('#confirmpassword').get(0)) != null ? ref1.setCustomValidity('') : void 0;
      } else {
        $('#ppolicy').show();
        $('#newpasswords').show();
        $('#newpassword').attr('required', true);
        $('#confirmpassword').attr('required', true);
        if (((ref2 = $('#confirmpassword').get(0)) != null ? ref2.value : void 0) === ((ref3 = $('#newpassword').get(0)) != null ? ref3.value : void 0)) {
          return (ref4 = $('#confirmpassword').get(0)) != null ? ref4.setCustomValidity('') : void 0;
        } else {
          return (ref5 = $('#confirmpassword').get(0)) != null ? ref5.setCustomValidity(translate('PE34')) : void 0;
        }
      }
    });
    $('#passwordfield').on('input', function() {
      if ($('#passwordfield').get(0).value && datas['dontStorePassword']) {
        return $("#passwordfield").attr('class', 'form-control key');
      } else {
        return $("#passwordfield").attr('class', 'form-control');
      }
    });
    $('#oldpassword').on('input', function() {
      if ($('#oldpassword').get(0).value && datas['dontStorePassword']) {
        return $("#oldpassword").attr('class', 'form-control key');
      } else {
        return $("#oldpassword").attr('class', 'form-control');
      }
    });
    $('#newpassword').on('input', function() {
      if ($('#newpassword').get(0).value && datas['dontStorePassword']) {
        return $("#newpassword").attr('class', 'form-control key');
      } else {
        return $("#newpassword").attr('class', 'form-control');
      }
    });
    $('#confirmpassword').on('input', function() {
      if ($('#confirmpassword').get(0).value && datas['dontStorePassword']) {
        return $("#confirmpassword").attr('class', 'form-control key');
      } else {
        return $("#confirmpassword").attr('class', 'form-control');
      }
    });
    $('.clear-finduser-field').on('click', function() {
      return $(this).parent().find(':input').each(function() {
        console.log('Clear search field ->', $(this).attr('name'));
        return $(this).val('');
      });
    });
    $('#closefinduserform').on('click', function() {
      console.log('Clear modal');
      return $('#finduserForm').trigger('reset');
    });
    $('#finduserbutton').on('click', function(event) {
      var str;
      event.preventDefault();
      document.body.style.cursor = 'progress';
      str = $("#finduserForm").serialize();
      console.log('Send findUser request with parameters', str);
      return $.ajax({
        type: "POST",
        url: portal + "finduser",
        dataType: 'json',
        data: str,
        success: function(data) {
          var user;
          document.body.style.cursor = 'default';
          user = data.user;
          console.log('Suggested spoofId=', user);
          $("input[name=spoofId]").each(function() {
            return $(this).val(user);
          });
          if (data.captcha) {
            $('#captcha').attr('src', data.captcha);
          }
          if (data.token) {
            $('#finduserToken').val(data.token);
            return $('#token').val(data.token);
          }
        },
        error: function(j, status, err) {
          var res;
          document.body.style.cursor = 'default';
          if (err) {
            console.log('Error', err);
          }
          if (j) {
            res = JSON.parse(j.responseText);
          }
          if (res && res.error) {
            return console.log('Returned error', res);
          }
        }
      });
    });
    $('#btn-back-to-top').on('click', function() {
      console.log('Back to top');
      document.body.scrollTop = 0;
      return document.documentElement.scrollTop = 0;
    });
    $(window).on('scroll', function() {
      if (datas['scrollTop'] && (document.body.scrollTop > Math.abs(datas['scrollTop']) || document.documentElement.scrollTop > Math.abs(datas['scrollTop']))) {
        return $('#btn-back-to-top').css("display", "block");
      } else {
        return $('#btn-back-to-top').css("display", "none");
      }
    });
    $('.btn-single-submit').on('click', function(event) {
      if ($(this).data('data-submitted') === true) {
        event.preventDefault();
        return $(this).prop('disabled', true);
      } else {
        return $(this).data('data-submitted', true);
      }
    });
    $(document).trigger("portalLoaded");
    return true;
  });

}).call(this);
