### base class for the display mechanism (SDL window code is in the aggregatees)

use 'GFX-Tools-Buffer::matrix';

sub new {
	my $class = shift;

	### contains the xy matrix of the on display curve, can be transformed
	$self = { $displaymatrix => undef, };

	bless $self, $class;
}

sub getMatrix {
  my $self = shift;

  return $self->{matrix};
}

### loop e.g. to display
sub setMatrix {
  my ($self, $rows, $columns) = @_;

  $self->{matrix} = matrix->new($rows, $columns);
}

sub display {
  my ($self, $DisplayAgg) = @_;

  $DisplayAgg->display($self); ### e.g. use SDL, DisplayAggSDL.pm
}

1;
