# Generated by default/object.tt
package Paws::WAFV2::CustomRequestHandling;
  use Moose;
  has InsertHeaders => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::CustomHTTPHeader]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::CustomRequestHandling

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::CustomRequestHandling object:

  $service_obj->Method(Att1 => { InsertHeaders => $value, ..., InsertHeaders => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::CustomRequestHandling object:

  $result = $service_obj->Method(...);
  $result->Att1->InsertHeaders

=head1 DESCRIPTION

Custom request handling behavior that inserts custom headers into a web
request. You can add custom request handling for the rule actions allow
and count.

For information about customizing web requests and responses, see
Customizing web requests and responses in WAF
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
in the WAF Developer Guide
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> InsertHeaders => ArrayRef[L<Paws::WAFV2::CustomHTTPHeader>]

The HTTP headers to insert into the request. Duplicate header names are
not allowed.

For information about the limits on count and size for custom request
and response settings, see WAF quotas
(https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in
the WAF Developer Guide
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

