use strict;
use warnings;
use utf8;
use Test::More;
use t::Util;

sub run;

my $parser = make_parser
    q{01101,"060  ","0600042","ﾎｯｶｲﾄﾞｳ","ｻｯﾎﾟﾛｼﾁｭｳｵｳｸ","ｵｵﾄﾞｵﾘﾆｼ(1-19ﾁｮｳﾒ)","北海道","札幌市中央区","大通西（１〜１９丁目）",1,0,1,0,0,0},
    q{13307,"19002","1900211","ﾄｳｷｮｳﾄ","ﾆｼﾀﾏｸﾞﾝﾋﾉﾊﾗﾑﾗ","ﾐﾂｺﾞ","東京都","西多摩郡檜原村","三都郷",0,0,0,0,0,0},
    q{13308,"19801","1980213","ﾄｳｷｮｳﾄ","ﾆｼﾀﾏｸﾞﾝｵｸﾀﾏﾏﾁ","ｳﾅｻﾞﾜ","東京都","西多摩郡奥多摩町","海沢",0,0,0,0,0,0},
    q{34101,"730  ","7300851","ﾋﾛｼﾏｹﾝ","ﾋﾛｼﾏｼﾅｶｸ","ｴﾉﾏﾁ","広島県","広島市中区","榎町",0,0,0,0,0,0},
    q{40101,"80001","8000101","ﾌｸｵｶｹﾝ","ｷﾀｷｭｳｼｭｳｼﾓｼﾞｸ","ｲｶﾜ","福岡県","北九州市門司区","伊川",0,0,0,0,0,0},
    q{10344,"37035","3703503","ｸﾞﾝﾏｹﾝ","ｷﾀｸﾞﾝﾏｸﾞﾝｼﾝﾄｳﾑﾗ","ｱﾗｲ","群馬県","北群馬郡榛東村","新井",0,0,0,0,0,0},
    q{13204,"181  ","1810011","ﾄｳｷｮｳﾄ","ﾐﾀｶｼ","ｲｸﾞﾁ","東京都","三鷹市","井口",0,0,1,0,0,0},
    q{13113,"150  ","1506001","ﾄｳｷｮｳﾄ","ｼﾌﾞﾔｸ","ｴﾋﾞｽ","東京都","渋谷区","恵比寿",0,0,0,0,0,0},
    q{13361,"10001","1000102","ﾄｳｷｮｳﾄ","ｵｵｼﾏﾏﾁ","ｵｶﾀ","東京都","大島町","岡田",0,0,0,0,0,0},
    q{13363,"10005","1000511","ﾄｳｷｮｳﾄ","ﾆｲｼﾞﾏﾑﾗ","ｼｷﾈｼﾞﾏ","東京都","新島村","式根島",0,0,0,0,0,0},
    q{13381,"10012","1001212","ﾄｳｷｮｳﾄ","ﾐﾔｹｼﾞﾏﾐﾔｹﾑﾗ","ｱｺ","東京都","三宅島三宅村","阿古",0,0,0,0,0,0},
    q{13421,"10021","1002101","ﾄｳｷｮｳﾄ","ｵｶﾞｻﾜﾗﾑﾗ","ﾁﾁｼﾞﾏ","東京都","小笠原村","父島",0,0,0,0,0,0},
;

run qw/ 北海道 ホッカイドウ 札幌市中央区 サッポロシチュウオウク undef undef 札幌市 サッポロシ 中央区 チュウオウク 大通西 オオドオリニシ /;
run qw/ 東京都 トウキョウト 西多摩郡檜原村 ニシタマグンヒノハラムラ 西多摩郡 ニシタマグン 檜原村 ヒノハラムラ undef undef 三都郷 ミツゴ /;
run qw/ 東京都 トウキョウト 西多摩郡奥多摩町 ニシタマグンオクタママチ 西多摩郡 ニシタマグン 奥多摩町 オクタママチ undef undef 海沢 ウナザワ /;
run qw/ 広島県 ヒロシマケン 広島市中区 ヒロシマシナカク undef undef 広島市 ヒロシマシ 中区 ナカク 榎町 エノマチ /;
run qw/ 福岡県 フクオカケン 北九州市門司区 キタキュウシュウシモジク undef undef 北九州市 キタキュウシュウシ 門司区 モジク 伊川 イカワ /;
run qw/ 群馬県 グンマケン 北群馬郡榛東村 キタグンマグンシントウムラ 北群馬郡 キタグンマグン 榛東村 シントウムラ undef undef 新井 アライ /;
run qw/ 東京都 トウキョウト 三鷹市 ミタカシ undef undef 三鷹市 ミタカシ undef undef 井口 イグチ /;
run qw/ 東京都 トウキョウト 渋谷区 シブヤク undef undef undef undef 渋谷区 シブヤク 恵比寿 エビス /;
run qw/ 東京都 トウキョウト 大島町 オオシママチ undef undef 大島町 オオシママチ undef undef 岡田 オカタ /;
run qw/ 東京都 トウキョウト 新島村 ニイジマムラ undef undef 新島村 ニイジマムラ undef undef 式根島 シキネジマ /;
run qw/ 東京都 トウキョウト 三宅島三宅村 ミヤケジマミヤケムラ undef undef 三宅島三宅村 ミヤケジマミヤケムラ undef undef 阿古 アコ /;
run qw/ 東京都 トウキョウト 小笠原村 オガサワラムラ undef undef 小笠原村 オガサワラムラ undef undef 父島 チチジマ /;

sub run {
    my @args = map { $_ eq 'undef' ? undef : $_ } @_;
    my $row = $parser->fetch_obj;
    is($row->pref, shift @args);
    is($row->pref_kana, shift @args);
    is($row->region, shift @args);
    is($row->region_kana, shift @args);
    is($row->district, shift @args);
    is($row->district_kana, shift @args);
    is($row->city, shift @args);
    is($row->city_kana, shift @args);
    is($row->ward, shift @args);
    is($row->ward_kana, shift @args);
    is($row->town, shift @args);
    is($row->town_kana, shift @args);
};

done_testing;
