# Generated by default/object.tt
package Paws::Macie2::ListJobsFilterTerm;
  use Moose;
  has Comparator => (is => 'ro', isa => 'Str', request_name => 'comparator', traits => ['NameInRequest']);
  has Key => (is => 'ro', isa => 'Str', request_name => 'key', traits => ['NameInRequest']);
  has Values => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'values', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::ListJobsFilterTerm

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::ListJobsFilterTerm object:

  $service_obj->Method(Att1 => { Comparator => $value, ..., Values => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::ListJobsFilterTerm object:

  $result = $service_obj->Method(...);
  $result->Att1->Comparator

=head1 DESCRIPTION

Specifies a condition that filters the results of a request for
information about classification jobs. Each condition consists of a
property, an operator, and one or more values.

=head1 ATTRIBUTES


=head2 Comparator => Str

The operator to use to filter the results.


=head2 Key => Str

The property to use to filter the results.


=head2 Values => ArrayRef[Str|Undef]

An array that lists one or more values to use to filter the results.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

