#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More;

plan skip_all => "Disabled" if $ENV{NO_JIRA_CHECK};

my @commits = split /\n/, <<'EOC';
d4e8ff74 PERL-666 Remove Path::Tiny and Config::AutoConf from config prereqs
fdf86ad5 PERL-778 Only send compression negotiation during handshake
e77dccc1 PERL-899 fix typos
7aa8de09 PERL-899 describe APM redaction rules
2c2f4c13 PERL-899 Add more notes about upgrading
b7d20d18 PERL-926 Fix bar count_documents in a test file
9879c05d PERL-901 run tests under various ENV var combos
751e02eb PERL-932 Bump BSON::XS prereq to v0.4.2
8c0cb9bf PERL-934 Bump Authen::SCRAM prereq
b3e63b6a PERL-933 Skip maxScan tests is server is 4.1+
48f24fb2 PERL-926 New count_documents requires a filter
db887225 PERL-924 Standalones don't support sessions
536e9205 PERL-640 Fix bug getting command name from BSON::Doc
d84d9c6a PERL-640 Allow BSON::Doc as ordered document
db98162e PERL-778 Implement OP_COMPRESSED op code handling
a5052a31 PERL-871 Remove use of MongoDB::GridFS in MongoDB::Database
d8711179 PERL-924 Fix session support detection for direct
4e26111a PERL-926 Document deprecated 'count' in Upgrading POD
5711d121 PERL-871 Document config globals removed
bf7727ad PERL-871 Remove deprecation documentation
8c891812 PERL-640 Add deprecation warnings to MongoDB BSON wrappers
ffb5fa32 PERL-871 Remove legacy get_gridfs
99e2c61b PERL-871 Remove force_int and force_double
dbad4667 PERL-871 Remove deprecated configuration options
3279b662 PERL-899 Partial draft of new Upgrading.pod
d4c4a4e2 PERL-840 Update CRUD spec tests for insertMany
65b3170f PERL-926 Add new count APIs; deprecate legacy count
5a1b4712 PERL-871 Remove deprecated MongoDB::GridFS
13b27a86 PERL-871 Remove methods deprecated in v1.0.0
b0ece524 PERL-872 Deprecate maxScan option
82a77c38 PERL-856 Document removal of MONGODB-CR
661d99e4 PERL-925 Fix failing t/sessions-end.t
7a30623c minor: Updated PERL-790 test from old BSONDebug role to new command monitoring
525f7921 PERL-924 Fix topology type detection regression
bb97d4ba PERL-834 Fix evergreen config name
2db3df50 PERL-834 Automate Atlas testing
a05e1ec9 PERL-919 Fix user/pass percent encoding validation
880e42f6 PERL-640: Remove more legacy type wrappers from test files
7dcb4e68 PERL-900 Conditionally require XS dependencies
42568ac9 PERL-666 Eliminate Module::Install in Makefile.PL
10002397 PERL-900 Vendor ExtUtils::HasCompiler
03251e3a PERL-917 Fix little spelling error
1cbd69f4 PERL-916 refactor failpoint test guards
4a1dc61f PERL-903 Revise MongoDB::DataTypes docs
82b56c59 PERL-903 Update MongoDB::Tutorial
78f2cc3b PERL-640 Remove more uses of MongoDB::Timestamp
09692445 PERL-640 Remove more uses of MongoDB::OID
28a1ef4b PERL-640 Stop loading MongoDB from MongoDB::MongoClient
4d9d3fb5 PERL-640 Remove more uses of MongoDB::DBRef
20cce50d PERL-640 Remove more uses of MongoDB::BSON::Regexp
5d37ba8c PERL-640 Remove more uses of MongoDB::BSON::Binary
a20f44bd PERL-903 Amend BSON references in GridFS docs
b9edfb14 PERL-765 Remove DateTime from driver
df34f5e0 PERL-907 Test with BSON Codec using full wrapping
dc0f3b98 PERL-765 Remove DateTime from GridFS
32a8a832 PERL-640 Remove MongoDB::BSON
ce0746c8 PERL-883 ignore codeName field in command monitoring
413ac04f PERL-907 Don't use client bson_codec for ismaster
030a0484 PERL-641 Make legacy typewrappers into subclasses
651b1f61 PERL-907 Allow BSON::String in QueryResult _fullname
80d7ca44 PERL-790 parallel_scan not supported with sessions
0cb7dd50 PERL-899 Create stub doc for v2 upgrading notes
7f8a7c65 PERL-905 Relax Bool type constraint
ba660615 PERL-792 Implement Retryable Writes
9293014c PERL-793 Causally Consistency read support
5df8498e PERL-895 Replace wire version checks with feature methods
73f2cd0c PERL-640 Use external BSON library as default codec
ed9378e2 PERL-718 Add support for deprecated 'modifiers' fields
4bee7ab5 PERL-884 Update SCRAM-SHA-256 implementation
53ede8cf PERL-883 expand cmd not found regex
cbc458ba PERL-833 Implement legacy killCursors command monitoring
60207e14 PERL-782 Add maxTimeMS option to Indexview methods
2f883848 PERL-883 rethrow exceptions even without a monitor callback
a52ef913 PERL-883 Implement command monitoring
d92b9e5c PERL-891 Test and fix for bulk_write passing write concern
094fefd7 PERL-891 Test and fix for query limit propagating
9770c7cf PERL-891 Test and fix for 'num' field of cursor
3e2b76f7 PERL-887 Fix topology_status with refresh
6452ccf7 PERL-807 Fix mongodb+srv parsing with auth
cdf16bc1 PERL-809 Added t/examples/changestream.t
cf19d129 PERL-790 remove session support from parallel_scan
220f7992 PERL-790 Revise session object design
a065ceea PERL-790 Fix changestreams broken by sessions merge
13267749 PERL-790 Implement Drivers Sessions API
858fb3b7 PERL-866 Document how to use the latest TLS protocols
f7b8339e PERL-791 Change stream support
9dbf08ce PERL-876 Use only a single host type per variant in Evergreen
a2c7f51d PERL-873 Deprecate snapshot option
0ce5f695 PERL-877 Bump Authen::SCRAM prereq to 0.009 for Unicode encoding bug
08c6ea99 PERL-869 Fix repeated credential validation
07589f61 PERL-863 Fix default auth sourch for SCRAM-SHA-256
867e6099 PERL-864 Improve auth error messages
c1117e53 PERL-863 Implement SCRAM-SHA-256 authentication
3286661b PERL-865 Fix wide character error in auth
9774edee PERL-668 Update SDAM spec tests
0c52b886 PERL-799 parse LogicalSessionTimeoutMinutes
839fe326 PERL-787 Implement arrayFilters support
4dd25550 PERL-847 Remove unused call_pv_va XS function
8e45d5ab PERL-783 Check username/password are URI-escaped
92bbb966 PERL-781 Prevent index drop errors for no collection
32e90bc6 PERL-807 Implement DNS Seedlist Discovery
5ecda87c PERL-724 CI: Update Perl paths for driver testing
22b18427 PERL-801 Fix Kerberos authentication
cd12200a PERL-801 Make kerberos test configurable from env vars
6e347b3f PERL-724: Restore Perl 5.20.3 to the list of Unix perls
bcc7b93a PERL-724 CI: update dependency builds to new Perl paths
7415ceef PERL-843 Bump IO::Socket::IP prereq to 0.32
e477f530 PERL-805 Implement database enumeration spec
c43e3672 PERL-768 Added support for aggregation hints
84d82fd9 PERL-808 Skip tests with profiler on mongos
7256c1fd PERL-808 Refactored aggregation comment test into seperate test file
5ecb352d PERL-808 Added test which shows comments appearing from aggregate commands
82770c19 PERL-769 Prevent short reads from throwing a protocol error
14fed978 PERL-800 CI: Stop testing 2.4 on Evergreen
0f5edc62 PERL-816 update error message for incompatible MongoDB versions
50819952 PERL-831 Skip threaded cursor test on Windows with SASL
31f9f97e PERL-892 CI: disable long-double testing on z-series
1f46f7c5 PERL-827 Fix auto-reconnect devel test
92d27453 PERL-827 Fix fsync unlock devel test
77882316 PERL-827 Fix deprecated methods in devel tests
b3f31b55 PERL-826 Stop sending maxAwaitTimeMS if not set
dcfdcb66 PERL-824 Fix insert_many exception for unack'd writes
5f70c99f PERL-818 CI: Add MongoDB 3.6 to Evergreen matrix
a78e4040 PERL-724 CI: update perl toolchain
520c43e2 PERL-772 CI: Add Perl 5.26.1 to toolchain
8364c57d PERL-724 CI: Add Perls 5.22.4 and 5.24.3 to toolchain
5f9b8184 PERL-767 Cache SCRAM-SHA-1 client key
88ca80d8 PERL-812 Fix typos in README and GSSAPI section
4205ba9f PERL-797 Update Tutorial.pod to fix typos
162926ab PERL-794 Improve resolution of GridFS uploadDate
53fd047b PERL-768 Document GridFS uniqueness constraints
c8f314ec PERL-788 Amend MongoDB::Cursor docs further
835cdf79 PERL-788 Fixg MongoDB::Cursor hint() documentation
3058e40d PERL-719 Resync CRUD spec tests
b14be5e4 PERL-733 Require ordered document for run_command
93cef900 PERL-742 Require Perl 5.10.1 or later
a185da01 PERL-764: ARM and Power8 require -lpthreads
32fea611 PERL-756 Use killCursors command for MongoDB 3.2+
a2ac9345 PERL-750 Create tested examples for the docs site
e3796f4d PERL-762 Makefile.PL fails with no '.' in @INC
478f77a3 PERL-759 CI: fix tests for Atlas proxy
1f89f4e8 PERL-757 CI: test against Atlas Free Tier proxy
33187ec1 PERL-758 Switch to binary type SASL payloads
57887b06 PERL-725 CI: Document Evergreen config and scripts
33832c21 PERL-679 PERL-708 Username no longer required for X509
585fddb3 PERL-729 CI: Add Z, ARM, Power variants
09801c54 PERL-729: CI: test with repo-specific prereq library
3000b6a4 PERL-748 CI: fix SSL orchestration on Windows
3bf06890 PERL-715 Force localhost to connect via IPv4
7a004080 PERL-729 CI: Clean up .cpanm during builds
12734523 PERL-729 CI: split dependency tarballs by repo
2fd5223d PERL-729 CI: Build perl dependencies for ZAP platforms
eb3512f3 PERL-729 CI: fix variant name for SUSE 12 on Z
45c8718c PERL-729 CI: Switch zseries builds to SUSE 12
1a6f2675 PERL-729 CI: Limit perls to 5.14+ for ZAP
38028493 PERL-729 CI: Build Perls for Z, ARM, and Power
9e63dfbc PERL-727 Fix GridFS tests on Windows
af2ec62e PERL-702 CI: Fix orchestration on Windows
60b4c04d PERL-726 Update deprecated 'last_error' test
79bb1f0d PERL-701 CI: Switch testing to RHEL6.2
6be420d6 PERL-701 CI: Build rhel62 dependency artifacts
906872ba PERL-700 CI: Perl uses eq for string equality
e3cfe2d1 PERL-700 CI: check contents of SSL env var, not existence
8773a9a4 PERL-700 CI: Pass in SSL attributes when needed
e4f66d3f PERL-700 Fix app_name test for multi-shard topologies
170fe9e1 PERL-700 Skip direct connect test if auth needed
2828295a PERL-700 CI: Add orchestrated tests for Ubuntu
e228d10e PERL-695 CI: save build logs to S3
a4ad1e48 PERL-696 Fix permissions for Strawberry Perls
eeb659f4 PERL-723 CI: Fix Strawberry Perl downloader
89401e78 PERL-698 CI Toolchain - refactor and revise scripts/config
cb78c0bd PERL-696 CI toolchain - fix portable.perl for old Strawberries
b943642c PERL-698 PERL-700 CI Toolchain - refactor configs
666c9b41 PERL-698 PERL-701 CI toolchain - build deps for Windows and rhel62
24e6cee5 PERL-701 CI toolchain - Build rhel62 perls
9b8f4591 PERL-699 CI testing - disable Perl 5.8 testing
9261625d PERL-699 CI testing - add no orchestration unit test
088b7b4d PERL-697 CI toolchain - Test dependencies
c5c14cdf PERL-697 CI toolchain - fix dependency script for 5.8
3ec1762a PERL-697 CI toolchain - build Unix dependencies
e1c85a8b PERL-696 CI toolchain - Assemble perls for Windows
05c7b784 PERL-710 Support authSource URI option
228fa853 PERL-690 Fix undefined reference to strerror_r on Windows
9f7bd53d PERL-695 CI toolchain - Build perls for Ubuntu
04bb7829 PERL-671 Make CRUD tests more robust
8f32a22d PERL-671 Skip some CRUD tests based on minServerVersion
37fd0c54 PERL-671 Update CRUD spec test data files

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my $changelog = do { local $/; <$fh> };

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}

done_testing();
