use Test::More;
use lib '.';
use Progressive::Web::Application;
my $manifest = Progressive::Web::Application->manifest_schema();

subtest name => sub {
	plan tests => 3;
	is($manifest->{name}->('test okay', 'test okay'), 'test okay', 'name true');
	is(eval{$manifest->{name}->({okay => 'no'}, 'custom')}, undef, 'name errors');
	like($@, qr/Value is not a scalar for field custom/, 'Value is not a scalar for field custom');
};

subtest short_name => sub {
	plan tests => 3;
	is($manifest->{short_name}->('test okay', 'test okay'), 'test okay', 'name true');
	is(eval{$manifest->{short_name}->({okay => 'no'}, 'custom')}, undef, 'name errors');
	like($@, qr/Value is not a scalar for field custom/, 'Value is not a scalar for field custom');
};

subtest start_url => sub {
	plan tests => 3;
	is($manifest->{start_url}->('/okay/path', 'test okay'), '/okay/path', 'start_url true');
	is(eval{$manifest->{start_url}->({okay => 'no'}, 'custom')}, undef, 'name errors');
	like($@, qr/Value is not a scalar for field custom/, 'Value is not a scalar for field custom');
};

subtest icons => sub {
	plan tests => 3;
	my $icons = $manifest->{icons}->('t/resources');
	my @expected = (
		{
			sizes => '36x36',
			src => '/t/resources/36x36-icon.png',
			type => 'image/png'
		},
		{
			sizes => '310x310',
			src => '/t/resources/320x320-icon.png',
			type => 'image/png'
		}
	);

	is_deeply($icons, \@expected, 'icons string (directory) true');

	my $new = {
		sizes => '128x128',
		src => 't/unkown_path/128x128-icon.png',
		type => 'image/png'
	};
	$icons = $manifest->{icons}->([ 't/resources', $new ]);
	is_deeply($icons, [@expected, $new], 'icons array (directory, hash) true');


	my $code = sub {
		my $ex =  {
			sizes => '152x152',
			src => '/t/unkown_path/152x152-icon.png',
			type => 'image/png'
		};
		push @expected, $ex;
		return $ex;
	};
	$icons = $manifest->{icons}->([ 't/resources', $code, $new ]);
	is_deeply($icons, [@expected, $new], 'icons array (directory, code, hash) true');
		
};

subtest display => sub {
	plan tests => 5;
	is($manifest->{display}->('standalone', 'standalone'), 'standalone', 'display true');
	is(eval{$manifest->{display}->({okay => 'no'})}, undef, 'display errors');
	like($@, qr/Value is not a scalar for field display/, 'Value is not a scalar for field display');
	is(eval{$manifest->{display}->('okay-no', 'custom')}, undef, 'display errors');
	like($@, qr/Invalid display value passed okay-no must be one of standalone, minimal-ui, fullscreen or browser/, 'Invalid display value passed okay-no must be one of standalone, minimal-ui, fullscreen or browser');
};

subtest background_color => sub {
	plan tests => 3;
	is($manifest->{background_color}->('#DADADA', 'background_colour'), '#dadada', 'background_colour true');
	is(eval{ $manifest->{background_color}->('abcdefhji', 'background_colour') }, undef, 'background_colour error');
	like($@, qr/Cannot convert the colour format/, 'Cannot convert the colour format');
};

subtest theme_color => sub {
	plan tests => 3;
	is($manifest->{theme_color}->('#DADADA', 'theme_color'), '#dadada', 'theme_color true');
	is(eval{ $manifest->{theme_color}->('abcdefhji', 'theme_color') }, undef, 'theme_color error');
	like($@, qr/Cannot convert the colour format/, 'Cannot convert the colour format');
};

done_testing();
