/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.scanner.accuracy;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sourceforge.javaocr.scanner.accuracy.OCRComp;

public class OCRIdentification {
    private OCRComp ocrType;
    private ArrayList<Character> chars = new ArrayList();
    private ArrayList<Double> identErrors = new ArrayList();
    private static final Logger LOG = Logger.getLogger(OCRIdentification.class.getName());

    public OCRIdentification(OCRComp ocrType) {
        this.ocrType = ocrType;
    }

    public void addChar(char newChar, double identError) {
        this.chars.add(Character.valueOf(newChar));
        this.identErrors.add(identError);
    }

    public int getNumChars() {
        return this.chars.size();
    }

    public char getCharIdx(int idx) {
        return this.chars.get(idx).charValue();
    }

    public double getIdentErrorIdx(int idx) {
        return this.identErrors.get(idx);
    }

    public OCRComp getOCRType() {
        return this.ocrType;
    }

    public String toString() {
        String retStr = "----- OCRIdentification  -----\n";
        retStr = retStr + "OCR Type: " + (Object)((Object)this.ocrType) + "\n";
        for (int i = 0; i < this.chars.size(); ++i) {
            retStr = retStr + "Char: " + this.chars.get(i) + " " + this.identErrors.get(i) + "\n";
        }
        return retStr;
    }
}

