/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.gui.handwritingRecognizer;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.sourceforge.javaocr.gui.GUIController;

public class TrainingPanel
extends JPanel {
    public static final long serialVersionUID = 0L;
    private final GUIController guiController;
    private JTextField trainingImgLoc;
    private JCheckBox zeroToNineCheckbox;
    private JCheckBox lowCaseAtoZCheckbox;
    private JCheckBox upCaseAtoZCheckbox;
    private static final Logger LOG = Logger.getLogger(TrainingPanel.class.getName());

    public TrainingPanel(GUIController guiController) {
        this.guiController = guiController;
        this.trainingImgLoc = new JTextField(40);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getTrainingImageLoc(this.trainingImgLoc));
        this.add(this.getTrainingImageOptions());
    }

    public File getTrainingImgFile() {
        return new File(this.trainingImgLoc.getText());
    }

    public boolean isLearnLowerCaseAtoZ() {
        return this.lowCaseAtoZCheckbox.isSelected();
    }

    public boolean isLearnUpCaseAtoZ() {
        return this.upCaseAtoZCheckbox.isSelected();
    }

    public boolean isLearnZeroToNine() {
        return this.zeroToNineCheckbox.isSelected();
    }

    private JPanel getTrainingImageOptions() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(new TitledBorder("Training Options"));
        JTextArea helpLabel = new JTextArea("Each line of the training image should be ordered as the selected checkboxes.\nEx. Selecting 0-9 would mean the training image first line contains characters\n0 to 9.");
        helpLabel.setBackground(this.getBackground());
        helpLabel.setEditable(false);
        panel.add(helpLabel);
        panel.add(this.getCheckboxPanel());
        return panel;
    }

    private JPanel getCheckboxPanel() {
        int rows = 4;
        int cols = 2;
        JPanel panel = new JPanel(new GridLayout(rows, cols));
        this.zeroToNineCheckbox = new JCheckBox("Learn Line of Characters 0-9");
        panel.add(this.zeroToNineCheckbox);
        this.lowCaseAtoZCheckbox = new JCheckBox("Learn Line of Characters a-z");
        panel.add(this.lowCaseAtoZCheckbox);
        this.upCaseAtoZCheckbox = new JCheckBox("Learn Line of Characters A-Z");
        panel.add(this.upCaseAtoZCheckbox);
        return panel;
    }

    private JPanel getTrainingImageLoc(JTextField trainingImgLoc) {
        JPanel targPanel = new JPanel();
        targPanel.setBorder(new TitledBorder("Select Training Image"));
        targPanel.setLayout(new FlowLayout(0));
        JLabel label = new JLabel("Location: ");
        targPanel.add(label);
        targPanel.add(trainingImgLoc);
        JButton button = new JButton("Select");
        button.addActionListener(this.getSelectTrainingImgBtnAction());
        targPanel.add(button);
        return targPanel;
    }

    private ActionListener getSelectTrainingImgBtnAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    TrainingPanel.this.trainingImgLoc.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
    }
}

