/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.measurement;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.measurement.PDMeasureDictionary;
import org.apache.pdfbox.pdmodel.interactive.measurement.PDNumberFormatDictionary;

public class PDRectlinearMeasureDictionary
extends PDMeasureDictionary {
    public static final String SUBTYPE = "RL";

    public PDRectlinearMeasureDictionary() {
        this.setSubtype(SUBTYPE);
    }

    public PDRectlinearMeasureDictionary(COSDictionary dictionary) {
        super(dictionary);
    }

    public String getScaleRatio() {
        return this.getDictionary().getString(COSName.R);
    }

    public void setScaleRatio(String scaleRatio) {
        this.getDictionary().setString(COSName.R, scaleRatio);
    }

    public PDNumberFormatDictionary[] getChangeXs() {
        COSArray x = (COSArray)this.getDictionary().getDictionaryObject("X");
        if (x != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[x.size()];
            for (int i = 0; i < x.size(); ++i) {
                COSDictionary dic = (COSDictionary)x.get(i);
                retval[i] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setChangeXs(PDNumberFormatDictionary[] changeXs) {
        COSArray array = new COSArray();
        for (int i = 0; i < changeXs.length; ++i) {
            array.add(changeXs[i]);
        }
        this.getDictionary().setItem("X", (COSBase)array);
    }

    public PDNumberFormatDictionary[] getChangeYs() {
        COSArray y = (COSArray)this.getDictionary().getDictionaryObject("Y");
        if (y != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[y.size()];
            for (int i = 0; i < y.size(); ++i) {
                COSDictionary dic = (COSDictionary)y.get(i);
                retval[i] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setChangeYs(PDNumberFormatDictionary[] changeYs) {
        COSArray array = new COSArray();
        for (int i = 0; i < changeYs.length; ++i) {
            array.add(changeYs[i]);
        }
        this.getDictionary().setItem("Y", (COSBase)array);
    }

    public PDNumberFormatDictionary[] getDistances() {
        COSArray d = (COSArray)this.getDictionary().getDictionaryObject("D");
        if (d != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[d.size()];
            for (int i = 0; i < d.size(); ++i) {
                COSDictionary dic = (COSDictionary)d.get(i);
                retval[i] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setDistances(PDNumberFormatDictionary[] distances) {
        COSArray array = new COSArray();
        for (int i = 0; i < distances.length; ++i) {
            array.add(distances[i]);
        }
        this.getDictionary().setItem("D", (COSBase)array);
    }

    public PDNumberFormatDictionary[] getAreas() {
        COSArray a = (COSArray)this.getDictionary().getDictionaryObject(COSName.A);
        if (a != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[a.size()];
            for (int i = 0; i < a.size(); ++i) {
                COSDictionary dic = (COSDictionary)a.get(i);
                retval[i] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setAreas(PDNumberFormatDictionary[] areas) {
        COSArray array = new COSArray();
        for (int i = 0; i < areas.length; ++i) {
            array.add(areas[i]);
        }
        this.getDictionary().setItem(COSName.A, (COSBase)array);
    }

    public PDNumberFormatDictionary[] getAngles() {
        COSArray t = (COSArray)this.getDictionary().getDictionaryObject("T");
        if (t != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[t.size()];
            for (int i = 0; i < t.size(); ++i) {
                COSDictionary dic = (COSDictionary)t.get(i);
                retval[i] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setAngles(PDNumberFormatDictionary[] angles) {
        COSArray array = new COSArray();
        for (int i = 0; i < angles.length; ++i) {
            array.add(angles[i]);
        }
        this.getDictionary().setItem("T", (COSBase)array);
    }

    public PDNumberFormatDictionary[] getLineSloaps() {
        COSArray s = (COSArray)this.getDictionary().getDictionaryObject("S");
        if (s != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[s.size()];
            for (int i = 0; i < s.size(); ++i) {
                COSDictionary dic = (COSDictionary)s.get(i);
                retval[i] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setLineSloaps(PDNumberFormatDictionary[] lineSloaps) {
        COSArray array = new COSArray();
        for (int i = 0; i < lineSloaps.length; ++i) {
            array.add(lineSloaps[i]);
        }
        this.getDictionary().setItem("S", (COSBase)array);
    }

    public float[] getCoordSystemOrigin() {
        COSArray o = (COSArray)this.getDictionary().getDictionaryObject("O");
        if (o != null) {
            return o.toFloatArray();
        }
        return null;
    }

    public void setCoordSystemOrigin(float[] coordSystemOrigin) {
        COSArray array = new COSArray();
        array.setFloatArray(coordSystemOrigin);
        this.getDictionary().setItem("O", (COSBase)array);
    }

    public float getCYX() {
        return this.getDictionary().getFloat("CYX");
    }

    public void setCYX(float cyx) {
        this.getDictionary().setFloat("CYX", cyx);
    }
}

