/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceNAttributes;

public class PDDeviceN
extends PDColorSpace {
    public static final String NAME = "DeviceN";
    private COSArray array;

    public PDDeviceN() {
        this.array = new COSArray();
        this.array.add(COSName.getPDFName(NAME));
        this.array.add(COSName.getPDFName(""));
    }

    public PDDeviceN(COSArray separation) {
        this.array = separation;
    }

    public String getName() {
        return NAME;
    }

    public int getNumberOfComponents() throws IOException {
        return this.getColorantNames().size();
    }

    protected ColorSpace createColorSpace() throws IOException {
        throw new IOException("Not implemented");
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        throw new IOException("Not implemented");
    }

    public List getColorantNames() {
        COSArray names = (COSArray)this.array.getObject(1);
        return COSArrayList.convertCOSNameCOSArrayToList(names);
    }

    public void setColorantNames(List names) {
        COSArray namesArray = COSArrayList.convertStringListToCOSNameCOSArray(names);
        this.array.set(1, namesArray);
    }

    public PDColorSpace getAlternateColorSpace() throws IOException {
        COSBase alternate = this.array.getObject(2);
        return PDColorSpaceFactory.createColorSpace(alternate);
    }

    public void setAlternateColorSpace(PDColorSpace cs) {
        COSBase space = null;
        if (cs != null) {
            space = cs.getCOSObject();
        }
        this.array.set(2, space);
    }

    public PDFunction getTintTransform() throws IOException {
        return PDFunction.create(this.array.getObject(3));
    }

    public void setTintTransform(PDFunction tint) {
        this.array.set(3, tint);
    }

    public PDDeviceNAttributes getAttributes() {
        PDDeviceNAttributes retval = null;
        if (this.array.size() < 5) {
            retval = new PDDeviceNAttributes();
            this.setAttributes(retval);
        }
        return retval;
    }

    public void setAttributes(PDDeviceNAttributes attributes) {
        if (attributes == null) {
            this.array.remove(4);
        } else {
            while (this.array.size() < 5) {
                this.array.add(COSNull.NULL);
            }
            this.array.set(4, attributes.getCOSDictionary());
        }
    }
}

