/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.util.ImageParameters;
import org.apache.pdfbox.util.PDFOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFStreamParser
extends BaseParser {
    private List<Object> streamObjects = new ArrayList<Object>(100);
    private RandomAccess file;
    private PDFOperator lastBIToken = null;

    public PDFStreamParser(InputStream stream, RandomAccess raf) throws IOException {
        super(stream);
        this.file = raf;
    }

    public PDFStreamParser(PDStream stream) throws IOException {
        this(stream.createInputStream(), stream.getStream().getScratchFile());
    }

    public PDFStreamParser(COSStream stream) throws IOException {
        this(stream.getUnfilteredStream(), stream.getScratchFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        try {
            Object token = null;
            while ((token = this.parseNextToken()) != null) {
                this.streamObjects.add(token);
            }
        }
        finally {
            this.pdfSource.close();
        }
    }

    public List<Object> getTokens() {
        return this.streamObjects;
    }

    private Object parseNextToken() throws IOException {
        Object retval = null;
        this.skipSpaces();
        int nextByte = this.pdfSource.peek();
        if ((byte)nextByte == -1) {
            return null;
        }
        char c = (char)nextByte;
        switch (c) {
            case '<': {
                int leftBracket = this.pdfSource.read();
                c = (char)this.pdfSource.peek();
                this.pdfSource.unread(leftBracket);
                if (c == '<') {
                    COSDictionary pod = this.parseCOSDictionary();
                    this.skipSpaces();
                    if ((char)this.pdfSource.peek() == 's') {
                        retval = this.parseCOSStream(pod, this.file);
                        break;
                    }
                    retval = pod;
                    break;
                }
                retval = this.parseCOSString();
                break;
            }
            case '[': {
                retval = this.parseCOSArray();
                break;
            }
            case '(': {
                retval = this.parseCOSString();
                break;
            }
            case '/': {
                retval = this.parseCOSName();
                break;
            }
            case 'n': {
                String nullString = this.readString();
                if (nullString.equals("null")) {
                    retval = COSNull.NULL;
                    break;
                }
                retval = PDFOperator.getOperator(nullString);
                break;
            }
            case 'f': 
            case 't': {
                String next = this.readString();
                if (next.equals("true")) {
                    retval = COSBoolean.TRUE;
                    break;
                }
                if (next.equals("false")) {
                    retval = COSBoolean.FALSE;
                    break;
                }
                retval = PDFOperator.getOperator(next);
                break;
            }
            case 'R': {
                String line = this.readString();
                if (line.equals("R")) {
                    retval = new COSObject(null);
                    break;
                }
                retval = PDFOperator.getOperator(line);
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                boolean dotNotRead;
                StringBuffer buf = new StringBuffer();
                buf.append(c);
                this.pdfSource.read();
                boolean bl = dotNotRead = c != '.';
                while (Character.isDigit(c = (char)this.pdfSource.peek()) || dotNotRead && c == '.') {
                    buf.append(c);
                    this.pdfSource.read();
                    if (!dotNotRead || c != '.') continue;
                    dotNotRead = false;
                }
                retval = COSNumber.get(buf.toString());
                break;
            }
            case 'B': {
                String next = this.readString();
                retval = PDFOperator.getOperator(next);
                if (!next.equals("BI")) break;
                this.lastBIToken = (PDFOperator)retval;
                COSDictionary imageParams = new COSDictionary();
                this.lastBIToken.setImageParameters(new ImageParameters(imageParams));
                Object nextToken = null;
                while ((nextToken = this.parseNextToken()) instanceof COSName) {
                    Object value = this.parseNextToken();
                    imageParams.setItem((COSName)nextToken, (COSBase)value);
                }
                PDFOperator imageData = (PDFOperator)nextToken;
                this.lastBIToken.setImageData(imageData.getImageData());
                break;
            }
            case 'I': {
                String id = "" + (char)this.pdfSource.read() + (char)this.pdfSource.read();
                if (!id.equals("ID")) {
                    throw new IOException("Error: Expected operator 'ID' actual='" + id + "'");
                }
                ByteArrayOutputStream imageData = new ByteArrayOutputStream();
                if (this.isWhitespace()) {
                    this.pdfSource.read();
                }
                int twoBytesAgo = 0;
                int lastByte = this.pdfSource.read();
                int currentByte = this.pdfSource.read();
                int count = 0;
                while (!(this.isWhitespace(twoBytesAgo) && lastByte == 69 && currentByte == 73 && this.isWhitespace() || this.pdfSource.isEOF())) {
                    imageData.write(lastByte);
                    twoBytesAgo = lastByte;
                    lastByte = currentByte;
                    currentByte = this.pdfSource.read();
                    ++count;
                }
                this.pdfSource.unread(73);
                this.pdfSource.unread(69);
                retval = PDFOperator.getOperator("ID");
                ((PDFOperator)retval).setImageData(imageData.toByteArray());
                break;
            }
            case ']': {
                this.pdfSource.read();
                retval = COSNull.NULL;
                break;
            }
            default: {
                String operator = this.readOperator();
                retval = operator.trim().length() == 0 ? null : PDFOperator.getOperator(operator);
            }
        }
        return retval;
    }

    protected String readOperator() throws IOException {
        this.skipSpaces();
        StringBuffer buffer = new StringBuffer(4);
        while (!(this.isWhitespace() || this.isClosing() || this.pdfSource.isEOF() || this.pdfSource.peek() == 91 || this.pdfSource.peek() == 60 || this.pdfSource.peek() == 40 || this.pdfSource.peek() == 47 || this.pdfSource.peek() >= 48 && this.pdfSource.peek() <= 57)) {
            buffer.append((char)this.pdfSource.read());
        }
        return buffer.toString();
    }
}

