/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationRubberStamp;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.util.MapUtil;

public class RubberStampWithImage {
    private static final String SAVE_GRAPHICS_STATE = "q\n";
    private static final String RESTORE_GRAPHICS_STATE = "Q\n";
    private static final String CONCATENATE_MATRIX = "cm\n";
    private static final String XOBJECT_DO = "Do\n";
    private static final String SPACE = " ";
    private static NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String[] args) throws IOException {
        if (args.length != 3) {
            this.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load(args[0]);
                if (document.isEncrypted()) {
                    throw new IOException("Encrypted documents are not supported for this example");
                }
                ArrayList allpages = new ArrayList();
                document.getDocumentCatalog().getPages().getAllKids(allpages);
                int numberOfPages = allpages.size();
                for (int i = 0; i < numberOfPages; ++i) {
                    PDPage apage = (PDPage)allpages.get(i);
                    List annotations = apage.getAnnotations();
                    PDAnnotationRubberStamp rubberStamp = new PDAnnotationRubberStamp();
                    rubberStamp.setName("TopSecret");
                    rubberStamp.setRectangle(new PDRectangle(100.0f, 100.0f));
                    rubberStamp.setContents("A top secret note");
                    FileInputStream fin = new FileInputStream(args[2]);
                    PDJpeg mypic = new PDJpeg(document, fin);
                    PDRectangle myrect = new PDRectangle();
                    myrect.setUpperRightX(275.0f);
                    myrect.setUpperRightY(575.0f);
                    myrect.setLowerLeftX(250.0f);
                    myrect.setLowerLeftY(550.0f);
                    PDStream formstream = new PDStream(document);
                    OutputStream os = formstream.createOutputStream();
                    PDXObjectForm form = new PDXObjectForm(formstream);
                    form.setResources(new PDResources());
                    form.setBBox(myrect);
                    form.setFormType(1);
                    this.drawXObject(mypic, form.getResources(), os, 250.0f, 550.0f, 25.0f, 25.0f);
                    os.close();
                    PDAppearanceStream myDic = new PDAppearanceStream(form.getCOSStream());
                    PDAppearanceDictionary appearance = new PDAppearanceDictionary(new COSDictionary());
                    appearance.setNormalAppearance(myDic);
                    rubberStamp.setAppearance(appearance);
                    rubberStamp.setRectangle(myrect);
                    annotations.add(rubberStamp);
                }
                document.save(args[1]);
            }
            catch (COSVisitorException exception) {
                System.err.println("An error occured during saving the document.");
                System.err.println("Exception:" + exception);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private void drawXObject(PDXObjectImage xobject, PDResources resources, OutputStream os, float x, float y, float width, float height) throws IOException {
        String xObjectPrefix = "Im";
        String objMapping = MapUtil.getNextUniqueKey(resources.getImages(), xObjectPrefix);
        resources.getXObjects().put(objMapping, xobject);
        this.appendRawCommands(os, SAVE_GRAPHICS_STATE);
        this.appendRawCommands(os, formatDecimal.format(width));
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, formatDecimal.format(0L));
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, formatDecimal.format(0L));
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, formatDecimal.format(height));
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, formatDecimal.format(x));
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, formatDecimal.format(y));
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, CONCATENATE_MATRIX);
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, "/");
        this.appendRawCommands(os, objMapping);
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, XOBJECT_DO);
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, RESTORE_GRAPHICS_STATE);
    }

    private void appendRawCommands(OutputStream os, String commands) throws IOException {
        os.write(commands.getBytes("ISO-8859-1"));
    }

    public static void main(String[] args) throws Exception {
        RubberStampWithImage rubberStamp = new RubberStampWithImage();
        rubberStamp.doIt(args);
    }

    private void usage() {
        System.err.println("Usage: java " + this.getClass().getName() + " <input-pdf> <output-pdf> <jpeg-filename>");
    }
}

