/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import java.io.IOException;

public class TIFFPackBitsDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public int decode(byte[] srcData, int srcOffset, byte[] dstData, int dstOffset) throws IOException {
        int srcIndex = srcOffset;
        int dstIndex = dstOffset;
        int dstArraySize = dstData.length;
        int srcArraySize = srcData.length;
        try {
            block2: while (dstIndex < dstArraySize) {
                byte b;
                if (srcIndex >= srcArraySize) return dstIndex - dstOffset;
                if ((b = srcData[srcIndex++]) >= 0 && b <= 127) {
                    int i = 0;
                    while (true) {
                        if (i >= b + 1) continue block2;
                        dstData[dstIndex++] = srcData[srcIndex++];
                        ++i;
                    }
                }
                if (b <= -1 && b >= -127) {
                    byte repeat = srcData[srcIndex++];
                    int i = 0;
                    while (true) {
                        if (i >= -b + 1) continue block2;
                        dstData[dstIndex++] = repeat;
                        ++i;
                    }
                }
                ++srcIndex;
            }
            return dstIndex - dstOffset;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (!(this.reader instanceof TIFFImageReader)) return dstIndex - dstOffset;
            ((TIFFImageReader)this.reader).forwardWarningMessage("ArrayIndexOutOfBoundsException ignored in TIFFPackBitsDecompressor.decode()");
        }
        return dstIndex - dstOffset;
    }

    public void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        int bufOffset;
        byte[] buf;
        this.stream.seek(this.offset);
        byte[] srcData = new byte[this.byteCount];
        this.stream.readFully(srcData);
        int bytesPerRow = (this.srcWidth * bitsPerPixel + 7) / 8;
        if (bytesPerRow == scanlineStride) {
            buf = b;
            bufOffset = dstOffset;
        } else {
            buf = new byte[bytesPerRow * this.srcHeight];
            bufOffset = 0;
        }
        this.decode(srcData, 0, buf, bufOffset);
        if (bytesPerRow != scanlineStride) {
            int off = 0;
            for (int y = 0; y < this.srcHeight; ++y) {
                System.arraycopy(buf, off, b, dstOffset, bytesPerRow);
                off += bytesPerRow;
                dstOffset += scanlineStride;
            }
        }
    }
}

