/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.OutDataStreamFile;
import java.io.DataInputStream;
import java.util.HashMap;

class TagCount {
    private HashMap<String, Integer> map = new HashMap();
    private int ambClassId = -1;
    private String[] getTagsCache;
    private boolean dirty = true;
    private static final String NULL_SYMBOL = "<<NULL>>";

    TagCount() {
    }

    protected void save(OutDataStreamFile rf) {
        try {
            rf.writeInt(this.map.size());
            for (String tag : this.map.keySet()) {
                if (tag == null) {
                    rf.writeUTF(NULL_SYMBOL);
                } else {
                    rf.writeUTF(tag);
                }
                rf.writeInt(this.map.get(tag));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAmbClassId(int ambClassId) {
        this.ambClassId = ambClassId;
    }

    public int getAmbClassId() {
        return this.ambClassId;
    }

    protected void read(DataInputStream rf) {
        try {
            int numTags = rf.readInt();
            this.map = new HashMap(numTags);
            for (int i = 0; i < numTags; ++i) {
                String tag = rf.readUTF();
                int count = rf.readInt();
                if (tag.equals(NULL_SYMBOL)) {
                    tag = null;
                }
                this.map.put(tag, count);
            }
            this.dirty = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int sum() {
        int s = 0;
        for (Integer i : this.map.values()) {
            s += i.intValue();
        }
        return s;
    }

    protected void add(String tag) {
        int val;
        if (this.map.get(tag) != null) {
            val = this.map.get(tag);
        } else {
            val = 0;
            this.dirty = true;
        }
        this.map.put(tag, val + 1);
    }

    protected int get(String tag) {
        if (this.map.get(tag) != null) {
            return this.map.get(tag);
        }
        return 0;
    }

    public String[] getTags() {
        if (this.dirty) {
            this.getTagsCache = this.map.keySet().toArray(new String[this.map.keySet().size()]);
            this.dirty = false;
        }
        return this.getTagsCache;
    }

    protected int numTags() {
        return this.map.size();
    }

    public String getFirstTag() {
        String maxTag = null;
        int max = 0;
        for (String tag : this.map.keySet()) {
            int count = this.map.get(tag);
            if (count <= max) continue;
            maxTag = tag;
            max = count;
        }
        return maxTag;
    }

    public String toString() {
        return this.map.toString();
    }
}

