/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ling.Datum;
import java.io.Serializable;
import java.util.List;

public class CRFDatum<FEAT, LAB>
implements Serializable {
    private final List<FEAT> features;
    private final LAB label;
    private static final long serialVersionUID = -8345554365027671190L;

    public CRFDatum(List<FEAT> features, LAB label) {
        this.features = features;
        this.label = label;
    }

    public List<FEAT> asFeatures() {
        return this.features;
    }

    public LAB label() {
        return this.label;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CRFDatum[\n");
        sb.append("    label=").append(this.label).append('\n');
        int sz = this.features.size();
        for (int i = 0; i < sz; ++i) {
            sb.append("    features(").append(i).append("):").append(this.features.get(i)).append('\n');
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Datum)) {
            return false;
        }
        Datum d = (Datum)o;
        return ((Object)this.features).equals(d.asFeatures());
    }

    public int hashCode() {
        return ((Object)this.features).hashCode();
    }
}

