use strict;
use warnings;

use Test::More tests => 22;

BEGIN {#1
    use_ok( 'Graph::Dijkstra' ) || print "Bail out!\n";
}

{#tests 2-6

	my $graph = Graph::Dijsktra->new();
	ok(defined($graph), 'Dijkstra->new()');
	
	my $filename = 't/data/graphML2.xml';
	
	ok(-e $filename, "found $filename");
	
	ok($graph->inputGraphfromGraphML($filename),'$graph->inputGraphfromGraphML($filename)');
	
	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"\$graph->farthestNode('1', \\\%Solution)");
	
	my $pathCost = $graph->shortestPath('1', '5', \%Solution);
	
	ok( ($pathCost == 1.8 and $Solution{edges}->[0]->{target} eq '3'),"\$graph->shortestPath('1','5', \\\%Solution)");
}

{#tests 7-10

	my $graph = Graph::Dijsktra->new();
	
	my $filename = 't/data/graphML2.gml';
	
	ok(-e $filename, "found $filename");
	
	ok($graph->inputGraphfromGML($filename),'$graph->inputGraphfromGML($filename)');
	
	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"\$graph->farthestNode('1', \\\%Solution)");
	
	my $pathCost = $graph->shortestPath('1', '5', \%Solution);
	
	ok( ($pathCost == 1.8 and $Solution{edges}->[0]->{target} eq '3'),"\$graph->shortestPath('1','5', \\\%Solution)");

}


{#tests 11-14

	my $graph = Graph::Dijsktra->new();
	
	my $filename = 't/data/graphML2.json';
	
	ok(-e $filename, "found $filename");
	
	ok($graph->inputGraphfromJSON($filename),'$graph->inputGraphfromJSON($filename)');
	
	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"\$graph->farthestNode('1', \\\%Solution)");
	
	my $pathCost = $graph->shortestPath('1', '5', \%Solution);
	
	ok( ($pathCost == 1.8 and $Solution{edges}->[0]->{target} eq '3'),"\$graph->shortestPath('1','5', \\\%Solution)");

}


{#tests 15-18

	my $graph = Graph::Dijsktra->new();
	
	my $filename = 't/data/graphML2.csv';
	
	ok(-e $filename, "found $filename");
	
	ok($graph->inputGraphfromCSV($filename),'$graph->inputGraphfromCSV($filename)');
	
	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"\$graph->farthestNode('1', \\\%Solution)");
	
	my $pathCost = $graph->shortestPath('1', '5', \%Solution);
	
	ok( ($pathCost == 1.8 and $Solution{edges}->[0]->{target} eq '3'),"\$graph->shortestPath('1','5', \\\%Solution)");

}

{# 19-22
	my $graph = Graph::Dijsktra->new();
	
	my $filename = 't/data/graphML2.xml';
	$graph->inputGraphfromGraphML($filename);
	
	$filename = 't/data/graphML3.csv';
	$graph->outputGraphtoCSV($filename);
	ok(-e $filename, '$graph->outputGraphtoCSV($filename);');
	
	$filename = 't/data/graphML3.gml';
	$graph->outputGraphtoGML($filename, 'Test Test');
	ok(-e $filename, "\$graph->outputGraphtoGML(\$filename, 'Test Test');");
	
	$filename = 't/data/graphML3.json';
	$graph->outputGraphtoJSON($filename);
	ok(-e $filename, '$graph->outputGraphtoJSON($filename);');
	
	$filename = 't/data/graphML3.xml';
	$graph->outputGraphtoGraphML($filename, {});
	ok(-e $filename, '$graph->outputGraphtoGraphML($filename, {});');
	
	#clean-up
	unlink('t/data/graphML3.csv');
	unlink('t/data/graphML3.json');
	unlink('t/data/graphML3.gml');
	unlink('t/data/graphML3.xml');

}



exit(0);