### A matrix of matrixes, the main model (pixelized or sometimes modeled)
### in a matrix

use 'GFX-Tools-Buffer::matrix';

sub new {
  ### columns / rows
  my ($class, $breadth, $length) = @_;
  
  $self = { matrixes => GFX-Tools-Buffer::matrix->new($length, $breadth),
	  indexForAdding => 0, };
  
  bless $self, $class;
}

### add a matrix to the matrix bar
sub addMatrixSleeve {
  my ($self, $mat) = @_;
  
  if ($self->{indexForAdding} >= $self->{matrixes}->getRowsNumber) {

    print "Your matrix of matrixes is too small, the program might be corrupted";
    
    return -1;
  }

  $self->{matrixes}->setAtIndex(0, $self->{indexForAdding}++, $mat); ### FIXME

  return 0; ### plain C
  
}

1;
  
