/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyScoring {
    public final List<Set<TypedDependency>> goldDeps;
    public final List<Set<TypedDependency>> goldDepsUnlabeled;

    private static List<Set<TypedDependency>> toSets(Collection<TypedDependency> depCollection) {
        HashSet<TypedDependency> depSet = new HashSet<TypedDependency>(depCollection);
        HashSet<TypedDependencyStringEquality> unlabeledDepSet = new HashSet<TypedDependencyStringEquality>();
        for (TypedDependency dep : depCollection) {
            unlabeledDepSet.add(new TypedDependencyStringEquality(null, dep.gov(), dep.dep()));
        }
        ArrayList<Set<TypedDependency>> l = new ArrayList<Set<TypedDependency>>(2);
        l.add(depSet);
        l.add(unlabeledDepSet);
        return l;
    }

    public DependencyScoring(List<Collection<TypedDependency>> goldDeps) {
        this.goldDeps = new ArrayList<Set<TypedDependency>>(goldDeps.size());
        this.goldDepsUnlabeled = new ArrayList<Set<TypedDependency>>(goldDeps.size());
        for (Collection<TypedDependency> depCollection : goldDeps) {
            List<Set<TypedDependency>> sets = DependencyScoring.toSets(depCollection);
            this.goldDepsUnlabeled.add(sets.get(1));
            this.goldDeps.add(sets.get(0));
        }
    }

    public DependencyScoring(String filename) throws IOException {
        this(DependencyScoring.readDeps(filename));
    }

    protected static List<Collection<TypedDependency>> readDeps(String filename) throws IOException {
        BufferedReader breader = new BufferedReader(new FileReader(filename));
        ArrayList<Collection<TypedDependency>> readDeps = new ArrayList<Collection<TypedDependency>>();
        ArrayList<TypedDependencyStringEquality> deps = new ArrayList<TypedDependencyStringEquality>();
        String line = breader.readLine();
        while (line != null) {
            if (line.equals("")) {
                if (deps.size() != 0) {
                    readDeps.add(deps);
                    deps = new ArrayList();
                }
            } else {
                int firstParen = line.indexOf("(");
                int commaSpace = line.indexOf(", ");
                String depName = line.substring(0, firstParen);
                String govName = line.substring(firstParen + 1, commaSpace);
                String childName = line.substring(commaSpace + 2, line.length() - 1);
                GrammaticalRelation grel = EnglishGrammaticalRelations.valueOf(depName);
                if (depName.startsWith("prep_")) {
                    String prep = depName.substring(5);
                    grel = EnglishGrammaticalRelations.getPrep(prep);
                }
                if (depName.startsWith("prepc_")) {
                    String prepc = depName.substring(6);
                    grel = EnglishGrammaticalRelations.getPrepC(prepc);
                }
                if (depName.startsWith("conj_")) {
                    String conj = depName.substring(5);
                    grel = EnglishGrammaticalRelations.getConj(conj);
                }
                if (grel == null) {
                    throw new RuntimeException("Unknown grammatical relation '" + depName + "'");
                }
                int govDash = govName.lastIndexOf("-");
                int childDash = childName.lastIndexOf("-");
                Word govWord = new Word(govName);
                Word childWord = new Word(childName);
                TypedDependencyStringEquality dep = new TypedDependencyStringEquality(grel, new TreeGraphNode(govWord), new TreeGraphNode(childWord));
                deps.add(dep);
            }
            line = breader.readLine();
        }
        if (deps.size() != 0) {
            readDeps.add(deps);
        }
        return readDeps;
    }

    Score score(List<Collection<TypedDependency>> system) {
        int cnt = 0;
        int correctAttachment = 0;
        int correctUnlabeledAttachment = 0;
        int labelCnt = 0;
        int labelCorrect = 0;
        ClassicCounter<String> unlabeledErrorCounts = new ClassicCounter<String>();
        ClassicCounter<String> labeledErrorCounts = new ClassicCounter<String>();
        for (int i = 0; i < system.size(); ++i) {
            String sGov;
            String sChild;
            List<Set<TypedDependency>> l = DependencyScoring.toSets(system.get(i));
            cnt += l.get(0).size();
            l.get(0).retainAll((Collection)this.goldDeps.get(i));
            l.get(1).retainAll((Collection)this.goldDepsUnlabeled.get(i));
            correctAttachment += l.get(0).size();
            correctUnlabeledAttachment += l.get(1).size();
            labelCnt += l.get(1).size();
            labelCorrect += l.get(0).size();
            List<Set<TypedDependency>> errl = DependencyScoring.toSets(system.get(i));
            errl.get(0).removeAll((Collection)this.goldDeps.get(i));
            errl.get(1).removeAll((Collection)this.goldDepsUnlabeled.get(i));
            HashMap<String, String> childCorrectWithLabel = new HashMap<String, String>();
            HashMap<String, String> childCorrectWithOutLabel = new HashMap<String, String>();
            for (TypedDependency goldDep : this.goldDeps.get(i)) {
                sChild = goldDep.dep().label().toString().replaceFirst("-[^-]*$", "");
                String prefixLabeled = "";
                String prefixUnlabeled = "";
                if (childCorrectWithLabel.containsKey(sChild)) {
                    prefixLabeled = (String)childCorrectWithLabel.get(sChild) + ", ";
                    prefixUnlabeled = (String)childCorrectWithOutLabel.get(sChild) + ", ";
                }
                childCorrectWithLabel.put(sChild, prefixLabeled + goldDep.reln() + "(" + goldDep.gov().label().toString().replaceFirst("-[^-]*$", "") + ", " + sChild + ")");
                childCorrectWithOutLabel.put(sChild, prefixUnlabeled + "dep(" + goldDep.gov().label().toString().replaceFirst("-[^-]*$", "") + ", " + sChild + ")");
            }
            for (TypedDependency labeledError : errl.get(0)) {
                sChild = labeledError.dep().label().toString().replaceFirst("-[^-]*$", "");
                sGov = labeledError.gov().label().toString().replaceFirst("-[^-]*$", "");
                labeledErrorCounts.incrementCount(labeledError.reln().toString() + "(" + sGov + ", " + sChild + ") <= " + (String)childCorrectWithLabel.get(sChild));
            }
            for (TypedDependency unlabeledError : errl.get(1)) {
                sChild = unlabeledError.dep().label().toString().replaceFirst("-[^-]*$", "");
                sGov = unlabeledError.gov().label().toString().replaceFirst("-[^-]*$", "");
                unlabeledErrorCounts.incrementCount("dep(" + sGov + ", " + sChild + ") <= " + (String)childCorrectWithOutLabel.get(sChild));
            }
        }
        return new Score(cnt, correctAttachment, correctUnlabeledAttachment, labelCnt, labelCorrect, labeledErrorCounts, unlabeledErrorCounts);
    }

    public static void main(String[] args) throws IOException {
        Properties props = StringUtils.argsToProperties(args);
        boolean verbose = Boolean.parseBoolean(props.getProperty("v", "False"));
        String goldFilename = props.getProperty("g");
        String systemFilename = props.getProperty("s");
        if (goldFilename == null || systemFilename == null) {
            System.err.println("Usage:\n\tjava ...DependencyScoring [-v True/False] -g goldFile -s systemFile\n");
            System.err.println("\nOptions:\n\t-v verbose output");
            System.exit(-1);
        }
        DependencyScoring goldScorer = new DependencyScoring(goldFilename);
        List<Collection<TypedDependency>> systemDeps = DependencyScoring.readDeps(systemFilename);
        Score score = goldScorer.score(systemDeps);
        System.out.println(score.toString(verbose));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Score {
        final int cnt;
        final int correctAttachment;
        final int correctUnlabeledAttachment;
        final int labelCnt;
        final int labelCorrect;
        final double labeledAttachment;
        final double unlabeledAttachment;
        final double labelAccuracy;
        final ClassicCounter<String> unlabeledErrorCounts;
        final ClassicCounter<String> labeledErrorCounts;

        public Score(int cnt, int correctAttachment, int correctUnlabeledAttachment, int labelCnt, int labelCorrect, ClassicCounter<String> labeledErrorCounts, ClassicCounter<String> unlabeledErrorCounts) {
            this.cnt = cnt;
            this.correctAttachment = correctAttachment;
            this.correctUnlabeledAttachment = correctUnlabeledAttachment;
            this.labelCnt = labelCnt;
            this.labelCorrect = labelCorrect;
            this.labeledAttachment = (double)correctAttachment / (double)cnt;
            this.unlabeledAttachment = (double)correctUnlabeledAttachment / (double)cnt;
            this.labelAccuracy = (double)labelCorrect / (double)labelCnt;
            this.unlabeledErrorCounts = new ClassicCounter<String>(unlabeledErrorCounts);
            this.labeledErrorCounts = new ClassicCounter<String>(labeledErrorCounts);
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean verbose) {
            StringBuilder sbuild = new StringBuilder();
            sbuild.append(String.format("Labeled Attachment: %.3f (%d/%d)\n", this.labeledAttachment, this.correctAttachment, this.cnt));
            sbuild.append(String.format("Unlabeled Attachment: %.3f (%d/%d)\n", this.unlabeledAttachment, this.correctUnlabeledAttachment, this.cnt));
            sbuild.append(String.format("LabelAccuracy: %.3f (%d/%d)\n", this.labelAccuracy, this.labelCorrect, this.labelCnt));
            if (verbose) {
                sbuild.append("\nLabeled Attachment Error Counts\n");
                sbuild.append(Counters.toSortedString(this.labeledErrorCounts, Integer.MAX_VALUE, "\t%2$f\t%1$s", "\n"));
                sbuild.append("\n");
                sbuild.append("\nUnlabeled Attachment Error Counts\n");
                sbuild.append(Counters.toSortedString(this.unlabeledErrorCounts, Integer.MAX_VALUE, "\t%2$f\t%1$s", "\n"));
            }
            return sbuild.toString();
        }
    }

    private static class TypedDependencyStringEquality
    extends TypedDependency {
        public TypedDependencyStringEquality(GrammaticalRelation reln, TreeGraphNode gov, TreeGraphNode dep) {
            super(reln, gov, dep);
        }

        public boolean equals(Object o) {
            return o.toString().equals(this.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

