/* -*- buffer-read-only: t -*-
 *
 *    regcharclass.h
 *
 *    Copyright (C) 2007, 2011 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/regcharclass.pl.
 * Any changes made here will be lost!
 * WARNING: These macros are for internal Perl core use only, and may be
 * changed or removed without notice.
 */


#ifndef H_REGCHARCLASS   /* Guard against nested #includes */
#define H_REGCHARCLASS 1

/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( 0x0A <= NATIVE_TO_LATIN1(((U8*)s)[0]) && NATIVE_TO_LATIN1(((U8*)s)[0]) <= 0x0C ) ? 1\
    : ( 0x0D == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x0A == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 1 )               \
    : ( is_utf8 ) ?                                                         \
	( ( 0xC2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                       \
	    ( ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )           \
	: ( ( ( 0xE2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
    : ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) )                           \
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x0A <= NATIVE_TO_LATIN1(((U8*)s)[0]) && NATIVE_TO_LATIN1(((U8*)s)[0]) <= 0x0C ) ? 1\
    : ( 0x0D == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x0A == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 1 )               \
    : ( is_utf8 ) ?                                                         \
	( ( ( 0xC2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) ? 2 : 0 )\
    : ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) )                           \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0A <= NATIVE_TO_LATIN1(((U8*)s)[0]) && NATIVE_TO_LATIN1(((U8*)s)[0]) <= 0x0D ) ? 1\
    : ( !( is_utf8 ) ) ?                                                    \
	( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[0]) )                           \
    : 0 )                                                                   \
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( 0x0A <= NATIVE_TO_LATIN1(((U8*)s)[0]) && NATIVE_TO_LATIN1(((U8*)s)[0]) <= 0x0C ) ? 1\
    : ( 0x0D == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x0A == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 1 )               \
    : ( 0xC2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )               \
    : ( ( ( 0xE2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x0A <= NATIVE_TO_LATIN1(((U8*)s)[0]) && NATIVE_TO_LATIN1(((U8*)s)[0]) <= 0x0C ) ? 1\
    : ( 0x0D == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x0A == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 1 )               \
    : ( ( 0xC2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) ? 2 : 0 )\
: ((e)-(s) > 0) ?                                                           \
    ( 0x0A <= NATIVE_TO_LATIN1(((U8*)s)[0]) && NATIVE_TO_LATIN1(((U8*)s)[0]) <= 0x0D )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0A <= NATIVE_TO_LATIN1(((U8*)s)[0]) && NATIVE_TO_LATIN1(((U8*)s)[0]) <= 0x0C ) || 0x85 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ? 1\
    : ( 0x0D == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x0A == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 1 )               \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0A <= NATIVE_TO_LATIN1(((U8*)s)[0]) && NATIVE_TO_LATIN1(((U8*)s)[0]) <= 0x0D ) || 0x85 == NATIVE_TO_LATIN1(((U8*)s)[0]) )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( ( 0x9A == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
: ( 0xE2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x8A ) || 0xAF == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 0 )\
    : ( ( 0x81 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x9F == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
: ( ( ( 0xE3 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == NATIVE_TO_UNI(cp) || ( 0x1680 < NATIVE_TO_UNI(cp) &&            \
( ( 0x2000 <= NATIVE_TO_UNI(cp) && NATIVE_TO_UNI(cp) <= 0x200A ) || ( 0x200A < NATIVE_TO_UNI(cp) &&\
( 0x202F == NATIVE_TO_UNI(cp) || ( 0x202F < NATIVE_TO_UNI(cp) &&            \
( 0x205F == NATIVE_TO_UNI(cp) || 0x3000 == NATIVE_TO_UNI(cp) ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xE2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFE ) == 0xA8 ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( 0x2028 == NATIVE_TO_UNI(cp) || 0x2029 == NATIVE_TO_UNI(cp) )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( 0xEF == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0xBC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( ( 0x90 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x99 ) || ( 0xA1 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xA6 ) ) ? 3 : 0 )\
    : ( ( 0xBD == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x81 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x86 ) ) ? 3 : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( ( 0xFF10 <= NATIVE_TO_UNI(cp) && NATIVE_TO_UNI(cp) <= 0xFF19 ) || ( 0xFF19 < NATIVE_TO_UNI(cp) &&\
( ( 0xFF21 <= NATIVE_TO_UNI(cp) && NATIVE_TO_UNI(cp) <= 0xFF26 ) || ( 0xFF41 <= NATIVE_TO_UNI(cp) && NATIVE_TO_UNI(cp) <= 0xFF46 ) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( ( 0x9A == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
: ( 0xE2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x8A ) || ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFE ) == 0xA8 || 0xAF == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 0 )\
    : ( ( 0x81 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x9F == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
: ( ( ( 0xE3 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == NATIVE_TO_UNI(cp) || ( 0x1680 < NATIVE_TO_UNI(cp) &&            \
( ( 0x2000 <= NATIVE_TO_UNI(cp) && NATIVE_TO_UNI(cp) <= 0x200A ) || ( 0x200A < NATIVE_TO_UNI(cp) &&\
( 0x2028 == NATIVE_TO_UNI(cp) || ( 0x2028 < NATIVE_TO_UNI(cp) &&            \
( 0x2029 == NATIVE_TO_UNI(cp) || ( 0x2029 < NATIVE_TO_UNI(cp) &&            \
( 0x202F == NATIVE_TO_UNI(cp) || ( 0x202F < NATIVE_TO_UNI(cp) &&            \
( 0x205F == NATIVE_TO_UNI(cp) || 0x3000 == NATIVE_TO_UNI(cp) ) ) ) ) ) ) ) ) ) ) )

/*
	REPLACEMENT: Unicode REPLACEMENT CHARACTER

	0xFFFD
*/
/*** GENERATED CODE ***/
#define is_REPLACEMENT_utf8_safe(s,e)                                       \
( ( ( ( ( ((e) - (s)) >= 3 ) && ( 0xEF == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ) && ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( 0xBD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )

/*
	NONCHAR: Non character code points

	\p{Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8(s)                                                  \
( ( 0xEF == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0xB7 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( 0x90 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xAF ) ? 3 : 0 )\
    : ( ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( NATIVE_TO_LATIN1(((U8*)s)[2]) >= 0xBE ) ) ? 3 : 0 )\
: ( 0xF0 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) == 0x9F || ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xEF ) == 0xAF ) ) && ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( NATIVE_TO_LATIN1(((U8*)s)[3]) >= 0xBE ) ) ? 4 : 0 )\
: ( 0xF1 <= NATIVE_TO_LATIN1(((U8*)s)[0]) && NATIVE_TO_LATIN1(((U8*)s)[0]) <= 0xF3 ) ?\
    ( ( ( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xCF ) == 0x8F ) && ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( NATIVE_TO_LATIN1(((U8*)s)[3]) >= 0xBE ) ) ? 4 : 0 )\
: ( ( ( ( 0xF4 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x8F == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( NATIVE_TO_LATIN1(((U8*)s)[3]) >= 0xBE ) ) ? 4 : 0 )

/*
	SURROGATE: Surrogate characters

	\p{Gc=Cs}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8(s)                                                \
( ( ( 0xED == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( NATIVE_TO_LATIN1(((U8*)s)[1]) >= 0xA0 ) ) ? 3 : 0 )

/*
	GCB_L: Grapheme_Cluster_Break=L

	\p{_X_GCB_L}
*/
/*** GENERATED CODE ***/
#define is_GCB_L_utf8(s)                                                    \
( ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x84 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	3                                                                   \
    : ( ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x9F ) ) ? 3 : 0 )\
: ( ( ( 0xEA == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0xA5 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( 0xA0 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xBC ) ) ? 3 : 0 )

/*
	GCB_LV_LVT_V: Grapheme_Cluster_Break=(LV or LVT or V)

	\p{_X_LV_LVT_V}
*/
/*** GENERATED CODE ***/
#define is_GCB_LV_LVT_V_utf8(s)                                             \
( ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( NATIVE_TO_LATIN1(((U8*)s)[2]) >= 0xA0 ) ? 3 : 0 )               \
    : ( ( 0x86 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xA7 ) ) ? 3 : 0 )\
: ( 0xEA == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) >= 0xB0 ) ?                           \
	3                                                                   \
    : 0 )                                                                   \
: ( 0xEB == NATIVE_TO_LATIN1(((U8*)s)[0]) || 0xEC == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?\
    3                                                                       \
: ( 0xED == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) <= 0x9D ) ?                           \
	3                                                                   \
    : ( 0x9E == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xA3 ) || ( NATIVE_TO_LATIN1(((U8*)s)[2]) >= 0xB0 ) ) ? 3 : 0 )\
    : ( ( 0x9F == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x86 ) ) ? 3 : 0 )\
: 0 )

/*
	GCB_Prepend: Grapheme_Cluster_Break=Prepend

	\p{_X_GCB_Prepend}
*/
/*** GENERATED CODE ***/
#define is_GCB_Prepend_utf8(s)                                              \
( 0 )

/*
	GCB_RI: Grapheme_Cluster_Break=RI

	\p{_X_RI}
*/
/*** GENERATED CODE ***/
#define is_GCB_RI_utf8(s)                                                   \
( ( ( ( ( 0xF0 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x9F == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( 0x87 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( NATIVE_TO_LATIN1(((U8*)s)[3]) >= 0xA6 ) ) ? 4 : 0 )

/*
	GCB_SPECIAL_BEGIN_START: Grapheme_Cluster_Break=special_begin_starts

	\p{_X_Special_Begin_Start}
*/
/*** GENERATED CODE ***/
#define is_GCB_SPECIAL_BEGIN_START_utf8(s)                                  \
( ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xFC ) == 0x84 ) ?                \
	3                                                                   \
    : 0 )                                                                   \
: ( 0xEA == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0xA5 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( 0xA0 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xBC ) ? 3 : 0 )\
    : ( NATIVE_TO_LATIN1(((U8*)s)[1]) >= 0xB0 ) ?                           \
	3                                                                   \
    : 0 )                                                                   \
: ( 0xEB == NATIVE_TO_LATIN1(((U8*)s)[0]) || 0xEC == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?\
    3                                                                       \
: ( 0xED == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) <= 0x9D ) ?                           \
	3                                                                   \
    : ( 0x9E == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xA3 ) || ( NATIVE_TO_LATIN1(((U8*)s)[2]) >= 0xB0 ) ) ? 3 : 0 )\
    : ( ( 0x9F == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x86 ) || ( 0x8B <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xBB ) ) ) ? 3 : 0 )\
: ( ( ( ( 0xF0 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x9F == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( 0x87 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( NATIVE_TO_LATIN1(((U8*)s)[3]) >= 0xA6 ) ) ? 4 : 0 )

/*
	GCB_T: Grapheme_Cluster_Break=T

	\p{_X_GCB_T}
*/
/*** GENERATED CODE ***/
#define is_GCB_T_utf8(s)                                                    \
( ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x86 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( NATIVE_TO_LATIN1(((U8*)s)[2]) >= 0xA8 ) ? 3 : 0 )               \
    : ( 0x87 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	3                                                                   \
    : 0 )                                                                   \
: ( ( ( 0xED == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x9F == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( 0x8B <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xBB ) ) ? 3 : 0 )

/*
	GCB_V: Grapheme_Cluster_Break=V

	\p{_X_GCB_V}
*/
/*** GENERATED CODE ***/
#define is_GCB_V_utf8(s)                                                    \
( ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( NATIVE_TO_LATIN1(((U8*)s)[2]) >= 0xA0 ) ? 3 : 0 )               \
    : ( ( 0x86 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xA7 ) ) ? 3 : 0 )\
: ( 0xED == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x9E == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( NATIVE_TO_LATIN1(((U8*)s)[2]) >= 0xB0 ) ? 3 : 0 )               \
    : ( ( 0x9F == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x86 ) ) ? 3 : 0 )\
: 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x8F == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )                   \
: ( 0xD8 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x9C == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )                   \
: ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( 0x9F == NATIVE_TO_LATIN1(((U8*)s)[2]) || 0xA0 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 0 )\
    : ( 0x9A == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 0 )               \
    : ( 0x9E == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFE ) == 0xB4 ) ? 3 : 0 )    \
    : ( ( 0xA0 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x8B <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x8E ) ) ? 3 : 0 )\
: ( 0xE2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xBE ) ? 3 : 0 )               \
    : ( 0x81 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( ( 0x81 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x93 ) || ( 0x95 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xAF ) ) ? 3 : 0 )\
    : ( 0x86 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( NATIVE_TO_LATIN1(((U8*)s)[2]) >= 0x90 ) ? 3 : 0 )               \
    : ( ( 0x87 <= NATIVE_TO_LATIN1(((U8*)s)[1]) && NATIVE_TO_LATIN1(((U8*)s)[1]) <= 0x90 ) || ( 0x94 <= NATIVE_TO_LATIN1(((U8*)s)[1]) && NATIVE_TO_LATIN1(((U8*)s)[1]) <= 0x9C ) || ( 0x9F <= NATIVE_TO_LATIN1(((U8*)s)[1]) && NATIVE_TO_LATIN1(((U8*)s)[1]) <= 0xAF ) || ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xFE ) == 0xB8 ) ?\
	3                                                                   \
    : ( 0x91 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x9F ) ? 3 : 0 )               \
    : ( 0x9D == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xB5 ) ? 3 : 0 )               \
    : ( ( 0x9E == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( NATIVE_TO_LATIN1(((U8*)s)[2]) >= 0x94 ) ) ? 3 : 0 )\
: ( 0xE3 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x83 ) || ( 0x88 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xA0 ) || 0xB0 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 0 )\
    : ( ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xA4 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
: ( 0xEF == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0xB4 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( NATIVE_TO_LATIN1(((U8*)s)[2]) >= 0xBE ) ? 3 : 0 )               \
    : ( 0xB8 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x8F ) ? 3 : 0 )               \
    : ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[2]) || 0x86 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 0 )\
    : ( 0xBB == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 0 )               \
    : ( 0xBE == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( 0xA0 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 0 )               \
    : ( ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xB0 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0xB8 ) ) ? 3 : 0 )\
: ( 0xF0 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( ( ( 0x9D == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( 0xB3 <= NATIVE_TO_LATIN1(((U8*)s)[3]) && NATIVE_TO_LATIN1(((U8*)s)[3]) <= 0xBA ) ) ? 4 : 0 )\
: ( ( 0xF3 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0xA0 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) ? 4 : 0 )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	do regen/regcharclass_multi_char_folds.pl
	&regcharclass_multi_char_folds::multi_char_folds(1)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e)                             \
( ( 0x73 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0x74 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e)                             \
( ( 0x74 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x88 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x77 == NATIVE_TO_LATIN1(((U8*)s)[0]) || 0x79 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?\
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x8A == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0xC5 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xC5 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
    : ( 0xCA == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xBC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x6E == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xFD ) == 0xAC ) ?            \
	    ( ( ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0xB1 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0xB7 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?\
	    ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ?                   \
		( ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ?               \
		    ( ( ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[4]) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[5]) ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ?                   \
		( ( 0x88 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ?               \
		    ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[4]) ) ?           \
			( ( ( NATIVE_TO_LATIN1(((U8*)s)[5]) & 0xFE ) == 0x80 ) ? 6 : 0 )\
		    : ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[4]) ) && ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[5]) ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xCF == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x81 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0x93 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ?                   \
		( ( 0x88 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ?               \
		    ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[4]) ) ?           \
			( ( ( NATIVE_TO_LATIN1(((U8*)s)[5]) & 0xFE ) == 0x80 ) ? 6 : 0 )\
		    : ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[4]) ) && ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[5]) ) ) ? 6 : 0 )\
		: ( 0x93 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ?               \
		    ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[4]) ) ?           \
			( ( ( NATIVE_TO_LATIN1(((U8*)s)[5]) & 0xFE ) == 0x80 ) ? 6 : 4 )\
		    : ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[4]) ) && ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[5]) ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0x89 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ?                   \
		( ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ?               \
		    ( ( ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[4]) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[5]) ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
    : ( 0xD5 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0xA5 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( ( 0xD6 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0xB4 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( ( 0xD5 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( ( ( NATIVE_TO_LATIN1(((U8*)s)[3]) & 0xF7 ) == 0xA5 ) || NATIVE_TO_LATIN1(((U8*)s)[3]) == 0xAB || NATIVE_TO_LATIN1(((U8*)s)[3]) == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xD5 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( 0xB6 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
    : ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0xBC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( ( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xD8 ) == 0x80 ) && ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[4]) ) ) ? 5 : 0 )\
	: ( ( ( ( 0xBD == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xF8 ) == 0xA0 ) || ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFB ) == 0xB0 ) || NATIVE_TO_LATIN1(((U8*)s)[2]) == 0xBC ) ) && ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[4]) ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part2(s,e)                             \
( ( 0x61 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
	( ( ( 0xCA == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xBE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x66 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x66 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( 0x69 == NATIVE_TO_LATIN1(((U8*)s)[2]) || 0x6C == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 2 )\
	: ( 0x69 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0x6C == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )\
    : ( 0x68 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xB1 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x69 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x87 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x6A == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x8C == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x73 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x73 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0x74 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )\
    : ( 0x74 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x88 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x77 == NATIVE_TO_LATIN1(((U8*)s)[0]) || 0x79 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?\
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x8A == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0xC5 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xC5 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
    : ( 0xCA == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xBC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x6E == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xFD ) == 0xAC ) ?            \
	    ( ( ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0xB1 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0xB7 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?\
	    ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ?                   \
		( ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ? 4 : 0 )       \
	    : ( ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( ( ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
    : ( 0xCF == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x81 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0x93 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ?                   \
		( ( 0x93 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ? 4 : 0 )       \
	    : ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0x89 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ?                   \
		( ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ? 4 : 0 )       \
	    : ( ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
    : ( 0xD5 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0xA5 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( ( 0xD6 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0xB4 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( ( 0xD5 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( ( ( NATIVE_TO_LATIN1(((U8*)s)[3]) & 0xF7 ) == 0xA5 ) || NATIVE_TO_LATIN1(((U8*)s)[3]) == 0xAB || NATIVE_TO_LATIN1(((U8*)s)[3]) == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xD5 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( 0xB6 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part3(s,e)                             \
( ((e)-(s) > 2) ?                                                           \
    ( ( 0x61 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCA == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xBE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x66 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x66 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( 0x69 == NATIVE_TO_LATIN1(((U8*)s)[2]) || 0x6C == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 2 )\
	: ( 0x69 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0x6C == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )\
    : ( 0x68 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xB1 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x69 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x87 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x6A == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x8C == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x73 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x73 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0x74 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )\
    : ( 0x74 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x88 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x77 == NATIVE_TO_LATIN1(((U8*)s)[0]) || 0x79 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?\
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x8A == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( ( ( 0xCA == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0xBC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( 0x6E == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x66 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x66 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0x69 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0x6C == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )\
    : ( ( 0x73 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x73 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0x74 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part4(s,e)                             \
( ( 0x61 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
	( ( ( 0xCA == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xBE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x66 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x66 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( 0x69 == NATIVE_TO_LATIN1(((U8*)s)[2]) || 0x6C == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 2 )\
	: ( 0x69 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0x6C == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )\
    : ( 0x68 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xB1 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x69 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x87 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x6A == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x8C == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x73 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ? is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e) )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part5(s,e)                             \
( ((e)-(s) > 4) ?                                                           \
    ( ( 0x61 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCA == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xBE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x66 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x66 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( 0x69 == NATIVE_TO_LATIN1(((U8*)s)[2]) || 0x6C == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 2 )\
	: ( 0x69 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0x6C == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )\
    : ( 0x68 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xB1 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x69 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x87 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x6A == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x8C == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x73 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x73 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0x74 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )\
    : ( 0x74 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x88 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0x77 == NATIVE_TO_LATIN1(((U8*)s)[0]) || 0x79 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?\
	( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x8A == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0xC5 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xC5 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
    : ( 0xCA == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( 0xBC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0x6E == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
    : ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xFD ) == 0xAC ) ?            \
	    ( ( ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0xB1 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0xB7 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?\
	    ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ?                   \
		( ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ? 4 : 0 )       \
	    : ( ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( ( ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
    : ( 0xCF == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0x81 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0x93 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( 0xCC == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ?                   \
		( ( 0x93 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ? 4 : 0 )       \
	    : ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0x89 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( 0xCD == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ?                   \
		( ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ? 4 : 0 )       \
	    : ( ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
    : ( 0xD5 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0xA5 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( ( 0xD6 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( 0x82 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
	: ( 0xB4 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( ( 0xD5 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) && ( ( ( NATIVE_TO_LATIN1(((U8*)s)[3]) & 0xF7 ) == 0xA5 ) || NATIVE_TO_LATIN1(((U8*)s)[3]) == 0xAB || NATIVE_TO_LATIN1(((U8*)s)[3]) == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( 0xD5 == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) && ( 0xB6 == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) ? 4 : 0 )\
    : ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                           \
	( ( 0xBC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                       \
	    ( ( ( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xD8 ) == 0x80 ) && ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[4]) ) ) ? 5 : 0 )\
	: ( ( ( ( 0xBD == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xF8 ) == 0xA0 ) || ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFB ) == 0xB0 ) || NATIVE_TO_LATIN1(((U8*)s)[2]) == 0xBC ) ) && ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[3]) ) ) && ( 0xB9 == NATIVE_TO_LATIN1(((U8*)s)[4]) ) ) ? 5 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 3) ? is_MULTI_CHAR_FOLD_utf8_safe_part2(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part3(s,e) )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ? is_MULTI_CHAR_FOLD_utf8_safe_part4(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part5(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(0)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( NATIVE_TO_LATIN1(((U8*)s)[0]) & 0xDF ) == 0x46 ) ?                \
	( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x46 ) ?            \
	    ( ( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xDF ) == 0x49 ) || ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xDF ) == 0x4C ) ) ? 3 : 2 )\
	: ( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x49 ) || ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x4C ) ) ? 2 : 0 )\
    : ( ( ( NATIVE_TO_LATIN1(((U8*)s)[0]) & 0xDF ) == 0x53 ) && ( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x53 ) || ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x54 ) ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( NATIVE_TO_LATIN1(((U8*)s)[0]) & 0xDF ) == 0x46 ) ?                \
	( ( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x46 ) || ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x49 ) || ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x4C ) ) ? 2 : 0 )\
    : ( ( ( NATIVE_TO_LATIN1(((U8*)s)[0]) & 0xDF ) == 0x53 ) && ( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x53 ) || ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x54 ) ) ) ? 2 : 0 )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0xC3 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x9F == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )                   \
: ( 0xC4 == NATIVE_TO_LATIN1(((U8*)s)[0]) || 0xC7 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?\
    ( ( 0xB0 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )                   \
: ( 0xC5 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x89 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )                   \
: ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x90 ) ? 2 : 0 )        \
: ( 0xD6 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x87 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )                   \
: ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0xBA == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( ( 0x96 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x9A ) || 0x9E == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ? 3 : 0 )\
    : ( 0xBD == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xF9 ) == 0x90 ) ? 3 : 0 )    \
    : ( 0xBE == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ?                           \
	( ( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xE0 ) == 0x80 ) || ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xF0 ) == 0xA0 ) || ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFA ) == 0xB2 ) || ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xF7 ) == 0xB4 ) ) ? 3 : 0 )\
    : ( ( 0xBF == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xCA ) == 0x82 ) || ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xF7 ) == 0x84 ) || NATIVE_TO_LATIN1(((U8*)s)[2]) == 0xA4 || ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xF7 ) == 0xB4 ) ) ) ? 3 : 0 )\
: ( ( ( 0xEF == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0xAC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x86 ) || ( 0x93 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x97 ) ) ) ? 3 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ( NATIVE_TO_LATIN1(((U8*)s)[0]) & 0x80 ) == 0x00 ) ? 1                  \
: ( ( NATIVE_TO_LATIN1(((U8*)s)[0]) & 0xFE ) == 0xC2 ) ?                    \
    2                                                                       \
: ( 0xC4 == NATIVE_TO_LATIN1(((U8*)s)[0]) || 0xC7 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?\
    ( ( 0xB0 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )                   \
: ( 0xC5 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x89 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0xB8 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0xBF == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )\
: ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x9C ) ? 2 : 0 )        \
: ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( ( 0xBA == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( ( 0x96 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x9A ) || 0x9E == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
: ( 0xE2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( ( 0x84 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFE ) == 0xAA ) ) ? 3 : 0 )\
: ( ( ( 0xEF == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0xAC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x86 ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( NATIVE_TO_UNI(cp) <= 0xFF || ( 0xFF < NATIVE_TO_UNI(cp) &&                \
( 0x130 == NATIVE_TO_UNI(cp) || ( 0x130 < NATIVE_TO_UNI(cp) &&              \
( 0x149 == NATIVE_TO_UNI(cp) || ( 0x149 < NATIVE_TO_UNI(cp) &&              \
( 0x178 == NATIVE_TO_UNI(cp) || ( 0x178 < NATIVE_TO_UNI(cp) &&              \
( 0x17F == NATIVE_TO_UNI(cp) || ( 0x17F < NATIVE_TO_UNI(cp) &&              \
( 0x1F0 == NATIVE_TO_UNI(cp) || ( 0x1F0 < NATIVE_TO_UNI(cp) &&              \
( 0x39C == NATIVE_TO_UNI(cp) || ( 0x39C < NATIVE_TO_UNI(cp) &&              \
( 0x3BC == NATIVE_TO_UNI(cp) || ( 0x3BC < NATIVE_TO_UNI(cp) &&              \
( ( 0x1E96 <= NATIVE_TO_UNI(cp) && NATIVE_TO_UNI(cp) <= 0x1E9A ) || ( 0x1E9A < NATIVE_TO_UNI(cp) &&\
( 0x1E9E == NATIVE_TO_UNI(cp) || ( 0x1E9E < NATIVE_TO_UNI(cp) &&            \
( 0x212A == NATIVE_TO_UNI(cp) || ( 0x212A < NATIVE_TO_UNI(cp) &&            \
( 0x212B == NATIVE_TO_UNI(cp) || ( 0xFB00 <= NATIVE_TO_UNI(cp) && NATIVE_TO_UNI(cp) <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ( NATIVE_TO_LATIN1(((U8*)s)[0]) & 0x80 ) == 0x00 ) ? 1                  \
: ( ( NATIVE_TO_LATIN1(((U8*)s)[0]) & 0xFE ) == 0xC2 ) ?                    \
    2                                                                       \
: ( 0xC4 == NATIVE_TO_LATIN1(((U8*)s)[0]) || 0xC7 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?\
    ( ( 0xB0 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )                   \
: ( 0xC5 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0x89 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0xB8 == NATIVE_TO_LATIN1(((U8*)s)[1]) || 0xBF == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )\
: ( 0xCA == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( 0xBC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )                   \
: ( 0xCE == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( ( NATIVE_TO_LATIN1(((U8*)s)[1]) & 0xDF ) == 0x9C ) ? 2 : 0 )        \
: ( 0xE1 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( ( 0xBA == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( ( 0x96 <= NATIVE_TO_LATIN1(((U8*)s)[2]) && NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x9A ) || 0x9E == NATIVE_TO_LATIN1(((U8*)s)[2]) ) ) ? 3 : 0 )\
: ( 0xE2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                               \
    ( ( ( 0x84 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) && ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFE ) == 0xAA ) ) ? 3 : 0 )\
: ( ( ( 0xEF == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0xAC == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( NATIVE_TO_LATIN1(((U8*)s)[2]) <= 0x86 ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( NATIVE_TO_UNI(cp) <= 0xFF || ( 0xFF < NATIVE_TO_UNI(cp) &&                \
( 0x130 == NATIVE_TO_UNI(cp) || ( 0x130 < NATIVE_TO_UNI(cp) &&              \
( 0x149 == NATIVE_TO_UNI(cp) || ( 0x149 < NATIVE_TO_UNI(cp) &&              \
( 0x178 == NATIVE_TO_UNI(cp) || ( 0x178 < NATIVE_TO_UNI(cp) &&              \
( 0x17F == NATIVE_TO_UNI(cp) || ( 0x17F < NATIVE_TO_UNI(cp) &&              \
( 0x1F0 == NATIVE_TO_UNI(cp) || ( 0x1F0 < NATIVE_TO_UNI(cp) &&              \
( 0x2BC == NATIVE_TO_UNI(cp) || ( 0x2BC < NATIVE_TO_UNI(cp) &&              \
( 0x39C == NATIVE_TO_UNI(cp) || ( 0x39C < NATIVE_TO_UNI(cp) &&              \
( 0x3BC == NATIVE_TO_UNI(cp) || ( 0x3BC < NATIVE_TO_UNI(cp) &&              \
( ( 0x1E96 <= NATIVE_TO_UNI(cp) && NATIVE_TO_UNI(cp) <= 0x1E9A ) || ( 0x1E9A < NATIVE_TO_UNI(cp) &&\
( 0x1E9E == NATIVE_TO_UNI(cp) || ( 0x1E9E < NATIVE_TO_UNI(cp) &&            \
( 0x212A == NATIVE_TO_UNI(cp) || ( 0x212A < NATIVE_TO_UNI(cp) &&            \
( 0x212B == NATIVE_TO_UNI(cp) || ( 0xFB00 <= NATIVE_TO_UNI(cp) && NATIVE_TO_UNI(cp) <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ((e) > (s)) ?                                                             \
    ( ( ( 0x09 <= NATIVE_TO_LATIN1(((U8*)s)[0]) && NATIVE_TO_LATIN1(((U8*)s)[0]) <= 0x0D ) || 0x20 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ? 1\
    : (! is_utf8 ) ?                                                        \
	    ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[0]) )                       \
	: (((e) - (s)) >= UTF8SKIP(s)) ?                                    \
	    ( ( 0xC2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                   \
		( ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )       \
	    : ( ( ( 0xE2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFE ) == 0x8E || ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
	: 0 )                                                               \
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_non_low_safe(s,e,is_utf8)                                  \
( ((e) > (s)) ?                                                             \
    ( (! is_utf8) ?                                                         \
	( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[0]) )                           \
    : (((e) - (s)) >= UTF8SKIP(s)) ?                                        \
	( ( 0xC2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) ?                       \
	    ( ( 0x85 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ? 2 : 0 )           \
	: ( ( ( 0xE2 == NATIVE_TO_LATIN1(((U8*)s)[0]) ) && ( 0x80 == NATIVE_TO_LATIN1(((U8*)s)[1]) ) ) && ( ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFE ) == 0x8E || ( NATIVE_TO_LATIN1(((U8*)s)[2]) & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
    : 0 )                                                                   \
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_cp(cp)                                                     \
( ( 0x09 <= NATIVE_TO_UNI(cp) && NATIVE_TO_UNI(cp) <= 0x0D ) || ( 0x0D < NATIVE_TO_UNI(cp) &&\
( 0x20 == NATIVE_TO_UNI(cp) || ( 0x20 < NATIVE_TO_UNI(cp) &&                \
( 0x85 == NATIVE_TO_UNI(cp) || ( 0x85 < NATIVE_TO_UNI(cp) &&                \
( 0x200E == NATIVE_TO_UNI(cp) || ( 0x200E < NATIVE_TO_UNI(cp) &&            \
( 0x200F == NATIVE_TO_UNI(cp) || ( 0x200F < NATIVE_TO_UNI(cp) &&            \
( 0x2028 == NATIVE_TO_UNI(cp) || 0x2029 == NATIVE_TO_UNI(cp) ) ) ) ) ) ) ) ) ) ) )


#endif /* H_REGCHARCLASS */

/* ex: set ro: */
