################################################################################
# Tk::StyleDialog - Stylish Dialogboxes with Custom Icons		       #
################################################################################
package Tk::StyleDialog::Builtins;

# Additional built-in icons.

$Tk::StyleDialog::BUILTIN_ICONS = {
	'aim_guy' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAANmfvwAAACr1BMVEUCAAUAAQQAAQAEAAYAAQ4A
AwYBAg8AAhQABBUABhoCBR8ABxsGBSQACiUBCyYCDScADiwBCkUAEDMAETMAED0GDzgAEj8GD0MC
FjgAE1ICFj0AGE8AGFAAG0IAGkwAHEMAHT4AHU8BHVYAIk4AI0oGIE4GIUkAJkcGHmsAJlIIH2wE
KFsAKHIAK2IAIJ4ALWUALmAALmYALIwHMmsAJ7sBLpYAOWsKM3ILNWgAOXEMM3kAPnUALuIAQocT
LeYASo8ATYsATJEKRKsFQscPSYgATpkRS4QGU4sITq8BTM8AVacAR/kAUcQQQ+cAUNIAVMgDWqYU
U6YAU90TUMUAU+0AVuAAUf8LTP8GV9sNX54AZK8STf8AXfYAb7oAZP8Acr0AbdoAaPkAZ/8Ua7cA
aP8AbP8kaqoAd8gCbP4AdNkJbf8AduoLbvgdZvkAdP0AdP4Ad/kAd/8idLMAev8Mev0AgfsAgv0A
g/4TfPEAhP8AifQEhvoWfP8AiP8AiP8Aiv0Ihv8Lh/sAjvoAjv8Aj/sAkvgAkf4Ak/kAlu4AlPoA
lv8XkOIAl/8GlP8GlfsAmfYAmvEAnfsAn/0Aof8AovoAov8ApPwEpf0FqPgFqvQLpv4ArPw2mNcA
sP8AsfokoPkAtP0nofoAt/8AuvwarvgGu/4gsPoAwf8IvvojsfwNvP8msv0Pv/sSvf9Aq+o1r/MU
wPxEru4Ywv2XmZYcxvtJsfEfxP8fx/wiyP03wP0lyf4oyv87wv8s0P4+y/sx0v9AzPxRx/9Fz/9E
0/tG1Pw62/9H1f5L1/9vz/1b2v1O4v1c2/5e3P9p2v5o3ftr3/1s4P554P964f945PuC4vx65v59
6P9+6f+H5/+G6vyQ5f+W5fqP6fyY5/yK7v+V7v+e9vyo9v648v7C+f/E//0Lg/ccAAAAAXRSTlMA
QObYZgAAAAFiS0dEAIgFHUgAAAAJcEhZcwAACxMAAAsTAQCanBgAAAAHdElNRQfVAQUIOjCJ+kHT
AAAB5ElEQVQ4y2NgwABMTEwMeAETn4W1LF5FLPbrL904kca2GbcZLjvOXTxz5lQk42Zciri6d6/Z
uW3n4n4+nEpkpy1YMnNmf2u7OhMuNcJVbS1NzdX11QqbcSlh9cxKzE1MSQxiw6mESdw3LMw7LEyS
CacSYLDo2diYCIJU4FKymYmRjYUJrAKnKVBp3CqYzdz5IGqYcAburSdzhIEmMbFzYlfDJH/w8aNH
Wx2M3YrWJWMPO+b4+7fu3Ll/+ey1ew82cmFVwrX+2sVLly9dvnblwr1DBtiMYVLbcOHsybNnzpw8
enZttyY2JYwGe04ePnxyZmxUgL02B9bwZTJcu3ff7kPpzMzMsNDBcK36kh0HtxxcHC+BM/iYhGZs
W7Fixbbt/cq4YoA5YPHOxTtXLF68fIYlEzYfMzG7zl0yb960hcvmLVs0yxiLGibOwMnTJk2pMtfN
nDx50vRWVVQ1TIzMAlYJPa29nRWKjMycHk2tLT3ZAihqmDj9Cxpry0ori5WA7mRidqosLa31YUZx
L7NPTXFeQUGODiM4HXBH5OUVJ0qhBC+TXEpiXEaoHDQ8mERjMvzkmFG9zewcE2LKzQwNjc1MWkYs
zGghwySmBVaQCRHdjC0CGJlQghxr+KMJYosAdDEEBwDG9e1PY5uQ1wAAAABJRU5ErkJggg==',
	'aol_icon' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAC/VBMVEUpLJMOEFoVEWoYFWYcF2kT
GH0YG3kbHnUeG4oeHn0HJpYYIZUiInoaJIkbJYIkIIgjJXApKHoZLJYZK6QnLIsnKZ4vKYsOCU4V
M6ohL6E0MGsrLpQlMp4uL5YlMaQvMJcoNKApM6YhOKk0M5stNqMmOqwvOKU3N5gzOqc4PYosPbA3
PKomRLUxQbQyQq8qRrc8QK8sR7lBRo5KRIE9Q6olTb04RrM4RbkwSbwoT787R7xJTIJDSKogVcQr
UME+SrgiVsUtUcI2TcAvUsMvUcpIR79HS65BTLswU8RPTZExVL9CS8FBTrU6TsknWMg7Ub4zVcc1
V8JQT6ZKUqdMT7JGUrk3WMNITsxAUs04WcROUbRCVMlIVbZKUchSVZ46WNJDVNA7WsZCWL5XWYQ7
XMFEVstFVNdFVdIzYMo9XMg9WtRYWJY1YMtGV81RWK1GWcdUVL82YcxHW8JAW9ZbXIg/XspAYMVI
Xr5dXopDXdhWWrdVXLJEX9NNWd5RXrk9Y91NXs1MYcJIX+NWXM1TYrdVX8JQXdtHZsVUYb1QX9VB
as9JaMhLZNlDa9BeYb87cNNWY9tnaJROa8tIa99VasVlZrJHcM9Act1daMViZ79RbNRdasBBdNhX
bMhlaq5JctBpa6Nfashvb4RLc9E6et1FdttrbaVbb8tbcsZHetg/feBQd9Zob8BZceBlb81edMlt
cLZKfNpCf+JZd9FrccNqc71MfOFTe9RhdsxvdrROf95VfdZ2dqRyc8BncuVWftdkec9webFYf9l7
e5BSgOZ0d71fftJ5eadieuRLh+R8fJ17f5pVh99jgtZ5frFdhN5FjupXhuZpgdBXiOGFgZJlhtRZ
iuN8f8V/g6phidxyg85niNZrg+dvhtZdjeeAgsl2htFqi9mKipRyi9SKip+JjZx0jddilOaAi9GF
i8uMkJ99kNSTkZWOkqFgne5/ktaTlJ2Ak9eBlNmHldWXmZZtoOyKmNeFnNmMmtmRnt6QodqSotuT
pN2dqd2fq99KR3dPAAAAAXRSTlMAQObYZgAAAmpJREFUOMtjYICC2SBC6TeI7Ni0mQEFsL0BEpcO
MDAsP3TZGyEcBGNofvkCYRgeuzrJEEjXJmUwfNmy0fYLijGMMO5MEwgt9AWqUfnX79Mg2j/v7G0z
NyDD9MOSTQV+XxjKA7d8+fI8w5cBA4ijC1RfF0AVMOMyLhFEcoG0tGfL5xhphICGVvCz158+fbLR
gKoyNwydt3j7oTn99gGOH0AC0d22qV92Xvx6bUPDoUTHc0CRL2DAgMLCDjAcyBAkhSbAfN0GzYCo
mbN5UAR4JfhLjK8gi8g9QrNY8rTMiwcySCqUldV+/vr9WwMhoqU95dn7T5+mfIGJGejv2Xz26u3b
GXtMoSatMP0yafWhQ71dVg72YAHvKc5fYleu2nU5NTXR+QlIZEp74A2Gzndfe16d7wp0AeqLTgkL
q/kCCokjl/vDTI/CQoWBmPAhATAxEVLB+fI+6yJ8lrFI7927dw1HMm417MpVIarC3Nzc1rjU8CmK
ilS8AfnqymHsasQkxd48muhpZCQGDgAsKuQVZNX1XvwFgVsa2djMUFNV0Qj59Pnbt2/ff/z44RX3
RQVdhZauvs2C9XfvPnz88BkQJBo81dE5hWyZuX+SofmHvM2btx86dPbs2WkZ0/J8nB2dliHUuBat
N7Wr+3K8dPuc1SuXLF06Z1e+q2tXmLPTVJia8LIpU+wcooGeqLl2+eTJC8+fT289OOtQRpiDXR9E
TVp5Y1lZmF/mDCD31dYZO2ZsffVlzbabu+dnhDnbNYPyT21EQkJCfFZlZX3TOkiKeDth350Tayf3
VFZmJUS0gUPoCxJgQEo5qGJ4AQApljrdSD0n0wAAAABJRU5ErkJggg==',
	'attention' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAElBMVEUAAACAgACZmZnAwMD//wAA
AABjkWUwAAAAAXRSTlMAQObYZgAAAPNJREFUKM9lkEsOgzAMRA3KAVrJ7KOcoAvYV2DvEU3uf5X6
BwqtJZAZXjzjAGi9AVKTpwKMxZS0Q3oDsX0Pq0pYs7Q0y0ci2jLASco/JZjlP1OGtNEOyLQCkbzG
UmxoesURkeN04rqGxNXFpN3qlFZ2u0omNqtymkfhfk2OcRKUT4/LDZf5CKyF7yAdh++EDiIx0eEJ
2G0Hi8KeRfIpiNLNBqInlW6IfAC2demCPh/wE5q24yaoyVLuiGx+5DtyhyRsaz0kiCodhKFckE7Z
2qebZBtMnV0s3Nn5kouecsgR0skBhRLFJV9XQ37KrsMv5iz4ry/n4U7to4iyMAAAAABJRU5ErkJg
gg==',
	'bomb' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAA0lBMVEUAAAA/Pz9AQEBBQUFCQkJD
Q0NERERFRUVGRkZHR0dISEhJSUlKSkpLS0tMTEtMTExNTU1OTk5PT09QUFBRUUtRUVFSUlJTU1NU
VFRVVVVWVlZXV1dYWFhZWVlaWlpbW1tcXFxdXV1eXl5fX19gYGCLT0thYWFiYmJjY2NkZGRlZWVm
ZmZnZ2doaGiVWEtpaWlqamqRXUtwbktra2tsbGxtbW2VX0tubm5xcXGWaEuRa0uKdEuWc0uVeUuM
hUuKiUuWhUuUiEuWi0uWlkuZmZk+Pj4LvKatAAAAAXRSTlMAQObYZgAAAftJREFUOMt9U4l2mzAQ
1EoCUzD1kRoTx9jmKOWsabFLeqaH9P+/VAnLYBJe5j3xpNHsanckELqCidEY4sNdLueMdVtUjLLh
CGnEVcpLyLt2enjg7ZIfmxqTlgJ6F6z7BP0hkntUKeaB1gZaTVNyEJNt0/hwLzM5Fqex3MPmNmEq
dJjPRujX729Dyu5rQ7E+0Hvl6VSFhHO1hm3dCBQTAPMi5EZSVUdfAzB8Fco5COCJE027ZLoXxmnx
vJoWH98PyhP4+/NTT7CW7CNtdqm5g2tiNHR+PofBOW82vm9D1wRCk6Q+14XNOwpHJ9HWyQd+jST5
WTD1HnNKFZMJzbmwACxP9b4rqypfAhBnpxiw75eayGL6ykjeuoE1ex9fK+RA9Nnai9K+ZLY5RGm6
GtjDWqBR2HbnwI+vX8YEbYKL6PPTvz/f2YiCXVIJh9+iscP6hyG3RmpxH10Do9dgWlNTxzfWD0Cm
bpSXArm/Eq7xlzripkd5NeJyquxBl5rh3SLsZEohNGVgYJD+3ibi1CtqJTlXyZpi+ToXs5uGOF59
KOuzRFVEd5q8MjrbBbcSji0vSvI8CTcWBXEKptNtuLi1RXaAiUYIhvYXoKazD/2hsbwFYEw1w5yt
t0GUrF9YD5puLVab3SGI4zTNFqMvgZHJcp9lgWO+9lTYFc83/gMB3FHbxJTm3gAAAABJRU5ErkJg
gg==',
	'bomb_dynamite' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAHlBMVEUAAACAAAD/AACAgACAgICZ
mZnAwMD//wD///8AAACDYODvAAAAAXRSTlMAQObYZgAAAWpJREFUKM9tkEFrg0AQhccYW7ylQg/e
GmkD3goSgrcUttK9mcNSPLaYpf6CXnsoxdwU1DL/tm/dpDXQwV3efoxv3yy5RORjZRWRx1jQCVGJ
74F2PXk50ZpMQ5kviOYqlDnNtwzs3gO7CpuU2HQ1bq93pFS8on4W7clzVmhUxpTTnmy566N4qmuY
WXMtcye+IRKdGMovjpHqQE4cyz06DuSHsRHkD00xCjdJji7+N+dH+dyf1OXpsouq+7CqrutHq7Qu
oRZGZVCzoIEayky3y2skEAINAZSvlIpu2z3UlmYcZpj1QlHcLk0EMA4GM75fNVc2HhWiHxFKKc+m
Sd5RKU1LbVJ4nyGQs/NcbFIhthOgTX3+johXM6AU/xMnahcjqTJLnCiMwtyQAT0S642B8FA8ltYv
IQsZhWaSgpFP7QL8IlgrkI7xDg4As9Rj9o7BDWhDC8hn1eCePwDv6pCXU4DhCybjPp3Xmxx+AMK8
dC34B9RSAAAAAElFTkSuQmCC',
	'bomb_grenade' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAG1BMVEUAAAAiIiJERERVVVV3d3eZ
mZmgoKT///8AAAAJQmV8AAAAAXRSTlMAQObYZgAAAV9JREFUKM9NUMFugzAMteiQuHZfgAxIHKtS
th0rCFmPUdVI3IfoD1TbjlVoJH/2nAToIohenp/tZwPsACAFSN4VQMM/f5sdJCeIOoh+/TuhO4uM
PDI2We0Y5MvpXPAIQG3MobEEmN5OTmT4El6oWeN+SMqRXIKDpu6PAcjbLnKIUIiqd1Upq+QtIBRj
c1Feh1h0IZesClWqai5Hj/EjxGIiSj1SidHnEDWigTT0kENqPcrlrX5xyHDfeuOd4uH69USX4ACr
OnfI5HIobOA+m+CFXZXnODRBq4ItIhtcQaw1LCcpB6Jp2q3EnbsgZtNBLQpQzr3Rfb5oLBfDbF9A
slJMCDm0KWA3pxHmYvwZGhXlswHDjBxFW8AjLJ5ou33FrKr2apqZkp8Hef1u9cKsR4csV4d3I0Rj
+1T/7yVKjd1s2zcTaDlJLYY4D3kMWKf3xXkZ8To9z0H2uR1/tJ5L/AF1i24DpJ5rkAAAAABJRU5E
rkJggg==',
	'bulb' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAANmfvwAAABqlBMVEUAAQABAQECAgIOEhISEhIW
FhYiIh41KSk2KipCOjZGPjpFPz5NRkJeVipXV1deVlJYWFhfV1NmVk5iWlZjW1dgYGBiYmJjY2Nk
ZGRoZF5uYlpoZV5nZ2dra2tsbGx1cWpycnJ2cmt4eHh+e3N/fHSAfHR9fX1+fn6CfnaAgICFgXmH
gX6FhYWGhoaOioOOi4OMjIyTkImTk5OUlJSXlo+WlpaXl5eYmJiZmZmbm5ucnJyhoaGkpKSlpaWn
p6eoqKipqamtqqSurq6vr6+wsLCxsbGysrK0tLS1tbW2tra3t7e4uLi5ubm6urrBua3Cuq68vLy+
vr7FvbG/v7/GvrLAwMDBwcHCwsLDw8PExMTFxcXHx8fJycnKysrLy8vMzMzNzc3Ozs7Pz8/Q0NDR
0dHS0tLT09PU1NTW1tbd1cnX19fe1srY2Njf18vZ2dna2trb29vi2s7c3Nzd3d3e3t7f39/g4ODh
4eHi4uLj4+Pk5OTl5eXm5ubn5+fp6enq6urq7urt7e3u7u7w8PDx8fH09PT29vb39/f4+Pj7+/v8
/Pz+/v7///8AAACC+Sk3AAAAAXRSTlMAQObYZgAAAAFiS0dEAIgFHUgAAAAJcEhZcwAACxIAAAsS
AdLdfvwAAAAHdElNRQfVAQUJDTbxXC7lAAAB1klEQVQ4y4XQ+1vSUBgH8NdTdlNr3byl3bWt7OK1
pYZlaCZaaJYlI3QXQEoW7CCDghkOELb9zx19eh6V7dj76/t5vt/3HIBjw3F3b3a0X2SANhwXUHUc
l8NL7Z0UMZ81igU9i9VoaM7TcMFfpmmWjHwWp3/Is8iL5MqVaqW8a+S3saYIL5FHTXmvVq/tlUsF
HZOuRcQ3ktvblZplWbWKWcxhrEU/T7lMj1mtW7ZVr5oGIVj56m8kzIJ5NAUr4jTijxtGKx29JR0J
+10kauwevgjHNxYnXORd3ij9+fcvGEvy3GQjASabLxR/Fwv7IpkQhekXbrKh6blMTictajIaCviI
aCSvVLIkHVhVpMgn/3M3ASamHJC0FBM+Tg57CGAEMU5IOhkOrU6N7Qs38cXiCVIjrS3NjHoKYr5J
hCTEL7O+AeQpgAlHFKzJQmDiMUUAsy7F8E9xdWaIUgPgXO8fn9ciC2+eORQB6EEwY8tvh3ubaALQ
tUcjr+1MsB9RQ9jllG3vpN6zbbQQQFdvsYNP+7pazlB72JXvJGXzw1nqKeBcuvPwyf0brecdesry
lm2nVvqaqSHkFpZl7112eHoRnLpwpdtxzp0gSA46zfMnCgCe/y8Bj/1fCMKoKwo1G8oAAAAASUVO
RK5CYII=',
	'butterfly' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAANmfvwAAAC/VBMVEUWWDAFWTASTi0PYSwJYzMr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',
	'cake' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAJ1BMVEUAAAAAAP8zZv//M2Zmmf+Z
mZn/Zpn/mcyZzP//zGb/zP///5kAAACYp0nrAAAAAXRSTlMAQObYZgAAAZJJREFUKM9tkbFLw0AU
xh+KonBLCoJDl15D6eAgxN6ig8QbInTIks1BqFyMOghCb3GqGTrbIg0ZRQtZnUIXa5u65I/y3SUt
Kv2G5L0f7+597x0AavsNYPcYYOfMhVLf93D+DJzqRHYUj18OAeb12xEmUyMrC0m3BbB584qfiLkw
+whOgTdiCvuh3QZiGN7ySsjlo/77Hebf6QiP+O+fKppZQRydYDB/EnFqXfUwCqldF8MetquYnPNa
plx4SvBPubws/8LKCleWkC3NLD9Jim6LAZMPesIFthC674IFk4Hqu9FIByIeImw+oRV23cbIrLMo
HbZdaIambQUjjL6ckPP60Z4LpIKm7Joyc2EYRlXbW++vMJfnfzIpu6KTrRauMouh//INCOsw4ctk
3D1ZvgphWCCTZLw6RlicRgquiggTQTRRsCwilEUDq4BUzUzMHoviSQEdGxHORPGSAjrhgZ6ScruA
KRIPpma/jwSF0LGrOOOUcqevhbyqp86NCtWqGXm5Bu8i18p+7WVLb8lz1+4JfgCLkJ3DD/q+JAAA
AABJRU5ErkJggg==',
	'circularsaw' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAALVBMVEUAAAAiIiJERERVVVVmZmZ3
d3eIiIiZmZmqqqq7u7uZzMzd3d3u7u7///8AAADgruDYAAAAAXRSTlMAQObYZgAAAdJJREFUKM91
Uc9LG0EUfgZkC62DBEIpQtGVhRRxD5UiYWkuPRU9td3GHDZQPdlgWXqZ2x4CRUUayDYWl4AH/4Pu
Qoks5NKTJBehKEugbFdkjD/e39CZSdZKoe8w8+Z7v773DQABgGmAzCrAVRFSIzWY0EGdlA8cR37u
eiWAiUGjaHOkY6eZ02O8GusUiLWGQN6EJYj7rVM4OOzboFQ24Y6N6/Ji+uAhMuENzMhzpZdsd6vZ
WHTVWquP1k44hRWrED5fpABK4ltPd6isVSilf1nGqZcMO3MCOkpqLB7gRxlGdaviyBlHWuShqH5Q
23jZKIkoMX/+KLxSuJfRWgudx6KWWC/a2XmuxT20lhpBh9pwH9fLQcB41K3Ovf6WF02I+2R2ti6H
OftOmw0VofYdfv/aeeWWMEEJzCR6qiRmUAAME5Yiiwm6Kl/ISZPI9X7e7PW2WaIPp5CjT9pG9GUh
V8bR3Os9rXy4HH7/mqvgqEg1+81eNTSyaU6irkRL3Wc1991ZMR7qeP65GXZzv33t7QexyU39woya
nhcGxi9GuQIkf+NqaqEVGMdTdSplulR931fnj7PGDht9jnP5flc/M9ptRtO1FIdRB5HeAgKzxT/+
T6U/eKC5wch+2eEAAAAASUVORK5CYII=',
	'control_panel' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAANlBMVEUAAIgzZsxmmcyZzP+ZmQDM
zGb//5n/zJn/AACZAAAzAAD/mZn////MzMyZmZlmZmYAAAAAAGb6ZwkrAAAAAXRSTlMAQObYZgAA
AVpJREFUOMu9U+F6wiAMREsSOyGG93/ZXQhFrJv7t7P64XEJCZemlBOQmVlffgPZd5krJzblJCw8
NgjIvp251qojsNBdPFgHRgZg6tnTm+TEWmohXwgb9QXzZfctEVdhkWaeCS+Pmc5EQHoQGFJC2KMa
yNxLUzU8ZgRRMIBhv4IRZ8Tjt0b7zaQz6esVaxnL+YCtRInUT4IGcmBKouLQTqYogcNZYHoTWsGI
BFMKbruaodHBPEwrvua9B8O9J/UmJiOVxJkjM3PbTMqNFk27mtz3hRGJJ5jzZSw2v7v0GXl2S/aH
4DdRLp9g70n8frxIDEDMidu5SrpFrBhmozF/3mRItBR9HMmnBJO0SGo3y98G1RKDdpIQWDGDfzhq
zKJf8SKJiYCEvN56SGYt0v/j01pDJ7Tv7lg3aWYZmrZdG+L3+20/0jwPCk3bLk/JmuWY1Z/RzT+7
/4b0X/gGxbceU0xn1t4AAAAASUVORK5CYII=',
	'cow' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAAPFBMVEUAAAAzADMzMzPMAABmZmaZ
ZmaZmZn/ZsygoKRmzGbMmWaZzJn/mZnMzGbMzMz/zMz/zP///5n///8AAAAwnJN8AAAAAXRSTlMA
QObYZgAAAZVJREFUOMt9U4tSxDAIjLVyEZVE9v//VV5p49woNzdNNwtZlrQ1NA+oP8FCtpROrZFF
bDXGA01ZpemErA3LyNSmUFsbphY4rYQVGkNFskCdYAmR9zAyO2iAHl5EmQGx8t0L+CIq2gLAGJCe
ckoRGt1lM8gTLsF+GEKMySLOY8ERLlC+XGLuextd5INCToYf7eLRDZMxZrQV7ThleKhnySZkkxNm
+GOHkGo2SEPzeuUHUtKDKxO3HgLTMtH/ofxod182tPP49nNtOxtV0UNyLJnl1uIdvzoV68sQ1bt1
LQQX0gNJOdPM0MqyOTHP6VBltaQEIomsydE2wTRkN6c9B9Kv3IyXP0gl09lEz9toV7eU7zGsOjLs
u5z2OgGQb9RF8xZuy7SuOznI1wCRkcNYbluUL0sqODgAF6ULwiiqG+H186ZyXgc5z5uSt7rrFvCR
qVFeP8OuJ0JSfIhVBapbN8s8G/O5U26WT9w+VJcbU11aoiGTKWPOnHl1JL87Qn875nSSf0kaHW2U
ihcc9ss4F3iUvfRv/ADdQTW5QWF0YgAAAABJRU5ErkJggg==',
	'defrag' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAAM1BMVEUAAAAAAIAAAP+AAACAAIAA
gAD/AAAAgID/AP+AgAAA/wCgoKQA///AwMD//wD///8AAAAQWuKnAAAAAXRSTlMAQObYZgAAAaFJ
REFUOMt9lAmShCAMRaMQtoDm/qedn4DazoZV2vV8hixUExFFohCUhEKLg0i3LKDkN1vpIKXEUSjl
uFgIxwHVPk3M2oaxtG85SrcPNQW9A3gQqnOrlLSKRU/cqpz2ipuWEyxtey/aO5y9q3oS0FccueMd
86HRswkJ13FUvVlIKbGC8DlmISDcGitqaGPMr7AbSClRJee8yJ57VhDsZkkqIl3kXqAq8qrOV7x/
nSvDcs4H8quTjYlScFYnsoSwkfW0etgxxAmzEeZVvZGzcRV1NL9CWVwjXchJ4+h1ySI7CECUWakR
r7REyb2jtkl6NmKlC1nlGIc7T93ejYdMFsKrPWDhR39+69e7efF8+ofjFXCvaNrxwKHlkWCU2bLD
tDn9t2THIJkW1C29cxiKSy7FrVthHkvyPiwFfW8+DSja+LwkuTfyA2aa+kaf0qdiw7FTV+ygehry
UrZHiRhi0TmOl4JR7abk4nHUx+qTfSk7UMd4l6K2noo2d0zIeSk+prWbalraN+U91UvLGS38TfnQ
MDJL4M+jYJr8856+/w9c6wsOtRik3rUhLwAAAABJRU5ErkJggg==',
	'disk_blue' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAC6FBMVEWAAAAAAAAAgACAgAAAAICA
AIAAgIDAwMDA3MCmyvD//8z//5n//2b//zP/zP//zMz/zJn/zGb/zDP/zAD/mf//mcz/mZn/mWb/
mTP/mQD/Zv//Zsz/Zpn/Zmb/ZjP/ZgD/M///M8z/M5n/M2b/MzP/MwD/AMz/AJn/AGb/ADPM///M
/8zM/5nM/2bM/2bM/zPM/wDMzP/MzMzMzJnMzGbMzDPMzADMmf/MmczMmZnMmWbMmTPMmQDMZv/M
ZszMZpnMZmbMZjPMZgDMM//MM8zMM5nMM2bMMzPMMwDMAP/MAMzMAJnMAGbMADPMAACZ//+Z/8yZ
/5mZ/2aZ/zOZ/wCZzP+ZzMyZzJmZzGaZzDOZzACZmf+ZmcyZmZmZmWaZmTOZmQCZZv+ZZsyZZpmZ
ZmaZZjOZZgCZM/+ZM8yZM5mZM2aZMzOZMwCZAP+ZAMyZAJmZAGaZADOZAABm//9m/8xm/5lm/2Zm
/zNm/wBmzP9mzMxmzJlmzGZmzDNmzABmmf9mmcxmmZlmmWZmmTNmmQBmZv9mZsxmZplmZmZmZjNm
ZgBmM/9mM8xmM5lmM2ZmMzNmMwBmAP9mAMxmAJlmAGZmADNmAAAz//8z/8wz/5kz/2Yz/zMz/wAz
zP8zzMwzzJkzzGYzzDMzzAAzmf8zmcwzmZkzmWYzmTMzmQAzZv8zZswzZpkzZmYzZjMzZgAzM/8z
M8wzM5kzM2YzMzMzMwAzAP8zAMwzAJkzAGYzADMzAAAA/8wA/5kA/2YA/zMAzP8AzMwAzJkAzGYA
zDMAzAAAmf8AmcwAmZkAmWYAmTMAmQAAZv8AZswAZpkAZmYAZgAAZjMAM/8AM8wAM5kAM2YAMzMA
MwAAAMwAAJkAAGYAADPdAAC7AACqAACIAAB3AABVAABEAAAiAAAA3QAAuwAAqgAAiAAAdwAAVQAA
RAAAIgDd3d1VVVV3d3d3d3dEREQiIiIREREAAHcAAFUAAEQAACL/+/CgoKRE5o8eAAAAAXRSTlMA
QObYZgAAAMlJREFUOMvVkzsSwyAMRKWD6oCMmy11K0raSPyMgdgzyaTIK7BYFhAgEzEzEUuEEAO9
JTHKoEoCqamlKQMqEpP1sh1lom6iApF1BAJtAajOuw20BVKx7RQexGjL2HJ0KkhSN62K0xToSfOM
fKxcsHQ8eWkZBvCg+CcAvCqyV456iKMrI1m5HGv2hB8r+uzpLze8IHzirIv5NV8gLZZo/VQsqKZb
S76JZ8sml2SsFoQNuFreM2y0I/yrJZfcl6tM/8+M1wutNTRV1Aul+2zielv6iAAAAABJRU5ErkJg
gg==',
	'disk_blue_label' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAYAAAFNQDtUAAADTUlEQVRYw82YMWvbWhTHfzLO3Jiu
z4+iLUNJIdOjFGuwt7eqAb/hQaDR4A+QrUOn+AN4uC4YD6FQ5yNkkTElkx8tHYKHK0rcNdiBZjAO
nDe4V5YsyYnShPS/yOhezj3nnv/5nyNbAL7vCz/hOI5V7HaPBKDVajEcDlFKSQGgUqnQ6/XQWgNQ
IAUWgFJKYi+jhwAUyuUyo9GIcrlM5eULkPlUDHzfl4TxYrvzMf6m2z0SrbXIfCq+74tSSrTWYtu2
yHwqSikpAth/PgWg8vLF4jBAj/5bmjY/vC9PEgHVf/Tjm9ROMup+PyPQKBzHsZD5VLTWorUWE4Dr
uiLzqch8uox7MDjl7OwrAI1GY3mXMp9mHrF0tPgkffX6crHBG6avq21zxBoLBWtjc50LWKsMSGzo
do/k33/+Jji/IJqj4PyC8XjMt2/fefXqLwBqtVoiZ9bGppXgSHB+Qf/TZwaDU0ajUXh/AAcHB8lg
DUOiGAxOmc2uCIKAIAiYTCbYtg3A/t4uzWYzO5wESW/A/t4uAO3OxyXD9vd2sxNIGvv6Ia8L3ANi
d5LFlDTUs4y02zmM1NcoRx44jmMBC3FxXXehFiJiitD3fel2j8S27XCtWq2K7/thQQKSerFRps5m
V7G1nZ2dVLIljEQNBEEQW9vaep4aVsJI1MCqEVNDqUYmk0n4YpXyQEh780zQ/iYtWisBG5sopZY8
uWvthGR7XX9Dr9e7vYXry/UX+0u1k6du1HaGkbRmkx0Ov3M4x8fHSO/u4RSNilve7W1Ia/F0XTd7
PMnNXKP2hnSHh4fhom3bCWKZJjcej8OCBXj37m24x9RcqVQCoNPphKIeLRkTREJi1yHLgdnsimaz
ycnJSSyAWq1GqVRiOEzPusynWBubopTC8zyr+CsOAAnZigqpbduZjtzYzdMEd50DWY5sbT3n2bM/
7tZC03CTA1FtXhV0MyzldqT34X2YCnNYlITrYKawexkqoiOfQXS8e0jEdPF1/c2DH9j/9Pn2HEn7
BrkPqO3LfGTN1Xry4PqWqXlMpKdmyAOlht8/NcWVJgQf3j9uarTWtH9+WOSZCfLAzA+Zf3W4rium
a2b1jvtCo9Gg1Vp4VK1W445Eu+BjpMXzPOt/JujmpKyAKyAAAAAASUVORK5CYII=',
	'disk_orange' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAHlBMVEUAAABVVVXMmQCZmZnMmTOg
oKT/mQD/zGbd3d0AAACoXWG/AAAAAXRSTlMAQObYZgAAAMdJREFUKM+1kEEKwjAQRT901aWb4lIE
sy7kCuINRlwXO8EL1BNUXJaKhdzWTNKmrQoFwU8zvLykSRikFnhmOToOI9E5bIPdDYrl0xotrRlu
kd1yO6nWuo1MZSGF4dxHOUjRLugU0Yp4A09ZLQcIEXkqthLv2GeJbAgALuXkqgnEVF1GyqfE7rJj
IB8hf62KzvxE5y8u0SHSVVVSH1O4Z0aTcU2GRc2NvOzd6GhO99GY65CqN7OEv8a5+bPZL+9J7SwP
jdiqoWMvIEzWsdImn/EAAAAASUVORK5CYII=',
	'disk_red' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAYAAAFNQDtUAAAB5klEQVRYw+2Xq1LDQBiFv23DA+CY
qSuPEMUMuKIi+gKdoYq+AhIZi1wXEVdVEZU6BCq2LnWZ4S0WkQvL5t4E6DAc1U42Z8/+l7N/BCkU
nxBTQHmez8XFlJfDgVspnwWgQm3ZUUomVMACxFFKnRNhbjJxAc/zieOYEJRwQdnakhK5dSklR5PU
Ba48H4Ag2OG6LsfrawDuQZSEmygOEtGMCR1gHrT0XITZgiQTPVuvSDyf2XpF1LaNDRQMJwsdYUFb
sErJqgxUmIXd1uKRIwh2ADjOsohTnqan9P1uKXncbrm7uynFMQQlpVRWG4HjLEmcJcnrW/15deYI
IJNbh3dtfYkkMh70wYQRcD4kbQ3V9m76Q28Zs9Cqiu1hvWKfOkhBZHUpNIAkI8kRpkQKEINjIqVU
42dnVlGtied/ManGsm8i0rFvIol6yLebGrArFoaiP9Y7Z0YSjUFij+AnSGM8OcmU9KFCN+wqf+mL
2XpVFGd24X0xtNr+64sg2BW+BTCPY15r7rns0iQCZQoapUr6IhdEdpP/mpAqkx6cGsdZMnfdwWKs
qrAt8j8tfl2HeQdf71Ss+19IT6lGom/cbPHd3no2Jv8v5E8LsX6iW3pFxB5hHhg8Swz4Phl6x5Q/
dMYYbk7FZrMRH0VWmCOlYIigAAAAAElFTkSuQmCC',
	'disk_red_label' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAYAAAFNQDtUAAADVUlEQVRYw92YsWsbWRDGfyuk+iSu
PYWwTXAREvA1IQRtIXXXbgS+4sAQq9AfoO6KVFaRUsVTQKgwAetfMAcrRHClkHBFUPGWYF1rtIFz
ITYwV9i72tXuSllHJuS+RuK9x7yZN998M5IB4DiOcAPLsozicHgiAL1ej+l0ilJKCgC1Wo3RaITW
GoACKTAAlFISW4xeAlCoVqvMZjOq1Sq1p49BfE8COI4jCePF/uA0vjIcnojWWsT3xHEcUUqJ1lpM
0xTxPVFKSRHAvPczALWnj68vA/Ts3cp0+O3DaSKg8b8P1g7tHyXDHo/TA43CsiwD8T3RWovWWoIA
bNsW8T0R31vFPZmc8/Hj3wC02+3VW4rvZV6xcrT4U/rul883B6b99AOPmjdXbLBQMErlTS5grDMg
cWA4PJE/fv8N9+KSaI7ci0vm8zmfPv3Ds2dPAGg0GomcGaWykeCIe3HJ+O17JpNzZrNZ+H4AnU4n
4UXIkCgmk3OWyytc18V1XRaLBaZpAnB02KTb7WaHkyDpFhwdNgHoD05XDDs6bGYnkDTyjUNeF9gB
4m+SxZRUPMgw0s9h5OBVtnLkgWVZBnAtLrZtX6uFiARF6DiODIcnYppmuFev18VxnLAgAUl92ChT
l8ur2N7+/n4q2RJGogZc143t7e09TA0rYSRqYN1IUEOpRhaLRbiwTnkgpH3wmaD9Ni3aKAGlMkqp
FU9uWzsh2Z4fvGA0Gn29hS+fNz/st9VOnrp51MwwktZsfrhwDPE9MUplRCR3ODGedDodaP369UZ6
fwFg23b2eJKbuYHaB6Q7Pj4ON03TTGQiaHLz+TwsWICXL/8MzwQ1V6lUABgMBqGoR0smCCIpsRuQ
5cByeUW32+Xs7CwWQKPRoFKpMJ1OU+2J72GUyqKUotVqGcVvcQBIyFZUSE3TzHRkazdPE9xNDmQ5
srf3kPv3f7llC03BNgei2rwu6MGwlNuR0ZvXYSqCy6Ik3IRgCtvNUBEZ+QJEx7u7REwXnx+8uPML
x2/f5+DIh9O78WJNk7c7kqf15MGaOO68Ze1+Ar7VJPw/S01xrQnBm9ffNzVaa/rB74o8M0Ee3MwP
mX912LYtQdfM6h27QrvdptfrAVCv1+OORLvg90hLq9Uy/gORI+2lTUat5QAAAABJRU5ErkJggg==',
	'disk_skull' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAG1BMVEUAAAAiAAAiIiJ3d3eZmZmg
oKTMzMz/+/AAAACkjDedAAAAAXRSTlMAQObYZgAAAQVJREFUKM91ULtuwzAM5JAhqxZ9QIdk7ScY
BZHOBVLtRFS6HxAoa4bE0GeXD1u2AvRgE6fjSzrYV4DHcYApys8D7HCAeodzgcTwFQERnngsIEmW
9NMjkcRapZAxXzQwSEYCxSXo8RSJZYQMmRLiB5Z3MHa4FhmgDNHYz7fCNOZoS6ZELO0vGhtsuQIA
OCO+Id+dMfLvyoYtY1l2cmZQZmuTayHw6EzWzkxe4ixSpP+ymYN0j22ysh061NWU5wOWi1yzKQe+
yutV6hW92auCTfm85aaMtwWL0sG72N6mBo6rQkGe2yvm9lYR07suCvO3rQm01mByU7rJlpc6V/a1
wwOhWbU49gcvFc5YAZl8CwAAAABJRU5ErkJggg==',
	'disk_yellow' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAG1BMVEUAAABVVVWZmZmgoKT/zDPd
3d3//wD//5kAAADuc2oMAAAAAXRSTlMAQObYZgAAAMNJREFUKM+1kEEKgzAQRT+u3HZR15IrDO26
UMkFpL2AYdIT2K20Ijl2M4lGbQtCoR8zvLzEJAxyBzyLEgPHkakSrsP5Cs3yKYWe9gy/yH65X1Tn
/EamxkhhePdRtBTlg0ET7YhPCFTUcoAQUSBTSYLjkC1yMQC4kZPbLhJTe5upXBL7y46RQoTCtTo5
+xOZLy5TMdJV3dAYa/wzkym4Jsui1kZe9m5UMofLbOx9SjuaVeJf89z+2VTbe3K3ykMhtWrq2As1
Tcl0PH3t1AAAAABJRU5ErkJggg==',
	'error' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAD1BMVEUAAAD/AACZmZn///9gAADt
zF8pAAAAAXRSTlMAQObYZgAAAPVJREFUKM9dko2twyAMhGmUAd4BAyD0FrBYoETsP1PPP7RNLSVx
Ps7mcJIS4wFe0uyZmpKEmoA0s70DTwpKgd9JJnryOGHF+EsYwqLC25SR2QxZS6k+WiiXlUxoGBmC
oTKKxwBq80w0O1HgqwptkXGs1Vu6xzKDvkWktkXdSNTFg83K0OVJl9wjmxXdNzKJrARjhRTB5bWw
LDr3fY6sZo6Nbv6Ob6OL8e3Zh2AWP9Y9njfF5+gE9A83Wt9k+MTMgHUhMgD1631LAFwtiGpuhIri
6GoxGIn2VQ9y2hy1l0r6r8M469pg9f2H/Btb1xvoZCx+v2PEC2oELiZOaMTkAAAAAElFTkSuQmCC',
	'error2' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAABVlBMVEXLy8u8Mja+MjXEMjbGMjbI
MjbKMjbMMjXMMjbOMjbQMjbRMzfUMjbTMzfWMjbYMjbcMjbbMzfOOj7ROT3MPEDkMjbmMjbQPEDo
MjfpMzfrMzjSQEP1Mzf4NDjmPED9Mzf/OT7/O0DQUFP9PUL/PUL/QUb8REjwSk7/RUr0Sk7YWFvz
TVH6Sk/2TlLyUFTcWl36TlLpV1vxVVnsXGDuXGDuXmLxX2PmZmntY2foam3kbnHqbnDicnXkcnXm
dnmZmZnken3le37df4HWgoTgfoHhgYPchIbfg4XmhIfkiIrgiozkiozijI7oio3ijpDkjpDikJLm
kpTokpTllZfqmJrknJ7mnJ7onqDooKLmpKbrqavsrrDrr7HrsbPts7XstLbtt7q8MjXwvr/xxcbw
yMnyyMnyzMz109T01Nb11dX129z23N323t/55+j77e767u789vb///+d2kzWAAAAAXRSTlMAQObY
ZgAAAi9JREFUOMuVUlt70kAQ3RaTgQYlvdBqCy1pF00rWrSKVbQhvajUS43F21pRUIyKWvb/vzh7
SQh87YPnYTI5Ozuzc2YIUQjDEG3AqUeI7/uC8vQRyTBmksY2dQj4vhedWN8GH0A47xln/FEBPdfl
lNN5cWzutTa8OINEaTBYFN8THob8FiHAOMKZJHYj4JxSg4ArGBev7XDf57Pi/kzrGFSeRDprKmsD
DFNPf/6j8FCRsN7FRKwrKnQtcS8bIER2jn04JlJQQUiGUuqkRNByDf9qNWl1Udh9obAwEZf3Jk0j
5Y11NwYrY2eTL7SuvDkdDH7dgwsRcVM/+UcuJYmplZChMqgN+66KW19EF11pHpuCKTCpmdTNEUFw
J2pL9CU6hbuNIHgWtWUjk16LGkWqLFPPu26Ux3UlA6praZY7svwsjgBXAc0O6GYXtBi7EHcPG8et
1t6MkZDDSxlGZ0wf7xy9MhkASJ+n4kUrmy+Ubh8e7jvFvHVGnJVbefn7VOEv4tO1HBgjAZeuf+33
GetHQPfngxwMH5O5/KrXk7KynoB2TxbjGMg/b7fbWi/Wjkbw8e2TfLQlsP5Ogiex7yBKIFeLgH2/
2WwG8RrqCVEH19FW6kH2xrYEpSMhApYWGIpXJUYK4VjL5SJ0dIhVqVarw/vaq1YrIol6cBq26vW6
oOsKyt0CIzEnWDp4OoaDJZgYnSTA5tHrGEebIAPGZu2ZOOW51dU5/MjVOHMZvCTIf+AfQGjOcWf+
ACQAAAAASUVORK5CYII=',
	'error3' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAB0VBMVEUFBwMQAQEHAAAhAAAyAAA6
AAAhEQ1LAAAYGBAXGBZUAABKBgghGBlaAgAoGRdrAAJ0AAF9AAAxIR+DAgCMAACVAAKVAA5kGBef
AAAxMSowMi+lBACtAAGlBAU7NC+3AACvAwu3AAe/AAC/AANCODnGAQC9CAC9CAPQAADPAATHBAlU
OS9jMjDYAADeAQDJCxPoAADcCAPLDw3pAA3xAADWDgq1IB//AAjgDRn3BgCvJSivJi//Bh2TOjLv
Ew/LIyXmGRb5EBleV1H8FhLrISH/Hx7/ICbDQTnzLC3YOzt9Y2KUXFT/Ly7VQ0j5NDj/OS/ZR1H+
OjX/PkTlS0zCXlveUlGacG7/SEzZWGKCgXn/SVL/UEj/UVT4WVP/WFboY1yegoH4YlythIf/YmDW
e2uZloisi5L/amj6cWnWhHz/cnK5k4+koJH/eXvnhX3Hk5Pwh3z2hH3/goaqrZ2uraT/jYuUvb7K
pqf+lJSzuqmew7//nJm7wrH/pJ6oyMv/pKT3rZr1rqfHxqrFybnwva/Dz9Cr2tfR1sTpzb693uHb
18jI3dzc38/o3dDI6ezm59Dk6NfY7ezu59Lw5+Dk8N3u79js8N/R//nm9vb5///+//zFwHZ4AAAA
AXRSTlMAQObYZgAAAylJREFUOMuVU+1P00AYP/CFoCKbvWKlV0rR0hWd6yqVonEuk7WlhMEGdAID
gaHgdIokGAKRaaLGxWQJn+Tur/WuFcS3D/4+9K6/+z3Pc8/LARChPJyn3wRRnwJwT4aM6v1xBKZG
MiYw3QEZCJLLjm6EFvv7m8wGZGdwghgm3SGZTGNZYCSEPMc9Baew9aaxXQ4N/UcjEx4AqTxeOSBW
D0hlEwSr6hAQtT2CA9QNgEQQIhyNMwF5yLWHDvp6T/wVq/X6RunJ8e+r8sZ2fblUqSwWMiHhecXP
ODCM5Fu8bqdylNHsbNrFhNBAaVPrZ4yu6wNfCSYrqoYkgeWN0AGhgScxXhP5MGjACzwSRYEmA9uP
w8UhF49z5zpfgn9iq1R7U1vyfhJObbfxbqdWKYwfEzSFarlUWSh5D6M7L1Z8Z2R4dCTnOFmfMWPF
Fdy8bRg++XzH1lieXn60hVvJeULmLDNFReNj2XT6kCZBZhJ6SrkCgKJZViJ5RMi4qpuqdB4AVxnS
Ez7N/HBQva5JnQA8R1oiRxUYN5EiCZeoaxEFmEzLqIW/0WRZxe4JAnYRQgK+y8O28IoihLQUggAh
15GL0oARuHhH33GqtyBH0d2WO1UPv+9an/9nmT5urS4tVBaXNt//tYofCqVqfWe/0Wjs1DeWy8Wx
9d8Em155tb6zu7u7Xa/XahvV6nJpynl4OkC+sFCprq4ul4r5/CPHKRYLhami52UfnHRqjHFBsxkM
Gwyj6dze3oSTydp2T6T4Ynt5J/+4SYvcDGg7dH+PbvGcYZsp82oombNtw8lkjMkWPWmtrTEtmUlb
lqVpihg+l1RKs+5kjWRSn2yREHhG1VXLVBVNUi6zWbqraaqpW3oyef3ZUah4PaBS6NSH2H+eTf+s
ogwOqWpC9g9w5IUcBjJtqywJEhdNpCAheRBFAlfpnz5idwokJPK8cC7q0guZR9L9TxgTF8mKIva7
bIbu8zzkL3TO/6iMxFO4s4KIRDoFSOyZdeO0sfDsiYI+TzoL1AiyqaBrD219nOtq7/3l5QcxntHM
NlxjZ38TRLh5sas7Fot1dZxpv5SbB/+B744u2u4QJBlwAAAAAElFTkSuQmCC',
	'error4' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAANmfvwAAABLFBMVEUAAACDAAC8AAC8AQC+AAC9
AwC+BAC/BgDOAAC/CAC/CQDACwDBCwDXAADXAQDXAwDGDQDHDgDmAADXCQHJEQDLFQDKFwDLFwDM
FwDLGADYEQT+AAD+AwDOHADYFwfQHgD+CQLSIQDUHwnZHgrUJQDaIw3+EgbWKADZKgDaKA/+Ggvc
LgDYMRDeMgD+IQ/kNwDlNwD+KRTfPRr+LxngQR3qPyL+Nh3iRCHhRyDiRyL+PSPiTCLrSCjjUSb+
RCjrUC7lVij+Si7nWyzqXCD+UDPoYC/+VTjqZTH+Wz3sajT+YUP+Zkj+bE7+cVP+d1n+fF7+gWP+
hmj+im31lGb+j3P+lHj+mX3+nYL+oYf+pYz+qpH+rpb+sZr+tZ/+uaP+vaj+wKz+xLH+x7WAAACt
xDIzAAAAAXRSTlMAQObYZgAAAAFiS0dEAIgFHUgAAAAJcEhZcwAACxIAAAsSAdLdfvwAAAAHdElN
RQfVAQUJCiajqqhGAAABK0lEQVQ4y73RV1PCQBQF4EMinVAEVIiANAEBO4oC0kUEe+/t//8HZy4x
zmbZiU/etz3z7czuPcBfZ42P5tnjerfMiVKYEVefw6JBbJ42Q4z4eB/kDeJkXA8w4u21nzOI0XHF
r720S+LluZMxiKPDlGcSlIcknh5bSYMouH8uFQckHu4bCYEA8n0Sd7e1mEAAuQ6Jm+tqZG66ADIt
EpcXe7sCASQbJM7PhAJI1MwEEKuaCSCybSag/6WXdU0X+j567YO000zs78TtZmJrI2oTikKWxOpK
0CoSbleaxPKSTxYIwBknsah6ZYEA7FESqqpIAgHYgiR+zUKJ26nVp07GoZlwk9u67CUxO2PRglCd
60VWSHzpQaDCNScpjAD8Ka5bycEIwMNXIlnwz/MNgk9owgidMToAAAAASUVORK5CYII=',
	'file_cabinet' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAAOVBMVEX/OwQzM2aZAGZERERVVVUA
uwBmZswzmWZ3d3eZZpmZmZn/ZsyZmf8z/5nAwMDMzMzd3d3//8wAAAAOpC/0AAAAAXRSTlMAQObY
ZgAAATxJREFUOMuFUtuWhCAM6wI6iDtdyf9/7LblIipzJg/aE9L0AkQEkHy8T0Q5h0TYGRKnlJTX
U/goR4jEHGI7+VOoEEvO2UdJ5OPgECwSALE6FBNLkHSWWp4lWCCmEsivBJrPQQPeW6BGrB0mAymK
VW+AiqwgWlHCuq5aVyspYzWsDmAMegZC6IxzyoST8dqrMDVLuhhqofZTZ6yDUlvO2OFARGMw2FTG
2lWgMb/r+mN0Y97Lq4zRmNzxZFCYsw5CYw6Bt9E745y7M/tuTPfxZRs2581ZGd1GwnM9aQANGK5x
3NdXQZztfUSMg4QnAr5LZNGyaX/iLlHkAbhJ8F4Ur17iIbmkF4+sF9sl01GyXsgp4QfkUsNDctRD
3x74TOK2bdtHCb65XFY37eW6XXyEvfnyHOT7QXR9L2kOPfoH4Z02vEuYtgMAAAAASUVORK5CYII=',
	'find' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAG1BMVEUAAAAAAJkAAP8AmZmZmZkA
///MzMz///8AAAABzOueAAAAAXRSTlMAQObYZgAAAQpJREFUKM+lUbtOAzEQ3MIk/EB+AOXQfQAS
lBYsZ9eH4lBCOPlSAooylCCdkvts1sZOLKBAYor1eDz7sE0kmL4RTbZEylGG0bR+psl73DAH0xMe
ZLndh0jq4GQtZ5eQlA6apkYCXYfweK7DMf2EAWwk8LseXSiH7gKR0eloEyMzqxNTPBt+q/QdzNkF
hBkEzT2wiTXcoukRbnTiFntgiIwTU+7GfDGyu3li9NqaxFDNE/Or1g9pqrNDP6Xpn5D2yA+TLtMH
xWRJLZ27k3ExjmNKWW6du4qJay6UxnuflZg1+EIhFostPbHXqm5KhcymamuDUsFLlI6KTPJRtRK5
/AI78vEj0uz894f4BEhTXWDdOiNFAAAAAElFTkSuQmCC',
	'floppy_drive' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAFVBMVEVwAAD/AAB/f3+ZmZm/v7//
//8AAAAIGlEzAAAAAXRSTlMAQObYZgAAAO5JREFUKM+tUcFtwzAMPLhFJsgABS3pLcATlKA9QCBm
ACfR/iOUlBKndT8tkANsnI8nHikDA4CYESTjUNFBQIEw6qV/R814l2C2eL4xNpAZMZ/6K8iyQuRz
xFx1RK2P0xuC6invGRNbW1WlVMnnYLJntIo42JtMDXnXzuLpozM7Xje25B0rT8a0+CoiJQRj6rl1
TRnFw458cUbUc61p1eKs9Fkm+Fq+mbV761Phr4izp5X0W5n+p7RZxJWBGqLwla7uGXpNTKGu3N2y
3Ad/KvarjkLJrjWaOVlxJbt68sbu8eC2d1PoO1Jbe/oBvAxfOLlYNVe8/jcAAAAASUVORK5CYII=',
	'fortunecookie' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAG1BMVEUAAABmMwCZZgCZmZnMmTP/
zDP/zGb//2YAAACgQ1wmAAAAAXRSTlMAQObYZgAAAVRJREFUKM+NUUFuwjAQXJqq5GoVQa+JEOox
kiXEsVDLzQOwzyDZGx7Q2r22oOBndzcQFVFV7Ryc2Ynt2fECEIYNQO4rGIygR/sIcwuD+67Id7Qc
7AQrADRbWjNZ9TsT/bwLegNqHRAWR48Ab3YHN0LsAaSEH8gxhtk7kdtG22VEuuBzikQsG8A8eINs
kqMhsmctKZW+LX9H3mI6kSa62YbJS8DVJHCkV49FxCfK4O22CVizrxsHb+sKskWKaNY1mxyDMYpZ
Tq2s1TOxoTdKTTnMhxBlwRJkXVedXSblf9q7ajalyzIhxhgRezG5hktVzuLuNBMdAyK6YkxflnIX
lDHWFRMSHNJzH5TzRjvR0EGPmjOkVBZiTDd5ek2suV9qtqUTJFjtHk4J2m6DsaiXe3kWDAtaL+su
W16WqAmrclSfx5qEKAhTeoZ+zlImAjlcDv6q/ANfNL9t4qKmpTIAAAAASUVORK5CYII=',
	'garbage_empty' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAIVBMVEUAACUiIiJERERVVVV3d3eZ
mZmgoKTAwMDd3d3///8AAACW/mpkAAAAAXRSTlMAQObYZgAAANNJREFUKM9jYFjAwMDWjMCsoQwg
wJIARawBDAyrVgEVMaS0GcDJTDDJBRTmAklytTkGYCdmGAP1h4YGgBVCzGHgypzRlmIaAGJluLUk
mjKQwsqcUeYMZgGdtQBCI0wGMVYtBbu/siMtGcLKzDBxgbOcacPq9EiD2tHZngIRA/oaCBhgYElH
ihacw8Cl4pYxoy01xMVYaQFMQXpHe3lamouxFSi0wCIZM6d0tJmlOFvBjFmS1umW0eySIjyURNJn
zujoSEPyBTi+wDEFDx7WUCgAeR0AjRePGBi7ZFwAAAAASUVORK5CYII=',
	'garbage_full' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAJ1BMVEVzbWEiIiJERERVVVV3d3eZ
mZmgoKTAwMDMzMzd3d3/+/D///8AAAABLJrUAAAAAXRSTlMAQObYZgAAAXZJREFUKM+FUTFPg0AY
/QbapIaprg7GtBsTxe5tDyoJQ4eijja2IO2sFh3VqDMVPBl1wc3EDpWlg3Tqj/K7A1o1MX4JH493
33v3uAOYA5Q8fN4AivgumMBq4wjaBiQqFDoAyyUOCcHLFnZ/gh3Gpyp2EWmRLQpBYw6l2N9mrZq2
YqCoIJ61UG+aHT7IfRANI/+4ihQsnD2PKAzp4eVMKyccjXLkOjRFAvWvexKbEy2r29zlESF1++7M
wJIJQHilVoujxbCtEJYWnceTnsRNpuEz3/dfdOFl6MHNk7rOJM2ycA6UlsqQ8HhYb6b7Yj6ZI/xr
LMjrkw6k1QeIFc2Z+YMuqe3M8wGHBueWRWSJnVbKPEU6rfdrRmYj6n74fuKR/mYlyV2duB1GitaQ
Da4SNT+cuvHHeugn0/mbceLoF2NHdM1gHJvuu1TRerKRRhR1mz7YHrEalSSNiLL7G/uK9MuZCGWj
2d2tNSC5KLsvflOr4ymYWbGRL8wZuDUYxYAzAAAAAElFTkSuQmCC',
	'gun' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAElBMVEXItMgAAACZmZnMzMzMAACZ
mQAwxA3pAAAAAXRSTlMAQObYZgAAANhJREFUKM91kVGOwyAMRD1s+m872//Y6gVKT9BVL7AVuf9V
GhogJFX9YQ1PMGOAKJcQgYkGprU4LwPTUNaybCDPje7vPgi1mpZTisXBuTT9W3C4ZzfhbSPB0MRq
oF4EPL5DSNS4mOMhNeb3UY3AXXSrcaoqVvXjRYSGrg2NWpSaVebFWNwEa5o+6/inuV1irnZh/q/w
3K4J+law65FEM2APJnQEH+BmBxD1ZjtgGkffEbfRtSMsYs4B26wCvxhpPz00pf5Q/oSU9uMS0geS
lAQHdAQ55vs70QuU6BKRgZTwSAAAAABJRU5ErkJggg==',
	'hammer' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAG1BMVEUAAACAAACAgACAgICZmZnA
wMD//wD///8AAAB6W031AAAAAXRSTlMAQObYZgAAAQNJREFUKM+tj7FOwzAURW+bFOUD8gOJoMoY
KSB19OBIHaHmyZm7dK2IDIyIOiSfzbOTOgXEgMQdbo6OXmw/gBOVXAQsEpwTAcsjrh8hglo9u87q
DZe48G66ct27LtoSy6yzyNNB8GAMxPg13ctHGfBuPDPPyNCbh7RWg/Qg4ACLVOCPiapqooTUYcKa
3o8jXRGdRjrcUH/vlSkabbzaFUS8Bqvcdo0jVnK1sUysplex4i3dy5waE0v8e5Jec8I+/potkT6t
2y9jpHWzvr0w+1dWpOYf908PBenemCaIXZZ1PVFb2VlYPl0NgxRByK0TVs5CIFGD9SNn4bb3HwQx
54cAvolPVFlJByyKoe0AAAAASUVORK5CYII=',
	'heart' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAANmfvwAAABMlBMVEUAAABrAAJtAABzAAF3AAB/
AAKAAACCAACJAAGEAwCLAACNAQCTAACVAAKXAACZAgCfAAChAAKjAACrAACwAwC2AADAAADDAACq
DgjGAgDPAADRAACsExLYAADcAADcAAPlAADzAAD8AAP/AAD/AAf/ART3Bw3/GxT/HR33IiDmKS3/
ISbfOTj+LS3/Ly7/MTXzOjzQTUn/Ozb/PD3/PkT/R0XwUlP/T03/UlXlYV//WFb/Wl3/YF/jbnD/
Y2b+aGf/a2mXmZb/bHD+b3D/d3T/eXv/f33/gX//gob/h4j/jYv/lZX/nJn/naD/pKT/pqb/q6j/
rKn/srL/tLT+uLf/u7n9wMH9x8b/ycj/y8v/0M3/0dT/2dr93t3/6OX+6ez/6+7/8fL/9PX++Pf/
/Pv+//ylqqrrAAAAAXRSTlMAQObYZgAAAAFiS0dEAIgFHUgAAAAJcEhZcwAACxMAAAsTAQCanBgA
AAAHdElNRQfVARwBFAHx42tfAAAB10lEQVQ4y7XT8XuSQBgHcEiZGd0IbXMb6ZADwUhWsiXJ2vY6
nU6XkZrLli0b/P//QnfQykS3+qHvcw/Pc7yfOzi4Y5i/DwDMd+L1NI8ExKcg1rnNQyRuF+R8TkTk
dhJlSKdAOsk5IRTMs9HlqKVJAkCmUB9cz67ODQn9migtFHtB4Pt+4J/IHF/65AdBcPN96sqIjQwI
8jCgddrcHWlwM726/DjyPG9fQtF7c9kGKZKB/uz661i1xsP+u1633TptHKsiGxpU+BzMvk2/kKED
z1PtXrvZOD50nQPb1nbWKIEneDIZDz/0L3rdTutUM4+c2r5dNQ1D19Tddfq5QFC6F93zs9bJUd2p
2RhbpqFpuoJpShHJYLtx6NQO7L29sqljrIYtSjEkjEgGViumoZOJ8ULkRyFJ5bGqqjhWJlFyXEgg
i1dFESH6u6ntVeRp4icBPr9c5NbgdosALy0Tmwh+byLgN+Miy8H8NgMuW1xYrpj4QxDDCpJOPioJ
uZSUjfAhsLB1+Y1ytWJZlYpVLW89jgtq0pmXruPU6+5zIblMUMMJr9vNZucFSiwX1CSEzvvBGx5W
CYoePJv0xbsEXfzbV+ydgpit9XsEw7D3ivBsw78c/1WG+S/5ARLQfhPLo5AAAAAAAElFTkSuQmCC',
	'help' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAAP1BMVEX///+ZM2bMAJnMAMyZAJlm
AGYzADP/mf///wCZmTP//8z/zADMmTOZZjPMZmaZZmZmADPMzMyZmZlmZmYAAABbrJZGAAAAAXRS
TlMAQObYZgAAARlJREFUOMvFkttywyAMRLG1cii+NAj+/1srME4Ap85kpjPVgy/LYS20NqaUZb0A
kp7FtLXBGM5LzQqXO80rkJ9GJ/3eqm7H3X5l/EYLx8R7IGZ7OI9iwBdGL82JwN07LCMWHxCWBfqh
cHzh7pxP66h6FowOpzN82MovBZp6QfuZGmG2M4PjU6ARwwqWxymI7MpAOARVrNoghLJL20cWJJZd
EOeEKyGd06tWCbvmY3d2iedA/2YanwxuegfksHm6AoZt+R50LPycbudAGzPPebo4QRkgrLO1duEE
6JylB1I8apIc9EcLj59vJ+4aTOpzX1dAk4qNiwbtfcmvApqJA6Nml9LjtHYGckZSMO9fAwfGGK+A
A3sD/HP9ABiFDuu8lffaAAAAAElFTkSuQmCC',
	'hub' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAAS1BMVEUAAAAAABERAABmADNmAGYz
MzOZADMAZjNEREQAZmb/AAAAZpkAmTNmZmZ3d3eIiIgA/wCZmZmqqqq7u7vMzMzd3d3u7u7///8A
AAAQ64HPAAAAAXRSTlMAQObYZgAAAXVJREFUOMu1U+12wjAIxc1OrVsigRDe/0l3SaprPbo/bpzT
tHzDvSnRIkZMrmZMxIlpI+ZOkq0QiW8cfsKBpHysjhwpIi37XfZK5pFVzQ89UVQMaSJcrQkaVw0l
YvBa6jwvt51lnp1OToehmdU6KToRv0ev0aQKzAZjNKgSotZKSb0peUmlNGjOfGvLvNZeE4x49vXM
0HfEn1cdUwNr/vSxtVs1nTDwjvZvoWvF+Flkih0wFLZQRpJlixOlk8lFcqwKaQVkOEx6Uaxfm0gK
ejyLGXZvMnbtgOcchlxu27J7kS0W6PkIjT9C51VwZ2BHp7P7g9sBaD1kuBkQ+8ZdAz+AizcCF/d+
2TSy+8UBRqrTUXqcf+x7rXFdVTQvNTSgXL59wOW4bUGCgBuuvVkPiKO1/lu5pGJR5ytKRdiIgLt0
3ngJKtbDkqCeqrYCf0oi7tdxoWdYI13BKViG2if54a6zW3LKqUg8d+4V3xB54l7H/eb+X/kGNyMq
2SF3r48AAAAASUVORK5CYII=',
	'hwinfo' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAANmfvwAAAAOVBMVEUAAAAAAIAAAP+AAAAwMDAA
gAD/AABYWFgAwACAgICAgP+ZmZmgoKDDw8PAwP/c3Nz//8D///8AAACr1iWhAAAAAXRSTlMAQObY
ZgAAAAFiS0dEAIgFHUgAAAAJcEhZcwAACxMAAAsTAQCanBgAAAAHdElNRQfVAQUJDDOYLesrAAAB
LUlEQVQ4y5WSiXKAMAhETWpKSVJT+f+P7QIe8ex0M6PGPGBBh+EqUQ3PwmlWPVN2Ps3NqDdinqcn
xmtsyA3jhDG40h2zIqaYc8hSbpGmypkVkgKGiK5OUIgjIE8ztibHOtPkXkKOHK3SWNeCuxUgATeO
bJWArPJzNgTnFCmvyJfLEKTPDISi1gkbklxis4BRzUJB3V4RbTRX2K2WMPRI1SVqpM2LGhJ1SGWT
wMC8KURJXRbGCEmqMHyiV3QTAktNfRZD1E7UoWJhbLq/ZEk6pOBGsUt3WfB6sjGat0MWH6/2ZVi1
mM7LNy1d682Cl5h0QCzYwyX5tvdCjtS0hKddpw9Q9+vnxwkROSOLNdk+QJH0c7sA/AfpNPabYv+s
ImUoT7K/eix/IsP28KJ34hfDhCR+LDVDlgAAAABJRU5ErkJggg==',
	'ie5' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAHlBMVEUAAAAAAH8AAP9/fwB/f3+Z
mZm/v7///wD///8AAADrs7arAAAAAXRSTlMAQObYZgAAAVZJREFUKM9VUUFOwzAQnDgKorfYKPfs
oDygqUS/YZB8yLVIPCDiBfygSBz6W2bdFtqVEq/HszvjNRCAQP8ytlo7KAKCYSWSofiWfUZjWcez
lZjRNdFxYAQotDlwxOPUTJhJw3ZaIoycML6a2BmXYPdWl2d6FZC+rCTR0HwyxqhSPJAnj4ydSf6b
U8ZcjlF9JdnQulL++kGyNcJ47hxcPmQnrko9S3uJMSt7WqclsdfhnkWdB6D9km510LKGsp1VBz/A
wVjKaxTvEKWUvGJ2K1Q9totngxpv8xLj4BORv1LOo7m1eWM3jNdN8D69WOFM5CWsR6ivkPi8XrC+
vkvkfqWdjslZXtREB6TokM8HDtCtbJwkv9i/8CZkt/2Yme6Q3TtNlyvXEDIzWtXYxCqPHS2mpF+9
vjmHw9Ghs2m/dSt4cUy8oY6hdQt1nOU6j04bVJn/udxt8AtwcFShIDqqRAAAAABJRU5ErkJggg==',
	'info' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAADIaRbxAAAAD1BMVEVlYXIAAP+ZmZn///8AAADI
hm6AAAAAAXRSTlMAQObYZgAAAAFiS0dEAIgFHUgAAAAJcEhZcwAACxMAAAsTAQCanBgAAAAHdElN
RQfVAQUJAhHTzodBAAAAn0lEQVQoz63S0Q3EIAgAUGNcgNwChusCrQ5wUfef6UQQzHn9Kx9tfEGi
oHM3gT3WtcfUA6PBO424lAQ6zRRaAND3YyknwKv/sqWIcBJX4V2cpHWHRNlkUaaA1DFJKvEx0RMO
yfhX/CpldLLyCYky9zYsd5DOVr3nbH8QykWbfzSCVmxCHlulLet88CCJ6xBJfuZcNwmbuLaJx/3F
3D2lL2ZNO/7TbRBBAAAAAElFTkSuQmCC',
	'keys' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAGFBMVEWBCAiEhACEhISZmZnGxsb/
/wD///8AAAB68f+2AAAAAXRSTlMAQObYZgAAAVlJREFUKM9VkT1vgzAQhk9AYY1UVazFsvFK64G1
RRSvTYTlPbXSldhB/P2ebSDNCY6X5z7gzlAAAJkAkiveUwOAF7LzB+TfUDxhFLLl2/uvHkNQT0f0
cvJ5WAacH/BVL9hllAC5tFhv317RNda7FCD1XQjxn0GjP8ypQ1Bnpm+yCVHJVBUUJYNjVVSdgyBz
r4D7uLgJiLasT+A1iSKX3VwGZZxux/A5IxVTz0ENSkWVD/Oq4NIpFRtRs8w6lgydiDDr+qYK0Ax9
kwaYoQKu8V+oV6lDlVm/mzCmiPN4S3dV1BcO/yy5/FLe9+W0AyOJ1bZVnxuqeymYFq0ey2YjQ8eU
0no8uq1qqGcPkDQbqnGTSt0JJGcjLSHsdL33JjgPb9WOCkqtIU6wHSWG1j3FJnxeEeYs1BOoXk5L
E3OsCQTej6U/l4T2aw6OL8JJFa5dc+C+mMKJB/KwrT9QJ1nGMgqX4wAAAABJRU5ErkJggg==',
	'keys2' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAJ1BMVEVpeGUAAJkA/wAAmQD//wCZ
mQD/AACZAAD////MzMyZmZkAAAAAAP+zSxPiAAAAAXRSTlMAQObYZgAAAVZJREFUKM9tkLFOwzAQ
hm8ACZJH6MbKI7A6EmkWhkRCyQMw9CUYUsmxlw6tROhiCUVy3CWIBpy4j9CH4hLXpa34h9PvT/Z/
dwZAXS0AKgFgMgEHUQAOULTjoRjKx45h9buYYJ0fL96+Ylnr4cIEIU+HnCWJYL2cp9AyOKp05k0X
1kgTTayVPy9ajZnetoxseMfLkhASCMCegUIhtHVU44zPndO6cUgfoN5m1EJ+v+uZc5qNTdj3jNpA
2iYWwU1M0kOKmQY4wRPAquvR4FawiqaPz1L2AuqcMCUEPvcldVMpJeAfdc0loEVzAcw5QhDpU1RT
0xLTnyBp7h4+93tD311Tyb/MzBjKjt8k6cacAfAojwnJ/gDAdRyGIcmM1bB5xet1WIfJqDjDcVZ8
swlrQkmWZ3nQKyT58GquElWpKsXFfVXlBIECBR54w1CeqpLktNU4wSU41y9+q6SAEK1UGAAAAABJ
RU5ErkJggg==',
	'keys3' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAANmfvwAAACVVBMVEUAAAAJAgARBwAKDAgXBwEO
EAwUFRMaHBolHhQfIB4pHRUrHRArHxchIyAlISAtIBMjJCIwIhUxJBcmJyUoKSc4KRwsLStAKhU/
KyAwMi9CMiA8NCpJMh02ODVOMh45Ojg6OzlKOi1POSg9PzxLOy5MPC9BQkBLQjhVRTdISUdQTEpf
Si1tRSRoRylhTjZZW1hdX11gYl+AWzB3XEVlZmSMXiqGYDWSXiyWXS2VYCFtaGdpa2iVYS9rbWqY
YzCZZDKJakibZjOJb0WdaDVydHGgazilbS52eHWjbTqgcDqlbzyicjypcTGjcz2lcziqcjl8fnus
czSpcz+qdECndkF+gH2pd0KBg4CreUSvd0SofESDhYKte0axeUaufEeFh4Swfki3fT2ygEq0gUu3
g0e2g02yhlS4hU+5hlC6h1G4iky4i1OSlJG9ilOXkpC6jFS8jlbCjVG+kViZmZm/klm+kl/Bk1rF
kVrEkWDDlVvHlGPFl13GmF7EmGTJlmWfoZ7GmWW6nXHHmmeho6CjpaKlp6TNn2unqabMoHKoqqfL
pG6pq6iqrKnRo2/OpnDSpHDRpHasrqvQqHLQqnnRq3vTrXzSrYK0trPYsYC5u7i7vbq8vru+wb3a
v53DxcLdwJjExsPFx8THycbIysfLzsriya3P0c7Q0s/nzbHR09DS1NHT1dLt0a/V19TW2NXu07Du
1Lfw1rna3Nnc3tvf4d7g4t/t38zm4d/k5uPx49Dy5NHm6OXn6ebo6ufp6+jq7On26t3u8O3x8Ob2
7ufz9fL19/QAAQBMXFB5AAAAAXRSTlMAQObYZgAAAAFiS0dEAIgFHUgAAAAJcEhZcwAACxMAAAsT
AQCanBgAAAAHdElNRQfVAQUJFxSUEZXaAAACk0lEQVQ4y7WU+VcSURTHGSLbjMpqIqNQNCrabDey
tDQlTUgzTIvKCjKpwZpEMtRSLI0srAQNmlwKxAXNlgvKNmXzdzVwTsCQ1U99z3nnzLz7ed+57777
hsX6b0IzFlHzR6iNGRlpy+kHEYl1zMdQKzHw+cFaRLHQWSNx+Xdm4R5/8BOMAUC7AIVWm/9IIkNl
gd8lSRPsfwMOExp4QsA2Cmci3GDAyKVwHOdi4EChg8gKvzBMsKBzCR4RtwNQMA0MJSKrAc6E58KT
gohLAcUkWFwYFP1ahWAoPCMECSas9QEbGkUuCGiX1gQXHo+/aVVK8tJlK1LW8ng7UeginGLGpoWh
b19H3loab6j1esPjbjMKPcMSpkt66PuH7ha1Ui6tUGpu6xpRsDmAy0hm88cZS+fD2uvSUlm1pkFn
QKHf6S5ilC6MmFtqz8vLL6o0Wu12jARwVyIMZCrU19msUpYUV13VqIVGGgDoPxpvkzke6m3SK/Jz
DuXml6TaghEErLeS4l28fa+6DQadVvcgr4cEl52w20dhoCC278wpb2+zukqee1yav+EHAEF7AJ2P
KQmPy8VifqG7W19/78R7cgyICRqZ84NLEk0nfXLG0nTzbHbOsex1AHScJMm5OR94zkUR4cjMy6fP
DXXX6upS6cYL5/qZHh6ojJaY/pC57b5KIS1W8OmQe9qFSdo98CUemfS+bmu4IjspLT847Jumy7Zl
l9g1C4NZUSR9PGQ2aC/JZKdKK7bOAowm51Xv6PI5sFjn8R+9u1NTUyYvLCw7fQALwMTivYf3WQET
4bGjRNhs9gIOwuGw2RxE4gf7bjEGWBoSf9h4nCixachqI4rWJDQ4zhCFIFSk2/E/XfsY+7efwz8B
hn4Ctf4/GG/U1cYAAAAASUVORK5CYII=',
	'labtec' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAIVBMVEUAACJEREQAZmZmZmZ3d3eI
iIiZmZm7u7vd3d3///8AAAAMkYg/AAAAAXRSTlMAQObYZgAAATBJREFUKM9dj81qwzAMgHVyhm+9
bNAX6AP0MNgL+BECPQXGNMhtTRo1OfU03D5ACDsVAnbxU07+SZZMEOXThyzLAByZBpBNAYI/EN7A
+QJdw9Lzk774JnX+LiDrCAtfbTnfGR6a83HgXNHww0mVQDkn8c4J4BM5CW6W+hYmQ9ZqHTmrKXFW
WUstlnxB/WJr8gRuPCXiCZZwW8QB1viZ4fYQYYUIOqEdJrS7Ca2ihPaVGHv01BH1mEg1gdRMdEgk
3D6PBALHRMz5RGCbZxNJGJMc98a/fNzmbWOt/bv/nGz9aksnif45Seq4Wzk2NU191/4eTWWDu/Kz
TOHNV2e7URHxrgvj+OxsqH5bGXD4kZ8Om2BMMIBYun29NOGFLl8bjtLftVkacGwc4sKArxHWEepf
Zyq0Bpj0/MwAAAAASUVORK5CYII=',
	'mac' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAAM1BMVEUMAABjSpzOYwC3do07uteZ
mZljzhj/nAC9ziD/tUr/zgD/w5rC3sH/zs7/zv///86mMTHjQwfaAAAAAXRSTlMAQObYZgAAASVJ
REFUOMt9k9GChCAIRZ3MlJUG//9rV0SFXNvzYBMQcoFxTsCE9YwR6llKYVMIfBI7kV2xefxwOJdS
fzBsOxjfjCfT4yaXGBA5oaP2Xb0QIlN9uSUIUoJU0fJ8pZwQbEK5UsHrwmBeBlIk/UxA0sAxAfnu
LorveT6DUsbtZwfDqs8tBaF7r1A0XMkkIcTaE2lOd0/ElpNCokJ1ST0UlT5BFXrckthYstzvjfYs
1RpL6UHajS4Ez8kQgquhj24Z36MxRvMOwtqJ9F+/qQ0c30LaEtdmJySiPyEE0ujW1r40iTYBC0mn
SWAGMUlAKjrHLaYtBNsIsCtittYAtxFl19hutIm5fXkJ0jl8/WueoDGfDR4fozY7Yv46y6RwmnEf
oHv0/MX8AoDIFe2i4FdLAAAAAElFTkSuQmCC',
	'mail' => 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAAEzo7pQAAABtlBMVEUIAABJRG9HRnZGSHJLSW5M
TnhPTn9RUIFRU35TUoNTVYBUV41cV5BYWJZdW41bWphcXpZdYodeXpxhX5FgYY1hYJ9hY5tmY5dj
ZZ1lZ59qZ5trbJhpa6NrbaVsbqdub6lvcKpzcaV1cqZ3dKh3d6V5dqp8eKF7eK16eqh4fbB6f7J7
gLN+g7aGhrSHh7aIiLeMiLGJibiLirmMi7qNjLuOjrCOjbyPj72VkbuXkrySlb2ZmZmUl7+VmMCW
mcGXmsOZnMWdnL+encCfnsGcn8iko8eno8GlpMimpcmnpsqpqcyqqs2rq86srM+trdCvrtKyrsyv
s8+1sc+wtNCxtdG0t9S2uda4u9i6vdq9vdS/v9bAwNfDwtrEw9vFxNzGxt3Hx97IyN/JyeDKyuHL
y+LNzeXRzd/SzuDTz+HU0OLV0ePW0uTS1ubY1ebZ1ujW2urY3OzZ3e3c3efa3u7d3ujb3+/c4PDf
4Org4evj4+7k5e/l5vDm5/Hn6PLo6fPp6vTt7fjw7fLx7vPy7/Tz8fX08vb18/f29Pj59vv69/z7
+P32+/78+v73/f/9+//4/v/8//s9O19lNA9OAAAAAXRSTlMAQObYZgAAAqNJREFUOMt1Uvlb00AU
XO8DFURUUERFERAB8SoYxNpyyVEQKSJCgR5Q2gTSloS2SRrS0KRp6Gb9j91NKNAPfL/stzPzZmff
LgB2IcgBYHlYAEyecqBJNI/xPN0HAOOyMbdpdAAwSkOoM0TlsjQpFavFTB9DHXUB0O8s47BAljUI
i3IDtt1DZVVYAOAbQiOzdBzLYSmSYVcvAdBTEBN1dr/UcmxDanBAWTgGRvwIQpPNvyPIDI0Qgsgy
tCUp02ojCGXmto0CL/IJpok0LCJkmYzsSSejy+EagrBQVySBY+nnV528HUo+nfU1USfpX3TepKoy
OOWq3g7Osd2ntu4QOtwaPknK4mzFlPzY3k1P7OMgqKQpuS4imTMQ2UM9IYv0dQxMFTd0jBiFeSmT
eoIlHixYXtH1vAdnHSM9fggRXPH+9IcTTKQOA0MYKGmbwQ1uOxBqI5IIdkzLQpqlo+9vEeCDZRaC
2JGZqT+6n6znBYGPNf6t3LD3YE/k226cXP9lnnM9pE4P4M0z6rx5VGqgv3/q06v/kENf3UEVmnGx
++5ZC+/wxLaFyJOqITXcVX3I9/FfIrIgeeOyqYeEfXmhvSKY9U0HNTwO+wPgQRp64YeSEwV3q6Pw
LaWzJvkbhMb2Rf0gvJ4Ts2mu75GjmIhZ8DDxZ2VXwxqzqB3kvVkxy3NJtu2OoxhJ2gZIWZ4a/U3L
++ExLsOnkjt0uPmao/AUEAkAy4bOTXq+fF7NJKJroTgdXay/YCs+uvE7Q8s0dHWdU0SB5xIsQ8ci
AV/7bcfirRv3H+LjaTbnHM/Et4Ybay8eT7xnvFzCfJoh/G5yZ/H1/RrKrsqguv26psoxSczwjLfl
wZUq0q6OgKowkhDobb5HnWVJdW7uTD5tvnw+aVdrw7mt/wC3BgkvlZJNMQAAAABJRU5ErkJggg==',
	'mail_deleted' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAByFBMVEUBAACiAACsAAG1AACwAwC5
AAmwBQyhEgzGAgDMAALPAAQ9O1+uFhO2Ehe3ExHTBxHLDgyEK0DzAAD7AAJHRnZGSHL/AADWEBv/
AAbFGhpLSW5PTn9SUYJSVH9UVJLILDCWQUxUV43/GxRcV5BYWJbULTBdW41bWphcXpZdYodhX5Ff
Xp1gYY3HPTpiZJxmY5fRPj/1Ly/fOT6pUFb+LTNlZ6D/Ly5qZ5vLSUtrbJhpa6Rtb6jdSUj/PT1z
caXOVFb5QUe+W155dqrIXV3/RkV8eKHfVFh7eK3RXmF5frF7gLOFhbSKirj/YV//YmaOjbz+Z2eW
kruZmZmTlr+WmcGZnMWencCbnsedoMn/f36josWno8GlpMinpsr/h4ipqcyrqs6urdGzrsy1sc+w
tNC0t9T/nqG2uta9vdTAwNf/q6jDwtrExNvHx97KyeHMy+P/u7nRzd/Tz+HV0ePX0+XS1ubY1ebZ
1uj/y8rW2urY3OzZ3e3d3eja3u7b4PDg4evj5O7l5vDm5/Ho6fP/4uDp6vTr7Pbw7vLy7/T/6u3z
8fX18vf98PH29Pj/8vP59vv69/z99/b7+f33/P/9+//4/v/+//yhAAKzXPYWAAAAAXRSTlMAQObY
ZgAAAutJREFUOMt9U/tD0lAUvtlTs1Iqs3fRw0ozLbPSNNOVmSaxYiWVKGqG8ggXA8fWHjpB3QQ2
7unf7W60MLO+H+6955xv5z2EKsjBCjmBySJ0TFcOkzeNXITBoNFceWYJvfKwNKJdS9xk7KtgYGtW
7iGvTGZIEzkfjfauUvvvVB34K1cAp2xdCGNzbRihqSTgDVUgKoDoTIJrRY8zGUnhE1dQH3gUsZ1Y
vF7KX4lH01V/Dt7M86NVKchjXC4I2iNHmjMBMEDZEDSFPW9rGKJYXDSMNUYR+KDj6lpHxwvLSCYT
wnI0PkyjU5PwuaS/jquyuDzdaserbdJ16Dqufh8854avoQaoI/1/JePAtyNBX25+Oy3wsYiLmyPV
lOcAwBLWxn6RpmJEhrI1o4ltTts5W4aSZURW5H6b9MHkJPsbI88pYsX3NIAcFoqbkipluftOpRgD
zgWZqSWWTzm+D93tuGgVOI0R+aXFxAWEajMED40EqTTNxlpO0mhSL32GiQOqIvJc71m7vL6+Lej0
1BC3vhuVcpu6QdeP18jh+275dRTlXfXe693WjtMURTWe/6M9tAP0P/j9/infs3+a3/oD8bxlppTR
m7v5Yd6F0qQt2DLz8Xzi5c5Yn4Izqr0NgMulohFX1rT54SolND0bN6AMzsJAySwam7O5FVUJ9Luc
cESSC7hCIEtmFYyNZGxFlSVx7IHLCbEYTCESFQ0yHpMwcoxMuivx6cHrLuc9bzsBrC2GQ19YLZcM
irIo8Gku0XPO5QQ2nTjYsgwhzLx9E5OzS7F4ik1EWk86nNrn6wT6+pOhopGPSZqqSGKWX2bZZDQ8
ctXe2bsLX0tfF5zj9tMUbycqZXnuGxtobznhTKJhfHxiC0ol0Ac8nn0cYQhCNh0Zab/8e1R1XvLn
bQHonR4PWQJSSup9b/vZ7ZM81Ny8CnpXtw6rTU17lOhYz62/Jl3T0P0LRy/19pzZfRF+HDhSX19/
sLHtf4tCu9jN+BOvhTlpAZrd5wAAAABJRU5ErkJggg==',
	'mailbox' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAGFBMVEWBCAj/AACEhACEhISZmZm9
vb3///8AAAAMx5IbAAAAAXRSTlMAQObYZgAAASpJREFUKM9lkbFuxCAMQK3oLsydujfDrZUIYs1A
dXPVGtYukPWuQPj92pCkl9ZSyOMRO3YCAgDOHkBkgpGuCTjsF6CD7sbch1d+KKOm2xtpgI4N8Gnv
ac12vsE94w3iByba4yfAkKjUwOVOvCw1nULYEHxl4RBDRjoV77EgRkqFK3IwQXchMJWG0bRsGMa1
TFkFqL1ywBX7sCFRQFcHiPRiyfJ8j3bWcmJycZbzVHtxTsapdeCkrN+hEOlK38Vps1JpQJQaMK3N
dDuB2VoWGeXebY3FWjw4QW2Gg8ve/3EZsTmnVBszu+dIzvusikrNPJVCblYade0uO/oxukRKWpqh
qTgUGaXWCUx1jwbES6lGJ7ObS6TPkMwmmjG/+808zvrfwOkazdGQ28UPKZ5r7oZEdfwAAAAASUVO
RK5CYII=',
	'mouth' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAADIaRbxAAAAElBMVEUAgLf/AACZmZmgoKD///8A
AACBnWNiAAAAAXRSTlMAQObYZgAAAAFiS0dEAIgFHUgAAAAJcEhZcwAACxMAAAsTAQCanBgAAAAH
dElNRQfVAQUINAOoqQ1LAAAArklEQVQoz8WP0QnDMAxERSED6EP/RdANnAmS/MdObv9VepJrEjpA
exgsnk5CJ/JLTcAogT2+qtqLCaoWv1JGG2pUe5CsgOxoI7EtUYKztifJsvUBw1mS6LGsM6izlFlJ
pGJZS38F5kEMg6Am4SKkDeAaz4MOdqk11ngebWOqD4UJnYCWJEzW96i5f9JHiIgxLBk/jx4WmnqK
yyLy4gjaZRF5OOB+swT6AtR95I96A0gCL+dV5wywAAAAAElFTkSuQmCC',
	'msdos' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAJ1BMVEUAAAAAAL8AAP+/AAD/AAC/
AL//AP+AgICZmZm/vwDAwMD//wAAAABtGTJSAAAAAXRSTlMAQObYZgAAAcJJREFUKM9NUjFrGzEU
fhBDjdGSIVO9JFBDwVNuzXZq8XBrPXVySyGQPaFouFF17wfU2EM3FXFD6JSgG87OxVZ170flk0yg
DyQ+fe99n54eImKiEdbJZyLSJQ01UUukmD44ko60pjfLQ0UkmD3RgCsUD4rrx5JaIYjCyHti638T
x4L8ptnQ7OvugWZf/jLJj30DS5iImgLXAdbiO8qDwj3izi7BRVtZfLtx7j5a77t+531Jg9m+K3fQ
IyuLa+eakk6y7PnTvxWyokXnDDsa/SGzVCaiWpil5xIooGfrEwqHSqcs14clG3BolAPHbCcvL946
B5su23HP/S8gPi/6eYWuOn9e/Jg3+ojK+fo+Ii56/vkQtfKydy4qZH7xfv0I9JRdnZ6uNlDERyNw
BwXTpk0EazC8yFhVCmviFCrjE3OLk8G65XZ4VKmgLBtfVmzVUaUqU6M+1MNXldLBA1fWWhVVQiKu
JpPJ2GFesSYyBYipSxHnL/Ns/64rxm678MdZykJHplpvF9zGpl8ZLbaL3jXJB8wUDKNm7XximLuc
cWJ2LvnE4Ml0Fa9KznmGeD47G68QG52GzxxqbFgeHyN+u/8CFS+IgRrBj7b8DgAAAABJRU5ErkJg
gg==',
	'mycomputer' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAAOVBMVEUAAAAAMzMAM5kzMzMzM5kA
ZmYAmQBmZmYAmZmZmZkzzMyZmcwz/2bMmf+ZzP/MzMzMzP////8AAAAh5xK7AAAAAXRSTlMAQObY
ZgAAAUdJREFUOMt1UgmyhSAMQ8Vf87dK73/Y19Ki4JJhGExj6EJKCUgpcWbdC9sOGFU33/NOqmCy
T4pA4mmajLIIb34ig4WFWVfVAeGk+qkabzlvfmBe60Ed2A7kiJ/0LrOBEIKohppmA5Mz4E1N1ZZx
MqzxfWAM63oydECc4a+ayCKLxowqVgh8WWHoQC2djm3EkSEkUp4C3O4q07elnNeOse95HhgtQmRg
NEXZembzwk6GGxpDHZZL6VE8fjlq18oEQ1XBoA7V26EEGmEcIPFoDgiQLjatPzGQO1q7ji4yjwtE
0tmgcJSvDdDZruubJP/vFbM26i7RJuYfx/wnjxJ1yVwz0oHIq4tCpApeXEbcJU9dGSVJnkA6pO6e
7u9zip0PrsGrBFXhRt1ePBn4LVLq+PWZ6+hiZxfgkkafTxNcHuLwJrvXgjdE/APYticKYcZg0AAA
AABJRU5ErkJggg==',
	'mycomputer2' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAAllBMVEX///8ICAgQEBAYGBgxMQAA
ADEhISE5OTljMQBjMTFjYzFaWlpjY2Nzc3OcYzGcY2OEhACcnACcnGMxAJwxMZxjMZxjY5wxMc4x
Y85jY84AnM4xnM4xnP9jnM5jnP8xzv9jzs5jzv9j//+EhISUlJStrZS1tbXOzpycnM6czv+c///v
1sb//87n59bOzv/O///v7+8AAADsig1PAAAAAXRSTlMAQObYZgAAAkVJREFUOMttU4F22yAMJAmD
lTUs8TbN6Ug9XOOATRXz/z83yU5Wd+uRl/COs5DvFCFijEII3zr6dnUthN5qoL3oum457IemiFjX
ReBWX5YDgee2dUQJEX1KztFOA6giP3f8LE4YdSWEiQxDRXJqvfNUMg9DcgNvUvLu2gnINYE2KGXZ
GCBGbrU2lirBNF20lks7y8V5hS03Gvrsh2FoU+NcW/j6GLNvifDEDHem8QTnntx1ZgQEJPQ9tWeY
0TBh0Fup5K4ATixRCDBOdopG6696fop0iOOIWFUGmIorLOfjyK29zsCZSXgik5Knfr4jl9E9nlpq
uW0aVy9M+IAhj9s1c8RnJvw7hqoS3J15Cb/rG36FuWV5WF60j9Ys6RhVrC6l7B7sbn6tQzchlJ1U
aiurke1+PFillDEAYA3Mjj0qNDZeuFgV5FxaaWYmYvZ2XPxR5M6IY9zTk7A41q3BBmac8frP4jm5
eZxwJNHpx89vn9aoEcs9hr5PmE+e/Bjm9NkVtqElyaLRoe8xn/0sIGtTapozS4aVJAaSpKXGXfL0
tJYcF0maw0i3i0hyXUuOmCkJypiXnzt5L3mJx5DdM2d15i5YQJ+VREh4CRmHPOTru4XxJtFoZVlh
w+AfuVms5Snu0MID/REtVBWOU56wslA2VtlbHBoONOrjfbFk4sxornGStxQfYVQVQrAmmogx4h41
Tbzdaynv/aqNkiGABZaEC0a0QQe6F/9KKHz1pcKKqlTxtmywYR8wgHhDBx/jrc5/g/SGP7C/eOMq
MdoLAAAAAElFTkSuQmCC',
	'mycomputer3' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAIVBMVEUAACUAgAAAAIAAgIDAwMAA
/wAA//8AAP+AgID///8AAACiEKTsAAAAAXRSTlMAQObYZgAAAShJREFUKM91UbtuhDAQ3EhXwP1I
PsBSBGV0G8lHnX+JlIqCYu02FJjqpIsih6/MrO3jUWQEZhhmhwETCdFpxMlET9xThfsKl4ZOlkZL
0hNZsUR0+cJahzD1dJYIG4moX5e20RE8qRgZMM0I5I6m6AU2DaEQ0iziL8Y0NjMJhVm4EjsvQOzA
RmaRwUP0Ls5uQcrAihSnsZlUmuyV1ZCcDlB9N6bN7CfcC7uH+cHaB9smNNlvDaQEh0kZMwpaZa+w
DYlpqThFNPGC78SXUqrHESmVJFBG7s189UVwRWDri8d1S4LbKS+4N2avGPf88XlUFhfmo2J0bKdc
Q8aqyIo43I6CDJLqj7zCFuXtHVuqFb/tPx7np9/H4SN2x4UNVoX8cwti2b/d21X4A9YH09SCD2V2
AAAAAElFTkSuQmCC',
	'newspaper' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAElBMVEUIQLeEhISZmZnGxsb///8A
AACCORiVAAAAAXRSTlMAQObYZgAAAQ1JREFUKM99kEFuhDAMRV2GOUBE2CMkDkBD9kWx92Sw73+V
2iFMmVadvwg/T9/JDwCqVgB2HqBJcKr9Ap/g9nlsNls6YoBbkjDobhqeSVvYA3ys4sF3lGD3Xgcl
WeYBf9UybodxhGi+dclHQp0QNV1MdskUV5/CWJJT3MdzfIR/dafTsVR7R6bDMq/kqKSUoVHWL64s
AyjChUndTLh2i6jLc8JM8tA/k5WK2M1NdgUVG6SWaSoy+6bfVbL9AtZpewXE5C+MFy0etenJFPRL
YnZUcwVg71FQX6adcgV61Mq4K+EKQtDIbiSHXEaciwqMwGQs2jEGRntbM+Vlxv4HHCzwFRwshyso
/2R8Be/0DeKcSakW6XGxAAAAAElFTkSuQmCC',
	'peripheral' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAANlBMVEUuR3QREREiIiIAM2YzM2ZE
RERVVVUzZplmZmZmZsxmZv93d3eIiIgA/wCZmZmZmf+qqqoAAAAe+ZyjAAAAAXRSTlMAQObYZgAA
AVNJREFUOMudk4lygzAMRN1KhVh2Ze///2zXR8KVSTLVDANIj7UuQpiG7AEw5aMJwsk8rLAaEMXP
AX5qpvjhHWW1ItoRwMMTm84RNZp7MJ5rloTyvAuEEZiIN8btudCwfMkUfsdZjCEvnkc+djftiojF
vvvBakV7PpGJ0FuSAFqHjiNW00TVfRZ+fH1hyFfXtbu7EtGA5VTFbXkgI+NWGQ516b0uW/E1nVoL
5SJrWjCYAiEUe50rPUWkezjY7qvK99RPd34SozR7VM9uQLIeuuEQnNvxcXsu3cJ7xh3vGbzIAEPk
mmRbBy4yf4VmOE95bospL6BmTmWfL7YV22EPlRHGgdqw0DeytMebLzuqhUtN2ppMhFOa2CZSSh8S
JtIPmdi6plpnWHNqe97/WFLNhfhLjN7xvcx057C9qVisiaxqR9z93JWJiaaKa/SAvQhv2D/W5g+B
wRxMVMLeagAAAABJRU5ErkJggg==',
	'plant_leaf' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiAgMAAAEwLtPHAAAACVBMVEUAAACZmZkAgACe191PAAAA
AXRSTlMAQObYZgAAAPBJREFUGNM9ULFqwzAQfRYhOJpCIR06taUBW1/hTxDF7uCps79ClC7dSkiG
ehJGFvi+sneS40M83unu3j0OAJ4BDTwBBSfY4YwKOYoL8BqAcm5S7uSVPzgEfAXoT9RnGbjHm4AP
JWMVZu7V8RfYT38yrQdibB8c8sp7f0KVeROUbAllIzovzGPg9TDxyt/1aFn4MHJRTwtjQSRqpmdl
NQ8df7X7pA+bHanNmz5ubK05mJUFYeIaNcgqL3aNI2tOqT/S+2JX1sslKiha6Cb65E1cWik+0jTc
8plOPRF5YcaPc9elU3bfg1sd7IqPzReO+Adh2zzhAyHADQAAAABJRU5ErkJggg==',
	'pocketknife' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAG1BMVEVEZWaEAAD/AACEhISZmZkA
///Gxsb///8AAABQSm46AAAAAXRSTlMAQObYZgAAATlJREFUKM9tUbtuwzAMJAIj0Qdk6NgSre2x
KIKmowci1R90bQvH0Q9U8WjYisLPLiXZeSEEbJGn0/FEAUgo+RZz+RUwRQZgHMw1TPsw402ofn0V
qqWbmHHTLQB61q9wfDQ1zDCQ8OVbTnUn4jmUq9LKzN0QclW0pFe+ljTHcvB1JEhqbDqSP222oxJV
WXUreMraaWvhpkwRcFgH6QYmoG/IrFe6E3v4TBtnXcgQhk8m4SMWpo3He8S1oSiCmPs26vVYHvZV
AstDk9r0Sz02zAgI7kV3U7OC63twS9ktIFLMFxoBUMfkCZQYaCQ6tm7sKY5LItJC0WsTEI8FlqJi
nbZNpPU5CktUWusdRQ8Jev8IjNFUgnwjTzR1TxBvv+wVVPLffncat0A/D+T3hs63YxbfRJdzoftD
CvEP3ldaiuFIzfUAAAAASUVORK5CYII=',
	'question' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAADIaRbxAAAAD1BMVEVlYXIAAP+ZmZn///8AAADI
hm6AAAAAAXRSTlMAQObYZgAAAAFiS0dEAIgFHUgAAAAJcEhZcwAACy8AAAsTAXMiW84AAAAHdElN
RQfVAQUINxbuWbpjAAAAp0lEQVQoz4XS0Q3EIAgGYGNcgLiA4bpAiwNc1P1nOrQIpqY5Xpp++dEU
6txLIdf67pG4MBl8aNSlJMA0I6T1tcgJEPmRLRIJQEMjEjmlobspiiRpUqEybwI5x0SOYUkm9JT4
X2axyHdKJqOKXD7Er1LGJKt15Xu2YTlXJlsn5Dn+IJSLDv9oHVqxDXlstbes+8GjS1qX2OWx57pJ
2MS1TTzuf8zbr/QD5Iw9gr+vgAwAAAAASUVORK5CYII=',
	'radiation' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAG1BMVEUAAAARERGZmZn/mQD/zAD/
/wD//zP//2YAAADqHjSRAAAAAXRSTlMAQObYZgAAAYhJREFUKM89kL1v4zAMxYngDvDK4WKNhqbO
TQp4ruWgawHJ9ZpBSlYvcsfIHyn/7CPlpPIg+adH8j0B3ACKb4A7VvBnrQA0/wOgghNCTbBjtFoW
EQ6pgr9hb5nUNAHrpHb9vAH9XCcWIMHpPBC8nfc9LP36DgURq3fcE2A+NvVNDkQuKJJaSuWARIKw
LFHE8ymEGHxTQWE8kXc1N5g/ENeP3OWFiPJBira9kM4bWUwrjWWuc/m+SCpcSSAX3vnExhPRnofl
uWkYlOK5b24cUImDoxvHMcrc5fSFZXSv7MoFRG9fuV/bo7KNxF96oqXW2ziap2ozRdPmb6f1w6gI
5sOhztae3o1prWmeGcTJ2jpne3og3in50HWk+HsMofRzuZxTopyDiUopXS6YBLEBygTHEVE0JITv
sEQcNqJhNq4LcRzKGGNnLQego3Nd5JpMGtYUx5ZF34j36L1pJBGXOa94ed+aWlfy7sZ+Ss9/DLbQ
jCgvc5h09YieAyh6AnmZ7ET/Aln697n+A9R9pILxVT7EAAAAAElFTkSuQmCC',
	'ram' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAG1BMVEUAAAAAMwAARAAAVQAzZgAz
mQCZmZn/zAAAAACoL+jXAAAAAXRSTlMAQObYZgAAARtJREFUKM91ULFqhUAQXAjI9SGQ2spW8hJs
JQqvDMjBllb7bENMSCm+t7qfnV1PjUqyxTo3Ozc7J4DWXQcg1xrgG5biN0CByBvueaLkrN/okzs7
RF91ECai7aJacNbPfHkBl7FOtevIDbNjn8xgLEUwwGh8FjTsYh7Gkqsa3DsiDwPZuGlRwjrDVTav
BKphW323rljUtwfxAUa3cvGIlA3QLdAlqALWCCcUhemgCV4NTgmawmDYX/gldZMjr7B6nMM0Gf2T
T39ddzjHCeOWu6q7yI6T9l437jiS9mQ6v+cKz7931bpTLlUde7RzPA2Vy/1TKgQGlJq4DyGi2RiD
jmg1NhM8BMiPQacA4n22ebRytoq2byahPWEc/FU/3EN+xd6pgO8AAAAASUVORK5CYII=',
	'recycle' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAD1BMVEVzAAAui1cyzTKZmZkAAABe
iNJZAAAAAXRSTlMAQObYZgAAATBJREFUKM9VUFGWhCAMi8oBpsAFYD0A8/AAVnr/M21bcWa3H1pK
0iQAJ7AysKzN/9iAcGJNSCuuBKtIL4DHVhQmfDVAeOg8iH6qXi47naDx/gG9QgFL2LFWUrYc7d6p
1EJkB4RamLK3MYmwOgh2XuquKJIGiUWvY61CNLRbrLsZW+/S3VUQOb3BVShjbqa71V1EyRhXTUzD
b6OIkDZER+9XPU3t1Qyh8YznDtgc5LqroSwSctQ1IdbyJjLh+HHPNnONTeTIrqH+Wrr9Pbm9mKwy
voNqXolE5kAlbLPW6B9IzYfRevuSxFl5voAGGl2LYzF9YUMb3MnNXtY2fthjWvEAQeINYhM1VR4a
yvSdRnTe4N6mnSk/LZrlOXks+mHwnxQwe73x6E+KJ/D4f7b38skv1MU4y/gAv4cAAAAASUVORK5C
YII=',
	'recycle2' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAASFBMVEUAAAAzADMAMwAAM2YzM2YA
ZgAAZmYAZswAmQAAmcxmZswAmf8AzAAAzP8A/wCZmZmZmf8z/wDMmZkA//9m/wBm//+Z//8zAACG
2mtGAAAAAXRSTlMAQObYZgAAAc9JREFUOMt9U+2CozAIjFhabqklHhje/00PEnXd7e3yw8TJhI+B
lDLMeM2vLvElNClXM5E8skIPo/jvp25ufXUFUkjM7jM6rH1rYvTNiz19XMTNLC8iqkoCk+oiXig2
yBRnVGYz8xHFfHd0+BMyo5d/upYkO0TQ6YAg3aMWm2QnmJKmLbKOdBJSAlg4jnseLnGO7iyw9qBO
q9nUqUQy4kuae1/KD+aZUJWvGVKtFygpArXeip8CmePWEjsKdoLIWm61h/KwDYm2TXnEztSmrWEL
JCo+Km20daTHy0DmLe7xIxDoiN9dGQHvUmtWSh8CzAw0gw/EYw3IL7UHUuuuxujJ34TEB3CRp9C7
PG9iiR92+0lG6sHMqa7V5TdGTYr9h3QyojwBsmp+q9P3RLr2wEqbNoEgTV/TF4hRiYmilD+niMVP
xpAkPOhGSWialGX5cwvXcul3dqspatOD8gB5Rbs7CXY38QpadD08oS48KDY4w8mHoxFHsMgHAB88
gzyj+DHqvRYAXuJuFIQxFzwzSH11fXZOoB5FscZQhCpnK6ajLEGvGHdeMRjzUWHYE/1srXgXPTWV
k/KkC6MPxO5a5Awkb+Mhu5Xjaf3yujr78vcPAI4w5ak2zowAAAAASUVORK5CYII=',
	'scanner' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAHlBMVEUAAABERER3d3czmZmIiIgA
/wCZmZm7u7vd3d0AAADCqRh6AAAAAXRSTlMAQObYZgAAAQdJREFUKM+FUdFqgzAUPU/b8qgMh4+V
0XXP/kHxQ7IiF/yAzfWtpSDXN2khmr9dUpM0FrYd0JxzEu45RsDhiYFHQsADpiPSzKnOPOKkgDMf
SQK76CSkfR3MiJM0Y7jDN3c5xq/cbGiJGDqwya2XYbwemZi5HOaVOfuQOH9uOKtzG9ekSUNuEi0n
ehw8ESp4/S1X+rT9zCYu1SLXBeehQSPRbiypDXuxXXa2i3hrZ2JarWvfqslDrV/6ua8e7gzBSv7n
QPTy7hJFH/0AzWWpK0U3bWE8GWvnLTRzQg1hLCJN1btx2rbwevWqiaDT1npGbxOjbRhZb03VymnM
XvEc6dlb6qv3xyX9ALPKdv8tILaHAAAAAElFTkSuQmCC',
	'screw' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAACnVBMVEX//////8z//5n//2b//zP/
/wD/zP//zMz/zJn/zGb/zDP/zAD/mf//mcz/mZn/mWb/mTP/mQD/Zv//Zsz/Zpn/Zmb/ZjP/ZgD/
M///M8z/M5n/M2b/MzP/MwD/AP//AMz/AJn/AGb/ADP/AADM///M/8zM/5nM/2bM/zPM/wDMzP/M
zMzMzJnMzGbMzDPMzADMmf/MmczMmZnMmWbMmTPMmQDMZv/MZszMZpnMZmbMZjPMZgDMM//MM8zM
M5nMM2bMMzPMMwDMAP/MAMzMAJnMAGbMADPMAACZ//+Z/8yZ/5mZ/2aZ/zOZ/wCZzP+ZzMyZzJmZ
zGaZzDOZzACZmf+ZmcyZmZmZmWaZmTOZmQCZZv+ZZsyZZpmZZmaZZjOZZgCZM/+ZM8yZM5mZM2aZ
MzOZMwCZAP+ZAMyZAJmZAGaZADOZAABm//9m/8xm/5lm/2Zm/zNm/wBmzP9mzMxmzJlmzGZmzDNm
zABmmf9mmcxmmZlmmWZmmTNmmQBmZv9mZsxmZplmZmZmZjNmZgBmM/9mM8xmM5lmM2ZmMzNmMwBm
AP9mAMxmAJlmAGZmADNmAAAz//8z/8wz/5kz/2Yz/zMz/wAzzP8zzMwzzJkzzGYzzDMzzAAzmf8z
mcwzmZkzmWYzmTMzmQAzZv8zZswzZpkzZmYzZjMzZgAzM/8zM8wzM5kzM2YzMzMzMwAzAP8zAMwz
AJkzAGYzADMzAAAA//8A/8wA/5kA/2YA/zMA/wAAzP8AzMwAzJkAzGYAzDMAzAAAmf8AmcwAmZkA
mWYAmTMAmQAAZv8AZswAZpkAZmYAZjMAZgAAM/8AM8wAM5kAM2YAMzMAMwAAAP8AAMwAAJkAAGYA
ADPuAADdAAC7AACqAACIAAB3AABVAABEAAC3dnjVAAAAAXRSTlMAQObYZgAAAPdJREFUOMuVVMsV
xCAIFG8cpzmvnFJM6kk/1rLgrj9MzFsOPhzGcQK+hIBgIcnWo+QcWpSiiK2pLaXAwqhprujR6zXD
j8UaJTlF8rdIlVQ5Q9Ikk09IhSTG7vEECceInAbfxLofADMgM1CQCdD7F+TIDgl5OYR5rwZPxAEk
A5ipHxQoEKfbtC/WmTQZ9J558QyCMwQdyP+cQL49hgT/qQuytCekBQmLjA3RmuJ718f3JYg1kwm3
GrERIkFurtVqi9LbO2fp/IXVH7yDzRDceP6lGOfZxyCDnUhX2VLUyrWdBHBga6W8m/09hfMiYpTr
9U28ikz/Ahcf1TxPb0l4QbwAAAAASUVORK5CYII=',
	'screw2' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAD1BMVEUAAACZmZnMzMz///8AAACp
fg6YAAAAAXRSTlMAQObYZgAAANZJREFUKM91UIsVgyAMjC0DmJQBCo8BSusABrL/TOUjqNjmQTyT
4/IBWAGA032m+4Jias0H5nKShVC+pvz44rHwMn8xKXnPChPWt0dXFYpDElv1lIhgLRUMVwCTmTek
5Iom3RBwT8paAVHACr33yC3LtYYKoT150FYWYteLvYbGhugX6v0R9/4OqLUHCFcTNuTEbg1nvkda
tCXc51Jx0W9rHe8C6vF2smDvIU+f5uJTCfVBd2Sc9tvWF1mfI7foBs5NzBgJVw4OEQg8RpTDcQd8
XcoM/+wLTOgcIdoH3gAAAAAASUVORK5CYII=',
	'setup' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAG1BMVEUAAAAAAJkAAP+ZmZkA///M
zMz//wD///8AAACvOCysAAAAAXRSTlMAQObYZgAAAVVJREFUKM9dkTFrwzAQhR8xwV5DMXRWW5pR
9DBo7l8QotoLzdpSgjLaEcL3s3snO+D0BvH8+fnu9Aww0L0AhS0a0U0jzyN2T5gKzhmWgEwe2Ccj
567nbNFSe4H4eAQ8WeDtaJF/5IiRCdcH9pgjZ8y+/UZjG7GgTSn9qkA25uhVjTdVAg0ped0lTb0Y
pWlnes9MqtLgSYUost0sI+p01vlSs3zgqhLb4OqMaMzrqt5XNd7YntN1UT5SSWcnbRxH6Zed7jkV
2VRe78whK1PViyK9egri0w1E5WWrNkXqvr7qHbNlTQggQkN1Ua0San24fyB4d/MUp4153pJnI3VH
zJZ0EczXDenCwCldNn3KEHIITHVWHmR+J3GV6ZGW+aQusU+HlfhKpOmhjxT5wtlTXkgfojudTp8k
wNbYhxBpLYuV5KUh8/prBjVXUOPQlO+ARkVLYlTBH7Aqlbj2rgoaAAAAAElFTkSuQmCC',
	'skull' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiAgMAAAEwLtPHAAAACVBMVEUAAACZmZkAAAClVEUEAAAA
AXRSTlMAQObYZgAAANNJREFUGNNNTjFuwzAMPBjVEE0ZEiDZ3KJDqlfkCS5gd/DUpYP9CvUHHuKh
mw1YQMxXljwhbgnpcDjyjkQJnIBXPq0Si34VEQbA63+egL0KXqWIt4hAnkiGaKZCdAZeFuMdg6RS
uMinouuPxhsbfYJjF5yPxD/vbiWeb1QGJlfEq+ILMXzZvJOD6T+m3N8tZ+TRe92wlRdm2z6RdWOM
yawiS23qMguXdc7dIJKyoxBpclzxMPhJ1j53P1LPQ80yN3VO/m5jJq5GyxOcGv24XVbjf/0ChCA+
gN94j+EAAAAASUVORK5CYII=',
	'skull2' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAC/VBMVEXb1a0xKR87LiVGMiZENShE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==',
	'skull3' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAD1BMVEVzAACIiIiZmZn///8AAADa
GNGIAAAAAXRSTlMAQObYZgAAASVJREFUKM99UQFyhCAMTJUHNMIDKPUB5cIDgOT/b2oS9HrTzjTD
aLJu1nUF6AD7BPC7gFfQ8w7hE96Sz1T9ihlAGh8ZpMBHdp7CD23YNtuhKtI7oIypTF1W7glXMdW+
5IloCYfGkrK3O2JxVg+YMuvzrQjjLPqYq5RyxmaYkzfbCdIvZVoGl/ICd+2O1YnI1bU6Vheq4Lxc
YXLNritH3nWb+o5HMGaLuqvvXl6Se+lS02grlVmKxC/lFaOcj8sYQIFfFVg9yitAVjX9IOwI3b4M
aSJ6cOZ/EKo0EF8QhZrgCu4JxehA6C5ilzHG9Gi7ZRClh6pJCFcUI85TNcRH/crimW82JtZ/kZcZ
Jkw6yYhNXJRsNLaCTPol4VpeqZjyHdGNwd/6BkYxOtzHS3sLAAAAAElFTkSuQmCC',
	'tux' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAAC/VBMVEUAAQACAAUBBAAABAcJAQAC
BQEGAwkHCQUOBwUKDAgHDhANDwsPEQ0RExAUEhYTFBIUFhMYGRcbHRodHxwfIB4jJCIlJyQnKSYq
LCktLiw7MBcwNDYyMzs1NzQ3OTY4Ojc4PD5FOyw9PzxgOQM/QD5KQihFQUBDRUJFRk5DSEpGSEVH
S05KS0lKTEpKS1RlSBxPS0piSx1NT01NUV5RU1BbUkdfUj1VU1deVUpWWFVbWEtdXlxiXVx0Xyll
XlhtXkRyXzRgYl9tYEtjYWWNXQhtYVFkZmNpZGNnaWZqbGlvaml9bTR6bVducG2PbDKAb05ucnWb
bht9cWB4c3KOdTF1d3SJdUmOei6EdmB6fHl/enmPfVyXgjZ/gX57goqChIGKhHGiiR6EhoOHhYmG
iIWnjRiLiY2HjI+vh0DGhhaMjouSjIuPkY68kw2Rk5CylyWSlJG2nQCVk5eVlpOxnTmXmZaboKLJ
qAXPm0LGrAnComrTsQHJtBbWqi3qoyaqrKnlpTDfsA2orrD/owLVuRGusK29rpbspzz/qAmxs6//
rgCztbK8tK3qsUniwwDcxA7otUPluET+uAHavFLpxADswjL9wxPBw7/CwszTwaP3w1jx1gbMxsXv
2QDEycz9xkX4xWH/0Q7+1QD/1wDSysP+1RP92gDLzsr+0S/JztH91SX2zl//1xj90UP50Fr/3QT8
3wL/0zz+4AD/1zT/3B392yr+1z7X0dD95QD93DfQ1djT1dLN1t7/2kr/6AD83ErV19T/21T/1Hvu
07D+7AD3147Y2tf/3V3/7gP31aH+3GrW293+8gD+3XLx35Lb3dr+4Wba3+Hd39z/4Xb++AD/3on/
4Xzy28T/4YP/5XDf4d7/7E7c4uTh5ODf5Ob346r/5JP+54b9543k5uP/5pv07Zb/5qHj6Ovn6eb/
57D87Kv+6rHm7O7q7On/8Zv87L/u8O3//nr/+aHx8/D38fD/9sDz9fL2+PX/9+n1+v35+/f6/Pn7
/fr8//v+//yU1oPyAAAAAXRSTlMAQObYZgAAArFJREFUOMtjYGBQYgCBhyCC6TsnkHxw/hmQLC0t
ZYCCGiYg8e8XA8Oj+gmlIBmwqKibOFT+3z8miFD697f3ZEHMI5v6LDftywELysOMYYKqYvikDGEw
ATVCDPj9mbUYSPP9/nxXQRrIuGp4d9ezBUDGvk3OxstswZaWIrlIy8PDJIcBGSSrpgVwlyKLtE1q
L2OKRxLI+/fv93drVlm4gA6Q//ntC1F+I6jGQxVvPr+9e7GOl8kPIrJ/76qdcy4da5p6fO/BRrBI
QXD4XKucguL82TZI7mHQYUADoR6+IigCTBLslkwobubOTihiikV2M8vHd/OZ3JBFmFc0X2dC8Vfs
v3//cpg8kAz+9+/Pr9/wwAXZDRT49iGeUxImwPkHJPBiOT8vTBH3P5DArT2ywsVQka9B/4AC2xsY
DYvBitY+uLpO5sOtY0ueHH3lAxZZeHDz5trn53c7XTi+7XYwSGTxkR2bdtg5msQsWzbFHRIaSa4t
hSl5xVGzU/NgwVOKAOihJJzV2tlaIMGAGzDxiEmICwkLMlmX4lTSupLL+dcLJSbOWFxqGE1Lnp4L
8TdgYo8sxaGGo//I0mldHfpMTEq4lLDv+nHy8Jd/3+WYmFSwKmFS/wcCf37/O8DNxMSfhEWFwHmw
gl/fv32/JMHKzuqJbhC70DGogs8f3n7uFuDh4Q5FVcPNFQlMyRAFL+7e3S0hICAgh+pml8zon/+g
Cu5cnFmlpG0koYWsJHPW65dPAs3nfQMquHX+9JLe9xFS9vczshBKNp49ders2Zu1inEv7p4/tntX
z8RrN4Dg4eqwApiSTYuXLV60aNHixZNnrJxeH6vnsHTL1jWLli3LNUuB2+WdWL3hypkzVyrVNHV0
jDS8zwDZ5RYpyKkBxMwKdvPNgSaSeC/30GJsqQVdE4wNAD9xSwvUKq2tAAAAAElFTkSuQmCC',
	'tux_config' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAMAAAF6nstmAAABVlBMVEUAAAAEBAQFAwgEBQYFBQUF
BgUGBgYHBwgKCAgJCQkKCgkKCgsKCwwNDQ0WCwYODg4SDgQPDw8RERESEhIWFhYbGxsjIRgmJiYU
LTo4JAwqKiosLCwwMDAvMT9KMgk5OTk9OzhFOTU9PT1eQhxCT0xZWVl0WBpaWlpjWFZhYWE0cJkz
eKMze6czfakzfaozfqozgK0zga4zg7Azg7EzhLIzhrUziLcziLgzibkzirkzirozjLwzjb2Vdy0z
jr4zj8AzkMEzkcKmgzu2jyKQkZStkFnQjhPHlwnElhqolmmZmZmxozijo6O+p07eohXMryfEqHTr
sxXgtiO2s6nktyPmtDnJtaK6urr0uxjtxhfIu7rKv7rKxbDqx2r1x1bz0yv21S7z1jHOzs7Tzcj7
2x/X0c/812n82nvZ4NPe3t7g4ODl5OPr5uPu6uzq7/D39vn///8AAAB+7LpCAAAAAXRSTlMAQObY
ZgAAAg1JREFUOMt1U/d70zAQVSFswiy00DIKHONCgZAww1CgZRwghim7ZRQIEFP7/v9fuJPkOHHo
+z5L8tPp1pOMMWwEyXuSEbDpR1SKlDF1He7JZ5HiQMbvGDgXZ84yDitrbdMvgZwLu8bsj/PMn21h
cfr1Th+TMO+oEbNFZH8KrWWhEsnhss/IIPlsJB1FdGVqtb2zdTOMmVdPPm4p9kGcm12P3/xlLPYB
iLtZniJzZBgkrmRsbxWU2FhstVo3mWMoIMALijK06/WkNqfTUPiB1wKT+46NJmh+b/5WoxHm6PND
G0oGwJiXnx9up5IAMp8Wf7wti+gTddM8D+3y6BPjap5bLjLghBmPo3aSKebGvk60GBk5FZjOdMGI
GlZKx3ZxCpJEDgjmadAMIt8MLFOUfiARurIM91OldzINqKDcsH4l6memJmen2KyPiQOi9onDE7tp
XZOFU2cPLhz5tWnHeATQtgpOundfv395tnVj1QSC8DLO3X704P6LD3uKDpQmiTRDqjf4NFtby7Is
bV/EasqgFnLHUPTJ8wxVkYoj6INqgd3VVJDora/YyC+oWpgGfXSartpoIOExwt69rn6G65JAweSG
B9656p2MmiT+ueG8B15pYtVCDKQx2Am41r50Hisa+ppFWGw0GpKJjuMikzwW55Z7K0vybJZWesv6
OyahcBTfOPkT/7sto1zx9w9cuKS2AivYpQAAAABJRU5ErkJggg==',
	'ups' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAMFBMVEUAMABERET/AABVVVVmZmZ3
d3eIiIgA/wCZmZmqqqq7u7vMzMzd3d3u7u7///8AAABaluDKAAAAAXRSTlMAQObYZgAAAXBJREFU
KM9VUD1PwzAQvTEMlXfUib/CxH9AYuI3sHoMEytIrEjVeciUxQUqkKiU5FwmOoDd7CBFFaITKeGu
afpxUuL33j37ng5AymtYWg2/A4BIuILeO+QIh4OW90oNPcpRwyI3/D+wMWyqnvPnv2DpPhEe0SCQ
wQQyM9LwnWh+UndWpVR7BvKlnN75ieHJfx9uhmiNhrrIkYu1mgQlMaMsX51czVmst6NBzTegWYPw
2s5TPriyBRRmkkMFz1MYSWuGQ0aTXOaLRpMXy2M5M9EYbaudjzmBYZSlb0NjJUPWn7ah4LmY2tEq
zeJ2uo4XNWWXL9oL2lUDao+GhqVoy533LjTxts8b4qqSjjsnlkoyrP28y1Ahhx/F3Edii+e+keQx
b7FyyH4jDmtFuSioSq2RfbMsyukxPaQGV5qVd+qCyN3JDTQGm5iVp0ui1MqzljkPr+9v+pSKpeWc
5uSIb6HpuEg/15TucK74ap+3y9oh/zXjIDH3O3ffAAAAAElFTkSuQmCC',
	'zipdisk' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAHlBMVEUAAABERET/AAB3d3eIiIiZ
mZmqqqrd3d3///8AAACdvavVAAAAAXRSTlMAQObYZgAAAOJJREFUKM+tjz+LwkAQxR8cKbZcLCTf
wDbMHcbexi6wDJjyijO9FusXkGwphBTzbZ1NXP/cIeLhK3bn99iZNwtEVUBHehyR9AHsLEyFq+Na
JfNd9PirTju7cn9EQ24F41YM1IxHMumm9b4e+h1ReZgs1Nr4r8ln3mtWJjbvz0Oyx8OeZMAUdSrW
oR4LV/ohuLjkTj1RDK4gze68QSY/sYjRN7tkkpb6x1YvSkh+ccGB5Z5bH5IXmVQhbGdso9fPPY1i
S7TM9c2m8T6xFdE/iHpX5vgrFrFaXRijJ7c8eHzPb9AJN2hLdDRw/YgAAAAASUVORK5CYII=',
	'zipdisks' => 'iVBORw0KGgoAAAANSUhEUgAAACIAAAAiBAMAAAG/biZnAAAAHlBMVEUAAAD/AACZmZnd3d2qqqqI
iIh3d3dEREQAAAD///8hwxJnAAAAAXRSTlMAQObYZgAAAQpJREFUKM+lT7tug0AQHF3FL6RDWyBS
xidZShsi5Qv8A468mNoSUCMwW9tSFP42uxwPkyJNRtzezNzc7QIorjkgVYxIF2JzkHzhQ+wzHHda
2n1Zx2j7Wit6K4hsFd8A8+2MdncSPe/W0sD1jQbd+GbEKcKeFPdX461nPpYne1bedO8Ck+4Xw8ga
sttOwj61DyRPZ/I8pIEkhR975AlzcSvPwGXpJtneiMS4LH0lk0pJ8Ka+f3j6W26dyqk3jfUwn5uJ
QViAjc5pINnqux9mzzQrhuHliSrzmk/PAVQxH2rNvGfez7oSITSi3qIPNVlGpCIi02tGDP/LYJPR
E52RlkzQCJ486tGjrd7gB4wtqY+Jyfa3AAAAAElFTkSuQmCC',
};

1;