/*                                                                
**  Copyright (C) 1996,2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* type.c
**/


#include <string.h>

#include "pfile.h"

vtype voidRec = {
  "void", NULL, NULL, NULL, NULL
};

vtype *VTypeList[MaxTypes + 3] = {
  &voidRec, &booleanRec, &integerRec, &realRec, &stringRec, &fileRec, &gRec,
  &structRec, &gcurRec, &imcurRec, &modeRec, &psetRec, &rangeRec,
  &commentRec, NULL
};


void *
Type2String (type, string)
     VType type;
     char *string;
{

  if (type == 0)
    return NULL;
  if (string == NULL)
    return NULL;

  if (type & ListType)
    {
      *string = '*';
      string++;
    }

  strcpy (string, VTypeList[TypeIndex (type)]->name);
  return string;
}


VType
String2Type (string)
     char *string;
{
  int i;
  int list = 0;

  if (*string == '*')
    {
      list = ListType;
      string++;
    }

  if (*string == 'f')
    i = FileType;
  else
    for (i = 0; VTypeList[i]; i++)
      if (!strcmp (string, VTypeList[i]->name))
	break;

  if (VTypeList[i] == NULL)
    {
      parerr = PARBADTYPE;
      return 0;
    }

  return i | list;
}
