/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkHat;
import net.sourceforge.plantuml.cucadiagram.LinkMiddleDecor;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class LinkType {
    private final LinkHat hat1;
    private final LinkDecor decor1;
    private final LinkStyle style;
    private final LinkDecor decor2;
    private final LinkHat hat2;
    private final LinkMiddleDecor middleDecor;

    public LinkType(LinkDecor linkDecor, LinkDecor linkDecor2) {
        this(LinkHat.NONE, linkDecor, linkDecor2, LinkHat.NONE);
    }

    public LinkType(LinkHat linkHat, LinkDecor linkDecor, LinkDecor linkDecor2, LinkHat linkHat2) {
        this(linkHat, linkDecor, LinkStyle.NORMAL, LinkMiddleDecor.NONE, linkDecor2, linkHat2);
    }

    public String toString() {
        return (Object)((Object)this.decor1) + "-" + (Object)((Object)this.style) + "-" + (Object)((Object)this.decor2);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        LinkType linkType = (LinkType)object;
        return this.decor1 == linkType.decor1 && this.decor2 == linkType.decor2 && this.style == linkType.style;
    }

    private LinkType(LinkHat linkHat, LinkDecor linkDecor, LinkStyle linkStyle, LinkMiddleDecor linkMiddleDecor, LinkDecor linkDecor2, LinkHat linkHat2) {
        this.decor1 = linkDecor;
        this.style = linkStyle;
        this.decor2 = linkDecor2;
        this.middleDecor = linkMiddleDecor;
        this.hat1 = linkHat;
        this.hat2 = linkHat2;
    }

    public boolean isDashed() {
        return this.style == LinkStyle.DASHED;
    }

    public boolean isDotted() {
        return this.style == LinkStyle.DOTTED;
    }

    public boolean isBold() {
        return this.style == LinkStyle.BOLD;
    }

    public boolean isInvisible() {
        return this.style == LinkStyle.INVISIBLE;
    }

    public LinkType getDashed() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.DASHED, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType getDotted() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.DOTTED, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType getBold() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.BOLD, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType getInterfaceProvider() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.__toremove_INTERFACE_PROVIDER, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType getInterfaceUser() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.__toremove_INTERFACE_USER, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType getInversed() {
        return new LinkType(this.hat2, this.decor2, this.style, this.middleDecor, this.decor1, this.hat1);
    }

    public LinkType withMiddleCircle() {
        return new LinkType(this.hat1, this.decor1, this.style, LinkMiddleDecor.CIRCLE, this.decor2, this.hat2);
    }

    public LinkType withMiddleCircleCircled() {
        return new LinkType(this.hat1, this.decor1, this.style, LinkMiddleDecor.CIRCLE_CIRCLED, this.decor2, this.hat2);
    }

    public LinkType withMiddleCircleCircled1() {
        return new LinkType(this.hat1, this.decor1, this.style, LinkMiddleDecor.CIRCLE_CIRCLED1, this.decor2, this.hat2);
    }

    public LinkType withMiddleCircleCircled2() {
        return new LinkType(this.hat1, this.decor1, this.style, LinkMiddleDecor.CIRCLE_CIRCLED2, this.decor2, this.hat2);
    }

    public LinkType getInvisible() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.INVISIBLE, this.middleDecor, this.decor2, this.hat2);
    }

    public String getSpecificDecorationSvek() {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = this.decor1 == LinkDecor.NONE && this.hat1 == LinkHat.NONE;
        boolean bl3 = bl = this.decor2 == LinkDecor.NONE && this.hat2 == LinkHat.NONE;
        if (bl2 && bl) {
            stringBuilder.append("arrowtail=none");
            stringBuilder.append(",arrowhead=none");
        } else if (!bl2 && !bl) {
            stringBuilder.append("dir=both,");
            stringBuilder.append("arrowtail=empty");
            stringBuilder.append(",arrowhead=empty");
        } else if (bl2 && !bl) {
            stringBuilder.append("arrowtail=empty");
            stringBuilder.append(",arrowhead=none");
            stringBuilder.append(",dir=back");
        } else if (!bl2 && bl) {
            stringBuilder.append("arrowtail=none");
            stringBuilder.append(",arrowhead=empty");
        }
        double d = Math.max(this.decor1.getArrowSize(), this.decor2.getArrowSize());
        if (d > 0.0) {
            stringBuilder.append(",arrowsize=" + d);
        }
        return stringBuilder.toString();
    }

    public final LinkDecor getDecor1() {
        return this.decor1;
    }

    public final LinkStyle getStyle() {
        return this.style;
    }

    public final LinkDecor getDecor2() {
        return this.decor2;
    }

    public boolean isExtendsOrAgregationOrCompositionOrPlus() {
        return this.isExtends() || this.isAgregationOrComposition() || this.isPlus();
    }

    private boolean isExtends() {
        return this.decor1 == LinkDecor.EXTENDS || this.decor2 == LinkDecor.EXTENDS;
    }

    private boolean isPlus() {
        return this.decor1 == LinkDecor.PLUS || this.decor2 == LinkDecor.PLUS;
    }

    private boolean isAgregationOrComposition() {
        return this.decor1 == LinkDecor.AGREGATION || this.decor2 == LinkDecor.AGREGATION || this.decor1 == LinkDecor.COMPOSITION || this.decor2 == LinkDecor.COMPOSITION;
    }

    public LinkType getPart1() {
        return new LinkType(this.hat1, this.decor1, this.style, this.middleDecor, LinkDecor.NONE, LinkHat.NONE);
    }

    public LinkType getPart2() {
        return new LinkType(LinkHat.NONE, LinkDecor.NONE, this.style, this.middleDecor, this.decor2, this.hat2);
    }

    public UStroke getStroke() {
        if (this.style == LinkStyle.DASHED) {
            return new UStroke(7.0, 7.0, 1.0);
        }
        if (this.style == LinkStyle.DOTTED) {
            return new UStroke(1.0, 3.0, 1.0);
        }
        if (this.style == LinkStyle.BOLD) {
            return new UStroke(2.0);
        }
        return new UStroke();
    }

    public LinkMiddleDecor getMiddleDecor() {
        return this.middleDecor;
    }

    public LinkHat getHat1() {
        return this.hat1;
    }

    public LinkHat getHat2() {
        return this.hat2;
    }
}

