package Google::Ads::AdWords::v201302::ManualCPCAdGroupCriterionBids;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201302' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201302::AdGroupCriterionBids);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %AdGroupCriterionBids__Type_of :ATTR(:get<AdGroupCriterionBids__Type>);
my %maxCpc_of :ATTR(:get<maxCpc>);
my %bidSource_of :ATTR(:get<bidSource>);
my %enhancedCpcEnabled_of :ATTR(:get<enhancedCpcEnabled>);

__PACKAGE__->_factory(
    [ qw(        AdGroupCriterionBids__Type
        maxCpc
        bidSource
        enhancedCpcEnabled

    ) ],
    {
        'AdGroupCriterionBids__Type' => \%AdGroupCriterionBids__Type_of,
        'maxCpc' => \%maxCpc_of,
        'bidSource' => \%bidSource_of,
        'enhancedCpcEnabled' => \%enhancedCpcEnabled_of,
    },
    {
        'AdGroupCriterionBids__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'maxCpc' => 'Google::Ads::AdWords::v201302::Bid',
        'bidSource' => 'Google::Ads::AdWords::v201302::BidSource',
        'enhancedCpcEnabled' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'AdGroupCriterionBids__Type' => 'AdGroupCriterionBids.Type',
        'maxCpc' => 'maxCpc',
        'bidSource' => 'bidSource',
        'enhancedCpcEnabled' => 'enhancedCpcEnabled',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201302::ManualCPCAdGroupCriterionBids

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ManualCPCAdGroupCriterionBids from the namespace https://adwords.google.com/api/adwords/cm/v201302.

Data representing a criterion level cost-per-click bid. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * maxCpc


=item * bidSource


=item * enhancedCpcEnabled




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

