package Alvis::Document::Encoding;

use warnings;
use strict;

$Alvis::Document::Encoding::VERSION = '0.1';

use HTML::Encoding;
use Encode;
use Encode::Guess;

use Alvis::Document::Type;

#############################################################################
#
#  A collection of routines for checking UTF-8 validity, guessing the
#  encoding of a document etc.
#
#############################################################################

#############################################################################
#
#     Global variables & constants
#
##############################################################################

my $DEBUG=0;

#
# Invalid Utf-8 codes (UTF-16 surrogates and non-valid codes) 
#
my %InvalidUtf8Code=(
 55296=>1,  55297=>1,  55298=>1,  55299=>1,  55300=>1,  55301=>1,  55302=>1, 
 55303=>1,  55304=>1,  55305=>1,  55306=>1,  55307=>1,  55308=>1,  55309=>1, 
 55310=>1,  55311=>1,  55312=>1,  55313=>1,  55314=>1,  55315=>1,  55316=>1, 
 55317=>1,  55318=>1,  55319=>1,  55320=>1,  55321=>1,  55322=>1,  55323=>1, 
 55324=>1,  55325=>1,  55326=>1,  55327=>1,  55328=>1,  55329=>1,  55330=>1, 
 55331=>1,  55332=>1,  55333=>1,  55334=>1,  55335=>1,  55336=>1,  55337=>1, 
 55338=>1,  55339=>1,  55340=>1,  55341=>1,  55342=>1,  55343=>1,  55344=>1, 
 55345=>1,  55346=>1,  55347=>1,  55348=>1,  55349=>1,  55350=>1,  55351=>1, 
 55352=>1,  55353=>1,  55354=>1,  55355=>1,  55356=>1,  55357=>1,  55358=>1, 
 55359=>1,  55360=>1,  55361=>1,  55362=>1,  55363=>1,  55364=>1,  55365=>1, 
 55366=>1,  55367=>1,  55368=>1,  55369=>1,  55370=>1,  55371=>1,  55372=>1, 
 55373=>1,  55374=>1,  55375=>1,  55376=>1,  55377=>1,  55378=>1,  55379=>1, 
 55380=>1,  55381=>1,  55382=>1,  55383=>1,  55384=>1,  55385=>1,  55386=>1, 
 55387=>1,  55388=>1,  55389=>1,  55390=>1,  55391=>1,  55392=>1,  55393=>1, 
 55394=>1,  55395=>1,  55396=>1,  55397=>1,  55398=>1,  55399=>1,  55400=>1, 
 55401=>1,  55402=>1,  55403=>1,  55404=>1,  55405=>1,  55406=>1,  55407=>1, 
 55408=>1,  55409=>1,  55410=>1,  55411=>1,  55412=>1,  55413=>1,  55414=>1, 
 55415=>1,  55416=>1,  55417=>1,  55418=>1,  55419=>1,  55420=>1,  55421=>1, 
 55422=>1,  55423=>1,  55424=>1,  55425=>1,  55426=>1,  55427=>1,  55428=>1, 
 55429=>1,  55430=>1,  55431=>1,  55432=>1,  55433=>1,  55434=>1,  55435=>1, 
 55436=>1,  55437=>1,  55438=>1,  55439=>1,  55440=>1,  55441=>1,  55442=>1, 
 55443=>1,  55444=>1,  55445=>1,  55446=>1,  55447=>1,  55448=>1,  55449=>1, 
 55450=>1,  55451=>1,  55452=>1,  55453=>1,  55454=>1,  55455=>1,  55456=>1, 
 55457=>1,  55458=>1,  55459=>1,  55460=>1,  55461=>1,  55462=>1,  55463=>1, 
 55464=>1,  55465=>1,  55466=>1,  55467=>1,  55468=>1,  55469=>1,  55470=>1, 
 55471=>1,  55472=>1,  55473=>1,  55474=>1,  55475=>1,  55476=>1,  55477=>1, 
 55478=>1,  55479=>1,  55480=>1,  55481=>1,  55482=>1,  55483=>1,  55484=>1, 
 55485=>1,  55486=>1,  55487=>1,  55488=>1,  55489=>1,  55490=>1,  55491=>1, 
 55492=>1,  55493=>1,  55494=>1,  55495=>1,  55496=>1,  55497=>1,  55498=>1, 
 55499=>1,  55500=>1,  55501=>1,  55502=>1,  55503=>1,  55504=>1,  55505=>1, 
 55506=>1,  55507=>1,  55508=>1,  55509=>1,  55510=>1,  55511=>1,  55512=>1, 
 55513=>1,  55514=>1,  55515=>1,  55516=>1,  55517=>1,  55518=>1,  55519=>1, 
 55520=>1,  55521=>1,  55522=>1,  55523=>1,  55524=>1,  55525=>1,  55526=>1, 
 55527=>1,  55528=>1,  55529=>1,  55530=>1,  55531=>1,  55532=>1,  55533=>1, 
 55534=>1,  55535=>1,  55536=>1,  55537=>1,  55538=>1,  55539=>1,  55540=>1, 
 55541=>1,  55542=>1,  55543=>1,  55544=>1,  55545=>1,  55546=>1,  55547=>1, 
 55548=>1,  55549=>1,  55550=>1,  55551=>1,  55552=>1,  55553=>1,  55554=>1, 
 55555=>1,  55556=>1,  55557=>1,  55558=>1,  55559=>1,  55560=>1,  55561=>1, 
 55562=>1,  55563=>1,  55564=>1,  55565=>1,  55566=>1,  55567=>1,  55568=>1, 
 55569=>1,  55570=>1,  55571=>1,  55572=>1,  55573=>1,  55574=>1,  55575=>1, 
 55576=>1,  55577=>1,  55578=>1,  55579=>1,  55580=>1,  55581=>1,  55582=>1, 
 55583=>1,  55584=>1,  55585=>1,  55586=>1,  55587=>1,  55588=>1,  55589=>1, 
 55590=>1,  55591=>1,  55592=>1,  55593=>1,  55594=>1,  55595=>1,  55596=>1, 
 55597=>1,  55598=>1,  55599=>1,  55600=>1,  55601=>1,  55602=>1,  55603=>1, 
 55604=>1,  55605=>1,  55606=>1,  55607=>1,  55608=>1,  55609=>1,  55610=>1, 
 55611=>1,  55612=>1,  55613=>1,  55614=>1,  55615=>1,  55616=>1,  55617=>1, 
 55618=>1,  55619=>1,  55620=>1,  55621=>1,  55622=>1,  55623=>1,  55624=>1, 
 55625=>1,  55626=>1,  55627=>1,  55628=>1,  55629=>1,  55630=>1,  55631=>1, 
 55632=>1,  55633=>1,  55634=>1,  55635=>1,  55636=>1,  55637=>1,  55638=>1, 
 55639=>1,  55640=>1,  55641=>1,  55642=>1,  55643=>1,  55644=>1,  55645=>1, 
 55646=>1,  55647=>1,  55648=>1,  55649=>1,  55650=>1,  55651=>1,  55652=>1, 
 55653=>1,  55654=>1,  55655=>1,  55656=>1,  55657=>1,  55658=>1,  55659=>1, 
 55660=>1,  55661=>1,  55662=>1,  55663=>1,  55664=>1,  55665=>1,  55666=>1, 
 55667=>1,  55668=>1,  55669=>1,  55670=>1,  55671=>1,  55672=>1,  55673=>1, 
 55674=>1,  55675=>1,  55676=>1,  55677=>1,  55678=>1,  55679=>1,  55680=>1, 
 55681=>1,  55682=>1,  55683=>1,  55684=>1,  55685=>1,  55686=>1,  55687=>1, 
 55688=>1,  55689=>1,  55690=>1,  55691=>1,  55692=>1,  55693=>1,  55694=>1, 
 55695=>1,  55696=>1,  55697=>1,  55698=>1,  55699=>1,  55700=>1,  55701=>1, 
 55702=>1,  55703=>1,  55704=>1,  55705=>1,  55706=>1,  55707=>1,  55708=>1, 
 55709=>1,  55710=>1,  55711=>1,  55712=>1,  55713=>1,  55714=>1,  55715=>1, 
 55716=>1,  55717=>1,  55718=>1,  55719=>1,  55720=>1,  55721=>1,  55722=>1, 
 55723=>1,  55724=>1,  55725=>1,  55726=>1,  55727=>1,  55728=>1,  55729=>1, 
 55730=>1,  55731=>1,  55732=>1,  55733=>1,  55734=>1,  55735=>1,  55736=>1, 
 55737=>1,  55738=>1,  55739=>1,  55740=>1,  55741=>1,  55742=>1,  55743=>1, 
 55744=>1,  55745=>1,  55746=>1,  55747=>1,  55748=>1,  55749=>1,  55750=>1, 
 55751=>1,  55752=>1,  55753=>1,  55754=>1,  55755=>1,  55756=>1,  55757=>1, 
 55758=>1,  55759=>1,  55760=>1,  55761=>1,  55762=>1,  55763=>1,  55764=>1, 
 55765=>1,  55766=>1,  55767=>1,  55768=>1,  55769=>1,  55770=>1,  55771=>1, 
 55772=>1,  55773=>1,  55774=>1,  55775=>1,  55776=>1,  55777=>1,  55778=>1, 
 55779=>1,  55780=>1,  55781=>1,  55782=>1,  55783=>1,  55784=>1,  55785=>1, 
 55786=>1,  55787=>1,  55788=>1,  55789=>1,  55790=>1,  55791=>1,  55792=>1, 
 55793=>1,  55794=>1,  55795=>1,  55796=>1,  55797=>1,  55798=>1,  55799=>1, 
 55800=>1,  55801=>1,  55802=>1,  55803=>1,  55804=>1,  55805=>1,  55806=>1, 
 55807=>1,  55808=>1,  55809=>1,  55810=>1,  55811=>1,  55812=>1,  55813=>1, 
 55814=>1,  55815=>1,  55816=>1,  55817=>1,  55818=>1,  55819=>1,  55820=>1, 
 55821=>1,  55822=>1,  55823=>1,  55824=>1,  55825=>1,  55826=>1,  55827=>1, 
 55828=>1,  55829=>1,  55830=>1,  55831=>1,  55832=>1,  55833=>1,  55834=>1, 
 55835=>1,  55836=>1,  55837=>1,  55838=>1,  55839=>1,  55840=>1,  55841=>1, 
 55842=>1,  55843=>1,  55844=>1,  55845=>1,  55846=>1,  55847=>1,  55848=>1, 
 55849=>1,  55850=>1,  55851=>1,  55852=>1,  55853=>1,  55854=>1,  55855=>1, 
 55856=>1,  55857=>1,  55858=>1,  55859=>1,  55860=>1,  55861=>1,  55862=>1, 
 55863=>1,  55864=>1,  55865=>1,  55866=>1,  55867=>1,  55868=>1,  55869=>1, 
 55870=>1,  55871=>1,  55872=>1,  55873=>1,  55874=>1,  55875=>1,  55876=>1, 
 55877=>1,  55878=>1,  55879=>1,  55880=>1,  55881=>1,  55882=>1,  55883=>1, 
 55884=>1,  55885=>1,  55886=>1,  55887=>1,  55888=>1,  55889=>1,  55890=>1, 
 55891=>1,  55892=>1,  55893=>1,  55894=>1,  55895=>1,  55896=>1,  55897=>1, 
 55898=>1,  55899=>1,  55900=>1,  55901=>1,  55902=>1,  55903=>1,  55904=>1, 
 55905=>1,  55906=>1,  55907=>1,  55908=>1,  55909=>1,  55910=>1,  55911=>1, 
 55912=>1,  55913=>1,  55914=>1,  55915=>1,  55916=>1,  55917=>1,  55918=>1, 
 55919=>1,  55920=>1,  55921=>1,  55922=>1,  55923=>1,  55924=>1,  55925=>1, 
 55926=>1,  55927=>1,  55928=>1,  55929=>1,  55930=>1,  55931=>1,  55932=>1, 
 55933=>1,  55934=>1,  55935=>1,  55936=>1,  55937=>1,  55938=>1,  55939=>1, 
 55940=>1,  55941=>1,  55942=>1,  55943=>1,  55944=>1,  55945=>1,  55946=>1, 
 55947=>1,  55948=>1,  55949=>1,  55950=>1,  55951=>1,  55952=>1,  55953=>1, 
 55954=>1,  55955=>1,  55956=>1,  55957=>1,  55958=>1,  55959=>1,  55960=>1, 
 55961=>1,  55962=>1,  55963=>1,  55964=>1,  55965=>1,  55966=>1,  55967=>1, 
 55968=>1,  55969=>1,  55970=>1,  55971=>1,  55972=>1,  55973=>1,  55974=>1, 
 55975=>1,  55976=>1,  55977=>1,  55978=>1,  55979=>1,  55980=>1,  55981=>1, 
 55982=>1,  55983=>1,  55984=>1,  55985=>1,  55986=>1,  55987=>1,  55988=>1, 
 55989=>1,  55990=>1,  55991=>1,  55992=>1,  55993=>1,  55994=>1,  55995=>1, 
 55996=>1,  55997=>1,  55998=>1,  55999=>1,  56000=>1,  56001=>1,  56002=>1, 
 56003=>1,  56004=>1,  56005=>1,  56006=>1,  56007=>1,  56008=>1,  56009=>1, 
 56010=>1,  56011=>1,  56012=>1,  56013=>1,  56014=>1,  56015=>1,  56016=>1, 
 56017=>1,  56018=>1,  56019=>1,  56020=>1,  56021=>1,  56022=>1,  56023=>1, 
 56024=>1,  56025=>1,  56026=>1,  56027=>1,  56028=>1,  56029=>1,  56030=>1, 
 56031=>1,  56032=>1,  56033=>1,  56034=>1,  56035=>1,  56036=>1,  56037=>1, 
 56038=>1,  56039=>1,  56040=>1,  56041=>1,  56042=>1,  56043=>1,  56044=>1, 
 56045=>1,  56046=>1,  56047=>1,  56048=>1,  56049=>1,  56050=>1,  56051=>1, 
 56052=>1,  56053=>1,  56054=>1,  56055=>1,  56056=>1,  56057=>1,  56058=>1, 
 56059=>1,  56060=>1,  56061=>1,  56062=>1,  56063=>1,  56064=>1,  56065=>1, 
 56066=>1,  56067=>1,  56068=>1,  56069=>1,  56070=>1,  56071=>1,  56072=>1, 
 56073=>1,  56074=>1,  56075=>1,  56076=>1,  56077=>1,  56078=>1,  56079=>1, 
 56080=>1,  56081=>1,  56082=>1,  56083=>1,  56084=>1,  56085=>1,  56086=>1, 
 56087=>1,  56088=>1,  56089=>1,  56090=>1,  56091=>1,  56092=>1,  56093=>1, 
 56094=>1,  56095=>1,  56096=>1,  56097=>1,  56098=>1,  56099=>1,  56100=>1, 
 56101=>1,  56102=>1,  56103=>1,  56104=>1,  56105=>1,  56106=>1,  56107=>1, 
 56108=>1,  56109=>1,  56110=>1,  56111=>1,  56112=>1,  56113=>1,  56114=>1, 
 56115=>1,  56116=>1,  56117=>1,  56118=>1,  56119=>1,  56120=>1,  56121=>1, 
 56122=>1,  56123=>1,  56124=>1,  56125=>1,  56126=>1,  56127=>1,  56128=>1, 
 56129=>1,  56130=>1,  56131=>1,  56132=>1,  56133=>1,  56134=>1,  56135=>1, 
 56136=>1,  56137=>1,  56138=>1,  56139=>1,  56140=>1,  56141=>1,  56142=>1, 
 56143=>1,  56144=>1,  56145=>1,  56146=>1,  56147=>1,  56148=>1,  56149=>1, 
 56150=>1,  56151=>1,  56152=>1,  56153=>1,  56154=>1,  56155=>1,  56156=>1, 
 56157=>1,  56158=>1,  56159=>1,  56160=>1,  56161=>1,  56162=>1,  56163=>1, 
 56164=>1,  56165=>1,  56166=>1,  56167=>1,  56168=>1,  56169=>1,  56170=>1, 
 56171=>1,  56172=>1,  56173=>1,  56174=>1,  56175=>1,  56176=>1,  56177=>1, 
 56178=>1,  56179=>1,  56180=>1,  56181=>1,  56182=>1,  56183=>1,  56184=>1, 
 56185=>1,  56186=>1,  56187=>1,  56188=>1,  56189=>1,  56190=>1,  56191=>1, 
 56192=>1,  56193=>1,  56194=>1,  56195=>1,  56196=>1,  56197=>1,  56198=>1, 
 56199=>1,  56200=>1,  56201=>1,  56202=>1,  56203=>1,  56204=>1,  56205=>1, 
 56206=>1,  56207=>1,  56208=>1,  56209=>1,  56210=>1,  56211=>1,  56212=>1, 
 56213=>1,  56214=>1,  56215=>1,  56216=>1,  56217=>1,  56218=>1,  56219=>1, 
 56220=>1,  56221=>1,  56222=>1,  56223=>1,  56224=>1,  56225=>1,  56226=>1, 
 56227=>1,  56228=>1,  56229=>1,  56230=>1,  56231=>1,  56232=>1,  56233=>1, 
 56234=>1,  56235=>1,  56236=>1,  56237=>1,  56238=>1,  56239=>1,  56240=>1, 
 56241=>1,  56242=>1,  56243=>1,  56244=>1,  56245=>1,  56246=>1,  56247=>1, 
 56248=>1,  56249=>1,  56250=>1,  56251=>1,  56252=>1,  56253=>1,  56254=>1, 
 56255=>1,  56256=>1,  56257=>1,  56258=>1,  56259=>1,  56260=>1,  56261=>1, 
 56262=>1,  56263=>1,  56264=>1,  56265=>1,  56266=>1,  56267=>1,  56268=>1, 
 56269=>1,  56270=>1,  56271=>1,  56272=>1,  56273=>1,  56274=>1,  56275=>1, 
 56276=>1,  56277=>1,  56278=>1,  56279=>1,  56280=>1,  56281=>1,  56282=>1, 
 56283=>1,  56284=>1,  56285=>1,  56286=>1,  56287=>1,  56288=>1,  56289=>1, 
 56290=>1,  56291=>1,  56292=>1,  56293=>1,  56294=>1,  56295=>1,  56296=>1, 
 56297=>1,  56298=>1,  56299=>1,  56300=>1,  56301=>1,  56302=>1,  56303=>1, 
 56304=>1,  56305=>1,  56306=>1,  56307=>1,  56308=>1,  56309=>1,  56310=>1, 
 56311=>1,  56312=>1,  56313=>1,  56314=>1,  56315=>1,  56316=>1,  56317=>1, 
 56318=>1,  56319=>1,  56320=>1,  56321=>1,  56322=>1,  56323=>1,  56324=>1, 
 56325=>1,  56326=>1,  56327=>1,  56328=>1,  56329=>1,  56330=>1,  56331=>1, 
 56332=>1,  56333=>1,  56334=>1,  56335=>1,  56336=>1,  56337=>1,  56338=>1, 
 56339=>1,  56340=>1,  56341=>1,  56342=>1,  56343=>1,  56344=>1,  56345=>1, 
 56346=>1,  56347=>1,  56348=>1,  56349=>1,  56350=>1,  56351=>1,  56352=>1, 
 56353=>1,  56354=>1,  56355=>1,  56356=>1,  56357=>1,  56358=>1,  56359=>1, 
 56360=>1,  56361=>1,  56362=>1,  56363=>1,  56364=>1,  56365=>1,  56366=>1, 
 56367=>1,  56368=>1,  56369=>1,  56370=>1,  56371=>1,  56372=>1,  56373=>1, 
 56374=>1,  56375=>1,  56376=>1,  56377=>1,  56378=>1,  56379=>1,  56380=>1, 
 56381=>1,  56382=>1,  56383=>1,  56384=>1,  56385=>1,  56386=>1,  56387=>1, 
 56388=>1,  56389=>1,  56390=>1,  56391=>1,  56392=>1,  56393=>1,  56394=>1, 
 56395=>1,  56396=>1,  56397=>1,  56398=>1,  56399=>1,  56400=>1,  56401=>1, 
 56402=>1,  56403=>1,  56404=>1,  56405=>1,  56406=>1,  56407=>1,  56408=>1, 
 56409=>1,  56410=>1,  56411=>1,  56412=>1,  56413=>1,  56414=>1,  56415=>1, 
 56416=>1,  56417=>1,  56418=>1,  56419=>1,  56420=>1,  56421=>1,  56422=>1, 
 56423=>1,  56424=>1,  56425=>1,  56426=>1,  56427=>1,  56428=>1,  56429=>1, 
 56430=>1,  56431=>1,  56432=>1,  56433=>1,  56434=>1,  56435=>1,  56436=>1, 
 56437=>1,  56438=>1,  56439=>1,  56440=>1,  56441=>1,  56442=>1,  56443=>1, 
 56444=>1,  56445=>1,  56446=>1,  56447=>1,  56448=>1,  56449=>1,  56450=>1, 
 56451=>1,  56452=>1,  56453=>1,  56454=>1,  56455=>1,  56456=>1,  56457=>1, 
 56458=>1,  56459=>1,  56460=>1,  56461=>1,  56462=>1,  56463=>1,  56464=>1, 
 56465=>1,  56466=>1,  56467=>1,  56468=>1,  56469=>1,  56470=>1,  56471=>1, 
 56472=>1,  56473=>1,  56474=>1,  56475=>1,  56476=>1,  56477=>1,  56478=>1, 
 56479=>1,  56480=>1,  56481=>1,  56482=>1,  56483=>1,  56484=>1,  56485=>1, 
 56486=>1,  56487=>1,  56488=>1,  56489=>1,  56490=>1,  56491=>1,  56492=>1, 
 56493=>1,  56494=>1,  56495=>1,  56496=>1,  56497=>1,  56498=>1,  56499=>1, 
 56500=>1,  56501=>1,  56502=>1,  56503=>1,  56504=>1,  56505=>1,  56506=>1, 
 56507=>1,  56508=>1,  56509=>1,  56510=>1,  56511=>1,  56512=>1,  56513=>1, 
 56514=>1,  56515=>1,  56516=>1,  56517=>1,  56518=>1,  56519=>1,  56520=>1, 
 56521=>1,  56522=>1,  56523=>1,  56524=>1,  56525=>1,  56526=>1,  56527=>1, 
 56528=>1,  56529=>1,  56530=>1,  56531=>1,  56532=>1,  56533=>1,  56534=>1, 
 56535=>1,  56536=>1,  56537=>1,  56538=>1,  56539=>1,  56540=>1,  56541=>1, 
 56542=>1,  56543=>1,  56544=>1,  56545=>1,  56546=>1,  56547=>1,  56548=>1, 
 56549=>1,  56550=>1,  56551=>1,  56552=>1,  56553=>1,  56554=>1,  56555=>1, 
 56556=>1,  56557=>1,  56558=>1,  56559=>1,  56560=>1,  56561=>1,  56562=>1, 
 56563=>1,  56564=>1,  56565=>1,  56566=>1,  56567=>1,  56568=>1,  56569=>1, 
 56570=>1,  56571=>1,  56572=>1,  56573=>1,  56574=>1,  56575=>1,  56576=>1, 
 56577=>1,  56578=>1,  56579=>1,  56580=>1,  56581=>1,  56582=>1,  56583=>1, 
 56584=>1,  56585=>1,  56586=>1,  56587=>1,  56588=>1,  56589=>1,  56590=>1, 
 56591=>1,  56592=>1,  56593=>1,  56594=>1,  56595=>1,  56596=>1,  56597=>1, 
 56598=>1,  56599=>1,  56600=>1,  56601=>1,  56602=>1,  56603=>1,  56604=>1, 
 56605=>1,  56606=>1,  56607=>1,  56608=>1,  56609=>1,  56610=>1,  56611=>1, 
 56612=>1,  56613=>1,  56614=>1,  56615=>1,  56616=>1,  56617=>1,  56618=>1, 
 56619=>1,  56620=>1,  56621=>1,  56622=>1,  56623=>1,  56624=>1,  56625=>1, 
 56626=>1,  56627=>1,  56628=>1,  56629=>1,  56630=>1,  56631=>1,  56632=>1, 
 56633=>1,  56634=>1,  56635=>1,  56636=>1,  56637=>1,  56638=>1,  56639=>1, 
 56640=>1,  56641=>1,  56642=>1,  56643=>1,  56644=>1,  56645=>1,  56646=>1, 
 56647=>1,  56648=>1,  56649=>1,  56650=>1,  56651=>1,  56652=>1,  56653=>1, 
 56654=>1,  56655=>1,  56656=>1,  56657=>1,  56658=>1,  56659=>1,  56660=>1, 
 56661=>1,  56662=>1,  56663=>1,  56664=>1,  56665=>1,  56666=>1,  56667=>1, 
 56668=>1,  56669=>1,  56670=>1,  56671=>1,  56672=>1,  56673=>1,  56674=>1, 
 56675=>1,  56676=>1,  56677=>1,  56678=>1,  56679=>1,  56680=>1,  56681=>1, 
 56682=>1,  56683=>1,  56684=>1,  56685=>1,  56686=>1,  56687=>1,  56688=>1, 
 56689=>1,  56690=>1,  56691=>1,  56692=>1,  56693=>1,  56694=>1,  56695=>1, 
 56696=>1,  56697=>1,  56698=>1,  56699=>1,  56700=>1,  56701=>1,  56702=>1, 
 56703=>1,  56704=>1,  56705=>1,  56706=>1,  56707=>1,  56708=>1,  56709=>1, 
 56710=>1,  56711=>1,  56712=>1,  56713=>1,  56714=>1,  56715=>1,  56716=>1, 
 56717=>1,  56718=>1,  56719=>1,  56720=>1,  56721=>1,  56722=>1,  56723=>1, 
 56724=>1,  56725=>1,  56726=>1,  56727=>1,  56728=>1,  56729=>1,  56730=>1, 
 56731=>1,  56732=>1,  56733=>1,  56734=>1,  56735=>1,  56736=>1,  56737=>1, 
 56738=>1,  56739=>1,  56740=>1,  56741=>1,  56742=>1,  56743=>1,  56744=>1, 
 56745=>1,  56746=>1,  56747=>1,  56748=>1,  56749=>1,  56750=>1,  56751=>1, 
 56752=>1,  56753=>1,  56754=>1,  56755=>1,  56756=>1,  56757=>1,  56758=>1, 
 56759=>1,  56760=>1,  56761=>1,  56762=>1,  56763=>1,  56764=>1,  56765=>1, 
 56766=>1,  56767=>1,  56768=>1,  56769=>1,  56770=>1,  56771=>1,  56772=>1, 
 56773=>1,  56774=>1,  56775=>1,  56776=>1,  56777=>1,  56778=>1,  56779=>1, 
 56780=>1,  56781=>1,  56782=>1,  56783=>1,  56784=>1,  56785=>1,  56786=>1, 
 56787=>1,  56788=>1,  56789=>1,  56790=>1,  56791=>1,  56792=>1,  56793=>1, 
 56794=>1,  56795=>1,  56796=>1,  56797=>1,  56798=>1,  56799=>1,  56800=>1, 
 56801=>1,  56802=>1,  56803=>1,  56804=>1,  56805=>1,  56806=>1,  56807=>1, 
 56808=>1,  56809=>1,  56810=>1,  56811=>1,  56812=>1,  56813=>1,  56814=>1, 
 56815=>1,  56816=>1,  56817=>1,  56818=>1,  56819=>1,  56820=>1,  56821=>1, 
 56822=>1,  56823=>1,  56824=>1,  56825=>1,  56826=>1,  56827=>1,  56828=>1, 
 56829=>1,  56830=>1,  56831=>1,  56832=>1,  56833=>1,  56834=>1,  56835=>1, 
 56836=>1,  56837=>1,  56838=>1,  56839=>1,  56840=>1,  56841=>1,  56842=>1, 
 56843=>1,  56844=>1,  56845=>1,  56846=>1,  56847=>1,  56848=>1,  56849=>1, 
 56850=>1,  56851=>1,  56852=>1,  56853=>1,  56854=>1,  56855=>1,  56856=>1, 
 56857=>1,  56858=>1,  56859=>1,  56860=>1,  56861=>1,  56862=>1,  56863=>1, 
 56864=>1,  56865=>1,  56866=>1,  56867=>1,  56868=>1,  56869=>1,  56870=>1, 
 56871=>1,  56872=>1,  56873=>1,  56874=>1,  56875=>1,  56876=>1,  56877=>1, 
 56878=>1,  56879=>1,  56880=>1,  56881=>1,  56882=>1,  56883=>1,  56884=>1, 
 56885=>1,  56886=>1,  56887=>1,  56888=>1,  56889=>1,  56890=>1,  56891=>1, 
 56892=>1,  56893=>1,  56894=>1,  56895=>1,  56896=>1,  56897=>1,  56898=>1, 
 56899=>1,  56900=>1,  56901=>1,  56902=>1,  56903=>1,  56904=>1,  56905=>1, 
 56906=>1,  56907=>1,  56908=>1,  56909=>1,  56910=>1,  56911=>1,  56912=>1, 
 56913=>1,  56914=>1,  56915=>1,  56916=>1,  56917=>1,  56918=>1,  56919=>1, 
 56920=>1,  56921=>1,  56922=>1,  56923=>1,  56924=>1,  56925=>1,  56926=>1, 
 56927=>1,  56928=>1,  56929=>1,  56930=>1,  56931=>1,  56932=>1,  56933=>1, 
 56934=>1,  56935=>1,  56936=>1,  56937=>1,  56938=>1,  56939=>1,  56940=>1, 
 56941=>1,  56942=>1,  56943=>1,  56944=>1,  56945=>1,  56946=>1,  56947=>1, 
 56948=>1,  56949=>1,  56950=>1,  56951=>1,  56952=>1,  56953=>1,  56954=>1, 
 56955=>1,  56956=>1,  56957=>1,  56958=>1,  56959=>1,  56960=>1,  56961=>1, 
 56962=>1,  56963=>1,  56964=>1,  56965=>1,  56966=>1,  56967=>1,  56968=>1, 
 56969=>1,  56970=>1,  56971=>1,  56972=>1,  56973=>1,  56974=>1,  56975=>1, 
 56976=>1,  56977=>1,  56978=>1,  56979=>1,  56980=>1,  56981=>1,  56982=>1, 
 56983=>1,  56984=>1,  56985=>1,  56986=>1,  56987=>1,  56988=>1,  56989=>1, 
 56990=>1,  56991=>1,  56992=>1,  56993=>1,  56994=>1,  56995=>1,  56996=>1, 
 56997=>1,  56998=>1,  56999=>1,  57000=>1,  57001=>1,  57002=>1,  57003=>1, 
 57004=>1,  57005=>1,  57006=>1,  57007=>1,  57008=>1,  57009=>1,  57010=>1, 
 57011=>1,  57012=>1,  57013=>1,  57014=>1,  57015=>1,  57016=>1,  57017=>1, 
 57018=>1,  57019=>1,  57020=>1,  57021=>1,  57022=>1,  57023=>1,  57024=>1, 
 57025=>1,  57026=>1,  57027=>1,  57028=>1,  57029=>1,  57030=>1,  57031=>1, 
 57032=>1,  57033=>1,  57034=>1,  57035=>1,  57036=>1,  57037=>1,  57038=>1, 
 57039=>1,  57040=>1,  57041=>1,  57042=>1,  57043=>1,  57044=>1,  57045=>1, 
 57046=>1,  57047=>1,  57048=>1,  57049=>1,  57050=>1,  57051=>1,  57052=>1, 
 57053=>1,  57054=>1,  57055=>1,  57056=>1,  57057=>1,  57058=>1,  57059=>1, 
 57060=>1,  57061=>1,  57062=>1,  57063=>1,  57064=>1,  57065=>1,  57066=>1, 
 57067=>1,  57068=>1,  57069=>1,  57070=>1,  57071=>1,  57072=>1,  57073=>1, 
 57074=>1,  57075=>1,  57076=>1,  57077=>1,  57078=>1,  57079=>1,  57080=>1, 
 57081=>1,  57082=>1,  57083=>1,  57084=>1,  57085=>1,  57086=>1,  57087=>1, 
 57088=>1,  57089=>1,  57090=>1,  57091=>1,  57092=>1,  57093=>1,  57094=>1, 
 57095=>1,  57096=>1,  57097=>1,  57098=>1,  57099=>1,  57100=>1,  57101=>1, 
 57102=>1,  57103=>1,  57104=>1,  57105=>1,  57106=>1,  57107=>1,  57108=>1, 
 57109=>1,  57110=>1,  57111=>1,  57112=>1,  57113=>1,  57114=>1,  57115=>1, 
 57116=>1,  57117=>1,  57118=>1,  57119=>1,  57120=>1,  57121=>1,  57122=>1, 
 57123=>1,  57124=>1,  57125=>1,  57126=>1,  57127=>1,  57128=>1,  57129=>1, 
 57130=>1,  57131=>1,  57132=>1,  57133=>1,  57134=>1,  57135=>1,  57136=>1, 
 57137=>1,  57138=>1,  57139=>1,  57140=>1,  57141=>1,  57142=>1,  57143=>1, 
 57144=>1,  57145=>1,  57146=>1,  57147=>1,  57148=>1,  57149=>1,  57150=>1, 
 57151=>1,  57152=>1,  57153=>1,  57154=>1,  57155=>1,  57156=>1,  57157=>1, 
 57158=>1,  57159=>1,  57160=>1,  57161=>1,  57162=>1,  57163=>1,  57164=>1, 
 57165=>1,  57166=>1,  57167=>1,  57168=>1,  57169=>1,  57170=>1,  57171=>1, 
 57172=>1,  57173=>1,  57174=>1,  57175=>1,  57176=>1,  57177=>1,  57178=>1, 
 57179=>1,  57180=>1,  57181=>1,  57182=>1,  57183=>1,  57184=>1,  57185=>1, 
 57186=>1,  57187=>1,  57188=>1,  57189=>1,  57190=>1,  57191=>1,  57192=>1, 
 57193=>1,  57194=>1,  57195=>1,  57196=>1,  57197=>1,  57198=>1,  57199=>1, 
 57200=>1,  57201=>1,  57202=>1,  57203=>1,  57204=>1,  57205=>1,  57206=>1, 
 57207=>1,  57208=>1,  57209=>1,  57210=>1,  57211=>1,  57212=>1,  57213=>1, 
 57214=>1,  57215=>1,  57216=>1,  57217=>1,  57218=>1,  57219=>1,  57220=>1, 
 57221=>1,  57222=>1,  57223=>1,  57224=>1,  57225=>1,  57226=>1,  57227=>1, 
 57228=>1,  57229=>1,  57230=>1,  57231=>1,  57232=>1,  57233=>1,  57234=>1, 
 57235=>1,  57236=>1,  57237=>1,  57238=>1,  57239=>1,  57240=>1,  57241=>1, 
 57242=>1,  57243=>1,  57244=>1,  57245=>1,  57246=>1,  57247=>1,  57248=>1, 
 57249=>1,  57250=>1,  57251=>1,  57252=>1,  57253=>1,  57254=>1,  57255=>1, 
 57256=>1,  57257=>1,  57258=>1,  57259=>1,  57260=>1,  57261=>1,  57262=>1, 
 57263=>1,  57264=>1,  57265=>1,  57266=>1,  57267=>1,  57268=>1,  57269=>1, 
 57270=>1,  57271=>1,  57272=>1,  57273=>1,  57274=>1,  57275=>1,  57276=>1, 
 57277=>1,  57278=>1,  57279=>1,  57280=>1,  57281=>1,  57282=>1,  57283=>1, 
 57284=>1,  57285=>1,  57286=>1,  57287=>1,  57288=>1,  57289=>1,  57290=>1, 
 57291=>1,  57292=>1,  57293=>1,  57294=>1,  57295=>1,  57296=>1,  57297=>1, 
 57298=>1,  57299=>1,  57300=>1,  57301=>1,  57302=>1,  57303=>1,  57304=>1, 
 57305=>1,  57306=>1,  57307=>1,  57308=>1,  57309=>1,  57310=>1,  57311=>1, 
 57312=>1,  57313=>1,  57314=>1,  57315=>1,  57316=>1,  57317=>1,  57318=>1, 
 57319=>1,  57320=>1,  57321=>1,  57322=>1,  57323=>1,  57324=>1,  57325=>1, 
 57326=>1,  57327=>1,  57328=>1,  57329=>1,  57330=>1,  57331=>1,  57332=>1, 
 57333=>1,  57334=>1,  57335=>1,  57336=>1,  57337=>1,  57338=>1,  57339=>1, 
 57340=>1,  57341=>1,  57342=>1,  57343=>1,  64976=>1,  64977=>1,  64978=>1, 
 64979=>1,  64980=>1,  64981=>1,  64982=>1,  64983=>1,  64984=>1,  64985=>1, 
 64986=>1,  64987=>1,  64988=>1,  64989=>1,  64990=>1,  64991=>1,  64992=>1, 
 64993=>1,  64994=>1,  64995=>1,  64996=>1,  64997=>1,  64998=>1,  64999=>1, 
 65000=>1,  65001=>1,  65002=>1,  65003=>1,  65004=>1,  65005=>1,  65006=>1, 
 65007=>1,  65534=>1,  65535=>1,  131070=>1,  131071=>1,  196606=>1,  196607=>1, 
 262142=>1,  262143=>1,  327678=>1,  327679=>1,  393214=>1,  393215=>1,  458750=>1, 
 458751=>1,  524286=>1,  524287=>1,  589822=>1,  589823=>1,  655358=>1,  655359=>1, 
 720894=>1,  720895=>1,  786430=>1,  786431=>1,  851966=>1,  851967=>1,  917502=>1, 
 917503=>1,  983038=>1,  983039=>1,  1048574=>1,  1048575=>1,  1114110=>1,  1114111=>1, 
);


#############################################################################
#
#     Error message stuff
#
#############################################################################

my $ErrStr;
my ($ERR_OK,
    $ERR_ILLEGAL_CODE,
    $ERR_DOC,
    $ERR_DOC_TYPE,
    $ERR_DOC_SUB_TYPE,
    $ERR_BOM,
    $ERR_FIRST_CHARS,
    $ERR_META,
    $ERR_XML,
    $ERR_GUESS,
    $ERR_WRONG_GUESS,
    $ERR_ILLEGAL_CHAR,
    $ERR_DOC_TYPE_WIZARD,
    $ERR_TYPE_GUESS,
    $ERR_ENCODE_GUESS,
    $ERR_GUESS_AND_CONVERT,
    $ERR_UNABLE_TO_GUESS
    )=(0..16);
my %ErrMsgs=($ERR_OK=>"",
	     $ERR_ILLEGAL_CODE=>"Illegal UTF-8 code.",
	     $ERR_DOC=>"No document text.",
	     $ERR_DOC_TYPE=>"No document type.",
	     $ERR_DOC_SUB_TYPE=>"No document subtype.",
	     $ERR_BOM=>"Byte order mark recognition failed miserably.",
	     $ERR_FIRST_CHARS=>"Guessing from the first characters " .
	     "failed miserably.",
	     $ERR_META=>"Guessing from the meta information " .
	     "failed miserably.",
	     $ERR_XML=>"Guessing from XML format failed miserably.",
	     $ERR_GUESS=>"Unable to guess at the encoding.",
	     $ERR_WRONG_GUESS=>"This pair does not convert:",
	     $ERR_ILLEGAL_CHAR=>"Illegal character in supposedly UTF-8 " .
	     "result.",
	     $ERR_DOC_TYPE_WIZARD=>"Instantiating Alvis::Document::Type",
	     $ERR_TYPE_GUESS=>"Guessing the document type failed.",
	     $ERR_ENCODE_GUESS=>"Encode::Guess failed.",
	     $ERR_GUESS_AND_CONVERT=>"Guessing an encoding and then " .
	     "converting failed.",
	     $ERR_UNABLE_TO_GUESS=>"Unable to guess at encoding name " .
	     "corrections."
   );

sub _set_err_state
{
    my $self=shift;
    my $errcode=shift;
    my $errmsg=shift;

    if (!defined($errcode))
    {
        confess("set_err_state() called with an undefined argument.");
    }

    if (exists($ErrMsgs{$errcode}))
    {
        if ($errcode==$ERR_OK)
        {
            $self->{errstr}="";
        }
        else
        {
            $self->{errstr}.=" " . $ErrMsgs{$errcode};
            if (defined($errmsg))
            {
                $self->{errstr}.=" " . $errmsg;
            }
        }
    }
    else
    {
        confess("Internal error: set_err_state() called with an " .
                "unrecognized argument ($errcode).")
    }
}

sub errmsg
{
    my $self=shift;

    return $self->{errstr};
}

#############################################################################
#
#      Methods
#
##############################################################################
 
sub new
{
    my $proto=shift;

    my $class=ref($proto)||$proto;
    my $parent=ref($proto)&&$proto;
    my $self={};
    bless($self,$class);

    $self->_init(@_);

    $self->_set_err_state($ERR_OK);

    $self->{docTypeWizard}=
	Alvis::Document::Type->new(defaultType=>
				   $self->{defaultDocType},
				   defaultSubType=>
				   $self->{defaultDocSubType});
    if (!defined($self->{docTypeWizard}))
    {
	$self->_set_err_state($ERR_DOC_TYPE_WIZARD);
	return undef;
    }

    Encode::Guess->add_suspects(qw/latin1 iso-8859-2 iso-8859-5 iso-8859-10 iso-8859-7 windows-1252/);

    return $self;
}

sub _init
{
    my $self=shift;

    $self->{defaultDocType}='text';
    $self->{defaultDocSubType}='html';
    $self->{defaultEncoding}='iso-8859-1';

    if (defined(@_))
    {
        my %args=@_;
        @$self{ keys %args }=values(%args);
    }
}

##########################################################################
#
#  Public methods
#
#########################################################################

#
# Returns 1 if the (decimal) character code is legal UTF-8
#
sub code_is_utf8
{
    my $self=shift;
    my $dec_code=shift;

    # check for invalid codes 
    if ($dec_code<0 || $dec_code>1114111 || $InvalidUtf8Code{$dec_code})
    {
	return 0;
    }

    return 1;
}

#
# Returns 1 if all of the characters of the text are legal UTF-8
# Else, returns 0 and sets an error message specifying the location
# (1..) of the first illegal character code
# If you wish to obtain the position and offending code, pass a 
# hash ref
#
sub is_utf8
{
    my $self=shift;
    my $text=shift;
    my $err=shift;

    # Go over the text char by char and check for invalid char codes
    my @chars=split(//,$text);
    my $i=1;
    for my $char (@chars)
    {
	# We test for valid code
	#
	my $code=ord($char);
	if (!$self->code_is_utf8($code))
	{
	    $self->_set_err_state($ERR_ILLEGAL_CODE,
				  sprintf("Position: #%d, character code: %#x",
					  $i,$code));
	    if (defined($err) && ref($err) eq 'HASH')
	    {
		$err->{pos}=$i;
		$err->{code}=$code;
	    }
	    return 0;
	}
	$i++;
    }

    return 1;
}

#
# type: The type of the document as one of the recognized types
#       defined in Alvis::Document::Type (superset of MIME). 
#
sub guess
{
    my $self=shift;
    my $text=shift;
    my $type=shift;
    my $sub_type=shift;

    $self->_set_err_state($ERR_OK);  # clean the slate

    if (!defined($text))
    {
	$self->_set_err_state($ERR_DOC);
	return undef;
    }
    if (!(defined($type) && defined($sub_type)))
    {
	($type,$sub_type)=$self->{docTypeWizard}->guess($text);
	if (!(defined($type) && defined($sub_type)))
	{
	    $self->_set_err_state($ERR_TYPE_GUESS,
				  $self->{docTypeWizard}->errmsg());
	    return undef;
	}
    }

#    warn "($type,$sub_type)";

    my @guesses;
    if ($type eq 'text')
    {
	if ($sub_type eq 'html')
	{
	    @guesses=$self->_HTML($text);
	    if (scalar(@guesses)==0)
	    {
		$self->_set_err_state($ERR_GUESS);
		if (defined($self->{defaultEncoding}))
		{
		    @guesses=($self->{defaultEncoding});
		}
	    }
	}
	elsif ($sub_type eq 'xhtml')
	{
	    @guesses=$self->_XHTML($text);
	    if (scalar(@guesses)==0)
	    {
		$self->_set_err_state($ERR_GUESS);
		if (defined($self->{defaultEncoding}))
		{
		    @guesses=($self->{defaultEncoding});
		}
	    }
	}
	elsif ($sub_type eq 'plain')
	{
	    @guesses=$self->_plain_text($text);
	    if (scalar(@guesses)==0)
	    {
		$self->_set_err_state($ERR_GUESS);
		if (defined($self->{defaultEncoding}))
		{
		    @guesses=($self->{defaultEncoding});
		}
	    }
	}
    }

    return @guesses;
}

sub from_to
{
    my $self=shift;
    my $text=shift;
    my $source_enc=shift;
    my $target_enc=shift;

    {
	eval
	{
	    Encode::from_to($text,
			    $source_enc,$target_enc,0);
			    # $source_enc,$target_enc,Encode::FB_QUIET);
	};
	if ($@)
	{
	    my $err=$@;
	    $err=~s/ at .*$//isgo;
	    $self->_set_err_state($ERR_WRONG_GUESS,
				  "source encoding: $source_enc, " .
				  "target encoding: $target_enc. Why? $err.");
	    return undef;
	}
        if ($target_enc=~/^\s*utf-?8\s*$/isgo)
        {
	    # leaves the bl***y UTF-8 flag on
	    Encode::_utf8_on($text); 
        }
    }
    return $text;
}

# 
# Should always leave the UTF-8 flag on, if target is UTF-8
#
sub convert
{
    my $self=shift;
    my $text=shift;
    my $source_enc=shift;
    my $target_enc=shift;

    my %err;
    if ($source_enc=~/^\s*utf-?8\s*$/isgo)
    {
	if (!$self->is_utf8($text,\%err))
	{
	    $self->_set_err_state($ERR_ILLEGAL_CHAR,
				  " Position: $err{pos}," .
				  "Code:$err{code}");
	    return undef;
	}
    }

    my $try=$self->from_to($text,$source_enc,$target_enc);
    if (!defined($try))
    {
	my @possible_src_typo_fixes=$self->guess_typo_fixes($source_enc);
	my @possible_trg_typo_fixes=$self->guess_typo_fixes($target_enc);

	for my $src_enc_guess ($self->guess_typo_fixes($source_enc))
	{
	    for my $trg_enc_guess ($self->guess_typo_fixes($target_enc))
	    {
		my $try=$self->from_to($text,$src_enc_guess,$trg_enc_guess);
		if (defined($try))
		{
		    return $try;
		}
	    }
	}
	
	$self->_set_err_state($ERR_UNABLE_TO_GUESS);
	return undef;
    }

    return $try;
}

sub guess_and_convert
{
    my $self=shift;
    my $text=shift;
    my $type=shift;
    my $sub_type=shift;
    my $target_enc=shift;

    $self->_set_err_state($ERR_OK);

    if (!defined($text))
    {
	$self->_set_err_state($ERR_DOC);
	return undef;
    }
    if (!(defined($type) && defined($sub_type)))
    {
	($type,$sub_type)=$self->{docTypeWizard}->guess($text);
	if (!(defined($type) && defined($sub_type)))
	{
	    $self->_set_err_state($ERR_TYPE_GUESS,
				  $self->{docTypeWizard}->errmsg());
	    return undef;
	}
    }
    
    my @enc_guesses=$self->guess($text,$type,$sub_type);
    if (scalar(@enc_guesses)==0)
    {
	$self->_set_err_state($ERR_GUESS);
	return undef;
    }

    my $result; 
    for my $enc_guess (@enc_guesses)
    {
	if ( $target_enc eq "utf8" && ( $enc_guess =~ /utf-?8/i ) ) {
	   return $text;
        } else {
           $result=$self->convert($text,$enc_guess,$target_enc);
	   if (defined($result))
	   {
	       return $result;
	   }
	}
    }
    if (!defined($result))
    {
        #  test if its UTF-8 already
	&Encode::_utf8_on($text);
	if (  &Encode::is_utf8($text) ) {
		return $text;
        }
         &Encode::_utf8_off($text);
	$self->_set_err_state($ERR_GUESS_AND_CONVERT);
        # print STDERR join("==", @enc_guesses) . " -> $target_enc : undef\n";
	# print STDERR "\n$text\n\n";
	return undef;
    }

    return $result;
}

sub guess_typo_fixes
{
    my $self=shift;
    my $typo=shift;

    my @possibilities=($typo);
    if ($typo=~/^\s*(?:utf|uft)-?8\s*$/isgo)
    {
	push(@possibilities,'utf8');
    }
    if ($typo=~/^\s*(?:utf|uft)-16\s*$/isgo)
    {
	push(@possibilities,'UTF-16');
    }
    if ($typo=~/^\s*iso-?8559-?1\s*$/isgo)
    {
	push(@possibilities,'iso-8859-1');
    }
    if ($typo=~/^\s*ecu-?(kr|jp|cn|tw|jisx0213)\s*$/isgo)
    {
	push(@possibilities,"euc-$1");
    }
    if ($typo=~/^\s*(?:uft|utf)-?32\s*$/isgo)
    {
	push(@possibilities,'UTF-32');
    }
    if ($typo=~/^\s*(?:acsii|asici)\s*$/isgo)
    {
	push(@possibilities,'ascii');
    }
    if ($typo=~/^\s*(?:acsii|asici)-?ctrl\s*$/isgo)
    {
	push(@possibilities,'ascii-ctrl');
    }
    if ($typo=~/^\s*(?:utf|uft)-?7\s*$/isgo)
    {
	push(@possibilities,'UTF-7');
    }
    if ($typo=~/^\s*macintosh\s*$/isgo)
    {
	for (my $i=1; $i<=11; $i++)
	{
	    push(@possibilities,"iso-8859-$i");
	}
	push(@possibilities,'viscii');
    }
    if ($typo=~/^\s*iso-8559-(\d)\s*$/isgo)
    {
	push(@possibilities,"iso-8859-$1");
    }
    if ($typo=~/^\s*iso-8895-(\d)\s*$/isgo)
    {
	push(@possibilities,"iso-8859-$1");
    }
    if ($typo=~/^\s*(?:utf|uft)-?16be\s*$/isgo)
    {
	push(@possibilities,'UTF-16BE');
    }
    if ($typo=~/^\s*(?:utf|uft)-?16le\s*$/isgo)
    {
	push(@possibilities,'UTF-16LE');
    }

    return @possibilities;
}

########################################################################3
#
# Private methods
#
##########################################################################
#
# HTML::Encoding has a nasty bug
#
sub _HTML
{
    my $self=shift;
    my $text=shift;

    if (!defined($text) || length($text)<1)
    {
	$self->_set_err_state($ERR_DOC);
	return ();
    }

    my @guesses;

    eval
    {
	@guesses=HTML::Encoding::encoding_from_byte_order_mark($text,xhtml=>0);
    };
    if ($@)
    {
	$self->_set_err_state($ERR_BOM,"$@");
    }
    if (scalar(@guesses))
    {
	return @guesses;
    }

    # Sanity check to exclude e.g. UTF-32
    #
    eval
    {
	@guesses=
	    HTML::Encoding::encoding_from_first_chars($text);
    };
    if ($@)
    {
	$self->_set_err_state($ERR_FIRST_CHARS,"$@");
    }

    my @tries;
    if (scalar(@guesses))
    {
	@tries=@guesses;
    }
    else
    {
	@tries=@{$HTML::Encoding::DEFAULT_ENCODINGS};
    }
    foreach my $try (@tries)
    {
	if ($try=~/^\s*UTF-(?:16|32)((?:B|L)E)?\s*$/isgo)
	{
	    # HTML::Encoding is a bit imperfect
	    next;
	}

	my @try_results;
	eval
	{
	    @try_results=
		HTML::Encoding::encoding_from_meta_element($text,$try);
	};
	if ($@)
	{
	    $self->_set_err_state($ERR_META,"$@");
	}
	
	@guesses=(@try_results,@guesses);
    }

    return @guesses;
}

sub _XHTML
{
    my $self=shift;
    my $text=shift;

    if (!defined($text) || length($text)<1)
    {
	$self->_set_err_state($ERR_DOC);
	return ();
    }

    my @guesses;
    eval
    {
	@guesses=HTML::Encoding::encoding_from_xml_document($text);
    };
    if ($@)
    {
	$self->_set_err_state($ERR_XML,"$@");
	return ();
    }
    
    if (scalar(@guesses))
    {
	return @guesses;
    }
    
    return $self->_HTML($text);
}

sub _plain_text
{
    my $self=shift;
    my $text=shift;

    if (!defined($text) || length($text)<1)
    {
	$self->_set_err_state($ERR_DOC);
	return ();
    }

    my $enc=guess_encoding($text);
    if (ref($enc))
    {
	return ($enc->name());
    }
    else
    {
	$self->_set_err_state($ERR_ENCODE_GUESS,"$@");
	return ();
    }
}

1;
__END__

=head1 NAME

Alvis::Encoding - Perl extension for guessing and checking the encoding of
documents.

=head1 SYNOPSIS

 use Alvis::Encoding;

 # Create a new instance
 my $e=Alvis::Encoding->new();
 if (!defined($e))
 {
    die "Instantiating Alvis::Encoding failed.";
 }

 # Check that a (decimal) character code is legal UTF-8
 my $code=55;
 if (!$e->code_is_utf8($code))
 {
    # The message will contain the position and the offending character's code 
    die $e->errmsg();
 }

 # Check that a text is legal UTF-8
 my $text;
 if (!$e->is_utf8($text))
 {
    # The message will contain the position and the offending character's code 
    die $e->errmsg();
 }

 # If you need to obtain the position (1..) and the offending character,
 # pass a placeholder in a hash ref argument:
 my %err=();
 if (!$e->is_utf8($text,\%err))
 {
    my $position=$err{pos};
    my $code=$err{code};
    . . . 
 }

 # 
 # Guess the encoding of a document given a guess for its type 
 #
 my $type_guesser=Alvis::Document::Type->new();
 my ($doc_type,$doc_sub_type)=$type_guesser->guess($text);
 my $doc_encoding=$e->guess($text,$doc_type,$doc_sub_type);
 if (!defined($doc_encoding))
 {
     die('Cannot guess. ' . $e->errmsg());
 }

 # 
 # Try converting a document to UTF-8 with only its type known
 #
 my $type_guesser=Alvis::Document::Type->new();
 my ($doc_type,$doc_sub_type)=$type_guesser->guess($text);
 my $doc_in_utf8=$e->try_to_convert_to_utf8($text,$doc_type,$doc_sub_type);
 if (!defined($doc_in_utf8))
 {
     die('Cannot guess. ' . $e->errmsg());
 }
 
 # Try to guess what was meant 
 my @possibilities=$e->guess_typo_fixes('uft-8');

=head1 DESCRIPTION

A collection of methods for guessing, confirming and fixing the encoding
of a document.

=head1 METHODS

=head2 new()

Options:

    defaultDocType       default type for a document. Default: text.
    defaultDocSubType    default sub type for a document. Default: html.
    defaultEncoding      default encoding for a document. Default: iso-8859-1.

=head2 code_is_utf8(decimal_code)

Returns 1 if the (decimal) character code is legal UTF-8.

=head2 is_utf8(text,err_hash_ref)

Returns 1 if all of the characters of $text are legal UTF-8
Else, returns 0 and sets an error message specifying the location
(1..) of the first illegal character code
If you wish to obtain the position and offending code, pass a 
hash ref ($err_hash_ref). The info is in $err_hash_ref->{pos} and
$err_hash_ref->{code}.

=head2 guess(text,doc_type,doc_sub_type)

Guess the encoding of a document given a guess for its type (and subtype).

=head2 guess_and_convert(text,doc_type,doc_sub_type,target_encoding)

Tries to first guess the encoding of the document given a guess at its
type and subtype, and then tries to convert it to $target_encoding.

=head2 convert(text,source_encoding,target_encoding)

Tries to convert $text from $source_encoding to $target_encoding.

=head2 guess_typo_fixes($typo)

Returns a set of guesses for the meant encoding in a case of an encoding
name containing typos.

=head2 errmsg()

Returns a stack of error messages, if any. Empty string otherwise.

=head1 SEE ALSO

Alvis::Document::Type

=head1 AUTHOR

Kimmo Valtonen, E<lt>kimmo.valtonen@hiit.fiE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 by Kimmo Valtonen

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.4 or,
at your option, any later version of Perl 5 you may have available.


=cut
