#!/usr/bin/perl -w

use Crypt::ECB;

my ($path, $retval, $ok);

my $ecb = Crypt::ECB->new;

print "Checking your perl installation for block ciphers compliant with Crypt::ECB...\n";

foreach $path (@INC)
{
	while (<$path/Crypt/*.pm>)
	{
		s|^.*Crypt/||;
		s|\.pm$||;
		$retval = 0;
		eval { $retval = $ecb->cipher($_) };
		print " Found $_.\n" if $retval and ++$ok;
	}
}

unless ($ok)
{
	print "There do not seem to be any block ciphers installed (at least none which I can\n"
	    . "use). Crypt::ECB will not be of any use to you unless you install some suitable\n"
	    . "cipher module(s).\n";
}
