=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Kaa - Package for language Kara-Kalpak

=cut

package Locale::CLDR::Locales::Kaa;
# This file auto generated from Data\common\main\kaa.xml
#	on Fri 17 Jan 12:03:31 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.46.0');

use v5.12.0;
use mro 'c3';
use utf8;
use feature 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'de' => 'немецше',
 				'de_AT' => 'немецше (Австрия)',
 				'de_CH' => 'немецше (Швейцария)',
 				'en' => 'Англичанша',
 				'fr' => 'французша',
 				'fr_CA' => 'французша (Канада)',
 				'fr_CH' => 'французша (Швейцария)',
 				'hi_Latn' => 'ҳиндше (латын)',
 				'hi_Latn@alt=variant' => 'ҳинглиш (латын)',
 				'it' => 'итальянша',
 				'ja' => 'японша',
 				'kaa' => 'қарақалпақша',
 				'ko' => 'корейсше',
 				'tr' => 'түрк тили',
 				'und' => 'белгисиз тил',
 				'zh' => 'қытайша',
 				'zh_Hans' => 'қытайша (аңсатластырылған)',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'араб жазыўы',
 			'Cyrl' => 'кирилл жазыўы',
 			'Hans' => 'аңсатластырылған',
 			'Hans@alt=stand-alone' => 'аңсатластырылған қытай жазыўы',
 			'Hant' => 'дәстүрли',
 			'Hant@alt=stand-alone' => 'дәстүрли қытай жазыўы',
 			'Jpan' => 'япон жазыўы',
 			'Kore' => 'корейс жазыўы',
 			'Latn' => 'латын жазыўы',
 			'Zxxx' => 'жазыўы жоқ',
 			'Zzzz' => 'белгисиз жазыў',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'дүнья',
 			'002' => 'Африка',
 			'003' => 'Арқа Америка',
 			'005' => 'Қубла Америка',
 			'009' => 'Океания',
 			'011' => 'Батыс Африка',
 			'013' => 'Орайлық Америка',
 			'014' => 'Шығыс Африка',
 			'015' => 'Арқа Африка',
 			'017' => 'Орайлық Африка',
 			'018' => 'Қубла Африка',
 			'019' => 'Америка',
 			'021' => 'Арқа Америка – AҚШ ҳәм Канада',
 			'029' => 'Кариб бассейни',
 			'030' => 'Шығыс Азия',
 			'034' => 'Қубла Азия',
 			'035' => 'Қубла-шығыс Азия',
 			'039' => 'Қубла Европа',
 			'053' => 'Австралазия',
 			'054' => 'Меланезия',
 			'057' => 'Микронезия',
 			'061' => 'Полинезия',
 			'142' => 'Азия',
 			'143' => 'Орайлық Азия',
 			'145' => 'Батыс Азия',
 			'150' => 'Европа',
 			'151' => 'Шығыс Европа',
 			'154' => 'Арқа Европа',
 			'155' => 'Батыс Европа',
 			'202' => 'Тропикалық Африка',
 			'419' => 'Латын Америкасы',
 			'AD' => 'Андорра',
 			'AE' => 'Бирлескен Араб Әмирликлери',
 			'AF' => 'Аўғанстан',
 			'AG' => 'Антигуа ҳәм Барбуда',
 			'AI' => 'Ангилья',
 			'AL' => 'Албания',
 			'AM' => 'Армения',
 			'AO' => 'Ангола',
 			'AR' => 'Аргентина',
 			'AT' => 'Австрия',
 			'AU' => 'Австралия',
 			'AW' => 'Аруба',
 			'AX' => 'Аланд атаўлары',
 			'AZ' => 'Әзербайжан',
 			'BA' => 'Босния ҳәм Герцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельгия',
 			'BF' => 'Буркина-Фасо',
 			'BG' => 'Болгария',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сен-Бартелеми',
 			'BM' => 'Бермуд атаўлары',
 			'BN' => 'Бруней',
 			'BO' => 'Боливия',
 			'BQ' => 'Бонэйр, Синт-Эстатиус ҳәм Саба',
 			'BR' => 'Бразилия',
 			'BS' => 'Багама атаўлары',
 			'BT' => 'Бутан',
 			'BV' => 'Буве атаўы',
 			'BW' => 'Ботсвана',
 			'BY' => 'Беларусь',
 			'BZ' => 'Белиз',
 			'CA' => 'Канада',
 			'CC' => 'Кокос атаўлары',
 			'CD' => 'Конго - Киншаса',
 			'CD@alt=variant' => 'Конго (КДР)',
 			'CF' => 'Орайлық Африка Республикасы',
 			'CG' => 'Конго - Браззавиль',
 			'CG@alt=variant' => 'Конго Республикасы',
 			'CH' => 'Швейцария',
 			'CI' => 'Кот-дИвуар',
 			'CI@alt=variant' => 'Кот-д’Ивуар',
 			'CK' => 'Кук атаўлары',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Қытай',
 			'CO' => 'Колумбия',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо-Верде',
 			'CW' => 'Кюрасао',
 			'CY' => 'Кипр',
 			'CZ' => 'Чехия',
 			'CZ@alt=variant' => 'Чехия Республикасы',
 			'DE' => 'Германия',
 			'DJ' => 'Джибути',
 			'DK' => 'Дания',
 			'DM' => 'Доминика',
 			'DO' => 'Доминикана Республикасы',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута ҳәм Мелилья',
 			'EC' => 'Эквадор',
 			'EE' => 'Эстония',
 			'EG' => 'Мысыр',
 			'EH' => 'Батыс Сахара',
 			'ER' => 'Эритрея',
 			'ES' => 'Испания',
 			'ET' => 'Эфиопия',
 			'EU' => 'Европа Аўқамы',
 			'EZ' => 'Еврозона',
 			'FI' => 'Финляндия',
 			'FJ' => 'Фиджи',
 			'FK' => 'Фолкленд атаўлары',
 			'FK@alt=variant' => 'Фолкленд (Мальвин) атаўлары',
 			'FM' => 'Микронезия Федеративлик Штатлары',
 			'FO' => 'Фарер атаўлары',
 			'FR' => 'Франция',
 			'GA' => 'Габон',
 			'GB' => 'Уллы Британия',
 			'GB@alt=short' => 'Британия',
 			'GD' => 'Гренада',
 			'GE' => 'Грузия',
 			'GF' => 'Француз Гвианасы',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренландия',
 			'GM' => 'Гамбия',
 			'GN' => 'Гвинея',
 			'GP' => 'Гваделупа',
 			'GQ' => 'Экваториальлық Гвинея',
 			'GR' => 'Греция',
 			'GS' => 'Қубла Георгия ҳәм Қубла Сэндвич атаўлары',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинея-Бисау',
 			'GY' => 'Гайана',
 			'HK' => 'Гонконг ААР',
 			'HK@alt=short' => 'Гонконг',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорватия',
 			'HT' => 'Гаити',
 			'HU' => 'Венгрия',
 			'IC' => 'Канар атаўлары',
 			'ID' => 'Индонезия',
 			'IE' => 'Ирландия',
 			'IL' => 'Израиль',
 			'IM' => 'Мэн атаўы',
 			'IN' => 'Ҳиндстан',
 			'IO' => 'Британияныӊ Ҳинд океанындағы территориясы',
 			'IO@alt=chagos' => 'Чагос архипелагы',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исландия',
 			'IT' => 'Италия',
 			'JE' => 'Джерси',
 			'JM' => 'Ямайка',
 			'JO' => 'Иордания',
 			'JP' => 'Япония',
 			'KE' => 'Кения',
 			'KG' => 'Қырғызстан',
 			'KH' => 'Камбоджа',
 			'KI' => 'Кирибати',
 			'KM' => 'Комор атаўлары',
 			'KN' => 'Сент-Китс ҳәм Невис',
 			'KP' => 'Арқа Корея',
 			'KR' => 'Қубла Корея',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайман атаўлары',
 			'KZ' => 'Қазақстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сент-Люсия',
 			'LI' => 'Лихтенштейн',
 			'LK' => 'Шри-Ланка',
 			'LR' => 'Либерия',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латвия',
 			'LY' => 'Ливия',
 			'MA' => 'Марокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Черногория',
 			'MF' => 'Сен-Мартен',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалл атаўлары',
 			'MK' => 'Арқа Македония',
 			'ML' => 'Мали',
 			'MM' => 'Мьянма (Бирма)',
 			'MN' => 'Монголия',
 			'MO' => 'Макао ААР',
 			'MO@alt=short' => 'Макао',
 			'MQ' => 'Мартиника',
 			'MR' => 'Мавритания',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврикий',
 			'MV' => 'Мальдив',
 			'MW' => 'Малави',
 			'MX' => 'Мексика',
 			'MY' => 'Малайзия',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибия',
 			'NC' => 'Жаӊа Каледония',
 			'NE' => 'Нигер',
 			'NG' => 'Нигерия',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерландия',
 			'NO' => 'Норвегия',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NZ' => 'Жаӊа Зеландия',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PG' => 'Папуа — Жаӊа Гвинея',
 			'PH' => 'Филиппин',
 			'PK' => 'Пакистан',
 			'PL' => 'Польша',
 			'PM' => 'Сен-Пьер ҳәм Микелон',
 			'PN' => 'Питкэрн атаўлары',
 			'PR' => 'Пуэрто-Рико',
 			'PS' => 'Палестина территориялары',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалия',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Қатар',
 			'QO' => 'Сыртқы Океания',
 			'RE' => 'Реюньон',
 			'RO' => 'Румыния',
 			'RS' => 'Сербия',
 			'RU' => 'Россия',
 			'RW' => 'Руанда',
 			'SA' => 'Саудия Арабстаны',
 			'SB' => 'Соломон атаўлары',
 			'SC' => 'Сейшель атаўлары',
 			'SD' => 'Судан',
 			'SE' => 'Швеция',
 			'SG' => 'Сингапур',
 			'SI' => 'Словения',
 			'SJ' => 'Шпицберген ҳәм Ян-Майен',
 			'SK' => 'Словакия',
 			'SL' => 'Сьерра-Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомали',
 			'SR' => 'Суринам',
 			'SS' => 'Қубла Судан',
 			'ST' => 'Сан-Томе ҳәм Принсипи',
 			'SV' => 'Сальвадор',
 			'SX' => 'Синт-Мартен',
 			'SY' => 'Сирия',
 			'SZ' => 'Эсватини',
 			'SZ@alt=variant' => 'Свазиленд',
 			'TC' => 'Тёркс ҳәм Кайкос атаўлары',
 			'TD' => 'Чад',
 			'TF' => 'Француз Қубла территориялары',
 			'TG' => 'Того',
 			'TH' => 'Таиланд',
 			'TJ' => 'Тәжикстан',
 			'TK' => 'Токелау',
 			'TL' => 'Шығыс Тимор',
 			'TL@alt=variant' => 'Тимор-Лесте',
 			'TM' => 'Түркменстан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Түркия',
 			'TT' => 'Тринидад ҳәм Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайвань',
 			'TZ' => 'Танзания',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UN' => 'Бирлескен Миллетлер Шөлкеми',
 			'US' => 'Америка Қурама Штатлары',
 			'US@alt=short' => 'АҚШ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Өзбекстан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент-Винсент ҳәм Гренадин атаўлары',
 			'VE' => 'Венесуэла',
 			'VG' => 'Британия Виргин атаўлары',
 			'VI' => 'Америка Виргин атаўлары',
 			'VN' => 'Вьетнам',
 			'VU' => 'Вануату',
 			'WS' => 'Самоа',
 			'XA' => 'қалпеки пәт',
 			'XB' => 'қалпеки Bidi',
 			'XK' => 'Косово',
 			'YE' => 'Йемен',
 			'YT' => 'Майотта',
 			'ZA' => 'Қубла Африка Республикасы',
 			'ZM' => 'Замбия',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'белгисиз аймақ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'gregorian' => q{григориан календарь},
 				'islamic-civil' => q{кестели ҳижрий календарь},
 				'islamic-tbla' => q{кестели ҳижрий календарь (астрономиялық дәўир)},
 				'iso8601' => q{ISO-8601 календары},
 			},
 			'collation' => {
 				'standard' => q{стандарт саралаў},
 			},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'Тил: {0}',
 			'script' => 'Жазыў: {0}',
 			'region' => 'Аймақ: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			index => ['А', 'Ә', 'Б', 'В', 'Г', 'Ғ', 'Д', 'ЕЁ', 'Ж', 'З', 'И', 'Й', 'К', 'Қ', 'Л', 'М', 'Н', 'Ң', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'УЎ', 'Ү', 'Ф', 'Х', 'Ҳ', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'],
			main => qr{[а ә б в г ғ д её ж з и й к қ л м н ң о ө п р с т уў ү ф х ҳ ц ч ш щ ъ ы ь э ю я]},
			numbers => qr{[\- ‑ , % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … '‘’ "“” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Ә', 'Б', 'В', 'Г', 'Ғ', 'Д', 'ЕЁ', 'Ж', 'З', 'И', 'Й', 'К', 'Қ', 'Л', 'М', 'Н', 'Ң', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'УЎ', 'Ү', 'Ф', 'Х', 'Ҳ', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'], };
},
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'янв',
							'фев',
							'мар',
							'апр',
							'май',
							'июн',
							'июл',
							'авг',
							'сен',
							'окт',
							'ноя',
							'дек'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Я',
							'Ф',
							'М',
							'А',
							'М',
							'И',
							'И',
							'А',
							'С',
							'О',
							'Н',
							'Д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'январь',
							'февраль',
							'март',
							'апрель',
							'май',
							'июнь',
							'июль',
							'август',
							'сентябрь',
							'октябрь',
							'ноябрь',
							'декабрь'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'Янв',
							'Фев',
							'Мар',
							'Апр',
							'Май',
							'Июн',
							'Июл',
							'Авг',
							'Сен',
							'Окт',
							'Ноя',
							'Дек'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Я',
							'Ф',
							'М',
							'А',
							'М',
							'И',
							'И',
							'А',
							'С',
							'О',
							'Н',
							'Д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Январь',
							'Февраль',
							'Март',
							'Апрель',
							'Май',
							'Июнь',
							'Июль',
							'Август',
							'Сентябрь',
							'Октябрь',
							'Ноябрь',
							'Декабрь'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'Дүй',
						tue => 'Сий',
						wed => 'Сәр',
						thu => 'Пий',
						fri => 'Жум',
						sat => 'Шем',
						sun => 'Екш'
					},
					narrow => {
						mon => 'Д',
						tue => 'С',
						wed => 'С',
						thu => 'П',
						fri => 'Ж',
						sat => 'Ш',
						sun => 'Е'
					},
					short => {
						mon => 'Дү',
						tue => 'Си',
						wed => 'Сә',
						thu => 'Пи',
						fri => 'Жу',
						sat => 'Ше',
						sun => 'Ек'
					},
					wide => {
						mon => 'дүйшемби',
						tue => 'сийшемби',
						wed => 'сәршемби',
						thu => 'пийшемби',
						fri => 'жума',
						sat => 'шемби',
						sun => 'екшемби'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'Дүй',
						tue => 'Сий',
						wed => 'Сәр',
						thu => 'Пий',
						fri => 'Жум',
						sat => 'Шем',
						sun => 'Екш'
					},
					narrow => {
						mon => 'Д',
						tue => 'С',
						wed => 'С',
						thu => 'П',
						fri => 'Ж',
						sat => 'Ш',
						sun => 'Е'
					},
					short => {
						mon => 'Дү',
						tue => 'Си',
						wed => 'Сә',
						thu => 'Пи',
						fri => 'Жу',
						sat => 'Ше',
						sun => 'Ек'
					},
					wide => {
						mon => 'дүйшемби',
						tue => 'сийшемби',
						wed => 'сәршемби',
						thu => 'пийшемби',
						fri => 'жума',
						sat => 'шемби',
						sun => 'екшемби'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'I ш.',
						1 => 'II ш.',
						2 => 'III ш.',
						3 => 'IV ш.'
					},
					narrow => {0 => 'I',
						1 => 'II',
						2 => 'III',
						3 => 'IV'
					},
					wide => {0 => 'I шерек',
						1 => 'II шерек',
						2 => 'III шерек',
						3 => 'IV шерек'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'I ш.',
						1 => 'II ш.',
						2 => 'III ш.',
						3 => 'IV ш.'
					},
					narrow => {0 => 'I',
						1 => 'II',
						2 => 'III',
						3 => 'IV'
					},
					wide => {0 => 'I шерек',
						1 => 'II шерек',
						2 => 'III шерек',
						3 => 'IV шерек'
					},
				},
			},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			abbreviated => {
				'0' => 'б. э. ш.',
				'1' => 'б. э.'
			},
			wide => {
				'0' => 'бизиӊ эрамызға шекемги',
				'1' => 'бизиӊ эрамыздыӊ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

no Moo;

1;

# vim: tabstop=4
