# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::BR;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240607153918;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              1[25-8]|
              2[357-9]|
              3[02-68]|
              4[12568]|
              5|
              6[0-8]|
              8[015]|
              9[0-47-9]
            )|
            321|
            610
          ',
                  'pattern' => '(\\d{3,6})'
                },
                {
                  'format' => '$1-$2',
                  'leading_digits' => '
            4(?:
              02|
              37
            )0|
            [34]00
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            [2357]|
            4(?:
              [0-24-9]|
              3(?:
                [0-689]|
                7[1-9]
              )
            )
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              [358]|
              90
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2,3})(\\d{4})'
                },
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '9',
                  'pattern' => '(\\d{5})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3',
                  'leading_digits' => '
            (?:
              [14689][1-9]|
              2[12478]|
              3[1-578]|
              5[13-5]|
              7[13-579]
            )[2-57]
          ',
                  'national_rule' => '($1)',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3',
                  'leading_digits' => '
            [16][1-9]|
            [2-57-9]
          ',
                  'national_rule' => '($1)',
                  'pattern' => '(\\d{2})(\\d{5})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )[2-5]\\d{7}
        ',
                'geographic' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )[2-5]\\d{7}
        ',
                'mobile' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )(?:
            7|
            9\\d
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          (?:
            30[03]\\d{3}|
            4(?:
              0(?:
                0\\d|
                20
              )|
              370
            )
          )\\d{4}|
          300\\d{5}
        )|(
          300\\d{6}|
          [59]00\\d{6,7}
        )',
                'toll_free' => '800\\d{6,7}',
                'voip' => ''
              };
my %areanames = ();
$areanames{pt} = {"5561", "Distrito\ Federal",};
$areanames{en} = {"55753062", "Feira\ de\ Santana\ \-\ BA",
"55613355", "Taguatinga\ \-\ DF",
"55533921", "Pelotas\ \-\ RS",
"55993075", "Imperatriz\ \-\ MA",
"55983269", "São\ Luís\ \-\ MA",
"55753435", "Cipó\ \-\ BA",
"55643686", "Moiporá\ \-\ GO",
"55313731", "Congonhas\ \-\ MG",
"55823003", "Maceió\ \-\ AL",
"55133201", "Santos\ \-\ SP",
"55273765", "Pinheiros\ \-\ ES",
"55413060", "Fazenda\ Rio\ Grande\ \-\ PR",
"55853403", "Fortaleza\ \-\ CE",
"55242221", "Petrópolis\ \-\ RJ",
"5547332", "Blumenau\ \-\ SC",
"55542101", "Caxias\ do\ Sul\ \-\ RS",
"55883641", "Pacujá\ \-\ CE",
"55553754", "Pinhal\ \-\ RS",
"55843393", "João\ Dias\ \-\ RN",
"55613394", "Santa\ Maria\ \-\ DF",
"55943337", "Brejo\ Grande\ do\ Araguaia\ \-\ PA",
"55443684", "Guaporema\ \-\ PR",
"55843525", "Guamaré\ \-\ RN",
"55513011", "Lajeado\ \-\ RS",
"55512104", "Porto\ Alegre\ \-\ RS",
"55123421", "Taubaté\ \-\ SP",
"55183402", "Assis\ \-\ SP",
"55343427", "Planura\ \-\ MG",
"55643678", "Israelândia\ \-\ GO",
"55433520", "Cornélio\ Procópio\ \-\ PR",
"5599352", "Imperatriz\ \-\ MA",
"55513466", "Canoas\ \-\ RS",
"55114454", "Santo\ André\ \-\ SP",
"55183821", "Dracena\ \-\ SP",
"55343245", "Indianópolis\ \-\ MG",
"55753544", "Ubaíra\ \-\ BA",
"55713289", "Lauro\ de\ Freitas\ \-\ BA",
"55553649", "Sanchuri\ \-\ RS",
"55733678", "Monte\ Pascoal\ \-\ BA",
"55993643", "Barra\ do\ Corda\ \-\ MA",
"55433334", "Londrina\ \-\ PR",
"55273080", "Serra\ \-\ ES",
"55114495", "Itatiba\ \-\ SP",
"55883527", "Pereiro\ \-\ CE",
"55153548", "Itapirapuã\ Paulista\ \-\ SP",
"55493238", "Palmeira\ \-\ SC",
"55773447", "Cordeiros\ \-\ BA",
"55853352", "Pentecoste\ \-\ CE",
"55873889", "Cedro\ \-\ PE",
"55323256", "Aracitaba\ \-\ MG",
"55883416", "Tauá\ \-\ CE",
"55813204", "Recife\ \-\ PE",
"55313442", "Minas\ Gerais",
"55173808", "Engenheiro\ Schimidt\ \-\ SP",
"55473446", "Barra\ Velha\ \-\ SC",
"55953539", "Nova\ Colina\ \-\ RR",
"55663498", "Primavera\ do\ Leste\ \-\ MT",
"55273773", "São\ Mateus\ \-\ ES",
"55663584", "Sorriso\ \-\ MT",
"55624015", "Anápolis\ \-\ GO",
"55533342", "Pelotas\ \-\ RS",
"55314133", "Belo\ Horizonte\ \-\ MG",
"55823277", "Anadia\ \-\ AL",
"55613045", "Brasília\ \-\ DF",
"55513553", "Novo\ Hamburgo\ \-\ RS",
"55733203", "Ibicaraí\ \-\ BA",
"55183622", "Araçatuba\ \-\ SP",
"55123601", "Taubaté\ \-\ SP",
"55543321", "Erechim\ \-\ RS",
"55673444", "Taquarussu\ \-\ MS",
"55133519", "Santos\ \-\ SP",
"55213198", "Rio\ de\ Janeiro\ \-\ RJ",
"55443582", "Guaiporã\ \-\ PR",
"55333424", "Senhora\ do\ Porto\ \-\ MG",
"55323722", "Muriaé\ \-\ MG",
"55333089", "Governador\ Valadares\ \-\ MG",
"55483269", "Florianópolis\ \-\ SC",
"55313370", "Minas\ Gerais",
"55193452", "Limeira\ \-\ SP",
"55353833", "Candeias\ \-\ MG",
"55223847", "Raposo\ \-\ RJ",
"55313277", "Minas\ Gerais",
"55493643", "São\ José\ do\ Cedro\ \-\ SC",
"55154009", "Sorocaba\ \-\ SP",
"55813256", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55163509", "São\ Carlos\ \-\ SP",
"55753642", "Jaguaripe\ \-\ BA",
"55813671", "Ribeirão\ \-\ PE",
"55333737", "Berilo\ \-\ MG",
"55773468", "Mirante\ \-\ BA",
"55843674", "Natal\ \-\ RN",
"55433172", "Arapongas\ \-\ PR",
"55113432", "Carapicuíba\ \-\ SP",
"55833369", "Arara\ \-\ PB",
"55443253", "Maringá\ \-\ PR",
"55114143", "Itapevi\ \-\ SP",
"55753023", "Feira\ de\ Santana\ \-\ BA",
"55693418", "Nova\ Brasilândia\ D\'Oeste\ \-\ RO",
"55243320", "Volta\ Redonda\ \-\ RJ",
"55712203", "Salvador\ \-\ BA",
"55823215", "Maceió\ \-\ AL",
"55863247", "Castelo\ do\ Piauí\ \-\ PI",
"55843488", "Cerro\ Corá\ \-\ RN",
"55333626", "Santa\ Helena\ de\ Minas\ \-\ MG",
"55143629", "Potunduva\ \-\ SP",
"55183323", "Assis\ \-\ SP",
"55242251", "Três\ Rios\ \-\ RJ",
"55473231", "Blumenau\ \-\ SC",
"55193602", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55853375", "Pindoretama\ \-\ CE",
"55873787", "Paranatama\ \-\ PE",
"55513044", "Alvorada\ \-\ RS",
"55273321", "Vitória\ \-\ ES",
"55843555", "Pedra\ Grande\ \-\ RN",
"55473644", "Rio\ Negrinho\ \-\ SC",
"55883614", "Sobral\ \-\ CE",
"55193463", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55543528", "Itatiba\ do\ Sul\ \-\ RS",
"55773639", "Luis\ Eduardo\ Magalhães\ \-\ BA",
"55663510", "Juara\ \-\ MT",
"55343457", "Carneirinho\ \-\ MG",
"55153287", "Laranjal\ Paulista\ \-\ SP",
"55313215", "Minas\ Gerais",
"55143597", "Presidente\ Alves\ \-\ SP",
"55633487", "São\ Bento\ do\ Tocantins\ \-\ TO",
"55693443", "Cacoal\ \-\ RO",
"55433533", "Panema\ \-\ PR",
"55843476", "Santana\ do\ Seridó\ \-\ RN",
"55183851", "Tupi\ Paulista\ \-\ SP",
"55163244", "Monte\ Alto\ \-\ SP",
"55893499", "Bela\ Vista\ do\ Piauí\ \-\ PI",
"55114424", "Santo\ André\ \-\ SP",
"55453421", "Toledo\ \-\ PR",
"55512126", "Porto\ Alegre\ \-\ RS",
"55513562", "Portão\ \-\ RS",
"55753343", "Bonito\ \-\ BA",
"55924009", "Manaus\ \-\ AM",
"55913032", "Ananindeua\ \-\ PA",
"55313229", "Minas\ Gerais",
"55213746", "Mesquita\ \-\ RJ",
"55863340", "Matias\ Olímpio\ \-\ PI",
"55853322", "Ocara\ \-\ CE",
"55143711", "Avaré\ \-\ SP",
"55493342", "Galvão\ \-\ SC",
"55413473", "Caiobá\ \-\ PR",
"55813138", "Caruaru\ \-\ PE",
"55883557", "Porteiras\ \-\ CE",
"55112849", "São\ Paulo\ \-\ SP",
"55843692", "Lagoa\ de\ Pedras\ \-\ RN",
"55343412", "Campina\ Verde\ \-\ MG",
"55914006", "Belém\ \-\ PA",
"55683342", "Rodrigues\ Alves\ \-\ AC",
"55182103", "Araçatuba\ \-\ SP",
"55853363", "Paraipaba\ \-\ CE",
"55112891", "Suzano\ \-\ SP",
"55673297", "Chapadão\ do\ Baús\ \-\ MS",
"55353331", "São\ Lourenço\ \-\ MG",
"55653361", "Barra\ do\ Bugres\ \-\ MT",
"55993017", "Imperatriz\ \-\ MA",
"55513523", "Parobé\ \-\ RS",
"55533238", "São\ José\ do\ Norte\ \-\ RS",
"55893480", "Socorro\ do\ Piauí\ \-\ PI",
"55222030", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55483443", "Criciúma\ \-\ SC",
"55213084", "Rio\ de\ Janeiro\ \-\ RJ",
"55673411", "Dourados\ \-\ MS",
"55134003", "Praia\ Grande\ \-\ SP",
"55543351", "David\ Canabarro\ \-\ RS",
"55133594", "Praia\ Grande\ \-\ SP",
"55813483", "Olinda\ \-\ PE",
"55183652", "Penápolis\ \-\ SP",
"55513354", "Rio\ Grande\ do\ Sul",
"55115112", "São\ Paulo\ \-\ SP",
"55272101", "Colatina\ \-\ ES",
"55163832", "Ipuã\ \-\ SP",
"55313546", "Minas\ Gerais",
"55883512", "Juazeiro\ do\ Norte\ \-\ CE",
"55793461", "Pinhão\ \-\ SE",
"5551364", "Rio\ Grande\ do\ Sul",
"55513778", "Rio\ Grande\ do\ Sul",
"55163981", "Pradópolis\ \-\ SP",
"55833629", "São\ Miguel\ de\ Taipu\ \-\ PB",
"55114604", "Mairiporã\ \-\ SP",
"55473542", "Agronômica\ \-\ SC",
"55923021", "Manaus\ \-\ AM",
"55343846", "Douradoquara\ \-\ MG",
"55413032", "Campo\ Largo\ \-\ PR",
"55424009", "Ponta\ Grossa\ \-\ PR",
"55883579", "Quixelô\ \-\ CE",
"55313164", "Santa\ Luzia\ \-\ MG",
"55843133", "Natal\ \-\ RN",
"55453274", "Toledo\ \-\ PR",
"55193801", "Indaiatuba\ \-\ SP",
"55714007", "Salvador\ \-\ BA",
"55413465", "Morretes\ \-\ PR",
"55133849", "Iguape\ \-\ SP",
"55212683", "Paracambi\ \-\ RJ",
"55243333", "Arrozal\ \-\ RJ",
"55513786", "Rio\ Grande\ do\ Sul",
"55183362", "Paraguaçu\ Paulista\ \-\ SP",
"55513664", "Torres\ \-\ RS",
"55753030", "Feira\ de\ Santana\ \-\ BA",
"55114656", "Santa\ Isabel\ \-\ SP",
"55193556", "Cordeirópolis\ \-\ SP",
"55112594", "São\ Paulo\ \-\ SP",
"55933533", "Monte\ Alegre\ \-\ PA",
"55183696", "Turiúba\ \-\ SP",
"55193373", "Piracicaba\ \-\ SP",
"55113442", "São\ Paulo\ \-\ SP",
"55183268", "Nantes\ \-\ SP",
"55513493", "Viamão\ \-\ RS",
"55273115", "Linhares\ \-\ ES",
"55643946", "Itumbiara\ \-\ GO",
"55333747", "Santo\ Antônio\ do\ Jacinto\ \-\ MG",
"5515322", "Sorocaba\ \-\ SP",
"55413653", "Pinhais\ \-\ PR",
"55813274", "Recife\ \-\ PE",
"55913322", "Barcarena\ \-\ PA",
"55662101", "Rondonópolis\ \-\ MT",
"55663558", "Santa\ Terezinha\ \-\ MT",
"55333525", "Poté\ \-\ MG",
"55312572", "Betim\ \-\ MG",
"55114133", "Barueri\ \-\ SP",
"55843271", "Macaíba\ \-\ RN",
"5521386", "Rio\ de\ Janeiro\ \-\ RJ",
"55413941", "Curitiba\ \-\ PR",
"55493633", "Santa\ Helena\ \-\ SC",
"55383622", "Pedras\ de\ Maria\ da\ Cruz\ \-\ MG",
"55624141", "Goiânia\ \-\ GO",
"55163512", "Ribeirão\ Preto\ \-\ SP",
"55813705", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55353843", "Ijaci\ \-\ MG",
"55183701", "Mirandópolis\ \-\ SP",
"55753632", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55653224", "Cáceres\ \-\ MT",
"55483345", "Tijucas\ \-\ SC",
"55622764", "Goiânia\ \-\ GO",
"55123671", "São\ Luís\ do\ Paraitinga\ \-\ SP",
"55733273", "Pau\ Brasil\ \-\ BA",
"55242404", "Angra\ dos\ Reis\ \-\ RJ",
"55273129", "Guarapari\ \-\ ES",
"55323274", "Rio\ Novo\ \-\ MG",
"55114692", "Biritiba\-Mirim\ \-\ SP",
"55673434", "Sanga\ Puitã\ \-\ MS",
"55653382", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55213844", "Nova\ Iguaçu\ \-\ RJ",
"55273031", "Vila\ Velha\ \-\ ES",
"55242522", "Nova\ Friburgo\ \-\ RJ",
"55193592", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55313207", "Belo\ Horizonte\ \-\ MG",
"55913798", "Pacajá\ \-\ PA",
"55953591", "Uiramutã\ \-\ RR",
"55632111", "Palmas\ \-\ TO",
"55513540", "Rio\ Grande\ do\ Sul",
"55833427", "Catingueira\ \-\ PB",
"55683248", "Rio\ Branco\ \-\ AC",
"55913284", "Ananindeua\ \-\ PA",
"55313432", "Belo\ Horizonte\ \-\ MG",
"55183605", "Santópolis\ do\ Aguapeí\ \-\ SP",
"55843366", "Janduís\ \-\ RN",
"55112118", "Itu\ \-\ SP",
"55863362", "Cocal\ \-\ PI",
"55383675", "Bonfinópolis\ de\ Minas\ \-\ MG",
"55843604", "Parnamirim\ \-\ RN",
"55613603", "Luziânia\ \-\ GO",
"55863323", "Parnaíba\ \-\ PI",
"55943012", "Marabá\ \-\ PA",
"55433344", "Londrina\ \-\ PR",
"55993633", "Lagoa\ Grande\ do\ Maranhão\ \-\ MA",
"55663321", "Rondonópolis\ \-\ MT",
"55273264", "Linhares\ \-\ ES",
"55553255", "Jaguari\ \-\ RS",
"55173392", "Viradouro\ \-\ SP",
"55753320", "Itaeté\ \-\ BA",
"55773437", "Belo\ Campo\ \-\ BA",
"55983345", "Rosário\ \-\ MA",
"55493248", "Ponte\ Alta\ \-\ SC",
"55843424", "Ipueira\ \-\ RN",
"55733265", "Itororó\ \-\ BA",
"55513581", "Novo\ Hamburgo\ \-\ RS",
"55773202", "Vitória\ da\ Conquista\ \-\ BA",
"55543584", "Passo\ Fundo\ \-\ RS",
"55483055", "Içara\ \-\ SC",
"55313645", "Vespasiano\ \-\ MG",
"55114891", "Bom\ Jesus\ dos\ Perdões\ \-\ SP",
"55133271", "Santos\ \-\ SP",
"55623397", "Rialma\ \-\ GO",
"55933518", "Itaituba\ \-\ PA",
"55343235", "Uberlândia\ \-\ MG",
"55553308", "Ijuí\ \-\ RS",
"55693345", "Cabixi\ \-\ RO",
"55323421", "Cataguases\ \-\ MG",
"55114488", "Francisco\ Morato\ \-\ SP",
"55173573", "Roberto\ \-\ SP",
"55114594", "Itatiba\ \-\ SP",
"55843737", "Parnamirim\ \-\ RN",
"55383821", "Janaúba\ \-\ MG",
"55643608", "Bom\ Jesus\ de\ Goiás\ \-\ GO",
"55383663", "Buritis\ \-\ MG",
"55212772", "Duque\ de\ Caxias\ \-\ RJ",
"55943347", "Eldorado\ dos\ Carajás\ \-\ PA",
"55883631", "Itapipoca\ \-\ CE",
"55854102", "Fortaleza\ \-\ CE",
"55413375", "São\ José\ dos\ Pinhais\ \-\ PR",
"55673216", "Sidrolândia\ \-\ MS",
"55115097", "São\ Paulo\ \-\ SP",
"55353021", "Passos\ \-\ MG",
"55193000", "Vinhedo\ \-\ SP",
"55114555", "Mauá\ \-\ SP",
"55383237", "Claro\ dos\ Poções\ \-\ MG",
"55683267", "Vila\ Campinas\ \(Pad\ Peixoto\)\ \-\ AC",
"55893515", "Floriano\ \-\ PI",
"55222534", "Duas\ Barras\ \-\ RJ",
"55753445", "Jandaíra\ \-\ BA",
"55313741", "Ouro\ Branco\ \-\ MG",
"55793266", "Santo\ Amaro\ das\ Brotas\ \-\ SE",
"55823645", "Inhapi\ \-\ AL",
"55382103", "Montes\ Claros\ \-\ MG",
"55413623", "Quitandinha\ \-\ PR",
"55193405", "Americana\ \-\ SP",
"55133495", "Praia\ Grande\ \-\ SP",
"5511314", "São\ Paulo\ \-\ SP",
"55514104", "Canoas\ \-\ RS",
"55823536", "Traipu\ \-\ AL",
"5542322", "Ponta\ Grossa\ \-\ PR",
"55933543", "Rurópolis\ \-\ PA",
"55993587", "São\ Francisco\ do\ Brejão\ \-\ MA",
"55413146", "São\ José\ dos\ Pinhais\ \-\ PR",
"55663528", "Luciára\ \-\ MT",
"55453256", "Mercedes\ \-\ PR",
"55223087", "Macaé\ \-\ RJ",
"55173693", "São\ Francisco\ \-\ SP",
"55323292", "Bom\ Jardim\ de\ Minas\ \-\ MG",
"55343836", "São\ João\ da\ Serra\ Negra\ \-\ MG",
"55513708", "Sinimbu\ \-\ RS",
"5511518", "São\ Paulo\ \-\ SP",
"55633026", "Palmas\ \-\ TO",
"55653254", "Indiavaí\ \-\ MT",
"55143846", "Areiópolis\ \-\ SP",
"55753279", "Paripiranga\ \-\ BA",
"55483433", "Criciúma\ \-\ SC",
"55114201", "Barueri\ \-\ SP",
"55193871", "Valinhos\ \-\ SP",
"55693025", "Porto\ Velho\ \-\ RO",
"55913662", "Terra\ Alta\ \-\ PA",
"55313536", "Florestal\ \-\ MG",
"5587", "Pernambuco",
"55353341", "Caxambu\ \-\ MG",
"55833457", "Princesa\ Isabel\ \-\ PB",
"55143479", "Avencas\ \-\ SP",
"55893577", "Monte\ Alegre\ do\ Piauí\ \-\ PI",
"55133406", "São\ Vicente\ \-\ SP",
"55193496", "Rafard\ \-\ SP",
"55112839", "São\ Paulo\ \-\ SP",
"55473387", "Pomerode\ \-\ SC",
"55533248", "Pinheiro\ Machado\ \-\ RS",
"55212755", "São\ João\ de\ Meriti\ \-\ RJ",
"55163953", "Pontal\ \-\ SP",
"55433311", "Rolândia\ \-\ PR",
"55613453", "Sobradinho\ \-\ DF",
"55493332", "Águas\ Frias\ \-\ SC",
"55193187", "Santa\ Maria\ da\ Serra\ \-\ SP",
"55543383", "Espumoso\ \-\ RS",
"55273177", "Colatina\ \-\ ES",
"55472033", "Balneário\ Camboriú\ \-\ SC",
"55213736", "Rio\ de\ Janeiro\ \-\ RJ",
"55313897", "São\ Miguel\ do\ Anta\ \-\ MG",
"5511407", "Diadema\ \-\ SP",
"55483025", "Florianópolis\ \-\ SC",
"55123894", "Ilhabela\ \-\ SP",
"55773691", "Malhada\ \-\ BA",
"55443628", "Jussara\ \-\ PR",
"55163234", "Ribeirão\ Preto\ \-\ SP",
"55893431", "Padre\ Marcos\ \-\ PI",
"55853305", "Fortaleza\ \-\ CE",
"55433543", "Itambaracá\ \-\ PR",
"55323539", "Ubá\ \-\ MG",
"55193672", "Santa\ Cruz\ das\ Palmeiras\ \-\ SP",
"55114519", "Mauá\ \-\ SP",
"55683213", "Rio\ Branco\ \-\ AC",
"55553272", "Tupanciretã\ \-\ RS",
"55893559", "Itaueira\ \-\ PI",
"55473241", "Itajaí\ \-\ SC",
"55613302", "Sobradinho\ \-\ DF",
"55833479", "Cacimba\ de\ Areia\ \-\ PB",
"55143457", "Oscar\ Bressane\ \-\ SP",
"55323451", "Astolfo\ Dutra\ \-\ MG",
"55543031", "Canela\ \-\ RS",
"55473634", "São\ Bento\ do\ Sul\ \-\ SC",
"55513034", "Sapucaia\ do\ Sul\ \-\ RS",
"55753660", "Pé\ de\ Serra\ \-\ BA",
"55212651", "São\ João\ de\ Meriti\ \-\ RJ",
"55533267", "Herval\ \-\ RS",
"55193625", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55753257", "Bessa\ \-\ BA",
"55383506", "Buritis\ \-\ MG",
"55413662", "Cerro\ Azul\ \-\ PR",
"55313714", "Paraopeba\ \-\ MG",
"55353453", "São\ Sebastião\ da\ Bela\ Vista\ \-\ MG",
"55623396", "Itaguari\ \-\ GO",
"55143283", "Pederneiras\ \-\ SP",
"55553542", "Tucunduva\ \-\ RS",
"55153325", "Sorocaba\ \-\ SP",
"55163475", "Sertãozinho\ \-\ SP",
"55493482", "Concórdia\ \-\ SC",
"55543433", "Arco\ Verde\ \-\ RS",
"55613380", "Núcleo\ Bandeirante\ \-\ DF",
"55114477", "Santo\ André\ \-\ SP",
"55773436", "Barra\ do\ Choça\ \-\ BA",
"55833364", "Remígio\ \-\ PB",
"55443056", "Umuarama\ \-\ PR",
"55333415", "Gonzaga\ \-\ MG",
"55854007", "Maracanaú\ \-\ CE",
"55492049", "Chapecó\ \-\ SC",
"55153372", "Itapetininga\ \-\ SP",
"55433428", "Marilândia\ do\ Sul\ \-\ PR",
"55112811", "Salto\ \-\ SP",
"55283560", "Alegre\ \-\ ES",
"55923673", "Manaus\ \-\ AM",
"55983383", "São\ Bento\ \-\ MA",
"55383236", "Juramento\ \-\ MG",
"55143552", "Getulina\ \-\ SP",
"55643054", "Rio\ Verde\ \-\ GO",
"55673449", "Nova\ Andradina\ \-\ MS",
"55313683", "Jaboticatubas\ \-\ MG",
"55433273", "Miraselva\ \-\ PR",
"55213839", "Rio\ de\ Janeiro\ \-\ RJ",
"55943346", "Parauapebas\ \-\ PA",
"55483264", "Canelinha\ \-\ SC",
"55813030", "Paulista\ \-\ PE",
"55333084", "Governador\ Valadares\ \-\ MG",
"55112657", "Guarulhos\ \-\ SP",
"55623305", "São\ Francisco\ de\ Goiás\ \-\ GO",
"55513438", "Cachoeirinha\ \-\ RS",
"55152105", "Sorocaba\ \-\ SP",
"55553231", "Rosário\ do\ Sul\ \-\ RS",
"5598324", "São\ Luís\ \-\ MA",
"55163463", "Araraquara\ \-\ SP",
"55323511", "Muriaé\ \-\ MG",
"55313295", "Belo\ Horizonte\ \-\ MG",
"55633368", "Pium\ \-\ TO",
"55613963", "Brasília\ \-\ DF",
"55113361", "São\ Paulo\ \-\ SP",
"55893425", "Sussuapara\ \-\ PI",
"55183697", "Rubiácea\ \-\ SP",
"55343251", "Santa\ Vitória\ \-\ MG",
"55333746", "Rubim\ \-\ MG",
"55313254", "Belo\ Horizonte\ \-\ MG",
"55323343", "Senhora\ dos\ Remédios\ \-\ MG",
"55433339", "Londrina\ \-\ PR",
"55112612", "São\ Paulo\ \-\ SP",
"55873884", "São\ José\ do\ Belmonte\ \-\ PE",
"55483031", "Florianópolis\ \-\ SC",
"55833283", "Sapé\ \-\ PB",
"55843260", "São\ Bento\ do\ Norte\ \-\ RN",
"55823295", "São\ Miguel\ dos\ Milagres\ \-\ AL",
"55883655", "Frecheirinha\ \-\ CE",
"55623931", "Goiânia\ \-\ GO",
"55242457", "Santa\ Isabel\ do\ Rio\ Preto\ \-\ RJ",
"55833426", "Emas\ \-\ PB",
"55273345", "Vitória\ \-\ ES",
"55433265", "São\ Sebastião\ da\ Amoreira\ \-\ PR",
"55843367", "Paraú\ \-\ RN",
"55213626", "Rio\ de\ Janeiro\ \-\ RJ",
"55143654", "Brotas\ \-\ SP",
"55633658", "Aurora\ do\ Tocantins\ \-\ TO",
"55113651", "Osasco\ \-\ SP",
"55983264", "São\ Luís\ \-\ MA",
"55183529", "Osvaldo\ Cruz\ \-\ SP",
"55913733", "Murucupi\ \-\ PA",
"55114531", "Jundiaí\ \-\ SP",
"55743658", "Canarana\ \-\ BA",
"55833552", "São\ José\ de\ Piranhas\ \-\ PB",
"55512109", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55613341", "Cruzeiro\ \-\ DF",
"55823254", "São\ Luís\ do\ Quitunde\ \-\ AL",
"55133348", "Guarujá\ \-\ SP",
"55893472", "Francinópolis\ \-\ PI",
"55813343", "Recife\ \-\ PE",
"55183742", "Ilha\ Solteira\ \-\ SP",
"55333531", "Caraí\ \-\ MG",
"55313896", "Pedra\ do\ Anta\ \-\ MG",
"55273072", "Vila\ Velha\ \-\ ES",
"55413902", "Paranaguá\ \-\ PR",
"55153355", "Angatuba\ \-\ SP",
"55453279", "Quatro\ Pontes\ \-\ PR",
"55133844", "Juquiá\ \-\ SP",
"55173243", "Mirassol\ \-\ SP",
"55673038", "Dourados\ \-\ MS",
"55883574", "Barbalha\ \-\ CE",
"55753204", "Feira\ de\ Santana\ \-\ BA",
"55163303", "Araraquara\ \-\ SP",
"55115213", "São\ Paulo\ \-\ SP",
"55513669", "Nova\ Tramandaí\ \-\ RS",
"55153394", "Ibiúna\ \-\ SP",
"55112599", "São\ Paulo\ \-\ SP",
"55514112", "Novo\ Hamburgo\ \-\ RS",
"55193186", "Charqueada\ \-\ SP",
"55143404", "Tupã\ \-\ SP",
"55813642", "Condado\ \-\ PE",
"55383616", "Matias\ Cardoso\ \-\ MG",
"55433141", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55753256", "Tucano\ \-\ BA",
"55663418", "São\ Pedro\ da\ Cipa\ \-\ MT",
"55143522", "Lins\ \-\ SP",
"55543345", "Sertão\ \-\ RS",
"55843232", "Natal\ \-\ RN",
"55793213", "Aracaju\ \-\ SE",
"55243421", "Angra\ dos\ Reis\ \-\ RJ",
"55143456", "Oriente\ \-\ SP",
"55643489", "Água\ Limpa\ \-\ GO",
"55213118", "Rio\ de\ Janeiro\ \-\ RJ",
"55213089", "Rio\ de\ Janeiro\ \-\ RJ",
"55443122", "Maringá\ \-\ PR",
"55114609", "Francisco\ Morato\ \-\ SP",
"55833624", "João\ Pessoa\ \-\ PB",
"55353286", "Divisa\ Nova\ \-\ MG",
"55623473", "Iaciara\ \-\ GO",
"55123632", "Taubaté\ \-\ SP",
"55373233", "Pará\ de\ Minas\ \-\ MG",
"55813435", "Paulista\ \-\ PE",
"55213604", "Niterói\ \-\ RJ",
"55883672", "Nova\ Russas\ \-\ CE",
"55893588", "Anísio\ de\ Abreu\ \-\ PI",
"55114084", "São\ Paulo\ \-\ SP",
"55893494", "Paes\ Landim\ \-\ PI",
"55333242", "São\ João\ do\ Manteninha\ \-\ MG",
"55553611", "Unistalda\ \-\ RS",
"55283532", "Marataízes\ \-\ ES",
"55343221", "Uberlândia\ \-\ MG",
"55924004", "Manaus\ \-\ AM",
"55823537", "Campo\ Grande\ \-\ AL",
"55893455", "Caldeirão\ Grande\ do\ Piauí\ \-\ PI",
"55173638", "Mesópolis\ \-\ SP",
"55993586", "Ribamar\ Fiquene\ \-\ MA",
"55714119", "Candeias\ \-\ BA",
"55513270", "Rio\ Grande\ do\ Sul",
"55453257", "Entre\ Rios\ do\ Oeste\ \-\ PR",
"55614009", "Brasília\ \-\ DF",
"55833456", "Pedra\ Branca\ \-\ PB",
"5511331", "São\ Paulo\ \-\ SP",
"55893576", "Cristalândia\ do\ Piauí\ \-\ PI",
"55543055", "Bento\ Gonçalves\ \-\ RS",
"55883625", "Chaval\ \-\ CE",
"55193497", "Limeira\ \-\ SP",
"55813544", "Ilha\ de\ Itamaracá\ \-\ PE",
"55643543", "Cezarina\ \-\ GO",
"555131", "Rio\ Grande\ do\ Sul",
"55473386", "Rio\ dos\ Cedros\ \-\ SC",
"55733311", "Teixeira\ de\ Freitas\ \-\ BA",
"55453333", "Cascavel\ \-\ PR",
"55953212", "Boa\ Vista\ \-\ RR",
"55313382", "Minas\ Gerais",
"55143847", "Itatinga\ \-\ SP",
"55733543", "Itaquara\ \-\ BA",
"55993578", "São\ Domingos\ do\ Maranhão\ \-\ MA",
"55883619", "Forquilha\ \-\ CE",
"553136", "Minas\ Gerais",
"55513049", "Campo\ Bom\ \-\ RS",
"55353462", "Estiva\ \-\ MG",
"55833522", "Sousa\ \-\ PB",
"55313537", "Serra\ Azul\ \-\ MG",
"55613567", "Guará\ \-\ DF",
"55743628", "Piritiba\ \-\ BA",
"55114028", "Salto\ \-\ SP",
"55114599", "Jundiaí\ \-\ SP",
"55313755", "Senhora\ de\ Oliveira\ \-\ MG",
"55753451", "Araças\ \-\ BA",
"55352105", "Varginha\ \-\ MG",
"55115063", "São\ Paulo\ \-\ SP",
"55163721", "Franca\ \-\ SP",
"55663433", "Primavera\ do\ Leste\ \-\ MT",
"5561325", "Brasília\ \-\ DF",
"55613331", "Recanto\ das\ Emas\ \-\ DF",
"55193641", "Vargem\ Grande\ do\ Sul\ \-\ SP",
"55273335", "Vitória\ \-\ ES",
"55323257", "Juiz\ de\ Fora\ \-\ MG",
"55623999", "Goiânia\ \-\ GO",
"55213133", "Rio\ de\ Janeiro\ \-\ RJ",
"55473447", "Araquari\ \-\ SC",
"55873858", "Pedra\ \-\ PE",
"55983661", "Codó\ \-\ MA",
"55623941", "Goiânia\ \-\ GO",
"55643520", "Itumbiara\ \-\ GO",
"55823276", "Jequiá\ da\ Praia\ \-\ AL",
"55323333", "Barbacena\ \-\ MG",
"55623363", "Porangatu\ \-\ GO",
"55273269", "Alfredo\ Chaves\ \-\ ES",
"55493301", "Concórdia\ \-\ SC",
"55333736", "Virgem\ da\ Lapa\ \-\ MG",
"55123961", "Jacareí\ \-\ SP",
"55713396", "Simões\ Filho\ \-\ BA",
"55153566", "Bairro\ Palmitalzinho\ \-\ SP",
"55343654", "Santa\ Rosa\ da\ Serra\ \-\ MG",
"55843084", "Natal\ \-\ RN",
"55843429", "Jucurutu\ \-\ RN",
"55313651", "Caeté\ \-\ MG",
"55823288", "Quebrangulo\ \-\ AL",
"55713681", "Vera\ Cruz\ \-\ BA",
"55313817", "Ponte\ Nova\ \-\ MG",
"55553241", "Santana\ do\ Livramento\ \-\ RS",
"55855672", "São\ Paulo\ \-\ SP",
"5598323", "São\ Luís\ \-\ MA",
"55773611", "Barreiras\ \-\ BA",
"55833492", "Monte\ Horebe\ \-\ PB",
"55743684", "Canarana\ \-\ BA",
"55513448", "Rio\ Grande\ do\ Sul",
"55983351", "Viana\ \-\ MA",
"55513151", "Porto\ Alegre\ \-\ RS",
"55313276", "Minas\ Gerais",
"55423035", "Guarapuava\ \-\ PR",
"5583333", "Campina\ Grande\ \-\ PB",
"55213849", "Rio\ de\ Janeiro\ \-\ RJ",
"55213891", "Rio\ de\ Janeiro\ \-\ RJ",
"55463213", "Pato\ Branco\ \-\ PR",
"55963332", "Macapá\ \-\ AP",
"55833251", "João\ Pessoa\ \-\ PB",
"55673439", "Bela\ Vista\ \-\ MS",
"55473501", "Jaraguá\ do\ Sul\ \-\ SC",
"55423423", "Irati\ \-\ PR",
"55353325", "Andrelândia\ \-\ MG",
"55353593", "Jacuí\ \-\ MG",
"55793643", "Riachão\ do\ Dantas\ \-\ SE",
"55733687", "Caravelas\ \-\ BA",
"55343283", "Monte\ Alegre\ de\ Minas\ \-\ MG",
"55112429", "Itu\ \-\ SP",
"55313852", "João\ Monlevade\ \-\ MG",
"55173101", "Uchoa\ \-\ SP",
"55423278", "Imbaú\ \-\ PR",
"55163405", "Franca\ \-\ SP",
"55683301", "Rio\ Branco\ \-\ AC",
"55793022", "Aracaju\ \-\ SE",
"55643687", "Córrego\ do\ Ouro\ \-\ GO",
"55813212", "Recife\ \-\ PE",
"55843338", "Carnaubais\ \-\ RN",
"55883303", "Aracati\ \-\ CE",
"55213555", "Rio\ de\ Janeiro\ \-\ RJ",
"55543443", "Guaporé\ \-\ RS",
"55143492", "Vera\ Cruz\ \-\ SP",
"55553387", "Ajuricaba\ \-\ RS",
"55883526", "Saboeiro\ \-\ CE",
"55153302", "Sorocaba\ \-\ SP",
"55115643", "São\ Paulo\ \-\ SP",
"55773446", "Aracatu\ \-\ BA",
"55333514", "Malacacheta\ \-\ MG",
"55343426", "Pirajuba\ \-\ MG",
"55623375", "Itaberaí\ \-\ GO",
"55193842", "Serra\ Negra\ \-\ SP",
"55513467", "Canoas\ \-\ RS",
"55672108", "Dourados\ \-\ MS",
"55643088", "Itumbiara\ \-\ GO",
"55833474", "Maturéia\ \-\ PB",
"55423916", "Tibagi\ \-\ PR",
"55733533", "Maracas\ \-\ BA",
"55823621", "Santana\ do\ Ipanema\ \-\ AL",
"55163751", "Buritizal\ \-\ SP",
"55753421", "Alagoinhas\ \-\ BA",
"55313725", "Caranaíba\ \-\ MG",
"55893554", "São\ José\ do\ Peixe\ \-\ PI",
"55313547", "Minas\ Gerais",
"55533293", "Rio\ Grande\ \-\ RS",
"55513039", "Sapiranga\ \-\ RS",
"55213674", "Niterói\ \-\ RJ",
"5561322", "Brasília\ \-\ DF",
"5512391", "São\ José\ dos\ Campos\ \-\ SP",
"55873828", "Tuparetama\ \-\ PE",
"55643533", "Itumbiara\ \-\ GO",
"55813534", "Escada\ \-\ PE",
"55793342", "Muribeca\ \-\ SE",
"55713473", "Salvador\ \-\ BA",
"55143221", "Marília\ \-\ SP",
"55414114", "Curitiba\ \-\ PR",
"55843531", "Angicos\ \-\ RN",
"55673668", "Paranaíba\ \-\ MS",
"55383845", "Taiobeiras\ \-\ MG",
"55212645", "Itaboraí\ \-\ RJ",
"55473255", "Brusque\ \-\ SC",
"55313719", "Minas\ Gerais",
"55693321", "Vilhena\ \-\ RO",
"55323445", "Argirita\ \-\ MG",
"55173648", "Paranapuã\ \-\ SP",
"5531331", "Minas\ Gerais",
"55283542", "Castelo\ \-\ ES",
"55714102", "Salvador\ \-\ BA",
"55513787", "Pinheiral\ \-\ RS",
"55114657", "Santa\ Isabel\ \-\ SP",
"55173312", "Barretos\ \-\ SP",
"55313863", "Ferros\ \-\ MG",
"55193557", "Rio\ Claro\ \-\ SP",
"55482101", "Criciúma\ \-\ SC",
"55483014", "São\ João\ Batista\ \-\ SC",
"55313621", "Vespasiano\ \-\ MG",
"55422122", "Castro\ \-\ PR",
"55653277", "Caramujo\ \-\ MT",
"55813831", "Serra\ Talhada\ \-\ PE",
"55843198", "Natal\ \-\ RN",
"55343847", "Abadia\ dos\ Dourados\ \-\ MG",
"55773644", "Brotas\ de\ Macaúbas\ \-\ BA",
"55454100", "Cascavel\ \-\ PR",
"55813445", "Recife\ \-\ PE",
"55183441", "Araçatuba\ \-\ SP",
"55212741", "Teresópolis\ \-\ RJ",
"55323534", "Brás\ Pires\ \-\ MG",
"55114811", "Franco\ da\ Rocha\ \-\ SP",
"55434001", "Londrina\ \-\ PR",
"55933598", "Jamanchizinho\ \-\ PA",
"55333232", "Sobrália\ \-\ MG",
"55213201", "Rio\ de\ Janeiro\ \-\ RJ",
"55383742", "Buritizeiro\ \-\ MG",
"5551329", "Rio\ Grande\ do\ Sul",
"55413972", "Pontal\ do\ Paraná\ \-\ PR",
"55753274", "Cansanção\ \-\ BA",
"55414007", "Curitiba\ \-\ PR",
"55873786", "Iati\ \-\ PE",
"55373243", "Itaúna\ \-\ MG",
"55222796", "Macaé\ \-\ RJ",
"55193512", "Campinas\ \-\ SP",
"55693485", "Espigão\ D\'Oeste\ \-\ RO",
"55692101", "Vilhena\ \-\ RO",
"55112834", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55333627", "Machacalis\ \-\ MG",
"55143474", "Lupércio\ \-\ SP",
"55114736", "Mogi\ das\ Cruzes\ \-\ SP",
"55153278", "Pilar\ do\ Sul\ \-\ SP",
"55633478", "Filadélfia\ \-\ TO",
"55212780", "Mangaratiba\ \-\ RJ",
"55123023", "Jacareí\ \-\ SP",
"55453030", "Foz\ do\ Iguaçu\ \-\ PR",
"55843242", "Arês\ \-\ RN",
"55983485", "Água\ Doce\ do\ Maranhão\ \-\ MA",
"55514109", "Gravataí\ \-\ RS",
"55483321", "Florianópolis\ \-\ SC",
"55423302", "Ponta\ Grossa\ \-\ PR",
"55213525", "Rio\ de\ Janeiro\ \-\ RJ",
"55333313", "Inhapim\ \-\ MG",
"55213747", "Rio\ de\ Janeiro\ \-\ RJ",
"55653003", "Cuiabá\ \-\ MT",
"55173667", "Turmalina\ \-\ SP",
"55883556", "Catarina\ \-\ CE",
"55883422", "Morada\ Nova\ \-\ CE",
"55433015", "Rolândia\ \-\ PR",
"55343456", "União\ de\ Minas\ \-\ MG",
"55673521", "Três\ Lagoas\ \-\ MS",
"55153286", "Jumirim\ \-\ SP",
"55843477", "Ouro\ Branco\ \-\ RN",
"55653259", "Vila\ Bela\ da\ Santíssima\ Trindade\ \-\ MT",
"55193579", "Campinas\ \-\ SP",
"55983014", "São\ Luís\ \-\ MA",
"55313875", "Santa\ Margarida\ \-\ MG",
"55443429", "Diamante\ do\ Norte\ \-\ PR",
"55472104", "Itajaí\ \-\ SC",
"55773448", "Dom\ Basílio\ \-\ BA",
"55373545", "Paineiras\ \-\ MG",
"55733086", "Ilhéus\ \-\ BA",
"55513611", "Chuvisca\ \-\ RS",
"55153547", "Guapiara\ \-\ SP",
"55413081", "São\ José\ dos\ Pinhais\ \-\ PR",
"55143203", "Bauru\ \-\ SP",
"55493237", "Capão\ Alto\ \-\ SC",
"55543614", "Rio\ dos\ Índios\ \-\ RS",
"55114163", "Barueri\ \-\ SP",
"5551332", "Rio\ Grande\ do\ Sul",
"55833391", "Boqueirão\ \-\ PB",
"55733677", "Coroa\ Vermelha\ \-\ BA",
"55633393", "Chapada\ da\ Natividade\ \-\ TO",
"55324141", "Juiz\ de\ Fora\ \-\ MG",
"55672106", "Campo\ Grande\ \-\ MS",
"55643086", "Itumbiara\ \-\ GO",
"55633519", "Lajeado\ \-\ TO",
"55553270", "São\ Miguel\ \-\ RS",
"55463559", "Quedas\ do\ Iguaçu\ \-\ PR",
"55833077", "Campina\ Grande\ \-\ PB",
"55823035", "Maceió\ \-\ AL",
"55313111", "São\ Joaquim\ de\ Bicas\ \-\ MG",
"55873272", "Parnamirim\ \-\ RN",
"55753662", "Laje\ \-\ BA",
"55343428", "Fronteira\ \-\ MG",
"55643677", "Amorinópolis\ \-\ GO",
"55633572", "Palmas\ \-\ TO",
"55473135", "Rio\ da\ Anta\ \-\ SC",
"55373434", "Medeiros\ \-\ MG",
"55213610", "Niterói\ \-\ RJ",
"55493524", "Água\ Doce\ \-\ SC",
"55553377", "Pejuçara\ \-\ RS",
"55223311", "Macaé\ \-\ RJ",
"55654009", "Cuiabá\ \-\ MT",
"55513715", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55423651", "Reserva\ do\ Iguaçu\ \-\ PR",
"55353537", "Fortaleza\ de\ Minas\ \-\ MG",
"55513729", "Lajeado\ \-\ RS",
"55313462", "Belo\ Horizonte\ \-\ MG",
"55613432", "Formosa\ \-\ GO",
"55843336", "São\ Rafael\ \-\ RN",
"55653314", "Cuiabá\ \-\ MT",
"55493353", "Xaxim\ \-\ SC",
"55423276", "Reserva\ \-\ PR",
"55623385", "Nova\ Crixás\ \-\ GO",
"55693526", "Jaru\ \-\ RO",
"55993622", "Bacabal\ \-\ MA",
"55193124", "Piracicaba\ \-\ SP",
"55222662", "Arraial\ do\ Cabo\ \-\ RJ",
"55863332", "Caxingó\ \-\ PI",
"55493330", "Chapecó\ \-\ SC",
"55713204", "Salvador\ \-\ BA",
"55222623", "Armação\ dos\ Búzios\ \-\ RJ",
"55493675", "Riqueza\ \-\ SC",
"55993663", "Presidente\ Dutra\ \-\ MA",
"55483526", "Balneário\ Arroio\ do\ Silva\ \-\ SC",
"55453902", "Cascavel\ \-\ PR",
"55643659", "Itarumã\ \-\ GO",
"55112336", "São\ Paulo\ \-\ SP",
"55183022", "Assis\ \-\ SP",
"55333738", "Francisco\ Badaró\ \-\ MG",
"55773467", "Jacaraci\ \-\ BA",
"55143764", "Iaras\ \-\ SP",
"55434062", "Londrina\ \-\ PR",
"55323743", "Divino\ \-\ MG",
"5555", "Rio\ Grande\ do\ Sul",
"5511267", "São\ Paulo\ \-\ SP",
"55343265", "Cachoeira\ Dourada\ \-\ MG",
"55183643", "Birigui\ \-\ SP",
"55513446", "Viamão\ \-\ RS",
"55923361", "Manacapuru\ \-\ AM",
"55823286", "Murici\ \-\ AL",
"55353471", "Santa\ Rita\ do\ Sapucaí\ \-\ MG",
"55273745", "Águia\ Branca\ \-\ ES",
"55823423", "Igaci\ \-\ AL",
"55623421", "Alvorada\ do\ Norte\ \-\ GO",
"55753623", "Feira\ de\ Santana\ \-\ BA",
"55673503", "Paranaíba\ \-\ MS",
"55883661", "Acaraú\ \-\ CE",
"55663211", "Sinop\ \-\ MT",
"55114026", "Itu\ \-\ SP",
"55383633", "Ubaí\ \-\ MG",
"55433251", "Cambé\ \-\ PR",
"55493622", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55373216", "Divinópolis\ \-\ MG",
"55713671", "Camaçari\ \-\ BA",
"55823278", "Tanque\ D\'Arca\ \-\ AL",
"55483303", "Florianópolis\ \-\ SC",
"55743674", "Lajes\ do\ Batata\ \-\ BA",
"55663497", "Primavera\ do\ Leste\ \-\ MT",
"55873856", "Tupanatinga\ \-\ PE",
"55813743", "Camocim\ de\ São\ Félix\ \-\ PE",
"55613799", "Brasília\ \-\ DF",
"55553359", "Cerro\ Largo\ \-\ RS",
"55222564", "Trajano\ de\ Morais\ \-\ RJ",
"55173807", "Ubarana\ \-\ SP",
"55683237", "Plácido\ de\ Castro\ \-\ AC",
"55793236", "Aracaju\ \-\ SE",
"55653548", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55313916", "Belo\ Horizonte\ \-\ MG",
"55883558", "Abaiara\ \-\ CE",
"55353295", "Machado\ \-\ MG",
"55753284", "Macururé\ \-\ BA",
"55473044", "Brusque\ \-\ SC",
"55543234", "São\ José\ dos\ Ausentes\ \-\ RS",
"55713717", "Camaçari\ \-\ BA",
"55633488", "Praia\ Norte\ \-\ TO",
"55634003", "Palmas\ \-\ TO",
"55143484", "Álvaro\ de\ Carvalho\ \-\ SP",
"55153288", "Cerquilho\ \-\ SP",
"55163383", "Matão\ \-\ SP",
"55123147", "Queluz\ \-\ SP",
"55693422", "Ji\-Paraná\ \-\ RO",
"55543527", "Áurea\ \-\ RS",
"55483463", "Forquilhinha\ \-\ SC",
"55983475", "Mata\ Roma\ \-\ MA",
"55312122", "Belo\ Horizonte\ \-\ MG",
"55873788", "Angelim\ \-\ PE",
"55613536", "Brasília\ \-\ DF",
"55653513", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55433474", "Grandes\ Rios\ \-\ PR",
"55493554", "Herval\ D\'Oeste\ \-\ SC",
"55473562", "Taió\ \-\ SC",
"55493018", "Lages\ \-\ SC",
"55853343", "Canindé\ \-\ CE",
"55493323", "Chapecó\ \-\ SC",
"55653341", "Santo\ Antônio\ do\ Leverger\ \-\ MT",
"55513759", "Travesseiro\ \-\ RS",
"55753322", "Feira\ de\ Santana\ \-\ BA",
"55413534", "São\ José\ dos\ Pinhais\ \-\ PR",
"55153276", "Sarapuí\ \-\ SP",
"55114738", "Mogi\ das\ Cruzes\ \-\ SP",
"55633476", "Colinas\ do\ Tocantins\ \-\ TO",
"55313885", "Viçosa\ \-\ MG",
"55863248", "Buriti\ dos\ Montes\ \-\ PI",
"55443531", "Peabiru\ \-\ PR",
"55193589", "Porto\ Ferreira\ \-\ SP",
"55513958", "Charqueadas\ \-\ RS",
"55513542", "Taquara\ \-\ RS",
"55743692", "América\ Dourada\ \-\ BA",
"55833484", "Juru\ \-\ PB",
"55313430", "Minas\ Gerais",
"55222653", "Saquarema\ \-\ RJ",
"55473354", "Guabiruba\ \-\ SC",
"55493362", "Novo\ Horizonte\ \-\ SC",
"55913445", "Santa\ Luzia\ do\ Pará\ \-\ PA",
"55213766", "Nova\ Iguaçu\ \-\ RJ",
"55863360", "Joaquim\ Pires\ \-\ PI",
"55222630", "Cabo\ Frio\ \-\ RJ",
"55643629", "Montividiu\ \-\ GO",
"55823302", "Maceió\ \-\ AL",
"55933596", "São\ José\ \-\ PA",
"55633692", "Dianópolis\ \-\ TO",
"55643615", "Quirinópolis\ \-\ GO",
"55115616", "São\ Paulo\ \-\ SP",
"55473395", "Pomerode\ \-\ SC",
"55773413", "Cascavel\ \-\ BA",
"55473523", "Lontras\ \-\ SC",
"55214139", "Maricá\ \-\ RJ",
"55623539", "Goiânia\ \-\ GO",
"55673907", "Corumbá\ \-\ MS",
"55693463", "Mirante\ da\ Serra\ \-\ RO",
"55833015", "João\ Pessoa\ \-\ PB",
"55733629", "São\ João\ do\ Paraíso\ \-\ BA",
"55133500", "Santos\ \-\ SP",
"55893461", "Colônia\ do\ Piauí\ \-\ PI",
"55963697", "Chaves\ \-\ PA",
"55513777", "Putinga\ \-\ RS",
"55753653", "Cairu\ \-\ BA",
"55623451", "Campos\ Belos\ \-\ GO",
"55223054", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55933505", "Aveiro\ \-\ PA",
"55813972", "Recife\ \-\ PE",
"55493652", "Palma\ Sola\ \-\ SC",
"55513064", "Sapiranga\ \-\ RS",
"55814007", "Recife\ \-\ PE",
"55643597", "Itumbiara\ \-\ GO",
"55542521", "Bento\ Gonçalves\ \-\ RS",
"55863267", "Lagoa\ Alegre\ \-\ PI",
"55443242", "Floraí\ \-\ PR",
"55752102", "Feira\ de\ Santana\ \-\ BA",
"55533237", "Povo\ Novo\ \-\ RS",
"55983463", "Itapecuru\ Mirim\ \-\ MA",
"55673666", "Chapadão\ do\ Sul\ \-\ MS",
"55993554", "Paraibano\ \-\ MA",
"55553329", "Entre\ Ijuís\ \-\ RS",
"55463246", "Saudade\ do\ Iguaçu\ \-\ PR",
"55413632", "Piên\ \-\ PR",
"55163321", "Tabatinga\ \-\ SP",
"55933552", "Placas\ \-\ PA",
"55113423", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55313761", "Conselheiro\ Lafaiete\ \-\ MG",
"55833428", "Mãe\ d\'Água\ \-\ PB",
"55243352", "Itatiaia\ \-\ RJ",
"55454007", "Cascavel\ \-\ PR",
"5516361", "Ribeirão\ Preto\ \-\ SP",
"55813733", "Taquaritinga\ do\ Norte\ \-\ PE",
"55743656", "Canarana\ \-\ BA",
"55273735", "Afonso\ Cláudio\ \-\ ES",
"55833273", "Alagoa\ Grande\ \-\ PB",
"55313394", "Belo\ Horizonte\ \-\ MG",
"55873874", "Ouricuri\ \-\ PE",
"55713113", "Salvador\ \-\ BA",
"55143265", "Piratininga\ \-\ SP",
"55353822", "Lavras\ \-\ MG",
"5511260", "São\ Paulo\ \-\ SP",
"55983655", "Zé\ Doca\ \-\ MA",
"55613003", "Brasília\ \-\ DF",
"55693239", "Campo\ Novo\ de\ Rondônia\ \-\ RO",
"55313665", "Pedro\ Leopoldo\ \-\ MG",
"55633366", "Miracema\ do\ Tocantins\ \-\ TO",
"55333336", "Simonésia\ \-\ MG",
"55193345", "Campinas\ \-\ SP",
"55883510", "Iguatu\ \-\ CE",
"55163830", "Ituverava\ \-\ SP",
"55513436", "Viamão\ \-\ RS",
"55553413", "Uruguaiana\ \-\ RS",
"55993425", "Jenipapo\ dos\ Vieiras\ \-\ MA",
"55314122", "Contagem\ \-\ MG",
"55663557", "Tabaporã\ \-\ MT",
"55713601", "Candeias\ \-\ BA",
"55443679", "Tapira\ \-\ PR",
"55183267", "Santo\ Expedito\ \-\ SP",
"55114092", "Diadema\ \-\ SP",
"55733245", "Ubatã\ \-\ BA",
"55112346", "São\ Paulo\ \-\ SP",
"55893482", "Simplício\ Mendes\ \-\ PI",
"55513560", "Araricá\ \-\ RS",
"5513342", "Itanhaém\ \-\ SP",
"55673929", "Três\ Lagoas\ \-\ MS",
"55223533", "Vila\ Velha\ \-\ ES",
"55383238", "Grão\ Mogol\ \-\ MG",
"55313045", "Belo\ Horizonte\ \-\ MG",
"55853320", "Paramoti\ \-\ CE",
"55483655", "Sangão\ \-\ SC",
"55163942", "Sertãozinho\ \-\ SP",
"55833265", "Duas\ Estradas\ \-\ PB",
"55143273", "Fernão\ \-\ SP",
"55162101", "Ribeirão\ Preto\ \-\ SP",
"55163014", "Araraquara\ \-\ SP",
"55663512", "Alta\ Floresta\ \-\ MT",
"55873202", "Petrolina\ \-\ PE",
"55433552", "Nova\ Fátima\ \-\ PR",
"55474063", "Joinville\ \-\ SC",
"55643607", "Itumbiara\ \-\ GO",
"55883115", "Juazeiro\ do\ Norte\ \-\ CE",
"55423254", "Colônia\ Witmarsum\ \-\ PR",
"55943348", "Curionópolis\ \-\ PA",
"55114487", "Itatiba\ \-\ SP",
"55483239", "Florianópolis\ \-\ SC",
"55633424", "Goianorte\ \-\ TO",
"55933517", "Creporizão\ \-\ PA",
"55553307", "Santa\ Maria\ \-\ RS",
"55663579", "Nova\ Ubiratã\ \-\ MT",
"55353621", "Itajubá\ \-\ MG",
"55353863", "Santo\ Antônio\ do\ Amparo\ \-\ MG",
"55623398", "Itaguaru\ \-\ GO",
"55193055", "Pirassununga\ \-\ SP",
"55983373", "Maracaçumé\ \-\ MA",
"55112152", "Jundiaí\ \-\ SP",
"55493247", "Lebon\ Régis\ \-\ SC",
"5512320", "São\ José\ dos\ Campos\ \-\ SP",
"55153537", "Itapetininga\ \-\ SP",
"55673565", "Aparecida\ do\ Taboado\ \-\ MS",
"55773438", "Cândido\ Sales\ \-\ BA",
"55113603", "Osasco\ \-\ SP",
"55493425", "Concórdia\ \-\ SC",
"55933522", "Santarém\ \-\ PA",
"55314004", "Belo\ Horizonte\ \-\ MG",
"55713167", "Salvador\ \-\ BA",
"55123972", "Santa\ Branca\ \-\ SP",
"55443232", "Marialva\ \-\ PR",
"55313325", "Minas\ Gerais",
"55533247", "Bagé\ \-\ RS",
"55473388", "Doutor\ Pedrinho\ \-\ SC",
"55163351", "São\ Carlos\ \-\ SP",
"55893578", "Gilbués\ \-\ PI",
"55413642", "Araucária\ \-\ PR",
"55243322", "Barra\ Mansa\ \-\ RJ",
"55833458", "Manaíra\ \-\ PB",
"55473261", "Balneário\ Camboriú\ \-\ SC",
"55743626", "Mundo\ Novo\ \-\ BA",
"55674002", "Campo\ Grande\ \-\ MS",
"55913544", "Oriximiná\ \-\ PA",
"55474104", "São\ Bento\ do\ Sul\ \-\ SC",
"55993576", "Matões\ \-\ MA",
"55163661", "Batatais\ \-\ SP",
"55513387", "Rio\ Grande\ do\ Sul",
"55824004", "Maceió\ \-\ AL",
"55673285", "Jaraguari\ \-\ MS",
"55473376", "Jaraguá\ do\ Sul\ \-\ SC",
"55513707", "Lajeado\ \-\ RS",
"55873892", "Terra\ Nova\ \-\ PE",
"55313372", "Minas\ Gerais",
"55623591", "Goiânia\ \-\ GO",
"5577", "Bahia",
"55433563", "Tomazina\ \-\ PR",
"55623549", "Aparecida\ de\ Goiânia\ \-\ GO",
"55474052", "Blumenau\ \-\ SC",
"55663527", "Nova\ União\ \-\ MT",
"55313440", "Minas\ Gerais",
"55983672", "Bom\ Jardim\ \-\ MA",
"55222640", "Cabo\ Frio\ \-\ RJ",
"55173636", "Dolcinópolis\ \-\ SP",
"55122131", "Guaratinguetá\ \-\ SP",
"55273082", "Vitória\ \-\ ES",
"55242102", "Volta\ Redonda\ \-\ RJ",
"55653331", "Barão\ de\ Melgaço\ \-\ MT",
"55353361", "Itanhandu\ \-\ MG",
"55643412", "Itumbiara\ \-\ GO",
"55143585", "Pirajuí\ \-\ SP",
"5513345", "Peruíbe\ \-\ SP",
"55813316", "Recife\ \-\ PE",
"55443541", "Moreira\ Sales\ \-\ PR",
"55163041", "Sertãozinho\ \-\ SP",
"55433456", "Apucarana\ \-\ PR",
"55753258", "Araci\ \-\ BA",
"55663416", "General\ Carneiro\ \-\ MT",
"55443599", "Campo\ Mourão\ \-\ PR",
"5511467", "Ferraz\ de\ Vasconcelos\ \-\ SP",
"55483625", "Treze\ de\ Maio\ \-\ SC",
"55883584", "Orós\ \-\ CE",
"55713451", "Salvador\ \-\ BA",
"55212700", "Itaguaí\ \-\ RJ",
"5543302", "Londrina\ \-\ PR",
"55443313", "Santa\ Inês\ \-\ PR",
"55793431", "Itabaiana\ \-\ SE",
"55143458", "Queiroz\ \-\ SP",
"55633454", "Aguiarnópolis\ \-\ TO",
"55213116", "Rio\ de\ Janeiro\ \-\ RJ",
"55692181", "Porto\ Velho\ \-\ RO",
"55212380", "Rio\ de\ Janeiro\ \-\ RJ",
"55483721", "Florianópolis\ \-\ SC",
"55115845", "São\ Paulo\ \-\ SP",
"55353651", "Paraisópolis\ \-\ MG",
"55173829", "Talhado\ \-\ SP",
"5541356", "Curitiba\ \-\ PR",
"55443627", "São\ Lourenço\ \-\ PR",
"55343131", "Uberlândia\ \-\ MG",
"55313898", "Cajuri\ \-\ MG",
"55193019", "Mogi\-Guaçu\ \-\ SP",
"55513634", "Bom\ Princípio\ \-\ RS",
"55222785", "Cardoso\ Moreira\ \-\ RJ",
"55643479", "Panamá\ \-\ GO",
"5511316", "São\ Paulo\ \-\ SP",
"5528", "Espirito\ Santo",
"55543244", "São\ Francisco\ de\ Paula\ \-\ RS",
"55873795", "Jurema\ \-\ PE",
"55823481", "Arapiraca\ \-\ AL",
"55933563", "Curuá\ \-\ PA",
"55173815", "Guaraci\ \-\ SP",
"55433575", "Londrina\ \-\ PR",
"55493455", "Alto\ Bela\ Vista\ \-\ SC",
"55753681", "Cabaceiras\ do\ Paraguaçu\ \-\ BA",
"55623483", "Sítio\ D\'Abadia\ \-\ GO",
"55883420", "São\ João\ do\ Jaguaribe\ \-\ CE",
"55663463", "Primavera\ do\ Leste\ \-\ MT",
"55112658", "Poá\ \-\ SP",
"55553523", "Padre\ Gonzales\ \-\ RS",
"55114486", "Terra\ Preta\ \-\ SP",
"55613361", "Guará\ \-\ DF",
"55313331", "Minas\ Gerais",
"5531325", "Minas\ Gerais",
"55813363", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55643517", "Itumbiara\ \-\ GO",
"55322102", "Juiz\ de\ Fora\ \-\ MG",
"55413601", "Pinhais\ \-\ PR",
"55513571", "São\ José\ do\ Hortêncio\ \-\ RS",
"55793268", "General\ Maynard\ \-\ SE",
"55553354", "Porto\ Xavier\ \-\ RS",
"55143813", "Botucatu\ \-\ SP",
"55273751", "Mucurici\ \-\ ES",
"55443366", "Maringá\ \-\ PR",
"55493246", "Fraiburgo\ \-\ SC",
"55313820", "Minas\ Gerais",
"55113513", "São\ Paulo\ \-\ SP",
"55323363", "Lagoa\ Dourada\ \-\ MG",
"55273239", "Vila\ Velha\ \-\ ES",
"55143769", "Holambra\ II\ \-\ SP",
"55813653", "Lagoa\ do\ Itaenga\ \-\ PE",
"55843240", "Montanhas\ \-\ RN",
"55643654", "Cachoeira\ Alta\ \-\ GO",
"55413385", "São\ José\ dos\ Pinhais\ \-\ PR",
"55643695", "Adelândia\ \-\ GO",
"55943424", "Redenção\ \-\ PA",
"55383740", "Pirapora\ \-\ MG",
"55633612", "Gurupi\ \-\ TO",
"55413113", "Campo\ Largo\ \-\ PR",
"55773493", "Guanambi\ \-\ BA",
"55115696", "São\ Paulo\ \-\ SP",
"55122125", "Taubaté\ \-\ SP",
"55873809", "Iguaraci\ \-\ PE",
"55143344", "Ipaussu\ \-\ SP",
"55812102", "Recife\ \-\ PE",
"55443656", "Alto\ Piquiri\ \-\ PR",
"55963323", "Macapá\ \-\ AP",
"55913802", "Mãe\ do\ Rio\ \-\ PA",
"55113399", "São\ Paulo\ \-\ SP",
"55143102", "Bauru\ \-\ SP",
"55273373", "Linhares\ \-\ ES",
"55673469", "Culturama\ \-\ MS",
"55133347", "Guarujá\ \-\ SP",
"55333253", "Belo\ Oriente\ \-\ MG",
"55743657", "Lapão\ \-\ BA",
"55213175", "Nilópolis\ \-\ RJ",
"55483631", "Tubarão\ \-\ SC",
"55943366", "Vila\ Novo\ Paraíso\ \-\ PA",
"55483244", "Florianópolis\ \-\ SC",
"55653325", "Tangará\ da\ Serra\ \-\ MT",
"55654004", "Várzea\ Grande\ \-\ MT",
"55843281", "Nova\ Cruz\ \-\ RN",
"55663504", "União\ do\ Norte\ \(Antiga\ Lenislândia\)\ \-\ MT",
"55513724", "Cachoeira\ do\ Sul\ \-\ RS",
"55423645", "Laranjal\ \-\ PR",
"55653319", "Cuiabá\ \-\ MT",
"55183371", "Maracaí\ \-\ SP",
"55733283", "Camacã\ \-\ BA",
"55123681", "Taubaté\ \-\ SP",
"55242458", "Rio\ das\ Flores\ \-\ RJ",
"55843368", "Triunfo\ Potiguar\ \-\ RN",
"55913796", "Mocajuba\ \-\ PA",
"55193129", "Vinhedo\ \-\ SP",
"55323322", "Nazareno\ \-\ MG",
"55323284", "Belmiro\ Braga\ \-\ MG",
"55193031", "Campinas\ \-\ SP",
"55443424", "Paranavaí\ \-\ PR",
"55663556", "Juara\ \-\ MT",
"55333582", "São\ José\ do\ Divino\ \-\ MG",
"5521345", "Rio\ de\ Janeiro\ \-\ RJ",
"55183698", "Lavínia\ \-\ SP",
"55112347", "São\ Paulo\ \-\ SP",
"55183266", "Alfredo\ Marcondes\ \-\ SP",
"55713797", "Salvador\ \-\ BA",
"55323375", "Conceição\ da\ Barra\ de\ Minas\ \-\ MG",
"55633367", "Tocantínia\ \-\ TO",
"55353229", "Varginha\ \-\ MG",
"55343088", "Uberlândia\ \-\ MG",
"55733552", "Córrego\ de\ Pedras\ \-\ BA",
"55373551", "Dores\ do\ Indaiá\ \-\ MG",
"55543625", "Capão\ Bonito\ do\ Sul\ \-\ RS",
"55513437", "Rio\ Grande\ do\ Sul",
"556432", "Itumbiara\ \-\ GO",
"55112628", "São\ Paulo\ \-\ SP",
"5547", "Santa\ Catarina",
"55183723", "Andradina\ \-\ SP",
"55863293", "Regeneração\ \-\ PI",
"5531322", "Belo\ Horizonte\ \-\ MG",
"55353442", "Bueno\ Brandão\ \-\ MG",
"55883433", "Aracati\ \-\ CE",
"55543373", "São\ Valentim\ \-\ RS",
"55643563", "Jandaia\ \-\ GO",
"55413292", "Campo\ Largo\ \-\ PR",
"55623445", "Damianópolis\ \-\ GO",
"55273721", "Colatina\ \-\ ES",
"55993559", "Sucupira\ do\ Norte\ \-\ MA",
"55193682", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55553324", "Cruz\ Alta\ \-\ RS",
"55153207", "Gramadinho\ \-\ SP",
"55143543", "Promissão\ \-\ SP",
"55713642", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55553282", "Lavras\ do\ Sul\ \-\ RS",
"55313850", "Minas\ Gerais",
"5561331", "Brasília\ \-\ DF",
"55833489", "São\ José\ de\ Caiana\ \-\ PB",
"55114009", "São\ Paulo\ \-\ SP",
"55813861", "Petrolina\ \-\ PE",
"55643624", "Itumbiara\ \-\ GO",
"55173275", "Monte\ Aprazível\ \-\ SP",
"55473359", "Botuverá\ \-\ SC",
"55313833", "São\ Gonçalo\ do\ Rio\ Abaixo\ \-\ MG",
"55613621", "Luziânia\ \-\ GO",
"55183586", "Mariápolis\ \-\ SP",
"5514362", "Jaú\ \-\ SP",
"55733624", "Jussari\ \-\ BA",
"55773261", "Itapetinga\ \-\ BA",
"55333262", "Goiabeira\ \-\ MG",
"55633232", "Palmas\ \-\ TO",
"55114230", "Itupeva\ \-\ SP",
"55443626", "Umuarama\ \-\ PR",
"55623534", "Goiânia\ \-\ GO",
"55143311", "Marília\ \-\ SP",
"55643575", "Itumbiara\ \-\ GO",
"55423460", "Teixeira\ Soares\ \-\ PR",
"55313538", "Esmeraldas\ \-\ MG",
"55613568", "Guará\ \-\ DF",
"55353731", "Andradas\ \-\ MG",
"55743627", "Miguel\ Calmon\ \-\ BA",
"55473270", "Jaraguá\ do\ Sul\ \-\ SC",
"55833490", "Bonito\ de\ Santa\ Fé\ \-\ PB",
"55993577", "Parnarama\ \-\ MA",
"55673243", "Dois\ Irmãos\ do\ Buriti\ \-\ MS",
"55143848", "Itatinga\ \-\ SP",
"55483211", "Florianópolis\ \-\ SC",
"5597", "Amazonas",
"55813662", "Palmares\ \-\ PE",
"55533246", "Aceguá\ \-\ RS",
"55513754", "Imigrante\ \-\ RS",
"55863301", "Teresina\ \-\ PI",
"55733575", "Arraial\ d\'Ajuda\ \-\ BA",
"55793455", "São\ Domingos\ \-\ SE",
"55114684", "Juquitiba\ \-\ SP",
"55112864", "São\ Paulo\ \-\ SP",
"55193498", "Nova\ Odessa\ \-\ SP",
"55543365", "Rondinha\ \-\ RS",
"55193584", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55643404", "Itumbiara\ \-\ GO",
"55613401", "Taguatinga\ \-\ DF",
"55413539", "Campo\ Largo\ \-\ PR",
"55743541", "Senhor\ do\ Bonfim\ \-\ BA",
"55963622", "Vitória\ do\ Jari\ \-\ AP",
"55663526", "Porto\ dos\ Gaúchos\ \-\ MT",
"55513649", "Montenegro\ \-\ RS",
"553130", "Minas\ Gerais",
"55513691", "Rio\ Grande\ do\ Sul",
"55753289", "Pedro\ Alexandre\ \-\ BA",
"55453258", "Ramilândia\ \-\ PR",
"55193881", "Valinhos\ \-\ SP",
"55173637", "Guzolândia\ \-\ SP",
"55643522", "Itumbiara\ \-\ GO",
"5521342", "Rio\ de\ Janeiro\ \-\ RJ",
"55143489", "Iacri\ \-\ SP",
"55493431", "Xanxerê\ \-\ SC",
"55633028", "Palmas\ \-\ TO",
"55463524", "Francisco\ Beltrão\ \-\ PR",
"55754141", "Feira\ de\ Santana\ \-\ BA",
"55833543", "Aparecida\ \-\ PB",
"55893587", "Dirceu\ Arcoverde\ \-\ PI",
"55453305", "Cascavel\ \-\ PR",
"55133864", "Jacupiranga\ \-\ SP",
"55173263", "Mirassolândia\ \-\ SP",
"55513706", "Rio\ Grande\ do\ Sul",
"55473377", "Luiz\ Alves\ \-\ SC",
"55373521", "Bom\ Despacho\ \-\ MG",
"55663452", "Novo\ São\ Joaquim\ \-\ MT",
"55193773", "Campinas\ \-\ SP",
"55163176", "Furnas\ Vila\ Residencial\ \-\ SP",
"55663574", "Nova\ Guarita\ \-\ MT",
"55193862", "Mogi\ Mirim\ \-\ SP",
"55513447", "Alvorada\ \-\ RS",
"55913722", "Curuçá\ \-\ PA",
"55823287", "Capela\ \-\ AL",
"55693416", "Ji\-Paraná\ \-\ RO",
"55483527", "Araranguá\ \-\ SC",
"55242484", "Miguel\ Pereira\ \-\ RJ",
"55453352", "Rio\ do\ Salto\ \-\ PR",
"55953623", "Boa\ Vista\ \-\ RR",
"55443572", "Piquirivaí\ \-\ PR",
"55123322", "São\ José\ dos\ Campos\ \-\ SP",
"55183301", "Araçatuba\ \-\ SP",
"55313380", "Minas\ Gerais",
"55663405", "Barra\ do\ Garças\ \-\ MT",
"55773466", "Jacaraci\ \-\ BA",
"55913775", "Santo\ Antônio\ do\ Tauá\ \-\ PA",
"55423635", "Laranjeiras\ do\ Sul\ \-\ PR",
"55643492", "Edéia\ \-\ GO",
"55483953", "Florianópolis\ \-\ SC",
"55473448", "Balneário\ Barra\ do\ Sul\ \-\ SC",
"55873857", "Flores\ \-\ PE",
"55663496", "Alto\ Taquari\ \-\ MT",
"55283553", "Guaçuí\ \-\ ES",
"55323258", "Coronel\ Pacheco\ \-\ MG",
"55883418", "Jaguaruana\ \-\ CE",
"55483641", "Tijucas\ \-\ SC",
"55813681", "Xexéu\ \-\ PE",
"55423259", "Ventania\ \-\ PR",
"55353714", "Poços\ de\ Caldas\ \-\ MG",
"55163025", "Franca\ \-\ SP",
"55443525", "Campo\ Mourão\ \-\ PR",
"55173551", "Ibirá\ \-\ SP",
"55633429", "Muricilândia\ \-\ TO",
"55114027", "Salto\ \-\ SP",
"55643087", "Itumbiara\ \-\ GO",
"55553261", "Restinga\ Seca\ \-\ RS",
"55223866", "São\ José\ de\ Ubá\ \-\ RJ",
"55812119", "Recife\ \-\ PE",
"55513468", "Rio\ Grande\ do\ Sul",
"5531379", "Minas\ Gerais",
"55733251", "Itacaré\ \-\ BA",
"55123653", "Caçapava\ \-\ SP",
"55693641", "Alta\ Floresta\ do\ Oeste\ \-\ RO",
"55623511", "Inhumas\ \-\ GO",
"55383753", "Felixlândia\ \-\ MG",
"55713040", "Camaçari\ \-\ BA",
"55643676", "Cachoeira\ de\ Goiás\ \-\ GO",
"55112684", "São\ Paulo\ \-\ SP",
"55273249", "Paraju\ \-\ ES",
"55843253", "Bom\ Jesus\ \-\ RN",
"55193765", "Campinas\ \-\ SP",
"55623343", "Abadiânia\ \-\ GO",
"55153546", "Buri\ \-\ SP",
"55493236", "Urupema\ \-\ SC",
"55823341", "Maceió\ \-\ AL",
"55114911", "São\ Paulo\ \-\ SP",
"55843230", "Nísia\ Floresta\ \-\ RN",
"55413671", "Quatro\ Barras\ \-\ PR",
"55343813", "Vazante\ \-\ MG",
"55193351", "Araras\ \-\ SP",
"55733676", "Barrolândia\ \-\ BA",
"55483061", "Criciúma\ \-\ SC",
"55443674", "Indianópolis\ \-\ PR",
"55113820", "Guarulhos\ \-\ SP",
"55643688", "Jaupaci\ \-\ GO",
"55653566", "Juína\ \-\ MT",
"55413398", "São\ José\ dos\ Pinhais\ \-\ PR",
"55353536", "Itaú\ de\ Minas\ \-\ MG",
"55433235", "Primeiro\ de\ Maio\ \-\ PR",
"55843337", "Caraúbas\ \-\ RN",
"55652122", "Cáceres\ \-\ MT",
"55423277", "Ortigueira\ \-\ PR",
"5521271", "Niterói\ \-\ RJ",
"55473467", "Joinville\ \-\ SC",
"55114408", "Cajamar\ \-\ SP",
"55443201", "Campo\ Mourão\ \-\ PR",
"55833088", "Campina\ Grande\ \-\ PB",
"55733688", "Piraí\ do\ Norte\ \-\ BA",
"55553376", "Panambi\ \-\ RS",
"55193661", "Espírito\ Santo\ do\ Pinhal\ \-\ SP",
"55313399", "Minas\ Gerais",
"55873879", "Exu\ \-\ PE",
"55554052", "Santa\ Maria\ \-\ RS",
"55933597", "Tabocal\ \-\ PA",
"55833533", "João\ Pessoa\ \-\ PB",
"55633531", "Divinópolis\ do\ Tocantins\ \-\ TO",
"55493441", "Concórdia\ \-\ SC",
"55513255", "Rio\ Grande\ do\ Sul",
"55913752", "Tailândia\ \-\ PA",
"55623642", "Goiânia\ \-\ GO",
"55343848", "Romaria\ \-\ MG",
"55813473", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55643474", "Orizona\ \-\ GO",
"55453322", "Cascavel\ \-\ PR",
"55613471", "Ceilândia\ \-\ DF",
"55473039", "Blumenau\ \-\ SC",
"55192101", "Campinas\ \-\ SP",
"55743531", "Curaçá\ \-\ BA",
"55513639", "São\ Vendelino\ \-\ RS",
"55115851", "São\ Paulo\ \-\ SP",
"55353645", "São\ José\ do\ Alegre\ \-\ MG",
"55473904", "Itapema\ \-\ SC",
"55114658", "Igaratá\ \-\ SP",
"55513788", "Progresso\ \-\ RS",
"55543291", "São\ Marcos\ \-\ RS",
"55814102", "Recife\ \-\ PE",
"55553884", "Dona\ Otília\ \-\ RS",
"55162132", "Ribeirão\ Preto\ \-\ SP",
"551130", "São\ Paulo\ \-\ SP",
"55273422", "Cariacica\ \-\ ES",
"55323228", "Juiz\ de\ Fora\ \-\ MG",
"55112610", "Mogi\ das\ Cruzes\ \-\ SP",
"55283523", "Gironda\ \-\ ES",
"55153003", "Sorocaba\ \-\ SP",
"55913483", "São\ Domingos\ do\ Capim\ \-\ PA",
"55843262", "João\ Câmara\ \-\ RN",
"55453284", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55444003", "Maringá\ \-\ PR",
"55673250", "Corguinho\ \-\ MS",
"55473307", "Jaraguá\ do\ Sul\ \-\ SC",
"55663592", "Brasnorte\ \-\ MT",
"55513776", "Relvado\ \-\ RS",
"55212673", "Duque\ de\ Caxias\ \-\ RJ",
"55443555", "Nice\ \-\ PR",
"55353741", "Botelhos\ \-\ MG",
"55313548", "Minas\ Gerais",
"55353799", "Caldas\ \-\ MG",
"55113191", "São\ Paulo\ \-\ SP",
"55123662", "Campos\ do\ Jordão\ \-\ SP",
"55453375", "Esquina\ Ipiranga\ \-\ PR",
"55633459", "Buriti\ do\ Tocantins\ \-\ TO",
"55153259", "Tatuí\ \-\ SP",
"55173521", "Catanduva\ \-\ SP",
"55123861", "São\ Sebastião\ \-\ SP",
"55373222", "Divinópolis\ \-\ MG",
"55773664", "Paratinga\ \-\ BA",
"55733221", "Ilhéus\ \-\ BA",
"55673047", "Campo\ Grande\ \-\ MS",
"55433711", "Cambé\ \-\ PR",
"55843478", "São\ José\ do\ Seridó\ \-\ RN",
"55443133", "Mandaguari\ \-\ PR",
"55813032", "Recife\ \-\ PE",
"55123146", "Lavrinhas\ \-\ SP",
"55383723", "Inimutaba\ \-\ MG",
"55824009", "Maceió\ \-\ AL",
"55823314", "Maceió\ \-\ AL",
"55283562", "Bom\ Jesus\ do\ Norte\ \-\ ES",
"55213748", "Belford\ Roxo\ \-\ RJ",
"55123042", "São\ José\ dos\ Campos\ \-\ SP",
"55843223", "Natal\ \-\ RN",
"55853113", "Aquiraz\ \-\ CE",
"55813136", "Caruaru\ \-\ PE",
"55143533", "Lins\ \-\ SP",
"55713632", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55313843", "Antônio\ Dias\ \-\ MG",
"55193321", "Araras\ \-\ SP",
"55212394", "Rio\ de\ Janeiro\ \-\ RJ",
"55452102", "Foz\ do\ Iguaçu\ \-\ PR",
"55114012", "Bom\ Jesus\ dos\ Perdões\ \-\ SP",
"55793362", "Cumbe\ \-\ SE",
"55323032", "Juiz\ de\ Fora\ \-\ MG",
"55314009", "Belo\ Horizonte\ \-\ MG",
"55222733", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55212665", "Queimados\ \-\ RJ",
"55613702", "Brasília\ \-\ DF",
"55333628", "Umburatiba\ \-\ MG",
"55633477", "Itaguatins\ \-\ TO",
"55613382", "Guará\ \-\ DF",
"55153277", "Tapiraí\ \-\ SP",
"5555321", "Santa\ Maria\ \-\ RS",
"55323465", "Pirapetinga\ \-\ MG",
"55373275", "São\ José\ da\ Varginha\ \-\ MG",
"55543452", "Bento\ Gonçalves\ \-\ RS",
"55543526", "Três\ Arroios\ \-\ RS",
"55883443", "Quixeré\ \-\ CE",
"55193853", "Pedreira\ \-\ SP",
"55353432", "Córrego\ do\ Bom\ Jesus\ \-\ MG",
"55163345", "Dourado\ \-\ SP",
"55373384", "Itaguara\ \-\ MG",
"55923215", "Manaus\ \-\ AM",
"55553355", "Caibaté\ \-\ RS",
"55323693", "Barbacena\ \-\ MG",
"55383253", "Engenheiro\ Navarro\ \-\ MG",
"55222101", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55173292", "Paulo\ de\ Faria\ \-\ SP",
"55713636", "Vera\ Cruz\ \-\ BA",
"55493348", "União\ do\ Oeste\ \-\ SC",
"55853328", "Mulungu\ \-\ CE",
"55423542", "Mallet\ \-\ PR",
"5531329", "Minas\ Gerais",
"55793271", "Divina\ Pastora\ \-\ SE",
"55115090", "São\ Paulo\ \-\ SP",
"55513568", "São\ Leopoldo\ \-\ RS",
"55433244", "Prado\ Ferreira\ \-\ PR",
"55114016", "Jarinu\ \-\ SP",
"55273364", "Guarapari\ \-\ ES",
"55513401", "Guaíba\ \-\ RS",
"55373226", "Nova\ Serrana\ \-\ MG",
"5519373", "Campinas\ \-\ SP",
"55513822", "Gravataí\ \-\ RS",
"55543522", "Erechim\ \-\ RS",
"5554302", "Caxias\ do\ Sul\ \-\ RS",
"55693427", "Nova\ Colina\ \-\ RO",
"55343269", "Ituiutaba\ \-\ MG",
"55913637", "Melgaço\ \-\ PA",
"55643694", "Palmelo\ \-\ GO",
"55413384", "São\ José\ dos\ Pinhais\ \-\ PR",
"55813693", "Xexéu\ \-\ PE",
"55353436", "Toledo\ \-\ MG",
"55193608", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55122124", "Lorena\ \-\ SP",
"55773453", "Brumado\ \-\ BA",
"55793366", "Brejo\ Grande\ \-\ SE",
"55643655", "Paranaiguara\ \-\ GO",
"55733239", "Uruçuca\ \-\ BA",
"55613386", "Núcleo\ Bandeirante\ \-\ DF",
"55753327", "Lajedinho\ \-\ BA",
"55114461", "Santo\ André\ \-\ SP",
"55113359", "São\ Paulo\ \-\ SP",
"55733694", "São\ José\ da\ Vitória\ \-\ BA",
"55773430", "Caatiba\ \-\ BA",
"55543456", "Santa\ Tereza\ \-\ RS",
"55533028", "Pelotas\ \-\ RS",
"55313039", "Timóteo\ \-\ MG",
"55453326", "Cascavel\ \-\ PR",
"55333293", "São\ José\ da\ Safira\ \-\ MG",
"55423231", "Carambeí\ \-\ PR",
"55513547", "Rolante\ \-\ RS",
"55843371", "Itaú\ \-\ RN",
"55213620", "Niterói\ \-\ RJ",
"55183368", "Lutécia\ \-\ SP",
"55493367", "Sul\ Brasil\ \-\ SC",
"55813758", "Barra\ de\ Guabiraba\ \-\ PE",
"55623389", "Goianésia\ \-\ GO",
"55513725", "Cerro\ Branco\ \-\ RS",
"55213213", "Rio\ de\ Janeiro\ \-\ RJ",
"55423644", "Santa\ Maria\ do\ Oeste\ \-\ PR",
"55223321", "Rio\ das\ Ostras\ \-\ RJ",
"55443340", "Alto\ Alegre\ \-\ PR",
"55483245", "Santo\ Amaro\ da\ Imperatriz\ \-\ SC",
"55513719", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55913756", "Moju\ \-\ PA",
"55673902", "Dourados\ \-\ MS",
"55693516", "Ariquemes\ \-\ RO",
"55183281", "Presidente\ Epitácio\ \-\ SP",
"55923542", "Maués\ \-\ AM",
"55743529", "Andorinha\ \-\ BA",
"55513621", "Capão\ Novo\ \-\ RS",
"55513772", "Arvorezinha\ \-\ RS",
"55473021", "Balneário\ Camboriú\ \-\ SC",
"55663596", "Paranorte\ \-\ MT",
"55112753", "São\ Paulo\ \-\ SP",
"55313956", "Contagem\ \-\ MG",
"55883518", "Solonópole\ \-\ CE",
"55163838", "Ituverava\ \-\ SP",
"55183658", "Clementina\ \-\ SP",
"55323374", "Rio\ das\ Mortes\ \-\ MG",
"55123666", "Santo\ Antônio\ do\ Pinhal\ \-\ SP",
"55493657", "Santa\ Terezinha\ do\ Progresso\ \-\ SC",
"55113377", "São\ Paulo\ \-\ SP",
"5564309", "Itumbiara\ \-\ GO",
"55463555", "Planalto\ \-\ PR",
"55223853", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55913275", "Ananindeua\ \-\ PA",
"55863262", "Altos\ \-\ PI",
"55683612", "Sena\ Madureira\ \-\ AC",
"55443247", "Santa\ Fé\ \-\ PR",
"55833345", "Caturité\ \-\ PB",
"55653927", "Várzea\ Grande\ \-\ MT",
"55313121", "Igarapé\ \-\ MG",
"55323285", "Chiador\ \-\ MG",
"55933735", "Monte\ Dourado\ \-\ PA",
"55443425", "Loanda\ \-\ PR",
"55413637", "Bugre\ \-\ PR",
"55843266", "Pureza\ \-\ RN",
"55353214", "Varginha\ \-\ MG",
"55853358", "Tururu\ \-\ CE",
"55493232", "Bom\ Jardim\ da\ Serra\ \-\ SC",
"55543283", "Caxias\ do\ Sul\ \-\ RS",
"55153542", "Capão\ Bonito\ \-\ SP",
"55383223", "Montes\ Claros\ \-\ MG",
"55713216", "Simões\ Filho\ \-\ BA",
"55863253", "Juazeiro\ do\ Piauí\ \-\ PI",
"55733672", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55223862", "Portela\ \-\ RJ",
"55423446", "Prudentópolis\ \-\ PR",
"5511441", "Atibaia\ \-\ SP",
"55993541", "Balsas\ \-\ MA",
"55643672", "Mineiros\ \-\ GO",
"55753667", "Nossa\ Senhora\ da\ Ajuda\ \-\ BA",
"55873816", "Buíque\ \-\ PE",
"55143433", "Marília\ \-\ SP",
"55733625", "Mascote\ \-\ BA",
"55113183", "Itatiba\ \-\ SP",
"55313890", "Minas\ Gerais",
"55813915", "Aripibu\ \-\ PE",
"55623535", "Santo\ Antônio\ de\ Goiás\ \-\ GO",
"55543552", "Cacique\ Doble\ \-\ RS",
"55553372", "Santa\ Bárbara\ do\ Sul\ \-\ RS",
"5524224", "Petrópolis\ \-\ RJ",
"55473399", "Timbó\ \-\ SC",
"55473341", "Itajaí\ \-\ SC",
"55183911", "Eneida\ \-\ SP",
"55863582", "São\ Raimundo\ Nonato\ \-\ PI",
"55353532", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55883543", "Aurora\ \-\ CE",
"55173274", "Tanabi\ \-\ SP",
"55913449", "São\ João\ de\ Pirabas\ \-\ PA",
"55683028", "Rio\ Branco\ \-\ AC",
"55222667", "Araruama\ \-\ RJ",
"55993627", "Bacabal\ \-\ MA",
"55313889", "Belo\ Horizonte\ \-\ MG",
"55833450", "Tavares\ \-\ PB",
"55693412", "Alvorada\ do\ Oeste\ \-\ RO",
"55543364", "Ronda\ Alta\ \-\ RS",
"55193585", "Porto\ Ferreira\ \-\ SP",
"55643405", "Piracanjuba\ \-\ GO",
"55213633", "Guapimirim\ \-\ RJ",
"55893570", "Baixa\ Grande\ do\ Ribeiro\ \-\ PI",
"55463572", "Cruzeiro\ do\ Iguaçu\ \-\ PR",
"55113438", "Santo\ André\ \-\ SP",
"55443576", "Águas\ de\ Jurema\ \-\ PR",
"55833433", "Coremas\ \-\ PB",
"55312112", "Belo\ Horizonte\ \-\ MG",
"55513755", "Muçum\ \-\ RS",
"55773462", "Caetanos\ \-\ BA",
"55633431", "Angico\ \-\ TO",
"55813728", "Bezerros\ \-\ PE",
"55493541", "Campos\ Novos\ \-\ SC",
"55853048", "Fortaleza\ \-\ CE",
"55333508", "Governador\ Valadares\ \-\ MG",
"55753648", "Dom\ Macedo\ Costa\ \-\ BA",
"55493313", "Chapecó\ \-\ SC",
"55513288", "Rio\ Grande\ do\ Sul",
"55193866", "Conchal\ \-\ SP",
"55213267", "Rio\ de\ Janeiro\ \-\ RJ",
"55163172", "Igarapava\ \-\ SP",
"55753312", "Cruz\ das\ Almas\ \-\ BA",
"5565364", "Cuiabá\ \-\ MT",
"55983479", "Tutóia\ \-\ MA",
"55193458", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55913726", "Ulianópolis\ \-\ PA",
"55114781", "Embu\ das\ Artes\ \-\ SP",
"55323728", "Muriaé\ \-\ MG",
"55513651", "São\ Jerônimo\ \-\ RS",
"55743559", "Pindobaçu\ \-\ BA",
"55443588", "Vidigal\ \-\ PR",
"55463525", "Marmeleiro\ \-\ PR",
"55143025", "Lins\ \-\ SP",
"55115839", "São\ Paulo\ \-\ SP",
"55493627", "Paraíso\ \-\ SC",
"55453304", "Cascavel\ \-\ PR",
"55323573", "Piraúba\ \-\ MG",
"5531380", "Minas\ Gerais",
"55643496", "Aloândia\ \-\ GO",
"55173421", "Votuporanga\ \-\ SP",
"55353241", "São\ Gonçalo\ do\ Sapucaí\ \-\ MG",
"55443455", "Santa\ Mônica\ \-\ PR",
"55353299", "Alfenas\ \-\ MG",
"55683232", "Senador\ Guiomard\ \-\ AC",
"55313151", "Sete\ Lagoas\ \-\ MG",
"55173802", "Paulo\ de\ Faria\ \-\ SP",
"55313448", "Minas\ Gerais",
"55443237", "Santa\ Zélia\ \-\ PR",
"55114762", "Mogi\ das\ Cruzes\ \-\ SP",
"55533242", "Bagé\ \-\ RS",
"55933527", "Santarém\ \-\ PA",
"55114873", "São\ Paulo\ \-\ SP",
"55333753", "Medina\ \-\ MG",
"55323356", "Ritápolis\ \-\ MG",
"55242485", "Paty\ do\ Alferes\ \-\ RJ",
"55843301", "Natal\ \-\ RN",
"55443663", "Douradina\ \-\ PR",
"55674007", "Campo\ Grande\ \-\ MS",
"5511507", "São\ Paulo\ \-\ SP",
"55483369", "Florianópolis\ \-\ SC",
"55623093", "Goiânia\ \-\ GO",
"55353857", "Campo\ do\ Meio\ \-\ MG",
"55663575", "Peixoto\ de\ Azevedo\ \-\ MT",
"55643452", "Rio\ Quente\ \-\ GO",
"55673919", "Três\ Lagoas\ \-\ MS",
"55513382", "Rio\ Grande\ do\ Sul",
"55983182", "São\ Luís\ \-\ MA",
"55113307", "São\ Paulo\ \-\ SP",
"55513702", "Rio\ Grande\ do\ Sul",
"55413048", "Araucária\ \-\ PR",
"55623636", "Goiânia\ \-\ GO",
"55353715", "Poços\ de\ Caldas\ \-\ MG",
"55163489", "Serrana\ \-\ SP",
"55163024", "Ribeirão\ Preto\ \-\ SP",
"553131", "Minas\ Gerais",
"55443524", "Campo\ Mourão\ \-\ PR",
"55313377", "Belo\ Horizonte\ \-\ MG",
"55733526", "Jequié\ \-\ BA",
"55773481", "Bom\ Jesus\ da\ Lapa\ \-\ BA",
"55753218", "Salgadália\ \-\ BA",
"55193936", "Indaiatuba\ \-\ SP",
"55663522", "São\ Félix\ do\ Araguaia\ \-\ MT",
"55353729", "Poços\ de\ Caldas\ \-\ MG",
"55513537", "Porto\ Alegre\ \-\ RS",
"55313049", "Contagem\ \-\ MG",
"55483659", "Pedras\ Grandes\ \-\ SC",
"55913774", "São\ Francisco\ do\ Pará\ \-\ PA",
"55423634", "Campina\ do\ Simão\ \-\ PR",
"55713297", "Salvador\ \-\ BA",
"55643526", "Itumbiara\ \-\ GO",
"55823270", "Maribondo\ \-\ AL",
"55733249", "Barro\ Preto\ \-\ BA",
"55733291", "Teixeira\ de\ Freitas\ \-\ BA",
"55242107", "Volta\ Redonda\ \-\ RJ",
"55983369", "Santo\ Amaro\ do\ Maranhão\ \-\ MA",
"55413668", "Pinhais\ \-\ PR",
"55443675", "Cidade\ Gaúcha\ \-\ PR",
"55643417", "Morrinhos\ \-\ GO",
"55663563", "Paranaíta\ \-\ MT",
"55773440", "Piripá\ \-\ BA",
"55553423", "Quaraí\ \-\ RS",
"55843293", "Serra\ Caiada\ \-\ RN",
"55112685", "São\ Paulo\ \-\ SP",
"55273251", "Serra\ \-\ ES",
"55433527", "Jacarezinho\ \-\ PR",
"55143335", "Ourinhos\ \-\ SP",
"55613639", "Planaltina\ \-\ GO",
"55513471", "Cachoeirinha\ \-\ RS",
"55613308", "Planaltina\ \-\ DF",
"55553278", "Pinhal\ Grande\ \-\ RS",
"55693235", "Porto\ Velho\ \-\ RO",
"5511418", "Carapicuíba\ \-\ SP",
"55353446", "Albertina\ \-\ MG",
"55183582", "Parapuã\ \-\ SP",
"55163311", "Araraquara\ \-\ SP",
"55193678", "Canoas\ \-\ SP",
"55413358", "São\ José\ dos\ Pinhais\ \-\ PR",
"55143269", "Lençóis\ Paulista\ \-\ SP",
"55943353", "Vila\ Cruzeiro\ do\ Sul\ \-\ PA",
"55443622", "Umuarama\ \-\ PR",
"5516362", "Ribeirão\ Preto\ \-\ SP",
"55453565", "São\ Miguel\ do\ Iguaçu\ \-\ PR",
"55113413", "Itu\ \-\ SP",
"55333266", "Quatituba\ \-\ MG",
"55114109", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55813046", "Caruaru\ \-\ PE",
"55123132", "Guaratinguetá\ \-\ SP",
"55114578", "Mauá\ \-\ SP",
"55483086", "Palhoça\ \-\ SC",
"55173483", "Nova\ Luzitânia\ \-\ SP",
"55553286", "Santa\ Maria\ \-\ RS",
"55713646", "Lauro\ de\ Freitas\ \-\ BA",
"55493338", "Cunhataí\ \-\ SC",
"55753469", "Cícero\ Dantas\ \-\ BA",
"55112301", "São\ Paulo\ \-\ SP",
"5582", "Alagoas",
"55112781", "São\ Paulo\ \-\ SP",
"55623978", "Anápolis\ \-\ GO",
"55913521", "Paragominas\ \-\ PA",
"55443043", "Paiçandu\ \-\ PR",
"55423532", "São\ Mateus\ do\ Sul\ \-\ PR",
"55353644", "Piranguinho\ \-\ MG",
"55794003", "Aracaju\ \-\ SE",
"55493459", "Coronel\ Martins\ \-\ SC",
"55493198", "Maravilha\ \-\ SC",
"55933557", "Faro\ \-\ PA",
"55433579", "Salto\ do\ Itararé\ \-\ PR",
"55173819", "Poloni\ \-\ SP",
"55654104", "Várzea\ Grande\ \-\ MT",
"55513933", "Gravataí\ \-\ RS",
"55643475", "Três\ Ranchos\ \-\ GO",
"55423560", "Fluviópolis\ \-\ PR",
"55973331", "Lábrea\ \-\ AM",
"55222789", "São\ Francisco\ de\ Paula\ \-\ RJ",
"55683242", "Rio\ Branco\ \-\ AC",
"55313438", "Minas\ Gerais",
"55613468", "Brasília\ \-\ DF",
"55243357", "Resende\ \-\ RJ",
"55773673", "Oliveira\ dos\ Brejinhos\ \-\ BA",
"55333723", "Jacinto\ \-\ MG",
"55653261", "Araputanga\ \-\ MT",
"55193029", "Campinas\ \-\ SP",
"55643504", "Americano\ do\ Brasil\ \-\ GO",
"55143106", "Bauru\ \-\ SP",
"55863281", "Milton\ Brandão\ \-\ PI",
"55193484", "Nova\ Odessa\ \-\ SP",
"55613501", "Planaltina\ \-\ DF",
"55653388", "Várzea\ Grande\ \-\ MT",
"55312586", "Contagem\ \-\ MG",
"55543251", "Cambará\ do\ Sul\ \-\ RS",
"55544062", "Caxias\ do\ Sul\ \-\ RS",
"55623877", "Goiânia\ \-\ GO",
"55753638", "Governador\ Mangabeira\ \-\ BA",
"55733556", "Lajedo\ do\ Tabocal\ \-\ BA",
"55163518", "Cravinhos\ \-\ SP",
"55443018", "Cianorte\ \-\ PR",
"55443554", "Assis\ Chateaubriand\ \-\ PR",
"55713444", "Salvador\ \-\ BA",
"55412108", "Curitiba\ \-\ PR",
"55963271", "Mazagão\ \-\ AP",
"55942103", "Marabá\ \-\ PA",
"55312109", "Ipatinga\ \-\ MG",
"55654052", "Cuiabá\ \-\ MT",
"55213643", "Teresópolis\ \-\ RJ",
"55373421", "Luz\ \-\ MG",
"55653376", "Nobres\ \-\ MT",
"55443323", "Colorado\ \-\ PR",
"55663552", "Guarantã\ do\ Norte\ \-\ MT",
"55453285", "Subsede\ São\ Francisco\ \-\ PR",
"55433512", "Arapoti\ \-\ PR",
"55143589", "Reginópolis\ \-\ SP",
"55493531", "Videira\ \-\ SC",
"55153241", "Ibiúna\ \-\ SP",
"55643556", "Paraúna\ \-\ GO",
"55113448", "Osasco\ \-\ SP",
"55183262", "Presidente\ Bernardes\ \-\ SP",
"55113151", "São\ Paulo\ \-\ SP",
"55833443", "Brejo\ do\ Cruz\ \-\ PB",
"55893487", "Paulistana\ \-\ PI",
"55383561", "João\ Pinheiro\ \-\ MG",
"55553430", "São\ Borja\ \-\ RS",
"55883533", "Campos\ Sales\ \-\ CE",
"55913854", "Maracanã\ \-\ PA",
"55183223", "Presidente\ Prudente\ \-\ SP",
"55863347", "Batalha\ \-\ PI",
"55853384", "Maracanaú\ \-\ CE",
"5516336", "São\ Carlos\ \-\ SP",
"55163947", "Sertãozinho\ \-\ SP",
"55433557", "Arapoti\ \-\ PR",
"55112803", "Carapicuíba\ \-\ SP",
"55663517", "Sinop\ \-\ MT",
"55623545", "Goiânia\ \-\ GO",
"55673289", "Rochedo\ \-\ MS",
"55643602", "Rio\ Verde\ \-\ GO",
"55173256", "Santa\ Luzia\ \-\ SP",
"55114482", "Mairiporã\ \-\ SP",
"55243379", "Angra\ dos\ Reis\ \-\ RJ",
"55123878", "São\ José\ dos\ Campos\ \-\ SP",
"5524223", "Petrópolis\ \-\ RJ",
"55943323", "Marabá\ \-\ PA",
"55613272", "Brasília\ \-\ DF",
"55553302", "Santa\ Maria\ \-\ RS",
"55933512", "Santarém\ \-\ PA",
"55163344", "Ribeirão\ Bonito\ \-\ SP",
"55423436", "Imbituva\ \-\ PR",
"55963424", "Pracuúba\ \-\ AP",
"55963118", "Macapá\ \-\ AP",
"55993531", "Estreito\ \-\ MA",
"55443652", "Iporã\ \-\ PR",
"55353064", "Poços\ de\ Caldas\ \-\ MG",
"55863240", "Cabeceiras\ do\ Piauí\ \-\ PI",
"55153532", "Itararé\ \-\ SP",
"55493242", "São\ José\ do\ Cerrito\ \-\ SC",
"55323464", "Estrela\ Dalva\ \-\ MG",
"55623434", "Goiânia\ \-\ GO",
"55373274", "Papagaios\ \-\ MG",
"55513683", "Rio\ Grande\ do\ Sul",
"55192137", "Campinas\ \-\ SP",
"55442103", "Maringá\ \-\ PR",
"55753243", "Conceição\ do\ Jacuípe\ \-\ BA",
"55193893", "Pedreira\ \-\ SP",
"55453036", "Cascavel\ \-\ PR",
"55212664", "Japeri\ \-\ RJ",
"55313329", "Minas\ Gerais",
"55713521", "Salvador\ \-\ BA",
"55353225", "Carmo\ da\ Cachoeira\ \-\ MG",
"55433526", "Santana\ do\ Itararé\ \-\ PR",
"55453218", "Cascavel\ \-\ PR",
"5583323", "João\ Pessoa\ \-\ PB",
"55513460", "Esteio\ \-\ RS",
"55633353", "Alvorada\ \-\ TO",
"55614020", "Brasília\ \-\ DF",
"55463313", "Pato\ Branco\ \-\ PR",
"55173445", "Américo\ de\ Campos\ \-\ SP",
"55273182", "Vitória\ \-\ ES",
"55833351", "Monteiro\ \-\ PB",
"55323379", "São\ João\ Del\ Rei\ \-\ MG",
"55242106", "Barra\ Mansa\ \-\ RJ",
"55173831", "Nova\ Castilho\ \-\ SP",
"55484062", "Florianópolis\ \-\ SC",
"55633524", "Porto\ Alegre\ do\ Tocantins\ \-\ TO",
"55843238", "Parnamirim\ \-\ RN",
"55643416", "Morrinhos\ \-\ GO",
"55663412", "Juscimeira\ \-\ MT",
"55373544", "Cedro\ do\ Abaeté\ \-\ MG",
"55433452", "Borrazópolis\ \-\ PR",
"55493572", "Matos\ Costa\ \-\ SC",
"55813648", "João\ Alfredo\ \-\ PE",
"55153202", "Sorocaba\ \-\ SP",
"55713647", "Catu\ \-\ BA",
"55633402", "Araguaína\ \-\ TO",
"55313034", "Contagem\ \-\ MG",
"55813379", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55423649", "Guará\ \-\ PR",
"55663479", "Novo\ São\ Joaquim\ \-\ MT",
"55483251", "Florianópolis\ \-\ SC",
"55853181", "Fortaleza\ \-\ CE",
"55643680", "Nazário\ \-\ GO",
"55623384", "Taquaral\ de\ Goiás\ \-\ GO",
"55433303", "Arapongas\ \-\ PR",
"55493525", "Catanduvas\ \-\ SC",
"55112643", "São\ Paulo\ \-\ SP",
"55653329", "Tangará\ da\ Serra\ \-\ MT",
"55513714", "Lajeado\ \-\ RS",
"55413908", "Curitiba\ \-\ PR",
"55333267", "Aimorés\ \-\ MG",
"55213508", "Itaboraí\ \-\ RJ",
"55323312", "Juiz\ de\ Fora\ \-\ MG",
"55733680", "Ilhéus\ \-\ BA",
"55183748", "Ilha\ Solteira\ \-\ SP",
"55373435", "Vargem\ Bonita\ \-\ MG",
"55673465", "Jateí\ \-\ MS",
"55743622", "Jacobina\ \-\ BA",
"55833099", "Campina\ Grande\ \-\ PB",
"55343264", "Gurinhatã\ \-\ MG",
"55113395", "Jundiaí\ \-\ SP",
"55313261", "Belo\ Horizonte\ \-\ MG",
"55114174", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55853877", "Fortaleza\ \-\ CE",
"55473319", "Navegantes\ \-\ SC",
"55993572", "Buriti\ Bravo\ \-\ MA",
"5511568", "São\ Paulo\ \-\ SP",
"55353856", "Guapé\ \-\ MG",
"55183991", "Mirante\ do\ Paranapanema\ \-\ SP",
"55843643", "Parnamirim\ \-\ RN",
"55643699", "Buriti\ de\ Goiás\ \-\ GO",
"55643641", "Santa\ Helena\ de\ Goiás\ \-\ GO",
"55863122", "Teresina\ \-\ PI",
"55114620", "Osasco\ \-\ SP",
"55213803", "Niterói\ \-\ RJ",
"55313388", "Belo\ Horizonte\ \-\ MG",
"55443236", "Floresta\ \-\ PR",
"55733234", "Ilhéus\ \-\ BA",
"55973481", "Eirunepé\ \-\ AM",
"55693251", "Vista\ Alegre\ do\ Abunã\ \-\ RO",
"55933526", "Alenquer\ \-\ PA",
"5511364", "São\ Paulo\ \-\ SP",
"55153571", "Riversul\ \-\ SP",
"55913411", "Capanema\ \-\ PA",
"55143765", "Águas\ de\ Santa\ Bárbara\ \-\ SP",
"55713205", "Salvador\ \-\ BA",
"55493674", "Mondaí\ \-\ SC",
"55883686", "Catunda\ \-\ CE",
"55323357", "Coronel\ Xavier\ Chaves\ \-\ MG",
"55273235", "Vitória\ \-\ ES",
"55143351", "Piraju\ \-\ SP",
"55463232", "Coronel\ Vivida\ \-\ PR",
"5514323", "Bauru\ \-\ SP",
"55113354", "São\ Paulo\ \-\ SP",
"55883410", "Itaiçaba\ \-\ CE",
"55323250", "Juiz\ de\ Fora\ \-\ MG",
"55383690", "Montes\ Claros\ \-\ MG",
"55193937", "Jaguariúna\ \-\ SP",
"55513536", "Conceição\ \-\ RS",
"55553513", "Santa\ Rosa\ \-\ RS",
"55222565", "Bom\ Jardim\ \-\ RJ",
"55173632", "Jales\ \-\ SP",
"55242443", "Barra\ do\ Piraí\ \-\ RJ",
"55433249", "Cambé\ \-\ PR",
"55673473", "Eldorado\ \-\ MS",
"55273369", "Vila\ Velha\ \-\ ES",
"55283538", "Atilio\ Vivacqua\ \-\ ES",
"55694062", "Porto\ Velho\ \-\ RO",
"55823261", "Rio\ Largo\ \-\ AL",
"55713296", "Simões\ Filho\ \-\ BA",
"55743675", "São\ José\ do\ Jacuípe\ \-\ BA",
"55893582", "São\ Raimundo\ Nonato\ \-\ PI",
"55273744", "Governador\ Lindenberg\ \-\ ES",
"55473372", "Jaraguá\ do\ Sul\ \-\ SC",
"55623637", "Goiânia\ \-\ GO",
"55433417", "Ribeirão\ Bonito\ \-\ PR",
"55733527", "Jequié\ \-\ BA",
"55313376", "Belo\ Horizonte\ \-\ MG",
"55443441", "Terra\ Rica\ \-\ PR",
"55433556", "Abatiá\ \-\ PR",
"55373343", "Camacho\ \-\ MG",
"55163114", "Araraquara\ \-\ SP",
"55613879", "Brasília\ \-\ DF",
"55173257", "Baguaçu\ \-\ SP",
"5561210", "Brasília\ \-\ DF",
"55833321", "Campina\ Grande\ \-\ PB",
"55643512", "Rio\ Quente\ \-\ GO",
"5521341", "Rio\ de\ Janeiro\ \-\ RJ",
"55923571", "Urucará\ \-\ AM",
"55633554", "Taquarussu\ do\ Porto\ \-\ TO",
"55163273", "Itápolis\ \-\ SP",
"55143014", "Bauru\ \-\ SP",
"55693474", "Castanheiras\ \-\ RO",
"55543235", "Campestre\ da\ Serra\ \-\ RS",
"55863346", "São\ José\ do\ Divino\ \-\ PI",
"55533201", "Rio\ Grande\ \-\ RS",
"5565", "Mato\ Grosso",
"55313581", "Nova\ Lima\ \-\ MG",
"55513645", "São\ Pedro\ da\ Serra\ \-\ RS",
"55153378", "Pilar\ do\ Sul\ \-\ SP",
"55843618", "Natal\ \-\ RN",
"55353294", "Alterosa\ \-\ MG",
"55373511", "Divinópolis\ \-\ MG",
"55163946", "Sertãozinho\ \-\ SP",
"55753285", "Rodelas\ \-\ BA",
"55733512", "Eunápolis\ \-\ BA",
"55473045", "Itajaí\ \-\ SC",
"55333213", "Governador\ Valadares\ \-\ MG",
"5511255", "São\ Paulo\ \-\ SP",
"55612323", "Brasília\ \-\ DF",
"55222758", "São\ Fidélis\ \-\ RJ",
"55413535", "Curitiba\ \-\ PR",
"55313884", "Minas\ Gerais",
"55543369", "Barra\ Funda\ \-\ RS",
"55793459", "Pedra\ Mole\ \-\ SE",
"55212787", "Duque\ de\ Caxias\ \-\ RJ",
"55793198", "Aracaju\ \-\ SE",
"55453037", "Cascavel\ \-\ PR",
"55553548", "Cândido\ Godói\ \-\ RS",
"55513741", "Venâncio\ Aires\ \-\ RS",
"55113135", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55433475", "Jardim\ Alegre\ \-\ PR",
"55493555", "Capinzal\ \-\ SC",
"55623583", "Goiânia\ \-\ GO",
"55983474", "Duque\ Bacelar\ \-\ MA",
"55643579", "Itumbiara\ \-\ GO",
"55133342", "Guarujá\ \-\ SP",
"55832101", "Campina\ Grande\ \-\ PB",
"55833558", "Cachoeira\ dos\ Índios\ \-\ PB",
"55743652", "Ibititá\ \-\ BA",
"5561332", "Brasília\ \-\ DF",
"55163265", "Tapinas\ \-\ SP",
"55673681", "Terenos\ \-\ MS",
"55643614", "Santa\ Helena\ de\ Goiás\ \-\ GO",
"55813613", "Limoeiro\ \-\ PE",
"55473394", "Indaial\ \-\ SC",
"55353826", "Lavras\ \-\ MG",
"55473355", "Brusque\ \-\ SC",
"55913444", "Mãe\ do\ Rio\ \-\ PA",
"55173279", "Olímpia\ \-\ SP",
"55684003", "Rio\ Branco\ \-\ AC",
"55513780", "Rio\ Grande\ do\ Sul",
"55453243", "Nova\ Aurora\ \-\ PR",
"55243356", "Pinheiral\ \-\ RJ",
"55114005", "São\ Paulo\ \-\ SP",
"55833485", "Santana\ dos\ Garrotes\ \-\ PB",
"55115477", "Mogi\ das\ Cruzes\ \-\ SP",
"55143321", "Bauru\ \-\ SP",
"55223094", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55993555", "Pastos\ Bons\ \-\ MA",
"55753693", "Pintadas\ \-\ BA",
"55623449", "Guarani\ de\ Goiás\ \-\ GO",
"55433463", "Godoy\ Moreira\ \-\ PR",
"55112618", "São\ Paulo\ \-\ SP",
"55484053", "Criciúma\ \-\ SC",
"5531321", "Belo\ Horizonte\ \-\ MG",
"55813101", "Caruaru\ \-\ PE",
"55112342", "São\ Paulo\ \-\ SP",
"55114096", "São\ Paulo\ \-\ SP",
"55513065", "Novo\ Hamburgo\ \-\ RS",
"55333332", "Manhuaçu\ \-\ MG",
"55633362", "Dois\ Irmãos\ do\ Tocantins\ \-\ TO",
"55313540", "Minas\ Gerais",
"55663427", "Rondonópolis\ \-\ MT",
"55213781", "Itaguaí\ \-\ RJ",
"55673258", "Taunay\ \-\ MS",
"55553314", "Santo\ Ângelo\ \-\ RS",
"55553567", "Campina\ das\ Missões\ \-\ RS",
"55273711", "Colatina\ \-\ ES",
"55513432", "Gravataí\ \-\ RS",
"55452031", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55313395", "Contagem\ \-\ MG",
"55873875", "Cabrobó\ \-\ PE",
"55313523", "Sítio\ Novo\ \-\ MG",
"55333238", "São\ Geraldo\ da\ Piedade\ \-\ MG",
"55143264", "Lençóis\ Paulista\ \-\ SP",
"55633696", "Novo\ Jardim\ \-\ TO",
"55983654", "Santa\ Luzia\ \-\ MA",
"55115612", "São\ Paulo\ \-\ SP",
"55543412", "Farroupilha\ \-\ RS",
"55553331", "Ijuí\ \-\ RS",
"55963198", "Macapá\ \-\ AP",
"55114104", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55513546", "Três\ Coroas\ \-\ RS",
"55833383", "Soledade\ \-\ PB",
"55633381", "Conceição\ do\ Tocantins\ \-\ TO",
"55353571", "Muzambinho\ \-\ MG",
"55473453", "Joinville\ \-\ SC",
"55774009", "Vitória\ da\ Conquista\ \-\ BA",
"55343351", "Sacramento\ \-\ MG",
"55213762", "Nilópolis\ \-\ RJ",
"55493366", "Pinhalzinho\ \-\ SC",
"55283548", "Irupi\ \-\ ES",
"55242433", "Barra\ do\ Piraí\ \-\ RJ",
"55173642", "Vitória\ Brasil\ \-\ SP",
"55193813", "Itapira\ \-\ SP",
"55812129", "Recife\ \-\ PE",
"55814107", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55162137", "Ribeirão\ Preto\ \-\ SP",
"55733244", "Itagibá\ \-\ BA",
"55913829", "Tomé\-Açú\ \-\ PA",
"55443246", "Maringá\ \-\ PR",
"55463242", "Chopinzinho\ \-\ PR",
"55693654", "São\ Domingos\ \-\ RO",
"55823523", "Limoeiro\ de\ Anadia\ \-\ AL",
"55413636", "Balsa\ Nova\ \-\ PR",
"55193769", "Campinas\ \-\ SP",
"55273245", "Serra\ \-\ ES",
"55793348", "Japoatã\ \-\ SE",
"55843267", "Ielmo\ Marinho\ \-\ RN",
"55873822", "Arcoverde\ \-\ PE",
"55613299", "Brasília\ \-\ DF",
"55613241", "Olinda\ \-\ PE",
"55663597", "Nova\ Monte\ Verde\ \-\ MT",
"55483283", "Palhoça\ \-\ SC",
"55993118", "Timon\ \-\ MA",
"55643631", "Jataí\ \-\ GO",
"55343661", "Araxá\ \-\ MG",
"55114052", "São\ Paulo\ \-\ SP",
"55343823", "Patos\ de\ Minas\ \-\ MG",
"55493656", "Saltinho\ \-\ SC",
"55613634", "Padre\ Bernardo\ \-\ GO",
"55113376", "São\ Paulo\ \-\ SP",
"55373227", "Nova\ Serrana\ \-\ MG",
"55993604", "São\ Pedro\ dos\ Crentes\ \-\ MA",
"55633425", "Pau\ D\'Arco\ \-\ TO",
"55443529", "Campo\ Mourão\ \-\ PR",
"55773021", "Barreiras\ \-\ BA",
"55333022", "Governador\ Valadares\ \-\ MG",
"55883428", "Iracema\ \-\ CE",
"55973453", "Boca\ do\ Acre\ \-\ AM",
"55313912", "Contagem\ \-\ MG",
"55483654", "Santa\ Rosa\ de\ Lima\ \-\ SC",
"55713637", "Vera\ Cruz\ \-\ BA",
"55124159", "Vargem\ Grande\ Paulista\ \-\ SP",
"55873772", "Correntes\ \-\ PE",
"55793260", "Barra\ dos\ Coqueiros\ \-\ SE",
"55834101", "Campina\ Grande\ \-\ PB",
"55423639", "Foz\ do\ Jordão\ \-\ PR",
"55114017", "Jarinu\ \-\ SP",
"55843248", "Senador\ Georgino\ Avelino\ \-\ RN",
"55183117", "Araçatuba\ \-\ SP",
"55513215", "Rio\ Grande\ do\ Sul",
"55623358", "Santa\ Isabel\ \-\ GO",
"55493424", "Bom\ Jesus\ \-\ SC",
"55173841", "Arabá\ \-\ SP",
"55633472", "Araguacema\ \-\ TO",
"55613387", "Sobradinho\ \-\ DF",
"55153272", "Itapetininga\ \-\ SP",
"55753326", "Boa\ Vista\ do\ Tupim\ \-\ BA",
"55813638", "Bom\ Jardim\ \-\ PE",
"55543457", "Monte\ Belo\ do\ Sul\ \-\ RS",
"55913712", "Castanhal\ \-\ PA",
"55313828", "Minas\ Gerais",
"55713038", "Salvador\ \-\ BA",
"55353437", "Senador\ Amaral\ \-\ MG",
"5561303", "Brasília\ \-\ DF",
"55913636", "Limoeiro\ do\ Ajuru\ \-\ PA",
"55613532", "Brasília\ \-\ DF",
"55313562", "Itabirito\ \-\ MG",
"55413978", "Antonina\ \-\ PR",
"55472122", "Balneário\ Camboriú\ \-\ SC",
"55513229", "Rio\ Grande\ do\ Sul",
"55963242", "Macapá\ \-\ AP",
"55114618", "Jandira\ \-\ SP",
"5583324", "João\ Pessoa\ \-\ PB",
"55163349", "Trabiju\ \-\ SP",
"55123101", "Cachoeira\ Paulista\ \-\ SP",
"55474105", "Itajaí\ \-\ SC",
"55333342", "Durandé\ \-\ MG",
"55193867", "Jaguariúna\ \-\ SP",
"55653904", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55313553", "Cachoeira\ do\ Campo\ \-\ MG",
"55963084", "Macapá\ \-\ AP",
"55433625", "Cafeara\ \-\ PR",
"55513442", "Alvorada\ \-\ RS",
"55833498", "Serra\ Grande\ \-\ PB",
"55913727", "Tomé\-Açu\ \-\ PA",
"5555322", "Santa\ Maria\ \-\ RS",
"55313530", "Betim\ \-\ MG",
"55823282", "Paulo\ Jacinto\ \-\ AL",
"55483522", "Araranguá\ \-\ SC",
"55513370", "Rio\ Grande\ do\ Sul",
"55433619", "Ibaiti\ \-\ PR",
"55173209", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55212669", "Nova\ Iguaçu\ \-\ RJ",
"55313324", "Belo\ Horizonte\ \-\ MG",
"55913181", "Belém\ \-\ PA",
"55473423", "Joinville\ \-\ SC",
"55913859", "Salinópolis\ \-\ PA",
"55373212", "Divinópolis\ \-\ MG",
"55733211", "Itabuna\ \-\ BA",
"55943431", "Santana\ do\ Araguaia\ \-\ PA",
"55453233", "Campo\ Bonito\ \-\ PR",
"55213097", "Teresópolis\ \-\ RJ",
"55823530", "Arapiraca\ \-\ AL",
"55193543", "Araras\ \-\ SP",
"55643497", "Santo\ Antônio\ do\ Rio\ Verde\ \-\ GO",
"55913434", "Garrafão\ do\ Norte\ \-\ PA",
"55873852", "Betânia\ \-\ PE",
"55623551", "Bela\ Vista\ de\ Goiás\ \-\ GO",
"55413140", "Campo\ Largo\ \-\ PR",
"55823553", "Porto\ Real\ do\ Colégio\ \-\ AL",
"55613214", "Brasília\ \-\ DF",
"55853123", "Caucaia\ \-\ CE",
"55813469", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55193311", "Jaguariúna\ \-\ SP",
"55693913", "Guajará\-Mirim\ \-\ RO",
"55493626", "Bandeirante\ \-\ SC",
"55343853", "Tiros\ \-\ MG",
"5511452", "Jundiaí\ \-\ SP",
"55114022", "Itu\ \-\ SP",
"55153255", "Angatuba\ \-\ SP",
"55453379", "Toledo\ \-\ PR",
"55633455", "Nazaré\ \-\ TO",
"55423447", "São\ João\ do\ Triunfo\ \-\ PR",
"55173343", "Bebedouro\ \-\ SP",
"55513731", "Rio\ Pardo\ \-\ RS",
"55553538", "Boa\ Vista\ do\ Buricá\ \-\ RS",
"55973423", "Fonte\ Boa\ \-\ AM",
"55813887", "Orocó\ \-\ PE",
"55193848", "Louveira\ \-\ SP",
"55833682", "São\ José\ dos\ Ramos\ \-\ PB",
"55873817", "Alagoinha\ \-\ PE",
"55483624", "Jaguaruna\ \-\ SC",
"55883585", "Iguatu\ \-\ CE",
"55423219", "Ponta\ Grossa\ \-\ PR",
"55163203", "Jaboticabal\ \-\ SP",
"55113581", "Barueri\ \-\ SP",
"55153294", "Ibiúna\ \-\ SP",
"55633494", "Barra\ do\ Ouro\ \-\ TO",
"55143584", "Pirajuí\ \-\ SP",
"55192146", "Capivari\ \-\ SP",
"55843332", "Areia\ Branca\ \-\ RN",
"55613436", "Brasília\ \-\ DF",
"55133213", "Santos\ \-\ SP",
"55313466", "Belo\ Horizonte\ \-\ MG",
"55143881", "Botucatu\ \-\ SP",
"55873794", "Ibirajuba\ \-\ PE",
"55173814", "Adolfo\ \-\ SP",
"55493454", "Xavantina\ \-\ SC",
"55793541", "Tobias\ Barreto\ \-\ SE",
"55423272", "Telêmaco\ Borba\ \-\ PR",
"55353691", "Três\ Corações\ \-\ MG",
"55222666", "São\ Vicente\ de\ Paula\ \-\ RJ",
"55993626", "Pedreiras\ \-\ MA",
"55473035", "Blumenau\ \-\ SC",
"55313858", "Dionísio\ \-\ MG",
"55513635", "São\ Sebastião\ do\ Caí\ \-\ RS",
"55273161", "Guarapari\ \-\ ES",
"551129", "São\ Paulo\ \-\ SP",
"55443431", "Paraíso\ do\ Norte\ \-\ PR",
"55373333", "Carmópolis\ de\ Minas\ \-\ MG",
"55193024", "Rio\ Claro\ \-\ SP",
"55793313", "Feira\ Nova\ \-\ SE",
"55423523", "União\ da\ Vitória\ \-\ PR",
"55653611", "Cuiabá\ \-\ MT",
"55313826", "Minas\ Gerais",
"55533027", "Pelotas\ \-\ RS",
"55863242", "Barras\ \-\ PI",
"55833365", "Alagoa\ Nova\ \-\ PB",
"55753328", "Ibiquera\ \-\ BA",
"55143373", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55813636", "Paudalho\ \-\ PE",
"55153553", "Ribeirão\ Branco\ \-\ SP",
"55414107", "Curitiba\ \-\ PR",
"55843246", "Pipa\ \-\ RN",
"55623356", "Nova\ Veneza\ \-\ GO",
"55813712", "Caruaru\ \-\ PE",
"55853924", "Fortaleza\ \-\ CE",
"55383746", "Ibiaí\ \-\ MG",
"55193607", "Casa\ Branca\ \-\ SP",
"55873782", "Saloá\ \-\ PE",
"55312128", "Belo\ Horizonte\ \-\ MG",
"55443633", "São\ João\ \-\ PR",
"55153324", "Tatuí\ \-\ SP",
"55123646", "Roseira\ \-\ SP",
"55433031", "Londrina\ \-\ PR",
"55693428", "Nova\ Londrina\ \-\ RO",
"55193516", "Campinas\ \-\ SP",
"55883426", "Banabuiú\ \-\ CE",
"55483265", "São\ João\ Batista\ \-\ SC",
"55983273", "São\ Luís\ \-\ MA",
"55863477", "Inhuma\ \-\ PI",
"55153282", "Tietê\ \-\ SP",
"55514009", "Porto\ Alegre\ \-\ RS",
"55513567", "Santa\ Maria\ do\ Herval\ \-\ RS",
"55813093", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55193966", "Conchal\ \-\ SP",
"55673451", "Itaporã\ \-\ MS",
"55493347", "Coronel\ Freitas\ \-\ SC",
"55333414", "Divinolândia\ de\ Minas\ \-\ MG",
"55883552", "Mauriti\ \-\ CE",
"55423664", "Faxinal\ do\ Céu\ \-\ PR",
"55793346", "Canindé\ de\ São\ Francisco\ \-\ SE",
"5592364", "Manaus\ \-\ AM",
"55843697", "Parazinho\ \-\ RN",
"55873885", "Mirandiba\ \-\ PE",
"55123411", "Taubaté\ \-\ SP",
"55653928", "Cuiabá\ \-\ MT",
"55673292", "Rio\ Verde\ de\ Mato\ Grosso\ \-\ MS",
"55893424", "Paquetá\ \-\ PI",
"55163221", "Matão\ \-\ SP",
"55773229", "Brumado\ \-\ BA",
"55114158", "Vargem\ Grande\ Paulista\ \-\ SP",
"55114441", "Caieiras\ \-\ SP",
"55443248", "Iguaraçu\ \-\ PR",
"55663533", "Sinop\ \-\ MT",
"55713285", "Salvador\ \-\ BA",
"55833373", "Araruna\ \-\ PB",
"55113378", "Jundiaí\ \-\ SP",
"55423912", "São\ Mateus\ do\ Sul\ \-\ PR",
"55213020", "Rio\ de\ Janeiro\ \-\ RJ",
"55633371", "Paranã\ \-\ TO",
"5561", "Federal\ District",
"55183657", "Alto\ Alegre\ \-\ SP",
"55493658", "Tigrinhos\ \-\ SC",
"55343249", "Araguari\ \-\ MG",
"55223512", "Nova\ Friburgo\ \-\ RJ",
"55152104", "Sorocaba\ \-\ SP",
"55883517", "Jucás\ \-\ CE",
"55113754", "Arujá\ \-\ SP",
"55914107", "Ananindeua\ \-\ PA",
"55473547", "Braço\ do\ Trombudo\ \-\ SC",
"55613669", "Valparaíso\ de\ Goiás\ \-\ GO",
"55623142", "Goiânia\ \-\ GO",
"55923306", "Manaus\ \-\ AM",
"55212173", "Rio\ de\ Janeiro\ \-\ RJ",
"55883695", "Sobral\ \-\ CE",
"55823255", "Colônia\ Leopoldina\ \-\ AL",
"55192113", "Limeira\ \-\ SP",
"55923664", "Manaus\ \-\ AM",
"55273769", "Jaguaré\ \-\ ES",
"55222551", "Cordeiro\ \-\ RJ",
"55333236", "Alpercata\ \-\ MG",
"55753439", "Ribeira\ do\ Amparo\ \-\ BA",
"55283546", "Venda\ Nova\ do\ Imigrante\ \-\ ES",
"55863198", "Teresina\ \-\ PI",
"55183367", "Borá\ \-\ SP",
"55483273", "Major\ Gercino\ \-\ SC",
"55813757", "Santa\ Maria\ do\ Cambucá\ \-\ PE",
"55434101", "Apucarana\ \-\ PR",
"55823294", "União\ dos\ Palmares\ \-\ AL",
"55883654", "Mucambo\ \-\ CE",
"55423562", "Paula\ Freitas\ \-\ PR",
"55383084", "Montes\ Claros\ \-\ MG",
"55613359", "Samambaia\ Sul\ \-\ DF",
"55273344", "Viana\ \-\ ES",
"55473621", "Canoinhas\ \-\ SC",
"55513548", "Riozinho\ \-\ RS",
"55513952", "São\ Leopoldo\ \-\ RS",
"55753358", "Coronel\ Octaviano\ Alves\ \-\ BA",
"55354104", "Lavras\ \-\ MG",
"55222668", "Silva\ Jardim\ \-\ RJ",
"55313856", "São\ Domingos\ do\ Prata\ \-\ MG",
"55143405", "Pompéia\ \-\ SP",
"55423553", "Bituruna\ \-\ PR",
"55813877", "Carnaubeira\ da\ Penha\ \-\ PE",
"55623326", "Jaraguá\ \-\ GO",
"55353261", "Campanha\ \-\ MG",
"5551379", "Rio\ Grande\ do\ Sul",
"55883404", "Russas\ \-\ CE",
"55153523", "Caputera\ \-\ SP",
"55533281", "Pelotas\ \-\ RS",
"55373071", "Divinópolis\ \-\ MG",
"55883575", "Jati\ \-\ CE",
"55223234", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55123153", "Lorena\ \-\ SP",
"55113571", "São\ Paulo\ \-\ SP",
"55853667", "Itarema\ \-\ CE",
"55943332", "São\ Domingos\ do\ Araguaia\ \-\ PA",
"55212707", "Niterói\ \-\ RJ",
"55753296", "Sítio\ do\ Quinto\ \-\ BA",
"55833625", "Marcação\ \-\ PB",
"55193846", "Vinhedo\ \-\ SP",
"55553536", "Alegria\ \-\ RS",
"5565366", "Cuiabá\ \-\ MT",
"55143496", "Tupã\ \-\ SP",
"55543344", "Tapejara\ \-\ RS",
"55513399", "Rio\ Grande\ do\ Sul",
"55883522", "Jaguaribe\ \-\ CE",
"55493561", "Caçador\ \-\ SC",
"55853357", "General\ Sampaio\ \-\ CE",
"55773442", "Buritirama\ \-\ BA",
"55623503", "Abadia\ de\ Goiás\ \-\ GO",
"55883563", "Icó\ \-\ CE",
"55313447", "Belo\ Horizonte\ \-\ MG",
"55873035", "Petrolina\ \-\ PE",
"55383531", "Diamantina\ \-\ MG",
"55913469", "Nova\ Timboteua\ \-\ PA",
"55374141", "Divinópolis\ \-\ MG",
"5516333", "Araraquara\ \-\ SP",
"55443332", "Itaguajé\ \-\ PR",
"55222647", "Cabo\ Frio\ \-\ RJ",
"55923324", "Presidente\ Figueiredo\ \-\ AM",
"55823272", "Barra\ de\ São\ Miguel\ \-\ AL",
"55453411", "Cascavel\ \-\ PR",
"55893454", "Fronteiras\ \-\ PI",
"55163251", "Guariba\ \-\ SP",
"55643450", "Marzagão\ \-\ GO",
"55893495", "Queimada\ Nova\ \-\ PI",
"55513380", "Rio\ Grande\ do\ Sul",
"55473361", "Balneário\ Camboriú\ \-\ SC",
"55323727", "Barão\ de\ Monte\ Alto\ \-\ MG",
"55813434", "Paulista\ \-\ PE",
"55643433", "Itumbiara\ \-\ GO",
"55513700", "Rio\ Grande\ do\ Sul",
"55843431", "Currais\ Novos\ \-\ RN",
"55223842", "Porciúncula\ \-\ RJ",
"55483199", "Tubarão\ \-\ SC",
"55193457", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55993561", "Governador\ Luiz\ Rocha\ \-\ MA",
"55753647", "Aratuípe\ \-\ BA",
"55333732", "Comercinho\ \-\ MG",
"55623464", "Água\ Fria\ de\ Goiás\ \-\ GO",
"55673274", "Figueirão\ \-\ MS",
"55533240", "Bagé\ \-\ RS",
"55153562", "Itaberá\ \-\ SP",
"55113437", "Guarulhos\ \-\ SP",
"55273311", "Vila\ Velha\ \-\ ES",
"55513051", "Canoas\ \-\ RS",
"55212634", "Maricá\ \-\ RJ",
"55383834", "Nova\ Porteirinha\ \-\ MG",
"55543054", "Caxias\ do\ Sul\ \-\ RS",
"55883624", "Granja\ \-\ CE",
"55813545", "Igarassu\ \-\ PE",
"55143417", "Marília\ \-\ SP",
"55713298", "Simões\ Filho\ \-\ BA",
"55753491", "Feira\ de\ Santana\ \-\ BA",
"55753449", "Conde\ \-\ BA",
"55433661", "Alvorada\ do\ Sul\ \-\ PR",
"55283536", "Anchieta\ \-\ ES",
"55513538", "Canoas\ \-\ RS",
"55983678", "Pindare\ Mirim\ \-\ MA",
"55383811", "Monte\ Azul\ \-\ MG",
"5511567", "São\ Paulo\ \-\ SP",
"55993582", "Imperatriz\ \-\ MA",
"55623959", "Niquelândia\ \-\ GO",
"55973471", "São\ Gabriel\ da\ Cachoeira\ \-\ AM",
"55753217", "Santo\ Amaro\ \-\ BA",
"55313378", "Belo\ Horizonte\ \-\ MG",
"55143291", "Domélia\ \-\ SP",
"55673226", "Ladário\ \-\ MS",
"55413047", "Almirante\ Tamandaré\ \-\ PR",
"55333246", "Mendes\ Pimentel\ \-\ MG",
"55313754", "Lamim\ \-\ MG",
"55353011", "Alfenas\ \-\ MG",
"55113308", "Jundiaí\ \-\ SP",
"55453545", "Foz\ do\ Iguaçu\ \-\ PR",
"55633301", "Gurupi\ \-\ TO",
"55353858", "Santana\ da\ Vargem\ \-\ MG",
"55433351", "Londrina\ \-\ PR",
"55813411", "Belo\ Jardim\ \-\ PE",
"55423909", "Palmeira\ \-\ PR",
"55673483", "Coronel\ Sapucaia\ \-\ MS",
"55212103", "Rio\ de\ Janeiro\ \-\ RJ",
"55473537", "Chapadão\ do\ Lageado\ \-\ SC",
"555130", "Rio\ Grande\ do\ Sul",
"55313649", "Santa\ Luzia\ \-\ MG",
"55163847", "Nuporanga\ \-\ SP",
"55743685", "Mundo\ Novo\ \-\ BA",
"55353466", "Munhoz\ \-\ MG",
"55833452", "Piancó\ \-\ PB",
"55983349", "Barreirinhas\ \-\ MA",
"55243328", "Barra\ Mansa\ \-\ RJ",
"55513191", "Portão\ \-\ RS",
"55983391", "Cururupu\ \-\ MA",
"55733269", "Ilhéus\ \-\ BA",
"55553259", "Mata\ \-\ RS",
"55413648", "Bateias\ \-\ PR",
"55893572", "Parnaguá\ \-\ PI",
"55473702", "Blumenau\ \-\ SC",
"5592363", "Manaus\ \-\ AM",
"55473382", "Timbó\ \-\ SC",
"55193744", "Campinas\ \-\ SP",
"55313386", "Minas\ Gerais",
"55483203", "Florianópolis\ \-\ SC",
"55114431", "Jundiaí\ \-\ SP",
"55123978", "Jambeiro\ \-\ SP",
"55443238", "Doutor\ Camargo\ \-\ PR",
"55633685", "Combinado\ \-\ TO",
"55773460", "Igaporã\ \-\ BA",
"55933528", "Novo\ Progresso\ \-\ PA",
"55833291", "Rio\ Tinto\ \-\ PB",
"55383679", "Paracatu\ \-\ MG",
"55473471", "São\ Francisco\ do\ Sul\ \-\ SC",
"55213851", "Nova\ Iguaçu\ \-\ RJ",
"55183609", "Araçatuba\ \-\ SP",
"55514116", "Porto\ Alegre\ \-\ RS",
"55353553", "Juruaia\ \-\ MG",
"55112085", "Guarulhos\ \-\ SP",
"55143303", "Marília\ \-\ SP",
"55493337", "Jardinópolis\ \-\ SC",
"55643901", "Itumbiara\ \-\ GO",
"5521310", "Rio\ de\ Janeiro\ \-\ RJ",
"55273076", "Cariacica\ \-\ ES",
"55114577", "Mauá\ \-\ SP",
"55313892", "Viçosa\ \-\ MG",
"55183746", "Pereira\ Barreto\ \-\ SP",
"55413906", "Curitiba\ \-\ PR",
"55624106", "Trindade\ \-\ GO",
"55543533", "Caxias\ do\ Sul\ \-\ RS",
"55273125", "Guarapari\ \-\ ES",
"55613307", "Brasília\ \-\ DF",
"55443643", "Francisco\ Alves\ \-\ PR",
"55553277", "São\ Martinho\ da\ Serra\ \-\ RS",
"55223211", "Campos\ dos\ Goytacazes\ \-\ RJ",
"5515321", "Sorocaba\ \-\ SP",
"5563341", "Araguaína\ \-\ TO",
"55553816", "Condor\ \-\ RS",
"55143452", "Pompéia\ \-\ SP",
"55333515", "Água\ Boa\ \-\ MG",
"55353282", "Carvalhópolis\ \-\ MG",
"55163456", "Ribeirão\ Preto\ \-\ SP",
"55813709", "Belo\ Jardim\ \-\ PE",
"55433528", "Wenceslau\ Braz\ \-\ PR",
"55663489", "Ribeirão\ Cascalheira\ \-\ MT",
"55623374", "Itapirapuã\ \-\ GO",
"55383612", "Montalvânia\ \-\ MG",
"55813646", "Tracunhaém\ \-\ PE",
"55533262", "Arroio\ Grande\ \-\ RS",
"55753252", "Ruy\ Barbosa\ \-\ BA",
"55333529", "Teófilo\ Otoni\ \-\ MG",
"55413667", "Pinhais\ \-\ PR",
"55424052", "Guarapuava\ \-\ PR",
"55213554", "Rio\ de\ Janeiro\ \-\ RJ",
"55843236", "Natal\ \-\ RN",
"55673591", "Santa\ Rita\ do\ Pardo\ \-\ MS",
"55493253", "São\ Cristovão\ do\ Sul\ \-\ SC",
"55112507", "São\ Paulo\ \-\ SP",
"55863260", "Demerval\ Lobão\ \-\ PI",
"55893488", "Jacobina\ do\ Piauí\ \-\ PI",
"55114529", "Jacaré\ \-\ SP",
"55113447", "Osasco\ \-\ SP",
"55114098", "Salto\ \-\ SP",
"5581346", "Recife\ \-\ PE",
"55163749", "Ribeirão\ Corrente\ \-\ SP",
"55424063", "Ponta\ Grossa\ \-\ PR",
"55694001", "Porto\ Velho\ \-\ RO",
"55883221", "Juazeiro\ do\ Norte\ \-\ CE",
"55823202", "Maceió\ \-\ AL",
"55323444", "Recreio\ \-\ MG",
"55753263", "Valente\ \-\ BA",
"55813535", "Moreno\ \-\ PE",
"55673671", "Dourados\ \-\ MS",
"55193629", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55412107", "Curitiba\ \-\ PR",
"55143602", "Jaú\ \-\ SP",
"55513770", "Sério\ \-\ RS",
"55273533", "Vila\ Velha\ \-\ ES",
"55443017", "Campo\ Mourão\ \-\ PR",
"55223832", "Rosal\ \-\ RJ",
"55483131", "Florianópolis\ \-\ SC",
"55623878", "Goiânia\ \-\ GO",
"55313724", "Cristiano\ Otoni\ \-\ MG",
"55893555", "Arraial\ \-\ PI",
"55323535", "Divinésia\ \-\ MG",
"55623565", "Goiânia\ \-\ GO",
"55653387", "Campos\ de\ Júlio\ \-\ MT",
"55833556", "São\ Gonçalo\ \-\ PB",
"55773645", "Boquira\ \-\ BA",
"55483029", "São\ José\ \-\ SC",
"55313202", "Belo\ Horizonte\ \-\ MG",
"55643443", "Catalão\ \-\ GO",
"55133507", "Mongaguá\ \-\ SP",
"55193597", "Rio\ Claro\ \-\ SP",
"55383541", "Serro\ \-\ MG",
"55243358", "Resende\ \-\ RJ",
"55833422", "Patos\ \-\ PB",
"55353562", "Nova\ Resende\ \-\ MG",
"55313437", "Minas\ Gerais",
"55613467", "Brasília\ \-\ DF",
"55933558", "Belterra\ \-\ PA",
"55863367", "Luís\ Correia\ \-\ PI",
"55932101", "Santarém\ \-\ PA",
"55443342", "Paranapoema\ \-\ PR",
"55192138", "Campinas\ \-\ SP",
"55543334", "Colorado\ \-\ RS",
"55153261", "Porto\ Feliz\ \-\ SP",
"55773432", "Itambé\ \-\ BA",
"55333431", "Santa\ Maria\ do\ Suaçuí\ \-\ MG",
"55633461", "Brasilândia\ do\ Tocantins\ \-\ TO",
"55112835", "São\ Caetano\ do\ Sul\ \-\ SP",
"55353523", "Alpinópolis\ \-\ MG",
"55923581", "Manaus\ \-\ AM",
"55833463", "Taperoá\ \-\ PB",
"55143475", "Ocauçu\ \-\ SP",
"55115105", "São\ Paulo\ \-\ SP",
"55963117", "Macapá\ \-\ AP",
"55193836", "Vinhedo\ \-\ SP",
"55113501", "São\ Paulo\ \-\ SP",
"55543520", "Erechim\ \-\ RS",
"55222222", "Nova\ Friburgo\ \-\ RJ",
"55313571", "Brumadinho\ \-\ MG",
"55753275", "Monte\ Santo\ \-\ BA",
"55553546", "Alecrim\ \-\ RS",
"55153388", "Sorocaba\ \-\ SP",
"55312559", "Contagem\ \-\ MG",
"55983015", "São\ Luís\ \-\ MA",
"55313874", "Minas\ Gerais",
"55943342", "Abel\ Figueiredo\ \-\ PA",
"55114246", "Mairinque\ \-\ SP",
"55433558", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55432101", "Londrina\ \-\ PR",
"55963689", "Afuá\ \-\ PA",
"55843616", "Natal\ \-\ RN",
"55153376", "Itapetininga\ \-\ SP",
"55353664", "Conceição\ das\ Pedras\ \-\ MG",
"55623573", "Goiânia\ \-\ GO",
"55873761", "Garanhuns\ \-\ PE",
"55683262", "Vila\ do\ V\ \-\ AC",
"55983484", "Afonso\ Cunha\ \-\ MA",
"55383232", "Cristália\ \-\ MG",
"55115092", "São\ Paulo\ \-\ SP",
"55273194", "Vitória\ \-\ ES",
"55653241", "Mirassol\ D\'Oeste\ \-\ MT",
"55143556", "Cafelândia\ \-\ SP",
"55133499", "Praia\ Grande\ \-\ SP",
"55484001", "Florianópolis\ \-\ SC",
"55194113", "Sumaré\ \-\ SP",
"55813521", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55114576", "Mauá\ \-\ SP",
"55543015", "Erechim\ \-\ RS",
"55553755", "Liberato\ Salzano\ \-\ RS",
"55443685", "Nova\ Olímpia\ \-\ PR",
"55613395", "Santa\ Maria\ \-\ DF",
"55333268", "Aimorés\ \-\ MG",
"5592", "Amazonas",
"55553361", "Giruá\ \-\ RS",
"55143641", "Barra\ Bonita\ \-\ SP",
"55413907", "Curitiba\ \-\ PR",
"55273764", "Pedro\ Canário\ \-\ ES",
"55373352", "Arcos\ \-\ MG",
"55823634", "Senador\ Rui\ Palmeira\ \-\ AL",
"55843330", "Itajá\ \-\ RN",
"55423270", "Guaragi\ \-\ PR",
"55753434", "Acajutiba\ \-\ BA",
"55553794", "Planalto\ \-\ RS",
"55613354", "Brasília\ \-\ DF",
"55513481", "Eldorado\ do\ Sul\ \-\ RS",
"55843353", "São\ Miguel\ \-\ RN",
"55242463", "Engenheiro\ Paulo\ de\ Frontin\ \-\ RJ",
"55222727", "São\ Francisco\ de\ Itabapoana\ \-\ RJ",
"55823299", "Atalaia\ \-\ AL",
"55883659", "Croatá\ \-\ CE",
"55713648", "Dias\ d\'Ávila\ \-\ BA",
"55493336", "Guatambú\ \-\ SC",
"55813647", "Buenos\ Aires\ \-\ PE",
"55513134", "São\ Leopoldo\ \-\ RS",
"55713379", "Lauro\ de\ Freitas\ \-\ BA",
"5511366", "São\ Paulo\ \-\ SP",
"55513898", "Porto\ Alegre\ \-\ RS",
"55413666", "Colombo\ \-\ PR",
"55843237", "Parnamirim\ \-\ RN",
"55893429", "São\ João\ da\ Canabrava\ \-\ PI",
"55114494", "Atibaia\ \-\ SP",
"55753181", "Alagoinhas\ \-\ BA",
"55733661", "Vereda\ \-\ BA",
"55613306", "Brasília\ \-\ DF",
"55553276", "São\ Pedro\ do\ Sul\ \-\ RS",
"55893415", "Picos\ \-\ PI",
"55753545", "Milagres\ \-\ BA",
"55343244", "Uberlândia\ \-\ MG",
"55313241", "Belo\ Horizonte\ \-\ MG",
"55623988", "Goiânia\ \-\ GO",
"55313634", "Santa\ Luzia\ \-\ MG",
"55843663", "Natal\ \-\ RN",
"55112771", "São\ Paulo\ \-\ SP",
"55112622", "São\ Paulo\ \-\ SP",
"55123637", "Moreira\ César\ \-\ SP",
"55343631", "Ibiá\ \-\ MG",
"55643661", "Mineiros\ \-\ GO",
"55112663", "São\ Paulo\ \-\ SP",
"55733041", "Itabuna\ \-\ BA",
"55333425", "Braúnas\ \-\ MG",
"55733528", "Jequié\ \-\ BA",
"55323296", "Arantina\ \-\ MG",
"55343832", "Patrocínio\ \-\ MG",
"55673227", "Anhanduí\ \-\ MS",
"55333247", "Itabirinha\ \-\ MG",
"55743643", "Mulungu\ do\ Morro\ \-\ BA",
"55883677", "Sobral\ \-\ CE",
"55213835", "Rio\ de\ Janeiro\ \-\ RJ",
"55513593", "Novo\ Hamburgo\ \-\ RS",
"55673445", "Anaurilândia\ \-\ MS",
"55544001", "Caxias\ do\ Sul\ \-\ RS",
"55873833", "Venturosa\ \-\ PE",
"55713667", "Mata\ de\ São\ João\ \-\ BA",
"55143416", "Jaú\ \-\ SP",
"5542", "Paraná",
"5511508", "São\ Paulo\ \-\ SP",
"55283537", "Iconha\ \-\ ES",
"55613044", "Taguatinga\ \-\ DF",
"55873850", "Brejinho\ \-\ PE",
"55453252", "Toledo\ \-\ PR",
"55833641", "Riacho\ de\ Santo\ Antônio\ \-\ PB",
"55193938", "Indaiatuba\ \-\ SP",
"55163412", "São\ Carlos\ \-\ SP",
"55663585", "Feliz\ Natal\ \-\ MT",
"55624014", "Anápolis\ \-\ GO",
"55193492", "Capivari\ \-\ SP",
"55484042", "Balneário\ Camboriú\ \-\ SC",
"55793337", "Poço\ Redondo\ \-\ SE",
"55513372", "Rio\ Grande\ do\ Sul",
"55773471", "Paramirim\ \-\ BA",
"55313387", "Minas\ Gerais",
"55115934", "São\ Paulo\ \-\ SP",
"55133821", "Registro\ \-\ SP",
"55333340", "Governador\ Valadares\ \-\ MG",
"55943301", "Maracajá\ \-\ PA",
"55143842", "São\ Manuel\ \-\ SP",
"55433901", "Apucarana\ \-\ PR",
"55483334", "Florianópolis\ \-\ SC",
"55913784", "Portel\ \-\ PA",
"55173465", "Fernandópolis\ \-\ SP",
"55513440", "Rio\ Grande\ do\ Sul",
"55473536", "Petrolândia\ \-\ SC",
"55823280", "Pindoba\ \-\ AL",
"55313532", "Betim\ \-\ MG",
"55613562", "Taguatinga\ \-\ DF",
"55112524", "São\ Paulo\ \-\ SP",
"55513045", "Viamão\ \-\ RS",
"55193837", "Jaguariúna\ \-\ SP",
"55963116", "Santana\ \-\ AP",
"55613553", "Brasília\ \-\ DF",
"5511332", "São\ Paulo\ \-\ SP",
"55213236", "Nilópolis\ \-\ RJ",
"55813551", "Ipojuca\ \-\ PE",
"55373322", "Formiga\ \-\ MG",
"55423438", "Guamiranga\ \-\ PR",
"55173681", "Nova\ Canaã\ Paulista\ \-\ SP",
"55933589", "Santarém\ \-\ PA",
"55893531", "Canto\ do\ Buriti\ \-\ PI",
"55453038", "Cascavel\ \-\ PR",
"55863089", "Teresina\ \-\ PI",
"55242291", "Petrópolis\ \-\ RJ",
"55693533", "Porto\ Velho\ \-\ RO",
"55633470", "Santa\ Fé\ do\ Araguaia\ \-\ TO",
"55883629", "Novo\ Oriente\ \-\ CE",
"55222757", "Macaé\ \-\ RJ",
"55243389", "Barra\ Mansa\ \-\ RJ",
"55843323", "Mossoró\ \-\ RN",
"55913464", "Atalaia\ \-\ PA",
"55793262", "Barra\ dos\ Coqueiros\ \-\ SE",
"55114419", "Mairiporã\ \-\ SP",
"55893459", "Patos\ do\ Piauí\ \-\ PI",
"55323551", "Visconde\ do\ Rio\ Branco\ \-\ MG",
"55463057", "Francisco\ Beltrão\ \-\ PR",
"55553621", "Santana\ do\ Livramento\ \-\ RS",
"55123876", "São\ José\ dos\ Campos\ \-\ SP",
"55173258", "Bady\ Bassitt\ \-\ SP",
"55513673", "Mostardas\ \-\ RS",
"55114247", "Barueri\ \-\ SP",
"55112652", "São\ Paulo\ \-\ SP",
"55114033", "Bragança\ Paulista\ \-\ SP",
"55412106", "Curitiba\ \-\ PR",
"55473300", "Rio\ do\ Sul\ \-\ SC",
"55383626", "Ibiracatu\ \-\ MG",
"55513761", "Paverama\ \-\ RS",
"55443016", "Campo\ Mourão\ \-\ PR",
"55732101", "Ilhéus\ \-\ BA",
"55114605", "Caieiras\ \-\ SP",
"55372102", "Divinópolis\ \-\ MG",
"55433154", "Cambé\ \-\ PR",
"55133323", "Santos\ \-\ SP",
"55313809", "Santa\ Bárbara\ \-\ MG",
"55222779", "Conceição\ de\ Macabu\ \-\ RJ",
"55753636", "Nazaré\ \-\ BA",
"55163607", "Ribeirão\ Preto\ \-\ SP",
"55115486", "São\ Paulo\ \-\ SP",
"55773683", "Jaborandi\ \-\ BA",
"55273015", "Vitória\ \-\ ES",
"55863271", "Pedro\ II\ \-\ PI",
"55112506", "São\ Paulo\ \-\ SP",
"55983194", "São\ Luís\ \-\ MA",
"55513394", "Rio\ Grande\ do\ Sul",
"55183692", "Braúna\ \-\ SP",
"55793223", "Aracaju\ \-\ SE",
"55543349", "São\ Domingos\ do\ Sul\ \-\ RS",
"55642101", "Rio\ Verde\ \-\ GO",
"55643014", "Jataí\ \-\ GO",
"55643558", "Itumbiara\ \-\ GO",
"55543391", "Gaurama\ \-\ RS",
"55643942", "Itumbiara\ \-\ GO",
"55553401", "Uruguaiana\ \-\ RS",
"55653691", "Várzea\ Grande\ \-\ MT",
"55843362", "Campo\ Grande\ \-\ RN",
"55242452", "Valença\ \-\ RJ",
"55313436", "Minas\ Gerais",
"55353413", "Passos\ \-\ MG",
"55133851", "Cananéia\ \-\ SP",
"55863366", "Luís\ Correia\ \-\ PI",
"55213760", "Nilópolis\ \-\ RJ",
"55883409", "Russas\ \-\ CE",
"55114701", "Taboão\ da\ Serra\ \-\ SP",
"55963281", "Santana\ \-\ AP",
"55473065", "Balneário\ Camboriú\ \-\ SC",
"55513665", "Capão\ da\ Canoa\ \-\ RS",
"55483533", "Sombrio\ \-\ SC",
"55114696", "Salesópolis\ \-\ SP",
"55313165", "Santa\ Luzia\ \-\ MG",
"55953263", "Alto\ Alegre\ \-\ RR",
"55453275", "São\ Clemente\ \-\ PR",
"55653386", "São\ José\ do\ Rio\ Claro\ \-\ MT",
"55893477", "Inhuma\ \-\ PI",
"55133506", "Mongaguá\ \-\ SP",
"55143108", "Bauru\ \-\ SP",
"55653225", "Porto\ Esperidião\ \-\ MT",
"55483344", "Palhoça\ \-\ SC",
"55622765", "Goiânia\ \-\ GO",
"55183656", "Jatobá\ \-\ SP",
"55123668", "Campos\ do\ Jordão\ \-\ SP",
"55513453", "Rio\ Grande\ do\ Sul",
"55843381", "Alexandria\ \-\ RN",
"55623379", "Minaçu\ \-\ GO",
"55883516", "Piquet\ Carneiro\ \-\ CE",
"55273273", "Sooretama\ \-\ ES",
"55313542", "Nova\ Lima\ \-\ MG",
"55993117", "Timon\ \-\ MA",
"55513430", "Gravataí\ \-\ RS",
"55473546", "Laurentino\ \-\ SC",
"55333353", "Pingo\-D\'Água\ \-\ MG",
"55793347", "Cedro\ de\ São\ João\ \-\ SE",
"55443482", "Paranavaí\ \-\ PR",
"55663015", "Sinop\ \-\ MT",
"55843268", "Caiçara\ do\ Rio\ do\ Vento\ \-\ RN",
"55853464", "Fortaleza\ \-\ CE",
"55333524", "Ladainha\ \-\ MG",
"55843696", "Caiçara\ do\ Norte\ \-\ RN",
"55433055", "Arapongas\ \-\ PR",
"55383201", "Montes\ Claros\ \-\ MG",
"55323222", "Juiz\ de\ Fora\ \-\ MG",
"55162138", "Ribeirão\ Preto\ \-\ SP",
"55133419", "Pedro\ de\ Toledo\ \-\ SP",
"55192511", "Campinas\ \-\ SP",
"55183271", "Presidente\ Venceslau\ \-\ SP",
"55283547", "Conceição\ do\ Castelo\ \-\ ES",
"55313064", "Belo\ Horizonte\ \-\ MG",
"55513782", "Santa\ Clara\ do\ Sul\ \-\ RS",
"55463223", "Pato\ Branco\ \-\ PR",
"55823542", "São\ Sebastião\ \-\ AL",
"55114652", "Arujá\ \-\ SP",
"55163409", "Franca\ \-\ SP",
"55343061", "Patos\ de\ Minas\ \-\ MG",
"55383674", "Cabeceira\ Grande\ \-\ MG",
"55183366", "Quatá\ \-\ SP",
"55213431", "Rio\ de\ Janeiro\ \-\ RJ",
"55773401", "Vitória\ da\ Conquista\ \-\ BA",
"55873843", "Tacaratu\ \-\ PE",
"55843605", "Natal\ \-\ RN",
"55193948", "Louveira\ \-\ SP",
"55173564", "Catiguá\ \-\ SP",
"55193552", "Mogi\ Mirim\ \-\ SP",
"55183604", "Vicentinópolis\ \-\ SP",
"55413132", "Pinhais\ \-\ PR",
"55413036", "Almirante\ Tamandaré\ \-\ PR",
"55863133", "Teresina\ \-\ PI",
"55112419", "Bragança\ Paulista\ \-\ SP",
"55343842", "Monte\ Carmelo\ \-\ MG",
"55913758", "Cachoeira\ do\ Arari\ \-\ PA",
"55733031", "Itamaraju\ \-\ BA",
"55323275", "Santana\ do\ Deserto\ \-\ MG",
"55623312", "Itapuranga\ \-\ GO",
"55673435", "Antônio\ João\ \-\ MS",
"55213845", "Duque\ de\ Caxias\ \-\ RJ",
"55312524", "Contagem\ \-\ MG",
"55153467", "Capela\ do\ Alto\ \-\ SP",
"55743633", "Saúde\ \-\ BA",
"55333237", "Fernandes\ Tourinho\ \-\ MG",
"55383747", "Paredão\ de\ Minas\ \-\ MG",
"55313231", "Minas\ Gerais",
"55613261", "Brasília\ \-\ DF",
"5531335", "Minas\ Gerais",
"55133268", "Bertioga\ \-\ SP",
"55353438", "Camanducaia\ \-\ MG",
"55793281", "Laranjeiras\ \-\ SE",
"55123647", "Lagoinha\ \-\ SP",
"55423904", "Telêmaco\ Borba\ \-\ PR",
"55383525", "Senador\ Modestino\ Gonçalves\ \-\ MG",
"55553254", "Cacequi\ \-\ RS",
"55543458", "Tuiutí\ \-\ RS",
"55533026", "Pelotas\ \-\ RS",
"55313827", "Minas\ Gerais",
"55613388", "Planaltina\ \-\ DF",
"55843425", "São\ João\ do\ Sabugi\ \-\ RN",
"55773621", "Cotegipe\ \-\ BA",
"55813637", "Aliança\ \-\ PE",
"55333622", "Nanuque\ \-\ MG",
"55463262", "Palmas\ \-\ PR",
"55433345", "Londrina\ \-\ PR",
"55843247", "Pedro\ Velho\ \-\ RN",
"55193749", "Campinas\ \-\ SP",
"55273265", "Rio\ Bananal\ \-\ ES",
"55623357", "Uruaçu\ \-\ GO",
"55513566", "São\ Leopoldo\ \-\ RS",
"55114018", "Pinhalzinho\ \-\ SP",
"55163711", "Franca\ \-\ SP",
"55823644", "Água\ Branca\ \-\ AL",
"55123521", "Pindamonhangaba\ \-\ SP",
"55183502", "Adamantina\ \-\ SP",
"55493346", "Quilombo\ \-\ SC",
"55623995", "Goiânia\ \-\ GO",
"55823231", "Maceió\ \-\ AL",
"5512395", "Jacareí\ \-\ SP",
"55853326", "Capistrano\ \-\ CE",
"55213742", "Nova\ Iguaçu\ \-\ RJ",
"55193654", "Santo\ Antônio\ do\ Jardim\ \-\ SP",
"55173662", "Santa\ Salete\ \-\ SP",
"5582335", "Maceió\ \-\ AL",
"55323263", "Maripá\ de\ Minas\ \-\ MG",
"55193695", "Mococa\ \-\ SP",
"55883427", "Boa\ Viagem\ \-\ CE",
"55623954", "Goiânia\ \-\ GO",
"55843472", "Jardim\ do\ Seridó\ \-\ RN",
"55693344", "Pimenteiras\ do\ Oeste\ \-\ RO",
"55313759", "Minas\ Gerais",
"55922127", "Manaus\ \-\ AM",
"55114595", "Várzea\ Paulista\ \-\ SP",
"55373228", "Nova\ Serrana\ \-\ MG",
"55513423", "Gravataí\ \-\ RS",
"55193575", "Itirapina\ \-\ SP",
"55614063", "Brasília\ \-\ DF",
"55313879", "Belo\ Horizonte\ \-\ MG",
"55512117", "Porto\ Alegre\ \-\ RS",
"55893580", "Dom\ Inocêncio\ \-\ PI",
"55343512", "Araguari\ \-\ MG",
"55323726", "Patrocínio\ do\ Muriaé\ \-\ MG",
"55333323", "Ubaporanga\ \-\ MG",
"55313446", "Belo\ Horizonte\ \-\ MG",
"55222123", "Macaé\ \-\ RJ",
"55883412", "Quixadá\ \-\ CE",
"55323252", "Santos\ Dumont\ \-\ MG",
"55653308", "Nova\ Mutum\ \-\ MT",
"55473442", "São\ Francisco\ do\ Sul\ \-\ SC",
"55643498", "Professor\ Jamil\ \-\ GO",
"55133494", "Praia\ Grande\ \-\ SP",
"55193404", "Limeira\ \-\ SP",
"55613581", "Ceilândia\ \-\ DF",
"5535", "Minas\ Gerais",
"55643932", "Itumbiara\ \-\ GO",
"55813726", "Belo\ Jardim\ \-\ PE",
"55543339", "Erebango\ \-\ RS",
"55114622", "Santana\ de\ Parnaíba\ \-\ SP",
"55113436", "Guarulhos\ \-\ SP",
"55433176", "Rolândia\ \-\ PR",
"55312323", "Betim\ \-\ MG",
"55193456", "Iracemápolis\ \-\ SP",
"55913728", "Concórdia\ do\ Pará\ \-\ PA",
"55743620", "São\ Gabriel\ \-\ BA",
"55133576", "São\ Vicente\ \-\ SP",
"55114043", "Diadema\ \-\ SP",
"55193868", "Estiva\ Gerbi\ \-\ SP",
"55813252", "Recife\ \-\ PE",
"55753646", "Guaibim\ \-\ BA",
"55123013", "Guaratinguetá\ \-\ SP",
"55863393", "Luzilândia\ \-\ PI",
"551932", "Campinas\ \-\ SP",
"55853304", "Fortaleza\ \-\ CE",
"55543273", "Nova\ Bassano\ \-\ RS",
"55163993", "Ribeirão\ Preto\ \-\ SP",
"55313611", "Viçosa\ \-\ MG",
"55813491", "Olinda\ \-\ PE",
"55483024", "Florianópolis\ \-\ SC",
"55214501", "Rio\ de\ Janeiro\ \-\ RJ",
"55123895", "Ilhabela\ \-\ SP",
"55753162", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55733682", "Teixeira\ de\ Freitas\ \-\ BA",
"55343614", "Perdizes\ \-\ MG",
"55114402", "Atibaia\ \-\ SP",
"55163659", "Brodowski\ \-\ SP",
"55983311", "São\ Luís\ \-\ MA",
"55513111", "Cachoeirinha\ \-\ RS",
"55313857", "Dom\ Silvério\ \-\ MG",
"55193563", "Pirassununga\ \-\ SP",
"55553224", "Silveira\ Martins\ \-\ RS",
"55114663", "Embu\-Guaçu\ \-\ SP",
"55112883", "Mogi\ das\ Cruzes\ \-\ SP",
"55683026", "Rio\ Branco\ \-\ AC",
"55114821", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55652128", "Cuiabá\ \-\ MT",
"55183839", "Jamaica\ \-\ SP",
"55813217", "Recife\ \-\ PE",
"55413392", "Campo\ Largo\ \-\ PR",
"55643682", "Turvânia\ \-\ GO",
"55433433", "Ariranha\ do\ Ivaí\ \-\ PR",
"55323449", "Leopoldina\ \-\ MG",
"55313715", "Cordisburgo\ \-\ MG",
"55893541", "Marcos\ Parente\ \-\ PI",
"55114524", "Itatiba\ \-\ SP",
"55153307", "Itapetininga\ \-\ SP",
"55212649", "Cachoeiras\ de\ Macacu\ \-\ RJ",
"55212691", "Nilópolis\ \-\ RJ",
"55193624", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"5582332", "Maceió\ \-\ AL",
"55663410", "Rondonópolis\ \-\ MT",
"5512392", "São\ José\ dos\ Campos\ \-\ SP",
"55853356", "Apuiarés\ \-\ CE",
"55513603", "Rainha\ do\ Mar\ \-\ RS",
"55413573", "Curitiba\ \-\ PR",
"55183406", "Guararapes\ \-\ SP",
"55473635", "São\ Bento\ do\ Sul\ \-\ SC",
"55193847", "Jaguariúna\ \-\ SP",
"55513035", "Novo\ Hamburgo\ \-\ RS",
"55173284", "Ribeiro\ dos\ Santos\ \-\ SP",
"55373258", "Pitangui\ \-\ MG",
"55553537", "Horizontina\ \-\ RS",
"55313729", "Minas\ Gerais",
"55513462", "Canoas\ \-\ RS",
"55193913", "Itapira\ \-\ SP",
"55613540", "Brazlândia\ \-\ DF",
"55693311", "Cacoal\ \-\ RO",
"55353721", "Poços\ de\ Caldas\ \-\ MG",
"55313528", "Belo\ Horizonte\ \-\ MG",
"55333233", "Tarumirim\ \-\ MG",
"55743637", "Gentio\ do\ Ouro\ \-\ BA",
"55162105", "Sertãozinho\ \-\ SP",
"55833261", "Belém\ \-\ PB",
"55943779", "Goianésia\ do\ Pará\ \-\ PA",
"55453017", "Foz\ do\ Iguaçu\ \-\ PR",
"55113129", "São\ Paulo\ \-\ SP",
"55613981", "Formosa\ \-\ GO",
"55113115", "São\ Paulo\ \-\ SP",
"55113383", "São\ Paulo\ \-\ SP",
"55833388", "Seridó\ \-\ PB",
"55313862", "Alvorada\ de\ Minas\ \-\ MG",
"55993601", "Feira\ Nova\ do\ Maranhão\ \-\ MA",
"55773489", "Cocos\ \-\ BA",
"55473458", "São\ João\ do\ Itaperiú\ \-\ SC",
"55483276", "Alfredo\ Wagner\ \-\ SC",
"55873847", "Tabira\ \-\ PE",
"55463227", "Vitorino\ \-\ PR",
"55283543", "Ibatiba\ \-\ ES",
"55242438", "Conservatória\ \-\ RJ",
"55883111", "Sobral\ \-\ CE",
"55193818", "Mogi\-Guaçu\ \-\ SP",
"55663536", "Marcelândia\ \-\ MT",
"55163134", "Jeriquara\ \-\ SP",
"55823528", "Lagoa\ da\ Canoa\ \-\ AL",
"55913110", "Belém\ \-\ PA",
"55713472", "Salvador\ \-\ BA",
"55793343", "Pacatuba\ \-\ SE",
"55643532", "Itumbiara\ \-\ GO",
"55353625", "Marmelópolis\ \-\ MG",
"55333357", "Dom\ Cavati\ \-\ MG",
"55463534", "São\ Jorge\ D\'Oeste\ \-\ PR",
"55273277", "Timbuí\ \-\ ES",
"55173844", "Pontes\ Gestal\ \-\ SP",
"55623622", "Goiânia\ \-\ GO",
"55493802", "Lages\ \-\ SC",
"55513457", "Rio\ Grande\ do\ Sul",
"55833376", "Barra\ de\ Santa\ Rosa\ \-\ PB",
"55883603", "Cruz\ \-\ CE",
"55843638", "Rio\ do\ Fogo\ \-\ RN",
"55733532", "Itamari\ \-\ BA",
"55384141", "Montes\ Claros\ \-\ MG",
"55212025", "Rio\ de\ Janeiro\ \-\ RJ",
"55922123", "Manaus\ \-\ AM",
"55313765", "Minas\ Gerais",
"55633384", "Araguaçu\ \-\ TO",
"55543546", "Faxinalzinho\ \-\ RS",
"55343354", "Santa\ Juliana\ \-\ MG",
"55883423", "Limoeiro\ do\ Norte\ \-\ CE",
"55973458", "Pauini\ \-\ AM",
"55313351", "Contagem\ \-\ MG",
"55983276", "São\ Luís\ \-\ MA",
"55323267", "São\ João\ Nepomuceno\ \-\ MG",
"55143261", "Agudos\ \-\ SP",
"55113264", "Salvador\ \-\ BA",
"55983651", "Araguanã\ \-\ MA",
"55873868", "Afrânio\ \-\ PE",
"55773311", "Brumado\ \-\ BA",
"55923249", "Manaus\ \-\ AM",
"55333312", "Mutum\ \-\ MG",
"55144104", "Garça\ \-\ SP",
"55423303", "Guarapuava\ \-\ PR",
"55553334", "Augusto\ Pestana\ \-\ RS",
"55843243", "Goianinha\ \-\ RN",
"55273259", "Santa\ Teresa\ \-\ ES",
"55123022", "Taubaté\ \-\ SP",
"55623353", "Goianésia\ \-\ GO",
"55313080", "Belo\ Horizonte\ \-\ MG",
"55153556", "Iporanga\ \-\ SP",
"55993421", "Caxias\ \-\ MA",
"55143376", "Sodrélia\ \-\ SP",
"55813633", "Nazaré\ da\ Mata\ \-\ PE",
"55643634", "Chapadão\ do\ Céu\ \-\ GO",
"55343664", "Araxá\ \-\ MG",
"55513479", "Nova\ Santa\ Rita\ \-\ RS",
"55193341", "Campinas\ \-\ SP",
"55423526", "Porto\ União\ \-\ SC",
"55193399", "Sumaré\ \-\ SP",
"55613631", "Formosa\ \-\ GO",
"55313661", "Pedro\ Leopoldo\ \-\ MG",
"55673027", "Campo\ Grande\ \-\ MS",
"55713605", "Candeias\ \-\ BA",
"55193513", "Limeira\ \-\ SP",
"55733299", "Lajedão\ \-\ BA",
"55983361", "Axixá\ \-\ MA",
"55373242", "Itaúna\ \-\ MG",
"55733241", "Coaraci\ \-\ BA",
"55733634", "Ilhéus\ \-\ BA",
"55693651", "Costa\ Marques\ \-\ RO",
"55443636", "Pérola\ \-\ PR",
"55413973", "Rio\ Branco\ do\ Sul\ \-\ PR",
"55623524", "Goiânia\ \-\ GO",
"55383743", "Pirapora\ \-\ MG",
"55673240", "Aquidauana\ \-\ MS",
"55443545", "Yolanda\ \-\ PR",
"55313558", "Mariana\ \-\ MG",
"55313014", "Belo\ Horizonte\ \-\ MG",
"55312101", "Belo\ Horizonte\ \-\ MG",
"55213693", "Paracambi\ \-\ RJ",
"55113159", "São\ Paulo\ \-\ SP",
"55353365", "São\ Sebastião\ do\ Rio\ Verde\ \-\ MG",
"55653335", "Agrovila\ das\ Palmeiras\ \-\ MT",
"55873967", "Ouricuri\ \-\ PE",
"55833493", "Boa\ Ventura\ \-\ PB",
"55113584", "São\ Paulo\ \-\ SP",
"55114047", "Diadema\ \-\ SP",
"55153249", "Ibiúna\ \-\ SP",
"55633449", "Tupiratins\ \-\ TO",
"55423463", "Rio\ Azul\ \-\ PR",
"55493539", "Iomerê\ \-\ SC",
"55143581", "Pongaí\ \-\ SP",
"55633491", "Luzinópolis\ \-\ TO",
"55153291", "Araçoiaba\ da\ Serra\ \-\ SP",
"55513734", "Pantano\ Grande\ \-\ RS",
"55753301", "Feira\ de\ Santana\ \-\ BA",
"55323332", "Barbacena\ \-\ MG",
"55623362", "Porangatu\ \-\ GO",
"55473428", "Dona\ Francisca\ SC\ 301\ \-\ SC",
"55114312", "Mogi\ das\ Cruzes\ \-\ SP",
"55453238", "Ibema\ \-\ PR",
"55863289", "São\ Gonçalo\ do\ Piauí\ \-\ PI",
"55353655", "Sapucaí\-Mirim\ \-\ MG",
"55963212", "Macapá\ \-\ AP",
"55883566", "Juazeiro\ do\ Norte\ \-\ CE",
"55543259", "Nova\ Sardenha\ \-\ RS",
"55823558", "Penedo\ \-\ AL",
"55433571", "Siqueira\ Campos\ \-\ PR",
"55173811", "Nova\ Aliança\ \-\ SP",
"55873791", "Palmeirina\ \-\ PE",
"55143884", "Anhembi\ \-\ SP",
"55353694", "Lavras\ \-\ MG",
"55753685", "Ipecaetá\ \-\ BA",
"55793544", "Itabaianinha\ \-\ SE",
"55333327", "Ipaba\ \-\ MG",
"55493451", "Paial\ \-\ SC",
"55663432", "Poxoréo\ \-\ MT",
"55513427", "Canoas\ \-\ RS",
"55115062", "São\ Paulo\ \-\ SP",
"55222781", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55163761", "Batatais\ \-\ SP",
"55193917", "Ribeirão\ Preto\ \-\ SP",
"55185871", "Panorama\ \-\ SP",
"55873948", "Bom\ Nome\ \-\ PE",
"55213977", "Rio\ de\ Janeiro\ \-\ RJ",
"55433202", "Apucarana\ \-\ PR",
"55553533", "São\ Martinho\ \-\ RS",
"55313321", "Minas\ Gerais",
"55283518", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55973428", "Maraã\ \-\ AM",
"55193843", "Itapira\ \-\ SP",
"55343324", "Água\ Comprida\ \-\ MG",
"55513607", "Rio\ Grande\ do\ Sul",
"55913184", "Belém\ \-\ PA",
"55163394", "Matão\ \-\ SP",
"5511482", "Ribeirão\ Pires\ \-\ SP",
"55123104", "Aparecida\ \-\ SP",
"55115642", "São\ Paulo\ \-\ SP",
"55983621", "Bacabal\ \-\ MA",
"55623506", "Trindade\ \-\ GO",
"55313107", "Sete\ Lagoas\ \-\ MG",
"55653901", "Cuiabá\ \-\ MT",
"55643560", "São\ João\ da\ Paraúna\ \-\ GO",
"55993539", "Vila\ Nova\ dos\ Martírios\ \-\ MA",
"55963081", "Macapá\ \-\ AP",
"55143493", "Varpa\ \-\ SP",
"55353373", "Virgínia\ \-\ MG",
"55113177", "São\ Paulo\ \-\ SP",
"55433437", "Novo\ Itacolomi\ \-\ PR",
"55313830", "Minas\ Gerais",
"55153526", "Itapeva\ \-\ SP",
"55112887", "Itaquaquecetuba\ \-\ SP",
"55114667", "Itapecerica\ da\ Serra\ \-\ SP",
"55623323", "Ceres\ \-\ GO",
"55623595", "Goiânia\ \-\ GO",
"55273229", "Vila\ Velha\ \-\ ES",
"55193567", "Santa\ Cruz\ da\ Conceição\ \-\ SP",
"55313853", "Bela\ Vista\ de\ Minas\ \-\ MG",
"55473339", "Blumenau\ \-\ SC",
"55243371", "Paraty\ \-\ RJ",
"5545352", "Foz\ do\ Iguaçu\ \-\ PR",
"55163665", "Altinópolis\ \-\ SP",
"55793642", "Colônia\ Treze\ \-\ SE",
"55953238", "Rorainópolis\ \-\ RR",
"55943434", "Ourilândia\ do\ Norte\ \-\ PA",
"55733214", "Itabuna\ \-\ BA",
"55423422", "Irati\ \-\ PR",
"55114233", "São\ Caetano\ do\ Sul\ \-\ SP",
"55194009", "Campinas\ \-\ SP",
"55793318", "Monte\ Alegre\ de\ Sergipe\ \-\ SE",
"55273215", "Vitória\ \-\ ES",
"55623554", "Varjão\ \-\ GO",
"55123156", "Piquete\ \-\ SP",
"55693621", "São\ Francisco\ do\ Guaporé\ \-\ RO",
"55373232", "Pará\ de\ Minas\ \-\ MG",
"55973484", "Itamarati\ \-\ AM",
"55733231", "Ilhéus\ \-\ BA",
"55123633", "Taubaté\ \-\ SP",
"55713043", "Salvador\ \-\ BA",
"55474001", "Joinville\ \-\ SC",
"55443123", "Maringá\ \-\ PR",
"55143354", "Botucatu\ \-\ SP",
"55633358", "Dueré\ \-\ TO",
"55383733", "Francisco\ Dumont\ \-\ MG",
"55443646", "Pérola\ Independente\ \-\ PR",
"55114469", "Santo\ André\ \-\ SP",
"55493256", "Fraiburgo\ \-\ SC",
"55923365", "Novo\ Airão\ \-\ AM",
"55343261", "Ituiutaba\ \-\ MG",
"55313264", "Minas\ Gerais",
"55613234", "Guará\ \-\ DF",
"55143523", "Lins\ \-\ SP",
"55713622", "Camaçari\ \-\ BA",
"55183994", "Emilianópolis\ \-\ SP",
"55533717", "Rio\ Grande\ \-\ RS",
"55643644", "Aporé\ \-\ GO",
"55813643", "Itaquitinga\ \-\ PE",
"55283155", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55623340", "São\ Patrício\ \-\ GO",
"55883665", "Morrinhos\ \-\ CE",
"55843357", "Coronel\ João\ Pessoa\ \-\ RN",
"55433255", "Rolândia\ \-\ PR",
"55353556", "Arceburgo\ \-\ MG",
"55513409", "Miraguaia\ \-\ RS",
"55143664", "Itapuí\ \-\ SP",
"55115212", "São\ Paulo\ \-\ SP",
"55623425", "São\ Domingos\ \-\ GO",
"55543536", "Caxias\ do\ Sul\ \-\ RS",
"55624103", "Aparecida\ de\ Goiânia\ \-\ GO",
"55173242", "Mirassol\ \-\ SP",
"55653025", "Cuiabá\ \-\ MT",
"55833562", "Poço\ Dantas\ \-\ PB",
"55112312", "Mogi\ das\ Cruzes\ \-\ SP",
"55743668", "João\ Dourado\ \-\ BA",
"55823264", "Atalaia\ \-\ AL",
"55183743", "Ilha\ Solteira\ \-\ SP",
"55793279", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55173834", "Guarani\ D\'Oeste\ \-\ SP",
"55353463", "Bueno\ Brandão\ \-\ MG",
"55833395", "Umbuzeiro\ \-\ PB",
"55633521", "Brejinho\ de\ Nazaré\ \-\ TO",
"55463544", "Enéas\ Marques\ \-\ PR",
"55513615", "Caraá\ \-\ RS",
"55373541", "Abaeté\ \-\ MG",
"55983683", "Satubinha\ \-\ MA",
"55733542", "Km\ Cem\ \-\ BA",
"55313383", "Belo\ Horizonte\ \-\ MG",
"55413414", "Tagaçaba\ \-\ PR",
"55453332", "Nova\ Santa\ Rosa\ \-\ PR",
"55513629", "Rio\ Grande\ do\ Sul",
"55663546", "Cláudia\ \-\ MT",
"55643542", "Itumbiara\ \-\ GO",
"55222762", "Macaé\ \-\ RJ",
"55623605", "Goiânia\ \-\ GO",
"55833354", "Serra\ Branca\ \-\ PB",
"55423655", "Altamira\ do\ Paraná\ \-\ PR",
"55513711", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55793257", "São\ Cristóvão\ \-\ SE",
"55273065", "Serra\ \-\ ES",
"55183289", "Tarabai\ \-\ SP",
"55673478", "Tacuru\ \-\ MS",
"55283533", "Rio\ Novo\ do\ Sul\ \-\ ES",
"55873837", "Iguaraci\ \-\ PE",
"55843379", "Francisco\ Dantas\ \-\ RN",
"55423239", "Ponta\ Grossa\ \-\ PR",
"55743647", "Jussara\ \-\ BA",
"55333243", "Central\ de\ Minas\ \-\ MG",
"55513597", "Campo\ Bom\ \-\ RS",
"55833306", "Coxixola\ \-\ PB",
"55883673", "Itapipoca\ \-\ CE",
"55483254", "Garopaba\ \-\ SC",
"55623381", "Estrela\ do\ Norte\ \-\ GO",
"55114887", "Jarinu\ \-\ SP",
"55173531", "Catanduva\ \-\ SP",
"55873221", "Garanhuns\ \-\ PE",
"55833664", "Santa\ Rita\ \-\ PB",
"55114243", "Cotia\ \-\ SP",
"5511361", "São\ Paulo\ \-\ SP",
"55913441", "Igarapé\-Açu\ \-\ PA",
"55513677", "Dom\ Feliciano\ \-\ RS",
"55114976", "Santo\ André\ \-\ SP",
"55433272", "Jaguapitã\ \-\ PR",
"55143324", "Ourinhos\ \-\ SP",
"55143553", "Guaimbê\ \-\ SP",
"55713652", "São\ Francisco\ do\ Conde\ \-\ BA",
"55893465", "Valença\ do\ Piauí\ \-\ PI",
"55313840", "Minas\ Gerais",
"55983382", "Santa\ Helena\ \-\ MA",
"55923672", "Manaus\ \-\ AM",
"55843220", "Natal\ \-\ RN",
"55643611", "Rio\ Verde\ \-\ GO",
"55453267", "Vera\ Cruz\ do\ Oeste\ \-\ PR",
"55473349", "Itajaí\ \-\ SC",
"55613614", "Novo\ Gama\ \-\ GO",
"55843613", "Natal\ \-\ RN",
"55153373", "Itapetininga\ \-\ SP",
"55833466", "Assunção\ \-\ PB",
"55612328", "Brasília\ \-\ DF",
"55353526", "Passos\ \-\ MG",
"55843327", "Grossos\ \-\ RN",
"55213304", "Belford\ Roxo\ \-\ RJ",
"55115632", "São\ Paulo\ \-\ SP",
"55323052", "Barbacena\ \-\ MG",
"55983224", "São\ José\ de\ Ribamar\ \-\ MA",
"55623455", "Povoado\ de\ São\ Jorge\ \-\ GO",
"55553311", "Santa\ Maria\ \-\ RS",
"55653055", "Cuiabá\ \-\ MT",
"55543207", "São\ Brás\ \-\ RS",
"55553543", "Tuparendi\ \-\ RS",
"55143282", "Duartina\ \-\ SP",
"55823177", "Maceió\ \-\ AL",
"55623494", "Cavalcante\ \-\ GO",
"55623588", "Aparecida\ de\ Goiânia\ \-\ GO",
"55193833", "Paulínia\ \-\ SP",
"55163286", "Ribeirão\ Preto\ \-\ SP",
"55353452", "Careaçu\ \-\ MG",
"55142104", "Jaú\ \-\ SP",
"55813342", "Recife\ \-\ PE",
"55323017", "Juiz\ de\ Fora\ \-\ MG",
"55893473", "Massapê\ do\ Piauí\ \-\ PI",
"55693471", "Presidente\ Médici\ \-\ RO",
"55833553", "Carrapateira\ \-\ PB",
"55533204", "Rio\ Grande\ \-\ RS",
"55313159", "Betim\ \-\ MG",
"55973391", "Tapauá\ \-\ AM",
"55913732", "Acará\ \-\ PA",
"55663442", "Vale\ dos\ Sonhos\ \-\ MT",
"5511285", "São\ Paulo\ \-\ SP",
"55373514", "Abaeté\ \-\ MG",
"55353291", "Alfenas\ \-\ MG",
"55513659", "Rio\ Grande\ do\ Sul",
"55163111", "Franca\ \-\ SP",
"55743551", "Filadélfia\ \-\ BA",
"55193538", "Ajapi\ \-\ SP",
"55483537", "Meleiro\ \-\ SC",
"55473059", "São\ Bento\ do\ Sul\ \-\ SC",
"55453248", "Iguatu\ \-\ PR",
"55443444", "São\ Pedro\ do\ Paraná\ \-\ PR",
"55114789", "Jandira\ \-\ SP",
"55413158", "Campina\ Grande\ do\ Sul\ \-\ PR",
"5522", "Rio\ de\ Janeiro",
"55114638", "Poá\ \-\ SP",
"55213142", "Itaboraí\ \-\ RJ",
"55513744", "Ibarama\ \-\ RS",
"55423625", "Entre\ Rios\ \-\ PR",
"55533256", "Bojuru\ \-\ RS",
"55833282", "Pilar\ \-\ PB",
"55753698", "Santa\ Brígida\ \-\ BA",
"55793445", "Carira\ \-\ SE",
"55753266", "Araci\ \-\ BA",
"55433468", "Rio\ Bom\ \-\ PR",
"55283520", "Piúma\ \-\ ES",
"55323342", "Santa\ Rita\ de\ Ibitipoca\ \-\ MG",
"55983471", "Chapadinha\ \-\ MA",
"55212124", "Duque\ de\ Caxias\ \-\ RJ",
"55793227", "Aracaju\ \-\ SE",
"55613108", "Brasília\ \-\ DF",
"55773687", "Canápolis\ \-\ BA",
"55613962", "Brasília\ \-\ DF",
"55163603", "Ribeirão\ Preto\ \-\ SP",
"55443535", "Jesuítas\ \-\ PR",
"55673230", "Pedro\ Gomes\ \-\ MS",
"55313881", "Ponte\ Nova\ \-\ MG",
"55493549", "Vargem\ \-\ SC",
"55633439", "Itacajá\ \-\ TO",
"55114037", "Pedra\ Bela\ \-\ SP",
"55212670", "Japeri\ \-\ RJ",
"55653345", "Poconé\ \-\ MT",
"55483207", "Florianópolis\ \-\ SC",
"5521261", "Niterói\ \-\ RJ",
"55133298", "Santos\ \-\ SP",
"55114878", "Barueri\ \-\ SP",
"55273254", "Cariacica\ \-\ ES",
"55663547", "Tapurah\ \-\ MT",
"5534", "Minas\ Gerais",
"55623515", "Goiânia\ \-\ GO",
"55513474", "Sapucaia\ do\ Sul\ \-\ RS",
"55193394", "Indaiatuba\ \-\ SP",
"55553265", "Agudo\ \-\ RS",
"55733255", "Camamu\ \-\ BA",
"55543471", "Dois\ Lajeados\ \-\ RS",
"55343669", "Araxá\ \-\ MG",
"55643639", "Perolândia\ \-\ GO",
"55913821", "Peixe\-Boi\ \-\ PA",
"55413675", "Colombo\ \-\ PR",
"55733294", "Itamaraju\ \-\ BA",
"55443668", "Serra\ dos\ Dourados\ \-\ PR",
"55673487", "Vila\ Marques\ \-\ MS",
"55483065", "Florianópolis\ \-\ SC",
"55473533", "Ituporanga\ \-\ SC",
"55493279", "Rio\ Rufino\ \-\ SC",
"55623098", "Anápolis\ \-\ GO",
"55623529", "Brazabrantes\ \-\ GO",
"55483432", "Içara\ \-\ SC",
"55193761", "Campinas\ \-\ SP",
"55733639", "Ilhéus\ \-\ BA",
"55933064", "Santarém\ \-\ PA",
"55633389", "Abreulândia\ \-\ TO",
"55112304", "Guarulhos\ \-\ SP",
"55743646", "Cafarnaum\ \-\ BA",
"55833307", "Caraúbas\ \-\ PB",
"55513596", "Novo\ Hamburgo\ \-\ RS",
"55112784", "São\ Paulo\ \-\ SP",
"55323293", "Liberdade\ \-\ MG",
"55173692", "Santana\ da\ Ponte\ Pensa\ \-\ SP",
"55114886", "Itu\ \-\ SP",
"55823420", "Palmeira\ dos\ Índios\ \-\ AL",
"55753213", "Banzaê\ \-\ BA",
"55343359", "Uberaba\ \-\ MG",
"55163567", "Cajuru\ \-\ SP",
"55933542", "Jacareacanga\ \-\ PA",
"5511443", "Santo\ André\ \-\ SP",
"55193665", "Mococa\ \-\ SP",
"55793256", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55873836", "Sanharó\ \-\ PE",
"55143413", "Marília\ \-\ SP",
"55382102", "Unaí\ \-\ MG",
"55413622", "Lapa\ \-\ PR",
"55493257", "Frei\ Rogério\ \-\ SC",
"55413663", "Colombo\ \-\ PR",
"55813127", "Recife\ \-\ PE",
"55433064", "Londrina\ \-\ PR",
"55663568", "São\ José\ do\ Xingu\ \-\ MT",
"55115819", "São\ Paulo\ \-\ SP",
"55173849", "Macedônia\ \-\ SP",
"55743162", "Juazeiro\ \-\ BA",
"55463539", "Doutor\ Antônio\ Paranhos\ \-\ PR",
"55663401", "Barra\ do\ Garças\ \-\ MT",
"55843298", "São\ Bento\ do\ Trairí\ \-\ RN",
"55443647", "Maripá\ \-\ PR",
"55613303", "Brasília\ \-\ DF",
"55683212", "Rio\ Branco\ \-\ AC",
"55693432", "Rolim\ de\ Moura\ \-\ RO",
"55193673", "Tambaú\ \-\ SP",
"55543537", "Caxias\ do\ Sul\ \-\ RS",
"55433542", "Bandeirantes\ \-\ PR",
"55124448", "Cajamar\ \-\ SP",
"55313094", "Ipatinga\ \-\ MG",
"55943358", "Canaã\ dos\ Carajás\ \-\ PA",
"55423631", "Guarapuava\ \-\ PR",
"55913771", "Mosqueiro\ \-\ PA",
"55113418", "Taboão\ da\ Serra\ \-\ SP",
"55613526", "Brasília\ \-\ DF",
"55174003", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55114573", "Cotia\ \-\ SP",
"55143307", "Ibirarema\ \-\ SP",
"55543382", "Alto\ Alegre\ \-\ RS",
"55493333", "Nova\ Erechim\ \-\ SC",
"55993212", "Timon\ \-\ MA",
"55843356", "Doutor\ Severiano\ \-\ RN",
"55713414", "Salvador\ \-\ BA",
"55813685", "Quipapá\ \-\ PE",
"55753332", "Palmeiras\ \-\ BA",
"55483645", "Armazém\ \-\ SC",
"55313055", "Belo\ Horizonte\ \-\ MG",
"55163952", "Pitangueiras\ \-\ SP",
"55773484", "Santana\ \-\ BA",
"55443048", "Sarandi\ \-\ PR",
"55443521", "Goioerê\ \-\ PR",
"55543702", "Bento\ Gonçalves\ \-\ RS",
"55222633", "Armação\ dos\ Búzios\ \-\ RJ",
"55793483", "Nossa\ Senhora\ Aparecida\ \-\ SE",
"55212765", "Nova\ Iguaçu\ \-\ RJ",
"55273224", "Vitória\ \-\ ES",
"55483536", "Timbé\ do\ Sul\ \-\ SC",
"55863363", "Buriti\ dos\ Lopes\ \-\ PI",
"55733225", "Igrapiúna\ \-\ BA",
"55313433", "Belo\ Horizonte\ \-\ MG",
"55913617", "Cotijuba\ \-\ PA",
"55773678", "Botuporã\ \-\ BA",
"55333728", "Bandeira\ \-\ MG",
"55473334", "Blumenau\ \-\ SC",
"55193325", "Campinas\ \-\ SP",
"55193593", "Descalvado\ \-\ SP",
"55643447", "Corumbaíba\ \-\ GO",
"55383564", "Ruralminas\ I\ \-\ MG",
"55473520", "Rio\ do\ Sul\ \-\ SC",
"55653383", "Sapezal\ \-\ MT",
"55853381", "Maracanaú\ \-\ CE",
"55114693", "Guararema\ \-\ SP",
"55893569", "Santa\ Filomena\ \-\ PI",
"55773686", "Serra\ Dourada\ \-\ BA",
"55733272", "Ibicuí\ \-\ BA",
"55373271", "Pitangui\ \-\ MG",
"55323461", "Angustura\ \-\ MG",
"55713616", "Salvador\ \-\ BA",
"55353842", "Nazareno\ \-\ MG",
"55163513", "Sertãozinho\ \-\ SP",
"5543332", "Londrina\ \-\ PR",
"55114036", "Piracaia\ \-\ SP",
"55753650", "Nordestina\ \-\ BA",
"55173201", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55412103", "Curitiba\ \-\ PR",
"55383623", "Januária\ \-\ MG",
"55493632", "Tunápolis\ \-\ SC",
"55533257", "Piratini\ \-\ RS",
"55114132", "Pirapora\ do\ Bom\ Jesus\ \-\ SP",
"55753267", "Biritinga\ \-\ BA",
"55163341", "Ibitinga\ \-\ SP",
"55913323", "Belém\ \-\ PA",
"55413652", "Rio\ Branco\ do\ Sul\ \-\ PR",
"55513492", "Viamão\ \-\ RS",
"55112503", "São\ Paulo\ \-\ SP",
"55113443", "São\ Paulo\ \-\ SP",
"55993534", "Davinópolis\ \-\ MA",
"55273382", "Vitória\ \-\ ES",
"55833448", "Bom\ Sucesso\ \-\ PB",
"55963421", "Amapá\ \-\ AP",
"55863284", "Barro\ Duro\ \-\ PI",
"55193481", "São\ Pedro\ \-\ SP",
"55613504", "Cristalina\ \-\ GO",
"55883538", "Potengi\ \-\ CE",
"55163818", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55224104", "Macaé\ \-\ RJ",
"55493445", "Abelardo\ Luz\ \-\ SC",
"55453266", "Céu\ Azul\ \-\ PR",
"55633535", "Marianópolis\ do\ Tocantins\ \-\ TO",
"55793549", "Poço\ Verde\ \-\ SE",
"55353641", "Brasópolis\ \-\ MG",
"55115855", "São\ Paulo\ \-\ SP",
"55823025", "Maceió\ \-\ AL",
"55543295", "Gramado\ \-\ RS",
"55163975", "Ribeirão\ Preto\ \-\ SP",
"55383662", "Buritis\ \-\ MG",
"55513676", "Arambaré\ \-\ RS",
"55973334", "Canutama\ \-\ AM",
"55173572", "Pindorama\ \-\ SP",
"55743535", "Remanso\ \-\ BA",
"55192105", "Piracicaba\ \-\ SP",
"55613475", "Brasília\ \-\ DF",
"55943328", "Núcleo\ Carajás\ \-\ PA",
"55373424", "Córrego\ Danta\ \-\ MG",
"55342109", "Araguari\ \-\ MG",
"55633444", "Axixá\ do\ Tocantins\ \-\ TO",
"55153244", "Piedade\ \-\ SP",
"55493534", "Ibiam\ \-\ SC",
"55163287", "Vista\ Alegre\ do\ Alto\ \-\ SP",
"55833467", "São\ José\ do\ Sabugi\ \-\ PB",
"55353527", "Bom\ Jesus\ dos\ Campos\ \-\ MG",
"55513739", "Rio\ Grande\ do\ Sul",
"55843326", "Tibau\ \-\ RN",
"55514062", "Porto\ Alegre\ \-\ RS",
"55173525", "Catanduva\ \-\ SP",
"55114374", "Carapicuíba\ \-\ SP",
"55513688", "Rio\ Grande\ do\ Sul",
"55443551", "Iracema\ do\ Oeste\ \-\ PR",
"55693536", "Ariquemes\ \-\ RO",
"55993632", "Lago\ dos\ Rodrigues\ \-\ MA",
"55753248", "Coração\ de\ Maria\ \-\ BA",
"55943013", "Parauapebas\ \-\ PA",
"55863322", "Parnaíba\ \-\ PI",
"55213667", "Duque\ de\ Caxias\ \-\ RJ",
"55413554", "Quatro\ Barras\ \-\ PR",
"55193898", "Lindóia\ \-\ SP",
"55653321", "Cuiabá\ \-\ MT",
"55413472", "Guaratuba\ \-\ PR",
"55843285", "Várzea\ \-\ RN",
"55493343", "Formosa\ do\ Sul\ \-\ SC",
"55853323", "Tejuçuoca\ \-\ CE",
"55443038", "Umuarama\ \-\ PR",
"55483003", "Florianópolis\ \-\ SC",
"55513563", "Ivoti\ \-\ RS",
"55213171", "Rio\ de\ Janeiro\ \-\ RJ",
"55913605", "Anajás\ \-\ PA",
"55183284", "Rosana\ \-\ SP",
"55423234", "Colônia\ Castrolanda\ \-\ PR",
"5583", "Paraiba",
"55433532", "Cambará\ \-\ PR",
"55693442", "Rolim\ de\ Moura\ \-\ RO",
"55843374", "Riacho\ da\ Cruz\ \-\ RN",
"55943222", "Marabá\ \-\ PA",
"55133036", "Santos\ \-\ SP",
"55183375", "Pedrinhas\ Paulista\ \-\ SP",
"555132", "Porto\ Alegre\ \-\ RS",
"55483259", "São\ José\ \-\ SC",
"55663471", "Alto\ Garças\ \-\ MT",
"55463549", "Realeza\ \-\ PR",
"55173839", "Parisi\ \-\ SP",
"55513170", "Estância\ Velha\ \-\ RS",
"55443637", "Cianorte\ \-\ PR",
"55353211", "Passos\ \-\ MG",
"55773458", "Brumado\ \-\ BA",
"55513624", "Santa\ Terezinha\ \-\ RS",
"55183322", "Assis\ \-\ SP",
"55123301", "Lorena\ \-\ SP",
"55153557", "Itaóca\ \-\ SP",
"55323371", "São\ João\ Del\ Rei\ \-\ MG",
"55143377", "São\ Pedro\ do\ Turvo\ \-\ SP",
"55833359", "Congo\ \-\ PB",
"5554331", "Passo\ Fundo\ \-\ RS",
"55933532", "Uruará\ \-\ PA",
"55333298", "Açucena\ \-\ MG",
"55493030", "Concórdia\ \-\ SC",
"55513404", "Rio\ Grande\ do\ Sul",
"55613365", "Brasília\ \-\ DF",
"55313335", "Belo\ Horizonte\ \-\ MG",
"55543401", "Farroupilha\ \-\ RS",
"55114808", "Jundiaí\ \-\ SP",
"55273288", "Marechal\ Floriano\ \-\ ES",
"55623085", "Aparecida\ de\ Goiânia\ \-\ GO",
"55813753", "São\ Joaquim\ do\ Monte\ \-\ PE",
"55873846", "Triunfo\ \-\ PE",
"55483277", "São\ Pedro\ de\ Alcântara\ \-\ SC",
"55793113", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55463226", "Mariópolis\ \-\ PR",
"55243332", "Rio\ Claro\ \-\ RJ",
"55212682", "Seropédica\ \-\ RJ",
"55273755", "Ecoporanga\ \-\ ES",
"5515301", "Sorocaba\ \-\ SP",
"55743636", "Caém\ \-\ BA",
"55513575", "São\ Leopoldo\ \-\ RS",
"55413605", "Colombo\ \-\ PR",
"55793274", "Rosário\ do\ Catete\ \-\ SE",
"55823269", "Pólo\ Cloroquímico\ de\ Alagoas\ \-\ AL",
"55543568", "Ponte\ Preta\ \-\ RS",
"55192117", "Campinas\ \-\ SP",
"55273361", "Guarapari\ \-\ ES",
"55413033", "Pinhais\ \-\ PR",
"5511369", "Osasco\ \-\ SP",
"55333356", "São\ João\ do\ Oriente\ \-\ MG",
"55473543", "Rio\ do\ Oeste\ \-\ SC",
"55323753", "Miradouro\ \-\ MG",
"55273276", "Guaraná\ \-\ ES",
"55883513", "Crato\ \-\ CE",
"55183653", "Penápolis\ \-\ SP",
"55513456", "Canoas\ \-\ RS",
"55443275", "Barbosa\ Ferraz\ \-\ PR",
"55813482", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55833377", "Dona\ Inês\ \-\ PB",
"55134002", "Santos\ \-\ SP",
"55483442", "Criciúma\ \-\ SC",
"55663537", "Nova\ Maringá\ \-\ MT",
"55313269", "Belo\ Horizonte\ \-\ MG",
"55513522", "Morro\ da\ Pedra\ \-\ RS",
"55643649", "Castelândia\ \-\ GO",
"55643691", "Vicentinópolis\ \-\ GO",
"55183999", "Estrela\ do\ Norte\ \-\ SP",
"55683343", "Mâncio\ Lima\ \-\ AC",
"55182102", "Araçatuba\ \-\ SP",
"55853362", "Aquiraz\ \-\ CE",
"55843693", "Touros\ \-\ RN",
"55913425", "Bragança\ \-\ PA",
"55343413", "São\ Francisco\ de\ Sales\ \-\ MG",
"55183941", "Espigão\ \-\ SP",
"55853353", "Uruburetama\ \-\ CE",
"55543288", "Gramado\ \-\ RS",
"55653351", "Nossa\ Senhora\ do\ Livramento\ \-\ MT",
"55483215", "Florianópolis\ \-\ SC",
"55383228", "Coração\ de\ Jesus\ \-\ MG",
"55513749", "Palanque\ \-\ RS",
"55353735", "Caldas\ \-\ MG",
"55923512", "Borba\ \-\ AM",
"55713431", "Salvador\ \-\ BA",
"55273401", "Baixo\ Guandu\ \-\ ES",
"55643571", "Palmeiras\ de\ Goiás\ \-\ GO",
"55863258", "Monsenhor\ Gil\ \-\ PI",
"55753238", "Terra\ Nova\ \-\ BA",
"55693546", "Nova\ Dimensão\ \-\ RO",
"55993642", "Pedreiras\ \-\ MA",
"55433436", "Cambira\ \-\ PR",
"55613574", "Brasília\ \-\ DF",
"55543361", "Sarandi\ \-\ RS",
"55213976", "Rio\ de\ Janeiro\ \-\ RJ",
"5531350", "Minas\ Gerais",
"55553015", "Santa\ Maria\ \-\ RS",
"55513606", "Rondinha\ Velha\ \-\ RS",
"55493544", "Campos\ Novos\ \-\ SC",
"55633434", "Juarina\ \-\ TO",
"55413576", "Curitiba\ \-\ PR",
"55212703", "Niterói\ \-\ RJ",
"55113188", "São\ Paulo\ \-\ SP",
"55843392", "Antônio\ Martins\ \-\ RN",
"55833315", "Campina\ Grande\ \-\ PB",
"55142109", "Bauru\ \-\ SP",
"55952121", "Boa\ Vista\ \-\ RR",
"55513695", "Harmonia\ \-\ RS",
"55543276", "Protásio\ Alves\ \-\ RS",
"55353244", "Cordislândia\ \-\ MG",
"55123157", "Lorena\ \-\ SP",
"55163996", "Ribeirão\ Preto\ \-\ SP",
"55413455", "Pontal\ do\ Paraná\ \-\ PR",
"55313589", "Nova\ Lima\ \-\ MG",
"55193885", "Indaiatuba\ \-\ SP",
"55413588", "São\ José\ dos\ Pinhais\ \-\ PR",
"55114784", "São\ Roque\ \-\ SP",
"55883548", "Altaneira\ \-\ CE",
"55153527", "Itapetininga\ \-\ SP",
"55813873", "Araripina\ \-\ PE",
"55114666", "Itapecerica\ da\ Serra\ \-\ SP",
"55513654", "Triunfo\ \-\ RS",
"55112886", "São\ Paulo\ \-\ SP",
"55473054", "Jaraguá\ do\ Sul\ \-\ SC",
"55813762", "Garanhuns\ \-\ PE",
"55373525", "Moema\ \-\ MG",
"55193566", "Analândia\ \-\ SP",
"5567342", "Dourados\ \-\ MS",
"55192122", "Campinas\ \-\ SP",
"55493435", "Ponte\ Serrada\ \-\ SC",
"55453301", "Cascavel\ \-\ PR",
"55753022", "Feira\ de\ Santana\ \-\ BA",
"55443252", "Nova\ Esperança\ \-\ PR",
"55114142", "Itapevi\ \-\ SP",
"55993544", "Loreto\ \-\ MA",
"55113433", "Embu\ das\ Artes\ \-\ SP",
"55153416", "Votorantim\ \-\ SP",
"55833438", "Condado\ \-\ PB",
"55123112", "Potim\ \-\ SP",
"55313590", "Minas\ Gerais",
"55813723", "Caruaru\ \-\ PE",
"55213789", "Mangaratiba\ \-\ RJ",
"55983229", "Raposa\ \-\ MA",
"55623441", "Catalão\ \-\ GO",
"55413020", "Curitiba\ \-\ PR",
"55753643", "Valença\ \-\ BA",
"55513283", "Novo\ Hamburgo\ \-\ RS",
"55554001", "Santa\ Maria\ \-\ RS",
"55273725", "Itaguaçu\ \-\ ES",
"55493642", "Guarujá\ do\ Sul\ \-\ SC",
"55873966", "Exu\ \-\ PE",
"55112392", "São\ Paulo\ \-\ SP",
"55413883", "Curitiba\ \-\ PR",
"55193453", "Limeira\ \-\ SP",
"55353832", "Campo\ Belo\ \-\ MG",
"55943491", "Redenção\ \-\ PA",
"55433560", "Cornélio\ Procópio\ \-\ PR",
"5522252", "Nova\ Friburgo\ \-\ RJ",
"55913494", "Muaná\ \-\ PA",
"55613625", "Cidade\ Ocidental\ \-\ GO",
"55323723", "Rosário\ da\ Limeira\ \-\ MG",
"55213037", "Nova\ Iguaçu\ \-\ RJ",
"55333326", "Santa\ Bárbara\ do\ Leste\ \-\ MG",
"55173271", "Neves\ Paulista\ \-\ SP",
"55223828", "Boaventura\ \-\ RJ",
"55163820", "Orlândia\ \-\ SP",
"55513426", "Canoas\ \-\ RS",
"55373201", "Itaúna\ \-\ MG",
"55183861", "Irapuru\ \-\ SP",
"55183623", "Araçatuba\ \-\ SP",
"55733202", "Barra\ do\ Rocha\ \-\ BA",
"55323578", "Guidoval\ \-\ MG",
"55513552", "Lindolfo\ Collor\ \-\ RS",
"55193302", "Piracicaba\ \-\ SP",
"55133392", "Guarujá\ \-\ SP",
"55483546", "Ermo\ \-\ SC",
"55222643", "Cabo\ Frio\ \-\ RJ",
"55473344", "Itajaí\ \-\ SC",
"55273772", "Nova\ Venécia\ \-\ ES",
"55613619", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55313443", "Minas\ Gerais",
"55883567", "Ipaumirim\ \-\ CE",
"55414064", "Paranaguá\ \-\ PR",
"55843637", "Bento\ Fernandes\ \-\ RN",
"55133384", "Guarujá\ \-\ SP",
"55553251", "Santiago\ \-\ RS",
"55413698", "Almirante\ Tamandaré\ \-\ PR",
"55983399", "Mirinzal\ \-\ MA",
"55673232", "Corumbá\ \-\ MS",
"55373262", "Lagoa\ da\ Prata\ \-\ MG",
"55733261", "Eunápolis\ \-\ BA",
"55123663", "Campos\ do\ Jordão\ \-\ SP",
"55773624", "Riachão\ das\ Neves\ \-\ BA",
"55274105", "Vila\ Velha\ \-\ ES",
"55513458", "Esteio\ \-\ RS",
"55483287", "Florianópolis\ \-\ SC",
"55273278", "Acioli\ \-\ ES",
"55663593", "Apiacás\ \-\ MT",
"55193794", "Campinas\ \-\ SP",
"55212721", "Niterói\ \-\ RJ",
"55183421", "Assis\ \-\ SP",
"55114895", "Nazaré\ Paulista\ \-\ SP",
"55913482", "Augusto\ Corrêa\ \-\ PA",
"55313234", "Minas\ Gerais",
"55613264", "Brasília\ \-\ DF",
"55843263", "Touros\ \-\ RN",
"55283522", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55823527", "Craíbas\ \-\ AL",
"55973412", "Tabatinga\ \-\ AM",
"55833280", "Salgado\ de\ São\ Félix\ \-\ PB",
"55513585", "Campo\ Bom\ \-\ RS",
"55614101", "Brasília\ \-\ DF",
"55313641", "Santa\ Luzia\ \-\ MG",
"55813419", "Recife\ \-\ PE",
"55193361", "Mogi\-Guaçu\ \-\ SP",
"55162133", "Ribeirão\ Preto\ \-\ SP",
"55423901", "Ponta\ Grossa\ \-\ PR",
"55112704", "São\ Paulo\ \-\ SP",
"55193817", "Amparo\ \-\ SP",
"55242437", "Ipiabas\ \-\ RJ",
"55383825", "Montezuma\ \-\ MG",
"55793322", "Propriá\ \-\ SE",
"55114806", "Jundiaí\ \-\ SP",
"55473457", "Barra\ Velha\ \-\ SC",
"55883635", "Irauçuba\ \-\ CE",
"55873848", "Custódia\ \-\ PE",
"55323425", "Santana\ de\ Cataguases\ \-\ MG",
"55644052", "Itumbiara\ \-\ GO",
"55693341", "Colorado\ do\ Oeste\ \-\ RO",
"55333296", "Sardoá\ \-\ MG",
"55453323", "Cascavel\ \-\ PR",
"55833387", "São\ Sebastião\ de\ Lagoa\ de\ Roça\ \-\ PB",
"55813472", "Recife\ \-\ PE",
"55753441", "Aporá\ \-\ BA",
"55623643", "Goiânia\ \-\ GO",
"55913753", "Barcarena\ \-\ PA",
"55823641", "Delmiro\ Gouveia\ \-\ AL",
"55464054", "Francisco\ Beltrão\ \-\ PR",
"5543", "Paraná",
"5561324", "Brasília\ \-\ DF",
"55823234", "Maceió\ \-\ AL",
"55554062", "Santa\ Maria\ \-\ RS",
"55833532", "Cajazeiras\ \-\ PB",
"55553739", "Taquaruçu\ do\ Sul\ \-\ RS",
"55313527", "Minas\ Gerais",
"55193651", "Espírito\ Santo\ do\ Pinhal\ \-\ SP",
"55333521", "Teófilo\ Otoni\ \-\ MG",
"55853461", "Fortaleza\ \-\ CE",
"55193852", "Pedreira\ \-\ SP",
"55883442", "Madalena\ \-\ CE",
"55353433", "Camanducaia\ \-\ MG",
"55843275", "Vera\ Cruz\ \-\ RN",
"55413482", "Guaraqueçaba\ \-\ PR",
"55273111", "Aracruz\ \-\ ES",
"55183274", "Teçaindá\ \-\ SP",
"55673028", "Campo\ Grande\ \-\ MS",
"55673541", "Bataguassu\ \-\ MS",
"55483341", "Palhoça\ \-\ SC",
"55183705", "Guaraçaí\ \-\ SP",
"55843384", "Pilões\ \-\ RN",
"55613383", "Brasília\ \-\ DF",
"55613703", "Brasília\ \-\ DF",
"55222732", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55663481", "Alto\ Araguaia\ \-\ MT",
"55773456", "Urandi\ \-\ BA",
"55793363", "Canhoba\ \-\ SE",
"55114013", "Itu\ \-\ SP",
"55452103", "Toledo\ \-\ PR",
"55313842", "Coronel\ Fabriciano\ \-\ MG",
"55143532", "Lins\ \-\ SP",
"55713633", "Vera\ Cruz\ \-\ BA",
"55843222", "Natal\ \-\ RN",
"55753616", "Feira\ de\ Santana\ \-\ BA",
"55323696", "Muriaé\ \-\ MG",
"5593", "Pará",
"55313061", "Conselheiro\ Lafaiete\ \-\ MG",
"55383722", "Curvelo\ \-\ MG",
"55213434", "Rio\ de\ Janeiro\ \-\ RJ",
"55383671", "Paracatu\ \-\ MG",
"55813033", "Recife\ \-\ PE",
"55833299", "Pitimbu\ \-\ PB",
"55143387", "Sarutaiá\ \-\ SP",
"55173561", "Novais\ \-\ SP",
"55713267", "Salvador\ \-\ BA",
"55833634", "Casserengue\ \-\ PB",
"55183601", "Bento\ de\ Abreu\ \-\ SP",
"55433270", "Santa\ Cecília\ do\ Pavão\ \-\ PR",
"55513114", "Guaíba\ \-\ RS",
"55513428", "Rio\ Grande\ do\ Sul",
"55433315", "Londrina\ \-\ PR",
"55212751", "São\ João\ de\ Meriti\ \-\ RJ",
"55333328", "Alvarenga\ \-\ MG",
"55213779", "Nova\ Iguaçu\ \-\ RJ",
"55823557", "Piaçabuçu\ \-\ AL",
"55893435", "Francisco\ Macedo\ \-\ PI",
"55283552", "Alegre\ \-\ ES",
"55853301", "Beberibe\ \-\ CE",
"55483952", "Florianópolis\ \-\ SC",
"55453237", "Lindoeste\ \-\ PR",
"55483548", "Passo\ de\ Torres\ \-\ SC",
"55193547", "Araras\ \-\ SP",
"55323576", "Dores\ do\ Turvo\ \-\ MG",
"55984009", "São\ Luís\ \-\ MA",
"55343611", "Araxá\ \-\ MG",
"55773695", "Tanque\ Novo\ \-\ BA",
"55413873", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55543035", "Farroupilha\ \-\ RS",
"55623921", "Goiânia\ \-\ GO",
"55473427", "Joinville\ \-\ SC",
"55793352", "Neópolis\ \-\ SE",
"55212655", "São\ João\ de\ Meriti\ \-\ RJ",
"55173281", "Olímpia\ \-\ SP",
"55443573", "Iretama\ \-\ PR",
"55143214", "Bauru\ \-\ SP",
"55833436", "Vista\ Serrana\ \-\ PB",
"55414121", "Fazenda\ Rio\ Grande\ \-\ PR",
"55543462", "Garibaldi\ \-\ RS",
"55222760", "Rio\ das\ Ostras\ \-\ RJ",
"55694009", "Porto\ Velho\ \-\ RO",
"55913723", "Marapanim\ \-\ PA",
"55813576", "Sirinhaém\ \-\ PE",
"55273302", "Aracruz\ \-\ ES",
"55114048", "Diadema\ \-\ SP",
"55893544", "Uruçuí\ \-\ PI",
"55753414", "Cachoeira\ \-\ BA",
"55313557", "Mariana\ \-\ MG",
"55733540", "Presidente\ Tancredo\ Neves\ \-\ BA",
"55193621", "Americana\ \-\ SP",
"55193863", "Itapira\ \-\ SP",
"55193772", "Campinas\ \-\ SP",
"55493316", "Chapecó\ \-\ SC",
"55123018", "São\ José\ dos\ Campos\ \-\ SP",
"5571349", "Salvador\ \-\ BA",
"55193822", "Sumaré\ \-\ SP",
"55543278", "Canela\ \-\ RS",
"55643581", "Itumbiara\ \-\ GO",
"55193401", "Piracicaba\ \-\ SP",
"55484009", "Florianópolis\ \-\ SC",
"55133491", "Praia\ Grande\ \-\ SP",
"55653291", "Cáceres\ \-\ MT",
"55153335", "Sorocaba\ \-\ SP",
"55115042", "São\ Paulo\ \-\ SP",
"55173012", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"5553327", "Pelotas\ \-\ RS",
"55114668", "Itapecerica\ da\ Serra\ \-\ SP",
"55413586", "São\ José\ dos\ Pinhais\ \-\ PR",
"55943392", "Canaã\ dos\ Carajás\ \-\ PA",
"55652123", "Cuiabá\ \-\ MT",
"55553505", "Alegrete\ \-\ RS",
"55883546", "Nova\ Olinda\ \-\ CE",
"55313512", "Betim\ \-\ MG",
"55223308", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55753236", "Santa\ Bárbara\ \-\ BA",
"55863256", "Alto\ Longá\ \-\ PI",
"55113178", "São\ Paulo\ \-\ SP",
"55343812", "Lagamar\ \-\ MG",
"55543286", "Gramado\ \-\ RS",
"55383226", "Coração\ de\ Jesus\ \-\ MG",
"55114205", "Itapevi\ \-\ SP",
"55193875", "Indaiatuba\ \-\ SP",
"55623342", "Ipiranga\ de\ Goiás\ \-\ GO",
"55843252", "Sítio\ Novo\ \-\ RN",
"55313579", "Aranha\ \-\ MG",
"55513608", "Rio\ Grande\ do\ Sul",
"55443565", "Tuneiras\ do\ Oeste\ \-\ PR",
"55114774", "Itapevi\ \-\ SP",
"55673260", "Alcinópolis\ \-\ MS",
"55283517", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55112876", "Carapicuíba\ \-\ SP",
"55973427", "Juruá\ \-\ AM",
"55213978", "Rio\ de\ Janeiro\ \-\ RJ",
"55114067", "Diadema\ \-\ SP",
"55123652", "Caçapava\ \-\ SP",
"55353345", "Carvalhos\ \-\ MG",
"55163432", "Franca\ \-\ SP",
"55173347", "Jaborandi\ \-\ SP",
"55633469", "Goiatins\ \-\ TO",
"55543319", "Montauri\ \-\ RS",
"55133048", "São\ Vicente\ \-\ SP",
"55173486", "Álvares\ Florence\ \-\ SP",
"55613041", "Brasília\ \-\ DF",
"55743667", "Piritiba\ \-\ BA",
"55633233", "Palmas\ \-\ TO",
"55113416", "Taboão\ da\ Serra\ \-\ SP",
"55333263", "Resplendor\ \-\ MG",
"55943356", "Parauapebas\ \-\ PA",
"55624011", "Goiânia\ \-\ GO",
"55833644", "Tenório\ \-\ PB",
"55112647", "São\ Paulo\ \-\ SP",
"55313832", "Santa\ Bárbara\ \-\ MG",
"55813622", "Carpina\ \-\ PE",
"55813771", "Bom\ Conselho\ \-\ PE",
"55843358", "Rafael\ Fernandes\ \-\ RN",
"55514001", "Porto\ Alegre\ \-\ RS",
"55623248", "Aparecida\ de\ Goiânia\ \-\ GO",
"55143542", "Promissão\ \-\ SP",
"55543325", "São\ José\ do\ Herval\ \-\ RS",
"55193683", "Santa\ Cruz\ das\ Palmeiras\ \-\ SP",
"55553426", "Alegrete\ \-\ RS",
"55663566", "Juína\ \-\ MT",
"55433904", "Cornélio\ Procópio\ \-\ PR",
"55913781", "Cametá\ \-\ PA",
"55653625", "Cuiabá\ \-\ MT",
"5521346", "Rio\ de\ Janeiro\ \-\ RJ",
"55112521", "São\ Paulo\ \-\ SP",
"55543372", "Marcelino\ Ramos\ \-\ RS",
"55353443", "Jacutinga\ \-\ MG",
"55883432", "Icapuí\ \-\ CE",
"55653619", "Cuiabá\ \-\ MT",
"55633357", "Formoso\ do\ Araguaia\ \-\ TO",
"55463564", "Salgado\ Filho\ \-\ PR",
"55863292", "Amarante\ \-\ PI",
"55183722", "Andradina\ \-\ SP",
"55623983", "Aparecida\ de\ Goiânia\ \-\ GO",
"55813675", "Barreiros\ \-\ PE",
"55115931", "São\ Paulo\ \-\ SP",
"55773474", "Feira\ da\ Mata\ \-\ BA",
"55553552", "Vista\ Gaúcha\ \-\ RS",
"55114888", "Joanópolis\ \-\ SP",
"55112668", "Mogi\ das\ Cruzes\ \-\ SP",
"55753431", "Inhambupe\ \-\ BA",
"55313735", "Jeceaba\ \-\ MG",
"55173262", "Nova\ Granada\ \-\ SP",
"55833542", "Santa\ Helena\ \-\ PB",
"55473629", "Bela\ Vista\ do\ Toldo\ \-\ SC",
"55743648", "Ibipeba\ \-\ BA",
"55513484", "Gravataí\ \-\ RS",
"55613351", "Taguatinga\ \-\ DF",
"55553791", "Palmitinho\ \-\ RS",
"55513598", "Campo\ Bom\ \-\ RS",
"55183872", "Ouro\ Verde\ \-\ SP",
"55873838", "Afogados\ da\ Ingazeira\ \-\ PE",
"55883645", "Coreaú\ \-\ CE",
"55542105", "Bento\ Gonçalves\ \-\ RS",
"55813524", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55413685", "Paiol\ de\ Baixo\ \-\ PR",
"55273355", "Vitória\ \-\ ES",
"55493289", "Lages\ \-\ SC",
"55843521", "Macau\ \-\ RN",
"55242447", "Barra\ do\ Piraí\ \-\ RJ",
"55124611", "Cotia\ \-\ SP",
"55273761", "São\ Mateus\ \-\ ES",
"55222559", "São\ Sebastião\ do\ Alto\ \-\ RJ",
"55143644", "Igaraçu\ do\ Tietê\ \-\ SP",
"55242225", "Petrópolis\ \-\ RJ",
"55193933", "Paulínia\ \-\ SP",
"55343241", "Araguari\ \-\ MG",
"55633379", "Caseara\ \-\ TO",
"55313244", "Minas\ Gerais",
"55519", "Rio\ Grande\ do\ Sul",
"55323353", "Dores\ de\ Campos\ \-\ MG",
"55534007", "Pelotas\ \-\ RS",
"55663302", "Rondonópolis\ \-\ MT",
"55114217", "Atibaia\ \-\ SP",
"55323330", "Correia\ de\ Almeida\ \-\ MG",
"55813821", "Recife\ \-\ PE",
"55643664", "Doverlândia\ \-\ GO",
"55133296", "Santos\ \-\ SP",
"55673242", "Miranda\ \-\ MS",
"5598325", "São\ Luís\ \-\ MA",
"55623096", "Goiânia\ \-\ GO",
"55843647", "Parnamirim\ \-\ RN",
"55443304", "Maringá\ \-\ PR",
"55124715", "Alumínio\ \-\ SP",
"55773221", "Itapetinga\ \-\ BA",
"55114449", "Franco\ da\ Rocha\ \-\ SP",
"55443666", "Herculândia\ \-\ PR",
"55913803", "Bonito\ \-\ PA",
"55843013", "Natal\ \-\ RN",
"55863274", "Brasileira\ \-\ PI",
"55963322", "Pedra\ Branca\ do\ Amaparí\ \-\ AP",
"55543394", "Santo\ Antônio\ do\ Palma\ \-\ RS",
"55673429", "Vila\ Macaúba\ \-\ MS",
"55642104", "Rio\ Verde\ \-\ GO",
"55112895", "São\ Paulo\ \-\ SP",
"55623587", "Aparecida\ de\ Goiânia\ \-\ GO",
"55773492", "Presidente\ Jânio\ Quadros\ \-\ BA",
"55943326", "Rondon\ do\ Pará\ \-\ PA",
"55713052", "Salvador\ \-\ BA",
"55413112", "Curitiba\ \-\ PR",
"55653365", "Cuiabá\ \-\ MT",
"55353335", "Conceição\ do\ Rio\ Verde\ \-\ MG",
"55863385", "São\ João\ do\ Arraial\ \-\ PI",
"55513764", "Cruzeiro\ do\ Sul\ \-\ RS",
"5531358", "Minas\ Gerais",
"55193896", "Santo\ Antônio\ de\ Posse\ \-\ SP",
"55813652", "Camutanga\ \-\ PE",
"55433151", "Sabáudia\ \-\ PR",
"55513686", "Magistério\ \-\ RS",
"55733011", "Teixeira\ de\ Freitas\ \-\ BA",
"55793465", "São\ Miguel\ do\ Aleixo\ \-\ SE",
"55143879", "Bauru\ \-\ SP",
"55753246", "São\ Gonçalo\ dos\ Campos\ \-\ BA",
"55543355", "Ibiraiaras\ \-\ RS",
"55513077", "Canoas\ \-\ RS",
"55623332", "Silvânia\ \-\ GO",
"55323362", "Barbacena\ \-\ MG",
"55212303", "Rio\ de\ Janeiro\ \-\ RJ",
"55613485", "Sobradinho\ \-\ DF",
"55113512", "São\ Paulo\ \-\ SP",
"55843328", "Governador\ Dix\-Sept\ Rosado\ \-\ RN",
"55453268", "Santa\ Helena\ \-\ PR",
"55443464", "São\ Pedro\ do\ Paraná\ \-\ PR",
"55143812", "São\ Manuel\ \-\ SP",
"5548322", "Florianópolis\ \-\ SC",
"55114275", "Mairiporã\ \-\ SP",
"55193805", "Mogi\ Mirim\ \-\ SP",
"55883536", "Lavras\ da\ Mangabeira\ \-\ CE",
"55213162", "Nilópolis\ \-\ RJ",
"55653694", "Várzea\ Grande\ \-\ MT",
"55534141", "Pelotas\ \-\ RS",
"55813362", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55663603", "Aripuanã\ \-\ MT",
"55923019", "Manaus\ \-\ AM",
"55553522", "Três\ Passos\ \-\ RS",
"55114704", "Embu\ das\ Artes\ \-\ SP",
"55115032", "São\ Paulo\ \-\ SP",
"55173253", "Mirassol\ \-\ SP",
"55983538", "Açailândia\ \-\ MA",
"55513678", "Cristal\ \-\ RS",
"55133854", "Cajati\ \-\ SP",
"55112806", "Diadema\ \-\ SP",
"55114038", "Campo\ Limpo\ Paulista\ \-\ SP",
"55553563", "São\ Paulo\ das\ Missões\ \-\ RS",
"55663423", "Rondonópolis\ \-\ MT",
"55513059", "Canoas\ \-\ RS",
"55733530", "Entroncamento\ de\ Jaguaquara\ \-\ BA",
"55773688", "Novo\ Paraná\ \-\ BA",
"55273325", "Vitória\ \-\ ES",
"55613107", "Brasília\ \-\ DF",
"55543045", "Passo\ Fundo\ \-\ RS",
"55333583", "Pescador\ \-\ MG",
"55242255", "Três\ Rios\ \-\ RJ",
"55753697", "Serra\ Preta\ \-\ BA",
"55433467", "Rio\ Branco\ do\ Ivaí\ \-\ PR",
"55853371", "Maracanaú\ \-\ CE",
"55993569", "Senador\ Alexandre\ Costa\ \-\ MA",
"55323323", "São\ João\ Del\ Rei\ \-\ MG",
"55333726", "Jordânia\ \-\ MG",
"55313211", "Minas\ Gerais",
"55183855", "Monte\ Castelo\ \-\ SP",
"55893445", "Santa\ Cruz\ do\ Piauí\ \-\ PI",
"55313860", "Minas\ Gerais",
"55373281", "Santo\ Antônio\ do\ Monte\ \-\ MG",
"55733282", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55413157", "Quatro\ Barras\ \-\ PR",
"55843439", "Bodó\ \-\ RN",
"55193537", "Ipeúna\ \-\ SP",
"55684007", "Rio\ Branco\ \-\ AC",
"55453247", "Penha\ \-\ PR",
"55483538", "Balneário\ Bela\ Torres\ \-\ SC",
"55193702", "Limeira\ \-\ SP",
"55913461", "Colares\ \-\ PA",
"5598322", "São\ Luís\ \-\ MA",
"55333252", "Joanésia\ \-\ MG",
"55273372", "Linhares\ \-\ ES",
"55323554", "Ervália\ \-\ MG",
"55143103", "Bauru\ \-\ SP",
"55423025", "Ponta\ Grossa\ \-\ PR",
"55542991", "Caxias\ do\ Sul\ \-\ RS",
"55463902", "Pato\ Branco\ \-\ PR",
"55513550", "Rio\ Grande\ do\ Sul",
"55673476", "Itaquiraí\ \-\ MS",
"55983673", "Brejo\ de\ Areia\ \-\ MA",
"55213895", "Rio\ de\ Janeiro\ \-\ RJ",
"55273770", "Colatina\ \-\ ES",
"5585349", "Fortaleza\ \-\ CE",
"55943379", "São\ João\ do\ Araguaia\ \-\ PA",
"55443906", "Umuarama\ \-\ PR",
"55833255", "João\ Pessoa\ \-\ PB",
"55443068", "Campo\ Mourão\ \-\ PR",
"55773409", "Iguatemi\ \-\ BA",
"55474053", "Blumenau\ \-\ SC",
"55433562", "Sertaneja\ \-\ PR",
"55833294", "Itapororoca\ \-\ PB",
"55873893", "Itacuruba\ \-\ PE",
"55313373", "Belo\ Horizonte\ \-\ MG",
"5554322", "Caxias\ do\ Sul\ \-\ RS",
"55113303", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55833308", "Santo\ André\ \-\ PB",
"55424101", "Guarapuava\ \-\ PR",
"55833639", "Riachão\ \-\ PB",
"55623097", "Aparecida\ de\ Goiânia\ \-\ GO",
"55843646", "Natal\ \-\ RN",
"55353853", "Campos\ Gerais\ \-\ MG",
"55653211", "Cáceres\ \-\ MT",
"55483355", "Imbituba\ \-\ SC",
"55674003", "Campo\ Grande\ \-\ MS",
"55673488", "Aral\ Moreira\ \-\ MS",
"55212108", "Rio\ de\ Janeiro\ \-\ RJ",
"55183279", "Regente\ Feijó\ \-\ SP",
"55213551", "Rio\ de\ Janeiro\ \-\ RJ",
"55853213", "Caucaia\ \-\ CE",
"55813236", "Recife\ \-\ PE",
"55443667", "Santa\ Eliza\ \-\ PR",
"55243323", "Barra\ Mansa\ \-\ RJ",
"55883683", "Ipu\ \-\ CE",
"55643956", "Itumbiara\ \-\ GO",
"55443250", "Presidente\ Castelo\ Branco\ \-\ PR",
"55413643", "Araucária\ \-\ PR",
"55213806", "Rio\ de\ Janeiro\ \-\ RJ",
"55483208", "Florianópolis\ \-\ SC",
"55443233", "Mandaguari\ \-\ PR",
"55943312", "Marabá\ \-\ PA",
"55933523", "Santarém\ \-\ PA",
"55623371", "Goiás\ \-\ GO",
"55623482", "Nova\ Roma\ \-\ GO",
"55143294", "Iacanga\ \-\ SP",
"55153584", "Taquarivaí\ \-\ SP",
"55613335", "São\ Sebastião\ \-\ DF",
"55352101", "Poços\ de\ Caldas\ \-\ MG",
"55313751", "Entre\ Rios\ de\ Minas\ \-\ MG",
"55353558", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55143308", "Fartura\ \-\ SP",
"55163725", "Franca\ \-\ SP",
"55173487", "Magda\ \-\ SP",
"55473221", "Blumenau\ \-\ SC",
"55753494", "Canudos\ \-\ BA",
"55453559", "Itaipulândia\ \-\ PR",
"55413063", "Curitiba\ \-\ PR",
"55273331", "Vitória\ \-\ ES",
"55383814", "Mamonas\ \-\ MG",
"55433306", "Londrina\ \-\ PR",
"55623945", "Goiânia\ \-\ GO",
"55213792", "Duque\ de\ Caxias\ \-\ RJ",
"55112646", "São\ Paulo\ \-\ SP",
"55773629", "Recife\ \-\ PE",
"55983394", "Carutapera\ \-\ MA",
"55443648", "Santa\ Rita\ do\ Oeste\ \-\ PR",
"55633356", "Peixe\ \-\ TO",
"55483045", "Criciúma\ \-\ SC",
"55843297", "Japi\ \-\ RN",
"55443312", "Nossa\ Senhora\ das\ Graças\ \-\ PR",
"55123965", "Jacareí\ \-\ SP",
"55433523", "Cornélio\ Procópio\ \-\ PR",
"55433354", "Londrina\ \-\ PR",
"55313239", "Belo\ Horizonte\ \-\ MG",
"55853332", "Redenção\ \-\ CE",
"55643413", "Morrinhos\ \-\ GO",
"55313694", "Nova\ Lima\ \-\ MG",
"55493258", "Cerro\ Negro\ \-\ SC",
"55983355", "Cajapió\ \-\ MA",
"55242103", "Petrópolis\ \-\ RJ",
"55343691", "Araxá\ \-\ MG",
"55483372", "São\ José\ \-\ SC",
"55893483", "São\ João\ do\ Piauí\ \-\ PI",
"55833447", "Belém\ do\ Brejo\ do\ Cruz\ \-\ PB",
"55114093", "Diadema\ \-\ SP",
"5535323", "Três\ Corações\ \-\ MG",
"5513346", "São\ Vicente\ \-\ SP",
"55693481", "Espigão\ do\ Oeste\ \-\ RO",
"55753696", "Saubara\ \-\ BA",
"55753268", "Teofilândia\ \-\ BA",
"55313574", "Crucilândia\ \-\ MG",
"55713461", "Salvador\ \-\ BA",
"55994102", "Imperatriz\ \-\ MA",
"55533258", "Santana\ da\ Boa\ Vista\ \-\ RS",
"55713508", "Lauro\ de\ Freitas\ \-\ BA",
"55213824", "Rio\ de\ Janeiro\ \-\ RJ",
"55553412", "Uruguaiana\ \-\ RS",
"55543331", "Carazinho\ \-\ RS",
"55114779", "Itapecerica\ da\ Serra\ \-\ SP",
"55913017", "Ananindeua\ \-\ PA",
"5511589", "São\ Paulo\ \-\ SP",
"55333434", "São\ Pedro\ do\ Suaçuí\ \-\ MG",
"55633464", "Guaraí\ \-\ TO",
"55373690", "Divinópolis\ \-\ MG",
"55153264", "Águia\ da\ Castelo\ \-\ SP",
"55753381", "Varzedo\ \-\ BA",
"55923584", "Manaus\ \-\ AM",
"55163852", "Sales\ Oliveira\ \-\ SP",
"55653631", "Cuiabá\ \-\ MT",
"55353823", "Itumirim\ \-\ MG",
"55473492", "Santa\ Cruz\ \-\ SC",
"55873764", "Garanhuns\ \-\ PE",
"55813616", "Goiana\ \-\ PE",
"55112535", "São\ Paulo\ \-\ SP",
"55983481", "Anapurus\ \-\ MA",
"55113556", "São\ Paulo\ \-\ SP",
"55484004", "Florianópolis\ \-\ SC",
"55653244", "Jauru\ \-\ MT",
"55853650", "Carnaubal\ \-\ CE",
"55773677", "Érico\ Cardoso\ \-\ BA",
"55813732", "Fazenda\ Nova\ \-\ PE",
"55333727", "Santa\ Maria\ do\ Salto\ \-\ MG",
"55313871", "Rio\ Casca\ \-\ MG",
"55243353", "Porto\ Real\ \-\ RJ",
"55113422", "São\ Caetano\ do\ Sul\ \-\ SP",
"55433011", "Arapongas\ \-\ PR",
"55212680", "Mangaratiba\ \-\ RJ",
"55432104", "Londrina\ \-\ PR",
"55453246", "Palmitópolis\ \-\ PR",
"55213668", "São\ João\ de\ Meriti\ \-\ RJ",
"55193897", "Hortolândia\ \-\ SP",
"55533931", "Rio\ Grande\ \-\ RS",
"55513687", "Arroio\ do\ Sal\ \-\ RS",
"55473087", "Brusque\ \-\ SC",
"55753247", "Irará\ \-\ BA",
"55113602", "Osasco\ \-\ SP",
"55823625", "Maravilha\ \-\ AL",
"55543905", "Gramado\ \-\ RS",
"55313721", "Conselheiro\ Lafaiete\ \-\ MG",
"55753425", "Cachoeira\ \-\ BA",
"55893591", "Jurema\ \-\ PI",
"55473251", "Brusque\ \-\ SC",
"55893549", "Alvorada\ do\ Gurguéia\ \-\ PI",
"55323441", "Leopoldina\ \-\ MG",
"55983372", "Santo\ Antônio\ dos\ Lopes\ \-\ MA",
"55532125", "Rio\ Grande\ \-\ RS",
"55517", "Rio\ Grande\ do\ Sul",
"55673674", "Bela\ Vista\ \-\ MS",
"551137", "São\ Paulo\ \-\ SP",
"55623586", "Goiânia\ \-\ GO",
"55923682", "Manaus\ \-\ AM",
"55123184", "Cruzeiro\ \-\ SP",
"55153383", "Laranjal\ Paulista\ \-\ SP",
"55943327", "Núcleo\ Carajás\ \-\ PA",
"55212641", "Teresópolis\ \-\ RJ",
"55383841", "Salinas\ \-\ MG",
"55843535", "Jardim\ de\ Angicos\ \-\ RN",
"55153115", "Boituva\ \-\ SP",
"55123431", "São\ José\ dos\ Campos\ \-\ SP",
"55313625", "Ribeirão\ das\ Neves\ \-\ MG",
"55114978", "Santo\ André\ \-\ SP",
"55513088", "Lajeado\ \-\ RS",
"55213774", "Duque\ de\ Caxias\ \-\ RJ",
"55474062", "Joinville\ \-\ SC",
"55112807", "Embu\ das\ Artes\ \-\ SP",
"55433553", "Nova\ América\ da\ Colina\ \-\ PR",
"55663513", "Sorriso\ \-\ MT",
"55114815", "Jundiaí\ \-\ SP",
"55163943", "Barrinha\ \-\ SP",
"55663399", "Campo\ Verde\ \-\ MT",
"55863343", "Piracuruca\ \-\ PI",
"55623578", "Aparecida\ de\ Goiânia\ \-\ GO",
"55123845", "Ubatuba\ \-\ SP",
"55883537", "Salitre\ \-\ CE",
"55983325", "Maranhãozinho\ \-\ MA",
"55493228", "Bocaina\ do\ Sul\ \-\ SC",
"55753340", "Marcionílio\ Souza\ \-\ BA",
"55313249", "Belo\ Horizonte\ \-\ MG",
"55313291", "Belo\ Horizonte\ \-\ MG",
"5564", "Goiás",
"55113365", "São\ Paulo\ \-\ SP",
"55143378", "Salto\ Grande\ \-\ SP",
"55633374", "Figueirópolis\ \-\ TO",
"55153558", "Apiaí\ \-\ SP",
"55152101", "Sorocaba\ \-\ SP",
"55493322", "Chapecó\ \-\ SC",
"55773457", "Riacho\ de\ Santana\ \-\ BA",
"55213726", "Teresópolis\ \-\ RJ",
"55853342", "Caucaia\ \-\ CE",
"5573", "Bahia",
"55483035", "São\ José\ \-\ SC",
"55434052", "Londrina\ \-\ PR",
"55473563", "Salete\ \-\ SC",
"55913633", "Curralinho\ \-\ PA",
"55213252", "Rio\ de\ Janeiro\ \-\ RJ",
"55114444", "Franco\ da\ Rocha\ \-\ SP",
"55893421", "Picos\ \-\ PI",
"55483462", "Criciúma\ \-\ SC",
"5592323", "Manaus\ \-\ AM",
"55693423", "Ji\-Paraná\ \-\ RO",
"55983278", "São\ Luís\ \-\ MA",
"55434104", "Apucarana\ \-\ PR",
"55163382", "Matão\ \-\ SP",
"55383081", "Montes\ Claros\ \-\ MG",
"55143386", "Taguaí\ \-\ SP",
"55823291", "Barra\ de\ Santo\ Antônio\ \-\ AL",
"55553744", "Frederico\ Westphalen\ \-\ RS",
"55473624", "Canoinhas\ \-\ SC",
"55273341", "Serra\ \-\ ES",
"55513489", "Gravataí\ \-\ RS",
"55682102", "Rio\ Branco\ \-\ AC",
"55222554", "Macuco\ \-\ RJ",
"55112712", "São\ Paulo\ \-\ SP",
"55143649", "Barra\ Bonita\ \-\ SC",
"55114535", "Jundiaí\ \-\ SP",
"55553369", "São\ Pedro\ do\ Butiá\ \-\ RS",
"55822123", "Maceió\ \-\ AL",
"55114130", "São\ Roque\ \-\ SP",
"55492102", "Lages\ \-\ SC",
"55153321", "Sorocaba\ \-\ SP",
"55823526", "Coité\ do\ Nóia\ \-\ AL",
"55943309", "Cumaru\ do\ Norte\ \-\ PA",
"55983462", "Cantanhede\ \-\ MA",
"55443243", "São\ Jorge\ do\ Ivaí\ \-\ PR",
"55663538", "Bom\ Jesus\ do\ Araguaia\ \-\ MT",
"55212186", "Nilópolis\ \-\ RJ",
"55464007", "Francisco\ Beltrão\ \-\ PR",
"55513490", "Gravataí\ \-\ RS",
"55833378", "Campo\ de\ Santana\ \-\ PB",
"55843636", "Ruy\ Barbosa\ \-\ RN",
"55923528", "Silves\ \-\ AM",
"55343826", "Patos\ de\ Minas\ \-\ MG",
"55493653", "Anchieta\ \-\ SC",
"55733270", "Itabela\ \-\ BA",
"55313303", "Belo\ Horizonte\ \-\ MG",
"55483286", "Palhoça\ \-\ SC",
"55133829", "Registro\ \-\ SP",
"55542628", "Farroupilha\ \-\ RS",
"55773479", "Piatã\ \-\ BA",
"55473404", "Itajaí\ \-\ SC",
"55753652", "Cairu\ \-\ BA",
"55273051", "Serra\ \-\ ES",
"55673454", "Maracaju\ \-\ MS",
"55192118", "Hortolândia\ \-\ SP",
"55442031", "Umuarama\ \-\ PR",
"55473522", "Rio\ do\ Sul\ \-\ SC",
"55773412", "Iramaia\ \-\ BA",
"55333411", "Peçanha\ \-\ MG",
"55423661", "Porto\ Barreiro\ \-\ PR",
"55313526", "Minas\ Gerais",
"55193816", "Indaiatuba\ \-\ SP",
"55413096", "São\ José\ dos\ Pinhais\ \-\ PR",
"55473456", "Barra\ Velha\ \-\ SC",
"55683322", "Cruzeiro\ do\ Sul\ \-\ AC",
"55273287", "Fundão\ \-\ ES",
"55623301", "Leopoldo\ de\ Bulhões\ \-\ GO",
"55853104", "Fortaleza\ \-\ CE",
"55483278", "São\ José\ \-\ SC",
"55112829", "Santo\ André\ \-\ SP",
"55493363", "Bom\ Jesus\ do\ Oeste\ \-\ SC",
"55544009", "Caxias\ do\ Sul\ \-\ RS",
"55222652", "Saquarema\ \-\ RJ",
"55173122", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55673495", "Caracol\ \-\ MS",
"55333297", "Santa\ Efigênia\ de\ Minas\ \-\ MG",
"55643377", "Mossâmedes\ \-\ GO",
"55513543", "Parobé\ \-\ RS",
"55753362", "Boa\ Vista\ Cananéia\ \-\ BA",
"55613055", "Brasília\ \-\ DF",
"55833386", "Gurjão\ \-\ PB",
"55543380", "Ibirapuitã\ \-\ RS",
"55753353", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55993623", "Bom\ Lugar\ \-\ MA",
"55422101", "Ponta\ Grossa\ \-\ PR",
"55213987", "Rio\ de\ Janeiro\ \-\ RJ",
"55553615", "Santa\ Margarida\ do\ Sul\ \-\ RS",
"55133877", "Santos\ \-\ SP",
"55753330", "Boninal\ \-\ BA",
"55813431", "Olinda\ \-\ PE",
"55473364", "Dona\ Emma\ \-\ SC",
"55413587", "São\ José\ dos\ Pinhais\ \-\ PR",
"55843434", "Santana\ do\ Matos\ \-\ RN",
"55133216", "Santos\ \-\ SP",
"55613433", "Brasília\ \-\ DF",
"55883547", "Caririaçu\ \-\ CE",
"55123835", "Ubatuba\ \-\ SP",
"55433540", "Rancho\ Alegre\ \-\ PR",
"55213222", "Rio\ de\ Janeiro\ \-\ RJ",
"55793316", "Nossa\ Senhora\ de\ Lourdes\ \-\ SE",
"5592361", "Manaus\ \-\ AM",
"55623016", "Aparecida\ de\ Goiânia\ \-\ GO",
"55383534", "Diamantina\ \-\ MG",
"55553629", "Jacuizinho\ \-\ RS",
"55323559", "Visconde\ do\ Rio\ Branco\ \-\ MG",
"55163254", "Guariroba\ \-\ SP",
"55893451", "Santo\ Inácio\ do\ Piauí\ \-\ PI",
"55183841", "Junqueirópolis\ \-\ SP",
"55953236", "Caroebe\ \-\ RR",
"55443218", "Maringá\ \-\ PR",
"55983302", "São\ Luís\ \-\ MA",
"55623461", "Pires\ do\ Rio\ \-\ GO",
"55863081", "Teresina\ \-\ PI",
"55893539", "Porto\ Alegre\ do\ Piauí\ \-\ PI",
"55973426", "Japurá\ \-\ AM",
"55383831", "Porteirinha\ \-\ MG",
"55114066", "Diadema\ \-\ SP",
"55753402", "Entre\ Rios\ \-\ BA",
"55243381", "Resende\ \-\ RJ",
"55212631", "Magé\ \-\ RJ",
"55873946", "Salgueiro\ \-\ PE",
"55513054", "Viamão\ \-\ RS",
"55273314", "Vitória\ \-\ ES",
"55473654", "Monte\ Castelo\ \-\ SC",
"55883621", "Camocim\ \-\ CE",
"55173346", "Bebedouro\ \-\ SP",
"55753237", "Teodoro\ Sampaio\ \-\ BA",
"55693302", "Porto\ Velho\ \-\ RO",
"55813559", "Ipojuca\ \-\ PE",
"55983453", "Arari\ \-\ MA",
"55114162", "Barueri\ \-\ SP",
"55543287", "Vila\ Cristina\ \-\ RS",
"55993317", "Timon\ \-\ MA",
"55383227", "Brasília\ de\ Minas\ \-\ MG",
"55993564", "Governador\ Eugênio\ Barros\ \-\ MA",
"55143202", "Bauru\ \-\ SP",
"55883568", "Jaguaribara\ \-\ CE",
"55313504", "Belo\ Horizonte\ \-\ MG",
"55242280", "Petrópolis\ \-\ RJ",
"55823556", "Feliz\ Deserto\ \-\ AL",
"55533284", "Pelotas\ \-\ RS",
"55813742", "Cachoeirinha\ \-\ PE",
"5515323", "Sorocaba\ \-\ SP",
"55114646", "Itaquaquecetuba\ \-\ SP",
"55853022", "Fortaleza\ \-\ CE",
"55453236", "Serranópolis\ do\ Iguaçu\ \-\ PR",
"55333535", "Pavão\ \-\ MG",
"55193546", "Cordeirópolis\ \-\ SP",
"55964141", "Macapá\ \-\ AP",
"55323577", "Rodeiro\ \-\ MG",
"55354101", "Varginha\ \-\ MG",
"55922101", "Manaus\ \-\ AM",
"55493623", "Descanso\ \-\ SC",
"55343856", "Arapuá\ \-\ MG",
"55383632", "Santa\ Fé\ de\ Minas\ \-\ MG",
"55863212", "Timon\ \-\ MA",
"55753622", "Feira\ de\ Santana\ \-\ BA",
"55353264", "Elói\ Mendes\ \-\ MG",
"55643438", "Domiciano\ Ribeiro\ \-\ GO",
"55273139", "Vila\ Velha\ \-\ ES",
"55883401", "Limoeiro\ do\ Norte\ \-\ CE",
"55823422", "Cacimbinhas\ \-\ AL",
"55543341", "Getúlio\ Vargas\ \-\ RS",
"55813577", "Sirinhaém\ \-\ PE",
"55312535", "Belo\ Horizonte\ \-\ MG",
"55273021", "Guarapari\ \-\ ES",
"55183642", "Birigui\ \-\ SP",
"55313556", "Mariana\ \-\ MG",
"55213263", "Rio\ de\ Janeiro\ \-\ RJ",
"55483430", "Criciúma\ \-\ SC",
"55323742", "Fervedouro\ \-\ MG",
"55433145", "Bandeirantes\ \-\ PR",
"55434063", "Londrina\ \-\ PR",
"55493564", "Rio\ das\ Antas\ \-\ SC",
"55473426", "Joinville\ \-\ SC",
"55833437", "Cajazeirinhas\ \-\ PB",
"55513769", "Rio\ Grande\ do\ Sul",
"55222771", "Rio\ das\ Ostras\ \-\ RJ",
"55222622", "Arraial\ do\ Cabo\ \-\ RJ",
"55993662", "Dom\ Pedro\ \-\ MA",
"55114023", "Itu\ \-\ SP",
"55115906", "São\ Paulo\ \-\ SP",
"55115068", "São\ Paulo\ \-\ SP",
"55863216", "Teresina\ \-\ PI",
"55693912", "Espigão\ do\ Oeste\ \-\ RO",
"55743640", "Presidente\ Dutra\ \-\ BA",
"55663438", "Nova\ Xavantina\ \-\ MT",
"55513590", "São\ Leopoldo\ \-\ RS",
"5585345", "Fortaleza\ \-\ CE",
"55813338", "Recife\ \-\ PE",
"55833295", "Jacaraú\ \-\ PB",
"55753626", "Feira\ de\ Santana\ \-\ BA",
"55213855", "Rio\ de\ Janeiro\ \-\ RJ",
"55823426", "Estrela\ de\ Alagoas\ \-\ AL",
"55973463", "Amaturá\ \-\ AM",
"55483664", "Florianópolis\ \-\ SC",
"55283557", "Apiacá\ \-\ ES",
"55823552", "Piaçabuçu\ \-\ AL",
"55213138", "Rio\ de\ Janeiro\ \-\ RJ",
"55833254", "Cruz\ do\ Espírito\ Santo\ \-\ PB",
"55813746", "Jataúba\ \-\ PE",
"55873853", "Itapetim\ \-\ PE",
"55193542", "Araras\ \-\ SP",
"55483306", "Florianópolis\ \-\ SC",
"55533503", "Bagé\ \-\ RS",
"55453232", "Guaraniaçu\ \-\ PR",
"55873830", "Solidão\ \-\ PE",
"55373213", "Divinópolis\ \-\ MG",
"55473422", "Joinville\ \-\ SC",
"55323338", "Madre\ de\ Deus\ de\ Minas\ \-\ MG",
"55333511", "Itambacuri\ \-\ MG",
"55313426", "Belo\ Horizonte\ \-\ MG",
"55993666", "Santo\ Antônio\ dos\ Lopes\ \-\ MA",
"55112350", "Poá\ \-\ SP",
"55483523", "Maracajá\ \-\ SC",
"55483354", "Garopaba\ \-\ SC",
"55823283", "Viçosa\ \-\ AL",
"55643996", "Itumbiara\ \-\ GO",
"55183646", "Brejo\ Alegre\ \-\ SP",
"55513443", "Alvorada\ \-\ RS",
"55843279", "Extremoz\ \-\ RN",
"55313552", "Ouro\ Preto\ \-\ MG",
"55333343", "Alto\ Jequitibá\ \-\ MG",
"55473556", "Santa\ Terezinha\ \-\ SC",
"55323746", "Espera\ Feliz\ \-\ MG",
"55193827", "Artur\ Nogueira\ \-\ SP",
"55153141", "Sorocaba\ \-\ SP",
"5511333", "São\ Paulo\ \-\ SP",
"55112279", "Guarulhos\ \-\ SP",
"55983664", "Buriticupu\ \-\ MA",
"55373332", "São\ Francisco\ de\ Paula\ \-\ MG",
"55913767", "São\ Caetano\ de\ Odivelas\ \-\ PA",
"55313749", "Ouro\ Branco\ \-\ MG",
"55793648", "Pedrinhas\ \-\ SE",
"55453541", "Santa\ Terezinha\ de\ Itaipu\ \-\ PR",
"55353015", "Varginha\ \-\ MG",
"55743258", "Baixa\ Grande\ \-\ BA",
"5551350", "Rio\ Grande\ do\ Sul",
"55893521", "Floriano\ \-\ PI",
"55453028", "Foz\ do\ Iguaçu\ \-\ PR",
"55323429", "Cataguases\ \-\ MG",
"55323084", "Juiz\ de\ Fora\ \-\ MG",
"55163724", "Franca\ \-\ SP",
"55693523", "Theobroma\ \-\ RO",
"55423273", "Telêmaco\ Borba\ \-\ PR",
"55493356", "Arvoredo\ \-\ SC",
"55493907", "Lages\ \-\ SC",
"55883639", "Varjota\ \-\ CE",
"5512394", "São\ José\ dos\ Campos\ \-\ SP",
"55143295", "Boracéia\ \-\ SP",
"55133212", "Santos\ \-\ SP",
"55613334", "Recanto\ das\ Emas\ \-\ DF",
"55843333", "Apodi\ \-\ RN",
"55633396", "São\ Salvador\ do\ Tocantins\ \-\ TO",
"55553244", "Santana\ do\ Livramento\ \-\ RS",
"55114166", "Barueri\ \-\ SP",
"55743681", "Ourolândia\ \-\ BA",
"55343817", "Coromandel\ \-\ MG",
"55163202", "Jaboticabal\ \-\ SP",
"55773614", "Barreiras\ \-\ BA",
"55513589", "São\ Leopoldo\ \-\ RS",
"55843257", "Lagoa\ Salgada\ \-\ RN",
"55114899", "Caieiras\ \-\ SP",
"55133279", "Santos\ \-\ SP",
"55433355", "Londrina\ \-\ PR",
"55623347", "Campinorte\ \-\ GO",
"55493304", "Chapecó\ \-\ SC",
"55383757", "Joaquim\ Felício\ \-\ MG",
"5531334", "Minas\ Gerais",
"55872101", "Petrolina\ \-\ PE",
"55983395", "Godofredo\ Viana\ \-\ MA",
"55983523", "Imperatriz\ \-\ MA",
"55114062", "São\ Paulo\ \-\ SP",
"55173342", "Bebedouro\ \-\ SP",
"55213483", "Rio\ de\ Janeiro\ \-\ RJ",
"55112831", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55733538", "Itiruçu\ \-\ BA",
"55633465", "Itapiratins\ \-\ TO",
"55333435", "Coluna\ \-\ MG",
"55533304", "Santa\ Maria\ \-\ RS",
"55143471", "Garça\ \-\ SP",
"55623628", "Novo\ Gama\ \-\ GO",
"55383216", "Montes\ Claros\ \-\ MG",
"55993326", "Timon\ \-\ MA",
"55483282", "Florianópolis\ \-\ SC",
"55753656", "Glória\ \-\ BA",
"55443569", "Juranda\ \-\ PR",
"55333062", "Governador\ Valadares\ \-\ MG",
"55114209", "Barueri\ \-\ SP",
"55193879", "Monte\ Mor\ \-\ SP",
"55444007", "Maringá\ \-\ PR",
"55313575", "Moeda\ \-\ MG",
"55973417", "Atalaia\ do\ Norte\ \-\ AM",
"55823522", "Arapiraca\ \-\ AL",
"55883501", "Juazeiro\ do\ Norte\ \-\ CE",
"55463243", "Mangueirinha\ \-\ PR",
"55753271", "Euclides\ da\ Cunha\ \-\ BA",
"55813010", "Paulista\ \-\ PE",
"55113505", "São\ Paulo\ \-\ SP",
"55983466", "Pirapemas\ \-\ MA",
"55193812", "Cosmópolis\ \-\ SP",
"55313456", "Minas\ Gerais",
"55173643", "Santa\ Rita\ D\'Oeste\ \-\ SP",
"55753604", "Feira\ de\ Santana\ \-\ BA",
"55432105", "Londrina\ \-\ PR",
"55213763", "Mesquita\ \-\ RJ",
"55473452", "Araquari\ \-\ SC",
"55313868", "Conceição\ do\ Mato\ Dentro\ \-\ MG",
"55673524", "Três\ Lagoas\ \-\ MS",
"55833382", "Juazeirinho\ \-\ PB",
"55983011", "São\ Luís\ \-\ MA",
"55813477", "Recife\ \-\ PE",
"55273151", "Linhares\ \-\ ES",
"55113596", "São\ Paulo\ \-\ SP",
"55153339", "Sorocaba\ \-\ SP",
"55133445", "Mongaguá\ \-\ SP",
"55483324", "Florianópolis\ \-\ SC",
"55693466", "Nova\ União\ \-\ RO",
"55773416", "Contendas\ do\ Sincorá\ \-\ BA",
"55853004", "Fortaleza\ \-\ CE",
"55933593", "Altamira\ \-\ PA",
"55133227", "Santos\ \-\ SP",
"55313522", "Minas\ Gerais",
"55673675", "Tacuru\ \-\ MS",
"55472123", "Blumenau\ \-\ SC",
"55963243", "Macapá\ \-\ AP",
"55123185", "Lorena\ \-\ SP",
"55613533", "Brasília\ \-\ DF",
"55313563", "Itabirito\ \-\ MG",
"55843534", "Pedro\ Avelino\ \-\ RN",
"55193857", "Engenheiro\ Coelho\ \-\ SP",
"55883447", "Limoeiro\ do\ Norte\ \-\ CE",
"55143224", "Bauru\ \-\ SP",
"55644012", "Itumbiara\ \-\ GO",
"55483466", "Orleans\ \-\ SC",
"55823624", "Pão\ de\ Açúcar\ \-\ AL",
"55843320", "Baraúna\ \-\ RN",
"55833471", "Malta\ \-\ PB",
"55473249", "Itajaí\ \-\ SC",
"55753424", "Muritiba\ \-\ BA",
"55153273", "Itapetininga\ \-\ SP",
"55633473", "Xambioá\ \-\ TO",
"55114511", "Mauá\ \-\ SP",
"55433440", "Pirapó\ \-\ PR",
"55212659", "Magé\ \-\ RJ",
"55693530", "Monte\ Negro\ \-\ RO",
"55853346", "Itapagé\ \-\ CE",
"5566", "Mato\ Grosso",
"55683464", "Jordão\ \-\ AC",
"55493326", "Caxambu\ do\ Sul\ \-\ SC",
"55773641", "Mansidão\ \-\ BA",
"55983324", "Centro\ Novo\ do\ Maranhão\ \-\ MA",
"55313847", "Minas\ Gerais",
"55682106", "Rio\ Branco\ \-\ AC",
"55434004", "Londrina\ \-\ PR",
"55333318", "Caratinga\ \-\ MG",
"55873773", "Lajedo\ \-\ PE",
"55623561", "Caldazinha\ \-\ GO",
"55323531", "Ubá\ \-\ MG",
"55843227", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55453260", "Missal\ \-\ PR",
"55893439", "Marcolândia\ \-\ PI",
"55313913", "Contagem\ \-\ MG",
"55163386", "Dobrada\ \-\ SP",
"55383727", "Monjolos\ \-\ MG",
"55513670", "Amaral\ Ferrador\ \-\ RS",
"55313624", "Ribeirão\ das\ Neves\ \-\ MG",
"55813198", "Recife\ \-\ PE",
"55383545", "Presidente\ Kubitschek\ \-\ MG",
"55163706", "Franca\ \-\ SP",
"55143382", "Fartura\ \-\ SP",
"55673043", "Campo\ Grande\ \-\ MS",
"55813459", "Aldeia\ \-\ PE",
"55114961", "Itupeva\ \-\ SP",
"55114445", "Caieiras\ \-\ SP",
"5527", "Espirito\ Santo",
"55313251", "Santana\ do\ Paraíso\ \-\ MG",
"55623582", "Goiânia\ \-\ GO",
"55483034", "São\ José\ \-\ SC",
"55873881", "Ipubi\ \-\ PE",
"55353866", "Santana\ do\ Jacaré\ \-\ MG",
"55173332", "Guaíra\ \-\ SP",
"55143288", "Bauru\ \-\ SP",
"55813657", "Ferreiros\ \-\ PE",
"5513328", "Santos\ \-\ SP",
"55553234", "Vila\ Nova\ do\ Sul\ \-\ RS",
"55143361", "Botucatu\ \-\ SP",
"5551357", "Rio\ Grande\ do\ Sul",
"55323367", "Alfredo\ Vasconcelos\ \-\ MG",
"55173587", "Palmares\ Paulista\ \-\ SP",
"55633375", "Pindorama\ do\ Tocantins\ \-\ TO",
"55333212", "Governador\ Valadares\ \-\ MG",
"55143276", "Bauru\ \-\ SP",
"55222555", "Cantagalo\ \-\ RJ",
"55114534", "Itatiba\ \-\ SP",
"55133209", "Santos\ \-\ SP",
"55983388", "Peri\ Mirim\ \-\ MA",
"55883649", "Meruoca\ \-\ CE",
"5512393", "São\ José\ dos\ Campos\ \-\ SP",
"55213167", "Duque\ de\ Caxias\ \-\ RJ",
"55542109", "Farroupilha\ \-\ RS",
"55883691", "Crateús\ \-\ CE",
"55823251", "Matriz\ de\ Camaragibe\ \-\ AL",
"55633322", "Palmas\ \-\ TO",
"55643513", "Caldas\ Novas\ \-\ GO",
"55553745", "Iraí\ \-\ RS",
"55473625", "Irineópolis\ \-\ SC",
"5511334", "São\ Paulo\ \-\ SP",
"55314062", "Belo\ Horizonte\ \-\ MG",
"55313739", "Minas\ Gerais",
"55663467", "Nova\ Nazaré\ \-\ MT",
"55113654", "Osasco\ \-\ SP",
"55513433", "Rio\ Grande\ do\ Sul",
"55183636", "Araçatuba\ \-\ SP",
"55853092", "Fortaleza\ \-\ CE",
"55473405", "Itajaí\ \-\ SC",
"55273270", "Barra\ do\ Riacho\ \-\ ES",
"55813679", "Gameleira\ \-\ PE",
"55953198", "Boa\ Vista\ \-\ RR",
"55633363", "Porto\ Nacional\ \-\ TO",
"55333333", "Realeza\ \-\ MG",
"55513450", "Rio\ Grande\ do\ Sul",
"55833361", "Esperança\ \-\ PB",
"55193984", "Paulínia\ \-\ SP",
"55433035", "Cambé\ \-\ PR",
"55323348", "Cipotânea\ \-\ MG",
"55163501", "São\ Carlos\ \-\ SP",
"55753692", "Paulo\ Afonso\ \-\ BA",
"55833288", "Mulungu\ \-\ PB",
"55813736", "São\ Caetano\ \-\ PE",
"55543329", "Carazinho\ \-\ RS",
"55643051", "Rio\ Verde\ \-\ GO",
"55113426", "Diadema\ \-\ SP",
"55733287", "Belmonte\ \-\ BA",
"55273091", "Cariacica\ \-\ ES",
"55212479", "São\ Gonçalo\ \-\ RJ",
"55123609", "Taubaté\ \-\ SP",
"55273049", "Colatina\ \-\ ES",
"55613054", "Brasília\ \-\ DF",
"55873840", "Inajá\ \-\ PE",
"5541342", "Paranaguá\ \-\ PR",
"55633653", "Arraias\ \-\ TO",
"55453242", "Corbélia\ \-\ PR",
"55913346", "Ananindeua\ \-\ PA",
"55742102", "Juazeiro\ \-\ BA",
"55463220", "Pato\ Branco\ \-\ PR",
"55733051", "Alcobaça\ \-\ BA",
"55112814", "Itaquaquecetuba\ \-\ SP",
"55193707", "Campinas\ \-\ SP",
"55913738", "Km\ 12\ \-\ PA",
"55743630", "Mirangaba\ \-\ BA",
"55114716", "São\ João\ Novo\ \-\ SP",
"55833276", "Pilões\ \-\ PB",
"55413056", "Pinhais\ \-\ PR",
"55743653", "Morro\ do\ Chapéu\ \-\ BA",
"55113552", "São\ Paulo\ \-\ SP",
"55673455", "Rio\ Brilhante\ \-\ MS",
"55193387", "Campinas\ \-\ SP",
"55133343", "Guarujá\ \-\ SP",
"55323313", "Juiz\ de\ Fora\ \-\ MG",
"55743662", "Barra\ \-\ BA",
"55112318", "São\ Paulo\ \-\ SP",
"55873031", "Petrolina\ \-\ PE",
"55173248", "Mendonça\ \-\ SP",
"55112642", "São\ Paulo\ \-\ SP",
"55673033", "Dourados\ \-\ MS",
"55383535", "Datas\ \-\ MG",
"55433302", "Londrina\ \-\ PR",
"55163308", "Gavião\ Peixoto\ \-\ SP",
"55973373", "Humaitá\ \-\ AM",
"55623486", "Colinas\ do\ Sul\ \-\ GO",
"55313837", "Barão\ de\ Cocais\ \-\ MG",
"55473365", "Camboriú\ \-\ SC",
"55353273", "Jesuânia\ \-\ MG",
"55213601", "Niterói\ \-\ RJ",
"551132", "São\ Paulo\ \-\ SP",
"55843435", "Florânia\ \-\ RN",
"55123834", "Ubatuba\ \-\ SP",
"55114081", "São\ Paulo\ \-\ SP",
"55843062", "Mossoró\ \-\ RN",
"55893449", "Santo\ Antônio\ de\ Lisboa\ \-\ PI",
"55143547", "Guaiçara\ \-\ SP",
"55323541", "Ubá\ \-\ MG",
"55212734", "Rio\ Bonito\ \-\ RJ",
"55553614", "Vitória\ das\ Missões\ \-\ RS",
"55993565", "Formosa\ da\ Serra\ Negra\ \-\ MA",
"55493573", "Calmon\ \-\ SC",
"55242259", "Petrópolis\ \-\ RJ",
"55433453", "Kaloré\ \-\ PR",
"55213274", "Rio\ de\ Janeiro\ \-\ RJ",
"55643567", "Itumbiara\ \-\ GO",
"55713628", "Arembepe\ \-\ BA",
"55823221", "Maceió\ \-\ AL",
"55853336", "Horizonte\ \-\ CE",
"55222747", "Farol\ de\ São\ Tomé\ \-\ RJ",
"55113170", "São\ Paulo\ \-\ SP",
"55883437", "Tauá\ \-\ CE",
"55513055", "Guaíba\ \-\ RS",
"55273315", "Vitória\ \-\ ES",
"55473655", "Major\ Vieira\ \-\ SC",
"55543377", "Santo\ Antônio\ do\ Planalto\ \-\ RS",
"55863297", "Agricolândia\ \-\ PI",
"55813541", "Abreu\ e\ Lima\ \-\ PE",
"55213970", "Rio\ de\ Janeiro\ \-\ RJ",
"55633352", "Crixás\ do\ Tocantins\ \-\ TO",
"55213113", "Rio\ de\ Janeiro\ \-\ RJ",
"55513600", "Rio\ Grande\ do\ Sul",
"55222519", "Nova\ Friburgo\ \-\ RJ",
"55553557", "Coronel\ Bicaco\ \-\ RS",
"55373238", "Pará\ de\ Minas\ \-\ MG",
"55673268", "Bodoquena\ \-\ MS",
"55663904", "Barra\ do\ Garças\ \-\ MT",
"55653235", "Figueirópolis\ D\'Oeste\ \-\ MT",
"55353265", "Três\ Pontas\ \-\ MG",
"55433566", "Carlópolis\ \-\ PR",
"55173267", "Guapiaçu\ \-\ SP",
"55153349", "Ibiúna\ \-\ SP",
"55473373", "Guaramirim\ \-\ SC",
"55222674", "Araruama\ \-\ RJ",
"55113404", "Bragança\ Paulista\ \-\ SP",
"55833547", "Vieirópolis\ \-\ PB",
"55953084", "Boa\ Vista\ \-\ RR",
"55513420", "Rio\ Grande\ do\ Sul",
"5554", "Rio\ Grande\ do\ Sul",
"5513356", "São\ Vicente\ \-\ SP",
"55693581", "Machadinho\ D\'Oeste\ \-\ RO",
"55424001", "Ponta\ Grossa\ \-\ PR",
"55333534", "Padre\ Paraíso\ \-\ MG",
"55173633", "Santa\ Albertina\ \-\ SP",
"55242442", "Barra\ do\ Piraí\ \-\ RJ",
"55133841", "Iguape\ \-\ SP",
"55193809", "Hortolândia\ \-\ SP",
"55553512", "Santa\ Rosa\ \-\ RS",
"55753201", "Acupe\ \-\ BA",
"55883571", "Juazeiro\ do\ Norte\ \-\ CE",
"55443902", "Paranavaí\ \-\ PR",
"55613024", "Brasília\ \-\ DF",
"55963312", "Macapá\ \-\ AP",
"55613489", "Planaltina\ \-\ DF",
"55463233", "Coronel\ Vivida\ \-\ PR",
"55222768", "Quissamã\ \-\ RJ",
"5511256", "São\ Paulo\ \-\ SP",
"55673419", "Angélica\ \-\ MS",
"55212008", "Teresópolis\ \-\ RJ",
"55543359", "Vila\ Maria\ \-\ RS",
"55643548", "Itumbiara\ \-\ GO",
"55624051", "Anápolis\ \-\ GO",
"55923131", "Manaus\ \-\ AM",
"55753674", "Cruz\ das\ Almas\ \-\ BA",
"55413122", "Curitiba\ \-\ PR",
"55673247", "Costa\ Rica\ \-\ MS",
"55353339", "São\ Lourenço\ \-\ MG",
"55733548", "Irajuba\ \-\ BA",
"55843642", "Natal\ \-\ RN",
"55112841", "São\ Paulo\ \-\ SP",
"55733021", "Prado\ \-\ BA",
"55112166", "Barueri\ \-\ SP",
"55513345", "Rio\ Grande\ do\ Sul",
"55983359", "São\ João\ Batista\ \-\ MA",
"55273388", "Vila\ Velha\ \-\ ES",
"55183263", "Santo\ Anastácio\ \-\ SP",
"55773619", "Catolândia\ \-\ BA",
"55513584", "Novo\ Hamburgo\ \-\ RS",
"55513498", "Rio\ Grande\ do\ Sul",
"55553249", "Santiago\ \-\ RS",
"55383521", "Itamarandiba\ \-\ MG",
"5569", "Rondônia",
"55543581", "Passo\ Fundo\ \-\ RS",
"55413658", "Bocaiúva\ do\ Sul\ \-\ PR",
"55114894", "Itatiba\ \-\ SP",
"55313235", "Belo\ Horizonte\ \-\ MG",
"55663553", "Juruena\ \-\ MT",
"55913116", "Belém\ \-\ PA",
"55114138", "Taboão\ da\ Serra\ \-\ SP",
"55213642", "Teresópolis\ \-\ RJ",
"55183637", "Araçatuba\ \-\ SP",
"552122", "Rio\ de\ Janeiro\ \-\ RJ",
"55433399", "Tamarana\ \-\ PR",
"55273261", "Guarapari\ \-\ ES",
"55193795", "Campinas\ \-\ SP",
"55143731", "Avaré\ \-\ SP",
"55483091", "Florianópolis\ \-\ SC",
"55483049", "São\ José\ \-\ SC",
"55733278", "Wenceslau\ Guimarães\ \-\ BA",
"55833370", "Caiçara\ \-\ PB",
"55843421", "Caicó\ \-\ RN",
"55773625", "Santa\ Rita\ de\ Cássia\ \-\ BA",
"55274104", "Cariacica\ \-\ ES",
"55823235", "Maceió\ \-\ AL",
"55193706", "Campinas\ \-\ SP",
"55833277", "Pirpirituba\ \-\ PB",
"55383647", "Formoso\ \-\ MG",
"5598", "Maranhão",
"55222531", "Sumidouro\ \-\ RJ",
"55464055", "Pato\ Branco\ \-\ PR",
"55193386", "Campinas\ \-\ SP",
"55343799", "Araguari\ \-\ MG",
"55813737", "Bonito\ \-\ PE",
"55333722", "Mata\ Verde\ \-\ MG",
"55323424", "Laranjal\ \-\ MG",
"55163729", "Ituverava\ \-\ SP",
"55143003", "Bauru\ \-\ SP",
"55733286", "Itapebi\ \-\ BA",
"55113427", "Mogi\ das\ Cruzes\ \-\ SP",
"55112970", "Barueri\ \-\ SP",
"55114591", "Itupeva\ \-\ SP",
"55473211", "Brusque\ \-\ SC",
"55454003", "Foz\ do\ Iguaçu\ \-\ PR",
"55193649", "Águas\ da\ Prata\ \-\ SP",
"55112705", "São\ Paulo\ \-\ SP",
"55613339", "Brasília\ \-\ DF",
"55383824", "Rio\ Pardo\ de\ Minas\ \-\ MG",
"55123519", "São\ José\ dos\ Campos\ \-\ SP",
"55613608", "Novo\ Gama\ \-\ GO",
"55794002", "Aracaju\ \-\ SE",
"55883634", "Ubajara\ \-\ CE",
"55813656", "Orobó\ \-\ PE",
"55413012", "Curitiba\ \-\ PR",
"55193892", "Serra\ Negra\ \-\ SP",
"55753242", "Amélia\ Rodrigues\ \-\ BA",
"55993638", "Alto\ Alegre\ do\ Maranhão\ \-\ MA",
"55113607", "Osasco\ \-\ SP",
"55442102", "Maringá\ \-\ PR",
"55373016", "Divinópolis\ \-\ MG",
"55513682", "Balneário\ Pinhal\ \-\ RS",
"55123674", "Tremembé\ \-\ SP",
"55673559", "Paranaíba\ \-\ MS",
"55623336", "Alexânia\ \-\ GO",
"55323366", "Oliveira\ Fortes\ \-\ MG",
"55653221", "Cáceres\ \-\ MT",
"55183704", "Pereira\ Barreto\ \-\ SP",
"55843385", "Marcelino\ Vieira\ \-\ RN",
"55493243", "Correia\ Pinto\ \-\ SC",
"55423520", "São\ Mateus\ do\ Sul\ \-\ PR",
"55613114", "Brasília\ \-\ DF",
"55242401", "Barra\ do\ Piraí\ \-\ RJ",
"55153533", "Bom\ Sucesso\ de\ Itararé\ \-\ SP",
"55443653", "Tuneiras\ do\ Oeste\ \-\ PR",
"55963326", "Ferreira\ Gomes\ \-\ AP",
"55913658", "Santa\ Cruz\ do\ Arari\ \-\ PA",
"55183275", "Martinópolis\ \-\ SP",
"555133", "Porto\ Alegre\ \-\ RS",
"55983377", "Nova\ Olinda\ do\ Maranhão\ \-\ MA",
"55433051", "Rolândia\ \-\ PR",
"55773496", "Santa\ Maria\ da\ Vitória\ \-\ BA",
"55353867", "Ribeirão\ Vermelho\ \-\ MG",
"55115693", "São\ Paulo\ \-\ SP",
"55423334", "Maceió\ \-\ AL",
"55813271", "Recife\ \-\ PE",
"55553303", "Cruz\ Alta\ \-\ RS",
"55413116", "São\ José\ dos\ Pinhais\ \-\ PR",
"55843274", "Ceará\-Mirim\ \-\ RN",
"55943322", "Marabá\ \-\ PA",
"55613273", "Brasília\ \-\ DF",
"55753477", "Chorrochó\ \-\ BA",
"55643462", "Goiandira\ \-\ GO",
"55833635", "Damião\ \-\ PB",
"55114483", "Mairiporã\ \-\ SP",
"55333825", "Belo\ Oriente\ \-\ MG",
"55813604", "Surubim\ \-\ PE",
"55212868", "Rio\ de\ Janeiro\ \-\ RJ",
"55643603", "Iporá\ \-\ GO",
"55553526", "Sede\ Nova\ \-\ RS",
"55663466", "Ponte\ Branca\ \-\ MT",
"55313078", "Belo\ Horizonte\ \-\ MG",
"55673431", "Ponta\ Porã\ \-\ MS",
"55833259", "Pitimbu\ \-\ PB",
"55143277", "Bauru\ \-\ SP",
"55323271", "Bicas\ \-\ MG",
"5554321", "Caxias\ do\ Sul\ \-\ RS",
"55213899", "Rio\ de\ Janeiro\ \-\ RJ",
"55183222", "Presidente\ Prudente\ \-\ SP",
"55883532", "Barbalha\ \-\ CE",
"55353543", "Capetinga\ \-\ MG",
"5548", "Santa\ Catarina",
"55413628", "Campo\ do\ Tenente\ \-\ PR",
"55813495", "Olinda\ \-\ PE",
"55313615", "Belo\ Horizonte\ \-\ MG",
"55123849", "Ubatuba\ \-\ SP",
"55123891", "São\ Sebastião\ \-\ SP",
"55163231", "Guariba\ \-\ SP",
"55434009", "Londrina\ \-\ PR",
"55212791", "Nilópolis\ \-\ RJ",
"55443352", "Santo\ Inácio\ \-\ PR",
"55663523", "Nova\ Santa\ Helena\ \-\ MT",
"55114819", "Franco\ da\ Rocha\ \-\ SP",
"55433567", "Sengés\ \-\ PR",
"55923533", "Parintins\ \-\ AM",
"55823597", "Maceió\ \-\ AL",
"55213030", "Rio\ de\ Janeiro\ \-\ RJ",
"55173266", "Cedral\ \-\ SP",
"55643430", "Itumbiara\ \-\ GO",
"55513703", "Rio\ Grande\ do\ Sul",
"55513115", "Canoas\ \-\ RS",
"55183217", "Presidente\ Prudente\ \-\ SP",
"55183876", "Paulicéia\ \-\ SP",
"55813454", "Recife\ \-\ PE",
"55643453", "Caldas\ Novas\ \-\ GO",
"55673246", "Terenos\ \-\ MS",
"55373301", "Divinópolis\ \-\ MG",
"55483438", "Criciúma\ \-\ SC",
"55623092", "Goiânia\ \-\ GO",
"55443662", "Maria\ Helena\ \-\ PR",
"55313711", "Prudente\ de\ Morais\ \-\ MG",
"55753429", "Conde\ \-\ BA",
"5511499", "Santo\ André\ \-\ SP",
"55823629", "Ouro\ Branco\ \-\ AL",
"55163759", "Franca\ \-\ SP",
"55543034", "São\ Marcos\ \-\ RS",
"55513031", "Canoas\ \-\ RS",
"55653492", "Ouro\ Branco\ \(Antiga\ Raposolândia\)\ \-\ MT",
"55473631", "São\ Bento\ do\ Sul\ \-\ SC",
"55533243", "Dom\ Pedrito\ \-\ RS",
"55753609", "Bravo\ \-\ BA",
"55423533", "Antônio\ Olinto\ \-\ PR",
"55313836", "Itambé\ do\ Mato\ Dentro\ \-\ MG",
"55163958", "Taquaral\ \-\ SP",
"55753338", "Mucugê\ \-\ BA",
"55813626", "Goiana\ \-\ PE",
"55982109", "São\ Luís\ \-\ MA",
"55613458", "Samambaia\ Sul\ \-\ DF",
"55193571", "Leme\ \-\ SP",
"55143546", "Sabino\ \-\ SP",
"55543388", "Bento\ Gonçalves\ \-\ RS",
"55653251", "São\ José\ dos\ Quatro\ Marcos\ \-\ MT",
"55173482", "Auriflama\ \-\ SP",
"55123133", "Guaratinguetá\ \-\ SP",
"55613585", "Ceilândia\ \-\ DF",
"55113412", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55312138", "Belo\ Horizonte\ \-\ MG",
"55443623", "Umuarama\ \-\ PR",
"55273145", "Vitória\ \-\ ES",
"55153334", "Sorocaba\ \-\ SP",
"55713026", "Lauro\ de\ Freitas\ \-\ BA",
"55943352", "Parauapebas\ \-\ PA",
"55543261", "Farroupilha\ \-\ RS",
"5531348", "Belo\ Horizonte\ \-\ MG",
"55433548", "Sapopema\ \-\ PR",
"55513264", "Rio\ Grande\ do\ Sul",
"55114256", "Suzano\ \-\ SP",
"55183583", "Rinópolis\ \-\ SP",
"55883436", "Itatira\ \-\ CE",
"55543376", "Aratiba\ \-\ RS",
"55353344", "Aiuruoca\ \-\ MG",
"55544052", "Passo\ Fundo\ \-\ RS",
"55843292", "Tangará\ \-\ RN",
"55114775", "Itapecerica\ da\ Serra\ \-\ SP",
"55833215", "João\ Pessoa\ \-\ PB",
"55314113", "Sete\ Lagoas\ \-\ MG",
"55553556", "Redentora\ \-\ RS",
"55313409", "Belo\ Horizonte\ \-\ MG",
"55312591", "Betim\ \-\ MG",
"55213814", "Rio\ de\ Janeiro\ \-\ RJ",
"55553422", "Alegrete\ \-\ RS",
"55654062", "Cuiabá\ \-\ MT",
"55193874", "Paulínia\ \-\ SP",
"55833229", "Santa\ Rita\ \-\ PB",
"55114204", "Araçariguama\ \-\ SP",
"55663562", "Santa\ Carmem\ \-\ MT",
"55853337", "Aracoiaba\ \-\ CE",
"55923194", "Manaus\ \-\ AM",
"55273044", "Colatina\ \-\ ES",
"55123604", "Pindamonhangaba\ \-\ SP",
"55213982", "Rio\ de\ Janeiro\ \-\ RJ",
"55242471", "Vassouras\ \-\ RJ",
"55484109", "Biguaçu\ \-\ SC",
"55483413", "Criciúma\ \-\ SC",
"55673499", "Vila\ Nova\ Casa\ Verde\ \-\ MS",
"55173016", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55673441", "Nova\ Andradina\ \-\ MS",
"55543324", "Ibirubá\ \-\ RS",
"55333421", "Guanhães\ \-\ MG",
"55114292", "Suzano\ \-\ SP",
"55133872", "Sete\ Barras\ \-\ SP",
"55353533", "Pratápolis\ \-\ MG",
"55883542", "Missão\ Velha\ \-\ CE",
"55413582", "Curitiba\ \-\ PR",
"55813201", "Recife\ \-\ PE",
"55193826", "Vinhedo\ \-\ SP",
"55213227", "Rio\ de\ Janeiro\ \-\ RJ",
"55112819", "Mogi\ das\ Cruzes\ \-\ SP",
"55663581", "Castanheira\ \-\ MT",
"55553373", "Saldanha\ Marinho\ \-\ RS",
"55213445", "Rio\ de\ Janeiro\ \-\ RJ",
"55843398", "Serrinha\ dos\ Pintos\ \-\ RN",
"55383756", "Buenópolis\ \-\ MG",
"55143432", "Marília\ \-\ SP",
"55773475", "Rio\ de\ Contas\ \-\ BA",
"55153311", "Sorocaba\ \-\ SP",
"55493667", "São\ Miguel\ da\ Boa\ Vista\ \-\ SC",
"55223863", "Jaguarembé\ \-\ RJ",
"55463565", "Flor\ da\ Serra\ do\ Sul\ \-\ PR",
"55443640", "Esperança\ Nova\ \-\ PR",
"551", "São\ Paulo",
"55633397", "Pugmil\ \-\ TO",
"55733673", "Arataca\ \-\ BA",
"55993648", "Bernardo\ do\ Mearim\ \-\ MA",
"55173461", "General\ Salgado\ \-\ SP",
"551124", "Guarulhos\ \-\ SP",
"55863252", "Campo\ Maior\ \-\ PI",
"55653624", "Cuiabá\ \-\ MT",
"55943785", "Novo\ Repartimento\ \-\ PA",
"55343816", "Lagoa\ Grande\ \-\ MG",
"55383222", "Montes\ Claros\ \-\ MG",
"55323201", "Cataguases\ \-\ MG",
"55153543", "Capão\ Bonito\ \-\ SP",
"55943305", "Bannach\ \-\ PA",
"55543282", "Canela\ \-\ RS",
"55493233", "São\ Joaquim\ \-\ SC",
"55222580", "Nova\ Friburgo\ \-\ RJ",
"55843256", "Boa\ Saúde\ \-\ RN",
"55213534", "Rio\ de\ Janeiro\ \-\ RJ",
"55793046", "Aracaju\ \-\ SE",
"55533613", "Pedras\ Altas\ \-\ RS",
"55283556", "São\ José\ do\ Calçado\ \-\ ES",
"55683233", "Porto\ Acre\ \-\ AC",
"55553365", "Roque\ Gonzales\ \-\ RS",
"55114539", "Joanópolis\ \-\ SP",
"55242224", "São\ José\ do\ Vale\ do\ Rio\ Preto\ \-\ RJ",
"55813747", "Brejo\ da\ Madre\ de\ Deus\ \-\ PE",
"55183521", "Adamantina\ \-\ SP",
"55663493", "Pedra\ Preta\ \-\ MT",
"55883644", "Santana\ do\ Acaraú\ \-\ CE",
"55542104", "Passo\ Fundo\ \-\ RS",
"55543011", "Farroupilha\ \-\ RS",
"55813525", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55193308", "Campinas\ \-\ SP",
"55133398", "Guarujá\ \-\ SP",
"55273354", "Viana\ \-\ ES",
"55512101", "Porto\ Alegre\ \-\ RS",
"55613391", "Brazlândia\ \-\ DF",
"55314138", "Vespasiano\ \-\ MG",
"55513558", "Rio\ Grande\ do\ Sul",
"55553751", "Dois\ Irmãos\ das\ MissõEs\ \-\ RS",
"55323572", "Silveirânia\ \-\ MG",
"55273395", "Vitória\ \-\ ES",
"55733208", "Nova\ Viçosa\ \-\ BA",
"55115907", "São\ Paulo\ \-\ SP",
"55513485", "Viamão\ \-\ RS",
"55813519", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55113659", "Osasco\ \-\ SP",
"55623004", "Goiânia\ \-\ GO",
"55793304", "Aracaju\ \-\ SE",
"55753627", "Sapeaçu\ \-\ BA",
"55313734", "Belo\ Vale\ \-\ MG",
"55823427", "Minador\ do\ Negrão\ \-\ AL",
"55222541", "Nova\ Friburgo\ \-\ RJ",
"55643997", "Itumbiara\ \-\ GO",
"55323393", "Senhora\ das\ Dores\ \-\ MG",
"55183647", "Glicério\ \-\ SP",
"55733665", "Teixeira\ de\ Freitas\ \-\ BA",
"55673480", "Paranhos\ \-\ MS",
"55343259", "Uberlândia\ \-\ MG",
"55493648", "Caibi\ \-\ SC",
"55163173", "Igarapava\ \-\ SP",
"55483039", "Florianópolis\ \-\ SC",
"55213716", "São\ Gonçalo\ \-\ RJ",
"55473557", "Imbuia\ \-\ SC",
"55323747", "Alto\ Caparaó\ \-\ MG",
"55493312", "Chapecó\ \-\ SC",
"55443305", "Maringá\ \-\ PR",
"5592365", "Manaus\ \-\ AM",
"55343003", "Uberlândia\ \-\ MG",
"55773463", "Licínio\ de\ Almeida\ \-\ BA",
"55123424", "Taubaté\ \-\ SP",
"55953626", "Boa\ Vista\ \-\ RR",
"55643665", "Piranhas\ \-\ GO",
"55663540", "União\ do\ Sul\ \-\ MT",
"55163214", "Araraquara\ \-\ SP",
"55443258", "Munhoz\ de\ Melo\ \-\ PR",
"55114148", "Cotia\ \-\ SP",
"55833065", "Campina\ Grande\ \-\ PB",
"55213632", "Magé\ \-\ RJ",
"55313245", "Belo\ Horizonte\ \-\ MG",
"55993667", "Governador\ Archer\ \-\ MA",
"55693413", "Urupá\ \-\ RO",
"55222627", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55634141", "Palmas\ \-\ TO",
"55133591", "Praia\ Grande\ \-\ SP",
"55193501", "Hortolândia\ \-\ SP",
"55543354", "Esmeralda\ \-\ RS",
"55673414", "Vila\ Vargas\ \-\ MS",
"55513765", "Lagoão\ \-\ RS",
"55213660", "Magé\ \-\ RJ",
"55853347", "Baturité\ \-\ CE",
"55732105", "Porto\ Seguro\ \-\ BA",
"55114601", "Jundiaí\ \-\ SP",
"55163984", "São\ Simão\ \-\ SP",
"55493327", "Nova\ Itaberaba\ \-\ SC",
"55773452", "Guanambi\ \-\ BA",
"55112894", "São\ Paulo\ \-\ SP",
"55473416", "Joinville\ \-\ SC",
"55653364", "Várzea\ Grande\ \-\ MT",
"55353334", "Carmo\ de\ Minas\ \-\ MG",
"55883446", "Aracati\ \-\ CE",
"55193856", "Vinhedo\ \-\ SP",
"55813692", "Lagoa\ dos\ Gatos\ \-\ PE",
"5511348", "São\ Paulo\ \-\ SP",
"55543395", "Viadutos\ \-\ RS",
"55533312", "Bagé\ \-\ RS",
"55483467", "Içara\ \-\ SC",
"55543523", "Barão\ de\ Cotegipe\ \-\ RS",
"55114705", "Santana\ de\ Parnaíba\ \-\ SP",
"55153344", "Piedade\ \-\ SP",
"5542362", "Guarapuava\ \-\ PR",
"55713105", "Salvador\ \-\ BA",
"55133855", "Tatuí\ \-\ SP",
"55163387", "Nova\ Europa\ \-\ SP",
"55513661", "Tramandaí\ \-\ RS",
"55853012", "Caucaia\ \-\ CE",
"55313479", "Minas\ Gerais",
"55383726", "Santo\ Hipólito\ \-\ MG",
"55123143", "Cruzeiro\ \-\ SP",
"55163707", "Franca\ \-\ SP",
"55653695", "Várzea\ Grande\ \-\ MT",
"55423311", "Ponta\ Grossa\ \-\ PR",
"55634007", "Palmas\ \-\ TO",
"55693448", "Ministro\ Andreazza\ \-\ RO",
"55433538", "Andirá\ \-\ PR",
"55112549", "São\ Paulo\ \-\ SP",
"55982016", "São\ Luís\ \-\ MA",
"55112591", "São\ Paulo\ \-\ SP",
"55113409", "Suzano\ \-\ SP",
"55313846", "Coronel\ Fabriciano\ \-\ MG",
"55423543", "Paulo\ Frontin\ \-\ PR",
"55443465", "Cruzeiro\ do\ Sul\ \-\ PR",
"55753612", "Feira\ de\ Santana\ \-\ BA",
"55112717", "São\ Paulo\ \-\ SP",
"55173293", "Palestina\ \-\ SP",
"55193804", "Mogi\ Mirim\ \-\ SP",
"55453271", "Sede\ Alvorada\ \-\ PR",
"55383252", "Engenheiro\ Dolabela\ \-\ MG",
"55313161", "Ribeirão\ das\ Neves\ \-\ MG",
"55183551", "Lucélia\ \-\ SP",
"55242254", "Comendador\ Levy\ Gasparian\ \-\ RJ",
"55213279", "Rio\ de\ Janeiro\ \-\ RJ",
"55212251", "São\ Gonçalo\ \-\ RJ",
"55473234", "Blumenau\ \-\ SC",
"55283526", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55513099", "São\ Leopoldo\ \-\ RS",
"55473641", "Mafra\ \-\ SC",
"55273324", "Vitória\ \-\ ES",
"55513041", "Cachoeirinha\ \-\ RS",
"55863263", "Cocal\ de\ Telha\ \-\ PI",
"55883611", "Sobral\ \-\ CE",
"55223852", "Miracema\ \-\ RJ",
"55193447", "Piracicaba\ \-\ SP",
"55643593", "Itumbiara\ \-\ GO",
"55814003", "Recife\ \-\ PE",
"55653283", "Comodoro\ \-\ MT",
"55273553", "Guaçuí\ \-\ ES",
"55614001", "Brasília\ \-\ DF",
"55673236", "Nioaque\ \-\ MS",
"55893535", "Manoel\ Emídio\ \-\ PI",
"55383217", "Montes\ Claros\ \-\ MG",
"55112752", "São\ Paulo\ \-\ SP",
"55713500", "Salvador\ \-\ BA",
"55513773", "Poço\ das\ Antas\ \-\ RS",
"55643440", "Cumari\ \-\ GO",
"55173301", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55693467", "Rondominas\ \-\ RO",
"55323555", "Coimbra\ \-\ MG",
"55993613", "Grajaú\ \-\ MA",
"55773417", "Guajeru\ \-\ BA",
"55143714", "Cerqueira\ César\ \-\ SP",
"55833536", "Santa\ Cruz\ \-\ PB",
"55373371", "Piumhi\ \-\ MG",
"55714111", "Camaçari\ \-\ BA",
"55212688", "Itaguaí\ \-\ RJ",
"55213212", "Rio\ de\ Janeiro\ \-\ RJ",
"55683327", "Assis\ Brasil\ \(Vila\)\ \-\ AC",
"5592362", "Manaus\ \-\ AM",
"55813476", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55923311", "Cacau\ Pirêra\ \-\ AM",
"55114421", "Santo\ André\ \-\ SP",
"55163241", "Monte\ Alto\ \-\ SP",
"55893444", "Dom\ Expedito\ Lopes\ \-\ PI",
"55333292", "Marilac\ \-\ MG",
"55343215", "Uberlândia\ \-\ MG",
"55933538", "Terra\ Santa\ \-\ PA",
"55823344", "Maceió\ \-\ AL",
"55193778", "Campinas\ \-\ SP",
"55813253", "Recife\ \-\ PE",
"55133258", "Santos\ \-\ SP",
"5531336", "Minas\ Gerais",
"55112396", "Itu\ \-\ SP",
"55333284", "Frei\ Inocêncio\ \-\ MG",
"5511454", "Mauá\ \-\ SP",
"55413674", "Tijucas\ do\ Sul\ \-\ PR",
"55793205", "Aracaju\ \-\ SE",
"55733295", "Itanhém\ \-\ BA",
"55114914", "São\ Paulo\ \-\ SP",
"55493646", "Cunha\ Porã\ \-\ SC",
"55173362", "Marcondésia\ \-\ SP",
"55423516", "Rio\ Claro\ do\ Sul\ \-\ PR",
"55513475", "Canoas\ \-\ RS",
"55133305", "Guarujá\ \-\ SP",
"55543468", "Pinto\ Bandeira\ \-\ RS",
"55693231", "Itapuã\ do\ Oeste\ \-\ RO",
"55733254", "Gandu\ \-\ BA",
"55443256", "Ângulo\ \-\ PR",
"55463252", "Clevelândia\ \-\ PR",
"55623367", "Porangatu\ \-\ GO",
"55323337", "Mercês\ \-\ MG",
"55273255", "Viana\ \-\ ES",
"55643933", "Itumbiara\ \-\ GO",
"55123116", "Bananal\ \-\ SP",
"55623514", "Inhumas\ \-\ GO",
"55923427", "Juruá\ \-\ AM",
"55114317", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55353409", "Lavras\ \-\ MG",
"55314136", "Belo\ Horizonte\ \-\ MG",
"55513556", "Rio\ Grande\ do\ Sul",
"55484020", "Florianópolis\ \-\ SC",
"55193306", "Sumaré\ \-\ SP",
"55163315", "Ribeirão\ Preto\ \-\ SP",
"55473443", "Itapoá\ \-\ SC",
"55213137", "Rio\ de\ Janeiro\ \-\ RJ",
"55923245", "Manaus\ \-\ AM",
"55273776", "Barra\ de\ São\ Francisco\ \-\ ES",
"55963217", "Macapá\ \-\ AP",
"55283558", "Jerônimo\ Monteiro\ \-\ ES",
"55883413", "Fortim\ \-\ CE",
"55323253", "Tabuleiro\ \-\ MG",
"55282101", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55112785", "São\ Paulo\ \-\ SP",
"55333322", "Caratinga\ \-\ MG",
"55343513", "Araguari\ \-\ MG",
"55663437", "Campinápolis\ \-\ MT",
"55733206", "Mucuri\ \-\ BA",
"55614062", "Brasília\ \-\ DF",
"55513422", "Barro\ Vermelho\ \-\ RS",
"55313769", "Conselheiro\ Lafaiete\ \-\ MG",
"55214007", "Rio\ de\ Janeiro\ \-\ RJ",
"55513463", "Rio\ Grande\ do\ Sul",
"55913120", "Belém\ \-\ PA",
"55383758", "Augusto\ de\ Lima\ \-\ MG",
"55513602", "Caraá\ \-\ RS",
"55843258", "São\ Tomé\ \-\ RN",
"55353629", "Itajubá\ \-\ MG",
"55623348", "Mozarlândia\ \-\ GO",
"55663571", "Colniza\ \-\ MT",
"55623612", "Goiânia\ \-\ GO",
"55343818", "Patos\ de\ Minas\ \-\ MG",
"55543447", "Vila\ Flores\ \-\ RS",
"55433432", "Jandaia\ do\ Sul\ \-\ PR",
"55993646", "Lima\ Campos\ \-\ MA",
"55413393", "Campo\ Largo\ \-\ PR",
"55813684", "São\ Benedito\ do\ Sul\ \-\ PE",
"55483644", "Laguna\ \-\ SC",
"55773485", "Carinhanha\ \-\ BA",
"55183356", "Echaporã\ \-\ SP",
"55493908", "Fraiburgo\ \-\ SC",
"55114662", "Embu\-Guaçu\ \-\ SP",
"55193562", "Pirassununga\ \-\ SP",
"55483231", "Florianópolis\ \-\ SC",
"55114403", "Itu\ \-\ SP",
"55453027", "Foz\ do\ Iguaçu\ \-\ PR",
"55843396", "Lucrécia\ \-\ RN",
"55193979", "Monte\ Mor\ \-\ SP",
"55733683", "Guarani\ \-\ BA",
"55543272", "Guabiju\ \-\ RS",
"55162109", "Araraquara\ \-\ SP",
"55473154", "Rio\ dos\ Cedros\ \-\ SC",
"55332102", "Governador\ Valadares\ \-\ MG",
"55772101", "Vitória\ da\ Conquista\ \-\ BA",
"55193828", "Sumaré\ \-\ SP",
"55423245", "Socavão\ \-\ PR",
"55743632", "Mairi\ \-\ BA",
"55833538", "São\ José\ da\ Lagoa\ Tapada\ \-\ PB",
"55823311", "Maceió\ \-\ AL",
"55313490", "Minas\ Gerais",
"55193324", "Campinas\ \-\ SP",
"55212391", "Rio\ de\ Janeiro\ \-\ RJ",
"55122139", "São\ José\ dos\ Campos\ \-\ SP",
"55343843", "Estrela\ do\ Sul\ \-\ MG",
"55653273", "Curvelândia\ \-\ MT",
"55813478", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55163669", "Cássia\ dos\ Coqueiros\ \-\ SP",
"55773661", "Candiba\ \-\ BA",
"55123864", "São\ Sebastião\ \-\ SP",
"55933536", "Juruti\ \-\ PA",
"55423412", "Mato\ Branco\ de\ Baixo\ \-\ PR",
"55313867", "São\ Sebastião\ do\ Rio\ Preto\ \-\ MG",
"55623541", "Goiânia\ \-\ GO",
"55873842", "Ibimirim\ \-\ PE",
"55114653", "Arujá\ \-\ SP",
"55413150", "Fazenda\ Rio\ Grande\ \-\ PR",
"55273225", "Vitória\ \-\ ES",
"55823543", "Teotônio\ Vilela\ \-\ AL",
"55513783", "Esteio\ \-\ RS",
"55453240", "Medianeira\ \-\ PR",
"55134102", "Guarujá\ \-\ SP",
"55193927", "Piracicaba\ \-\ SP",
"55993535", "Pequiá\ \-\ MA",
"55753690", "Capela\ do\ Alto\ Alegre\ \-\ BA",
"55173622", "Jales\ \-\ SP",
"55283528", "Vargem\ Alta\ \-\ ES",
"55914003", "Belém\ \-\ PA",
"55853366", "Fortaleza\ \-\ CE",
"55373381", "Cláudio\ \-\ MG",
"55112228", "Santo\ André\ \-\ SP",
"55483879", "Florianópolis\ \-\ SC",
"55344009", "Uberlândia\ \-\ MG",
"55333352", "São\ Pedro\ dos\ Ferros\ \-\ MG",
"55663386", "São\ José\ do\ Rio\ Claro\ \-\ MT",
"55313543", "Raposos\ \-\ MG",
"55273272", "Guarapari\ \-\ ES",
"55513452", "Sapucaia\ do\ Sul\ \-\ RS",
"55673238", "Ribas\ do\ Rio\ Pardo\ \-\ MS",
"55173043", "Barretos\ \-\ SP",
"55112473", "Bragança\ Paulista\ \-\ SP",
"55813486", "Recife\ \-\ PE",
"55733537", "Ibirataia\ \-\ BA",
"55643471", "Pontalina\ \-\ GO",
"55693446", "Primavera\ de\ Rondônia\ \-\ RO",
"55743534", "Pilão\ Arcado\ \-\ BA",
"55653265", "Conquista\ D\'Oeste\ \-\ MT",
"55433536", "Ribeirão\ Claro\ \-\ PR",
"55192104", "Campinas\ \-\ SP",
"55843473", "Cruzeta\ \-\ RN",
"5583322", "João\ Pessoa\ \-\ PB",
"55473901", "Blumenau\ \-\ SC",
"55623407", "São\ Miguel\ do\ Passa\ Quatro\ \-\ GO",
"55383728", "Angueretá\ \-\ MG",
"55115854", "São\ Paulo\ \-\ SP",
"55543294", "Nova\ Roma\ do\ Sul\ \-\ RS",
"55163974", "Ribeirão\ Preto\ \-\ SP",
"55312146", "Sete\ Lagoas\ \-\ MG",
"5531340", "Minas\ Gerais",
"55323262", "Rochedo\ de\ Minas\ \-\ MG",
"55224105", "Nova\ Friburgo\ \-\ RJ",
"55173663", "Santa\ Clara\ D\'Oeste\ \-\ SP",
"55213743", "Nilópolis\ \-\ RJ",
"55493444", "Concórdia\ \-\ SC",
"55333317", "Conceição\ de\ Ipanema\ \-\ MG",
"55633534", "Mateiros\ \-\ TO",
"55843228", "Ceará\-Mirim\ \-\ RN",
"55863285", "Elesbão\ Veloso\ \-\ PI",
"55313848", "Minas\ Gerais",
"5511347", "São\ Paulo\ \-\ SP",
"5553330", "Pelotas\ \-\ RS",
"55613505", "Luziânia\ \-\ GO",
"55123027", "São\ José\ dos\ Campos\ \-\ SP",
"55463263", "Palmas\ \-\ PR",
"55413555", "Campo\ Largo\ \-\ PR",
"55313489", "Minas\ Gerais",
"55333623", "Fronteira\ dos\ Vales\ \-\ MG",
"55913692", "Gurupá\ \-\ PA",
"55173524", "Catanduva\ \-\ SP",
"55193466", "Nova\ Odessa\ \-\ SP",
"55153245", "Votorantim\ \-\ SP",
"55173353", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55673022", "Campo\ Grande\ \-\ MS",
"55493535", "Arroio\ Trinta\ \-\ SC",
"55423457", "Rebouças\ \-\ PR",
"55373247", "Igaratinga\ \-\ MG",
"55653339", "Tangará\ da\ Serra\ \-\ MT",
"5511592", "São\ Paulo\ \-\ SP",
"55844102", "Natal\ \-\ RN",
"55414003", "Curitiba\ \-\ PR",
"55312564", "Contagem\ \-\ MG",
"55173330", "Guaíra\ \-\ SP",
"55112136", "Jundiaí\ \-\ SP",
"55883448", "Parambu\ \-\ CE",
"55193858", "Engenheiro\ Coelho\ \-\ SP",
"55713198", "Salvador\ \-\ BA",
"55453281", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55114284", "Mogi\ das\ Cruzes\ \-\ SP",
"55473418", "Joinville\ \-\ SC",
"55373425", "Luz\ \-\ MG",
"55663468", "Água\ Boa\ \-\ MT",
"55112653", "São\ Paulo\ \-\ SP",
"55513672", "Tapes\ \-\ RS",
"55553528", "Campo\ Novo\ \-\ RS",
"55513721", "Triunfo\ \-\ RS",
"55173576", "Ariranha\ \-\ SP",
"55423235", "Ponta\ Grossa\ \-\ PR",
"55843375", "Taboleiro\ Grande\ \-\ RN",
"55983387", "Palmeirândia\ \-\ MA",
"55793263", "Capela\ \-\ SE",
"55183285", "Caiabu\ \-\ SP",
"55813281", "Recife\ \-\ PE",
"55654001", "Cuiabá\ \-\ MT",
"55423659", "Samambaia\ \-\ PR",
"55673213", "Campo\ Grande\ \-\ MS",
"55483241", "São\ José\ \-\ SC",
"55663501", "Alta\ Floresta\ \-\ MT",
"55843284", "Serrinha\ \-\ RN",
"55854003", "Fortaleza\ \-\ CE",
"55317", "Minas\ Gerais",
"55453262", "Matelândia\ \-\ PR",
"55913366", "Belém\ \-\ PA",
"55623609", "Goiânia\ \-\ GO",
"55652137", "Várzea\ Grande\ \-\ MT",
"55113518", "São\ Paulo\ \-\ SP",
"55833513", "João\ Pessoa\ \-\ PB",
"551155", "São\ Paulo\ \-\ SP",
"55623338", "Corumbá\ de\ Goiás\ \-\ GO",
"55114473", "Santo\ André\ \-\ SP",
"55693532", "Cacaulândia\ \-\ RO",
"55993636", "Poção\ de\ Pedras\ \-\ MA",
"55513625", "Capão\ da\ Canoa\ \-\ RS",
"55433442", "Bom\ Sucesso\ \-\ PR",
"55813658", "Glória\ do\ Goitá\ \-\ PE",
"55863326", "Timon\ \-\ MA",
"55323281", "Lima\ Duarte\ \-\ MG",
"55143287", "Avaí\ \-\ SP",
"55195657", "São\ Paulo\ \-\ SP",
"55943385", "Vila\ Santa\ Fé\ \-\ PA",
"55773498", "Formoso\ A\ \-\ BA",
"55513619", "Rio\ Grande\ do\ Sul",
"55443421", "Paranavaí\ \-\ PR",
"55373323", "Pains\ \-\ MG",
"55193909", "Hortolândia\ \-\ SP",
"55833341", "Campina\ Grande\ \-\ PB",
"55613552", "Núcleo\ Bandeirante\ \-\ DF",
"55913656", "Santa\ Bárbara\ do\ Pará\ \-\ PA",
"55242566", "Bom\ Jardim\ \-\ RJ",
"55353457", "Heliodora\ \-\ MG",
"55833399", "Massaranduba\ \-\ PB",
"55413604", "Fazenda\ Rio\ Grande\ \-\ PR",
"55793275", "Maruim\ \-\ SE",
"55193388", "Campinas\ \-\ SP",
"55273754", "Montanha\ \-\ ES",
"55653029", "Várzea\ Grande\ \-\ MT",
"55222105", "Macaé\ \-\ RJ",
"55553351", "Pirapó\ \-\ RS",
"55953262", "Normandia\ \-\ RR",
"55313520", "Minas\ Gerais",
"55193708", "Campinas\ \-\ SP",
"55423677", "Pinhão\ \-\ PR",
"55483532", "Praia\ Grande\ \-\ SC",
"55623429", "Posse\ \-\ GO",
"55242430", "Barra\ do\ Piraí\ \-\ RJ",
"55613606", "Santo\ Antônio\ do\ Descoberto\ \-\ GO",
"55612030", "Brasília\ \-\ DF",
"5588", "Ceará",
"55433259", "Jataizinho\ \-\ PR",
"55733288", "Porto\ Seguro\ \-\ BA",
"55613517", "Brasília\ \-\ DF",
"55242453", "Valença\ \-\ RJ",
"55133375", "Cubatão\ \-\ SP",
"55843363", "Rafael\ Godeiro\ \-\ RN",
"55513405", "Rio\ Grande\ do\ Sul",
"55313334", "Minas\ Gerais",
"55613364", "Brasília\ \-\ DF",
"55833380", "Puxinanã\ \-\ PB",
"55883669", "Vila\ de\ Jericoacoara\ \-\ CE",
"55114136", "Araçariguama\ \-\ SP",
"55862106", "Teresina\ \-\ PI",
"55943421", "Conceição\ do\ Araguaia\ \-\ PA",
"55112284", "Osasco\ \-\ SP",
"55833287", "Mari\ \-\ PB",
"55823520", "Girau\ do\ Ponciano\ \-\ AL",
"55913118", "Belém\ \-\ PA",
"55913424", "Redenção\ \-\ PA",
"55323347", "Ibertioga\ \-\ MG",
"55413656", "Colombo\ \-\ PR",
"55793222", "Aracaju\ \-\ SE",
"55183693", "Piacatu\ \-\ SP",
"55923369", "Careiro\ da\ Várzea\ \-\ AM",
"55513496", "Gravataí\ \-\ RS",
"55773682", "Iuiú\ \-\ BA",
"5561334", "Brasília\ \-\ DF",
"5519363", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55823334", "Maceió\ \-\ AL",
"55833051", "Campina\ Grande\ \-\ PB",
"55853133", "Fortaleza\ \-\ CE",
"55443274", "Sarandi\ \-\ PR",
"55343820", "Patos\ de\ Minas\ \-\ MG",
"55713612", "Salvador\ \-\ BA",
"55733276", "Apuarema\ \-\ BA",
"55843653", "Natal\ \-\ RN",
"55493636", "São\ João\ do\ Oeste\ \-\ SC",
"55115704", "Itupeva\ \-\ SP",
"55643651", "Quirinópolis\ \-\ GO",
"55114032", "Bragança\ Paulista\ \-\ SP",
"55863304", "Teresina\ \-\ PI",
"55513751", "Encantado\ \-\ RS",
"55653391", "Cuiabá\ \-\ MT",
"55653349", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55552101", "Santa\ Maria\ \-\ RS",
"55112861", "São\ Paulo\ \-\ SP",
"55114681", "Juquitiba\ \-\ SP",
"55493545", "Abdon\ Batista\ \-\ SC",
"55112623", "São\ Paulo\ \-\ SP",
"55633435", "Arapoema\ \-\ TO",
"55163904", "Ribeirão\ Preto\ \-\ SP",
"55843662", "Natal\ \-\ RN",
"55193581", "Porto\ Ferreira\ \-\ SP",
"55863298", "Angical\ do\ Piauí\ \-\ PI",
"55883438", "Choró\ \-\ CE",
"55793217", "Aracaju\ \-\ SE",
"55683216", "Rio\ Branco\ \-\ AC",
"55543378", "Ernestina\ \-\ RS",
"55222748", "Travessão\ \-\ RJ",
"55353734", "Santa\ Rita\ de\ Caldas\ \-\ MG",
"55173472", "Nhandeara\ \-\ SP",
"55713627", "Camaçari\ \-\ BA",
"55793449", "Ribeirópolis\ \-\ SE",
"5531347", "Belo\ Horizonte\ \-\ MG",
"55373402", "Itaúna\ \-\ MG",
"55483214", "São\ José\ \-\ SC",
"55543386", "Muliterno\ \-\ RS",
"55213733", "Rio\ de\ Janeiro\ \-\ RJ",
"55493434", "Vargeão\ \-\ SC",
"55613456", "Taguatinga\ \-\ DF",
"55834009", "João\ Pessoa\ \-\ PB",
"55114785", "Embu\ das\ Artes\ \-\ SP",
"55753336", "Wagner\ \-\ BA",
"55313194", "Belo\ Horizonte\ \-\ MG",
"55813628", "Limoeiro\ \-\ PE",
"55163307", "São\ Carlos\ \-\ SP",
"55513655", "General\ Câmara\ \-\ RS",
"55473055", "Jaraguá\ do\ Sul\ \-\ SC",
"55313838", "Santa\ Maria\ de\ Itabira\ \-\ MG",
"55163956", "Pontal\ \-\ SP",
"55373524", "Martinho\ Campos\ \-\ MG",
"55373353", "Iguatama\ \-\ MG",
"55433546", "Ibaiti\ \-\ PR",
"55513694", "Minas\ do\ Leão\ \-\ RS",
"55973345", "Alvarães\ \-\ AM",
"55623010", "Senador\ Canedo\ \-\ GO",
"55193884", "Paulínia\ \-\ SP",
"55112317", "São\ Paulo\ \-\ SP",
"55833567", "Cabedelo\ \-\ PB",
"55613522", "Brasília\ \-\ DF",
"55312136", "Ipatinga\ \-\ MG",
"55833314", "São\ José\ da\ Mata\ \-\ PB",
"55513239", "Rio\ Grande\ do\ Sul",
"55613563", "Taguatinga\ \-\ DF",
"55313533", "Ibirité\ \-\ MG",
"55813561", "Ipojuca\ \-\ PE",
"55983214", "São\ Luís\ \-\ MA",
"55313550", "Minas\ Gerais",
"55733547", "Aiquara\ \-\ BA",
"55483436", "Nova\ Veneza\ \-\ SC",
"55553321", "Cruz\ Alta\ \-\ RS",
"55673248", "Costa\ Rica\ \-\ MS",
"55273724", "Marilândia\ \-\ ES",
"55993545", "São\ Domingos\ do\ Azeitão\ \-\ MA",
"55623459", "Alto\ Paraíso\ de\ Goiás\ \-\ GO",
"55643547", "Indiara\ \-\ GO",
"55193493", "Rio\ das\ Pedras\ \-\ SP",
"55222767", "Cambuci\ \-\ RJ",
"55112352", "São\ Paulo\ \-\ SP",
"55163413", "São\ Carlos\ \-\ SP",
"55453253", "Nova\ Santa\ Rosa\ \-\ PR",
"5511362", "São\ Paulo\ \-\ SP",
"55453230", "Diamante\ do\ Sul\ \-\ PR",
"55823533", "Jaramataia\ \-\ AL",
"55793252", "Aracaju\ \-\ SE",
"55733621", "Dário\ Meira\ \-\ BA",
"55413626", "Mandirituba\ \-\ PR",
"55144009", "Bauru\ \-\ SP",
"55194126", "Itapira\ \-\ SP",
"55513592", "São\ Leopoldo\ \-\ RS",
"55743642", "Irecê\ \-\ BA",
"55963521", "Oiapoque\ \-\ AP",
"55643621", "Rio\ Verde\ \-\ GO",
"55173268", "Onda\ Verde\ \-\ SP",
"55343833", "Serra\ do\ Salitre\ \-\ MG",
"55212608", "Niterói\ \-\ RJ",
"55613624", "Valparaíso\ de\ Goiás\ \-\ GO",
"55112662", "São\ Paulo\ \-\ SP",
"55114882", "Carapicuíba\ \-\ SP",
"55613607", "Distrito\ de\ Campos\ Lindos\ \-\ GO",
"55443343", "Maringá\ \-\ PR",
"55813689", "Jaqueira\ \-\ PE",
"55423251", "Papagaios\ Novos\ \-\ PR",
"55833423", "Patos\ \-\ PB",
"55353563", "Bom\ Jesus\ da\ Penha\ \-\ MG",
"55633421", "Araguaína\ \-\ TO",
"55813738", "Cupira\ \-\ PE",
"55643442", "Catalão\ \-\ GO",
"55834105", "Cabedelo\ \-\ PB",
"55114718", "Mairinque\ \-\ SP",
"55833278", "Alagoinha\ \-\ PB",
"55713118", "Salvador\ \-\ BA",
"55413058", "São\ José\ dos\ Pinhais\ \-\ PR",
"55423676", "Faxinal\ da\ Boa\ Vista\ \-\ PR",
"55613966", "Brasília\ \-\ DF",
"55223850", "Miracema\ \-\ RJ",
"55733277", "Guaratinga\ \-\ BA",
"55223833", "Bom\ Jesus\ do\ Itabapoana\ \-\ RJ",
"55463535", "Verê\ \-\ PR",
"55493637", "Cristo\ Rei\ \-\ SC",
"55183638", "Birigui\ \-\ SP",
"55173845", "Meridiano\ \-\ SP",
"55533252", "Canguçu\ \-\ RS",
"55862107", "Teresina\ \-\ PI",
"55114137", "Taboão\ da\ Serra\ \-\ SP",
"55753262", "Conceição\ do\ Coité\ \-\ BA",
"55853198", "Fortaleza\ \-\ CE",
"55833286", "Caaporã\ \-\ PB",
"55353624", "Delfim\ Moreira\ \-\ MG",
"55823203", "Ibateguara\ \-\ AL",
"55333743", "Felisburgo\ \-\ MG",
"55163135", "Rifaina\ \-\ SP",
"55424062", "Ponta\ Grossa\ \-\ PR",
"55413657", "Almirante\ Tamandaré\ \-\ PR",
"55323346", "Antônio\ Carlos\ \-\ MG",
"55193377", "Piracicaba\ \-\ SP",
"55513497", "Gravataí\ \-\ RS",
"55483378", "Santa\ Tereza\ \-\ SC",
"5581342", "Recife\ \-\ PE",
"55793712", "Aracaju\ \-\ SE",
"55713656", "São\ Sebastião\ do\ Passé\ \-\ BA",
"55983386", "Guimarães\ \-\ MA",
"55553335", "Eugênio\ de\ Castro\ \-\ RS",
"55383233", "Francisco\ Sá\ \-\ MG",
"55873871", "Salgueiro\ \-\ PE",
"55313391", "Contagem\ \-\ MG",
"55193669", "Divinolândia\ \-\ SP",
"55623572", "Goiânia\ \-\ GO",
"55143278", "Lençóis\ Paulista\ \-\ SP",
"55343355", "Pedrinópolis\ \-\ MG",
"5519375", "Campinas\ \-\ SP",
"55163324", "Araraquara\ \-\ SP",
"55713271", "Salvador\ \-\ BA",
"55443209", "Nova\ Esperança\ \-\ PR",
"55313764", "Conselheiro\ Lafaiete\ \-\ MG",
"55633385", "Talismã\ \-\ TO",
"55313686", "Confins\ \-\ MG",
"55433276", "Arapongas\ \-\ PR",
"55143286", "Lucianópolis\ \-\ SP",
"5521262", "Niterói\ \-\ RJ",
"55313410", "Minas\ Gerais",
"55273299", "Vila\ Velha\ \-\ ES",
"55623393", "Bonópolis\ \-\ GO",
"55214125", "Belford\ Roxo\ \-\ RJ",
"55713604", "Madre\ de\ Deus\ \-\ BA",
"55493275", "Otacílio\ Costa\ \-\ SC",
"55993263", "Imperatriz\ \-\ MA",
"55983378", "Pedro\ do\ Rosário\ \-\ MA",
"55413679", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55353456", "Natércia\ \-\ MG",
"55533310", "Pelotas\ \-\ RS",
"55513509", "São\ Leopoldo\ \-\ RS",
"55733259", "Ibirapitanga\ \-\ BA",
"5531374", "Minas\ Gerais",
"55353522", "Passos\ \-\ MG",
"55913811", "Ipixuna\ do\ Pará\ \-\ PA",
"55833462", "São\ Mamede\ \-\ PB",
"55643635", "Santa\ Rita\ do\ Araguaia\ \-\ GO",
"55823686", "Xingó\ \-\ AL",
"55553269", "São\ João\ do\ Polêsine\ \-\ RS",
"55773433", "Boa\ Nova\ \-\ BA",
"55113608", "Osasco\ \-\ SP",
"55993637", "Joselândia\ \-\ MA",
"55623519", "Goiânia\ \-\ GO",
"55334141", "Governador\ Valadares\ \-\ MG",
"55773450", "Barra\ da\ Estiva\ \-\ BA",
"55833035", "João\ Pessoa\ \-\ PB",
"55453336", "Luz\ Marina\ \-\ PR",
"55313598", "Minas\ Gerais",
"55313029", "Belo\ Horizonte\ \-\ MG",
"55423221", "Telêmaco\ Borba\ \-\ PR",
"55483202", "Florianópolis\ \-\ SC",
"55663542", "Rondolândia\ \-\ MT",
"55473383", "Ascurra\ \-\ SC",
"55213630", "Magé\ \-\ RJ",
"55173529", "Elisiário\ \-\ SP",
"55893573", "Corrente\ \-\ PI",
"55633451", "Rio\ Sono\ \-\ TO",
"55643546", "Itumbiara\ \-\ GO",
"55153251", "Tatuí\ \-\ SP",
"55513735", "Várzea\ do\ Capivarita\ \-\ RS",
"55833453", "Conceição\ \-\ PB",
"55353364", "Pouso\ Alto\ \-\ MG",
"55113585", "São\ Paulo\ \-\ SP",
"55823131", "Maceió\ \-\ AL",
"55733546", "Nova\ Itarana\ \-\ BA",
"55533275", "Capão\ do\ Leão\ \-\ RS",
"55483437", "Criciúma\ \-\ SC",
"55443544", "Tupãssi\ \-\ PR",
"55883581", "Iguatu\ \-\ CE",
"55513631", "Escadinhas\ \-\ RS",
"55473031", "Joinville\ \-\ SC",
"55613479", "Brazlândia\ \-\ DF",
"55833302", "Camalaú\ \-\ PB",
"55163979", "Ribeirão\ Preto\ \-\ SP",
"55143885", "Pirambóia\ \-\ SP",
"55319", "Minas\ Gerais",
"55353695", "São\ Lourenço\ \-\ MG",
"55753684", "Ichu\ \-\ BA",
"55793545", "Tomar\ do\ Geru\ \-\ SE",
"55493449", "Ipuaçu\ \-\ SC",
"55443062", "Paranavaí\ \-\ PR",
"55353654", "Gonçalves\ \-\ MG",
"55853084", "Fortaleza\ \-\ CE",
"55633539", "Lizarda\ \-\ TO",
"55493491", "Seara\ \-\ SC",
"55433401", "Cornélio\ Procópio\ \-\ PR",
"55933547", "Óbidos\ \-\ PA",
"55443435", "Planaltina\ do\ Paraná\ \-\ PR",
"55142122", "Avaré\ \-\ SP",
"55413627", "Fazenda\ Rio\ Grande\ \-\ PR",
"55863250", "Prata\ do\ Piauí\ \-\ PI",
"55753230", "Antônio\ Cardoso\ \-\ BA",
"55473264", "Balneário\ Camboriú\ \-\ SC",
"55493252", "Timbó\ Grande\ \-\ SC",
"55713626", "Camaçari\ \-\ BA",
"55853338", "Beberibe\ \-\ CE",
"55163395", "Rincão\ \-\ SP",
"55543280", "Pedras\ Brancas\ \-\ RS",
"55123105", "Aparecida\ \-\ SP",
"55533263", "Santa\ Vitória\ do\ Palmar\ \-\ RS",
"55383613", "Itacarambi\ \-\ MG",
"55623476", "Colinas\ do\ Tocantins\ \-\ TO",
"5519372", "Campinas\ \-\ SP",
"55163354", "Guarapiranga\ \-\ SP",
"55923221", "Manaus\ \-\ AM",
"55344004", "Uberlândia\ \-\ MG",
"55353283", "Poço\ Fundo\ \-\ MG",
"55143453", "Marília\ \-\ SP",
"55893565", "Santa\ Luz\ \-\ PI",
"55443642", "Guaíra\ \-\ PR",
"55543532", "São\ João\ da\ Urtiga\ \-\ RS",
"55433547", "Figueira\ \-\ PR",
"55943435", "São\ Félix\ do\ Xingu\ \-\ PA",
"55733215", "Itabuna\ \-\ BA",
"55353426", "Senador\ José\ Bento\ \-\ MG",
"55113180", "São\ Paulo\ \-\ SP",
"55313893", "Porto\ Firme\ \-\ MG",
"55122134", "São\ José\ dos\ Campos\ \-\ SP",
"55543387", "Selbach\ \-\ RS",
"55143302", "Ourinhos\ \-\ SP",
"55323026", "Juiz\ de\ Fora\ \-\ MG",
"55353552", "Guaxupé\ \-\ MG",
"55163664", "Brodowski\ \-\ SP",
"55213980", "Rio\ de\ Janeiro\ \-\ RJ",
"55753337", "Utinga\ \-\ BA",
"55222009", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55153492", "Salto\ de\ Pirapora\ \-\ SP",
"55212769", "Nova\ Iguaçu\ \-\ RJ",
"55163306", "São\ Carlos\ \-\ SP",
"55163957", "Ibitiúva\ \-\ SP",
"55623594", "Aparecida\ de\ Goiânia\ \-\ GO",
"55623488", "Simolândia\ \-\ GO",
"55623502", "Bela\ Vista\ de\ Goiás\ \-\ GO",
"55115646", "São\ Paulo\ \-\ SP",
"55183995", "Indiana\ \-\ SP",
"55773443", "Caraíbas\ \-\ BA",
"55913429", "Viseu\ \-\ PA",
"55883523", "Crato\ \-\ CE",
"55643645", "Acreúna\ \-\ GO",
"55923364", "Caapiranga\ \-\ AM",
"55114168", "Barueri\ \-\ SP",
"55543446", "Cotiporã\ \-\ RS",
"55313265", "Minas\ Gerais",
"55993647", "Igarapé\ Grande\ \-\ MA",
"55143355", "Manduri\ \-\ SP",
"5533327", "Governador\ Valadares\ \-\ MG",
"55493668", "Flor\ do\ Sertão\ \-\ SC",
"55733645", "Medeiros\ Neto\ \-\ BA",
"55973485", "Guajará\ \-\ AM",
"55143761", "Itaí\ \-\ SP",
"55343423", "Frutal\ \-\ MG",
"55123004", "São\ José\ dos\ Campos\ \-\ SP",
"55943333", "Itupiranga\ \-\ PA",
"55843397", "Umarizal\ \-\ RN",
"55513579", "São\ Leopoldo\ \-\ RS",
"55823265", "Pilar\ \-\ AL",
"55123152", "Lorena\ \-\ SP",
"55993521", "Caxias\ \-\ MA",
"55273759", "Água\ Doce\ do\ Norte\ \-\ ES",
"55222561", "Santa\ Maria\ Madalena\ \-\ RJ",
"55223021", "Araruama\ \-\ RJ",
"55153522", "Itapeva\ \-\ SP",
"55493358", "Cordilheira\ Alta\ \-\ SC",
"55623089", "Goiânia\ \-\ GO",
"55192127", "Campinas\ \-\ SP",
"55423552", "General\ Carneiro\ \-\ PR",
"55883664", "Marco\ \-\ CE",
"55433254", "Cambé\ \-\ PR",
"55313339", "Belo\ Horizonte\ \-\ MG",
"55613369", "Paranoá\ \-\ DF",
"55453026", "Foz\ do\ Iguaçu\ \-\ PR",
"55993668", "Timbiras\ \-\ MA",
"55173441", "General\ Salgado\ \-\ SP",
"55673016", "Dourados\ \-\ MS",
"55833355", "São\ João\ do\ Cariri\ \-\ PB",
"55443257", "Flórida\ \-\ PR",
"55114147", "Itapecerica\ da\ Serra\ \-\ SP",
"55613677", "Planaltina\ \-\ GO",
"55973321", "Barcelos\ \-\ AM",
"55313428", "Belo\ Horizonte\ \-\ MG",
"55153563", "Guapiara\ \-\ SP",
"55323336", "Desterro\ do\ Melo\ \-\ MG",
"5584320", "Natal\ \-\ RN",
"55623366", "Mara\ Rosa\ \-\ GO",
"55353221", "Varginha\ \-\ MG",
"55123117", "São\ José\ do\ Barreiro\ \-\ SP",
"55333733", "Itinga\ \-\ MG",
"55163145", "Patrocínio\ Paulista\ \-\ SP",
"55513614", "Maratá\ \-\ RS",
"55323748", "Pedra\ Dourada\ \-\ MG",
"55833208", "João\ Pessoa\ \-\ PB",
"55543611", "André\ da\ Rocha\ \-\ RS",
"55183648", "Juritis\ \-\ SP",
"55833394", "Ingá\ \-\ PB",
"55493647", "Palmitos\ \-\ SC",
"55193904", "Mogi\ Mirim\ \-\ SP",
"55643998", "Itumbiara\ \-\ GO",
"55463545", "Nova\ Prata\ do\ Iguaçu\ \-\ PR",
"55223843", "Varre\-Sai\ \-\ RJ",
"55653311", "Tangará\ da\ Serra\ \-\ MT",
"55483255", "Imbituba\ \-\ SC",
"55183379", "São\ José\ Laranjeiras\ \-\ SP",
"55224009", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55643432", "Itumbiara\ \-\ GO",
"55753628", "São\ Felipe\ \-\ BA",
"55213032", "Rio\ de\ Janeiro\ \-\ RJ",
"55353100", "Extrema\ \-\ MG",
"55913746", "Bujaru\ \-\ PA",
"55663436", "Poxoréo\ \-\ MT",
"55115908", "São\ Paulo\ \-\ SP",
"55793297", "Siriri\ \-\ SE",
"55733207", "Nova\ Canaã\ \-\ BA",
"55115066", "São\ Paulo\ \-\ SP",
"55273064", "Serra\ \-\ ES",
"55513557", "Rio\ Grande\ do\ Sul",
"55823273", "Coruripe\ \-\ AL",
"55373431", "Bambuí\ \-\ MG",
"55673461", "Naviraí\ \-\ MS",
"55153624", "Itapeva\ \-\ SP",
"55193307", "Campinas\ \-\ SP",
"55493521", "Joaçaba\ \-\ SC",
"55843289", "Serra\ de\ São\ Bento\ \-\ RN",
"55793411", "Nossa\ Senhora\ da\ Glória\ \-\ SE",
"55813748", "Sairé\ \-\ PE",
"55423654", "Catuporanga\ \-\ PR",
"55883562", "Mineirolândia\ \-\ CE",
"55883553", "Milagres\ \-\ CE",
"55333316", "Pocrane\ \-\ MG",
"55883530", "Araripe\ \-\ CE",
"55163810", "São\ Joaquim\ da\ Barra\ \-\ SP",
"5564400", "Itumbiara\ \-\ GO",
"55893464", "Caridade\ do\ Piauí\ \-\ PI",
"55513416", "Capão\ da\ Canoa\ \-\ RS",
"55553433", "Itaqui\ \-\ RS",
"55833481", "Água\ Branca\ \-\ PB",
"55693447", "Parecis\ \-\ RO",
"55633483", "Bom\ Jesus\ do\ Tocantins\ \-\ TO",
"55163708", "Franca\ \-\ SP",
"55144004", "Bauru\ \-\ SP",
"55153283", "Laranjal\ Paulista\ \-\ SP",
"55433537", "Barra\ do\ Jacaré\ \-\ PR",
"55143325", "Ourinhos\ \-\ SP",
"55613629", "Valparaíso\ de\ Goiás\ \-\ GO",
"55343453", "Limeira\ do\ Oeste\ \-\ MG",
"55623406", "Buritinópolis\ \-\ GO",
"55473351", "Brusque\ \-\ SC",
"55983272", "São\ Luís\ \-\ MA",
"55813869", "Santa\ Maria\ da\ Boa\ Vista\ \-\ PE",
"55653102", "Nobres\ \-\ MT",
"55373246", "Igaratinga\ \-\ MG",
"55222793", "Macaé\ \-\ RJ",
"55443632", "Xambrê\ \-\ PR",
"5516363", "Ribeirão\ Preto\ \-\ SP",
"55653054", "Cuiabá\ \-\ MT",
"55993551", "São\ João\ dos\ Patos\ \-\ MA",
"55873783", "Caetés\ \-\ PE",
"55273729", "São\ Roque\ do\ Canaã\ \-\ ES",
"55853348", "Pacajus\ \-\ CE",
"55123026", "Taubaté\ \-\ SP",
"55493328", "Chapecó\ \-\ SC",
"55513680", "Quintão\ \-\ RS",
"55223051", "Macaé\ \-\ RJ",
"55153552", "Apiaí\ \-\ SP",
"55473080", "Blumenau\ \-\ SC",
"55613597", "Taguatinga\ \-\ DF",
"55453056", "Toledo\ \-\ PR",
"55143372", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55433224", "Santo\ Antônio\ do\ Paraíso\ \-\ PR",
"55863243", "Porto\ \-\ PI",
"55423522", "União\ da\ Vitória\ \-\ PR",
"55933537", "Mujuí\ dos\ Campos\ \-\ PA",
"55923575", "Itapiranga\ \-\ AM",
"55853260", "Eusébio\ \-\ CE",
"55313866", "Dom\ Joaquim\ \-\ MG",
"55493439", "Linha\ Planalto\ \-\ SC",
"55143481", "Marília\ \-\ SP",
"55353251", "Cambuquira\ \-\ MG",
"55483272", "Antônio\ Carlos\ \-\ SC",
"55513930", "Porto\ Alegre\ \-\ RS",
"55443445", "São\ João\ do\ Caiuá\ \-\ PR",
"55212687", "Itaguaí\ \-\ RJ",
"55713555", "Salvador\ \-\ BA",
"55973351", "Beruri\ \-\ AM",
"55714003", "Salvador\ \-\ BA",
"55713594", "Simões\ Filho\ \-\ BA",
"55193889", "Monte\ Mor\ \-\ SP",
"55153364", "Boituva\ \-\ SP",
"55473041", "Blumenau\ \-\ SC",
"55753281", "Paulo\ Afonso\ \-\ BA",
"55513699", "Rio\ Grande\ do\ Sul",
"55743549", "Rômulo\ Campos\ \-\ BA",
"55142105", "Marília\ \-\ SP",
"55513234", "Rio\ Grande\ do\ Sul",
"55192112", "Rio\ Claro\ \-\ SP",
"55543231", "Vacaria\ \-\ RS",
"55753658", "Fátima\ \-\ BA",
"55383218", "Montes\ Claros\ \-\ MG",
"55653344", "Jangada\ \-\ MT",
"55623626", "Goiânia\ \-\ GO",
"55483447", "Cocal\ do\ Sul\ \-\ SC",
"55212088", "São\ Gonçalo\ \-\ RJ",
"55443534", "Mariluz\ \-\ PR",
"55733536", "Santa\ Inês\ \-\ BA",
"55193448", "Ibitiruna\ \-\ SP",
"55833372", "Cuité\ \-\ PB",
"55663532", "Sinop\ \-\ MT",
"55833440", "Brejo\ dos\ Santos\ \-\ PB",
"55353739", "Andradas\ \-\ MG",
"55983468", "São\ Benedito\ do\ Rio\ Preto\ \-\ MA",
"55453346", "São\ João\ d\'Oeste\ \-\ PR",
"55433471", "Jacutinga\ \-\ PR",
"55553025", "Santa\ Maria\ \-\ RS",
"55513745", "Segredo\ \-\ RS",
"55493551", "Joaçaba\ \-\ SC",
"55914005", "Belém\ \-\ PA",
"55813272", "Recife\ \-\ PE",
"55212647", "Magé\ \-\ RJ",
"55943321", "Marabá\ \-\ PA",
"55112504", "São\ Paulo\ \-\ SP",
"55193476", "Nova\ Odessa\ \-\ SP",
"55513396", "Rio\ Grande\ do\ Sul",
"55113444", "São\ Paulo\ \-\ SP",
"55993533", "Buritirana\ \-\ MA",
"55323447", "Leopoldina\ \-\ MG",
"55143441", "Tupã\ \-\ SP",
"55173045", "Catanduva\ \-\ SP",
"55453378", "Toledo\ \-\ PR",
"55753634", "Amargosa\ \-\ BA",
"55653222", "Cáceres\ \-\ MT",
"5561344", "Brasília\ \-\ DF",
"55115029", "São\ Paulo\ \-\ SP",
"55313727", "Capela\ Nova\ \-\ MG",
"55553539", "Independência\ \-\ RS",
"55193891", "Mogi\-Guaçu\ \-\ SP",
"55383624", "São\ Romão\ \-\ MG",
"55313545", "Rio\ Acima\ \-\ MG",
"55114751", "Suzano\ \-\ SP",
"55193849", "Valinhos\ \-\ SP",
"55442101", "Maringá\ \-\ PR",
"55163514", "Ribeirão\ Preto\ \-\ SP",
"55443014", "Marialva\ \-\ PR",
"55473081", "Balneário\ Camboriú\ \-\ SC",
"55753241", "Santo\ Amaro\ \-\ BA",
"55433156", "Rolândia\ \-\ PR",
"55513681", "Cidreira\ \-\ RS",
"5511346", "São\ Paulo\ \-\ SP",
"55883531", "Brejo\ Santo\ \-\ CE",
"55343845", "Iraí\ de\ Minas\ \-\ MG",
"55163811", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55183221", "Presidente\ Prudente\ \-\ SP",
"55194003", "Campinas\ \-\ SP",
"55193488", "Mombuca\ \-\ SP",
"55383563", "São\ Gonçalo\ do\ Abaeté\ \-\ MG",
"55193594", "Descalvado\ \-\ SP",
"55813447", "Recife\ \-\ PE",
"55673432", "Ponta\ Porã\ \-\ MS",
"55323272", "Simão\ Pereira\ \-\ MG",
"55114694", "Biritiba\-Mirim\ \-\ SP",
"55653384", "Porto\ Estrela\ \-\ MT",
"55213842", "Duque\ de\ Caxias\ \-\ RJ",
"55473350", "Brusque\ \-\ SC",
"55933017", "Santarém\ \-\ PA",
"55513785", "Rio\ Grande\ do\ Sul",
"55114655", "Arujá\ \-\ SP",
"55273223", "Vitória\ \-\ ES",
"55313859", "João\ Monlevade\ \-\ MG",
"55473333", "Indaial\ \-\ SC",
"55833480", "Igaracy\ \-\ PB",
"55343431", "Prata\ \-\ MG",
"55114000", "Arujá\ \-\ SP",
"55193555", "Leme\ \-\ SP",
"55643461", "Pires\ do\ Rio\ \-\ GO",
"55653275", "Glória\ D\'Oeste\ \-\ MT",
"55243064", "Petrópolis\ \-\ RJ",
"55313434", "Belo\ Horizonte\ \-\ MG",
"55623438", "São\ João\ D\'Aliança\ \-\ GO",
"55823216", "Maceió\ \-\ AL",
"55143732", "Avaré\ \-\ SP",
"55114373", "São\ Paulo\ \-\ SP",
"55373278", "Pequi\ \-\ MG",
"55843422", "Mossoró\ \-\ RN",
"55333625", "Serra\ dos\ Aimorés\ \-\ MG",
"55753387", "Quijingue\ \-\ BA",
"55433618", "Ibaiti\ \-\ PR",
"55942101", "Marabá\ \-\ PA",
"55212668", "Nova\ Iguaçu\ \-\ RJ",
"55913011", "Paragominas\ \-\ PA",
"55273262", "Guarapari\ \-\ ES",
"55433342", "Londrina\ \-\ PR",
"55543337", "Estação\ \-\ RS",
"55163348", "Motuca\ \-\ SP",
"55373423", "Tapiraí\ \-\ MG",
"55853376", "Guaiúba\ \-\ CE",
"55213699", "Queimados\ \-\ RJ",
"55113153", "São\ Paulo\ \-\ SP",
"55833441", "Catolé\ do\ Rocha\ \-\ PB",
"55353068", "Varginha\ \-\ MG",
"55833499", "Aguiar\ \-\ PB",
"55153243", "Votorantim\ \-\ SP",
"55493533", "Videira\ \-\ SC",
"55173355", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55513931", "Porto\ Alegre\ \-\ RS",
"55212774", "São\ João\ de\ Meriti\ \-\ RJ",
"55433017", "Londrina\ \-\ PR",
"55813468", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55333721", "Almenara\ \-\ MG",
"55313216", "Minas\ Gerais",
"55843475", "Equador\ \-\ RN",
"55773671", "Sítio\ do\ Mato\ \-\ BA",
"55413282", "São\ José\ dos\ Pinhais\ \-\ PR",
"55373286", "São\ Sebastião\ do\ Oeste\ \-\ MG",
"55114592", "Itupeva\ \-\ SP",
"55473212", "Brusque\ \-\ SC",
"55313877", "Jequeri\ \-\ MG",
"55983487", "Paulino\ Neves\ \-\ MA",
"55512125", "Porto\ Alegre\ \-\ RS",
"55613503", "Planaltina\ \-\ GO",
"55843504", "Caicó\ \-\ RN",
"55813501", "Ipojuca\ \-\ PE",
"55213745", "Nova\ Iguaçu\ \-\ RJ",
"55913466", "Marudá\ \-\ PA",
"55653637", "Cuiabá\ \-\ MT",
"55543253", "Jaquirana\ \-\ RS",
"55943351", "Palestina\ do\ Pará\ \-\ PA",
"55883415", "Palhano\ \-\ CE",
"55323255", "Ewbank\ da\ Câmara\ \-\ MG",
"55273337", "Vitória\ \-\ ES",
"55473445", "Garuva\ \-\ SC",
"55124158", "Vargem\ Grande\ Paulista\ \-\ SP",
"55143414", "Marília\ \-\ SP",
"55173481", "São\ João\ das\ Duas\ Pontes\ \-\ SP",
"55113411", "São\ Paulo\ \-\ SP",
"55423638", "Candói\ \-\ PR",
"55112303", "Guarulhos\ \-\ SP",
"55922129", "Manaus\ \-\ AM",
"55313757", "Itaverava\ \-\ MG",
"55193572", "Leme\ \-\ SP",
"55352107", "Poços\ de\ Caldas\ \-\ MG",
"55213512", "Rio\ de\ Janeiro\ \-\ RJ",
"5521301", "Rio\ de\ Janeiro\ \-\ RJ",
"55443528", "Assis\ Chateaubriand\ \-\ PR",
"55343515", "Patrocínio\ \-\ MG",
"5562", "Goiás",
"55112783", "São\ Paulo\ \-\ SP",
"55883429", "Alto\ Santo\ \-\ CE",
"55713121", "Camaçari\ \-\ BA",
"55323294", "Bocaina\ de\ Minas\ \-\ MG",
"55473534", "Agrolândia\ \-\ SC",
"55193519", "Campinas\ \-\ SP",
"55843417", "Caicó\ \-\ RN",
"55183251", "Presidente\ Epitácio\ \-\ SP",
"55733293", "Alcobaça\ \-\ BA",
"55933063", "Santarém\ \-\ PA",
"55553421", "Alegrete\ \-\ RS",
"55813255", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55383749", "Pirapora\ \-\ MG",
"55114619", "Jandira\ \-\ SP",
"55663561", "Itaúba\ \-\ MT",
"55843249", "Espírito\ Santo\ \-\ RN",
"55273253", "Serra\ \-\ ES",
"55623359", "Jesúpolis\ \-\ GO",
"55663408", "São\ José\ do\ Couto\ \-\ MT",
"55843291", "Santa\ Cruz\ \-\ RN",
"55413562", "Colombo\ \-\ PR",
"55333373", "Santana\ do\ Manhuaçu\ \-\ MG",
"55813639", "Macaparana\ \-\ PE",
"55513473", "Esteio\ \-\ RS",
"55613356", "Taguatinga\ \-\ DF",
"55114405", "Piracaia\ \-\ SP",
"55553796", "Alpestre\ \-\ RS",
"55113389", "São\ Paulo\ \-\ SP",
"55213923", "Rio\ de\ Janeiro\ \-\ RJ",
"55493334", "Saudades\ \-\ SC",
"55313779", "Sete\ Lagoas\ \-\ MG",
"55773483", "Santa\ Maria\ da\ Vitória\ \-\ BA",
"55643685", "Ivolândia\ \-\ GO",
"55714109", "Salvador\ \-\ BA",
"55753436", "Olindina\ \-\ BA",
"55413523", "Curitiba\ \-\ PR",
"55423243", "Ponta\ Grossa\ \-\ PR",
"55443351", "Cianorte\ \-\ PR",
"55212792", "Nilópolis\ \-\ RJ",
"55193674", "Casa\ Branca\ \-\ SP",
"5582337", "Maceió\ \-\ AL",
"55174004", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55353327", "Carrancas\ \-\ MG",
"55123892", "São\ Sebastião\ \-\ SP",
"55843526", "Porto\ do\ Mangue\ \-\ RN",
"55613298", "Brasília\ \-\ DF",
"55663027", "Rondonópolis\ \-\ MT",
"55653491", "Itiquira\ \-\ MT",
"55623377", "Formoso\ \-\ GO",
"5551353", "Rio\ Grande\ do\ Sul",
"55513032", "Canoas\ \-\ RS",
"55114871", "São\ Paulo\ \-\ SP",
"55133291", "Santos\ \-\ SP",
"55473632", "Campo\ Alegre\ \-\ SC",
"55613304", "Guará\ \-\ DF",
"55513465", "Canoas\ \-\ RS",
"55343246", "Araguari\ \-\ MG",
"55543478", "Vista\ Alegre\ do\ Prata\ \-\ RS",
"55333751", "Pedra\ Azul\ \-\ MG",
"55413664", "Doutor\ Ulysses\ \-\ PR",
"55114496", "Itupeva\ \-\ SP",
"55313712", "Matozinhos\ \-\ MG",
"55193768", "Campinas\ \-\ SP",
"55793349", "Porto\ da\ Folha\ \-\ SE",
"55733301", "Itabuna\ \-\ BA",
"55623091", "Goiânia\ \-\ GO",
"55513653", "Taquari\ \-\ RS",
"55173278", "União\ Paulista\ \-\ SP",
"55212756", "São\ João\ de\ Meriti\ \-\ RJ",
"55114783", "Embu\ das\ Artes\ \-\ SP",
"55222542", "Nova\ Friburgo\ \-\ RJ",
"55713183", "Salvador\ \-\ BA",
"55513630", "Rio\ Grande\ do\ Sul",
"55173423", "Votuporanga\ \-\ SP",
"55313130", "Matozinhos\ \-\ MG",
"55773274", "Macarani\ \-\ BA",
"55323571", "Rio\ Pomba\ \-\ MG",
"55553752", "Ametista\ do\ Sul\ \-\ RS",
"55833559", "Bom\ Jesus\ \-\ PB",
"55513941", "Canoas\ \-\ RS",
"55613392", "Santa\ Maria\ \-\ DF",
"55973343", "Tefé\ \-\ AM",
"55313153", "Sete\ Lagoas\ \-\ MG",
"55373355", "Doresópolis\ \-\ MG",
"55853306", "Fortaleza\ \-\ CE",
"55183522", "Adamantina\ \-\ SP",
"5511412", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55513363", "Rio\ Grande\ do\ Sul",
"55843405", "Currais\ Novos\ \-\ RN",
"55163338", "Gavião\ Peixoto\ \-\ SP",
"55222777", "Rio\ das\ Ostras\ \-\ RJ",
"55112625", "São\ Paulo\ \-\ SP",
"55493543", "Anita\ Garibaldi\ \-\ SC",
"55212704", "Niterói\ \-\ RJ",
"55633433", "Palmeiras\ do\ Tocantins\ \-\ TO",
"55124110", "Pindamonhangaba\ \-\ SP",
"55833431", "Pombal\ \-\ PB",
"55193626", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55623448", "Flores\ de\ Goiás\ \-\ GO",
"55493311", "Chapecó\ \-\ SC",
"55383505", "Unaí\ \-\ MG",
"55543347", "Casca\ \-\ RS",
"55613573", "Brasília\ \-\ DF",
"55673003", "Campo\ Grande\ \-\ MS",
"55643586", "Itumbiara\ \-\ GO",
"55193406", "Americana\ \-\ SP",
"55222644", "Cabo\ Frio\ \-\ RJ",
"55893457", "Jaicós\ \-\ PI",
"55823535", "Olho\ d\'Água\ Grande\ \-\ AL",
"55313444", "Belo\ Horizonte\ \-\ MG",
"55473343", "Ilhota\ \-\ SC",
"55163415", "São\ Carlos\ \-\ SP",
"55663582", "Gaúcha\ do\ Norte\ \-\ MT",
"55183913", "Montalvão\ \-\ SP",
"55153379", "São\ Miguel\ Arcanjo\ \-\ SP",
"55683311", "Cruzeiro\ do\ Sul\ \-\ AC",
"55453255", "São\ Pedro\ do\ Iguaçu\ \-\ PR",
"55323724", "Eugenópolis\ \-\ MG",
"55443584", "Icaraíma\ \-\ PR",
"55133871", "Eldorado\ \-\ SP",
"55883541", "Várzea\ Alegre\ \-\ CE",
"55343835", "Cruzeiro\ da\ Fortaleza\ \-\ MG",
"55613878", "Brasília\ \-\ DF",
"55413581", "Curitiba\ \-\ PR",
"55183624", "Araçatuba\ \-\ SP",
"55633025", "Palmas\ \-\ TO",
"55673442", "Ivinhema\ \-\ MS",
"55143845", "Conchas\ \-\ SP",
"55323202", "Cataguases\ \-\ MG",
"55383221", "Montes\ Claros\ \-\ MG",
"55993311", "Açailândia\ \-\ MA",
"5531346", "Minas\ Gerais",
"55543281", "Nova\ Petrópolis\ \-\ RS",
"55753644", "Queimadas\ \-\ BA",
"55693026", "Porto\ Velho\ \-\ RO",
"55863251", "São\ João\ da\ Serra\ \-\ PI",
"55193454", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55173462", "Fernandópolis\ \-\ SP",
"55193839", "Amparo\ \-\ SP",
"55313535", "Mateus\ Leme\ \-\ MG",
"55222759", "Macaé\ \-\ RJ",
"552125", "Rio\ de\ Janeiro\ \-\ RJ",
"55243387", "Visconde\ de\ Mauá\ \-\ RJ",
"55212637", "Maricá\ \-\ RJ",
"55513375", "Rio\ Grande\ do\ Sul",
"55543057", "Bento\ Gonçalves\ \-\ RS",
"55883627", "Martinópole\ \-\ CE",
"55543368", "Jacutinga\ \-\ RS",
"55193495", "Limeira\ \-\ SP",
"55623467", "Teresina\ de\ Goiás\ \-\ GO",
"55433174", "Cambé\ \-\ PR",
"55993543", "Tasso\ Fragoso\ \-\ MA",
"55113434", "São\ Paulo\ \-\ SP",
"55863087", "Teresina\ \-\ PI",
"55843672", "Natal\ \-\ RN",
"55313389", "Belo\ Horizonte\ \-\ MG",
"55112751", "São\ Paulo\ \-\ SP",
"55513210", "Rio\ Grande\ do\ Sul",
"55444101", "Sarandi\ \-\ PR",
"55513623", "Rio\ Grande\ do\ Sul",
"55223851", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55553256", "Manoel\ Viana\ \-\ RS",
"55793339", "Santana\ do\ São\ Francisco\ \-\ SE",
"55443264", "Sarandi\ \-\ PR",
"55983346", "Bacabeira\ \-\ MA",
"55733266", "Itarantim\ \-\ BA",
"55473642", "Mafra\ \-\ SC",
"55513042", "Gravataí\ \-\ RS",
"55193366", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55423906", "Castro\ \-\ PR",
"55173453", "Cardoso\ \-\ SP",
"55473318", "Gaspar\ \-\ SC",
"55183552", "Pracinha\ \-\ SP",
"5512390", "São\ José\ dos\ Campos\ \-\ SP",
"55983689", "Zé\ Doca\ \-\ MA",
"55122128", "Jacareí\ \-\ SP",
"55343236", "Uberlândia\ \-\ MG",
"55313123", "Belo\ Horizonte\ \-\ MG",
"55643698", "Nova\ Aurora\ \-\ GO",
"55153327", "Sorocaba\ \-\ SP",
"55693346", "Chupinguaia\ \-\ RO",
"55843373", "Rodolfo\ Fernandes\ \-\ RN",
"55113636", "São\ Paulo\ \-\ SP",
"55423233", "Castro\ \-\ PR",
"55923312", "Balbina\ \-\ AM",
"55333291", "Coroaci\ \-\ MG",
"55163242", "Monte\ Alto\ \-\ SP",
"5511415", "Santana\ de\ Parnaíba\ \-\ SP",
"55623956", "Goiânia\ \-\ GO",
"55863474", "Pimenteiras\ \-\ PI",
"55423250", "Abapã\ \-\ PR",
"55112655", "São\ Paulo\ \-\ SP",
"55623307", "Ceres\ \-\ GO",
"55493344", "São\ Lourenço\ do\ Oeste\ \-\ SC",
"55853324", "Caridade\ \-\ CE",
"5531330", "Minas\ Gerais",
"5571", "Bahia",
"55193656", "Mococa\ \-\ SP",
"55163010", "Araraquara\ \-\ SP",
"55714112", "Salvador\ \-\ BA",
"55423667", "Inácio\ Martins\ \-\ PR",
"5531378", "Minas\ Gerais",
"55513564", "Dois\ Irmãos\ \-\ RS",
"55793265", "Nossa\ Senhora\ das\ Dores\ \-\ SE",
"55753446", "Sátiro\ Dias\ \-\ BA",
"55183283", "Euclides\ da\ Cunha\ Paulista\ \-\ SP",
"55283539", "Itaoca\ \-\ ES",
"55713669", "Palmares\ \-\ BA",
"55173302", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55823646", "Canapi\ \-\ AL",
"55893427", "Tanque\ do\ Piauí\ \-\ PI",
"55183695", "Planalto\ \-\ SP",
"55673546", "Brasilândia\ \-\ MS",
"55533311", "Bagé\ \-\ RS",
"55643945", "Itumbiara\ \-\ GO",
"55843239", "Nísia\ Floresta\ \-\ RN",
"55143529", "Lins\ \-\ SP",
"55843694", "Monte\ das\ Gameleiras\ \-\ RN",
"55343414", "Contagem\ \-\ MG",
"55333526", "Ataléia\ \-\ MG",
"55813649", "Machados\ \-\ PE",
"55813691", "Panelas\ \-\ PE",
"55313411", "Minas\ Gerais",
"55152107", "Porto\ Feliz\ \-\ SP",
"55883514", "Cariús\ \-\ CE",
"55114602", "Salto\ \-\ SP",
"55914104", "Ananindeua\ \-\ PA",
"55473544", "Trombudo\ Central\ \-\ SC",
"55663486", "Pedra\ Preta\ \-\ MT",
"55773451", "Guanambi\ \-\ BA",
"55453219", "Cascavel\ \-\ PR",
"55323754", "São\ Francisco\ do\ Glória\ \-\ MG",
"55483346", "São\ José\ \-\ SC",
"55193502", "Rio\ Claro\ \-\ SP",
"55133592", "Praia\ Grande\ \-\ SP",
"55183654", "Penápolis\ \-\ SP",
"55114463", "Santo\ André\ \-\ SP",
"55313390", "Minas\ Gerais",
"55873870", "Trindade\ \-\ PE",
"55923667", "Manaus\ \-\ AM",
"55624109", "Goiânia\ \-\ GO",
"55323691", "Juiz\ de\ Fora\ \-\ MG",
"55383251", "Bocaiúva\ \-\ MG",
"55313162", "Betim\ \-\ MG",
"55453272", "Diamante\ D\'Oeste\ \-\ PR",
"55222103", "Nova\ Friburgo\ \-\ RJ",
"55413034", "Piraquara\ \-\ PR",
"55983004", "São\ Luís\ \-\ MA",
"55273079", "Serra\ \-\ ES",
"55173566", "Embaúba\ \-\ SP",
"55883657", "Quiterianópolis\ \-\ CE",
"55823297", "Japaratinga\ \-\ AL",
"55713270", "Salvador\ \-\ BA",
"55183606", "Guararapes\ \-\ SP",
"55273347", "Vitória\ \-\ ES",
"55813378", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55433267", "São\ Jerônimo\ da\ Serra\ \-\ PR",
"55112592", "São\ Paulo\ \-\ SP",
"55843365", "Messias\ Targino\ \-\ RN",
"55513403", "Guaíba\ \-\ RS",
"55423648", "Marquinho\ \-\ PR",
"55663478", "Canarana\ \-\ MT",
"55513662", "Santo\ Antônio\ da\ Patrulha\ \-\ RS",
"55383676", "Unaí\ \-\ MG",
"55793114", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55473062", "Balneário\ Camboriú\ \-\ SC",
"55793543", "Indiaroba\ \-\ SE",
"55813436", "Paulista\ \-\ PE",
"55353693", "Pouso\ Alegre\ \-\ MG",
"55613218", "Brasília\ \-\ DF",
"55143883", "Bofete\ \-\ SP",
"55133211", "Santos\ \-\ SP",
"55463520", "Francisco\ Beltrão\ \-\ PR",
"55893522", "Floriano\ \-\ PI",
"5571321", "Salvador\ \-\ BA",
"55443433", "Nova\ Aliança\ do\ Ivaí\ \-\ PR",
"55373331", "Oliveira\ \-\ MG",
"55193407", "Americana\ \-\ SP",
"55893456", "Simões\ \-\ PI",
"55823013", "Maceió\ \-\ AL",
"55513733", "Encruzilhada\ do\ Sul\ \-\ RS",
"55114061", "Diadema\ \-\ SP",
"55833455", "Santana\ de\ Mangueira\ \-\ PB",
"55893575", "Avelino\ Lopes\ \-\ PI",
"55173341", "Colina\ \-\ SP",
"55543056", "Farroupilha\ \-\ RS",
"55883626", "São\ Benedito\ \-\ CE",
"55473385", "Benedito\ Novo\ \-\ SC",
"55623466", "Vila\ Boa\ \-\ GO",
"55513750", "Vale\ do\ Sol\ \-\ RS",
"55713493", "Camaçari\ \-\ BA",
"55313328", "Minas\ Gerais",
"55283511", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55863086", "Teresina\ \-\ PI",
"55114680", "Santa\ Isabel\ \-\ SP",
"55312557", "Contagem\ \-\ MG",
"55213694", "Maricá\ \-\ RJ",
"55212712", "São\ Gonçalo\ \-\ RJ",
"5511562", "São\ Paulo\ \-\ SP",
"55173513", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55473274", "Jaraguá\ do\ Sul\ \-\ SC",
"55113583", "São\ Paulo\ \-\ SP",
"55833494", "Diamante\ \-\ PB",
"55313895", "Teixeiras\ \-\ MG",
"55483027", "Florianópolis\ \-\ SC",
"55193541", "Araras\ \-\ SP",
"55114234", "São\ Caetano\ do\ Sul\ \-\ SP",
"55453231", "Santa\ Tereza\ do\ Oeste\ \-\ PR",
"55272144", "Vila\ Velha\ \-\ ES",
"55943433", "Tucumã\ \-\ PA",
"55823551", "Penedo\ \-\ AL",
"55114641", "Itaquaquecetuba\ \-\ SP",
"55623553", "Hidrolândia\ \-\ GO",
"55114699", "Mogi\ das\ Cruzes\ \-\ SP",
"55493458", "Itá\ \-\ SC",
"55493199", "Chapecó\ \-\ SC",
"55643620", "Rio\ Verde\ \-\ GO",
"55173818", "Bady\ Bassitt\ \-\ SP",
"55863369", "Cajueiro\ da\ Praia\ \-\ PI",
"55873798", "Bom\ Conselho\ \-\ PE",
"55343851", "Carmo\ do\ Paranaíba\ \-\ MG",
"5511258", "São\ Paulo\ \-\ SP",
"55313439", "Minas\ Gerais",
"55313854", "Rio\ Piracicaba\ \-\ MG",
"55953542", "Mucajaí\ \-\ RR",
"55553227", "Itaara\ \-\ RS",
"55312108", "Belo\ Horizonte\ \-\ MG",
"55533265", "Chuí\ \-\ RS",
"55383615", "Manga\ \-\ MG",
"55313551", "Ouro\ Preto\ \-\ MG",
"55163393", "Américo\ Brasiliense\ \-\ SP",
"55123103", "Cachoeira\ Paulista\ \-\ SP",
"55543346", "Ciríaco\ \-\ RS",
"55153298", "Pilar\ do\ Sul\ \-\ SP",
"55623282", "Aparecida\ de\ Goiânia\ \-\ GO",
"55113449", "Osasco\ \-\ SP",
"55834064", "Campina\ Grande\ \-\ PB",
"55893563", "Cristino\ Castro\ \-\ PI",
"55553534", "Doutor\ Maurício\ Cardoso\ \-\ RS",
"55753639", "Santa\ Teresinha\ \-\ BA",
"55343323", "Veríssimo\ \-\ MG",
"55443019", "Cianorte\ \-\ PR",
"55163519", "Ribeirão\ Preto\ \-\ SP",
"55333512", "Frei\ Gaspar\ \-\ MG",
"55753294", "Água\ Fria\ \-\ BA",
"55973385", "Manicoré\ \-\ AM",
"55193844", "Paulínia\ \-\ SP",
"55173843", "Ouroeste\ \-\ SP",
"55223835", "Carabuçu\ \-\ RJ",
"55463533", "São\ João\ \-\ PR",
"55813707", "Frei\ Miguelinho\ \-\ PE",
"55833472", "Teixeira\ \-\ PB",
"55893552", "Guadalupe\ \-\ PI",
"55553279", "Quevedos\ \-\ RS",
"55463550", "Renascença\ \-\ PR",
"55513902", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55893426", "Geminiano\ \-\ PI",
"55733248", "Itapé\ \-\ BA",
"55983368", "Primeira\ Cruz\ \-\ MA",
"55413669", "Pinhais\ \-\ PR",
"55163133", "Cristais\ Paulista\ \-\ SP",
"55673547", "Debrasa\ \-\ MS",
"55333745", "Joaíma\ \-\ MG",
"55793344", "Neópolis\ \-\ SE",
"55333527", "Ouro\ Verde\ de\ Minas\ \-\ MG",
"5541", "Paraná",
"55883656", "Graça\ \-\ CE",
"55823296", "Maragogi\ \-\ AL",
"55713261", "Salvador\ \-\ BA",
"55643983", "Itumbiara\ \-\ GO",
"55173567", "Paraíso\ \-\ SP",
"55493339", "Águas\ de\ Chapecó\ \-\ SC",
"55833425", "Quixabá\ \-\ PB",
"55183607", "Araçatuba\ \-\ SP",
"55433266", "Nova\ Santa\ Bárbara\ \-\ PR",
"55113384", "São\ Paulo\ \-\ SP",
"55313358", "Contagem\ \-\ MG",
"55313067", "Itabira\ \-\ MG",
"55283544", "Muniz\ Freire\ \-\ ES",
"55623979", "Anápolis\ \-\ GO",
"55973451", "Boca\ do\ Acre\ \-\ AM",
"55383677", "Unaí\ \-\ MG",
"55513720", "Estrêla\ \-\ RS",
"55983658", "Alto\ Alegre\ do\ Pindaré\ \-\ MA",
"55323532", "Ubá\ \-\ MG",
"55143268", "Macatuba\ \-\ SP",
"55663500", "Primavera\ do\ Leste\ \-\ MT",
"55333234", "Engenheiro\ Caldas\ \-\ MG",
"55773642", "Oliveira\ dos\ Brejinhos\ \-\ BA",
"55753501", "Paulo\ Afonso\ \-\ BA",
"55833419", "Santa\ Teresinha\ \-\ PB",
"55634101", "Palmas\ \-\ TO",
"55174009", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55115102", "São\ Paulo\ \-\ SP",
"55423907", "Irati\ \-\ PR",
"55623523", "Goiânia\ \-\ GO",
"55383744", "Jequitaí\ \-\ MG",
"5591", "Pará",
"55823521", "Arapiraca\ \-\ AL",
"55733633", "Ilhéus\ \-\ BA",
"55753272", "Tucano\ \-\ BA",
"55833033", "Santa\ Rita\ \-\ PB",
"55843244", "Baía\ Formosa\ \-\ RN",
"55623354", "Niquelândia\ \-\ GO",
"55553257", "São\ Vicente\ do\ Sul\ \-\ RS",
"55843631", "Macaíba\ \-\ RN",
"55773435", "Anagé\ \-\ BA",
"55143472", "Ubirajara\ \-\ SP",
"55733267", "Itororó\ \-\ BA",
"55813634", "Surubim\ \-\ PE",
"55343663", "Perdizes\ \-\ MG",
"55643633", "Lagoa\ do\ Bauzinho\ \-\ GO",
"55343821", "Patos\ de\ Minas\ \-\ MG",
"55833268", "João\ Pessoa\ \-\ PB",
"55333416", "Virginópolis\ \-\ MG",
"55443055", "Umuarama\ \-\ PR",
"55313521", "Ibirité\ \-\ MG",
"55193657", "Tapiratiba\ \-\ SP",
"55483658", "Braço\ do\ Norte\ \-\ SC",
"55313048", "Belo\ Horizonte\ \-\ MG",
"55115095", "São\ Paulo\ \-\ SP",
"55553333", "Ijuí\ \-\ RS",
"55383235", "Capitão\ Enéas\ \-\ MG",
"55753447", "Ouriçangas\ \-\ BA",
"55144103", "Jaú\ \-\ SP",
"55823647", "Pariconha\ \-\ AL",
"55423304", "Guarapuava\ \-\ PR",
"55173548", "Marapoama\ \-\ SP",
"55353573", "Monte\ Belo\ \-\ MG",
"55633383", "Cariri\ do\ Tocantins\ \-\ TO",
"55113637", "São\ Paulo\ \-\ SP",
"55143425", "Marília\ \-\ SP",
"55983012", "São\ Luís\ \-\ MA",
"55833381", "Montadas\ \-\ PB",
"55242431", "Piraí\ \-\ RJ",
"55323241", "Juiz\ de\ Fora\ \-\ MG",
"55193811", "Mogi\-Guaçu\ \-\ SP",
"55883424", "Tabuleiro\ do\ Norte\ \-\ CE",
"55943345", "Jacundá\ \-\ PA",
"55163488", "São\ Simão\ \-\ SP",
"55164003", "Ribeirão\ Preto\ \-\ SP",
"55473148", "Navegantes\ \-\ SC",
"55343353", "Conquista\ \-\ MG",
"55433461", "Faxinal\ \-\ PR",
"55753649", "Elísio\ Medrado\ \-\ BA",
"55513289", "Rio\ Grande\ do\ Sul",
"55493015", "Lages\ \-\ SC",
"55553544", "Novo\ Machado\ \-\ RS",
"55873785", "Lagoa\ do\ Ouro\ \-\ PE",
"55853377", "Itaitinga\ \-\ CE",
"55193834", "Indaiatuba\ \-\ SP",
"55613101", "Brasília\ \-\ DF",
"55133579", "São\ Vicente\ \-\ SP",
"55983478", "Araioses\ \-\ MA",
"55863245", "Nossa\ Senhora\ dos\ Remédios\ \-\ PI",
"55313888", "Minas\ Gerais",
"55213303", "Duque\ de\ Caxias\ \-\ RJ",
"55114735", "Mogi\ das\ Cruzes\ \-\ SP",
"55833362", "Areia\ \-\ PB",
"55113439", "Santo\ André\ \-\ SP",
"55543336", "Ipiranga\ do\ Sul\ \-\ RS",
"55793194", "Aracaju\ \-\ SE",
"55732011", "Teixeira\ de\ Freitas\ \-\ BA",
"55553435", "Maçambara\ \-\ RS",
"55143554", "Cafelândia\ \-\ SP",
"5581332", "Recife\ \-\ PE",
"55633014", "Palmas\ \-\ TO",
"55953532", "Caracaraí\ \-\ RR",
"55613613", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55843614", "Natal\ \-\ RN",
"55913467", "Ourém\ \-\ PA",
"55353298", "Machado\ \-\ MG",
"55313449", "Belo\ Horizonte\ \-\ MG",
"55883555", "Jardim\ \-\ CE",
"55673683", "Rio\ Verde\ de\ Mato\ Grosso\ \-\ MS",
"55313491", "Minas\ Gerais",
"55483262", "Governador\ Celso\ Ramos\ \-\ SC",
"55333082", "Governador\ Valadares\ \-\ MG",
"55323729", "Muriaé\ \-\ MG",
"55453241", "Cafelândia\ \-\ PR",
"5551320", "Rio\ Grande\ do\ Sul",
"55343455", "Carneirinho\ \-\ MG",
"55684001", "Rio\ Branco\ \-\ AC",
"55433016", "Rolândia\ \-\ PR",
"55153285", "Tietê\ \-\ SP",
"55373287", "Perdigão\ \-\ MG",
"55423573", "Porto\ Vitória\ \-\ PR",
"55313876", "Urucânia\ \-\ MG",
"55423915", "Carambeí\ \-\ PR",
"55112923", "Jundiaí\ \-\ SP",
"55163604", "Ribeirão\ Preto\ \-\ SP",
"55313726", "Santana\ dos\ Montes\ \-\ MG",
"55553318", "Jóia\ \-\ RS",
"55673254", "Sonora\ \-\ MS",
"55733017", "Ilhéus\ \-\ BA",
"55212709", "Niterói\ \-\ RJ",
"55873882", "Serrita\ \-\ PE",
"55623581", "Goiânia\ \-\ GO",
"55173331", "Guaíra\ \-\ SP",
"55212646", "São\ Gonçalo\ \-\ RJ",
"55673295", "São\ Gabriel\ do\ Oeste\ \-\ MS",
"55453280", "São\ Luiz\ D\'Oeste\ \-\ PR",
"55993015", "Imperatriz\ \-\ MA",
"55513743", "Candelária\ \-\ RS",
"55193477", "Americana\ \-\ SP",
"55483478", "Criciúma\ \-\ SC",
"55323446", "Palma\ \-\ MG",
"55143652", "Dois\ Córregos\ \-\ SP",
"55813879", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55913448", "Maracanã\ \-\ PA",
"55983262", "São\ Luís\ \-\ MA",
"55443443", "Santo\ Antônio\ do\ Caiuá\ \-\ PR",
"55373341", "Itapecerica\ \-\ MG",
"55633321", "Araguaína\ \-\ TO",
"55473204", "São\ Francisco\ do\ Sul\ \-\ SC",
"5512388", "Caraguatatuba\ \-\ SP",
"5574361", "Juazeiro\ \-\ BA",
"55833554", "Nazarezinho\ \-\ PB",
"55893474", "Pimenteiras\ \-\ PI",
"55813446", "Recife\ \-\ PE",
"55883692", "Crateús\ \-\ CE",
"55823252", "Joaquim\ Gomes\ \-\ AL",
"55373513", "Pompéu\ \-\ MG",
"5585", "Ceará",
"55133842", "Ilha\ Comprida\ \-\ SP",
"55513718", "Vera\ Cruz\ \-\ RS",
"55553511", "Santa\ Rosa\ \-\ RS",
"55273767", "São\ Mateus\ \-\ ES",
"55753202", "Retirolândia\ \-\ BA",
"55443901", "Maringá\ \-\ PR",
"55624104", "Goiânia\ \-\ GO",
"55213504", "Rio\ de\ Janeiro\ \-\ RJ",
"55183744", "Nova\ Independência\ \-\ SP",
"55823263", "Marechal\ Deodoro\ \-\ AL",
"55353326", "Minduri\ \-\ MG",
"55612099", "Brasília\ \-\ DF",
"55673471", "Iguatemi\ \-\ MS",
"55943335", "Itinga\ do\ Maranhão\ \-\ PA",
"55553797", "Novo\ Tiradentes\ \-\ RS",
"55613357", "Samambaia\ Sul\ \-\ DF",
"55613906", "Luziânia\ \-\ GO",
"55693582", "Cujubim\ \-\ RO",
"55143402", "Marília\ \-\ SP",
"55163406", "Franca\ \-\ SP",
"55813759", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55553343", "Cruz\ Alta\ \-\ RS",
"55753437", "Nova\ Soure\ \-\ BA",
"55153392", "Itapetininga\ \-\ SP",
"55843234", "Natal\ \-\ RN",
"55133416", "Ana\ Dias\ \-\ SP",
"55313263", "Belo\ Horizonte\ \-\ MG",
"55613233", "Guará\ \-\ DF",
"55114497", "Jundiaí\ \-\ SP",
"55813231", "Recife\ \-\ PE",
"55643643", "Porteirão\ \-\ GO",
"55813644", "Cumaru\ \-\ PE",
"55883525", "Antonina\ do\ Norte\ \-\ CE",
"55983337", "Alcântara\ \-\ MA",
"55513137", "Alvorada\ \-\ RS",
"55183993", "Cuiabá\ Paulista\ \-\ SP",
"55773445", "Condeúba\ \-\ BA",
"55843641", "Natal\ \-\ RN",
"55743528", "Umburanas\ \-\ BA",
"55343425", "Frutal\ \-\ MG",
"55313637", "Santa\ Luzia\ \-\ MG",
"55624052", "Goiânia\ \-\ GO",
"55833622", "Capim\ \-\ PB",
"55663026", "Rondonópolis\ \-\ MT",
"55153573", "Barão\ de\ Antonina\ \-\ SP",
"55123634", "Taubaté\ \-\ SP",
"55693253", "Vila\ Nova\ Califórnia\ \-\ RO",
"55623376", "Aruanã\ \-\ GO",
"55973483", "Envira\ \-\ AM",
"55883519", "Granjeiro\ \-\ CE",
"55163839", "Ituverava\ \-\ SP",
"55183659", "Bilac\ \-\ SP",
"5598308", "São\ Luís\ \-\ MA",
"55534001", "Pelotas\ \-\ RS",
"55693230", "Candeias\ do\ Jamari\ \-\ RO",
"5521315", "Rio\ de\ Janeiro\ \-\ RJ",
"5511458", "Jundiaí\ \-\ SP",
"55114082", "São\ Paulo\ \-\ SP",
"55313756", "Minas\ Gerais",
"55893492", "Campo\ Alegre\ do\ Fidalgo\ \-\ PI",
"55333244", "Galiléia\ \-\ MG",
"55514007", "Porto\ Alegre\ \-\ RS",
"55883674", "Acaraú\ \-\ CE",
"55843061", "Mossoró\ \-\ RN",
"55352106", "Varginha\ \-\ MG",
"55853315", "São\ Gonçalo\ do\ Amarante\ \-\ CE",
"55213602", "Niterói\ \-\ RJ",
"55483253", "Paulo\ Lopes\ \-\ SC",
"55873032", "Petrolina\ \-\ PE",
"5517322", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55493349", "Irati\ \-\ SC",
"55112641", "São\ Paulo\ \-\ SP",
"55433301", "Londrina\ \-\ PR",
"55853329", "Aratuba\ \-\ CE",
"55624017", "Aparecida\ de\ Goiânia\ \-\ GO",
"55212153", "Rio\ de\ Janeiro\ \-\ RJ",
"55513569", "Morro\ Reuter\ \-\ RS",
"55924002", "Manaus\ \-\ AM",
"55743661", "Xique\-Xique\ \-\ BA",
"55823275", "Campo\ Alegre\ \-\ AL",
"55283534", "Anchieta\ \-\ ES",
"55423132", "Irati\ \-\ PR",
"55193746", "Campinas\ \-\ SP",
"55163143", "Restinga\ \-\ SP",
"55333735", "Coronel\ Murta\ \-\ MG",
"55313384", "Belo\ Horizonte\ \-\ MG",
"55153565", "Itaporanga\ \-\ SP",
"55733238", "Itajuípe\ \-\ BA",
"55833353", "Sumé\ \-\ PB",
"55493678", "Itapiranga\ \-\ SC",
"55463311", "Pato\ Branco\ \-\ PR",
"55813542", "Abreu\ e\ Lima\ \-\ PE",
"55533029", "Pelotas\ \-\ RS",
"55633351", "Gurupi\ \-\ TO",
"55114178", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55533015", "Pelotas\ \-\ RS",
"55463543", "Realeza\ \-\ PR",
"55353464", "Inconfidentes\ \-\ MG",
"55173833", "Estrela\ D\'Oeste\ \-\ SP",
"55343268", "Ituiutaba\ \-\ MG",
"55114509", "Santo\ André\ \-\ SP",
"55512131", "Porto\ Alegre\ \-\ RS",
"55423036", "Guarapuava\ \-\ PR",
"55713272", "Salvador\ \-\ BA",
"5521323", "Rio\ de\ Janeiro\ \-\ RJ",
"55733616", "Itabuna\ \-\ BA",
"55243354", "Resende\ \-\ RJ",
"5595", "Roraima",
"55432103", "Londrina\ \-\ PR",
"55913446", "São\ Miguel\ do\ Guamá\ \-\ PA",
"55213765", "Mesquita\ \-\ RJ",
"55513660", "Rio\ Grande\ do\ Sul",
"55873763", "Garanhuns\ \-\ PE",
"55313392", "Contagem\ \-\ MG",
"55873872", "Araripina\ \-\ PE",
"55353824", "Ingaí\ \-\ MG",
"55473396", "Brusque\ \-\ SC",
"55115615", "São\ Paulo\ \-\ SP",
"55453270", "Iguiporã\ \-\ PR",
"55484003", "Florianópolis\ \-\ SC",
"55813448", "Recife\ \-\ PE",
"55193487", "Santa\ Maria\ da\ Serra\ \-\ SP",
"55793711", "Aracaju\ \-\ SE",
"55443557", "Terra\ Nova\ do\ Piquirí\ \-\ PR",
"55774141", "Vitória\ da\ Conquista\ \-\ BA",
"55633602", "Paraíso\ do\ Tocantins\ \-\ TO",
"55213823", "Rio\ de\ Janeiro\ \-\ RJ",
"55373259", "Pitangui\ \-\ MG",
"55643480", "Edealina\ \-\ GO",
"55833461", "Santa\ Luzia\ \-\ PB",
"55913812", "Magalhães\ Barata\ \-\ PA",
"55353521", "Passos\ \-\ MG",
"55313728", "Buarque\ de\ Macedo\ \-\ MG",
"55453377", "Foz\ do\ Iguaçu\ \-\ PR",
"55153263", "Boituva\ \-\ SP",
"55713225", "Feira\ de\ Santana\ \-\ BA",
"55633463", "Aragominas\ \-\ TO",
"55333433", "São\ José\ do\ Jacuri\ \-\ MG",
"55473258", "Vitor\ Meireles\ \-\ SC",
"55793615", "Simão\ Dias\ \-\ SE",
"55114094", "Diadema\ \-\ SP",
"55893484", "Campinas\ do\ Piauí\ \-\ PI",
"55483476", "Nova\ Veneza\ \-\ SC",
"55212648", "Maricá\ \-\ RJ",
"55673665", "Água\ Clara\ \-\ MS",
"55463245", "Honório\ Serpa\ \-\ PR",
"55313573", "Rio\ Manso\ \-\ MG",
"55273242", "Vila\ Velha\ \-\ ES",
"55513279", "Rio\ Grande\ do\ Sul",
"55313915", "Belo\ Horizonte\ \-\ MG",
"55853387", "Caucaia\ \-\ CE",
"55873775", "Águas\ Belas\ \-\ PE",
"55163944", "Dumont\ \-\ SP",
"55353296", "Fama\ \-\ MG",
"55993221", "Imperatriz\ \-\ MA",
"55643441", "Catalão\ \-\ GO",
"55383311", "Paracatu\ \-\ MG",
"55213528", "Rio\ de\ Janeiro\ \-\ RJ",
"55213099", "Teresópolis\ \-\ RJ",
"55983488", "Santana\ do\ Maranhão\ \-\ MA",
"55273198", "Vitória\ \-\ ES",
"5545", "Paraná",
"55313878", "Contagem\ \-\ MG",
"55383543", "Gouveia\ \-\ MG",
"55633422", "Bernardo\ Sayão\ \-\ TO",
"55143112", "Botucatu\ \-\ SP",
"55534062", "Pelotas\ \-\ RS",
"55433554", "Congonhinhas\ \-\ PR",
"55333025", "Governador\ Valadares\ \-\ MG",
"55163116", "São\ Carlos\ \-\ SP",
"55193713", "Limeira\ \-\ SP",
"55423252", "Palmeira\ \-\ PR",
"55213773", "Nova\ Iguaçu\ \-\ RJ",
"55694003", "Porto\ Velho\ \-\ RO",
"55983476", "Santa\ Quitéria\ do\ Maranhão\ \-\ MA",
"55913729", "Paragominas\ \-\ PA",
"55353067", "Varginha\ \-\ MG",
"55153384", "Cerquilho\ \-\ SP",
"55533251", "São\ Lourenço\ do\ Sul\ \-\ RS",
"55193869", "Valinhos\ \-\ SP",
"55613535", "Brasília\ \-\ DF",
"5516396", "Ribeirão\ Preto\ \-\ SP",
"55673673", "Jateí\ \-\ MS",
"55163347", "Cambaratiba\ \-\ SP",
"55472125", "Balneário\ Camboriú\ \-\ SC",
"55753261", "Serrinha\ \-\ BA",
"55543338", "Victor\ Graeff\ \-\ RS",
"55713501", "Salvador\ \-\ BA",
"55212667", "Nova\ Iguaçu\ \-\ RJ",
"55923491", "Carauari\ \-\ AM",
"55633475", "Esperantina\ \-\ TO",
"55153275", "Itapetininga\ \-\ SP",
"55313886", "Diogo\ de\ Vasconcelos\ \-\ MG",
"55373277", "Leandro\ Ferreira\ \-\ MG",
"55543459", "Bento\ Gonçalves\ \-\ RS",
"55883684", "Ipaporanga\ \-\ CE",
"55483525", "Turvo\ \-\ SC",
"55243324", "Barra\ Mansa\ \-\ RJ",
"55613389", "Planaltina\ \-\ DF",
"55113907", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55443641", "Terra\ Boa\ \-\ PR",
"55513982", "Lajeado\ \-\ RS",
"55443234", "Astorga\ \-\ PR",
"55123974", "Paraibuna\ \-\ SP",
"55933524", "Santarém\ \-\ PA",
"55112335", "São\ Paulo\ \-\ SP",
"55314002", "Belo\ Horizonte\ \-\ MG",
"55733236", "Una\ \-\ BA",
"55663407", "Barra\ do\ Garças\ \-\ MT",
"55193336", "Rio\ Claro\ \-\ SP",
"55333345", "Chalé\ \-\ MG",
"55353854", "Ilicínea\ \-\ MG",
"55133269", "Santos\ \-\ SP",
"55343266", "Canápolis\ \-\ MG",
"55493251", "Lages\ \-\ SC",
"55433622", "Jaboti\ \-\ PR",
"55513445", "Presidente\ Lucena\ \-\ RS",
"55674004", "Campo\ Grande\ \-\ MS",
"55114176", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55823285", "São\ José\ da\ Laje\ \-\ AL",
"55273746", "Alto\ Rio\ Novo\ \-\ ES",
"55153491", "Salto\ de\ Pirapora\ \-\ SP",
"55824002", "Maceió\ \-\ AL",
"55473473", "Joinville\ \-\ SC",
"55443527", "Nova\ Cantu\ \-\ PR",
"55313374", "Minas\ Gerais",
"55833293", "Lucena\ \-\ PB",
"55213830", "Rio\ de\ Janeiro\ \-\ RJ",
"55313758", "Minas\ Gerais",
"55353551", "Guaxupé\ \-\ MG",
"55673440", "Amandina\ \-\ MS",
"55114025", "Itu\ \-\ SP",
"55113304", "São\ Paulo\ \-\ SP",
"55373229", "Divinópolis\ \-\ MG",
"55373215", "Divinópolis\ \-\ MG",
"55473228", "Balneário\ Camboriú\ \-\ SC",
"55913777", "Ponta\ de\ Pedras\ \-\ PA",
"55114019", "Itu\ \-\ SP",
"55423637", "Nova\ Laranjeiras\ \-\ PR",
"55433675", "Centenário\ do\ Sul\ \-\ PR",
"55543531", "Paim\ Filho\ \-\ RS",
"55873855", "Buíque\ \-\ PE",
"55993492", "Lagoa\ do\ Mato\ \-\ MA",
"55283569", "Ibitirama\ \-\ ES",
"55373546", "Biquinhas\ \-\ MG",
"55843269", "Riachuelo\ \-\ RN",
"55414020", "Curitiba\ \-\ PR",
"55883582", "Iguatu\ \-\ CE",
"55613411", "Brasília\ \-\ DF",
"55273084", "Vitória\ \-\ ES",
"55242104", "Petrópolis\ \-\ RJ",
"55813413", "Recife\ \-\ PE",
"55673481", "Amambaí\ \-\ MS",
"55814109", "Paulista\ \-\ PE",
"55133418", "Itariri\ \-\ SP",
"55672105", "Três\ Lagoas\ \-\ MS",
"55213485", "Rio\ de\ Janeiro\ \-\ RJ",
"55153252", "Torre\ de\ Pedra\ \-\ SP",
"55633452", "Nova\ Olinda\ \-\ TO",
"55983393", "Luís\ Domingues\ \-\ MA",
"55823036", "Maceió\ \-\ AL",
"55123669", "Campos\ do\ Jordão\ \-\ SP",
"55543477", "Paraí\ \-\ RS",
"55983525", "Imperatriz\ \-\ MA",
"55623378", "Itauçu\ \-\ GO",
"55833685", "Sertãozinho\ \-\ PB",
"55684062", "Rio\ Branco\ \-\ AC",
"55663541", "Colíder\ \-\ MT",
"55613297", "Brasília\ \-\ DF",
"55663599", "Guariba\ \-\ MT",
"55433524", "Cornélio\ Procópio\ \-\ PR",
"55313132", "Esmeraldas\ \-\ MG",
"55383813", "Mato\ Verde\ \-\ MG",
"55513716", "Arroio\ do\ Meio\ \-\ RS",
"55143293", "Guaianás\ \-\ SP",
"55543242", "Nova\ Prata\ \-\ RS",
"55843335", "Ipanguaçu\ \-\ RN",
"55222540", "Nova\ Friburgo\ \-\ RJ",
"55423275", "Tibagi\ \-\ PR",
"55623386", "Faina\ \-\ GO",
"55973473", "São\ Gabriel\ da\ Cachoeira\ \-\ AM",
"55473465", "Joinville\ \-\ SC",
"55513632", "Montenegro\ \-\ RS",
"55183334", "Presidente\ Prudente\ \-\ SP",
"55693525", "Vale\ do\ Anari\ \-\ RO",
"55353013", "Lavras\ \-\ MG",
"55983454", "Anajatuba\ \-\ MA",
"55143586", "Guarantã\ \-\ SP",
"55543348", "Água\ Santa\ \-\ RS",
"55313710", "Minas\ Gerais",
"55643559", "Itumbiara\ \-\ GO",
"55183311", "Presidente\ Prudente\ \-\ SP",
"55472102", "Blumenau\ \-\ SC",
"55663415", "Ribeirãozinho\ \-\ MT",
"55483626", "Tubarão\ \-\ SC",
"55312106", "Sete\ Lagoas\ \-\ MG",
"55554007", "Santa\ Maria\ \-\ RS",
"55543612", "Muitos\ Capões\ \-\ RS",
"55993563", "Aldeias\ Altas\ \-\ MA",
"55753664", "Taperoá\ \-\ BA",
"55353222", "Varginha\ \-\ MG",
"55173442", "Fernandópolis\ \-\ SP",
"5511257", "São\ Paulo\ \-\ SP",
"55222778", "Casimiro\ de\ Abreu\ \-\ RJ",
"55513053", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55273313", "São\ Mateus\ \-\ ES",
"55473653", "Papanduva\ \-\ SC",
"55493522", "Joaçaba\ \-\ SC",
"55383533", "Couto\ de\ Magalhães\ de\ Minas\ \-\ MG",
"55883561", "Icó\ \-\ CE",
"55163253", "Taquaritinga\ \-\ SP",
"55113565", "São\ Caetano\ do\ Sul\ \-\ SP",
"55193026", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55153205", "Tatuí\ \-\ SP",
"55222664", "Araruama\ \-\ RJ",
"55163934", "Ribeirão\ Preto\ \-\ SP",
"55533517", "Pelotas\ \-\ RS",
"55653312", "Santo\ Afonso\ \-\ MT",
"55173816", "Orindiúva\ \-\ SP",
"55873796", "Capoeiras\ \-\ PE",
"55843433", "Acari\ \-\ RN",
"55613434", "Recanto\ das\ Emas\ \-\ DF",
"55313464", "Belo\ Horizonte\ \-\ MG",
"55173277", "Nipoã\ \-\ SP",
"55493456", "Campina\ da\ Alegria\ \-\ SC",
"55473363", "Balneário\ Camboriú\ \-\ SC",
"55643431", "Itumbiara\ \-\ GO",
"55313326", "Belo\ Horizonte\ \-\ MG",
"55453039", "Cascavel\ \-\ PR",
"55793457", "Macambira\ \-\ SE",
"55143762", "Taquarituba\ \-\ SP",
"55212789", "Mangaratiba\ \-\ RJ",
"55673278", "Rio\ Negro\ \-\ MS",
"55273232", "Vitória\ \-\ ES",
"55883628", "Santa\ Quitéria\ \-\ CE",
"55543367", "Três\ Palmeiras\ \-\ RS",
"55743619", "Jaguarari\ \-\ BA",
"55212638", "Maricá\ \-\ RJ",
"55243388", "Resende\ \-\ RJ",
"55913809", "Inhangapi\ \-\ PA",
"55113392", "São\ Paulo\ \-\ SP",
"55493563", "Caçador\ \-\ SC",
"55993575", "Graça\ Aranha\ \-\ MA",
"55423551", "Santana\ \-\ PR",
"55493624", "Romelândia\ \-\ SC",
"55893585", "Coronel\ José\ Dias\ \-\ PI",
"55673286", "Camapuã\ \-\ MS",
"55153521", "Itapeva\ \-\ SP",
"55223022", "Itaperuna\ \-\ RJ",
"55473375", "Corupá\ \-\ SC",
"55613877", "Brasília\ \-\ DF",
"55653233", "Salto\ do\ Céu\ \-\ MT",
"55353263", "Monsenhor\ Paulo\ \-\ MG",
"55123151", "Canas\ \-\ SP",
"55543260", "Caravaggio\ \-\ RS",
"55993522", "Tuntum\ \-\ MA",
"55373073", "Itaúna\ \-\ MG",
"55433020", "Rolândia\ \-\ PR",
"55533283", "Pelotas\ \-\ RS",
"55923328", "Rio\ Preto\ da\ Eva\ \-\ AM",
"55173635", "Aparecida\ D\'Oeste\ \-\ SP",
"55743672", "Morro\ do\ Chapéu\ \-\ BA",
"55192111", "Rio\ Claro\ \-\ SP",
"55213584", "Nova\ Iguaçu\ \-\ RJ",
"55173546", "Itajobi\ \-\ SP",
"55543232", "Vacaria\ \-\ RS",
"55222553", "Cantagalo\ \-\ RJ",
"55483656", "Sangão\ \-\ SC",
"55833266", "Mogeiro\ \-\ PB",
"55753282", "Paulo\ Afonso\ \-\ BA",
"55183344", "Presidente\ Prudente\ \-\ SP",
"55483271", "Florianópolis\ \-\ SC",
"55973352", "Anori\ \-\ AM",
"55623639", "Goiânia\ \-\ GO",
"55553743", "Jaboticaba\ \-\ RS",
"55473623", "Três\ Barras\ \-\ SC",
"5532", "Minas\ Gerais",
"55643515", "Itumbiara\ \-\ GO",
"55643697", "Davinópolis\ \-\ GO",
"55433472", "Ivaiporã\ \-\ PR",
"55123413", "Taubaté\ \-\ SP",
"55473317", "Indaial\ \-\ SC",
"55124109", "São\ José\ dos\ Campos\ \-\ SP",
"55493552", "Lacerdópolis\ \-\ SC",
"55122127", "Jacareí\ \-\ SP",
"55473564", "Rio\ do\ Campo\ \-\ SC",
"55193056", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55693424", "Ji\-Paraná\ \-\ RO",
"55663531", "Sinop\ \-\ MT",
"55553290", "Santa\ Maria\ \-\ RS",
"55114443", "Franco\ da\ Rocha\ \-\ SP",
"55633373", "Almas\ \-\ TO",
"55923521", "Itacoatiara\ \-\ AM",
"55733697", "Travessão\ \-\ BA",
"55483090", "São\ José\ \-\ SC",
"5519342", "Piracicaba\ \-\ SP",
"55814112", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55833371", "Picuí\ \-\ PB",
"5581", "Pernambuco",
"55542621", "Bento\ Gonçalves\ \-\ RS",
"55273260", "Vila\ Velha\ \-\ ES",
"55473352", "Presidente\ Getúlio\ \-\ SC",
"55493364", "Serra\ Alta\ \-\ SC",
"55313356", "Contagem\ \-\ MG",
"55983271", "São\ Luís\ \-\ MA",
"55863194", "Teresina\ \-\ PI",
"55813377", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"5511450", "São\ Paulo\ \-\ SP",
"55833482", "Imaculada\ \-\ PB",
"55433268", "Ibiporã\ \-\ PR",
"55513544", "Taquara\ \-\ RS",
"55883658", "Poranga\ \-\ CE",
"55823298", "Porto\ de\ Pedras\ \-\ AL",
"55553289", "Vale\ Vêneto\ \-\ RS",
"55713649", "Camaçari\ \-\ BA",
"55543541", "Trindade\ do\ Sul\ \-\ RS",
"55673453", "Caarapó\ \-\ MS",
"55483089", "São\ José\ \-\ SC",
"55743655", "Central\ \-\ BA",
"55163262", "Itápolis\ \-\ SP",
"5544326", "Maringá\ \-\ PR",
"55273736", "Laranja\ da\ Terra\ \-\ ES",
"552133", "Rio\ de\ Janeiro\ \-\ RJ",
"55653327", "Progresso\ \-\ MT",
"55983656", "Governador\ Newton\ Bello\ \-\ MA",
"55813974", "Recife\ \-\ PE",
"55353449", "Pouso\ Alegre\ \-\ MG",
"55493654", "São\ Bernardino\ \-\ SC",
"55113374", "Mogi\ das\ Cruzes\ \-\ SP",
"55653613", "Cuiabá\ \-\ MT",
"55613636", "Cabeceiras\ \-\ GO",
"55423521", "União\ da\ Vitória\ \-\ PR",
"55633365", "Fátima\ \-\ TO",
"55333335", "São\ José\ do\ Mantimento\ \-\ MG",
"55343301", "Uberlândia\ \-\ MG",
"5511269", "São\ Paulo\ \-\ SP",
"55513435", "Rio\ Grande\ do\ Sul",
"55152108", "Tietê\ \-\ SP",
"55153551", "Ribeirão\ Branco\ \-\ SP",
"55443631", "Cianorte\ \-\ PR",
"55993552", "Colinas\ \-\ MA",
"55413634", "São\ José\ dos\ Pinhais\ \-\ PR",
"55713378", "Lauro\ de\ Freitas\ \-\ BA",
"55433033", "Apucarana\ \-\ PR",
"5561337", "Ceilândia\ \-\ DF",
"55893428", "Santa\ Rosa\ do\ Piauí\ \-\ PI",
"55733246", "Itapitanga\ \-\ BA",
"55443244", "Paiçandu\ \-\ PR",
"55753011", "Feira\ de\ Santana\ \-\ BA",
"55643576", "Itumbiara\ \-\ GO",
"55753413", "Esplanada\ \-\ BA",
"55893543", "Antônio\ Almeida\ \-\ PI",
"55623611", "Aparecida\ de\ Goiânia\ \-\ GO",
"55633509", "Dianópolis\ \-\ TO",
"55113171", "São\ Paulo\ \-\ SP",
"55913724", "Benevides\ \-\ PA",
"55693541", "Guajará\-Mirim\ \-\ RO",
"5562332", "Anápolis\ \-\ GO",
"55793522", "Estância\ \-\ SE",
"55212693", "Nilópolis\ \-\ RJ",
"55663572", "Nova\ Bandeirantes\ \-\ MT",
"55653356", "Rosário\ Oeste\ \-\ MT",
"55313327", "Belo\ Horizonte\ \-\ MG",
"55533245", "Candiota\ \-\ RS",
"55963251", "Macapá\ \-\ AP",
"55473001", "Joinville\ \-\ SC",
"55513601", "Osório\ \-\ RS",
"55153646", "Buri\ \-\ SP",
"55543366", "Campinas\ do\ Sul\ \-\ RS",
"55193911", "Mogi\-Guaçu\ \-\ SP",
"55543271", "São\ Jorge\ \-\ RS",
"55663525", "Carlinda\ \-\ MT",
"55212132", "Rio\ de\ Janeiro\ \-\ RJ",
"55772102", "Vitória\ da\ Conquista\ \-\ BA",
"55163949", "Cruz\ das\ Posses\ \-\ SP",
"55333014", "Governador\ Valadares\ \-\ MG",
"55332101", "Governador\ Valadares\ \-\ MG",
"55513274", "Rio\ Grande\ do\ Sul",
"5532321", "Juiz\ de\ Fora\ \-\ MG",
"55313220", "Minas\ Gerais",
"55553032", "Santa\ Maria\ \-\ RS",
"55613491", "Brasília\ \-\ DF",
"55643588", "Itumbiara\ \-\ GO",
"55193408", "Americana\ \-\ SP",
"55214503", "Rio\ de\ Janeiro\ \-\ RJ",
"55243377", "Angra\ dos\ Reis\ \-\ RJ",
"55193561", "Pirassununga\ \-\ SP",
"55643455", "Caldas\ Novas\ \-\ GO",
"55983313", "São\ Luís\ \-\ MA",
"55483232", "Florianópolis\ \-\ SC",
"55954400", "Caracaraí\ \-\ RR",
"55453306", "Cascavel\ \-\ PR",
"55283322", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55673287", "Porto\ Murtinho\ \-\ MS",
"55353712", "Poços\ de\ Caldas\ \-\ MG",
"55513705", "Marques\ de\ Souza\ \-\ RS",
"55613217", "Brasília\ \-\ DF",
"55433559", "Joaquim\ Távora\ \-\ PR",
"55114661", "Embu\-Guaçu\ \-\ SP",
"55653046", "Cuiabá\ \-\ MT",
"55314115", "Lagoa\ Santa\ \-\ MG",
"55143332", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55112682", "São\ Paulo\ \-\ SP",
"55114773", "Itapevi\ \-\ SP",
"55833213", "João\ Pessoa\ \-\ PB",
"55623928", "Goiânia\ \-\ GO",
"5524", "Rio\ de\ Janeiro",
"55893489", "Conceição\ do\ Canindé\ \-\ PI",
"55114528", "Cabreúva\ \-\ SP",
"55114099", "Diadema\ \-\ SP",
"55443672", "Rondon\ \-\ PR",
"55153297", "Araçoiaba\ da\ Serra\ \-\ SP",
"55143587", "Presidente\ Alves\ \-\ SP",
"55633497", "Tupirama\ \-\ TO",
"55173361", "Monte\ Azul\ Paulista\ \-\ SP",
"55123011", "Taubaté\ \-\ SP",
"55623446", "Alto\ Paraíso\ de\ Goiás\ \-\ GO",
"55242266", "Werneck\ \-\ RJ",
"55112840", "Salto\ \-\ SP",
"55312107", "Sete\ Lagoas\ \-\ MG",
"55193628", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55813145", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55553228", "Boca\ do\ Monte\ \-\ RS",
"55183866", "Flora\ Rica\ \-\ SP",
"55443619", "Cianorte\ \-\ PR",
"55513421", "Gravataí\ \-\ RS",
"55933559", "Trairão\ \-\ PA",
"55173817", "Severínia\ \-\ SP",
"55493457", "Presidente\ Castelo\ Branco\ \-\ SC",
"55333321", "Caratinga\ \-\ MG",
"55173276", "Engenheiro\ Balduíno\ \-\ SP",
"55353829", "Lavras\ \-\ MG",
"55282102", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55173651", "Palmeira\ D\'Oeste\ \-\ SP",
"55443625", "Perobal\ \-\ PR",
"55483028", "Florianópolis\ \-\ SC",
"55813581", "Chã\ de\ Alegria\ \-\ PE",
"55913754", "Barcarena\ \-\ PA",
"5531382", "Ipatinga\ \-\ MG",
"55653326", "Tangará\ da\ Serra\ \-\ MT",
"55943365", "Vila\ Taboca\ \-\ PA",
"55323261", "São\ João\ Nepomuceno\ \-\ MG",
"55143267", "Borebi\ \-\ SP",
"55473902", "Jaraguá\ do\ Sul\ \-\ SC",
"55123354", "Jacareí\ \-\ SP",
"55383678", "Riachinho\ \-\ MG",
"55833248", "Cabedelo\ \-\ PB",
"5511461", "Cotia\ \-\ SP",
"55423646", "Pitanga\ \-\ PR",
"55112703", "São\ Paulo\ \-\ SP",
"55313357", "Contagem\ \-\ MG",
"55663476", "Araguainha\ \-\ MT",
"55453324", "Cascavel\ \-\ PR",
"55183608", "Araçatuba\ \-\ SP",
"55813376", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55643472", "Santa\ Cruz\ de\ Goiás\ \-\ GO",
"5512364", "Pindamonhangaba\ \-\ SP",
"55913795", "Baião\ \-\ PA",
"55873880", "Granito\ \-\ PE",
"55173875", "São\ João\ de\ Iracema\ \-\ SP",
"55453282", "Pato\ Bragado\ \-\ PR",
"55313233", "Minas\ Gerais",
"55333528", "Teófilo\ Otoni\ \-\ MG",
"55613263", "Brasília\ \-\ DF",
"55663555", "Cotriguaçu\ \-\ MT",
"55843264", "Taipu\ \-\ RN",
"55853468", "Fortaleza\ \-\ CE",
"55673021", "Dourados\ \-\ MS",
"55643419", "Cromínia\ \-\ GO",
"55733247", "Almadina\ \-\ BA",
"55183265", "Rancharia\ \-\ SP",
"5511505", "São\ Paulo\ \-\ SP",
"55242109", "Resende\ \-\ RJ",
"55983367", "Humberto\ de\ Campos\ \-\ MA",
"55553931", "Santo\ Ângelo\ \-\ RS",
"55123664", "Campos\ do\ Jordão\ \-\ SP",
"55113988", "Guarulhos\ \-\ SP",
"55773623", "São\ Desidério\ \-\ BA",
"55323376", "São\ Tiago\ \-\ MG",
"55613637", "Planaltina\ \-\ GO",
"55313667", "Coronel\ Fabriciano\ \-\ MG",
"55133383", "Guarujá\ \-\ SP",
"55114853", "Suzano\ \-\ SP",
"55663488", "Santo\ Antonuio\ do\ Leste\ \-\ MT",
"55813708", "Bezerros\ \-\ PE",
"55433529", "Jacarezinho\ \-\ PR",
"55663594", "Santa\ Cruz\ do\ Xingu\ \-\ MT",
"55123957", "São\ Silvestre\ \-\ SP",
"55212886", "Nova\ Iguaçu\ \-\ RJ",
"55993427", "Barra\ do\ Corda\ \-\ MA",
"55242723", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55873841", "Sertânia\ \-\ PE",
"55623542", "Goiânia\ \-\ GO",
"55213433", "Rio\ de\ Janeiro\ \-\ RJ",
"55313379", "Minas\ Gerais",
"55114485", "Mairiporã\ \-\ SP",
"55773662", "Palmas\ de\ Monte\ Alto\ \-\ BA",
"55833633", "Baraúna\ \-\ PB",
"55113638", "São\ Paulo\ \-\ SP",
"55273090", "Cariacica\ \-\ ES",
"55953553", "Cantá\ \-\ RR",
"55173547", "Itajobi\ \-\ SP",
"55353545", "Ibiraci\ \-\ MG",
"55753448", "Itamira\ \-\ BA",
"55863131", "Teresina\ \-\ PI",
"55733605", "Itabatan\ \-\ BA",
"55114014", "Morungaba\ \-\ SP",
"55452104", "Cascavel\ \-\ PR",
"55513539", "Novo\ Hamburgo\ \-\ RS",
"55223016", "Nova\ Friburgo\ \-\ RJ",
"55743631", "Serrolândia\ \-\ BA",
"55823312", "Maceió\ \-\ AL",
"55483657", "São\ Ludgero\ \-\ SC",
"55713634", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55833267", "Juarez\ Távora\ \-\ PB",
"55493245", "Curitibanos\ \-\ SC",
"55843383", "José\ da\ Penha\ \-\ RN",
"55513451", "Rio\ Grande\ do\ Sul",
"55153535", "Nova\ Campina\ \-\ SP",
"55733268", "Porto\ Seguro\ \-\ BA",
"55833360", "Borborema\ \-\ PB",
"55553258", "Nova\ Esperança\ do\ Sul\ \-\ RS",
"55413649", "Campo\ Largo\ \-\ PR",
"55212728", "São\ Gonçalo\ \-\ RJ",
"55793364", "Telha\ \-\ SE",
"55333351", "Raul\ Soares\ \-\ MG",
"55123979", "Monteiro\ Lobato\ \-\ SP",
"55613704", "Brasília\ \-\ DF",
"55553305", "Ijuí\ \-\ RS",
"55933515", "Altamira\ \-\ PA",
"55353434", "Itapeva\ \-\ MG",
"55173621", "Jales\ \-\ SP",
"55643696", "Campo\ Alegre\ de\ Goiás\ \-\ GO",
"55313312", "Belo\ Horizonte\ \-\ MG",
"55613275", "Brasília\ \-\ DF",
"55115695", "São\ Paulo\ \-\ SP",
"55122126", "Pindamonhangaba\ \-\ SP",
"55192513", "Campinas\ \-\ SP",
"55183273", "Álvares\ Machado\ \-\ SP",
"5531377", "Minas\ Gerais",
"55553785", "Inhacorá\ \-\ RS",
"55443655", "Cafezal\ do\ Sul\ \-\ PR",
"55373288", "Araújos\ \-\ MG",
"55112321", "São\ Paulo\ \-\ SP",
"55353411", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55343332", "Uberaba\ \-\ MG",
"55483531", "Morro\ Grande\ \-\ SC",
"55123145", "Cruzeiro\ \-\ SP",
"55963283", "Santana\ \-\ AP",
"55474141", "Itajaí\ \-\ SC",
"55114703", "Cotia\ \-\ SP",
"55173254", "Mirassol\ \-\ SP",
"55553352", "São\ Luiz\ Gonzaga\ \-\ RS",
"55173295", "Monte\ Aprazível\ \-\ SP",
"55443463", "Paranacity\ \-\ PR",
"55373361", "Oliveira\ \-\ MG",
"55913468", "Capitão\ Poço\ \-\ PA",
"55353297", "Alfenas\ \-\ MG",
"55373755", "Morada\ Nova\ de\ Minas\ \-\ MG",
"55322104", "Juiz\ de\ Fora\ \-\ MG",
"55732103", "Itabuna\ \-\ BA",
"55513763", "Rio\ Grande\ do\ Sul",
"55212666", "Nova\ Iguaçu\ \-\ RJ",
"55114031", "Bragança\ Paulista\ \-\ SP",
"55643652", "Cristianópolis\ \-\ GO",
"55433616", "Sengés\ \-\ PR",
"55323466", "Além\ Paraíba\ \-\ MG",
"55313887", "Acaiaca\ \-\ MG",
"55823218", "Maceió\ \-\ AL",
"55543519", "Erechim\ \-\ RS",
"55133321", "Santos\ \-\ SP",
"55373276", "Conceição\ do\ Pará\ \-\ MG",
"55543393", "Mormaço\ \-\ RS",
"55543525", "Severiano\ de\ Almeida\ \-\ RS",
"55642103", "Itumbiara\ \-\ GO",
"55143342", "Chavantes\ \-\ SP",
"55983477", "São\ Bernardo\ \-\ MA",
"55793221", "Aracaju\ \-\ SE",
"55963426", "Lourenço\ \-\ AP",
"55353066", "Poços\ de\ Caldas\ \-\ MG",
"55863273", "Curralinhos\ \-\ PI",
"55613013", "Brasília\ \-\ DF",
"55923877", "Manaus\ \-\ AM",
"55943422", "Piçarras\ \-\ PA",
"55423434", "Guamirim\ \-\ PR",
"55163346", "Boa\ Esperança\ do\ Sul\ \-\ SP",
"55413468", "Alexandra\ \-\ PR",
"55483242", "Palhoça\ \-\ SC",
"55473397", "Gaspar\ \-\ SC",
"55513256", "Rio\ Grande\ do\ Sul",
"55114264", "Francisco\ Morato\ \-\ SP",
"55693459", "Ji\-Paraná\ \-\ RO",
"55143104", "Bauru\ \-\ SP",
"55193486", "Charqueada\ \-\ SP",
"55163690", "Jardinópolis\ \-\ SP",
"55323553", "Guiricema\ \-\ MG",
"55923545", "Boa\ Vista\ do\ Ramos\ \-\ AM",
"55733617", "Itabuna\ \-\ BA",
"55343213", "Uberlândia\ \-\ MG",
"55913447", "Cachoeira\ do\ Piriá\ \-\ PA",
"55162111", "Ribeirão\ Preto\ \-\ SP",
"55513671", "Camaquã\ \-\ RS",
"55513722", "Cachoeira\ do\ Sul\ \-\ RS",
"55643018", "Itumbiara\ \-\ GO",
"55132101", "Santos\ \-\ SP",
"55863265", "União\ \-\ PI",
"55813553", "Amaraji\ \-\ PE",
"55274003", "Vitória\ \-\ ES",
"55833342", "Campina\ Grande\ \-\ PB",
"55193478", "Americana\ \-\ SP",
"55983198", "São\ Luís\ \-\ MA",
"55683615", "Santa\ Rosa\ do\ Purus\ \-\ AC",
"55613551", "Brasília\ \-\ DF",
"5571210", "Salvador\ \-\ BA",
"55323282", "Pedro\ Teixeira\ \-\ MG",
"55653374", "Cangas\ \-\ MT",
"55443422", "Paranavaí\ \-\ PR",
"55513775", "Pouso\ Novo\ \-\ RS",
"55663424", "Rondonópolis\ \-\ MT",
"55733554", "Aurelino\ Leal\ \-\ BA",
"55433158", "Ibiporã\ \-\ PR",
"55433441", "Marumbi\ \-\ PR",
"55443556", "Rancho\ Alegre\ D\'Oeste\ \-\ PR",
"55753669", "Ponte\ 2\ de\ Julho\ \-\ BA",
"55893533", "Rio\ Grande\ do\ Piauí\ \-\ PI",
"55553317", "Santa\ Maria\ \-\ RS",
"55843321", "Mossoró\ \-\ RN",
"55454052", "Foz\ do\ Iguaçu\ \-\ PR",
"55273555", "Mimoso\ do\ Sul\ \-\ ES",
"5575", "Bahia",
"55463552", "Capanema\ \-\ PR",
"55453376", "Nova\ Concórdia\ \-\ PR",
"55893550", "Jerumenha\ \-\ PI",
"55643595", "Itumbiara\ \-\ GO",
"55273120", "Colatina\ \-\ ES",
"55223865", "São\ João\ do\ Paraíso\ \-\ RJ",
"55463563", "Santo\ Antônio\ do\ Sudoeste\ \-\ PR",
"55113379", "Jundiaí\ \-\ SP",
"55454063", "Cascavel\ \-\ PR",
"55343248", "Cascalho\ Rico\ \-\ MG",
"55353444", "Jacutinga\ \-\ MG",
"55543476", "União\ da\ Serra\ \-\ RS",
"55313309", "Belo\ Horizonte\ \-\ MG",
"55773473", "Macaúbas\ \-\ BA",
"55743527", "Casa\ Nova\ \-\ BA",
"55643675", "Palminópolis\ \-\ GO",
"55413639", "Lapa\ \-\ PR",
"55193684", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55553322", "Cruz\ Alta\ \-\ RS",
"55493235", "Painel\ \-\ SC",
"55114159", "Vargem\ Grande\ Paulista\ \-\ SP",
"55443249", "Lobato\ \-\ PR",
"55812126", "Recife\ \-\ PE",
"55623280", "Aparecida\ de\ Goiânia\ \-\ GO",
"55633527", "Santa\ Tereza\ do\ Tocantins\ \-\ TO",
"55813562", "Primavera\ \-\ PE",
"55753438", "São\ Félix\ \-\ BA",
"55353535", "São\ Tomás\ de\ Aquino\ \-\ MG",
"55643622", "Rio\ Verde\ \-\ GO",
"55993078", "Caxias\ \-\ MA",
"55114881", "Francisco\ Morato\ \-\ SP",
"55733043", "Itabuna\ \-\ BA",
"55623387", "Anápolis\ \-\ GO",
"55112661", "São\ Paulo\ \-\ SP",
"55123034", "Caraguatatuba\ \-\ SP",
"55544003", "Caxias\ do\ Sul\ \-\ RS",
"55713644", "Camaçari\ \-\ BA",
"55223723", "Macaé\ \-\ RJ",
"5513323", "Santos\ \-\ SP",
"55743699", "Lapão\ \-\ BA",
"55613358", "Samambaia\ Sul\ \-\ DF",
"55513591", "São\ Leopoldo\ \-\ RS",
"55553798", "Rodeio\ Bonito\ \-\ RS",
"55513549", "Igrejinha\ \-\ RS",
"55743641", "Irecê\ \-\ BA",
"5531370", "Minas\ Gerais",
"55733622", "Mucuri\ \-\ BA",
"55793251", "Aracaju\ \-\ SE",
"55633234", "Palmas\ \-\ TO",
"55873831", "Serra\ Talhada\ \-\ PE",
"55483084", "Florianópolis\ \-\ SC",
"55623532", "Senador\ Canedo\ \-\ GO",
"55553375", "Panambi\ \-\ RS",
"55513717", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55273768", "Boa\ Esperança\ \-\ ES",
"55124104", "Taubaté\ \-\ SP",
"55743061", "Juazeiro\ \-\ BA",
"55343267", "Centralina\ \-\ MG",
"5522272", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55112528", "São\ Paulo\ \-\ SP",
"55114177", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55493677", "Itapiranga\ \-\ SC",
"55213002", "Rio\ de\ Janeiro\ \-\ RJ",
"55193582", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55313243", "Minas\ Gerais",
"55323354", "Resende\ Costa\ \-\ MG",
"55833063", "Campina\ Grande\ \-\ PB",
"55113357", "São\ Paulo\ \-\ SP",
"55513752", "Jacarezinho\ \-\ RS",
"55343633", "Tapira\ \-\ MG",
"55552102", "Uruguaiana\ \-\ RS",
"55643663", "Caiapônia\ \-\ GO",
"55733237", "Buerarema\ \-\ BA",
"55114682", "Juquitiba\ \-\ SP",
"55112862", "São\ Paulo\ \-\ SP",
"55474007", "Joinville\ \-\ SC",
"55773465", "Ibiassucê\ \-\ BA",
"55843661", "Natal\ \-\ RN",
"55663406", "Torixoréu\ \-\ MT",
"55112773", "São\ Paulo\ \-\ SP",
"55613521", "Brasília\ \-\ DF",
"55423636", "Cantagalo\ \-\ PR",
"55913776", "Santa\ Bárbara\ do\ Pará\ \-\ PA",
"55613048", "Taguatinga\ \-\ DF",
"55213589", "Mesquita\ \-\ RJ",
"55813523", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55443452", "Santa\ Cruz\ de\ Monte\ Castelo\ \-\ PR",
"55183349", "Frutal\ do\ Campo\ \-\ SP",
"55663495", "Primavera\ do\ Leste\ \-\ MT",
"55193934", "Indaiatuba\ \-\ SP",
"55683235", "Acrelândia\ \-\ AC",
"55553363", "São\ Nicolau\ \-\ RS",
"55133862", "Colonização\ \-\ SP",
"55443526", "Formosa\ do\ Oeste\ \-\ PR",
"55163026", "Franca\ \-\ SP",
"55453540", "São\ Miguel\ do\ Iguaçu\ \-\ PR",
"55143022", "Avaré\ \-\ SP",
"55843351", "Pau\ dos\ Ferros\ \-\ RN",
"55513483", "Alvorada\ \-\ RS",
"55212630", "Magé\ \-\ RJ",
"55193586", "Itirapina\ \-\ SP",
"55323453", "Dona\ Eusébia\ \-\ MG",
"55153279", "Sao\ Miguel\ Arcanjo\ \-\ SP",
"55683211", "Rio\ Branco\ \-\ AC",
"55633479", "Piraquê\ \-\ TO",
"55314007", "Belo\ Horizonte\ \-\ MG",
"55713164", "Salvador\ \-\ BA",
"55212653", "Duque\ de\ Caxias\ \-\ RJ",
"55163075", "Ribeirão\ Preto\ \-\ SP",
"55443575", "Roncador\ \-\ PR",
"55513756", "Anta\ Gorda\ \-\ RS",
"55653396", "Alto\ Paraguai\ \-\ MT",
"55543033", "Nova\ Petrópolis\ \-\ RS",
"55124004", "São\ José\ dos\ Campos\ \-\ SP",
"55663402", "Barra\ do\ Garças\ \-\ MT",
"55114686", "São\ Lourenço\ da\ Serra\ \-\ SP",
"5562400", "Goiânia\ \-\ GO",
"55193865", "Hortolândia\ \-\ SP",
"55114349", "São\ Paulo\ \-\ SP",
"55433627", "Leópolis\ \-\ PR",
"55913725", "Apeú\ \-\ PA",
"5511474", "Suzano\ \-\ SP",
"55923534", "Nhamundá\ \-\ AM",
"55513704", "Monte\ Alverne\ \-\ RS",
"55753331", "Seabra\ \-\ BA",
"55163951", "Cravinhos\ \-\ SP",
"55543701", "Bento\ Gonçalves\ \-\ RS",
"55443522", "Goioerê\ \-\ PR",
"55463526", "Itapejara\ D\'Oeste\ \-\ PR",
"55143026", "Ourinhos\ \-\ SP",
"55383321", "Montes\ Claros\ \-\ MG",
"55813453", "Recife\ \-\ PE",
"55543381", "Soledade\ \-\ RS",
"55643454", "Caldas\ Novas\ \-\ GO",
"55193578", "Campinas\ \-\ SP",
"55913772", "Mosqueiro\ \-\ PA",
"55423632", "Jordãozinho\ \-\ PR",
"55913621", "Caiçava\ \-\ PA",
"55773693", "Rio\ do\ Pires\ \-\ BA",
"55893450", "Francisco\ Santos\ \-\ PI",
"55643495", "Goiatuba\ \-\ GO",
"55873779", "Jupi\ \-\ PE",
"55433541", "Uraí\ \-\ PR",
"55893433", "Monsenhor\ Hipólito\ \-\ PI",
"55543268", "Farroupilha\ \-\ RS",
"55873829", "Ingazeira\ \-\ PE",
"55193873", "Sumaré\ \-\ SP",
"55483431", "Quarta\ Linha\ \-\ SC",
"55413547", "Lapa\ \-\ PR",
"55213813", "Rio\ de\ Janeiro\ \-\ RJ",
"55673669", "Paranaíba\ \-\ MS",
"55883587", "Juazeiro\ do\ Norte\ \-\ CE",
"55553326", "Cruz\ Alta\ \-\ RS",
"55543340", "Vanini\ \-\ RS",
"55185841", "Junqueirópolis\ \-\ SP",
"55313718", "Baldim\ \-\ MG",
"55913822", "Quatipuru\ \-\ PA",
"5567", "Mato\ Grosso\ do\ Sul",
"55153257", "Porangaba\ \-\ SP",
"55633457", "Colméia\ \-\ TO",
"55543472", "São\ Valentim\ do\ Sul\ \-\ RS",
"55283036", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55353343", "Baependi\ \-\ MG",
"55314114", "Conselheiro\ Lafaiete\ \-\ MG",
"55115721", "Mauá\ \-\ SP",
"55513038", "Campo\ Bom\ \-\ RS",
"55443563", "Farol\ \-\ PR",
"55473309", "Blumenau\ \-\ SC",
"55733626", "Núcleo\ Colonial\ de\ Una\ \-\ BA",
"55443624", "Umuarama\ \-\ PR",
"55623536", "Goiânia\ \-\ GO",
"55383014", "Montes\ Claros\ \-\ MG",
"55413621", "Colombo\ \-\ PR",
"55382101", "Montes\ Claros\ \-\ MG",
"55173386", "Pirangi\ \-\ SP",
"55513263", "Rio\ Grande\ do\ Sul",
"55433232", "Sertanópolis\ \-\ PR",
"55643626", "Santo\ Antônio\ da\ Barra\ \-\ GO",
"55173691", "Três\ Fronteiras\ \-\ SP",
"55883400", "Limoeiro\ do\ Norte\ \-\ CE",
"55513637", "Feliz\ \-\ RS",
"55683244", "Rio\ Branco\ \-\ AC",
"55883650", "Carnaubal\ \-\ CE",
"55173571", "Santa\ Adélia\ \-\ SP",
"55443283", "Barbosa\ Ferraz\ \-\ PR",
"55323423", "Cataguases\ \-\ MG",
"55143004", "Bauru\ \-\ SP",
"55433260", "Guaraci\ \-\ PR",
"55313071", "Belo\ Horizonte\ \-\ MG",
"55843608", "Natal\ \-\ RN",
"55883633", "Ararendá\ \-\ CE",
"55513726", "Lajeado\ \-\ RS",
"55383823", "Riacho\ dos\ Machados\ \-\ MG",
"55343074", "Uberaba\ \-\ MG",
"55483246", "São\ José\ \-\ SC",
"55873877", "Floresta\ \-\ PE",
"55943364", "Vila\ Mandii\ \-\ PA",
"55313397", "Contagem\ \-\ MG",
"55513252", "Rio\ Grande\ do\ Sul",
"55323278", "Pequeri\ \-\ MG",
"55663506", "Analândia\ do\ Norte\ \-\ MT",
"55673438", "Laguna\ Carapã\ \-\ MS",
"5521340", "Rio\ de\ Janeiro\ \-\ RJ",
"55913755", "Igarapé\-Miri\ \-\ PA",
"55193482", "Águas\ de\ São\ Pedro\ \-\ SP",
"55623645", "Goiânia\ \-\ GO",
"55443552", "Boa\ Esperança\ \-\ PR",
"5575322", "Feira\ de\ Santana\ \-\ BA",
"55993631", "São\ Luís\ Gonzaga\ do\ Maranhão\ \-\ MA",
"55663595", "Matupá\ \-\ MT",
"55863321", "Parnaíba\ \-\ PI",
"55913817", "Nova\ Esperança\ do\ Piriá\ \-\ PA",
"55653228", "Lambari\ D\'Oeste\ \-\ MT",
"55643089", "Itumbiara\ \-\ GO",
"55463556", "Pérola\ D\'Oeste\ \-\ PR",
"55183264", "Iepê\ \-\ SP",
"55333203", "Governador\ Valadares\ \-\ MG",
"55833346", "Barra\ de\ Santana\ \-\ PB",
"55513583", "Rio\ Grande\ do\ Sul",
"55323286", "Santo\ Antônio\ do\ Aventureiro\ \-\ MG",
"55933736", "Munguba\ \-\ PA",
"55114893", "Campo\ Limpo\ Paulista\ \-\ SP",
"55133273", "Santos\ \-\ SP",
"55173874", "Macaubal\ \-\ SP",
"55184101", "Presidente\ Prudente\ \-\ SP",
"55433367", "Londrina\ \-\ PR",
"55663554", "Vila\ Rica\ \-\ MT",
"55843265", "Poço\ Branco\ \-\ RN",
"55273033", "Vila\ Velha\ \-\ ES",
"55553356", "Bossoroca\ \-\ RS",
"55713003", "Salvador\ \-\ BA",
"55623998", "Goiânia\ \-\ GO",
"55713635", "Mata\ de\ São\ João\ \-\ BA",
"55853382", "Maracanaú\ \-\ CE",
"55873859", "Santa\ Terezinha\ \-\ PE",
"55313289", "Minas\ Gerais",
"55513310", "Rio\ Grande\ do\ Sul",
"55353544", "Ibiraci\ \-\ MG",
"55114015", "Tuiuti\ \-\ SP",
"55452105", "Foz\ do\ Iguaçu\ \-\ PR",
"55733604", "Batinga\ \-\ BA",
"5511273", "São\ Paulo\ \-\ SP",
"55114598", "Vargem\ \-\ SP",
"55114029", "Salto\ \-\ SP",
"55114484", "Mairiporã\ \-\ SP",
"55373225", "Nova\ Serrana\ \-\ MG",
"55343336", "Uberaba\ \-\ MG",
"55633427", "Pequizeiro\ \-\ TO",
"55953593", "Amajari\ \-\ RR",
"55613601", "Luziânia\ \-\ GO",
"55493735", "Fazenda\ Zandavalli\ \-\ SC",
"55643604", "Mairipotaba\ \-\ GO",
"55143346", "Bernardino\ de\ Campos\ \-\ SP",
"55823289", "Santana\ do\ Mundaú\ \-\ AL",
"55413651", "São\ Luiz\ do\ Purunã\ \-\ PR",
"55322152", "Juiz\ de\ Fora\ \-\ MG",
"55213311", "Macaé\ \-\ RJ",
"55553784", "Chiapetta\ \-\ RS",
"55443654", "Brasilândia\ do\ Sul\ \-\ PR",
"55513491", "Guaíba\ \-\ RS",
"55193371", "Piracicaba\ \-\ SP",
"55963422", "Tartarugalzinho\ \-\ AP",
"55513449", "Rio\ Grande\ do\ Sul",
"55733656", "Ilhéus\ \-\ BA",
"55273381", "Vitória\ \-\ ES",
"55553304", "Santa\ Maria\ \-\ RS",
"55353435", "Extrema\ \-\ MG",
"55933514", "Brasil\ Novo\ \-\ PA",
"55943426", "Xinguara\ \-\ PA",
"55843273", "São\ José\ de\ Mipibu\ \-\ RN",
"55114131", "Pirapora\ do\ Bom\ Jesus\ \-\ SP",
"55613274", "Brasília\ \-\ DF",
"55163342", "Ibitinga\ \-\ SP",
"55662103", "Rondonópolis\ \-\ MT",
"55353841", "Bom\ Sucesso\ \-\ MG",
"55273268", "Domingos\ Martins\ \-\ ES",
"55793365", "Malhada\ dos\ Bois\ \-\ SE",
"55173202", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55643656", "Caçu\ \-\ GO",
"55493631", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55493244", "Santa\ Cecília\ \-\ SC",
"55153534", "Taquarivaí\ \-\ SP",
"55843428", "São\ Fernando\ \-\ RN",
"5531320", "Minas\ Gerais",
"55373272", "Maravilhas\ \-\ MG",
"55213543", "Rio\ de\ Janeiro\ \-\ RJ",
"55733271", "Iguaí\ \-\ BA",
"55183703", "Bairro\ Formosa\ \-\ SP",
"55483529", "Praia\ Grande\ \-\ SC",
"55333764", "Minas\ Novas\ \-\ MG",
"55623432", "Goiânia\ \-\ GO",
"55323462", "Além\ Paraíba\ \-\ MG",
"55273362", "Guarapari\ \-\ ES",
"55433242", "Bela\ Vista\ do\ Paraíso\ \-\ PR",
"55173639", "Populina\ \-\ SP",
"55213520", "Rio\ de\ Janeiro\ \-\ RJ",
"55543237", "Bom\ Jesus\ \-\ RS",
"55114273", "Caieiras\ \-\ SP",
"55193803", "Sumaré\ \-\ SP",
"55223012", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55153511", "Itapetininga\ \-\ SP",
"55513647", "Vendinha\ \-\ RS",
"55473047", "Balneário\ Camboriú\ \-\ SC",
"55753287", "Abaré\ \-\ BA",
"55623546", "Goiânia\ \-\ GO",
"55123144", "Cruzeiro\ \-\ SP",
"55153343", "Votorantim\ \-\ SP",
"55473379", "Massaranduba\ \-\ SC",
"55212681", "Seropédica\ \-\ RJ",
"55933531", "Medicilândia\ \-\ PA",
"55893589", "Caracol\ \-\ PI",
"55923318", "Nova\ Olinda\ do\ Norte\ \-\ AM",
"55114428", "Santo\ André\ \-\ SP",
"55143487", "Júlio\ Mesquita\ \-\ SP",
"55313870", "Minas\ Gerais",
"55353333", "Soledade\ de\ Minas\ \-\ MG",
"55653363", "Cuiabá\ \-\ MT",
"55413382", "São\ José\ dos\ Pinhais\ \-\ PR",
"55433477", "São\ João\ do\ Ivaí\ \-\ PR",
"55423435", "Pinho\ de\ Baixo\ \-\ PR",
"55182101", "Presidente\ Prudente\ \-\ SP",
"55853361", "Aquiraz\ \-\ CE",
"55493557", "Zortéa\ \-\ SC",
"55112893", "São\ Paulo\ \-\ SP",
"55183942", "Gardênia\ \-\ SP",
"55183558", "Sagres\ \-\ SP",
"55713460", "Salvador\ \-\ BA",
"55473312", "Timbó\ \-\ SC",
"55543524", "Mariano\ Moro\ \-\ RS",
"55513048", "Osório\ \-\ RS",
"55743629", "Barro\ Alto\ \-\ BA",
"55373691", "Divinópolis\ \-\ MG",
"55272103", "Linhares\ \-\ ES",
"55613483", "Sobradinho\ \-\ DF",
"55733692", "Camacan\ \-\ BA",
"55673413", "Panambi\ \-\ MS",
"55813481", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55543353", "Caseiros\ \-\ RS",
"55483441", "Urussanga\ \-\ SC",
"55163983", "Luís\ Antônio\ \-\ SP",
"55863383", "Esperantina\ \-\ PI",
"55453035", "Cascavel\ \-\ PR",
"55543330", "Carazinho\ \-\ RS",
"55473357", "Ibirama\ \-\ SC",
"55513668", "Palmares\ do\ Sul\ \-\ RS",
"55973379", "Novo\ Aripuanã\ \-\ AM",
"55663472", "Serra\ Dourada\ \-\ MT",
"55423642", "Turvo\ \-\ PR",
"55114007", "São\ Paulo\ \-\ SP",
"55813372", "Paulista\ \-\ PE",
"55893443", "Santana\ do\ Piauí\ \-\ PI",
"55433531", "Santa\ Mariana\ \-\ PR",
"55193016", "Indaiatuba\ \-\ SP",
"55693441", "Cacoal\ \-\ RO",
"55193112", "Campinas\ \-\ SP",
"55993614", "Itaipava\ do\ Grajaú\ \-\ MA",
"55753341", "João\ Amaro\ \-\ BA",
"55173826", "Uchoa\ \-\ SP",
"55453278", "Toledo\ \-\ PR",
"55653322", "Cuiabá\ \-\ MT",
"55143713", "Paranapanema\ \-\ SP",
"55114265", "Itapecerica\ da\ Serra\ \-\ SP",
"55323372", "São\ João\ Del\ Rei\ \-\ MG",
"55513067", "Novo\ Hamburgo\ \-\ RS",
"55613591", "Sobradinho\ \-\ DF",
"55213119", "São\ Gonçalo\ \-\ RJ",
"55193508", "Araras\ \-\ SP",
"55313720", "Minas\ Gerais",
"55643594", "Itumbiara\ \-\ GO",
"55513774", "Ilópolis\ \-\ RS",
"55123302", "São\ José\ dos\ Campos\ \-\ SP",
"55183321", "Assis\ \-\ SP",
"55114608", "Francisco\ Morato\ \-\ SP",
"55212882", "Nova\ Iguaçu\ \-\ RJ",
"55553565", "Porto\ Lucena\ \-\ RS",
"55543622", "Passo\ Fundo\ \-\ RS",
"55613717", "Brasília\ \-\ DF",
"55993557", "Nova\ Iorque\ \-\ MA",
"55473233", "São\ Francisco\ do\ Sul\ \-\ SC",
"55353212", "Varginha\ \-\ MG",
"55453286", "Capitão\ Leônidas\ Marques\ \-\ PR",
"55663419", "Campo\ Verde\ \-\ MT",
"55643555", "Avelinópolis\ \-\ GO",
"55813319", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55863264", "José\ de\ Freitas\ \-\ PI",
"55493641", "Princesa\ \-\ SC",
"55733674", "Barra\ de\ Caravelas\ \-\ BA",
"55423511", "Santo\ Antônio\ do\ Iratim\ \-\ PR",
"55353831", "Campo\ Belo\ \-\ MG",
"55443676", "Cruzeiro\ do\ Oeste\ \-\ PR",
"55472107", "Jaraguá\ do\ Sul\ \-\ SC",
"55923030", "Manaus\ \-\ AM",
"55153544", "Ribeirão\ Grande\ \-\ SP",
"55543617", "Tapejara\ \-\ RS",
"55513439", "Cachoeirinha\ \-\ RS",
"55623370", "Montes\ Claros\ de\ Goiás\ \-\ GO",
"55123111", "Cunha\ \-\ SP",
"55813673", "Catende\ \-\ PE",
"55643674", "Iporá\ \-\ GO",
"55223864", "Aperibé\ \-\ RJ",
"55333339", "Manhuaçu\ \-\ MG",
"55633369", "Novo\ Acordo\ \-\ TO",
"55443251", "Sabáudia\ \-\ PR",
"55114141", "Itapevi\ \-\ SP",
"55753021", "Feira\ de\ Santana\ \-\ BA",
"55353445", "Borda\ da\ Mata\ \-\ MG",
"55693236", "Porto\ Velho\ \-\ RO",
"55183528", "Osvaldo\ Cruz\ \-\ SP",
"55273771", "São\ Mateus\ \-\ ES",
"55493527", "Joaçaba\ \-\ SC",
"55443688", "Xambrê\ \-\ PR",
"55743659", "Várzea\ Nova\ \-\ BA",
"55513551", "Estância\ Velha\ \-\ RS",
"55333265", "Santa\ Rita\ do\ Itueto\ \-\ MG",
"55623277", "Aparecida\ de\ Goiânia\ \-\ GO",
"55133391", "Guarujá\ \-\ SP",
"55193301", "Piracicaba\ \-\ SP",
"55483085", "Florianópolis\ \-\ SC",
"55673467", "Fátima\ do\ Sul\ \-\ MS",
"55543323", "Nova\ Alvorada\ \-\ RS",
"55713645", "Pojuca\ \-\ BA",
"5531327", "Belo\ Horizonte\ \-\ MG",
"55183862", "Pacaembu\ \-\ SP",
"55353534", "Itamogi\ \-\ MG",
"5511274", "São\ Paulo\ \-\ SP",
"55633659", "Ponte\ Alta\ do\ Bom\ Jesus\ \-\ TO",
"55173272", "Tanabi\ \-\ SP",
"55773464", "Mortugaba\ \-\ BA",
"55143767", "Coronel\ Macedo\ \-\ SP",
"55543362", "Nonoai\ \-\ RS",
"55273237", "Vitória\ \-\ ES",
"55323355", "Tiradentes\ \-\ MG",
"55183823", "Dracena\ \-\ SP",
"55754009", "Feira\ de\ Santana\ \-\ BA",
"55993641", "Coroatá\ \-\ MA",
"55343690", "Araguari\ \-\ MG",
"55483903", "Araranguá\ \-\ SC",
"5519341", "Piracicaba\ \-\ SP",
"55793526", "Estância\ \-\ SE",
"55653352", "Nova\ Marilândia\ \-\ MT",
"55513792", "Costão\ \-\ RS",
"55673448", "Deodápolis\ \-\ MS",
"55313750", "Minas\ Gerais",
"55213194", "Rio\ de\ Janeiro\ \-\ RJ",
"55192121", "Campinas\ \-\ SP",
"55643519", "Itumbiara\ \-\ GO",
"55483236", "Florianópolis\ \-\ SC",
"55353716", "Poços\ de\ Caldas\ \-\ MG",
"55313733", "Joaquim\ Murtinho\ \-\ MG",
"55183351", "Palmital\ \-\ SP",
"55813761", "Garanhuns\ \-\ PE",
"55663455", "Santa\ Elvira\ \-\ MT",
"55733525", "Jequié\ \-\ BA",
"55333428", "Santo\ Antônio\ do\ Itambé\ \-\ MG",
"55433429", "Califórnia\ \-\ PR",
"55212136", "Rio\ de\ Janeiro\ \-\ RJ",
"55663588", "Ipiranga\ do\ Norte\ \-\ MT",
"55242223", "Petrópolis\ \-\ RJ",
"55193935", "Indaiatuba\ \-\ SP",
"55663494", "São\ José\ do\ Povo\ \-\ MT",
"55683234", "Capixaba\ \-\ AC",
"55133203", "Santos\ \-\ SP",
"55843391", "Martins\ \-\ RN",
"55883643", "Massapê\ \-\ CE",
"55673926", "Ponta\ Porã\ \-\ MS",
"55542103", "Passo\ Fundo\ \-\ RS",
"55743677", "Ponto\ Novo\ \-\ BA",
"55513411", "Alvorada\ \-\ RS",
"55273732", "Baixo\ Guandu\ \-\ ES",
"55163266", "Borborema\ \-\ SP",
"55773648", "Novo\ Horizonte\ \-\ BA",
"55443629", "Cianorte\ \-\ PR",
"55143262", "Agudos\ \-\ SP",
"55173827", "Potirendaba\ \-\ SP",
"55112533", "São\ Paulo\ \-\ SP",
"55323538", "Presidente\ Bernardes\ \-\ MG",
"55353825", "Itutinga\ \-\ MG",
"55983652", "Bom\ Jesus\ das\ Selvas\ \-\ MA",
"55115614", "São\ Paulo\ \-\ SP",
"55753603", "Feira\ de\ Santana\ \-\ BA",
"55473356", "Vidal\ Ramos\ \-\ SC",
"55213077", "Rio\ de\ Janeiro\ \-\ RJ",
"55753462", "Itapicuru\ \-\ BA",
"55243355", "Resende\ \-\ RJ",
"55193017", "Indaiatuba\ \-\ SP",
"55483018", "Florianópolis\ \-\ SC",
"55993556", "Mirador\ \-\ MA",
"55463244", "Sulina\ \-\ PR",
"55453287", "Boa\ Vista\ da\ Aparecida\ \-\ PR",
"55983362", "Icatu\ \-\ MA",
"55733242", "Ibicaraí\ \-\ BA",
"55893485", "Isaías\ Coelho\ \-\ PI",
"55373241", "Itaúna\ \-\ MG",
"55114518", "Mauá\ \-\ SP",
"55892101", "Picos\ \-\ PI",
"55893558", "São\ Francisco\ do\ Piauí\ \-\ PI",
"55743221", "Senhor\ do\ Bonfim\ \-\ BA",
"55513066", "Novo\ Hamburgo\ \-\ RS",
"55433133", "Cornélio\ Procópio\ \-\ PR",
"55613632", "Formosa\ \-\ GO",
"55313662", "Pedro\ Leopoldo\ \-\ MG",
"55123021", "São\ José\ dos\ Campos\ \-\ SP",
"55993422", "Caxias\ \-\ MA",
"55223056", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55433555", "Japira\ \-\ PR",
"55663515", "Sinop\ \-\ MT",
"55163482", "Cravinhos\ \-\ SP",
"55973356", "Anamã\ \-\ AM",
"55513709", "Lajeado\ \-\ RS",
"55883112", "Sobral\ \-\ CE",
"5511501", "São\ Paulo\ \-\ SP",
"55773667", "Pindaí\ \-\ BA",
"55313210", "Minas\ Gerais",
"55513389", "Rio\ Grande\ do\ Sul",
"55313861", "Nova\ Era\ \-\ MG",
"55993602", "Nova\ Colinas\ \-\ MA",
"55143486", "Herculândia\ \-\ SP",
"55313623", "São\ José\ da\ Lapa\ \-\ MG",
"55673044", "Campo\ Grande\ \-\ MS",
"55173542", "Novo\ Horizonte\ \-\ SP",
"55212397", "Duque\ de\ Caxias\ \-\ RJ",
"55123843", "Ubatuba\ \-\ SP",
"5511436", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55513123", "Porto\ Alegre\ \-\ RS",
"55983323", "Centro\ do\ Guilherme\ \-\ MA",
"55483652", "Grão\ Pará\ \-\ SC",
"55863345", "São\ João\ da\ Fronteira\ \-\ PI",
"55353722", "Poços\ de\ Caldas\ \-\ MG",
"55114813", "Itu\ \-\ SP",
"55663529", "Querência\ \-\ MT",
"55473046", "Itajaí\ \-\ SC",
"55753286", "Coronel\ João\ Sá\ \-\ BA",
"55212743", "Teresópolis\ \-\ RJ",
"55163945", "Sertãozinho\ \-\ SP",
"55833262", "João\ Pessoa\ \-\ PB",
"55753423", "Alagoinhas\ \-\ BA",
"55623621", "Goiânia\ \-\ GO",
"55633474", "Araguatins\ \-\ TO",
"55153274", "Alambari\ \-\ SP",
"55143478", "Bastos\ \-\ SP",
"55733531", "Ipiaú\ \-\ BA",
"55823623", "Olho\ d\'Água\ das\ Flores\ \-\ AL",
"55673562", "Chapadão\ do\ Sul\ \-\ MS",
"55112838", "São\ Paulo\ \-\ SP",
"55683463", "Feijó\ \-\ AC",
"5562331", "Anápolis\ \-\ GO",
"5511353", "São\ Paulo\ \-\ SP",
"5581322", "Recife\ \-\ PE",
"55533249", "Hulha\ Negra\ \-\ RS",
"55753278", "Cícero\ Dantas\ \-\ BA",
"55433476", "Cândido\ de\ Abreu\ \-\ PR",
"55143223", "Bauru\ \-\ SP",
"55843533", "Afonso\ Bezerra\ \-\ RN",
"55493556", "Brunópolis\ \-\ SC",
"55643531", "Itumbiara\ \-\ GO",
"55963244", "Macapá\ \-\ AP",
"55532123", "Pelotas\ \-\ RS",
"5561219", "Brasília\ \-\ DF",
"5513347", "Praia\ Grande\ \-\ SP",
"5551330", "Rio\ Grande\ do\ Sul",
"55443659", "Altônia\ \-\ PR",
"55513444", "Viamão\ \-\ RS",
"55823284", "Cajueiro\ \-\ AL",
"55543441", "Veranópolis\ \-\ RS",
"55333344", "Lajinha\ \-\ MG",
"55983622", "Bacabal\ \-\ MA",
"55115641", "São\ Paulo\ \-\ SP",
"55353855", "Coqueiral\ \-\ MG",
"55663577", "Canabrava\ do\ Norte\ \-\ MT",
"55483330", "Florianópolis\ \-\ SC",
"55123975", "Santa\ Branca\ \-\ SP",
"55313322", "Minas\ Gerais",
"55112334", "São\ Paulo\ \-\ SP",
"55143766", "Arandu\ \-\ SP",
"55883685", "Ipueiras\ \-\ CE",
"5517332", "Barretos\ \-\ SP",
"55483524", "Araranguá\ \-\ SC",
"55242487", "Avelar\ \-\ RJ",
"55243325", "Barra\ Mansa\ \-\ RJ",
"55493249", "Campo\ Belo\ do\ Sul\ \-\ SC",
"55244004", "Petrópolis\ \-\ RJ",
"55413073", "Belo\ Horizonte\ \-\ MG",
"55873854", "Carnaíba\ \-\ PE",
"55833253", "Bayeux\ \-\ PB",
"55483821", "Florianópolis\ \-\ SC",
"55463211", "Francisco\ Beltrão\ \-\ PR",
"55153451", "Tatuí\ \-\ SP",
"55222566", "Bom\ Jardim\ \-\ RJ",
"55353591", "Monte\ Santo\ de\ Minas\ \-\ MG",
"55373214", "Divinópolis\ \-\ MG",
"55343281", "Tupaciguara\ \-\ MG",
"55793641", "Riachão\ do\ Dantas\ \-\ SE",
"55743676", "Quixabeira\ \-\ BA",
"55423421", "Irati\ \-\ PR",
"55693043", "Porto\ Velho\ \-\ RO",
"55954009", "Boa\ Vista\ \-\ RR",
"55243372", "Paraty\ \-\ RJ",
"55114489", "Francisco\ Morato\ \-\ SP",
"55114024", "Itu\ \-\ SP",
"55113305", "São\ Paulo\ \-\ SP",
"55643609", "Itumbiara\ \-\ GO",
"55973464", "Tonantins\ \-\ AM",
"55683303", "Rio\ Branco\ \-\ AC",
"55613212", "Brasília\ \-\ DF",
"55313375", "Belo\ Horizonte\ \-\ MG",
"55353226", "Luminárias\ \-\ MG",
"55833684", "Serra\ da\ Raiz\ \-\ PB",
"55623361", "Itapaci\ \-\ GO",
"55323331", "Barbacena\ \-\ MG",
"55112687", "São\ Paulo\ \-\ SP",
"55433525", "Jacarezinho\ \-\ PR",
"55213484", "Rio\ de\ Janeiro\ \-\ RJ",
"55483043", "Tubarão\ \-\ SC",
"55613081", "Brasília\ \-\ DF",
"55693237", "Porto\ Velho\ \-\ RO",
"55983524", "Imperatriz\ \-\ MA",
"55983353", "Apicum\-Açu\ \-\ MA",
"55183269", "Pirapozinho\ \-\ SP",
"55773613", "Barreiras\ \-\ BA",
"55623288", "Aparecida\ de\ Goiânia\ \-\ GO",
"55553243", "Santana\ do\ Livramento\ \-\ RS",
"55153292", "Salto\ de\ Pirapora\ \-\ SP",
"55443677", "Tapejara\ \-\ PR",
"55143582", "Uru\ \-\ SP",
"55472106", "Jaraguá\ do\ Sul\ \-\ SC",
"55663559", "Novo\ Horizonte\ do\ Norte\ \-\ MT",
"55733084", "Ilhéus\ \-\ BA",
"55312102", "Belo\ Horizonte\ \-\ MG",
"55483622", "Tubarão\ \-\ SC",
"55323083", "Juiz\ de\ Fora\ \-\ MG",
"5531381", "Minas\ Gerais",
"55163723", "Franca\ \-\ SP",
"55693524", "Governador\ Jorge\ Teixeira\ \-\ RO",
"55663431", "Guiratinga\ \-\ MT",
"55913741", "Soure\ \-\ PA",
"55115061", "São\ Paulo\ \-\ SP",
"55112088", "Guarulhos\ \-\ SP",
"55454009", "Cascavel\ \-\ PR",
"55112119", "Atibaia\ \-\ SP",
"55753453", "Itanagra\ \-\ BA",
"55193643", "Vargem\ Grande\ do\ Sul\ \-\ SP",
"55873792", "Terezinha\ \-\ PE",
"55173812", "Icém\ \-\ SP",
"55433572", "Londrina\ \-\ PR",
"55613333", "Recanto\ das\ Emas\ \-\ DF",
"55843334", "Serra\ do\ Mel\ \-\ RN",
"55753430", "Itapicuru\ \-\ BA",
"55423274", "Ventania\ \-\ PR",
"55473464", "Joinville\ \-\ SC",
"55493452", "Seara\ \-\ SC",
"55213131", "Rio\ de\ Janeiro\ \-\ RJ",
"55493526", "Jaborá\ \-\ SC",
"55943369", "Parauapebas\ \-\ PA",
"55413432", "Antonina\ \-\ PR",
"5519352", "Rio\ Claro\ \-\ SP",
"55193022", "Mogi\ Mirim\ \-\ SP",
"55673466", "Glória\ de\ Dourados\ \-\ MS",
"55633456", "Augustinópolis\ \-\ TO",
"55643541", "Itumbiara\ \-\ GO",
"55963234", "Porto\ Grande\ \-\ AP",
"55153256", "Campina\ do\ Monte\ Alegre\ \-\ SP",
"55814009", "Recife\ \-\ PE",
"55213114", "Rio\ de\ Janeiro\ \-\ RJ",
"55283037", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55823032", "Maceió\ \-\ AL",
"55243111", "Petrópolis\ \-\ RJ",
"55623920", "Goiânia\ \-\ GO",
"55733313", "Ipiaú\ \-\ BA",
"55513779", "Rio\ Grande\ do\ Sul",
"55173280", "Olímpia\ \-\ SP",
"55433454", "Cruzmaltina\ \-\ PR",
"55112848", "São\ Paulo\ \-\ SP",
"55654141", "Cuiabá\ \-\ MT",
"55493574", "Macieira\ \-\ SC",
"55883586", "Crato\ \-\ CE",
"55553327", "Salto\ do\ Jacuí\ \-\ RS",
"55983455", "Matões\ do\ Norte\ \-\ MA",
"5511354", "São\ Paulo\ \-\ SP",
"55633522", "Lagoa\ do\ Tocantins\ \-\ TO",
"55813314", "Recife\ \-\ PE",
"55863269", "Beneditinos\ \-\ PI",
"55353274", "Olímpio\ Noronha\ \-\ MG",
"55123833", "Ubatuba\ \-\ SP",
"55643627", "Riverlândia\ \-\ GO",
"55613435", "Brasília\ \-\ DF",
"55623382", "Fazenda\ Nova\ \-\ GO",
"55143408", "Marília\ \-\ SP",
"55222665", "Araruama\ \-\ RJ",
"55553613", "Mato\ Queimado\ \-\ RS",
"55324009", "Juiz\ de\ Fora\ \-\ MG",
"55513636", "Rio\ Grande\ do\ Sul",
"55733627", "Santa\ Cruz\ da\ Vitória\ \-\ BA",
"5561202", "Brasília\ \-\ DF",
"55623537", "Aparecida\ de\ Goiânia\ \-\ GO",
"55323314", "Juiz\ de\ Fora\ \-\ MG",
"55883578", "Umari\ \-\ CE",
"55753208", "Campinhos\ \-\ BA",
"55214137", "Nilópolis\ \-\ RJ",
"55513712", "Estrêla\ \-\ RS",
"55133848", "Iguape\ \-\ SP",
"55613642", "Formosa\ \-\ GO",
"55993574", "Fortuna\ \-\ MA",
"55433626", "Jundiaí\ do\ Sul\ \-\ PR",
"55743624", "Jacobina\ \-\ BA",
"55343262", "Ituiutaba\ \-\ MG",
"55112490", "Bragança\ Paulista\ \-\ SP",
"55713621", "Camaçari\ \-\ BA",
"55813021", "Paulista\ \-\ PE",
"55813548", "Itapissuma\ \-\ PE",
"55463234", "Bom\ Sucesso\ do\ Sul\ \-\ PR",
"55793211", "Aracaju\ \-\ SE",
"55673261", "Bandeirantes\ \-\ MS",
"55373231", "Pará\ de\ Minas\ \-\ MG",
"55653397", "Diamantino\ \-\ MT",
"55513757", "Nova\ Bréscia\ \-\ RS",
"55114687", "São\ Lourenço\ da\ Serra\ \-\ SP",
"55112867", "São\ Paulo\ \-\ SP",
"55173634", "Urânia\ \-\ SP",
"55833561", "Bernardino\ Batista\ \-\ PB",
"55412626", "Curitiba\ \-\ PR",
"55333533", "Novo\ Cruzeiro\ \-\ MG",
"55824102", "Centro\ \-\ AL",
"55473374", "Schroeder\ \-\ SC",
"55273742", "São\ Domingos\ do\ Norte\ \-\ ES",
"55663903", "Alta\ Floresta\ \-\ MT",
"55163301", "Araraquara\ \-\ SP",
"55323021", "Ubá\ \-\ MG",
"55463527", "Francisco\ Beltrão\ \-\ PR",
"55222673", "Araruama\ \-\ RJ",
"55493625", "Belmonte\ \-\ SC",
"55893498", "Lagoa\ do\ Barro\ do\ Piauí\ \-\ PI",
"55113403", "Bragança\ Paulista\ \-\ SP",
"55633426", "São\ Sebastião\ do\ Tocantins\ \-\ TO",
"55623933", "Goiânia\ \-\ GO",
"55743552", "Campo\ Formoso\ \-\ BA",
"55113653", "Osasco\ \-\ SP",
"5545322", "Cascavel\ \-\ PR",
"55413442", "Guaratuba\ \-\ PR",
"55483268", "Leoberto\ Leal\ \-\ SC",
"55423256", "Porto\ Amazonas\ \-\ PR",
"55613797", "Brasília\ \-\ DF",
"55173809", "Mendonça\ \-\ SP",
"55114533", "Jundiaí\ \-\ SP",
"55353292", "Alfenas\ \-\ MG",
"55913731", "Vigia\ \-\ PA",
"55183345", "Presidente\ Prudente\ \-\ SP",
"55663499", "Araguaiana\ \-\ MT",
"55813341", "Recife\ \-\ PE",
"55483381", "São\ José\ \-\ SC",
"55443607", "São\ Tomé\ \-\ PR",
"55163461", "Araraquara\ \-\ SP",
"55553233", "São\ Sepé\ \-\ RS",
"55493592", "Tangará\ \-\ SC",
"55124408", "Polvilho\ \-\ SP",
"55643657", "Bom\ Jardim\ de\ Goiás\ \-\ GO",
"55753325", "Iaçu\ \-\ BA",
"55894101", "Picos\ \-\ PI",
"55112518", "São\ Paulo\ \-\ SP",
"55833368", "Areial\ \-\ PB",
"55553250", "Nova\ Esperança\ do\ Sul\ \-\ RS",
"55613961", "Brasília\ \-\ DF",
"55753593", "Heliópolis\ \-\ BA",
"55513140", "Novo\ Hamburgo\ \-\ RS",
"55313882", "Minas\ Gerais",
"55983472", "Brejo\ \-\ MA",
"55323341", "Ressaquinha\ \-\ MG",
"5547343", "Joinville\ \-\ SC",
"55943427", "Água\ Azul\ do\ Norte\ \-\ PA",
"55412118", "Curitiba\ \-\ PR",
"55483033", "Palhoça\ \-\ SC",
"55163508", "Araraquara\ \-\ SP",
"55833281", "Itabaiana\ \-\ PB",
"55473565", "Mirim\ Doce\ \-\ SC",
"55873876", "Belém\ de\ São\ Francisco\ \-\ PE",
"55313396", "Minas\ Gerais",
"55923671", "Manaus\ \-\ AM",
"55483247", "São\ José\ \-\ SC",
"55633695", "Novo\ Alegre\ \-\ TO",
"55643612", "Rio\ Verde\ \-\ GO",
"55654007", "Cuiabá\ \-\ MT",
"55112813", "São\ Paulo\ \-\ SP",
"55553379", "Condor\ \-\ RS",
"55663507", "Simione\ \-\ MT",
"55823258", "Passo\ de\ Camaragibe\ \-\ AL",
"55713651", "São\ Francisco\ do\ Conde\ \-\ BA",
"55743654", "Barra\ do\ Mendes\ \-\ BA",
"55983381", "Pinheiro\ \-\ MA",
"55733612", "Itabuna\ \-\ BA",
"55613053", "Brasília\ \-\ DF",
"55713276", "Salvador\ \-\ BA",
"55513545", "Igrejinha\ \-\ RS",
"55313681", "Lagoa\ Santa\ \-\ MG",
"55493365", "Modelo\ \-\ SC",
"55913442", "Santa\ Maria\ do\ Pará\ \-\ PA",
"55983268", "São\ Luís\ \-\ MA",
"55513727", "Rio\ Grande\ do\ Sul",
"55353539", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55823305", "Maceió\ \-\ AL",
"55633654", "Taguatinga\ \-\ TO",
"55793631", "Lagarto\ \-\ SE",
"5513336", "Cubatão\ \-\ SP",
"55733679", "Porto\ Seguro\ \-\ BA",
"55353451", "Silvianópolis\ \-\ MG",
"55222134", "Iguaba\ Grande\ \-\ RJ",
"55443245", "Mandaguaçu\ \-\ PR",
"55833347", "Gado\ Bravo\ \-\ PB",
"55323287", "Senador\ Cortes\ \-\ MG",
"55933737", "Almeirim\ \-\ PA",
"55143281", "Bauru\ \-\ SP",
"55653925", "Cuiabá\ \-\ MT",
"55413003", "Curitiba\ \-\ PR",
"55413635", "São\ José\ dos\ Pinhais\ \-\ PR",
"55443427", "Porto\ Rico\ \-\ PR",
"55643679", "Sanclerlândia\ \-\ GO",
"55513434", "Viamão\ \-\ RS",
"55313305", "Belo\ Horizonte\ \-\ MG",
"55813700", "Caruaru\ \-\ PE",
"55993592", "Açailândia\ \-\ MA",
"55933502", "Castelo\ dos\ Sonhos\ \-\ PA",
"55553312", "Santo\ Ângelo\ \-\ RS",
"55623683", "Santa\ Bárbara\ de\ Goiás\ \-\ GO",
"55243302", "Petrópolis\ \-\ RJ",
"55493655", "Campo\ Erê\ \-\ SC",
"55115631", "São\ Paulo\ \-\ SP",
"55113375", "São\ Paulo\ \-\ SP",
"55713288", "Lauro\ de\ Freitas\ \-\ BA",
"55323051", "Barbacena\ \-\ MG",
"55463557", "Bela\ Vista\ da\ Caroba\ \-\ PR",
"55633364", "Lagoa\ da\ Confusão\ \-\ TO",
"55333334", "Manhuaçu\ \-\ MG",
"55273332", "Vitória\ \-\ ES",
"55993584", "Lajeado\ Novo\ \-\ MA",
"55543267", "Vila\ Seca\ \-\ RS",
"55353653", "Conceição\ dos\ Ouros\ \-\ MG",
"55473222", "Blumenau\ \-\ SC",
"55352102", "Pouso\ Alegre\ \-\ MG",
"55193577", "Corumbataí\ \-\ SP",
"55893496", "São\ Francisco\ de\ Assis\ do\ Piauí\ \-\ PI",
"55313752", "Catas\ Altas\ da\ Noruega\ \-\ MG",
"55653257", "Rio\ Branco\ \-\ MT",
"55843479", "Carnaúba\ dos\ Dantas\ \-\ RN",
"55753683", "Humildes\ \-\ BA",
"55533031", "Pelotas\ \-\ RS",
"55623481", "Posse\ \-\ GO",
"55513243", "Rio\ Grande\ do\ Sul",
"55223084", "Macaé\ \-\ RJ",
"55853331", "Barreira\ \-\ CE",
"55643570", "Claudinápolis\ \-\ GO",
"55173359", "Colômbia\ \-\ SP",
"55473275", "Jaraguá\ do\ Sul\ \-\ SC",
"55353363", "Itamonte\ \-\ MG",
"55843412", "Currais\ Novos\ \-\ RN",
"55713453", "Salvador\ \-\ BA",
"55414009", "Curitiba\ \-\ PR",
"55474108", "Balneário\ Camboriú\ \-\ SC",
"55443543", "Ubiratã\ \-\ PR",
"55473384", "Rodeio\ \-\ SC",
"55923228", "Manaus\ \-\ AM",
"55443311", "Jardim\ Olinda\ \-\ PR",
"55543360", "Nova\ Boa\ Vista\ \-\ RS",
"55833454", "Ibiara\ \-\ PB",
"55893574", "Curimatá\ \-\ PI",
"55692183", "Ji\-Paraná\ \-\ RO",
"55163663", "Jardinópolis\ \-\ SP",
"55183211", "Birigui\ \-\ SP",
"55163821", "Orlândia\ \-\ SP",
"55612141", "Brasília\ \-\ DF",
"55143406", "Garça\ \-\ SP",
"55313855", "Alvinópolis\ \-\ MG",
"55513638", "Salvador\ do\ Sul\ \-\ RS",
"55623325", "Rubiataba\ \-\ GO",
"55433561", "Conselheiro\ Mairinck\ \-\ PR",
"55623593", "Goiânia\ \-\ GO",
"55812626", "Recife\ \-\ PE",
"55513789", "Boqueirão\ do\ Leão\ \-\ RS",
"55133846", "Pedro\ Barros\ \-\ SP",
"55273213", "Cariacica\ \-\ ES",
"55883576", "Jaguaretama\ \-\ CE",
"55313894", "Araponga\ \-\ MG",
"55123897", "Caraguatatuba\ \-\ SP",
"55353322", "Seritinga\ \-\ MG",
"55343849", "Monte\ Carmelo\ \-\ MG",
"55663022", "Rondonópolis\ \-\ MT",
"55163353", "Ibaté\ \-\ SP",
"55433911", "Jacarezinho\ \-\ PR",
"55353284", "Serrania\ \-\ MG",
"55313549", "Minas\ Gerais",
"55943311", "Parauapebas\ \-\ PA",
"55623372", "Goiás\ \-\ GO",
"55513037", "São\ Leopoldo\ \-\ RS",
"55193845", "Hortolândia\ \-\ SP",
"55353798", "Areado\ \-\ MG",
"55553535", "Três\ de\ Maio\ \-\ RS",
"55153258", "Guareí\ \-\ SP",
"55143454", "Marília\ \-\ SP",
"55143495", "Tupã\ \-\ SP",
"55353375", "Dom\ Viçoso\ \-\ MG",
"55653212", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55213552", "Duque\ de\ Caxias\ \-\ RJ",
"55313717", "Santana\ de\ Pirapama\ \-\ MG",
"55473263", "Balneário\ Camboriú\ \-\ SC",
"55153305", "Tatuí\ \-\ SP",
"55323229", "Juiz\ de\ Fora\ \-\ MG",
"55533264", "Praia\ do\ Hermenegildo\ \-\ RS",
"55383614", "Montalvânia\ \-\ MG",
"55163524", "Sertãozinho\ \-\ SP",
"55193431", "Tanquinho\ \-\ SP",
"55753254", "Ipirá\ \-\ BA",
"55273248", "Aracê\ \-\ ES",
"55353623", "Itajubá\ \-\ MG",
"55923681", "Manaus\ \-\ AM",
"55494101", "Chapecó\ \-\ SC",
"55353861", "Nepomuceno\ \-\ MG",
"55873886", "Verdejante\ \-\ PE",
"55383842", "Salinas\ \-\ MG",
"55212642", "Teresópolis\ \-\ RJ",
"55983371", "Governador\ Nunes\ Freire\ \-\ MA",
"55823204", "Chã\ Preta\ \-\ AL",
"55323442", "Leopoldina\ \-\ MG",
"55333744", "Rio\ do\ Prado\ \-\ MG",
"55713286", "Salvador\ \-\ BA",
"55143366", "Bauru\ \-\ SP",
"55343674", "Matutina\ \-\ MG",
"55313722", "Queluzito\ \-\ MG",
"55513469", "Cachoeirinha\ \-\ RS",
"55933793", "Porto\ de\ Moz\ \-\ PA",
"55143604", "Barra\ Bonita\ \-\ SP",
"55113601", "Osasco\ \-\ SP",
"55343201", "Araxá\ \-\ MG",
"55873929", "Serra\ Talhada\ \-\ PE",
"55883696", "Monsenhor\ Tabosa\ \-\ CE",
"55823256", "Flexeiras\ \-\ AL",
"55173329", "Alberto\ Moreira\ \-\ SP",
"55213913", "Itaboraí\ \-\ RJ",
"55323277", "Chácara\ \-\ MG",
"55673437", "Ponta\ Porã\ \-\ MS",
"55213847", "Rio\ de\ Janeiro\ \-\ RJ",
"55873878", "Bodocó\ \-\ PE",
"55313398", "Minas\ Gerais",
"55333235", "Tumiritinga\ \-\ MG",
"55973491", "Carauari\ \-\ AM",
"55283545", "Iúna\ \-\ ES",
"55413399", "Campo\ Largo\ \-\ PR",
"55643689", "Diorama\ \-\ GO",
"55673202", "Campo\ Grande\ \-\ MS",
"55143656", "Torrinha\ \-\ SP",
"55113705", "Santo\ André\ \-\ SP",
"55112245", "Guarulhos\ \-\ SP",
"55443344", "Maringá\ \-\ PR",
"55183981", "Mirante\ do\ Paranapanema\ \-\ SP",
"55123432", "Taubaté\ \-\ SP",
"55313775", "Sete\ Lagoas\ \-\ MG",
"55753471", "Feira\ de\ Santana\ \-\ BA",
"55114409", "Jacaré\ \-\ SP",
"55833424", "Salgadinho\ \-\ PB",
"55353564", "Conceição\ da\ Aparecida\ \-\ MG",
"55913287", "Ananindeua\ \-\ PA",
"55113113", "São\ Paulo\ \-\ SP",
"55112427", "Atibaia\ \-\ SP",
"55773434", "Planalto\ \-\ BA",
"55143737", "Garça\ \-\ SP",
"55112516", "São\ Paulo\ \-\ SP",
"55833366", "Lagoa\ Seca\ \-\ PB",
"55243401", "Barra\ Mansa\ \-\ RJ",
"55813635", "Itambé\ \-\ PE",
"55163851", "Morro\ Agudo\ \-\ SP",
"55843427", "Timbaúba\ dos\ Batistas\ \-\ RN",
"55183631", "Araçatuba\ \-\ SP",
"55553411", "Uruguaiana\ \-\ RS",
"55843245", "Vila\ Flor\ \-\ RN",
"55543332", "Não\-Me\-Toque\ \-\ RS",
"55623355", "Itapuranga\ \-\ GO",
"55513218", "Rio\ Grande\ do\ Sul",
"55273267", "Fundão\ \-\ ES",
"55383745", "Lagoa\ dos\ Patos\ \-\ MG",
"55163506", "Matão\ \-\ SP",
"55623394", "Santa\ Rita\ do\ Novo\ Destino\ \-\ GO",
"55713462", "Salvador\ \-\ BA",
"55313819", "Ponte\ Nova\ \-\ MG",
"55383527", "Turmalina\ \-\ MG",
"55883425", "Ibicuitinga\ \-\ CE",
"55483266", "Florianópolis\ \-\ SC",
"55943344", "Nova\ Ipixuna\ \-\ PA",
"55163323", "Ribeirão\ Preto\ \-\ SP",
"55323003", "Juiz\ de\ Fora\ \-\ MG",
"55633428", "Araguanã\ \-\ TO",
"55813731", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55922125", "Manaus\ \-\ AM",
"55313872", "Abre\ Campo\ \-\ MG",
"55114597", "Nazaré\ Paulista\ \-\ SP",
"55113421", "Mauá\ \-\ SP",
"55313763", "Conselheiro\ Lafaiete\ \-\ MG",
"55115094", "São\ Paulo\ \-\ SP",
"55222537", "Carmo\ \-\ RJ",
"55983482", "Buriti\ \-\ MA",
"55383234", "São\ João\ da\ Ponte\ \-\ MG",
"55433240", "São\ Martinho\ \-\ PR",
"55193965", "Hortolândia\ \-\ SP",
"55353662", "Maria\ da\ Fé\ \-\ MG",
"55473449", "São\ Francisco\ do\ Sul\ \-\ SC",
"55623997", "Goiânia\ \-\ GO",
"55443518", "Campo\ Mourão\ \-\ PR",
"55883419", "Arneiroz\ \-\ CE",
"55833271", "Guarabira\ \-\ PB",
"55163472", "Araraquara\ \-\ SP",
"55993321", "Imperatriz\ \-\ MA",
"55213938", "Rio\ de\ Janeiro\ \-\ RJ",
"55753651", "Jiquiriçá\ \-\ BA",
"55863244", "Miguel\ Alves\ \-\ PI",
"55513379", "Rio\ Grande\ do\ Sul",
"55112836", "São\ Paulo\ \-\ SP",
"55193499", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55614007", "Brasília\ \-\ DF",
"55433223", "Cambé\ \-\ PR",
"55143476", "Campos\ Novos\ Paulista\ \-\ SP",
"55193835", "Indaiatuba\ \-\ SP",
"55983461", "Vargem\ Grande\ \-\ MA",
"55513047", "Gravataí\ \-\ RS",
"55313539", "Betim\ \-\ MG",
"55473647", "Mafra\ \-\ SC",
"55883617", "Tamboril\ \-\ CE",
"55493558", "Ipira\ \-\ SC",
"55853051", "Fortaleza\ \-\ CE",
"55183557", "Salmourão\ \-\ SP",
"55492101", "Lages\ \-\ SC",
"55553545", "Porto\ Mauá\ \-\ RS",
"55753276", "Ribeira\ do\ Pombal\ \-\ BA",
"55143849", "Bairro\ de\ Santana\ \-\ SP",
"55653053", "Várzea\ Grande\ \-\ MT",
"55833133", "João\ Pessoa\ \-\ PB",
"55433478", "Lunardelli\ \-\ PR",
"55873784", "São\ João\ \-\ PE",
"55113138", "São\ Paulo\ \-\ SP",
"55143488", "Quintana\ \-\ SP",
"55153284", "Cerquilho\ \-\ SP",
"55173121", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55633484", "Campos\ Lindos\ \-\ TO",
"55222651", "Saquarema\ \-\ RJ",
"5553323", "Rio\ Grande\ \-\ RS",
"55923317", "Autazes\ \-\ AM",
"55114427", "Santo\ André\ \-\ SP",
"55343839", "Patrocínio\ \-\ MG",
"55623302", "Jussara\ \-\ GO",
"55343454", "Carneirinho\ \-\ MG",
"55132138", "Santos\ \-\ SP",
"55473521", "Rio\ do\ Sul\ \-\ SC",
"55473048", "Itajaí\ \-\ SC",
"55333412", "São\ João\ Evangelista\ \-\ MG",
"55453259", "São\ José\ das\ Palmeiras\ \-\ PR",
"55773411", "Ibitira\ \-\ BA",
"55714117", "Simões\ Filho\ \-\ BA",
"55423662", "Paz\ \-\ PR",
"55883554", "Barro\ \-\ CE",
"55823539", "Arapiraca\ \-\ AL",
"55543238", "Caxias\ do\ Sul\ \-\ RS",
"55463055", "Francisco\ Beltrão\ \-\ PR",
"55693461", "Ouro\ Preto\ do\ Oeste\ \-\ RO",
"55633015", "Palmas\ \-\ TO",
"55213492", "Niterói\ \-\ RJ",
"55893422", "Picos\ \-\ PI",
"55483461", "Criciúma\ \-\ SC",
"55153653", "Capão\ Bonito\ \-\ SP",
"55813536", "Pombos\ \-\ PE",
"55793443", "Campo\ do\ Brito\ \-\ SE",
"5537", "Minas\ Gerais",
"55993558", "Passagem\ Franca\ \-\ MA",
"55414116", "Curitiba\ \-\ PR",
"55613718", "Formosa\ \-\ GO",
"55993014", "Imperatriz\ \-\ MA",
"55992101", "Imperatriz\ \-\ MA",
"55673255", "Bonito\ \-\ MS",
"55223058", "Cabo\ Frio\ \-\ RJ",
"55653343", "Arenápolis\ \-\ MT",
"55152102", "Sorocaba\ \-\ SP",
"55493321", "Chapecó\ \-\ SC",
"55853341", "Maranguape\ \-\ CE",
"55114607", "Jundiaí\ \-\ SP",
"55193507", "Araras\ \-\ SP",
"55313292", "Belo\ Horizonte\ \-\ MG",
"55163605", "Ribeirão\ Preto\ \-\ SP",
"55323536", "Senador\ Firmino\ \-\ MG",
"55373359", "Arcos\ \-\ MG",
"55682101", "Rio\ Branco\ \-\ AC",
"55453277", "Toledo\ \-\ PR",
"55153363", "Boituva\ \-\ SP",
"55473205", "Joinville\ \-\ SC",
"55773646", "Ipupiara\ \-\ BA",
"55893475", "Novo\ Oriente\ do\ Piauí\ \-\ PI",
"55223811", "Itaperuna\ \-\ RJ",
"55214062", "Rio\ de\ Janeiro\ \-\ RJ",
"55634001", "Palmas\ \-\ TO",
"55883652", "Guaraciaba\ do\ Norte\ \-\ CE",
"55823292", "Porto\ Calvo\ \-\ AL",
"55112597", "São\ Paulo\ \-\ SP",
"55433262", "Assaí\ \-\ PR",
"55833488", "Santa\ Inês\ \-\ PB",
"55213688", "Rio\ de\ Janeiro\ \-\ RJ",
"55473358", "Witmarsum\ \-\ SC",
"55513667", "Três\ Cachoeiras\ \-\ RS",
"55753621", "Cruz\ das\ Almas\ \-\ BA",
"55823421", "Palmeira\ dos\ Índios\ \-\ AL",
"55653318", "Cuiabá\ \-\ MT",
"55433253", "Cambé\ \-\ PR",
"55354102", "Pouso\ Alegre\ \-\ MG",
"55112086", "Guarulhos\ \-\ SP",
"55383631", "São\ Francisco\ \-\ MG",
"55883663", "Bela\ Cruz\ \-\ CE",
"55673468", "Vicentina\ \-\ MS",
"55183745", "Itapura\ \-\ SP",
"55483301", "Tubarão\ \-\ SC",
"55543017", "Veranópolis\ \-\ RS",
"55143572", "Pirajuí\ \-\ SP",
"55553757", "Novo\ Barreiro\ \-\ RS",
"55443687", "Maripá\ \-\ PR",
"55613397", "Taguatinga\ \-\ DF",
"55512107", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55653023", "Cuiabá\ \-\ MT",
"55173889", "Altair\ \-\ SP",
"55813741", "Toritama\ \-\ PE",
"55624105", "Senador\ Canedo\ \-\ GO",
"55222772", "Macaé\ \-\ RJ",
"55112078", "Barueri\ \-\ SP",
"55533321", "Pelotas\ \-\ RS",
"55993661", "Codó\ \-\ MA",
"55222621", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55343424", "Itapagipe\ \-\ MG",
"55333516", "Capelinha\ \-\ MG",
"55123003", "São\ José\ dos\ Campos\ \-\ SP",
"55443125", "Marialva\ \-\ PR",
"55123635", "Taubaté\ \-\ SP",
"55813645", "Feira\ Nova\ \-\ PE",
"55883524", "Aiuaba\ \-\ CE",
"55543618", "Nonoai\ \-\ RS",
"55773444", "Livramento\ de\ Nossa\ Senhora\ \-\ BA",
"55323741", "Carangola\ \-\ MG",
"55833201", "Campina\ Grande\ \-\ PB",
"55353473", "Santa\ Rita\ do\ Sapucaí\ \-\ MG",
"55433337", "Londrina\ \-\ PR",
"55463025", "Pato\ Branco\ \-\ PR",
"55843235", "Natal\ \-\ RN",
"55543342", "Marau\ \-\ RS",
"55183699", "Lourdes\ \-\ SP",
"55923363", "Manaquiri\ \-\ AM",
"55183641", "Birigui\ \-\ SP",
"55423630", "Guarapuava\ \-\ PR",
"55893452", "Wall\ Ferraz\ \-\ PI",
"55183842", "Junqueirópolis\ \-\ SP",
"55513101", "Alvorada\ \-\ RS",
"55283535", "Presidente\ Kennedy\ \-\ ES",
"55823274", "Colônia\ Pindorama\ \-\ AL",
"55793269", "Riachuelo\ \-\ SE",
"55213221", "Rio\ de\ Janeiro\ \-\ RJ",
"55423653", "Rio\ Bonito\ do\ Iguaçu\ \-\ PR",
"55333427", "Materlândia\ \-\ MG",
"55493351", "Entre\ Rios\ \-\ SC",
"55673225", "Coxim\ \-\ MS",
"55333245", "Divino\ das\ Laranjeiras\ \-\ MG",
"55883675", "Independência\ \-\ CE",
"55614141", "Brasília\ \-\ DF",
"55213837", "Rio\ de\ Janeiro\ \-\ RJ",
"55422102", "Ponta\ Grossa\ \-\ PR",
"55673447", "Novo\ Horizonte\ do\ Sul\ \-\ MS",
"55413083", "Curitiba\ \-\ PR",
"55143201", "Bauru\ \-\ SP",
"55513613", "Fazenda\ Vilanova\ \-\ RS",
"55373329", "Formiga\ \-\ MG",
"55173467", "Nhandeara\ \-\ SP",
"55193903", "Sumaré\ \-\ SP",
"55223844", "Porciúncula\ \-\ RJ",
"55343271", "Ituiutaba\ \-\ MG",
"55743686", "Ibipeba\ \-\ BA",
"55353465", "Monte\ Sião\ \-\ MG",
"55833525", "Sousa\ \-\ PB",
"55114161", "Barueri\ \-\ SP",
"55833393", "Fagundes\ \-\ PB",
"55212632", "Guapimirim\ \-\ RJ",
"55383832", "São\ João\ do\ Paraíso\ \-\ MG",
"55543052", "Bento\ Gonçalves\ \-\ RS",
"55673272", "Sidrolândia\ \-\ MS",
"5561320", "Brasília\ \-\ DF",
"55143768", "Jurumirim\ \-\ SP",
"55333734", "Itaobim\ \-\ MG",
"55713394", "Aratu\ \-\ BA",
"55313385", "Minas\ Gerais",
"55933582", "Santa\ Maria\ do\ Uruará\ \-\ PA",
"55973389", "Apuí\ \-\ AM",
"55383625", "Varzelândia\ \-\ MG",
"55193617", "Rio\ Claro\ \-\ SP",
"55313544", "Betim\ \-\ MG",
"55443015", "Marialva\ \-\ PR",
"55163515", "Ribeirão\ Preto\ \-\ SP",
"55114606", "Várzea\ Paulista\ \-\ SP",
"55173044", "Bebedouro\ \-\ SP",
"55712223", "Salvador\ \-\ BA",
"55833477", "Livramento\ \-\ PB",
"55133596", "Praia\ Grande\ \-\ SP",
"55753635", "Mutuípe\ \-\ BA",
"55483342", "Palhoça\ \-\ SC",
"55893557", "Nazaré\ do\ Piauí\ \-\ PI",
"55354141", "Poços\ de\ Caldas\ \-\ MG",
"55113445", "Itaquaquecetuba\ \-\ SP",
"55853462", "Fortaleza\ \-\ CE",
"55333522", "Teófilo\ Otoni\ \-\ MG",
"55813537", "Chã\ Grande\ \-\ PE",
"55863239", "Santo\ Antônio\ dos\ Milagres\ \-\ PI",
"55453288", "Santa\ Lúcia\ \-\ PR",
"55753259", "Euclides\ da\ Cunha\ \-\ BA",
"55473411", "Rio\ do\ Sul\ \-\ SC",
"55323224", "Juiz\ de\ Fora\ \-\ MG",
"55193851", "Mogi\-Guaçu\ \-\ SP",
"55883441", "Quixeramobim\ \-\ CE",
"55173562", "Tabapuã\ \-\ SP",
"55193554", "Leme\ \-\ SP",
"55213078", "Rio\ de\ Janeiro\ \-\ RJ",
"5511434", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55643478", "Ouvidor\ \-\ GO",
"55413134", "São\ José\ dos\ Pinhais\ \-\ PR",
"55243065", "Petrópolis\ \-\ RJ",
"55123863", "Maresias\ \-\ SP",
"55613465", "Brasília\ \-\ DF",
"55183602", "Gabriel\ Monteiro\ \-\ SP",
"55313435", "Belo\ Horizonte\ \-\ MG",
"5531356", "Minas\ Gerais",
"55513784", "Mato\ Leitão\ \-\ RS",
"55212763", "Nova\ Iguaçu\ \-\ RJ",
"55383721", "Curvelo\ \-\ MG",
"55114654", "Arujá\ \-\ SP",
"55383672", "Paracatu\ \-\ MG",
"55513666", "Terra\ de\ Areia\ \-\ RS",
"55473908", "Itajaí\ \-\ SC",
"55853111", "Fortaleza\ \-\ CE",
"55643610", "Mineiros\ \-\ GO",
"55843221", "Natal\ \-\ RN",
"55323537", "Paula\ Cândido\ \-\ MG",
"55623567", "Goiânia\ \-\ GO",
"55793014", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55114695", "Guararema\ \-\ SP",
"55453276", "Santa\ Helena\ \-\ PR",
"55473390", "Itajaí\ \-\ SC",
"55313166", "Belo\ Horizonte\ \-\ MG",
"552124", "Rio\ de\ Janeiro\ \-\ RJ",
"55343844", "Grupiara\ \-\ MG",
"55773647", "Ibitiara\ \-\ BA",
"55313899", "Viçosa\ \-\ MG",
"55313841", "Coronel\ Fabriciano\ \-\ MG",
"55133505", "Mongaguá\ \-\ SP",
"55614102", "Brasília\ \-\ DF",
"55483052", "Tubarão\ \-\ SC",
"55423902", "Guarapuava\ \-\ PR",
"55193362", "Mogi\-Guaçu\ \-\ SP",
"55173354", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55444001", "Maringá\ \-\ PR",
"55183556", "Inúbia\ Paulista\ \-\ SP",
"55913481", "Primavera\ \-\ PA",
"55753277", "Antas\ \-\ BA",
"55283521", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55313318", "Belo\ Horizonte\ \-\ MG",
"55343232", "Uberlândia\ \-\ MG",
"55353743", "Campestre\ \-\ MG",
"55212671", "Duque\ de\ Caxias\ \-\ RJ",
"55212722", "Niterói\ \-\ RJ",
"55183422", "Assis\ \-\ SP",
"55173523", "Catanduva\ \-\ SP",
"55553252", "São\ Francisco\ de\ Assis\ \-\ RS",
"55112837", "São\ Paulo\ \-\ SP",
"55173395", "Terra\ Roxa\ \-\ SP",
"55733262", "Eunápolis\ \-\ BA",
"55333624", "Carlos\ Chagas\ \-\ MG",
"55313880", "Minas\ Gerais",
"55373261", "Lagoa\ da\ Prata\ \-\ MG",
"55833198", "João\ Pessoa\ \-\ PB",
"55673231", "Corumbá\ \-\ MS",
"55143477", "Arco\-Íris\ \-\ SP",
"55833459", "Nova\ Olinda\ \-\ PB",
"55493443", "São\ Domingos\ \-\ SC",
"55714116", "Dias\ d\'Ávila\ \-\ BA",
"55193652", "Aguaí\ \-\ SP",
"55173664", "Aspásia\ \-\ SP",
"55833531", "Cajazeiras\ \-\ PB",
"55653421", "Rondonópolis\ \-\ MT",
"5511405", "Diadema\ \-\ SP",
"55823642", "Mata\ Grande\ \-\ AL",
"55743533", "Campo\ Alegre\ de\ Lourdes\ \-\ BA",
"55693342", "Cerejeiras\ \-\ RO",
"55192103", "Campinas\ \-\ SP",
"55163246", "Taiúva\ \-\ SP",
"55773668", "Sebastião\ Laranjeiras\ \-\ BA",
"55813471", "Recife\ \-\ PE",
"55163973", "Guatapará\ \-\ SP",
"55543293", "Antônio\ Prado\ \-\ RS",
"55623548", "Aparecida\ de\ Goiânia\ \-\ GO",
"55115853", "São\ Paulo\ \-\ SP",
"55623952", "Aparecida\ de\ Goiânia\ \-\ GO",
"55343514", "Cachoeira\ Dourada\ \-\ MG",
"55333426", "Dores\ de\ Guanhães\ \-\ MG",
"55883085", "Juazeiro\ do\ Norte\ \-\ CE",
"55313511", "Betim\ \-\ MG",
"55323295", "Passa\-Vinte\ \-\ MG",
"55673446", "Angélica\ \-\ MS",
"55173011", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55143415", "Marília\ \-\ SP",
"55193402", "Piracicaba\ \-\ SP",
"55115041", "São\ Paulo\ \-\ SP",
"55383239", "Mirabela\ \-\ MG",
"55193663", "Divinolândia\ \-\ SP",
"55883414", "Quixadá\ \-\ CE",
"55323254", "Piau\ \-\ MG",
"55193821", "Elias\ Fausto\ \-\ SP",
"55473444", "São\ Francisco\ do\ Sul\ \-\ SC",
"55663586", "Cocalinho\ \-\ MT",
"55843087", "Natal\ \-\ RN",
"55553263", "Faxinal\ do\ Soturno\ \-\ RS",
"55773439", "Encruzilhada\ \-\ BA",
"55114624", "Osasco\ \-\ SP",
"55383751", "Corinto\ \-\ MG",
"55623513", "Nerópolis\ \-\ GO",
"55733230", "Ubaitaba\ \-\ BA",
"55693643", "Alto\ Alegre\ dos\ Parecis\ \-\ RO",
"55663578", "Itanhangá\ \-\ MT",
"55823343", "Maceió\ \-\ AL",
"55623341", "Goianápolis\ \-\ GO",
"55843251", "São\ Paulo\ do\ Potengi\ \-\ RN",
"55173466", "Cardoso\ \-\ SP",
"55473535", "Atalanta\ \-\ SC",
"55193353", "Araras\ \-\ SP",
"55413673", "Piraquara\ \-\ PR",
"55913665", "Benevides\ \-\ PA",
"55343811", "Presidente\ Olegário\ \-\ MG",
"55443686", "Palotina\ \-\ PR",
"55473130", "Joinville\ \-\ SC",
"55553756", "Cerro\ Grande\ \-\ RS",
"55512106", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55343612", "Araxá\ \-\ MG",
"55733684", "Itamaraty\ \-\ BA",
"55283551", "Divino\ de\ São\ Lourenço\ \-\ ES",
"55713083", "Salvador\ \-\ BA",
"55853302", "Apuiarés\ \-\ CE",
"55193675", "Tambaú\ \-\ SP",
"55513710", "Lajeado\ \-\ RS",
"55212752", "São\ João\ de\ Meriti\ \-\ RJ",
"55643684", "Aurilândia\ \-\ GO",
"55213629", "Niterói\ \-\ RJ",
"55813683", "Maraial\ \-\ PE",
"55483643", "Imaruí\ \-\ SC",
"55623380", "Araguapaz\ \-\ GO",
"55833429", "São\ Bentinho\ \-\ PB",
"55112087", "Guarulhos\ \-\ SP",
"55493335", "Planalto\ Alegre\ \-\ SC",
"55173553", "São\ João\ de\ Itaguaçu\ \-\ SP",
"55193622", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55133251", "Santos\ \-\ SP",
"5571325", "Salvador\ \-\ BA",
"55413665", "Pinhais\ \-\ PR",
"55433336", "Londrina\ \-\ PR",
"55633520", "Nova\ Rosalândia\ \-\ TO",
"55114456", "Salto\ \-\ SP",
"55513464", "Canoas\ \-\ RS",
"55124242", "Cotia\ \-\ SP",
"55693238", "Buritis\ \-\ RO",
"5531328", "Belo\ Horizonte\ \-\ MG",
"55543461", "Carlos\ Barbosa\ \-\ RS",
"55683901", "Rio\ Branco\ \-\ AC",
"55623922", "Goiânia\ \-\ GO",
"55112688", "Guarulhos\ \-\ SP",
"55793351", "Porto\ da\ Folha\ \-\ SE",
"55414122", "Curitiba",
"55953621", "Boa\ Vista\ \-\ RR",
"55173282", "Icém\ \-\ SP",
"55714009", "Salvador\ \-\ BA",
"55413453", "Matinhos\ \-\ PR",
"55273762", "Conceição\ da\ Barra\ \-\ ES",
"55193883", "Sumaré\ \-\ SP",
"55133847", "Miracatu\ \-\ SP",
"55163236", "Ribeirão\ Preto\ \-\ SP",
"55513693", "Rio\ Grande\ do\ Sul",
"55373354", "Japaraíba\ \-\ MG",
"55212796", "Mesquita\ \-\ RJ",
"55214138", "Queimados\ \-\ RJ",
"55623538", "Goiânia\ \-\ GO",
"55773275", "Maiquinique\ \-\ BA",
"55424007", "Ponta\ Grossa\ \-\ PR",
"55843522", "Pendências\ \-\ RN",
"55123896", "Ilhabela\ \-\ SP",
"55733628", "Santa\ Luzia\ \-\ BA",
"55833313", "Boa\ Vista\ \-\ PB",
"55513959", "Sapiranga\ \-\ RS",
"55553792", "Pinheirinho\ do\ Vale\ \-\ RS",
"55613352", "Taguatinga\ \-\ DF",
"55143407", "Garça\ \-\ SP",
"55323401", "Leopoldina\ \-\ MG",
"55493433", "Xanxerê\ \-\ SC",
"55183871", "Panorama\ \-\ SP",
"55683025", "Rio\ Branco\ \-\ AC",
"55373523", "Pompéu\ \-\ MG",
"55823632", "Olivença\ \-\ AL",
"55993072", "Imperatriz\ \-\ MA",
"55643628", "Ouroana\ \-\ GO",
"55173261", "Nova\ Granada\ \-\ SP",
"55753432", "Aramari\ \-\ BA",
"551122", "São\ Paulo\ \-\ SP",
"55383504", "Paracatu\ \-\ MG",
"55353733", "Ibitiúra\ de\ Minas\ \-\ MG",
"55333221", "Governador\ Valadares\ \-\ MG",
"55313716", "Inhaúma\ \-\ MG",
"55114492", "Jundiaí\ \-\ SP",
"55242271", "Sapucaia\ \-\ RJ",
"55553328", "Fortaleza\ dos\ Valos\ \-\ RS",
"55673241", "Aquidauana\ \-\ MS",
"55853355", "São\ Luís\ do\ Curu\ \-\ CE",
"55912122", "Ananindeua\ \-\ PA",
"55663301", "Rondonópolis\ \-\ MT",
"55212705", "Niterói\ \-\ RJ",
"55833627", "Pilõezinhos\ \-\ PB",
"55863303", "Teresina\ \-\ PI",
"55513036", "Novo\ Hamburgo\ \-\ RS",
"55343242", "Araguari\ \-\ MG",
"55193576", "Ipeúna\ \-\ SP",
"55243370", "Angra\ dos\ Reis\ \-\ RJ",
"55183625", "Araçatuba\ \-\ SP",
"55893497", "Betânia\ do\ Piauí\ \-\ PI",
"55153289", "Ibiúna\ \-\ SP",
"55143541", "Promissão\ \-\ SP",
"55323725", "Antônio\ Prado\ de\ Minas\ \-\ MG",
"55313831", "Itabira\ \-\ MG",
"55613623", "Luziânia\ \-\ GO",
"55343459", "Frutal\ \-\ MG",
"55433122", "Apucarana\ \-\ PR",
"55343834", "Guimarânia\ \-\ MG",
"55813863", "Petrolina\ \-\ PE",
"55813621", "Carpina\ \-\ PE",
"55313445", "Belo\ Horizonte\ \-\ MG",
"55543266", "Santa\ Lúcia\ do\ Piaí\ \-\ RS",
"5511433", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55883559", "Penaforte\ \-\ CE",
"55624012", "Goiânia\ \-\ GO",
"55453254", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55143313", "Bauru\ \-\ SP",
"55833232", "Bayeux\ \-\ PB",
"55222645", "Cabo\ Frio\ \-\ RJ",
"5561354", "Brasília\ \-\ DF",
"55123224", "Caçapava\ \-\ SP",
"55823534", "Jacaré\ dos\ Homens\ \-\ AL",
"55493025", "Chapecó\ \-\ SC",
"55733561", "Ubaitaba\ \-\ BA",
"55114688", "Barueri\ \-\ SP",
"55313320", "Ipaba\ \-\ MG",
"55115932", "São\ Paulo\ \-\ SP",
"55113435", "Guarulhos\ \-\ SP",
"55553551", "Tenente\ Portela\ \-\ RS",
"55513758", "Capitão\ \-\ RS",
"55543371", "Marau\ \-\ RS",
"5511356", "São\ Paulo\ \-\ SP",
"55114739", "Mogi\ das\ Cruzes\ \-\ SP",
"55883431", "Itapiúna\ \-\ CE",
"55863249", "São\ Miguel\ do\ Tapuio\ \-\ PI",
"55643408", "Joviânia\ \-\ GO",
"55193588", "Porto\ Ferreira\ \-\ SP",
"55863291", "Jardim\ do\ Mulato\ \-\ PI",
"55183721", "Andradina\ \-\ SP",
"55223201", "Araruama\ \-\ RJ",
"55193455", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55222741", "São\ João\ da\ Barra\ \-\ RJ",
"55313534", "Igarapé\ \-\ MG",
"55143844", "Pratânia\ \-\ SP",
"55873789", "Brejão\ \-\ PE",
"55273723", "Colatina\ \-\ ES",
"55483332", "Florianópolis\ \-\ SC",
"55983213", "São\ Luís\ \-\ MA",
"55453206", "Agro\ Cafeeira\ \-\ PR",
"55493019", "Lages\ \-\ SC",
"55513285", "Rio\ Grande\ do\ Sul",
"55813719", "Caruaru\ \-\ PE",
"55373324", "Pimenta\ \-\ MG",
"55953224", "Boa\ Vista\ \-\ RR",
"55943428", "Rio\ Maria\ \-\ PA",
"55853372", "São\ Gonçalo\ do\ Amarante\ \-\ CE",
"5579324", "Aracaju\ \-\ SE",
"55843552", "Galinhos\ \-\ RN",
"55633344", "Carrasco\ Bonito\ \-\ TO",
"55383526", "Carbonita\ \-\ MG",
"55114474", "Santo\ André\ \-\ SP",
"55533025", "Pelotas\ \-\ RS",
"55833058", "Campina\ Grande\ \-\ PB",
"55963014", "Macapá\ \-\ AP",
"55962101", "Macapá\ \-\ AP",
"55833367", "Bananeiras\ \-\ PB",
"55843426", "Serra\ Negra\ do\ Norte\ \-\ RN",
"55643658", "São\ Simão\ \-\ GO",
"55373553", "Estrela\ do\ Indaiá\ \-\ MG",
"55333739", "Chapada\ do\ Norte\ \-\ MG",
"55273266", "Santa\ Leopoldina\ \-\ ES",
"55513565", "Nova\ Hartz\ \-\ RS",
"55793264", "Itaporanga\ d\'Ajuda\ \-\ SE",
"55823279", "Boca\ da\ Mata\ \-\ AL",
"5511419", "Barueri\ \-\ SP",
"55333251", "Santana\ do\ Paraíso\ \-\ MG",
"55273371", "Linhares\ \-\ ES",
"55542992", "Caxias\ do\ Sul\ \-\ RS",
"55953537", "São\ Luiz\ \-\ RR",
"55283310", "Castelo\ \-\ ES",
"55493345", "Santiago\ do\ Sul\ \-\ SC",
"55913462", "Capanema\ \-\ PA",
"55193701", "Limeira\ \-\ SP",
"55843283", "Brejinho\ \-\ RN",
"55853325", "Pacoti\ \-\ CE",
"55553358", "Salvador\ das\ Missões\ \-\ RS",
"55653549", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55183373", "Tarumã\ \-\ SP",
"5517321", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55483267", "Nova\ Trento\ \-\ SC",
"55853319", "Chorozinho\ \-\ CE",
"55333087", "Teófilo\ Otoni\ \-\ MG",
"55112654", "São\ Paulo\ \-\ SP",
"55343338", "Uberaba\ \-\ MG",
"55114596", "Várzea\ Paulista\ \-\ SP",
"55733281", "Eunápolis\ \-\ BA",
"55713287", "Lauro\ de\ Freitas\ \-\ BA",
"55462101", "Pato\ Branco\ \-\ PR",
"55443273", "Ivatuba\ \-\ PR",
"55114837", "São\ Paulo\ \-\ SP",
"55323361", "Carandaí\ \-\ MG",
"55463558", "Pérola\ D\'Oeste\ \-\ PR",
"55623331", "Pirenópolis\ \-\ GO",
"55183655", "Barbosa\ \-\ SP",
"55313660", "Pedro\ Leopoldo\ \-\ MG",
"55163835", "Miguelópolis\ \-\ SP",
"55813651", "Passira\ \-\ PE",
"55883515", "Pedra\ Branca\ \-\ CE",
"55733012", "Porto\ Seguro\ \-\ BA",
"55473545", "Pouso\ Redondo\ \-\ SC",
"55343429", "Frutal\ \-\ MG",
"55433152", "Arapongas\ \-\ PR",
"55843654", "Natal\ \-\ RN",
"5543342", "Apucarana\ \-\ PR",
"55323755", "Vieiras\ \-\ MG",
"55443428", "Graciosa\ \-\ PR",
"55663016", "Primavera\ do\ Leste\ \-\ MT",
"55773449", "Malhada\ de\ Pedras\ \-\ BA",
"55433056", "Arapongas\ \-\ PR",
"55773491", "São\ Félix\ do\ Coribe\ \-\ BA",
"55913423", "Salinópolis\ \-\ PA",
"55873887", "Orocó\ \-\ PE",
"55343415", "Iturama\ \-\ MG",
"55843695", "Lagoa\ de\ Velhos\ \-\ RN",
"55833612", "João\ Pessoa\ \-\ PB",
"55883529", "Milhã\ \-\ CE",
"55413111", "Curitiba\ \-\ PR",
"55713051", "Lauro\ de\ Freitas\ \-\ BA",
"55323288", "Olaria\ \-\ MG",
"55183694", "Zacarias\ \-\ SP",
"55963321", "Serra\ do\ Navio\ \-\ AP",
"55833348", "Alcantil\ \-\ PB",
"55424141", "Ponta\ Grossa\ \-\ PR",
"55733240", "Gongogi\ \-\ BA",
"55923071", "Manaus\ \-\ AM",
"55115031", "São\ Paulo\ \-\ SP",
"55513728", "Rio\ Grande\ do\ Sul",
"55412152", "Paranaguá\ \-\ PR",
"55192532", "Piracicaba\ \-\ SP",
"55813755", "Tacaimbó\ \-\ PE",
"55663461", "Jaciara\ \-\ MT",
"55843606", "Natal\ \-\ RN",
"55813361", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55913286", "Ananindeua\ \-\ PA",
"55843364", "Olho\-D\'Água\ do\ Borges\ \-\ RN",
"55613363", "Guará\ \-\ DF",
"55313333", "Minas\ Gerais",
"55413035", "São\ José\ dos\ Pinhais\ \-\ PR",
"55823257", "Campestre\ \-\ AL",
"55413603", "Itaperuçu\ \-\ PR",
"55854117", "Maracanaú\ \-\ CE",
"55323276", "Mar\ de\ Espanha\ \-\ MG",
"55663508", "Santo\ Antônio\ Fontoura\ \-\ MT",
"55483248", "Florianópolis\ \-\ SC",
"55413462", "Morretes\ \-\ PR",
"55213846", "Duque\ de\ Caxias\ \-\ RJ",
"55273753", "Vila\ Pavão\ \-\ ES",
"55143811", "Botucatu\ \-\ SP",
"5563331", "Gurupi\ \-\ TO",
"55143352", "Piraju\ \-\ SP",
"55483491", "Orleans\ \-\ SC",
"55793214", "Aracaju\ \-\ SE",
"55513515", "Porto\ Alegre\ \-\ RS",
"55693252", "Vila\ Extrema\ \-\ RO",
"55373234", "São\ Gonçalo\ do\ Pará\ \-\ MG",
"55973482", "Ipixuna\ \-\ AM",
"55923133", "Manaus\ \-\ AM",
"55153572", "Itaberá\ \-\ SP",
"55833623", "Cuité\ de\ Mamanguape\ \-\ PB",
"55913412", "Castanhal\ \-\ PA",
"55624053", "Goiânia\ \-\ GO",
"55112843", "São\ Paulo\ \-\ SP",
"55993571", "Porto\ Franco\ \-\ MA",
"55623505", "Trindade\ \-\ GO",
"55853369", "Maranguape\ \-\ CE",
"55183992", "Narandiba\ \-\ SP",
"5521260", "São\ Gonçalo\ \-\ RJ",
"55643642", "Turvelândia\ \-\ GO",
"55513529", "Sapiranga\ \-\ RS",
"55353737", "São\ Pedro\ de\ Caldas\ \-\ MG",
"55743621", "Jacobina\ \-\ BA",
"55833042", "João\ Pessoa\ \-\ PB",
"55313262", "Belo\ Horizonte\ \-\ MG",
"55713624", "Camaçari\ \-\ BA",
"55473371", "Jaraguá\ do\ Sul\ \-\ SC",
"55212689", "Porto\ Belo\ \-\ RJ",
"55143662", "Bariri\ \-\ SP",
"55163304", "Araraquara\ \-\ SP",
"55623596", "Aparecida\ de\ Goiânia\ \-\ GO",
"55693583", "Quinto\ Bec\ \-\ RO",
"55633547", "Porto\ Nacional\ \-\ TO",
"55493437", "Passos\ Maia\ \-\ SC",
"55163666", "Santa\ Cruz\ da\ Esperança\ \-\ SP",
"55833564", "Poço\ de\ José\ de\ Moura\ \-\ PB",
"55353424", "Congonhal\ \-\ MG",
"55343228", "Uberlândia\ \-\ MG",
"55173631", "Santa\ Fé\ do\ Sul\ \-\ SP",
"55493202", "Joaçaba\ \-\ SC",
"55833317", "Galante\ \-\ PB",
"55823262", "Messias\ \-\ AL",
"55122136", "São\ José\ dos\ Campos\ \-\ SP",
"55513697", "Brochier\ \-\ RS",
"55753203", "Jeremoabo\ \-\ BA",
"55743547", "Antônio\ Gonçalves\ \-\ BA",
"55153519", "Sorocaba\ \-\ SP",
"55413457", "Pontal\ do\ Paraná\ \-\ PR",
"55133843", "Ilha\ Comprida\ \-\ SP",
"55193887", "Hortolândia\ \-\ SP",
"55983217", "São\ Luís\ \-\ MA",
"55733544", "Planaltino\ \-\ BA",
"55443546", "Quarto\ Centenário\ \-\ PR",
"55433451", "São\ Pedro\ do\ Ivaí\ \-\ PR",
"55273727", "São\ Gabriel\ da\ Palha\ \-\ ES",
"55653336", "Diamantino\ \-\ MT",
"55353366", "Alagoa\ \-\ MG",
"55173832", "General\ Salgado\ \-\ SP",
"55813311", "Ipojuca\ \-\ PE",
"55463542", "Santa\ Izabel\ do\ Oeste\ \-\ PR",
"55823223", "Maceió\ \-\ AL",
"55483583", "Balneário\ Gaivota\ \-\ SC",
"55793436", "Itabaiana\ \-\ SE",
"55813543", "Igarassu\ \-\ PE",
"55833352", "São\ João\ do\ Tigre\ \-\ PB",
"55273181", "Vitória\ \-\ ES",
"55222764", "Rio\ das\ Ostras\ \-\ RJ",
"55224141", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55163142", "São\ José\ da\ Bela\ Vista\ \-\ SP",
"55183329", "Tarumã\ \-\ SP",
"55323311", "Juiz\ de\ Fora\ \-\ MG",
"55212152", "Teresópolis\ \-\ RJ",
"55353656", "Consolação\ \-\ MG",
"55543712", "Erechim\ \-\ RS",
"55883565", "Acopiara\ \-\ CE",
"55553921", "Santa\ Maria\ \-\ RS",
"55353271", "Lambari\ \-\ MG",
"55483252", "São\ Bonifácio\ \-\ SC",
"55312191", "Contagem\ \-\ MG",
"55114820", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55613627", "Valparaíso\ de\ Goiás\ \-\ GO",
"55853182", "Fortaleza\ \-\ CE",
"55733166", "Eunápolis\ \-\ BA",
"55213035", "Rio\ de\ Janeiro\ \-\ RJ",
"55693449", "Rolim\ de\ Moura\ \-\ RO",
"55893493", "Acauã\ \-\ PI",
"55113408", "Itatiba\ \-\ SP",
"55114083", "São\ Paulo\ \-\ SP",
"55733209", "Posto\ da\ Mata\ \-\ BA",
"55313766", "Minas\ Gerais",
"556733", "Campo\ Grande\ \-\ MS",
"55123687", "Quiririm\ \-\ SP",
"55143322", "Ourinhos\ \-\ SP",
"55433274", "Arapongas\ \-\ PR",
"55813518", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55133513", "Santos\ \-\ SP",
"55313684", "Taquaraçu\ de\ Minas\ \-\ MG",
"55163326", "Boa\ Esperança\ do\ Sul\ \-\ SP",
"55183377", "Florínia\ \-\ SP",
"5511279", "São\ Paulo\ \-\ SP",
"55693222", "Porto\ Velho\ \-\ RO",
"55483263", "Tijucas\ \-\ SC",
"55673682", "Camapuã\ \-\ MS",
"55114538", "Itatiba\ \-\ SP",
"55843287", "Lagoa\ D\'Anta\ \-\ RN",
"55613612", "Cristalina\ \-\ GO",
"55133341", "Guarujá\ \-\ SP",
"55813095", "Caruaru\ \-\ PE",
"55983384", "Presidente\ Sarney\ \-\ MA",
"55743651", "Capim\ Grosso\ \-\ BA",
"55513559", "Sapiranga\ \-\ RS",
"55543434", "Silva\ Jardim\ \-\ RS",
"55123119", "Campos\ de\ Cunha\ \-\ SP",
"55613679", "São\ Gabriel\ de\ Goiás\ \-\ GO",
"55153555", "Ribeira\ \-\ SP",
"55513431", "Gravataí\ \-\ RS",
"55833363", "Solânea\ \-\ PB",
"55113368", "São\ Paulo\ \-\ SP",
"55443259", "Maringá\ \-\ PR",
"55143375", "Espírito\ Santo\ do\ Turvo\ \-\ SP",
"55633361", "Paraíso\ do\ Tocantins\ \-\ TO",
"55333331", "Manhuaçu\ \-\ MG",
"55115634", "São\ Paulo\ \-\ SP",
"55423519", "União\ da\ Vitória\ \-\ PR",
"55753015", "Feira\ de\ Santana\ \-\ BA",
"55493649", "Barra\ Bonita\ \-\ SC",
"55112341", "São\ Paulo\ \-\ SP",
"55353454", "Espírito\ Santo\ do\ Dourado\ \-\ MG",
"55143284", "Pederneiras\ \-\ SP",
"55443635", "Japurá\ \-\ PR",
"55273757", "Ponto\ Belo\ \-\ ES",
"55112818", "Mauá\ \-\ SP",
"55162106", "São\ Carlos\ \-\ SP",
"55733511", "Eunápolis\ \-\ BA",
"55913734", "Quatro\ Bocas\ \-\ PA",
"55373512", "Divinópolis\ \-\ MG",
"55823253", "Novo\ Lino\ \-\ AL",
"55813344", "Recife\ \-\ PE",
"55413607", "Araucária\ \-\ PR",
"55213916", "Rio\ de\ Janeiro\ \-\ RJ",
"55453550", "São\ Jorge\ \-\ PR",
"55613367", "Brasília\ \-\ DF",
"55313337", "Belo\ Horizonte\ \-\ MG",
"55833322", "Campina\ Grande\ \-\ PB",
"55192129", "Campinas\ \-\ SP",
"55673498", "Caarapó\ \-\ MS",
"55923572", "São\ Sebastião\ do\ Uatumã\ \-\ AM",
"55623087", "Goiânia\ \-\ GO",
"55443442", "Guairaçá\ \-\ PR",
"5511422", "São\ Caetano\ do\ Sul\ \-\ SP",
"55483275", "Rancho\ Queimado\ \-\ SC",
"55113240", "Salvador\ \-\ BA",
"55143653", "Brotas\ \-\ SP",
"55313253", "Belo\ Horizonte\ \-\ MG",
"55663535", "Sinop\ \-\ MT",
"55323344", "Bias\ Fortes\ \-\ MG",
"55993649", "Peritoró\ \-\ MA",
"55513742", "Sobradinho\ \-\ RS",
"55313230", "Minas\ Gerais",
"55353626", "Wenceslau\ Braz\ \-\ MG",
"55833284", "Caldas\ Brandão\ \-\ PB",
"55873883", "Parnamirim\ \-\ PE",
"5585348", "Fortaleza\ \-\ CE",
"55114850", "Itu\ \-\ SP",
"55613964", "Brasília\ \-\ DF",
"55823337", "Maceió\ \-\ AL",
"55953194", "Boa\ Vista\ \-\ RR",
"55773620", "Serra\ do\ Ramalho\ \-\ BA",
"55443277", "Corumbataí\ do\ Sul\ \-\ PR",
"55713283", "Salvador\ \-\ BA",
"55833375", "Pedra\ Lavrada\ \-\ PB",
"55553643", "Boa\ Vista\ do\ Cadeado\ \-\ RS",
"55513236", "Rio\ Grande\ do\ Sul",
"55773643", "Matina\ \-\ BA",
"55163693", "Jardinópolis\ \-\ SP",
"55313911", "Contagem\ \-\ MG",
"55433549", "Bandeirantes\ \-\ PR",
"55323533", "Colônia\ Padre\ Damião\ \-\ MG",
"55873771", "Bom\ Conselho\ \-\ PE",
"55753608", "Barrocas\ \-\ BA",
"55212767", "Nova\ Iguaçu\ \-\ RJ",
"55333021", "Governador\ Valadares\ \-\ MG",
"55753339", "Souto\ Soares\ \-\ BA",
"5511479", "Mogi\ das\ Cruzes\ \-\ SP",
"55613459", "Samambaia\ Sul\ \-\ DF",
"55123867", "Maresias\ \-\ SP",
"55433717", "Londrina\ \-\ PR",
"55543389", "Fontoura\ Xavier\ \-\ RS",
"556232", "Goiânia\ \-\ GO",
"55673041", "Campo\ Grande\ \-\ MS",
"55313864", "Carmésia\ \-\ MG",
"55313561", "Itabirito\ \-\ MG",
"55414113", "Pinhais\ \-\ PR",
"55533255", "Pedro\ Osório\ \-\ RS",
"55115812", "São\ Paulo\ \-\ SP",
"55643534", "Itumbiara\ \-\ GO",
"55753265", "Santaluz\ \-\ BA",
"55813533", "Gravatá\ \-\ PE",
"55833228", "Cabedelo\ \-\ PB",
"55123311", "Aparecida\ \-\ SP",
"551120", "São\ Paulo\ \-\ SP",
"55193924", "Águas\ de\ Lindóia\ \-\ SP",
"5512362", "Taubaté\ \-\ SP",
"55153271", "Itapetininga\ \-\ SP",
"55493804", "Lages\ \-\ SC",
"55633471", "Tocantinópolis\ \-\ TO",
"55114513", "Mauá\ \-\ SP",
"55893553", "Júlio\ Borges\ \-\ PI",
"55623624", "Goiânia\ \-\ GO",
"55443536", "Brasiliana\ \-\ PR",
"55833473", "Desterro\ \-\ PB",
"55733534", "Jaguaquara\ \-\ BA",
"55913711", "Castanhal\ \-\ PA",
"55143032", "Jaú\ \-\ SP",
"55463532", "Quedas\ do\ Iguaçu\ \-\ PR",
"55313408", "Belo\ Horizonte\ \-\ MG",
"5586", "Piauí",
"55173842", "Indiaporã\ \-\ SP",
"55653346", "Nortelândia\ \-\ MT",
"55213761", "Nilópolis\ \-\ RJ",
"55343352", "Uberaba\ \-\ MG",
"55623404", "Assunção\ de\ Goiás\ \-\ GO",
"55823027", "Maceió\ \-\ AL",
"55543297", "Flores\ da\ Cunha\ \-\ RS",
"55173699", "Pontalinda\ \-\ SP",
"55163977", "Ribeirão\ Preto\ \-\ SP",
"55173641", "Santa\ Fé\ do\ Sul\ \-\ SP",
"55983013", "São\ Luís\ \-\ MA",
"55813194", "Recife\ \-\ PE",
"55743537", "Sento\ Sé\ \-\ BA",
"55482108", "Florianópolis\ \-\ SC",
"55313628", "Ribeirão\ das\ Neves\ \-\ MG",
"55192107", "Indaiatuba\ \-\ SP",
"55413629", "Tijucas\ do\ Sul\ \-\ PR",
"55813155", "Gravatá\ \-\ PE",
"55123848", "Ubatuba\ \-\ SP",
"55553332", "Ijuí\ \-\ RS",
"55513128", "Gravataí\ \-\ RS",
"55443460", "Tamboara\ \-\ PR",
"55623575", "Goiânia\ \-\ GO",
"55933549", "Porto\ Trombetas\ \-\ PA",
"55213208", "Rio\ de\ Janeiro\ \-\ RJ",
"55114818", "Terra\ Preta\ \-\ SP",
"55333314", "Ipanema\ \-\ MG",
"55493447", "Ouro\ Verde\ \-\ SC",
"55115611", "São\ Paulo\ \-\ SP",
"55753428", "Pedrão\ \-\ BA",
"55353525", "Delfinópolis\ \-\ MG",
"55453054", "Toledo\ \-\ PR",
"55643632", "Jataí\ \-\ GO",
"55343662", "Araxá\ \-\ MG",
"55143473", "Alvinlândia\ \-\ SP",
"55713221", "Salvador\ \-\ BA",
"55823628", "Monteirópolis\ \-\ AL",
"55543908", "Vacaria\ \-\ RS",
"55513760", "Colinas\ \-\ RS",
"55623456", "Divinópolis\ de\ Goiás\ \-\ GO",
"55473301", "Indaial\ \-\ SC",
"55213665", "Queimados\ \-\ RJ",
"55833032", "Santa\ Rita\ \-\ PB",
"55733632", "Ilhéus\ \-\ BA",
"55843538", "Fernando\ Pedroza\ \-\ RN",
"55873821", "Arcoverde\ \-\ PE",
"55623522", "Goiânia\ \-\ GO",
"55483439", "Criciúma\ \-\ SC",
"55532128", "Pelotas\ \-\ RS",
"55613010", "Brasília\ \-\ DF",
"55373244", "Carmo\ do\ Cajuru\ \-\ MG",
"55115103", "São\ Paulo\ \-\ SP",
"55793611", "Simão\ Dias\ \-\ SE",
"55613415", "Brasília\ \-\ DF",
"55413677", "Campo\ Magro\ \-\ PR",
"55833396", "Aroeiras\ \-\ PB",
"55173512", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55342102", "Uberlândia\ \-\ MG",
"55513616", "Rio\ Grande\ do\ Sul",
"55212713", "São\ Gonçalo\ \-\ RJ",
"5531351", "Minas\ Gerais",
"55863315", "Parnaíba\ \-\ PI",
"55483205", "Florianópolis\ \-\ SC",
"55313116", "Belo\ Horizonte\ \-\ MG",
"55993639", "São\ Mateus\ do\ Maranhão\ \-\ MA",
"55623364", "São\ Miguel\ do\ Araguaia\ \-\ GO",
"55323334", "Santana\ do\ Garambéu\ \-\ MG",
"55663545", "Sorriso\ \-\ MT",
"55623517", "Goiânia\ \-\ GO",
"55214117", "Nova\ Iguaçu\ \-\ RJ",
"55213481", "Rio\ de\ Janeiro\ \-\ RJ",
"55553267", "Ivorá\ \-\ RS",
"55163878", "Ribeirão\ Preto\ \-\ SP",
"55983521", "Caxias\ \-\ MA",
"55733257", "Nilo\ Peçanha\ \-\ BA",
"55313240", "Perpétuo\ Socorro\ \-\ MG",
"55513732", "Rio\ Grande\ do\ Sul",
"55613084", "Luziânia\ \-\ GO",
"55833258", "João\ Pessoa\ \-\ PB",
"55963214", "Macapá\ \-\ AP",
"55483668", "Pinheiral\ \-\ SC",
"55483296", "Biguaçu\ \-\ SC",
"55423656", "Goioxim\ \-\ PR",
"55193667", "Mococa\ \-\ SP",
"55443432", "Nova\ Londrina\ \-\ PR",
"55913744", "Santa\ Isabel\ do\ Pará\ \-\ PA",
"5538", "Minas\ Gerais",
"55693521", "Jaru\ \-\ RO",
"55513480", "Guaíba\ \-\ RS",
"55173579", "Botelho\ \-\ SP",
"55893523", "Floriano\ \-\ PI",
"55453543", "Vila\ Ipiranga\ \-\ PR",
"55843331", "Açu\ \-\ RN",
"55143882", "Botucatu\ \-\ SP",
"55353692", "Itajubá\ \-\ MG",
"55423271", "Telêmaco\ Borba\ \-\ PR",
"55793542", "Cristinápolis\ \-\ SE",
"55112331", "São\ Paulo\ \-\ SP",
"55433398", "Tamarana\ \-\ PR",
"55333513", "Campanário\ \-\ MG",
"55913182", "Belém\ \-\ PA",
"55343322", "Uberaba\ \-\ MG",
"55773470", "Rio\ do\ Antônio\ \-\ BA",
"55483521", "Araranguá\ \-\ SC",
"55733279", "Teolândia\ \-\ BA",
"55443645", "Terra\ Roxa\ \-\ PR",
"55463560", "Pinhal\ de\ São\ Bento\ \-\ PR",
"55893562", "Bom\ Jesus\ \-\ PI",
"55513441", "Cachoeirinha\ \-\ RS",
"55983358", "Penalva\ \-\ MA",
"55623283", "Aparecida\ de\ Goiânia\ \-\ GO",
"55773618", "Cristópolis\ \-\ BA",
"55513499", "Eldorado\ do\ Sul\ \-\ RS",
"55543444", "Serafina\ Corrêa\ \-\ RS",
"55823281", "União\ dos\ Palmares\ \-\ AL",
"55413659", "Tunas\ \-\ PR",
"55123102", "Silveiras\ \-\ SP",
"55163392", "Américo\ Brasiliense\ \-\ SP",
"55333341", "Manhumirim\ \-\ MG",
"55714062", "Salvador\ \-\ BA",
"55143305", "Piraju\ \-\ SP",
"55193312", "Indaiatuba\ \-\ SP",
"55173557", "Sales\ \-\ SP",
"55163728", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55953543", "Iracema\ \-\ RR",
"55433256", "Rolândia\ \-\ PR",
"55114021", "Salto\ \-\ SP",
"55353555", "Guaranésia\ \-\ MG",
"55973461", "Santo\ Antônio\ do\ Içá\ \-\ AM",
"55813687", "Bonito\ \-\ PE",
"55313057", "Belo\ Horizonte\ \-\ MG",
"55483647", "Laguna\ \-\ SC",
"55613338", "Brasília\ \-\ DF",
"55623552", "Guapó\ \-\ GO",
"55873851", "Petrolândia\ \-\ PE",
"5511566", "São\ Paulo\ \-\ SP",
"55543535", "Caxias\ do\ Sul\ \-\ RS",
"55653026", "Várzea\ Grande\ \-\ MT",
"55713676", "Mata\ de\ São\ João\ \-\ BA",
"55793644", "Lagarto\ \-\ SE",
"55733212", "Itabuna\ \-\ BA",
"55943432", "Floresta\ do\ Araguaia\ \-\ PA",
"55343284", "Araporã\ \-\ MG",
"55673901", "Campo\ Grande\ \-\ MS",
"5519344", "Limeira\ \-\ SP",
"55893467", "Lagoa\ do\ Sítio\ \-\ PI",
"55183282", "Teodoro\ Sampaio\ \-\ SP",
"55753344", "Palmeiras\ \-\ BA",
"55923028", "Manaus\ \-\ AM",
"55714113", "Lauro\ de\ Freitas\ \-\ BA",
"55193808", "Amparo\ \-\ SP",
"55114278", "Santa\ Isabel\ \-\ SP",
"55373373", "Capitólio\ \-\ MG",
"55493446", "Lindóia\ do\ Sul\ \-\ SC",
"55163976", "Ribeirão\ Preto\ \-\ SP",
"55543296", "Nova\ Pádua\ \-\ RS",
"55513675", "Cerro\ Grande\ do\ Sul\ \-\ RS",
"55163243", "Monte\ Alto\ \-\ SP",
"55423232", "Castro\ \-\ PR",
"55743536", "Casa\ Nova\ \-\ BA",
"55843372", "Severiano\ Melo\ \-\ RN",
"55243076", "Volta\ Redonda\ \-\ RJ",
"55192106", "Piracicaba\ \-\ SP",
"55433534", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55653057", "Cuiabá\ \-\ MT",
"55943382", "Sapucaia\ \-\ PA",
"5531345", "Belo\ Horizonte\ \-\ MG",
"55733549", "Manoel\ Vitorino\ \-\ BA",
"55193464", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55883613", "Sobral\ \-\ CE",
"55132105", "Santos\ \-\ SP",
"55513043", "Gravataí\ \-\ RS",
"55683611", "Manoel\ Urbano\ \-\ AC",
"55473643", "Mafra\ \-\ SC",
"55613488", "Brasília\ \-\ DF",
"55614003", "Brasília\ \-\ DF",
"55843325", "Upanema\ \-\ RN",
"55673418", "Itaum\ \-\ MS",
"55643591", "Itumbiara\ \-\ GO",
"55133481", "Praia\ Grande\ \-\ SP",
"55543358", "Lagoa\ Vermelha\ \-\ RS",
"55513622", "Arroio\ Teixeira\ \-\ RS",
"55183324", "Assis\ \-\ SP",
"55623457", "Monte\ Alegre\ de\ Goiás\ \-\ GO",
"55693535", "Ariquemes\ \-\ RO",
"55513771", "Rio\ Grande\ do\ Sul",
"5571348", "Salvador\ \-\ BA",
"55313026", "Sete\ Lagoas\ \-\ MG",
"55123141", "Cruzeiro\ \-\ SP",
"55483535", "Jacinto\ Machado\ \-\ SC",
"55513663", "Osório\ \-\ RS",
"55243334", "Rio\ Claro\ \-\ RJ",
"55513402", "Guaíba\ \-\ RS",
"55933534", "Prainha\ \-\ PA",
"55133372", "Cubatão\ \-\ SP",
"55893448", "Bocaina\ \-\ PI",
"55323015", "Juiz\ de\ Fora\ \-\ MG",
"55193326", "Campinas\ \-\ SP",
"55793272", "Japaratuba\ \-\ SE",
"55513237", "Rio\ Grande\ do\ Sul",
"55423028", "Ponta\ Grossa\ \-\ PR",
"55112319", "São\ Paulo\ \-\ SP",
"55173291", "Riolândia\ \-\ SP",
"55222102", "Nova\ Friburgo\ \-\ RJ",
"55453273", "Toledo\ \-\ PR",
"55173249", "Potirendaba\ \-\ SP",
"55813131", "Recife\ \-\ PE",
"55623412", "Goiânia\ \-\ GO",
"55114462", "Santo\ André\ \-\ SP",
"55443537", "Engenheiro\ Beltrão\ \-\ PR",
"55193503", "Hortolândia\ \-\ SP",
"55134004", "Santos\ \-\ SP",
"55114603", "Bragança\ Paulista\ \-\ SP",
"55213820", "Rio\ de\ Janeiro\ \-\ RJ",
"55114035", "Bragança\ Paulista\ \-\ SP",
"55673269", "Guia\ Lopes\ da\ Laguna\ \-\ MS",
"55653347", "Assari\ \-\ MT",
"55473238", "Blumenau\ \-\ SC",
"55313570", "Minas\ Gerais",
"55242258", "Bemposta\ \-\ RJ",
"55793447", "Frei\ Paulo\ \-\ SE",
"55182104", "Presidente\ Prudente\ \-\ SP",
"55853364", "Umirim\ \-\ CE",
"55813015", "Recife\ \-\ PE",
"55513524", "Novo\ Hamburgo\ \-\ RS",
"55923367", "Iranduba\ \-\ AM",
"55173475", "Meridiano\ \-\ SP",
"55753311", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55993644", "Lago\ da\ Pedra\ \-\ MA",
"55373405", "Arcos\ \-\ MG",
"55743065", "Juazeiro\ \-\ BA",
"55913087", "Belém\ \-\ PA",
"55833289", "Juripiranga\ \-\ PB",
"55163171", "Pedregulho\ \-\ SP",
"55312111", "Belo\ Horizonte\ \-\ MG",
"55633432", "Bandeirantes\ do\ Tocantins\ \-\ TO",
"55773461", "Bom\ Jesus\ da\ Serra\ \-\ BA",
"55493542", "Erval\ Velho\ \-\ SC",
"55813678", "Rio\ Formoso\ \-\ PE",
"55183786", "Sud\ Mennucci\ \-\ SP",
"55693411", "Ji\-Paraná\ \-\ RO",
"55313939", "Conselheiro\ Lafaiete\ \-\ MG",
"55513362", "Rio\ Grande\ do\ Sul",
"55353242", "Turvolândia\ \-\ MG",
"55853404", "Fortaleza\ \-\ CE",
"55553730", "Vista\ Alegre\ \-\ RS",
"55473156", "Braço\ do\ Baú\ \-\ SC",
"55913739", "Paragominas\ \-\ PA",
"55313152", "Sete\ Lagoas\ \-\ MG",
"55173801", "Riolândia\ \-\ SP",
"55683231", "Bujari\ \-\ AC",
"5531342", "Minas\ Gerais",
"55533611", "Portão\ \-\ RS",
"55653027", "Cuiabá\ \-\ MT",
"55843394", "Frutuoso\ Gomes\ \-\ RN",
"55443683", "Doutor\ Oliveira\ Castro\ \-\ PR",
"55613393", "Santa\ Maria\ \-\ DF",
"55713677", "Mata\ de\ São\ João\ \-\ BA",
"55553753", "São\ José\ das\ MissõEs\ \-\ RS",
"55613525", "Brasília\ \-\ DF",
"55433660", "Lupionópolis\ \-\ PR",
"55173422", "Votuporanga\ \-\ SP",
"55883667", "Itarema\ \-\ CE",
"55173556", "Irapuã\ \-\ SP",
"55843355", "Venha\-Ver\ \-\ RN",
"55433257", "Pitangueiras\ \-\ PR",
"55123608", "Taubaté\ \-\ SP",
"55273048", "Linhares\ \-\ ES",
"55114302", "São\ Paulo\ \-\ SP",
"55242465", "Mendes\ \-\ RJ",
"55813686", "Belém\ de\ Maria\ \-\ PE",
"55222543", "Nova\ Friburgo\ \-\ RJ",
"55483646", "Laguna\ \-\ SC",
"55473052", "Indaial\ \-\ SC",
"55513652", "Butiá\ \-\ RS",
"55183354", "Platina\ \-\ SP",
"55843673", "Natal\ \-\ RN",
"55153313", "Sorocaba\ \-\ SP",
"55993542", "Balsas\ \-\ MA",
"55643671", "São\ Luís\ de\ Montes\ Belos\ \-\ GO",
"55623516", "Goianira\ \-\ GO",
"55543439", "Faria\ Lemos\ \-\ RS",
"55553266", "Nova\ Palma\ \-\ RS",
"55223861", "Itaocara\ \-\ RJ",
"55733256", "Ituberá\ \-\ BA",
"55623607", "Goiânia\ \-\ GO",
"55753024", "Feira\ de\ Santana\ \-\ BA",
"55114144", "Itapevi\ \-\ SP",
"55443254", "Atalaia\ \-\ PR",
"55413676", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55493644", "Dionísio\ Cerqueira\ \-\ SC",
"55114916", "São\ Paulo\ \-\ SP",
"55833397", "Natuba\ \-\ PB",
"55193907", "Amparo\ \-\ SP",
"55353834", "Aguanil\ \-\ MG",
"55173463", "Fernandópolis\ \-\ SP",
"55733671", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55513617", "Rio\ Grande\ do\ Sul",
"55273296", "Aracruz\ \-\ ES",
"55823346", "Maceió\ \-\ AL",
"55713369", "Lauro\ de\ Freitas\ \-\ BA",
"5511367", "São\ Paulo\ \-\ SP",
"55673443", "Batayporã\ \-\ MS",
"55483411", "Criciúma\ \-\ SC",
"55743645", "Campo\ Formoso\ \-\ BA",
"55733204", "Itaju\ do\ Colônia\ \-\ BA",
"55513595", "Novo\ Hamburgo\ \-\ RS",
"55213833", "Rio\ de\ Janeiro\ \-\ RJ",
"55833290", "Conde\ \-\ PB",
"55313738", "São\ Brás\ do\ Suaçuí\ \-\ MG",
"55353531", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55213850", "Rio\ de\ Janeiro\ \-\ RJ",
"55333423", "Sabinópolis\ \-\ MG",
"55683542", "Xapuri\ \-\ AC",
"55663583", "Vera\ \-\ MT",
"55473342", "Navegantes\ \-\ SC",
"55242228", "Secretário\ \-\ RJ",
"55414062", "Curitiba\ \-\ PR",
"55423657", "Palmital\ \-\ PR",
"55313346", "Belo\ Horizonte\ \-\ MG",
"55133208", "Santos\ \-\ SP",
"55793255", "Aracaju\ \-\ SE",
"55513018", "Porto\ Alegre\ \-\ RS",
"55513554", "São\ Leopoldo\ \-\ RS",
"55114566", "Mogi\ das\ Cruzes\ \-\ SP",
"55542108", "Caxias\ do\ Sul\ \-\ RS",
"55873835", "Pesqueira\ \-\ PE",
"55883648", "Uruoca\ \-\ CE",
"55543551", "Machadinho\ \-\ RS",
"558532", "Fortaleza\ \-\ CE",
"55193304", "Campinas\ \-\ SP",
"55133302", "Praia\ Grande\ \-\ SP",
"55513472", "Canoas\ \-\ RS",
"55314111", "Belo\ Horizonte\ \-\ MG",
"55163379", "Fazenda\ Babilônia\ \-\ SP",
"55492020", "Chapecó\ \-\ SC",
"55543038", "Garibaldi\ \-\ RS",
"55854062", "Fortaleza\ \-\ CE",
"55483434", "Morro\ da\ Fumaça\ \-\ SC",
"555138", "Rio\ Grande\ do\ Sul",
"55273726", "Pancas\ \-\ ES",
"55933062", "Santarém\ \-\ PA",
"55653337", "Diamantino\ \-\ MT",
"55373249", "Itaúna\ \-\ MG",
"5524336", "Angra\ dos\ Reis\ \-\ RJ",
"554132", "Curitiba\ \-\ PR",
"55733292", "Teixeira\ de\ Freitas\ \-\ BA",
"55423459", "Fernandes\ Pinheiro\ \-\ PR",
"55173694", "Dirce\ Reis\ \-\ SP",
"55613626", "Santo\ Antônio\ do\ Descoberto\ \-\ GO",
"55333325", "Imbé\ de\ Minas\ \-\ MG",
"55213513", "Rio\ de\ Janeiro\ \-\ RJ",
"55513425", "Canoas\ \-\ RS",
"55193573", "Leme\ \-\ SP",
"55443621", "Umuarama\ \-\ PR",
"55773698", "Ibotirama\ \-\ BA",
"55143316", "Marília\ \-\ SP",
"55413624", "Agudos\ do\ Sul\ \-\ PR",
"55382104", "Montes\ Claros\ \-\ MG",
"55123131", "São\ José\ dos\ Campos\ \-\ SP",
"55913456", "Benfica\ \-\ PA",
"55183581", "Flórida\ Paulista\ \-\ SP",
"55693216", "Porto\ Velho\ \-\ RO",
"55933544", "Oriximiná\ \-\ PA",
"55893438", "São\ Julião\ \-\ PI",
"55643539", "Itumbiara\ \-\ GO",
"55443401", "Cianorte\ \-\ PR",
"55193878", "Louveira\ \-\ SP",
"55433062", "Cambé\ \-\ PR",
"55483877", "Florianópolis\ \-\ SC",
"55483216", "Florianópolis\ \-\ SC",
"55413404", "Curitiba\ \-\ PR",
"55213818", "Rio\ de\ Janeiro\ \-\ RJ",
"55353736", "Cabo\ Verde\ \-\ MG",
"55923198", "Manaus\ \-\ AM",
"55313713", "Capim\ Branco\ \-\ MG",
"55113175", "São\ Paulo\ \-\ SP",
"55193929", "Valinhos\ \-\ SP",
"55433435", "Manoel\ Ribas\ \-\ PR",
"559132", "Belém\ \-\ PA",
"55733539", "Itagi\ \-\ BA",
"55683214", "Rio\ Branco\ \-\ AC",
"55533241", "Bagé\ \-\ RS",
"55114761", "Mogi\ das\ Cruzes\ \-\ SP",
"55473633", "São\ Bento\ do\ Sul\ \-\ SC",
"55343972", "Uberaba\ \-\ MG",
"55513033", "Esteio\ \-\ RS",
"55163357", "Araraquara\ \-\ SP",
"55443568", "Mamborê\ \-\ PR",
"55513605", "Torres\ \-\ RS",
"55413575", "Curitiba\ \-\ PR",
"55113122", "São\ Paulo\ \-\ SP",
"55123893", "São\ Sebastião\ \-\ SP",
"55833316", "Riachão\ do\ Bacamarte\ \-\ PB",
"5511345", "São\ Paulo\ \-\ SP",
"55513696", "Barão\ \-\ RS",
"55433544", "Santa\ Amélia\ \-\ PR",
"55163995", "Ribeirão\ Preto\ \-\ SP",
"55693434", "Santa\ Luzia\ D\'Oeste\ \-\ RO",
"55743546", "Itiúba\ \-\ BA",
"55543275", "Nova\ Araçá\ \-\ RS",
"55663521", "Alta\ Floresta\ \-\ MT",
"55413456", "Matinhos\ \-\ PR",
"5531359", "Betim\ \-\ MG",
"55423242", "Ipiranga\ \-\ PR",
"55193886", "Vinhedo\ \-\ SP",
"55753334", "Lençóis\ \-\ BA",
"55513701", "Rio\ Grande\ do\ Sul",
"55923531", "Barreirinha\ \-\ AM",
"55473360", "Balneário\ Camboriú\ \-\ SC",
"55713412", "Salvador\ \-\ BA",
"55112885", "Guarulhos\ \-\ SP",
"5519343", "Piracicaba\ \-\ SP",
"55114665", "Embu\-Guaçu\ \-\ SP",
"55623597", "Goiânia\ \-\ GO",
"55163954", "Santa\ Rosa\ de\ Viterbo\ \-\ SP",
"55543384", "Barros\ Cassal\ \-\ RS",
"55193565", "Pirassununga\ \-\ SP",
"55493436", "Faxinal\ dos\ Guedes\ \-\ SC",
"55313869", "Congonhas\ do\ Norte\ \-\ MG",
"55983181", "São\ Luís\ \-\ MA",
"55613454", "Sobradinho\ \-\ DF",
"55513381", "Rio\ Grande\ do\ Sul",
"55163667", "Cajuru\ \-\ SP",
"55113117", "São\ Paulo\ \-\ SP",
"55443288", "Sarandi\ \-\ PR",
"55114481", "Bragança\ Paulista\ \-\ SP",
"55743259", "Macajuba\ \-\ BA",
"55613366", "Brasília\ \-\ DF",
"55453029", "Foz\ do\ Iguaçu\ \-\ PR",
"55313336", "Minas\ Gerais",
"55473332", "Gaspar\ \-\ SC",
"55623086", "Goiânia\ \-\ GO",
"55273222", "Vitória\ \-\ ES",
"55883638", "Hidrolândia\ \-\ CE",
"55873845", "Calumbi\ \-\ PE",
"55463225", "Pato\ Branco\ \-\ PR",
"55643601", "São\ Luís\ de\ Montes\ Belos\ \-\ GO",
"55153459", "Iperó\ \-\ SP",
"55413517", "São\ José\ dos\ Pinhais\ \-\ PR",
"55273756", "Barra\ de\ São\ Francisco\ \-\ ES",
"55743635", "Tapiramutá\ \-\ BA",
"55162107", "São\ Carlos\ \-\ SP",
"55323273", "Matias\ Barbosa\ \-\ MG",
"55673433", "Ponta\ Porã\ \-\ MS",
"55443361", "Umuarama\ \-\ PR",
"55194002", "Campinas\ \-\ SP",
"55383562", "Brasilândia\ de\ Minas\ \-\ MG",
"55213917", "Maricá\ \-\ RJ",
"55413606", "Colombo\ \-\ PR",
"55453015", "Cascavel\ \-\ PR",
"55353541", "Cássia\ \-\ MG",
"5531367", "Sabará\ \-\ MG",
"55193977", "Artur\ Nogueira\ \-\ SP",
"55663328", "Planalto\ da\ Serra\ \-\ MT",
"55333355", "Iapu\ \-\ MG",
"55353844", "Ibituruna\ \-\ MG",
"55463272", "Pato\ Branco\ \-\ PR",
"55493634", "Iporã\ do\ Oeste\ \-\ SC",
"55273275", "Aracruz\ \-\ ES",
"55153531", "Itararé\ \-\ SP",
"55513455", "Rio\ Grande\ do\ Sul",
"55823336", "Maceió\ \-\ AL",
"55493241", "Curitibanos\ \-\ SC",
"55813114", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55653223", "Cáceres\ \-\ MT",
"55443276", "Maringá\ \-\ PR",
"55733274", "Vera\ Cruz\ \-\ BA",
"55543449", "Bento\ Gonçalves\ \-\ RS",
"55193374", "Piracicaba\ \-\ SP",
"55513494", "Itapuã\ \-\ RS",
"55553781", "Santo\ Augusto\ \-\ RS",
"55513588", "São\ Leopoldo\ \-\ RS",
"55613271", "Belo\ Horizonte\ \-\ MG",
"55114134", "Barueri\ \-\ SP",
"55553301", "Santa\ Maria\ \-\ RS",
"55133278", "Santos\ \-\ SP",
"55813273", "Recife\ \-\ PE",
"55115691", "São\ Paulo\ \-\ SP",
"55323265", "Descoberto\ \-\ MG",
"55213139", "Rio\ de\ Janeiro\ \-\ RJ",
"55843286", "Passagem\ \-\ RN",
"55163101", "Ribeirão\ Preto\ \-\ SP",
"55863282", "Água\ Branca\ \-\ PI",
"5511597", "São\ Paulo\ \-\ SP",
"55173405", "Votuporanga\ \-\ SP",
"55923084", "Manaus\ \-\ AM",
"55613502", "Luziânia\ \-\ GO",
"55913606", "Bagre\ \-\ PA",
"55222533", "Nova\ Friburgo\ \-\ RJ",
"55114593", "Itupeva\ \-\ SP",
"55454001", "Cascavel\ \-\ PR",
"55313767", "Minas\ Gerais",
"55123686", "Taubaté\ \-\ SP",
"55663439", "Rondonópolis\ \-\ MT",
"55413283", "São\ José\ dos\ Pinhais\ \-\ PR",
"55313074", "Belo\ Horizonte\ \-\ MG",
"55813339", "Recife\ \-\ PE",
"55513883", "Montenegro\ \-\ RS",
"55343071", "Uberaba\ \-\ MG",
"55183376", "Cruzália\ \-\ SP",
"55673025", "Campo\ Grande\ \-\ MS",
"55493532", "Tangará\ \-\ SC",
"55633442", "Ananás\ \-\ TO",
"55383523", "Felício\ dos\ Santos\ \-\ MG",
"55153242", "Votorantim\ \-\ SP",
"55113152", "São\ Paulo\ \-\ SP",
"55183261", "Ribeirão\ dos\ Índios\ \-\ SP",
"5589", "Piauí",
"55813265", "Recife\ \-\ PE",
"55843278", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55663551", "Nova\ Canaã\ do\ Norte\ \-\ MT",
"55733421", "Porto\ Seguro\ \-\ BA",
"55184104", "Birigui\ \-\ SP",
"55433511", "Jacarezinho\ \-\ PR",
"55433343", "Londrina\ \-\ PR",
"55993634", "Lago\ do\ Junco\ \-\ MA",
"55323339", "Barbacena\ \-\ MG",
"55273263", "Santa\ Maria\ de\ Jetibá\ \-\ ES",
"5511471", "São\ Roque\ \-\ SP",
"55413552", "Araucária\ \-\ PR",
"55843423", "Jardim\ de\ Piranhas\ \-\ RN",
"55123678", "Natividade\ da\ Serra\ \-\ SP",
"55183708", "Primeira\ Aliança\ \-\ SP",
"55143733", "Avaré\ \-\ SP",
"55483093", "Palhoça\ \-\ SC",
"55193888", "Paulínia\ \-\ SP",
"55623550", "Aragoiânia\ \-\ GO",
"55513698", "Capela\ de\ Santana\ \-\ RS",
"55453251", "Ouro\ Verde\ do\ Oeste\ \-\ PR",
"55513266", "Rio\ Grande\ do\ Sul",
"55743548", "Pindobaçu\ \-\ BA",
"55163411", "São\ Carlos\ \-\ SP",
"55214133", "Magé\ \-\ RJ",
"55473098", "Itapema\ \-\ SC",
"55833642", "Santa\ Cecília\ \-\ PB",
"55623533", "Goiânia\ \-\ GO",
"55823531", "Batalha\ \-\ AL",
"55873983", "Petrolina\ \-\ PE",
"55123221", "Caçapava\ \-\ SP",
"55733623", "Firmino\ Alves\ \-\ BA",
"55153336", "Sorocaba\ \-\ SP",
"5584331", "Mossoró\ \-\ RN",
"55113599", "Osasco\ \-\ SP",
"55493438", "Ipumirim\ \-\ SC",
"55553617", "Tiradentes\ do\ Sul\ \-\ RS",
"55114295", "Suzano\ \-\ SP",
"55112822", "Osasco\ \-\ SP",
"55313834", "Itabira\ \-\ MG",
"55553506", "São\ Francisco\ de\ Assis\ \-\ RS",
"55413585", "Curitiba\ \-\ PR",
"55313459", "Minas\ Gerais",
"55813624", "Surubim\ \-\ PE",
"55643623", "Rio\ Verde\ \-\ GO",
"55343831", "Patrocínio\ \-\ MG",
"55883545", "Santana\ do\ Cariri\ \-\ CE",
"55813563", "Gravatá\ \-\ PE",
"55643564", "Anicuns\ \-\ GO",
"55753235", "Candeal\ \-\ BA",
"55313531", "Betim\ \-\ MG",
"55613561", "Taguatinga\ \-\ DF",
"55513097", "Novo\ Hamburgo\ \-\ RS",
"55983469", "Urbano\ Santos\ \-\ MA",
"55543285", "Picada\ Café\ \-\ RS",
"55213816", "Rio\ de\ Janeiro\ \-\ RJ",
"55553595", "Tuparendi\ \-\ RS",
"55143841", "São\ Manuel\ \-\ SP",
"55114206", "Jandira\ \-\ SP",
"55193876", "Vinhedo\ \-\ SP",
"55443566", "Juranda\ \-\ PR",
"55753659", "Salinas\ da\ Margarida\ \-\ BA",
"5571340", "Salvador\ \-\ BA",
"55773472", "Maetinga\ \-\ BA",
"55553554", "Miraguaí\ \-\ RS",
"55133822", "Registro\ \-\ SP",
"55613408", "Brasília\ \-\ DF",
"55883434", "Ererê\ \-\ CE",
"55353346", "Cruzília\ \-\ MG",
"55454062", "Cascavel\ \-\ PR",
"55543374", "Ibiaçá\ \-\ RS",
"55193491", "Capivari\ \-\ SP",
"55893560", "Francisco\ Ayres\ \-\ PI",
"5553", "Rio\ Grande\ do\ Sul",
"55463562", "Manfrinópolis\ \-\ PR",
"55513482", "Barra\ do\ Ribeiro\ \-\ RS",
"55112547", "São\ Paulo\ \-\ SP",
"55833544", "Marizópolis\ \-\ PB",
"55463523", "Francisco\ Beltrão\ \-\ PR",
"55213731", "Maricá\ \-\ RJ",
"55634009", "Palmas\ \-\ TO",
"5513331", "Bertioga\ \-\ SP",
"55143880", "Botucatu\ \-\ SP",
"55613628", "Novo\ Gama\ \-\ GO",
"55163389", "São\ Lourenço\ do\ Turvo\ \-\ SP",
"55433316", "Arapongas\ \-\ PR",
"55173264", "Bálsamo\ \-\ SP",
"55353690", "Varginha\ \-\ MG",
"55693218", "Porto\ Velho\ \-\ RO",
"55893436", "Alegrete\ do\ Piauí\ \-\ PI",
"55143642", "Barra\ Bonita\ \-\ SP",
"55112719", "São\ Paulo\ \-\ SP",
"55553362", "Dezesseis\ de\ Novembro\ \-\ RS",
"55373351", "Arcos\ \-\ MG",
"55443453", "Santa\ Isabel\ do\ Ivaí\ \-\ PR",
"55143318", "Marília\ \-\ SP",
"55813522", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55513945", "Gravataí\ \-\ RS",
"55323575", "Guarani\ \-\ MG",
"55543036", "Gramado\ \-\ RS",
"55112772", "São\ Paulo\ \-\ SP",
"55112621", "São\ Paulo\ \-\ SP",
"55493329", "Chapecó\ \-\ SC",
"55114683", "Juquitiba\ \-\ SP",
"55833435", "Jericó\ \-\ PB",
"55552103", "Santa\ Maria\ \-\ RS",
"55643662", "Palestina\ de\ Goiás\ \-\ GO",
"55212656", "São\ João\ de\ Meriti\ \-\ RJ",
"55753677", "Valença\ \-\ BA",
"55513753", "Roca\ Sales\ \-\ RS",
"55613027", "Taguatinga\ \-\ DF",
"5535342", "Pouso\ Alegre\ \-\ MG",
"55513730", "Passo\ do\ Sobrado\ \-\ RS",
"55193583", "Descalvado\ \-\ SP",
"55313242", "Minas\ Gerais",
"55964400", "Macapá\ \-\ AP",
"55483469", "Treviso\ \-\ SC",
"55733662", "Jucuruçu\ \-\ BA",
"55753182", "Alagoinhas\ \-\ BA",
"55273728", "Vila\ Valério\ \-\ ES",
"55183571", "Flórida\ Paulista\ \-\ SP",
"55983218", "São\ Luís\ \-\ MA",
"55443302", "Maringá\ \-\ PR",
"55773494", "Tremedal\ \-\ BA",
"55483037", "Florianópolis\ \-\ SC",
"55833209", "João\ Pessoa\ \-\ PB",
"55323749", "Faria\ Lemos\ \-\ MG",
"55623520", "Goiânia\ \-\ GO",
"55713054", "Camaçari\ \-\ BA",
"55843276", "Monte\ Alegre\ \-\ RN",
"55553402", "Uruguaiana\ \-\ RS",
"55613012", "Brasília\ \-\ DF",
"55963324", "Itaubal\ \-\ AP",
"55183649", "Birigui\ \-\ SP",
"55183691", "Buritama\ \-\ SP",
"55343257", "Uberlândia\ \-\ MG",
"55134010", "Santos\ \-\ SP",
"55642102", "Jataí\ \-\ GO",
"55143343", "Canitar\ \-\ SP",
"55643999", "Itumbiara\ \-\ GO",
"55543392", "Lagoa\ dos\ Três\ Cantos\ \-\ RS",
"55643941", "Itumbiara\ \-\ GO",
"55623334", "Petrolina\ de\ Goiás\ \-\ GO",
"55323364", "Paiva\ \-\ MG",
"55123676", "Redenção\ da\ Serra\ \-\ SP",
"55183706", "Suzanápolis\ \-\ SP",
"55113367", "São\ Paulo\ \-\ SP",
"55913265", "Ananindeua\ \-\ PA",
"55113514", "São\ Paulo\ \-\ SP",
"5599", "Maranhão",
"55813654", "Salgadinho\ \-\ PE",
"55643653", "Gouvelândia\ \-\ GO",
"55513762", "Rio\ Grande\ do\ Sul",
"55313084", "Belo\ Horizonte\ \-\ MG",
"55773455", "Caculé\ \-\ BA",
"55372101", "Divinópolis\ \-\ MG",
"55553237", "São\ Gabriel\ \-\ RS",
"55732102", "Itabuna\ \-\ BA",
"55843288", "Passa\ e\ Fica\ \-\ RN",
"55443462", "Querência\ do\ Norte\ \-\ PR",
"55143814", "Botucatu\ \-\ SP",
"55553353", "Guarani\ das\ Missões\ \-\ RS",
"55383255", "Botumirim\ \-\ MG",
"55114537", "Jundiaí\ \-\ SP",
"55133852", "Ariri\ \-\ SP",
"55553524", "Crissiumal\ \-\ RS",
"55114702", "Cotia\ \-\ SP",
"55115034", "São\ Paulo\ \-\ SP",
"55273132", "Vitória\ \-\ ES",
"5568", "Acre",
"55963282", "Santana\ \-\ AP",
"55753629", "Conceição\ do\ Almeida\ \-\ BA",
"55863219", "Teresina\ \-\ PI",
"55343333", "Uberaba\ \-\ MG",
"55673509", "Três\ Lagoas\ \-\ MS",
"55623937", "Anápolis\ \-\ GO",
"55653692", "Várzea\ Grande\ \-\ MT",
"55813517", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55843361", "Patu\ \-\ RN",
"55113964", "Jundiaí\ \-\ SP",
"55443278", "Ourizona\ \-\ PR",
"55463553", "Espigão\ Alto\ do\ Iguaçu\ \-\ PR",
"55833511", "Patos\ \-\ PB",
"55514", "Rio\ Grande\ do\ Sul",
"55823338", "Maceió\ \-\ AL",
"55454053", "Foz\ do\ Iguaçu\ \-\ PR",
"55893532", "Pajeú\ do\ Piauí\ \-\ PI",
"5549", "Santa\ Catarina",
"55242292", "Petrópolis\ \-\ RJ",
"55443423", "Paranavaí\ \-\ PR",
"55373321", "Formiga\ \-\ MG",
"55323283", "Rio\ Preto\ \-\ MG",
"55114169", "Carapicuíba\ \-\ SP",
"55833343", "Campina\ Grande\ \-\ PB",
"55513586", "Rio\ Grande\ do\ Sul",
"55274002", "Vitória\ \-\ ES",
"55813552", "Ipojuca\ \-\ PE",
"55633399", "Sucupira\ \-\ TO",
"55513723", "Cachoeira\ do\ Sul\ \-\ RS",
"55623088", "Goiânia\ \-\ GO",
"55112651", "São\ Paulo\ \-\ SP",
"55114805", "Jundiaí\ \-\ SP",
"55883636", "Amontada\ \-\ CE",
"55323426", "Miraí\ \-\ MG",
"55484107", "Palhoça\ \-\ SC",
"55973431", "São\ Paulo\ de\ Olivença\ \-\ AM",
"55333295", "Virgolândia\ \-\ MG",
"55343212", "Uberlândia\ \-\ MG",
"55733284", "Canavieiras\ \-\ BA",
"55613368", "Brasília\ \-\ DF",
"55313338", "Nova\ Lima\ \-\ MG",
"55333254", "Perpétuo\ Socorro\ \-\ MG",
"55313746", "Piranga\ \-\ MG",
"55793261", "São\ Cristóvão\ \-\ SE",
"55223717", "Macaé\ \-\ RJ",
"5575348", "Feira\ de\ Santana\ \-\ BA",
"55193384", "Campinas\ \-\ SP",
"55413608", "Fazenda\ Rio\ Grande\ \-\ PR",
"55193704", "Limeira\ \-\ SP",
"55663503", "Brianorte\ \-\ MT",
"55483243", "Biguaçu\ \-\ SC",
"55273758", "Mantenópolis\ \-\ ES",
"55213229", "Rio\ de\ Janeiro\ \-\ RJ",
"55654003", "Cuiabá\ \-\ MT",
"55193792", "Limeira\ \-\ SP",
"55734102", "Ilhéus\ \-\ BA",
"55913015", "Belém\ \-\ PA",
"55114852", "Santo\ André\ \-\ SP",
"55374101", "Itaúna\ \-\ MG",
"55133382", "Guarujá\ \-\ SP",
"55673234", "Corumbá\ \-\ MS",
"5551341", "Rio\ Grande\ do\ Sul",
"55333621", "Nanuque\ \-\ MG",
"55773622", "Angical\ \-\ BA",
"5517323", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55833445", "Paulista\ \-\ PB",
"55273326", "Vila\ Velha\ \-\ ES",
"55853339", "Palmácia\ \-\ CE",
"55543046", "Passo\ Fundo\ \-\ RS",
"55913484", "Santarém\ Novo\ \-\ PA",
"55613262", "Brasília\ \-\ DF",
"55313232", "Minas\ Gerais",
"55453283", "Margarida\ \-\ PR",
"55343318", "Uberaba\ \-\ MG",
"55443593", "Jota\ Esse\ \-\ PR",
"55513740", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55283524", "Vargem\ Grande\ do\ Soturno\ \-\ ES",
"55473236", "Blumenau\ \-\ SC",
"55414001", "Curitiba\ \-\ PR",
"55423122", "Ponta\ Grossa\ \-\ PR",
"55843471", "Parelhas\ \-\ RN",
"55333725", "Salto\ da\ Divisa\ \-\ MG",
"55913131", "Belém\ \-\ PA",
"55813474", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55893446", "Itainópolis\ \-\ PI",
"55143632", "Dois\ Córregos\ \-\ SP",
"55183856", "Nova\ Guataporanga\ \-\ SP",
"55713533", "Salvador\ \-\ BA",
"55443440", "Inajá\ \-\ PR",
"5563322", "Palmas\ \-\ TO",
"55212768", "Nova\ Iguaçu\ \-\ RJ",
"55473903", "Joinville\ \-\ SC",
"55823232", "Maceió\ \-\ AL",
"55123522", "Pindamonhangaba\ \-\ SP",
"55833534", "Uiraúna\ \-\ PB",
"55173661", "Rubinéia\ \-\ SP",
"55133224", "Santos\ \-\ SP",
"5516337", "São\ Carlos\ \-\ SP",
"55793530", "Estância\ \-\ SE",
"55512121", "Porto\ Alegre\ \-\ RS",
"55193328", "Indaiatuba\ \-\ SP",
"55423026", "Ponta\ Grossa\ \-\ PR",
"55183272", "Presidente\ Venceslau\ \-\ SP",
"55373383", "Carmo\ da\ Mata\ \-\ MG",
"55193439", "Saltinho\ \-\ SP",
"55112896", "Santo\ André\ \-\ SP",
"55653366", "Nova\ Mutum\ \-\ MT",
"55883444", "Quixeramobim\ \-\ CE",
"55143227", "Bauru\ \-\ SP",
"55114755", "Itaquaquecetuba\ \-\ SP",
"55313599", "Ibirité\ \-\ MG",
"55213780", "Duque\ de\ Caxias\ \-\ RJ",
"55943319", "Santa\ Maria\ das\ Barreiras\ \-\ PA",
"55313541", "Nova\ Lima\ \-\ MG",
"55222734", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55193895", "Socorro\ \-\ SP",
"55513685", "Capivari\ do\ Sul\ \-\ RS",
"55753245", "Santo\ Estêvão\ \-\ BA",
"55963261", "Macapá\ \-\ AP",
"55163986", "Luís\ Antônio\ \-\ SP",
"55673416", "Dourados\ \-\ MS",
"55543356", "Barracão\ \-\ RS",
"55113198", "São\ Paulo\ \-\ SP",
"55753427", "Esplanada\ \-\ BA",
"55613486", "Brasília\ \-\ DF",
"55712136", "Salvador\ \-\ BA",
"55843382", "Luís\ Gomes\ \-\ RN",
"55512", "Rio\ Grande\ do\ Sul",
"55114817", "Jundiaí\ \-\ SP",
"55493448", "Arabutã\ \-\ SC",
"55434007", "Londrina\ \-\ PR",
"55212747", "Tanguá\ \-\ RJ",
"55843224", "Natal\ \-\ RN",
"55633538", "Aparecida\ do\ Rio\ Negro\ \-\ TO",
"55213207", "Rio\ de\ Janeiro\ \-\ RJ",
"55193806", "Mogi\ Mirim\ \-\ SP",
"55343841", "Coromandel\ \-\ MG",
"55883535", "Assaré\ \-\ CE",
"55513127", "Gravataí\ \-\ RS",
"55313844", "Cava\ Grande\ \-\ MG",
"55953552", "Bonfim\ \-\ RR",
"55193551", "Araras\ \-\ SP",
"55743538", "Sobradinho\ \-\ BA",
"55643465", "Urutaí\ \-\ GO",
"55482107", "Florianópolis\ \-\ SC",
"55313627", "Ribeirão\ das\ Neves\ \-\ MG",
"55613478", "Sobradinho\ \-\ DF",
"55192108", "Americana\ \-\ SP",
"55773663", "Morpará\ \-\ BA",
"55413131", "Curitiba\ \-\ PR",
"55163829", "Ituverava\ \-\ SP",
"55513781", "Rio\ Grande\ do\ Sul",
"55823028", "Maceió\ \-\ AL",
"55823541", "Junqueiro\ \-\ AL",
"55213432", "Rio\ de\ Janeiro\ \-\ RJ",
"55112805", "Diadema\ \-\ SP",
"55114651", "Arujá\ \-\ SP",
"55433569", "Pinhalão\ \-\ PR",
"55383724", "Presidente\ Juscelino\ \-\ MG",
"55773402", "Vitória\ da\ Conquista\ \-\ BA",
"55353713", "Poços\ de\ Caldas\ \-\ MG",
"55413391", "Campo\ Largo\ \-\ PR",
"55313736", "Desterro\ de\ Entre\ Rios\ \-\ MG",
"55643681", "Firminópolis\ \-\ GO",
"55773652", "Muquém\ de\ São\ Francisco\ \-\ BA",
"55983312", "São\ Luís\ \-\ MA",
"55813492", "Olinda\ \-\ PE",
"55542106", "Erechim\ \-\ RS",
"55883646", "Cariré\ \-\ CE",
"55553033", "Santa\ Maria\ \-\ RS",
"55753161", "Feira\ de\ Santana\ \-\ BA",
"55283554", "Muqui\ \-\ ES",
"55973441", "Santa\ Isabel\ do\ Rio\ Negro\ \-\ AM",
"5511368", "Osasco\ \-\ SP",
"55143279", "Tibiriçá\ \-\ SP",
"55212133", "Rio\ de\ Janeiro\ \-\ RJ",
"55833257", "Mata\ Redonda\ \-\ PB",
"55443355", "Maringá\ \-\ PR",
"55733258", "Maraú\ \-\ BA",
"55242483", "Miguel\ Pereira\ \-\ RJ",
"55513461", "Esteio\ \-\ RS",
"55333755", "Águas\ Vermelhas\ \-\ MG",
"55673557", "Três\ Lagoas\ \-\ MS",
"55214118", "Rio\ de\ Janeiro\ \-\ RJ",
"55553268", "Dona\ Francisca\ \-\ RS",
"55543464", "Garibaldi\ \-\ RS",
"55163877", "Ribeirão\ Preto\ \-\ SP",
"55833350", "Ouro\ Velho\ \-\ PB",
"55793354", "Gararu\ \-\ SE",
"55623518", "Aparecida\ de\ Goiânia\ \-\ GO",
"55123426", "Taubaté\ \-\ SP",
"55133295", "Santos\ \-\ SP",
"55953624", "Boa\ Vista\ \-\ RR",
"55143212", "Bauru\ \-\ SP",
"55153026", "Sorocaba\ \-\ SP",
"55663573", "Paranatinga\ \-\ MT",
"55212692", "Nilópolis\ \-\ RJ",
"55553381", "São\ Miguel\ das\ Missões\ \-\ RS",
"5518390", "Presidente\ Prudente\ \-\ SP",
"55623095", "Goiânia\ \-\ GO",
"55434141", "Londrina\ \-\ PR",
"55483357", "São\ José\ \-\ SC",
"55483906", "Tubarão\ \-\ SC",
"55513179", "Taquara\ \-\ RS",
"55413678", "Adrianópolis\ \-\ PR",
"55893542", "Landri\ Sales\ \-\ PI",
"55443665", "Icaraíma\ \-\ PR",
"55463540", "Pranchita\ \-\ PR",
"55913764", "São\ Sebastião\ da\ Boa\ Vista\ \-\ PA",
"55173485", "Valentim\ Gentil\ \-\ SP",
"55115044", "São\ Paulo\ \-\ SP",
"55823260", "Marechal\ Deodoro\ \-\ AL",
"55833279", "Cachoeira\ \-\ PB",
"55193824", "Águas\ de\ Lindóia\ \-\ SP",
"55883411", "Russas\ \-\ CE",
"55323251", "Santos\ Dumont\ \-\ MG",
"55943355", "Marabá\ \-\ PA",
"55413059", "Pinhais\ \-\ PR",
"55473158", "Itajaí\ \-\ SC",
"55443045", "Paranavaí\ \-\ PR",
"55343511", "Patrocínio\ \-\ MG",
"55813688", "São\ José\ da\ Coroa\ Grande\ \-\ PE",
"55193647", "Itobi\ \-\ SP",
"55713125", "Camaçari\ \-\ BA",
"55483648", "Termas\ do\ Gravatal\ \-\ SC",
"55113429", "São\ Paulo\ \-\ SP",
"55463581", "Dois\ Vizinhos\ \-\ PR",
"55813739", "Altinho\ \-\ PE",
"55543326", "Campos\ Borges\ \-\ RS",
"55814062", "Recife\ \-\ PE",
"55843254", "São\ Pedro\ \-\ RN",
"55663565", "Aripuanã\ \-\ MT",
"55643640", "Lagoa\ Santa\ \-\ GO",
"55623344", "Uruana\ \-\ GO",
"55653626", "Cuiabá\ \-\ MT",
"55443673", "Ivaté\ \-\ PR",
"55513157", "Três\ Coroas\ \-\ RS",
"55983357", "Matinha\ \-\ MA",
"55343814", "Patos\ de\ Minas\ \-\ MG",
"55183255", "Rancharia\ \-\ SP",
"55773617", "Baianópolis\ \-\ BA",
"55313260", "Minas\ Gerais",
"55163859", "Orlândia\ \-\ SP",
"55693233", "Triunfo\ \-\ RO",
"55673579", "Selvíria\ \-\ MS",
"55123654", "Caçapava\ \-\ SP",
"55183788", "Murutinga\ do\ Sul\ \-\ SP",
"55163434", "Ribeirão\ Preto\ \-\ SP",
"55193521", "Campinas\ \-\ SP",
"55483047", "São\ José\ \-\ SC",
"55843295", "Jaçanã\ \-\ RN",
"55643931", "Itumbiara\ \-\ GO",
"55114772", "Jandira\ \-\ SP",
"55383754", "Três\ Marias\ \-\ MG",
"55112683", "São\ Paulo\ \-\ SP",
"55813676", "Tamandaré\ \-\ PE",
"55553419", "Barra\ do\ Quaraí\ \-\ RS",
"55183639", "Santo\ Antônio\ do\ Aracanguá\ \-\ SP",
"55853344", "Paracuru\ \-\ CE",
"55163987", "Serrana\ \-\ SP",
"55543357", "Camargo\ \-\ RS",
"55823626", "Poço\ das\ Trincheiras\ \-\ AL",
"55513075", "Canoas\ \-\ RS",
"55543906", "Farroupilha\ \-\ RS",
"55753426", "Rio\ Real\ \-\ BA",
"55343292", "Uberlândia\ \-\ MG",
"55613487", "Sobradinho\ \-\ DF",
"55633372", "Natividade\ \-\ TO",
"55333215", "Governador\ Valadares\ \-\ MG",
"55633440", "Fortaleza\ do\ Tabocão\ \-\ TO",
"5544322", "Maringá\ \-\ PR",
"55114442", "Caieiras\ \-\ SP",
"55532126", "Rio\ Grande\ \-\ RS",
"55483464", "Lauro\ Muller\ \-\ SC",
"5546", "Paraná",
"55173335", "Colômbia\ \-\ SP",
"55112897", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55493553", "Piratuba\ \-\ SC",
"55143226", "Bauru\ \-\ SP",
"55673291", "Coxim\ \-\ MS",
"55433473", "Lidianópolis\ \-\ PR",
"55113133", "São\ Paulo\ \-\ SP",
"55843536", "Pedra\ Preta\ \-\ RN",
"55163704", "Franca\ \-\ SP",
"55482106", "Florianópolis\ \-\ SC",
"55313626", "Ribeirão\ das\ Neves\ \-\ MG",
"5551352", "Rio\ Grande\ do\ Sul",
"55853813", "São\ Paulo\ \-\ SP",
"55513951", "Novo\ Hamburgo\ \-\ RS",
"55553742", "Palmeira\ das\ Missões\ \-\ RS",
"55473622", "Canoinhas\ \-\ SC",
"55973353", "Codajás\ \-\ AM",
"55212609", "Niterói\ \-\ RJ",
"55173269", "Ipiguá\ \-\ SP",
"55163384", "Matão\ \-\ SP",
"55183928", "Presidente\ Prudente\ \-\ SP",
"55114816", "Jundiaí\ \-\ SP",
"55812138", "Recife\ \-\ PE",
"55753283", "Paulo\ Afonso\ \-\ BA",
"55193807", "Amparo\ \-\ SP",
"55222552", "Santa\ Rita\ da\ Floresta\ \-\ RJ",
"55863280", "São\ Pedro\ do\ Piauí\ \-\ PI",
"55893468", "Aroazes\ \-\ PI",
"55543233", "Ipê\ \-\ RS",
"55983326", "Presidente\ Médici\ \-\ MA",
"55613500", "Brasília\ \-\ DF",
"55163275", "Taiaçu\ \-\ SP",
"55222791", "Macaé\ \-\ RJ",
"5596", "Amapá",
"55273327", "Vitória\ \-\ ES",
"55983464", "Miranda\ do\ Norte\ \-\ MA",
"55433032", "Londrina\ \-\ PR",
"55753695", "São\ Domingos\ \-\ BA",
"55813711", "Caruaru\ \-\ PE",
"55242257", "Areal\ \-\ RJ",
"55433465", "Rosário\ do\ Ivaí\ \-\ PR",
"55993553", "Sucupira\ do\ Riachão\ \-\ MA",
"55873781", "Canhotinho\ \-\ PE",
"55553559", "Braga\ \-\ RS",
"55383214", "Montes\ Claros\ \-\ MG",
"55223053", "Cabo\ Frio\ \-\ RJ",
"55753654", "Brejões\ \-\ BA",
"55473402", "Joinville\ \-\ SC",
"55443538", "Engenheiro\ Beltrão\ \-\ PR",
"55863299", "Hugo\ Napoleão\ \-\ PI",
"55863241", "Boa\ Hora\ \-\ PI",
"55883439", "Ibaretama\ \-\ CE",
"55114731", "Suzano\ \-\ SP",
"55543379", "Coxilha\ \-\ RS",
"55773414", "Jussiape\ \-\ BA",
"55323711", "Vermelho\ \-\ MG",
"55473524", "Aurora\ \-\ SC",
"55713029", "Lauro\ de\ Freitas\ \-\ BA",
"55112536", "São\ Paulo\ \-\ SP",
"55553431", "São\ Borja\ \-\ RS",
"55113555", "São\ Paulo\ \-\ SP",
"55163263", "Itápolis\ \-\ SP",
"55513238", "Rio\ Grande\ do\ Sul",
"55673452", "Rio\ Brilhante\ \-\ MS",
"55693464", "Vale\ do\ Paraíso\ \-\ RO",
"55423027", "Ponta\ Grossa\ \-\ PR",
"5519346", "Americana\ \-\ SP",
"55222654", "Sampaio\ Correia\ \-\ RJ",
"55153281", "Araçoiaba\ da\ Serra\ \-\ SP",
"55982106", "São\ Luís\ \-\ MA",
"55753364", "Iraquara\ \-\ BA",
"55473330", "Blumenau\ \-\ SC",
"55833483", "Olho\ d\'Água\ \-\ PB",
"55893447", "São\ José\ do\ Piauí\ \-\ PI",
"55113594", "São\ Paulo\ \-\ SP",
"55183857", "São\ João\ do\ Pau\ D\'Alho\ \-\ SP",
"55473353", "Apiúna\ \-\ SC",
"55313839", "Itabira\ \-\ MG",
"55453245", "Braganey\ \-\ PR",
"55493354", "Marema\ \-\ SC",
"55143722", "Tupã\ \-\ SP",
"55473362", "Presidente\ Nereu\ \-\ SC",
"55843432", "Campo\ Redondo\ \-\ RN",
"55193646", "São\ Sebastião\ da\ Grama\ \-\ SP",
"55773480", "Coribe\ \-\ BA",
"55653313", "Cuiabá\ \-\ MT",
"55613336", "Taguatinga\ \-\ DF",
"55433258", "Ibiporã\ \-\ PR",
"55733289", "Itagimirim\ \-\ BA",
"55843065", "Mossoró\ \-\ RN",
"55813078", "Recife\ \-\ PE",
"55273047", "Linhares\ \-\ ES",
"55753456", "Cardeal\ da\ Silva\ \-\ BA",
"55123607", "Tremembé\ \-\ SP",
"55644141", "Itumbiara\ \-\ GO",
"55163726", "Orlândia\ \-\ SP",
"55193123", "Campinas\ \-\ SP",
"55543327", "Passo\ Fundo\ \-\ RS",
"55883668", "Senador\ Sá\ \-\ CE",
"55373433", "São\ Roque\ de\ Minas\ \-\ MG",
"55673463", "Juti\ \-\ MS",
"55113120", "São\ Paulo\ \-\ SP",
"55983304", "São\ Luís\ \-\ MA",
"55823271", "São\ Miguel\ dos\ Campos\ \-\ AL",
"55163252", "Taquaritinga\ \-\ SP",
"55743665", "Jacobina\ \-\ BA",
"55753522", "Castro\ Alves\ \-\ BA",
"55653541", "Colíder\ \-\ MT",
"55653028", "Cuiabá\ \-\ MT",
"55213224", "Rio\ de\ Janeiro\ \-\ RJ",
"55623946", "Goiânia\ \-\ GO",
"55383532", "Diamantina\ \-\ MG",
"55433305", "Londrina\ \-\ PR",
"55313090", "Belo\ Horizonte\ \-\ MG",
"55493523", "Luzerna\ \-\ SC",
"55734141", "Itabuna\ \-\ BA",
"55193709", "Campinas\ \-\ SP",
"55493664", "Maravilha\ \-\ SC",
"55473652", "Itaiópolis\ \-\ SC",
"55273312", "São\ Mateus\ \-\ ES",
"55513052", "Canoas\ \-\ RS",
"55633355", "Miranorte\ \-\ TO",
"55813086", "Recife\ \-\ PE",
"55333731", "Araçuaí\ \-\ MG",
"55353223", "Varginha\ \-\ MG",
"55123966", "São\ José\ dos\ Campos\ \-\ SP",
"5519378", "Campinas\ \-\ SP",
"55993562", "Gonçalves\ Dias\ \-\ MA",
"55472103", "Itajaí\ \-\ SC",
"55913088", "Belém\ \-\ PA",
"55913119", "Belém\ \-\ PA",
"55633394", "Sandolândia\ \-\ TO",
"55223841", "Natividade\ \-\ RJ",
"55533011", "Pelotas\ \-\ RS",
"55114164", "Carapicuíba\ \-\ SP",
"55773616", "Formosa\ do\ Rio\ Preto\ \-\ BA",
"55542107", "Erechim\ \-\ RS",
"55883647", "Groaíras\ \-\ CE",
"55113572", "São\ Paulo\ \-\ SP",
"55743673", "Uauá\ \-\ BA",
"55273357", "Vitória\ \-\ ES",
"55242445", "Barra\ do\ Piraí\ \-\ RJ",
"55943331", "São\ Geraldo\ do\ Araguaia\ \-\ PA",
"55673475", "Japorã\ \-\ MS",
"55213896", "Duque\ de\ Caxias\ \-\ RJ",
"55533282", "Pelotas\ \-\ RS",
"55483298", "Florianópolis\ \-\ SC",
"55813744", "Agrestina\ \-\ PE",
"55833256", "Alhandra\ \-\ PB",
"55753624", "Feira\ de\ Santana\ \-\ BA",
"55313737", "Minas\ Gerais",
"55823424", "Major\ Isidoro\ \-\ AL",
"55115904", "São\ Paulo\ \-\ SP",
"55643071", "Rio\ Verde\ \-\ GO",
"55383634", "Chapada\ Gaúcha\ \-\ MG",
"55923012", "Manaus\ \-\ AM",
"55863214", "Teresina\ \-\ PI",
"55883521", "Crato\ \-\ CE",
"55773499", "Sussuarana\ \-\ BA",
"55513618", "Barão\ \-\ RS",
"55493562", "Pinheiro\ Preto\ \-\ SC",
"55473018", "Gaspar\ \-\ SC",
"55163491", "Sertãozinho\ \-\ SP",
"55773441", "Brumado\ \-\ BA",
"55873803", "Pesqueira\ \-\ PE",
"55733290", "Ibirapuã\ \-\ BA",
"55483356", "Imbituba\ \-\ SC",
"55183644", "Birigui\ \-\ SP",
"55113393", "São\ Paulo\ \-\ SP",
"55833398", "Itatuba\ \-\ PB",
"55623608", "Goiânia\ \-\ GO",
"55513470", "Rio\ Grande\ do\ Sul",
"55713203", "Salvador\ \-\ BA",
"55222624", "Iguaba\ Grande\ \-\ RJ",
"55273233", "Vitória\ \-\ ES",
"55343421", "Frutal\ \-\ MG",
"55273250", "Coqueiral\ \-\ ES",
"55115787", "São\ Paulo\ \-\ SP",
"55313424", "Belo\ Horizonte\ \-\ MG",
"55313118", "Belo\ Horizonte\ \-\ MG",
"55823555", "São\ Brás\ \-\ AL",
"55473340", "Blumenau\ \-\ SC",
"55843229", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55114645", "Itaquaquecetuba\ \-\ SP",
"55313849", "Timóteo\ \-\ MG",
"55453235", "Três\ Barras\ do\ Paraná\ \-\ PR",
"55193545", "Santa\ Gertrudes\ \-\ SP",
"55333536", "Teófilo\ Otoni\ \-\ MG",
"55313891", "Viçosa\ \-\ MG",
"5511439", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55343855", "Rio\ Paranaíba\ \-\ MG",
"55534052", "Pelotas\ \-\ RS",
"55953086", "Boa\ Vista\ \-\ RR",
"5565368", "Várzea\ Grande\ \-\ MT",
"55273171", "Linhares\ \-\ ES",
"55813457", "Paulista\ \-\ PE",
"55193181", "Floresta\ Escura\ \-\ SP",
"55833292", "Mamanguape\ \-\ PB",
"55753688", "Lamarão\ \-\ BA",
"55433564", "Quatiguá\ \-\ PR",
"55383729", "Curvelo\ \-\ MG",
"55473472", "Joinville\ \-\ SC",
"55213852", "Rio\ de\ Janeiro\ \-\ RJ",
"55823891", "Viçosa\ \-\ MG",
"55653338", "Gleba\ Ranchão\ \-\ MT",
"55433623", "Porecatu\ \-\ PR",
"55313555", "Minas\ Gerais",
"5511587", "São\ Paulo\ \-\ SP",
"55533261", "Jaguarão\ \-\ RS",
"55883449", "Senador\ Pompeu\ \-\ CE",
"55193859", "Valinhos\ \-\ SP",
"55983878", "São\ Luís\ \-\ MA",
"55753251", "Itaberaba\ \-\ BA",
"55163521", "Sertãozinho\ \-\ SP",
"55543037", "Carlos\ Barbosa\ \-\ RS",
"55353281", "Cristina\ \-\ MG",
"55923223", "Manaus\ \-\ AM",
"55913311", "Castanhal\ \-\ PA",
"55314003", "Belo\ Horizonte\ \-\ MG",
"55313488", "Minas\ Gerais",
"55753676", "São\ Miguel\ das\ Matas\ \-\ BA",
"55943314", "Serra\ Pelada\ \-\ PA",
"55513983", "Venâncio\ Aires\ \-\ RS",
"55613026", "Brasília\ \-\ DF",
"55143451", "Marília\ \-\ SP",
"55163668", "Santo\ Antônio\ da\ Alegria\ \-\ SP",
"55353012", "Itajubá\ \-\ MG",
"55513633", "Pareci\ Novo\ \-\ RS",
"55623484", "Mambaí\ \-\ GO",
"55623598", "Aparecida\ de\ Goiânia\ \-\ GO",
"55513650", "Barão\ do\ Triunfo\ \-\ RS",
"55123836", "Ubatuba\ \-\ SP",
"55143292", "Pederneiras\ \-\ SP",
"55473050", "Camboriú\ \-\ SC",
"55223081", "Macaé\ \-\ RJ",
"55213288", "Rio\ de\ Janeiro\ \-\ RJ",
"55833539", "Triunfo\ \-\ PB",
"55813846", "Santa\ Cruz\ da\ Baixa\ Verde\ \-\ PE",
"55383812", "Espinosa\ \-\ MG",
"55513267", "Rio\ Grande\ do\ Sul",
"55623015", "Goiânia\ \-\ GO",
"55373335", "Passa\ Tempo\ \-\ MG",
"55953235", "São\ João\ da\ Baliza\ \-\ RR",
"55433662", "Florestópolis\ \-\ PR",
"55163358", "Araraquara\ \-\ SP",
"55443567", "Quinta\ do\ Sol\ \-\ PR",
"55854042", "Fortaleza\ \-\ CE",
"55864020", "Teresina\ \-\ PI",
"55283515", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55973425", "Jutaí\ \-\ AM",
"55633430", "Carmolândia\ \-\ TO",
"55873945", "Serra\ Talhada\ \-\ PE",
"55833451", "Itaporanga\ \-\ PB",
"55513192", "Novo\ Hamburgo\ \-\ RS",
"55983392", "Bacuri\ \-\ MA",
"5524334", "Volta\ Redonda\ \-\ RJ",
"55673239", "Água\ Clara\ \-\ MS",
"55633453", "Wanderlândia\ \-\ TO",
"55153253", "Quadra\ \-\ SP",
"55173345", "Bebedouro\ \-\ SP",
"55813412", "Recife\ \-\ PE",
"55853334", "Cascavel\ \-\ CE",
"55413543", "Rio\ Negro\ \-\ PR",
"55283529", "Itapemirim\ \-\ ES",
"55883583", "Mombaça\ \-\ CE",
"55193877", "Artur\ Nogueira\ \-\ SP",
"55483878", "Florianópolis\ \-\ SC",
"55444009", "Maringá\ \-\ PR",
"55112229", "Guarulhos\ \-\ SP",
"55623391", "Mundo\ Novo\ \-\ GO",
"55114897", "Itu\ \-\ SP",
"55843259", "Barcelona\ \-\ RN",
"55313572", "Itatiaiuçu\ \-\ MG",
"55623349", "Hidrolina\ \-\ GO",
"55113502", "São\ Paulo\ \-\ SP",
"55513587", "Novo\ Hamburgo\ \-\ RS",
"55343819", "Monte\ Carmelo\ \-\ MG",
"55673405", "Vista\ Alegre\ \-\ MS",
"55213568", "Niterói\ \-\ RJ",
"55333432", "São\ Sebastião\ do\ Maranhão\ \-\ MG",
"55843635", "Santa\ Maria\ \-\ RN",
"55773431", "Poções\ \-\ BA",
"55153262", "Porto\ Feliz\ \-\ SP",
"55923582", "Manaus\ \-\ AM",
"55613004", "Brasília\ \-\ DF",
"55843003", "Natal\ \-\ RN",
"55673574", "Inocência\ \-\ MS",
"55553414", "Uruguaiana\ \-\ RS",
"55483285", "Biguaçu\ \-\ SC",
"55183634", "Birigui\ \-\ SP",
"55793377", "Ilha\ das\ Flores\ \-\ SE",
"55383759", "Lassance\ \-\ MG",
"55115049", "São\ Paulo\ \-\ SP",
"55683261", "Humaitá\ \(Pad\ Humaitá\)\ \-\ AC",
"55383231", "Brasília\ de\ Minas\ \-\ MG",
"5561342", "Brasília\ \-\ DF",
"55162108", "Araraquara\ \-\ SP",
"55313393", "Minas\ Gerais",
"55873873", "Araripina\ \-\ PE",
"55833274", "Araçagi\ \-\ PB",
"55193829", "Valinhos\ \-\ SP",
"55112277", "Bragança\ Paulista\ \-\ SP",
"55413054", "Campo\ Largo\ \-\ PR",
"55313525", "Minas\ Gerais",
"55313519", "Belo\ Horizonte\ \-\ MG",
"55943341", "Bom\ Jesus\ do\ Tocantins\ \-\ PA",
"5585347", "Fortaleza\ \-\ CE",
"55913344", "Belém\ \-\ PA",
"55473455", "Joinville\ \-\ SC",
"55883637", "Reriutaba\ \-\ CE",
"55432102", "Apucarana\ \-\ PR",
"55484106", "Florianópolis\ \-\ SC",
"55813734", "Vertentes\ \-\ PE",
"55673496", "Ponta\ Porã\ \-\ MS",
"55513400", "Rio\ Grande\ do\ Sul",
"55113424", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55833385", "Cubati\ \-\ PB",
"55713273", "Salvador\ \-\ BA",
"55123677", "Natividade\ da\ Serra\ \-\ SP",
"55343671", "São\ Gotardo\ \-\ MG",
"55143601", "Jaú\ \-\ SP",
"55315", "Minas\ Gerais",
"55513620", "Rio\ Grande\ do\ Sul",
"55553236", "Formigueiro\ \-\ RS",
"55223831", "Bom\ Jesus\ do\ Itabapoana\ \-\ RJ",
"55353864", "Perdões\ \-\ MG",
"55673672", "Rio\ Brilhante\ \-\ MS",
"55193779", "Campinas\ \-\ SP",
"55843277", "Nísia\ Floresta\ \-\ RN",
"55343256", "Uberlândia\ \-\ MG",
"55333741", "Jequitinhonha\ \-\ MG",
"55983374", "Santa\ Luzia\ do\ Paruá\ \-\ MA",
"55823201", "Maceió\ \-\ AL",
"55813607", "Orobó\ \-\ PE",
"55213621", "Rio\ de\ Janeiro\ \-\ RJ",
"5579", "Sergipe",
"55613689", "Formosa\ \-\ GO",
"55143385", "Tejupá\ \-\ SP",
"55633423", "Darcinópolis\ \-\ TO",
"55313768", "Contagem\ \-\ MG",
"55653531", "Sinop\ \-\ MT",
"55353561", "Carmo\ do\ Rio\ Claro\ \-\ MG",
"55833421", "Patos\ \-\ PB",
"55984002", "São\ Luís\ \-\ MA",
"55313201", "Belo\ Horizonte\ \-\ MG",
"555139", "Rio\ Grande\ do\ Sul",
"55873865", "Dormentes\ \-\ PE",
"55143274", "Gália\ \-\ SP",
"55153478", "Pilar\ do\ Sul\ \-\ SP",
"55283559", "Dores\ do\ Rio\ Preto\ \-\ ES",
"55413590", "Piraquara\ \-\ PR",
"55173334", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55493319", "Chapecó\ \-\ SC",
"55673676", "Nova\ Andradina\ \-\ MS",
"55123186", "Cachoeira\ Paulista\ \-\ SP",
"55623584", "Aparecida\ de\ Goiânia\ \-\ GO",
"55114280", "Cotia\ \-\ SP",
"55343252", "Ipiaçu\ \-\ MG",
"55863277", "Capitão\ de\ Campos\ \-\ PI",
"55543397", "Maximiliano\ de\ Almeida\ \-\ RS",
"55983473", "Coelho\ Neto\ \-\ MA",
"55483465", "Urussanga\ \-\ SC",
"55323512", "Juiz\ de\ Fora\ \-\ MG",
"55313883", "Rio\ Doce\ \-\ MG",
"55473674", "São\ Miguel\ da\ Serra\ \-\ SC",
"55213639", "Itaboraí\ \-\ RJ",
"55163601", "Ribeirão\ Preto\ \-\ SP",
"55113362", "São\ Paulo\ \-\ SP",
"55513767", "Tunas\ \-\ RS",
"55833439", "Lagoa\ \-\ PB",
"55653529", "Santa\ Rita\ do\ Trivelato\ \-\ MT",
"55673251", "Jardim\ \-\ MS",
"55853345", "Pacatuba\ \-\ CE",
"55553232", "São\ Gabriel\ \-\ RS",
"55493325", "São\ Carlos\ \-\ SC",
"55533045", "Rio\ Grande\ \-\ RS",
"55674062", "Campo\ Grande\ \-\ MS",
"55893471", "Várzea\ Grande\ \-\ PI",
"55353293", "Areado\ \-\ MG",
"55613618", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55112715", "Itu\ \-\ SP",
"55114532", "Jundiaí\ \-\ SP",
"55633530", "Rio\ dos\ Bois\ \-\ TO",
"55114707", "Jandira\ \-\ SP",
"55273137", "Vitória\ \-\ ES",
"55413443", "Guaratuba\ \-\ PR",
"55163385", "Tabatinga\ \-\ SP",
"55373344", "Pedra\ do\ Indaiá\ \-\ MG",
"55543290", "Caxias\ do\ Sul\ \-\ RS",
"55193716", "Campinas\ \-\ SP",
"55113652", "Osasco\ \-\ SP",
"55743553", "Campo\ Formoso\ \-\ BA",
"55383546", "São\ Gonçalo\ do\ Rio\ Preto\ \-\ MG",
"55623932", "Goiânia\ \-\ GO",
"55813512", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55223829", "Laje\ do\ Muriaé\ \-\ RJ",
"55115833", "São\ Paulo\ \-\ SP",
"55153266", "Iperó\ \-\ SP",
"55544141", "Caxias\ do\ Sul\ \-\ RS",
"55633466", "Pedro\ Afonso\ \-\ TO",
"55333436", "Rio\ Vermelho\ \-\ MG",
"5511310", "São\ Paulo\ \-\ SP",
"55222751", "São\ Fidélis\ \-\ RJ",
"55893537", "Eliseu\ Martins\ \-\ PI",
"55553313", "Santo\ Ângelo\ \-\ RS",
"55213826", "Rio\ de\ Janeiro\ \-\ RJ",
"55753694", "Santanópolis\ \-\ BA",
"55313576", "Bonfim\ \-\ MG",
"55433464", "Mauá\ da\ Serra\ \-\ PR",
"55553028", "Santa\ Maria\ \-\ RS",
"55513748", "Lajeado\ \-\ RS",
"55553541", "Santo\ Cristo\ \-\ RS",
"55274007", "Vitória\ \-\ ES",
"55242411", "Barra\ do\ Piraí\ \-\ RJ",
"55983465", "Nina\ Rodrigues\ \-\ MA",
"55193831", "Mogi\-Guaçu\ \-\ SP",
"55863259", "Lagoa\ do\ Piauí\ \-\ PI",
"55753239", "Anguera\ \-\ BA",
"55413589", "Piraquara\ \-\ PR",
"55212760", "Rio\ das\ Ostras\ \-\ RJ",
"5554320", "Caxias\ do\ Sul\ \-\ RS",
"55883549", "Tarrafas\ \-\ CE",
"55913443", "Irituia\ \-\ PA",
"55163421", "Ribeirão\ Preto\ \-\ SP",
"55133879", "Barra\ do\ Braço\ \-\ SP",
"55443448", "Marilena\ \-\ PR",
"55114241", "Embu\ das\ Artes\ \-\ SP",
"55453244", "Missal\ \-\ PR",
"55683325", "Marechal\ Thaumaturgo\ \-\ AC",
"55114634", "Poá\ \-\ SP",
"55222655", "Saquarema\ \-\ RJ",
"55113595", "São\ Paulo\ \-\ SP",
"55123211", "Cruzeiro\ \-\ SP",
"55733613", "Itabuna\ \-\ BA",
"55353301", "Poços\ de\ Caldas\ \-\ MG",
"55113554", "São\ Paulo\ \-\ SP",
"55142108", "Bauru\ \-\ SP",
"55693465", "Teixeirópolis\ \-\ RO",
"55133446", "Mongaguá\ \-\ SP",
"55773415", "Ituaçu\ \-\ BA",
"55843611", "Natal\ \-\ RN",
"55473393", "Bombinhas\ \-\ SC",
"55473525", "Rio\ do\ Sul\ \-\ SC",
"55112812", "Guarulhos\ \-\ SP",
"55643613", "Rio\ Verde\ \-\ GO",
"55513713", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55433304", "Londrina\ \-\ PR",
"55823268", "Santa\ Luzia\ do\ Norte\ \-\ AL",
"55283531", "Itapemirim\ \-\ ES",
"55743664", "Xique\-xique\ \-\ BA",
"55753496", "Adustina\ \-\ BA",
"55883671", "Tianguá\ \-\ CE",
"55333299", "Açucena\ \-\ MG",
"55333241", "Mantena\ \-\ MG",
"55553612", "Dilermando\ de\ Aguiar\ \-\ RS",
"55544007", "Caxias\ do\ Sul\ \-\ RS",
"55123981", "Cedro\ \-\ SP",
"55493355", "Lajeado\ Grande\ \-\ SC",
"55733047", "Jequié\ \-\ BA",
"55623383", "Britânia\ \-\ GO",
"55112827", "São\ Paulo\ \-\ SP",
"55213219", "Rio\ de\ Janeiro\ \-\ RJ",
"55143668", "Itaju\ \-\ SP",
"55143296", "Arealva\ \-\ SP",
"55673221", "Três\ Lagoas\ \-\ MS",
"55123832", "Ubatuba\ \-\ SP",
"5513335", "Guarujá\ \-\ SP",
"55313268", "Minas\ Gerais",
"55833048", "João\ Pessoa\ \-\ PB",
"55114165", "Itapecerica\ da\ Serra\ \-\ SP",
"55943787", "Tucuruí\ \-\ PA",
"55833521", "Sousa\ \-\ PB",
"55353461", "Bom\ Repouso\ \-\ MG",
"55643648", "Itajá\ \-\ GO",
"55983681", "Santa\ Inês\ \-\ MA",
"55433356", "Londrina\ \-\ PR",
"55373543", "Quartel\ Geral\ \-\ MG",
"55183998", "João\ Ramalho\ \-\ SP",
"5571323", "Salvador\ \-\ BA",
"55733312", "Itamaraju\ \-\ BA",
"55773477", "Lagoa\ Real\ \-\ BA",
"55313381", "Belo\ Horizonte\ \-\ MG",
"55493665", "Iraceminha\ \-\ SC",
"55983396", "Cândido\ Mendes\ \-\ MA",
"55823033", "Maceió\ \-\ AL",
"55633354", "Cristalândia\ \-\ TO",
"55323061", "Juiz\ de\ Fora\ \-\ MG",
"55113402", "Atibaia\ \-\ SP",
"55383635", "Arinos\ \-\ MG",
"55513487", "Glorinha\ \-\ RS",
"55313472", "Minas\ Gerais",
"55663902", "Rondonópolis\ \-\ MT",
"55833296", "Baía\ da\ Traição\ \-\ PB",
"55273743", "Colatina\ \-\ ES",
"55213856", "São\ Gonçalo\ \-\ RJ",
"55483258", "São\ José\ \-\ SC",
"55823425", "Taquarana\ \-\ AL",
"55744400", "Pilão\ Arcado\ \-\ BA",
"55553367", "Santo\ Antônio\ das\ Missões\ \-\ RS",
"55624101", "Goiânia\ \-\ GO",
"55813745", "Riacho\ das\ Almas\ \-\ PE",
"55333532", "Itaipé\ \-\ MG",
"55183741", "Castilho\ \-\ SP",
"55273071", "Vitória\ \-\ ES",
"55443039", "Cianorte\ \-\ PR",
"55242444", "Barra\ do\ Piraí\ \-\ RJ",
"55673474", "Mundo\ Novo\ \-\ MS",
"55474003", "Blumenau\ \-\ SC",
"55773459", "Tanhaçu\ \-\ BA",
"55473488", "Blumenau\ \-\ SC",
"55172136", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55453211", "Santa\ Maria\ \-\ PR",
"55433046", "Arapongas\ \-\ PR",
"55713041", "Camaçari\ \-\ BA",
"55123631", "Taubaté\ \-\ SP",
"55343637", "Pratinha\ \-\ MG",
"55643667", "Arenópolis\ \-\ GO",
"55113353", "São\ Paulo\ \-\ SP",
"55833358", "Barra\ de\ São\ Miguel\ \-\ PB",
"55963314", "Santana\ \-\ AP",
"55313247", "Belo\ Horizonte\ \-\ MG",
"55643954", "Itumbiara\ \-\ GO",
"55383731", "Várzea\ da\ Palma\ \-\ MG",
"55533325", "Pelotas\ \-\ RS",
"55993665", "Capinzal\ do\ Norte\ \-\ MA",
"55843231", "Natal\ \-\ RN",
"55114173", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55673596", "Cassilândia\ \-\ MS",
"55463548", "Bom\ Jesus\ do\ Sul\ \-\ PR",
"55733667", "Itamaraju\ \-\ BA",
"55343263", "Capinópolis\ \-\ MG",
"55183645", "Coroados\ \-\ SP",
"55173838", "Pedranópolis\ \-\ SP",
"55964009", "Macapá\ \-\ AP",
"55813699", "Panelas\ \-\ PE",
"55313419", "Minas\ Gerais",
"55813641", "Vicência\ \-\ PE",
"55323745", "Caiana\ \-\ MG",
"55843644", "Parnamirim\ \-\ RN",
"55793548", "Santa\ Luzia\ do\ Itanhy\ \-\ SE",
"55353266", "Três\ Pontas\ \-\ MG",
"55613213", "Brasília\ \-\ DF",
"55112809", "Guarulhos\ \-\ SP",
"55353698", "Alfenas\ \-\ MG",
"55433565", "São\ José\ da\ Boa\ Vista\ \-\ PR",
"55683302", "Rio\ Branco\ \-\ AC",
"55143888", "Pereiras\ \-\ SP",
"55613620", "Luziânia\ \-\ GO",
"55923016", "Manaus\ \-\ AM",
"55773657", "Tabocas\ do\ Brejo\ Velho\ \-\ BA",
"55643469", "Anhanguera\ \-\ GO",
"55243373", "Paraty\ \-\ RJ",
"55313851", "João\ Monlevade\ \-\ MG",
"55113576", "São\ Paulo\ \-\ SP",
"55453234", "Catanduvas\ \-\ PR",
"55443438", "São\ Carlos\ do\ Ivaí\ \-\ PR",
"55463905", "Francisco\ Beltrão\ \-\ PR",
"55193544", "Araras\ \-\ SP",
"55813497", "Recife\ \-\ PE",
"55883539", "Baixio\ \-\ CE",
"55183229", "Presidente\ Prudente\ \-\ SP",
"5511435", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55693623", "Seringueiras\ \-\ RO",
"55823554", "Igreja\ Nova\ \-\ AL",
"55833252", "João\ Pessoa\ \-\ PB",
"55114644", "Itaquaquecetuba\ \-\ SP",
"55115021", "São\ Paulo\ \-\ SP",
"55513738", "Venâncio\ Aires\ \-\ RS",
"55163763", "Jardinópolis\ \-\ SP",
"55513689", "Xangri\-Lá\ \-\ RS",
"55473424", "Pirabeiraba\ \-\ SC",
"55753249", "Tanquinho\ \-\ BA",
"55114759", "Suzano\ \-\ SP",
"55883451", "Dom\ Maurício\ \-\ CE",
"55193841", "Mogi\-Guaçu\ \-\ SP",
"55193899", "Monte\ Alegre\ do\ Sul\ \-\ SP",
"55943315", "PA\ 275\ \-\ PA",
"55313323", "Belo\ Horizonte\ \-\ MG",
"55212697", "Mesquita\ \-\ RJ",
"55313554", "Lavras\ Novas\ \-\ MG",
"55413025", "Curitiba\ \-\ PR",
"55493566", "Videira\ \-\ SC",
"55273720", "Itarana\ \-\ ES",
"55342108", "Araguari\ \-\ MG",
"55433878", "Londrina\ \-\ PR",
"55353371", "Passa\ Quatro\ \-\ MG",
"55143491", "Tupã\ \-\ SP",
"55963083", "Macapá\ \-\ AP",
"55893547", "São\ Miguel\ do\ Fidalgo\ \-\ PI",
"55373334", "Piracema\ \-\ MG",
"55833310", "Campina\ Grande\ \-\ PB",
"55193023", "Rio\ Claro\ \-\ SP",
"55753526", "Maragogipe\ \-\ BA",
"55163256", "Santa\ Ernestina\ \-\ SP",
"5563321", "Palmas\ \-\ TO",
"55513690", "Rio\ Grande\ do\ Sul",
"5515341", "Sorocaba\ \-\ SP",
"55143252", "Pederneiras\ \-\ SP",
"55793314", "Itabi\ \-\ SE",
"55623942", "Goiânia\ \-\ GO",
"55623558", "Goiânia\ \-\ GO",
"55664141", "Rondonópolis\ \-\ MT",
"55493453", "Peritiba\ \-\ SC",
"55473366", "Balneário\ Camboriú\ \-\ SC",
"55533035", "Rio\ Grande\ \-\ RS",
"55123512", "São\ José\ dos\ Campos\ \-\ SP",
"55613332", "Recanto\ das\ Emas\ \-\ DF",
"55873793", "Calçado\ \-\ PE",
"55173813", "Jaci\ \-\ SP",
"55433573", "Guapirama\ \-\ PR",
"55843436", "São\ Vicente\ \-\ RN",
"55193642", "Águas\ da\ Prata\ \-\ SP",
"55753452", "Itatim\ \-\ BA",
"55222783", "Italva\ \-\ RJ",
"55633540", "Monte\ do\ Carmo\ \-\ TO",
"55163722", "Franca\ \-\ SP",
"55312103", "Belo\ Horizonte\ \-\ MG",
"55483623", "Capivari\ de\ Baixo\ \-\ SC",
"55213691", "Japeri\ \-\ RJ",
"55163398", "Fazenda\ Babilônia\ \-\ SP",
"55123108", "Aparecida\ \-\ SP",
"55633493", "Palmeirante\ \-\ TO",
"55713682", "Bom\ Despacho\ \-\ BA",
"55143583", "Balbinos\ \-\ SP",
"55153293", "Sorocaba\ \-\ SP",
"55553242", "Santana\ do\ Livramento\ \-\ RS",
"55163204", "Jaboticabal\ \-\ SP",
"55333611", "Águas\ Formosas\ \-\ MG",
"55773612", "Barreiras\ \-\ BA",
"55833449", "Riacho\ dos\ Cavalos\ \-\ PB",
"55983352", "Vitória\ do\ Mearim\ \-\ MA",
"55513056", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55893568", "Palmeira\ do\ Piauí\ \-\ PI",
"55173344", "Bebedouro\ \-\ SP",
"55543733", "Caxias\ do\ Sul\ \-\ RS",
"55343328", "Campo\ Florido\ \-\ MG",
"55713177", "Salvador\ \-\ BA",
"557133", "Salvador\ \-\ BA",
"55123962", "Jacareí\ \-\ SP",
"55833217", "Santa\ Rita\ \-\ PB",
"55114777", "Cotia\ \-\ SP",
"55223066", "Nova\ Friburgo\ \-\ RJ",
"55173848", "Gastão\ Vidigal\ \-\ SP",
"55313402", "Nova\ Lima\ \-\ MG",
"55473406", "Balneário\ Camboriú\ \-\ SC",
"55463538", "Salto\ do\ Lontra\ \-\ PR",
"55623351", "Campos\ Verdes\ \-\ GO",
"55843299", "Coronel\ Ezequiel\ \-\ RN",
"55193797", "Campinas\ \-\ SP",
"55843241", "Canguaretama\ \-\ RN",
"55843634", "Ceará\-Mirim\ \-\ RN",
"55313663", "Pedro\ Leopoldo\ \-\ MG",
"55613633", "Padre\ Bernardo\ \-\ GO",
"55133387", "Guarujá\ \-\ SP",
"55433132", "Cornélio\ Procópio\ \-\ PR",
"55343824", "Lagoa\ Formosa\ \-\ MG",
"55443270", "Uniflor\ \-\ PR",
"55813631", "Timbaúba\ \-\ PE",
"55733243", "Floresta\ Azul\ \-\ BA",
"55983363", "Morros\ \-\ MA",
"55383799", "Curvelo\ \-\ MG",
"5596322", "Macapá\ \-\ AP",
"55663569", "Porto\ Alegre\ do\ Norte\ \-\ MT",
"55413971", "Matinhos\ \-\ PR",
"55313237", "Belo\ Horizonte\ \-\ MG",
"55115818", "São\ Paulo\ \-\ SP",
"55383741", "Pirapora\ \-\ MG",
"551138", "São\ Paulo\ \-\ SP",
"5594", "Pará",
"55823524", "Feira\ Grande\ \-\ AL",
"55813735", "São\ Bento\ do\ Una\ \-\ PE",
"55673522", "Três\ Lagoas\ \-\ MS",
"55313330", "Belo\ Horizonte\ \-\ MG",
"55113425", "Diadema\ \-\ SP",
"55623661", "Goiânia\ \-\ GO",
"55833384", "Pocinhos\ \-\ PB",
"55922121", "Manaus\ \-\ AM",
"55112707", "São\ Paulo\ \-\ SP",
"55883421", "Aracati\ \-\ CE",
"55193814", "Mogi\ Mirim\ \-\ SP",
"55753602", "Feira\ de\ Santana\ \-\ BA",
"55983653", "Santa\ Inês\ \-\ MA",
"55123527", "Pindamonhangaba\ \-\ SP",
"55833275", "Serraria\ \-\ PB",
"55112532", "São\ Paulo\ \-\ SP",
"55114715", "Alumínio\ \-\ SP",
"55143263", "Lençóis\ Paulista\ \-\ SP",
"55713115", "Salvador\ \-\ BA",
"55313524", "Belo\ Horizonte\ \-\ MG",
"55273733", "Brejetuba\ \-\ ES",
"55114103", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55483322", "Florianópolis\ \-\ SC",
"55423301", "Ponta\ Grossa\ \-\ PR",
"55673456", "Nova\ Alvorada\ do\ Sul\ \-\ MS",
"55173489", "Brasitânia\ \-\ SP",
"55114446", "Cajamar\ \-\ SP",
"55183277", "Sandovalina\ \-\ SP",
"55693322", "Vilhena\ \-\ RO",
"55193053", "Leme\ \-\ SP",
"55493278", "Urubici\ \-\ SC",
"55353865", "Cana\ Verde\ \-\ MG",
"55623528", "Caturaí\ \-\ GO",
"55623099", "Anápolis\ \-\ GO",
"5544", "Paraná",
"55793341", "Aquidabã\ \-\ SE",
"55843532", "Lajes\ \-\ RN",
"55143222", "Bauru\ \-\ SP",
"55193030", "Vinhedo\ \-\ SP",
"55133299", "Santos\ \-\ SP",
"55683462", "Tarauacá\ \-\ AC",
"55213724", "Rio\ de\ Janeiro\ \-\ RJ",
"55543902", "Passo\ Fundo\ \-\ RS",
"5571324", "Salvador\ \-\ BA",
"55163752", "Aramina\ \-\ SP",
"55823622", "São\ José\ da\ Tapera\ \-\ AL",
"55634052", "Palmas\ \-\ TO",
"55843387", "Riacho\ de\ Santana\ \-\ RN",
"55633376", "Barrolândia\ \-\ TO",
"55753422", "Alagoinhas\ \-\ BA",
"55833263", "Lagoa\ de\ Dentro\ \-\ PB",
"55212742", "Teresópolis\ \-\ RJ",
"55114812", "Campo\ Limpo\ Paulista\ \-\ SP",
"55143275", "Paulistânia\ \-\ SP",
"55222556", "São\ Sebastião\ do\ Alto\ \-\ RJ",
"55333231", "Itanhomi\ \-\ MG",
"55153461", "Porto\ Feliz\ \-\ SP",
"55213202", "Rio\ de\ Janeiro\ \-\ RJ",
"55483653", "Rio\ Fortuna\ \-\ SC",
"55983322", "Boa\ Vista\ do\ Gurupi\ \-\ MA",
"55923301", "Manaus\ \-\ AM",
"55553338", "Nova\ Ramada\ \-\ RS",
"55123842", "Ubatuba\ \-\ SP",
"55173543", "Novo\ Horizonte\ \-\ SP",
"55633388", "Santa\ Rosa\ do\ Tocantins\ \-\ TO",
"55173311", "Catanduva\ \-\ SP",
"55753475", "Porto\ de\ Sauipe\ \-\ BA",
"55313771", "Sete\ Lagoas\ \-\ MG",
"55482102", "Criciúma\ \-\ SC",
"55313622", "Vespasiano\ \-\ MG",
"55713264", "Salvador\ \-\ BA",
"55473626", "São\ Bento\ do\ Sul\ \-\ SC",
"55553746", "Seberi\ \-\ RS",
"55714101", "Salvador\ \-\ BA",
"55513658", "Charqueadas\ \-\ RS",
"55193539", "Ajapi\ \-\ SP",
"55473367", "Balneário\ Camboriú\ \-\ SC",
"55453249", "Anahy\ \-\ PR",
"55313835", "Itabira\ \-\ MG",
"55323721", "Muriaé\ \-\ MG",
"55413584", "Curitiba\ \-\ PR",
"55813625", "Goiana\ \-\ PE",
"55843437", "Lagoa\ Nova\ \-\ RN",
"55883544", "Farias\ Brito\ \-\ CE",
"55114308", "Diadema\ \-\ SP",
"55123602", "Taubaté\ \-\ SP",
"55183621", "Araçatuba\ \-\ SP",
"55114639", "Poá\ \-\ SP",
"55163660", "Batatais\ \-\ SP",
"55543322", "Quinze\ de\ Novembro\ \-\ RS",
"55163257", "Cândido\ Rodrigues\ \-\ SP",
"55113184", "Osasco\ \-\ SP",
"55113559", "São\ Paulo\ \-\ SP",
"55713025", "Salvador\ \-\ BA",
"55813619", "Fernando\ de\ Noronha\ \-\ PE",
"55313499", "Minas\ Gerais",
"55313441", "Minas\ Gerais",
"55114255", "Mogi\ das\ Cruzes\ \-\ SP",
"55513057", "Montenegro\ \-\ RS",
"55273317", "Vitória\ \-\ ES",
"55883435", "Potiretama\ \-\ CE",
"55513368", "Rio\ Grande\ do\ Sul",
"55543375", "Erval\ Grande\ \-\ RS",
"55863295", "São\ Félix\ do\ Piauí\ \-\ PI",
"55713176", "Salvador\ \-\ BA",
"55493548", "Vargem\ Bonita\ \-\ SC",
"55633438", "Recursolândia\ \-\ TO",
"55493021", "Lages\ \-\ SC",
"55813721", "Caruaru\ \-\ PE",
"55423618", "Virmond\ \-\ PR",
"55113431", "Barueri\ \-\ SP",
"55543284", "Caxias\ do\ Sul\ \-\ RS",
"55993567", "São\ João\ do\ Soter\ \-\ MA",
"55753699", "Saubara\ \-\ BA",
"55753641", "Valença\ \-\ BA",
"55242263", "Paraíba\ do\ Sul\ \-\ RJ",
"55643565", "Itumbiara\ \-\ GO",
"55753234", "Nova\ Fátima\ \-\ BA",
"55863254", "Assunção\ do\ Piauí\ \-\ PI",
"55193451", "Limeira\ \-\ SP",
"55223205", "Saquarema\ \-\ RJ",
"55613578", "Brasília\ \-\ DF",
"55883642", "Moraújo\ \-\ CE",
"55542102", "Bento\ Gonçalves\ \-\ RS",
"55323574", "Tocantins\ \-\ MG",
"5551351", "Rio\ Grande\ do\ Sul",
"55313507", "Belo\ Horizonte\ \-\ MG",
"55133202", "Santos\ \-\ SP",
"55473348", "Itajaí\ \-\ SC",
"55242222", "Petrópolis\ \-\ RJ",
"55183918", "Presidente\ Prudente\ \-\ SP",
"55683548", "Assis\ Brasil\ \-\ AC",
"55353267", "Paraguaçu\ \-\ MG",
"554133", "Curitiba\ \-\ PR",
"55793302", "Aracaju\ \-\ SE",
"55114826", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55313732", "Congonhas\ \-\ MG",
"55753680", "Rafael\ Jambeiro\ \-\ BA",
"55173265", "José\ Bonifácio\ \-\ SP",
"55833545", "São\ Francisco\ \-\ PB",
"55773656", "Brejolândia\ \-\ BA",
"55183875", "Santa\ Mercedes\ \-\ SP",
"55673245", "Anastácio\ \-\ MS",
"55443540", "Bragantina\ \-\ PR",
"55513793", "Venâncio\ Aires\ \-\ RS",
"55873939", "Flores\ \-\ PE",
"55153022", "Tatuí\ \-\ SP",
"55653353", "Acorizal\ \-\ MT",
"55713450", "Salvador\ \-\ BA",
"55493567", "Caçador\ \-\ SC",
"55853351", "Trairi\ \-\ CE",
"55623589", "Goiânia\ \-\ GO",
"55483902", "Criciúma\ \-\ SC",
"55643573", "Itumbiara\ \-\ GO",
"55893546", "Bertolínia\ \-\ PI",
"55333225", "Governador\ Valadares\ \-\ MG",
"55713433", "Salvador\ \-\ BA",
"55213634", "Rio\ Bonito\ \-\ RJ",
"55183822", "Dracena\ \-\ SP",
"55693316", "Vilhena\ \-\ RO",
"55543363", "Constantina\ \-\ RS",
"55183401", "Valparaíso\ \-\ SP",
"55313480", "Minas\ Gerais",
"55793453", "Moita\ Bonita\ \-\ SE",
"55833434", "Guarabira\ \-\ PB",
"55733573", "Prado\ \-\ BA",
"55883511", "Juazeiro\ do\ Norte\ \-\ CE",
"55213809", "Rio\ de\ Janeiro\ \-\ RJ",
"55813655", "São\ Vicente\ Ferrer\ \-\ PE",
"55163831", "Guará\ \-\ SP",
"55163982", "Serra\ Azul\ \-\ SP",
"55323751", "Tombos\ \-\ MG",
"55773454", "Caetité\ \-\ BA",
"55373015", "Divinópolis\ \-\ MG",
"55513628", "Maquiné\ \-\ RS",
"55623335", "Vianópolis\ \-\ GO",
"55323365", "Santa\ Bárbara\ do\ Tugúrio\ \-\ MG",
"55543352", "São\ José\ do\ Ouro\ \-\ RS",
"55673412", "Douradina\ \-\ MS",
"55813000", "Recife\ \-\ PE",
"55493700", "Chapecó\ \-\ SC",
"55843386", "Tenente\ Ananias\ \-\ RN",
"55272102", "Colatina\ \-\ ES",
"55115111", "São\ Paulo\ \-\ SP",
"55183651", "Avanhandava\ \-\ SP",
"55633377", "Aliança\ do\ Tocantins\ \-\ TO",
"55113515", "São\ Paulo\ \-\ SP",
"55963325", "Cutias\ \-\ AP",
"55192516", "Indaiatuba\ \-\ SP",
"55183276", "Piquerobi\ \-\ SP",
"55343411", "Iturama\ \-\ MG",
"55773495", "Caetité\ \-\ BA",
"55843691", "Lajes\ Pintadas\ \-\ RN",
"55112892", "São\ Paulo\ \-\ SP",
"55122123", "Taubaté\ \-\ SP",
"55413383", "São\ José\ dos\ Pinhais\ \-\ PR",
"55313128", "Jaboticatubas\ \-\ MG",
"55313414", "Minas\ Gerais",
"55353332", "São\ Lourenço\ \-\ MG",
"55653362", "Várzea\ Grande\ \-\ MT",
"55843378", "São\ Francisco\ do\ Oeste\ \-\ RN",
"55833636", "Frei\ Martinho\ \-\ PB",
"55313760", "Minas\ Gerais",
"55423238", "Ponta\ Grossa\ \-\ PR",
"55473627", "Canoinhas\ \-\ SC",
"55553747", "Boa\ Vista\ das\ Missões\ \-\ RS",
"55553525", "Humaitá\ \-\ RS",
"55153342", "Sorocaba\ \-\ SP",
"55813751", "Frei\ Miguelinho\ \-\ PE",
"55853014", "Maracanaú\ \-\ CE",
"55183361", "Paraguaçu\ Paulista\ \-\ SP",
"55753614", "Feira\ de\ Santana\ \-\ BA",
"55223013", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55143815", "Botucatu\ \-\ SP",
"5521388", "Rio\ de\ Janeiro\ \-\ RJ",
"55114272", "Santana\ de\ Parnaíba\ \-\ SP",
"55193802", "Holambra\ \-\ SP",
"55383254", "Itacambira\ \-\ MG",
"55323694", "Leopoldina\ \-\ MG",
"55183288", "Rosana\ \-\ SP",
"55673479", "Sete\ Quedas\ \-\ MS",
"55413031", "Araucária\ \-\ PR",
"55242491", "Vassouras\ \-\ RJ",
"55693733", "Porto\ Velho\ \-\ RO",
"55273322", "Vitória\ \-\ ES",
"55543042", "Farroupilha\ \-\ RS",
"55242252", "Três\ Rios\ \-\ RJ",
"55313236", "Belo\ Horizonte\ \-\ MG",
"55512139", "Porto\ Alegre\ \-\ RS",
"55193601", "Americana\ \-\ SP",
"55112754", "São\ Paulo\ \-\ SP",
"55543210", "Passo\ Fundo\ \-\ RS",
"55193796", "Campinas\ \-\ SP",
"55653617", "Cuiabá\ \-\ MT",
"55633359", "São\ Valério\ da\ Natividade\ \-\ TO",
"55443810", "Campo\ Mourão\ \-\ PR",
"55223854", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55133386", "Guarujá\ \-\ SP",
"55112378", "Mogi\ das\ Cruzes\ \-\ SP",
"55773626", "Wanderley\ \-\ BA",
"55323373", "São\ João\ Del\ Rei\ \-\ MG",
"55114468", "Santo\ André\ \-\ SP",
"55853321", "Guaramiranga\ \-\ CE",
"5574", "Bahia",
"55193705", "Campinas\ \-\ SP",
"55493341", "Jupiá\ \-\ SC",
"55513561", "Estância\ Velha\ \-\ RS",
"55743669", "Várzea\ da\ Roça\ \-\ BA",
"55673457", "Itaporã\ \-\ MS",
"55193385", "Campinas\ \-\ SP",
"55913031", "Ananindeua\ \-\ PA",
"5563", "Tocantins",
"55553201", "Santo\ Ângelo\ \-\ RS",
"55893442", "Alagoinha\ do\ Piauí\ \-\ PI",
"55133378", "Cubatão\ \-\ SP",
"55333294", "Nacip\ Raydan\ \-\ MG",
"55733285", "Potiraguá\ \-\ BA",
"55513408", "Rio\ Grande\ do\ Sul",
"55423643", "Nova\ Tebas\ \-\ PR",
"5512312", "Guaratinguetá\ \-\ SP",
"55913485", "Tracuateua\ \-\ PA",
"55313577", "Minas\ Gerais",
"55133272", "Santos\ \-\ SP",
"55114892", "Bragança\ Paulista\ \-\ SP",
"55973415", "Benjamin\ Constant\ \-\ AM",
"55283525", "Jaciguá\ \-\ ES",
"55213644", "Teresópolis\ \-\ RJ",
"55513582", "Novo\ Hamburgo\ \-\ RS",
"55163209", "Jaboticabal\ \-\ SP",
"55333202", "Governador\ Valadares\ \-\ MG",
"55833444", "São\ Bento\ \-\ PB",
"55113507", "São\ Paulo\ \-\ SP",
"55993538", "Açailândia\ \-\ MA",
"55773201", "Vitória\ da\ Conquista\ \-\ BA",
"55633467", "Presidente\ Kennedy\ \-\ TO",
"55173349", "Turvínia\ \-\ SP",
"55153267", "Capela\ do\ Alto\ \-\ SP",
"55114069", "Diadema\ \-\ SP",
"55873991", "Vermelho\ \-\ PE",
"5549322", "Lages\ \-\ SC",
"55274102", "Serra\ \-\ ES",
"55513337", "Rio\ Grande\ do\ Sul",
"55893536", "Flores\ do\ Piauí\ \-\ PI",
"55913014", "Ananindeua\ \-\ PA",
"55212675", "Duque\ de\ Caxias\ \-\ RJ",
"55443553", "Janiópolis\ \-\ PR",
"55353022", "Pouso\ Alegre\ \-\ MG",
"55313742", "Ouro\ Branco\ \-\ MG",
"55484007", "Florianópolis\ \-\ SC",
"55193483", "São\ Pedro\ \-\ SP",
"55323556", "São\ Geraldo\ \-\ MG",
"55653247", "Reserva\ do\ Cabaçal\ \-\ MT",
"55793319", "Gracho\ Cardoso\ \-\ SE",
"55513253", "Rio\ Grande\ do\ Sul",
"55833535", "São\ João\ do\ Rio\ do\ Peixe\ \-\ PB",
"55383822", "Janaúba\ \-\ MG",
"55133219", "Santos\ \-\ SP",
"55212771", "Duque\ de\ Caxias\ \-\ RJ",
"55353643", "Piranguçu\ \-\ MG",
"55883632", "Viçosa\ do\ Ceará\ \-\ CE",
"55773674", "Ibipitanga\ \-\ BA",
"55323422", "Cataguases\ \-\ MG",
"55333724", "Divisópolis\ \-\ MG",
"55813475", "Recife\ \-\ PE",
"55323463", "Volta\ Grande\ \-\ MG",
"55753631", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55183702", "Andradina\ \-\ SP",
"55123672", "Tremembé\ \-\ SP",
"55373273", "Onça\ de\ Pitangui\ \-\ MG",
"55513766", "Bom\ Retiro\ do\ Sul\ \-\ RS",
"55173203", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55383621", "Januária\ \-\ MG",
"55222735", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55193894", "Indaiatuba\ \-\ SP",
"55513684", "Tramandaí\ \-\ RS",
"55753244", "Conceição\ da\ Feira\ \-\ BA",
"55473084", "Jaraguá\ do\ Sul\ \-\ SC",
"55163511", "Sertãozinho\ \-\ SP",
"55443011", "Maringá\ \-\ PR",
"55163343", "Ibaté\ \-\ SP",
"55312571", "Betim\ \-\ MG",
"55923213", "Manaus\ \-\ AM",
"55943324", "Marabá\ \-\ PA",
"55843272", "Parnamirim\ \-\ RN",
"55313559", "Ouro\ Preto\ \-\ MG",
"55193855", "Socorro\ \-\ SP",
"55313184", "Itaguara\ \-\ MG",
"55113158", "São\ Paulo\ \-\ SP",
"55113441", "São\ Paulo\ \-\ SP",
"55963423", "Calçoene\ \-\ AP",
"55863276", "Piripiri\ \-\ PI",
"55112501", "São\ Paulo\ \-\ SP",
"55153248", "Ibiúna\ \-\ SP",
"55163797", "Ribeirão\ Preto\ \-\ SP",
"55633448", "Babaçulândia\ \-\ TO",
"55543396", "Santo\ Expedito\ do\ Sul\ \-\ RS",
"55694007", "Porto\ Velho\ \-\ RO",
"55493538", "Ibicaré\ \-\ SC",
"55853031", "Fortaleza\ \-\ CE",
"55273136", "Cariacica\ \-\ ES",
"55114706", "Barueri\ \-\ SP",
"55133856", "Pariquera\-Açu\ \-\ SP",
"55383725", "Morro\ da\ Garça\ \-\ MG",
"55193717", "Limeira\ \-\ SP",
"55653268", "Vale\ de\ São\ Domingos\ \-\ MT",
"55953592", "Pacaraima\ \-\ RR",
"55383547", "Serra\ Azul\ de\ Minas\ \-\ MG",
"55632112", "Araguaína\ \-\ TO",
"55313431", "Belo\ Horizonte\ \-\ MG",
"55613461", "Ceilândia\ \-\ DF",
"55343859", "Patos\ de\ Minas\ \-\ MG",
"5568322", "Rio\ Branco\ \-\ AC",
"55863288", "Palmeirais\ \-\ PI",
"55453239", "Juvinópolis\ \-\ PR",
"55313845", "Jaguaraçu\ \-\ MG",
"55193549", "Mogi\ Mirim\ \-\ SP",
"55853383", "Maracanaú\ \-\ CE",
"55143535", "Pompéia\ \-\ SP",
"55114649", "Itaquaquecetuba\ \-\ SP",
"55843225", "Genipabu\ \-\ RN",
"55273032", "Vila\ Velha\ \-\ ES",
"55213611", "São\ Gonçalo\ \-\ RJ",
"55283555", "Mimoso\ do\ Sul\ \-\ ES",
"55553366", "Itacurubi\ \-\ RS",
"55143646", "Mineiros\ do\ Tietê\ \-\ SP",
"55893432", "Cajazeiras\ do\ Piauí\ \-\ PI",
"55873869", "Santa\ Maria\ da\ Boa\ Vista\ \-\ PE",
"55193671", "Casa\ Branca\ \-\ SP",
"55813526", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55114571", "São\ Paulo\ \-\ SP",
"55423633", "Mato\ Rico\ \-\ PR",
"55513486", "Morungava\ \-\ RS",
"55813452", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55143389", "Timburi\ \-\ SP",
"55443523", "Campo\ Mourão\ \-\ PR",
"55433312", "Arapongas\ \-\ PR",
"55833297", "Mataraca\ \-\ PB",
"55913528", "Novo\ Progresso\ \-\ PA",
"55213857", "São\ Gonçalo\ \-\ RJ",
"55833390", "Prata\ \-\ PB",
"55213103", "Nova\ Iguaçu\ \-\ RJ",
"55733298", "Prado\ \-\ BA",
"55984141", "São\ Luís\ \-\ MA",
"55443664", "Alto\ Paraíso\ \-\ PR",
"55193775", "Campinas\ \-\ SP",
"55513610", "Rio\ Grande\ do\ Sul",
"55623094", "Aparecida\ de\ Goiânia\ \-\ GO",
"55172137", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55273258", "João\ Neiva\ \-\ ES",
"55433047", "Apucarana\ \-\ PR",
"55543032", "Flores\ da\ Cunha\ \-\ RS",
"55643666", "Portelândia\ \-\ GO",
"55953625", "Boa\ Vista\ \-\ RR",
"55173893", "Palestina\ \-\ SP",
"55553271", "Júlio\ de\ Castilhos\ \-\ RS",
"55613301", "Brasília\ \-\ DF",
"55473242", "Pomerode\ \-\ SC",
"55323452", "Itamarati\ de\ Minas\ \-\ MG",
"55333754", "Cachoeira\ de\ Pajeú\ \-\ MG",
"55513478", "Rio\ Grande\ do\ Sul",
"55313246", "Minas\ Gerais",
"55833389", "Olivedos\ \-\ PB",
"55883660", "Cruz\ \-\ CE",
"55773488", "Correntina\ \-\ BA",
"55473459", "São\ Francisco\ do\ Sul\ \-\ SC",
"55753211", "Feira\ de\ Santana\ \-\ BA",
"5516391", "Ribeirão\ Preto\ \-\ SP",
"55493905", "Chapecó\ \-\ SC",
"55733046", "Jequié\ \-\ BA",
"55323291", "Santa\ Rita\ de\ Jacutinga\ \-\ MG",
"55413041", "Curitiba\ \-\ PR",
"55143297", "Bairro\ de\ Santa\ Izabel\ \-\ SP",
"55313515", "Belo\ Horizonte\ \-\ MG",
"55413099", "Curitiba\ \-\ PR",
"55193819", "Hortolândia\ \-\ SP",
"55193825", "Indaiatuba\ \-\ SP",
"55313529", "Betim\ \-\ MG",
"55553737", "Vicente\ Dutra\ \-\ RS",
"55943778", "Vila\ Residencial\ de\ Tucuruí\ \-\ PA",
"55913765", "Salvaterra\ \-\ PA",
"55173484", "Monções\ \-\ SP",
"55143411", "Jaú\ \-\ SP",
"55113414", "Itu\ \-\ SP",
"55843294", "São\ José\ do\ Campestre\ \-\ RN",
"55383755", "Morada\ Nova\ de\ Minas\ \-\ MG",
"55443562", "Araruna\ \-\ PR",
"5553322", "Pelotas\ \-\ RS",
"55773476", "Abaíra\ \-\ BA",
"55983397", "Turiaçu\ \-\ MA",
"55123655", "Caçapava\ \-\ SP",
"55673409", "Naviraí\ \-\ MS",
"55473531", "Rio\ do\ Sul\ \-\ SC",
"55313697", "Bairro\ Eldorado\ \-\ Sete\ Lagoas\ MG",
"55484141", "Florianópolis\ \-\ SC",
"55913823", "Americano\ \-\ PA",
"55913661", "Oeiras\ do\ Pará\ \-\ PA",
"55943786", "Breu\ Branco\ \-\ PA",
"55823529", "Arapiraca\ \-\ AL",
"55843255", "Senador\ Elói\ de\ Souza\ \-\ RN",
"55663564", "Confresa\ \-\ MT",
"55193872", "Cosmópolis\ \-\ SP",
"55114202", "Carapicuíba\ \-\ SP",
"55433906", "Rolândia\ \-\ PR",
"55793045", "Aracaju\ \-\ SE",
"55515", "Rio\ Grande\ do\ Sul",
"55123682", "Taubaté\ \-\ SP",
"55923184", "Manaus\ \-\ AM",
"55353236", "São\ Bento\ Abade\ \-\ MG",
"55653266", "Pontes\ e\ Lacerda\ \-\ MT",
"55693445", "São\ Felipe\ do\ Oeste\ \-\ RO",
"55433535", "Jaguariaíva\ \-\ PR",
"55213039", "Nilópolis\ \-\ RJ",
"55273138", "Serra\ \-\ ES",
"55114708", "Mairinque\ \-\ SP",
"55513674", "Tavares\ \-\ RS",
"55883569", "Deputado\ Irapuan\ Pinheiro\ \-\ CE",
"55673687", "Miranda\ \-\ MS",
"55453264", "Medianeira\ \-\ PR",
"55613617", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55843282", "Santo\ Antônio\ \-\ RN",
"55454101", "Cascavel\ \-\ PR",
"55613506", "Brasília\ \-\ DF",
"55753345", "Nova\ Redenção\ \-\ BA",
"55483632", "Tubarão\ \-\ SC",
"55213787", "Seropédica\ \-\ RJ",
"55183325", "Assis\ \-\ SP",
"55433444", "Arapuã\ \-\ PR",
"55693534", "Alto\ Paraíso\ \-\ RO",
"55733551", "Aurelino\ Leal\ \-\ BA",
"55663421", "Rondonópolis\ \-\ MT",
"55413556", "São\ José\ dos\ Pinhais\ \-\ PR",
"55513768", "Rio\ Grande\ do\ Sul",
"5531349", "Belo\ Horizonte\ \-\ MG",
"55273717", "Colatina\ \-\ ES",
"55613595", "Sobradinho\ \-\ DF",
"55823620", "Dois\ Riachos\ \-\ AL",
"55753420", "Entre\ Rios\ \-\ BA",
"55153246", "Cesário\ Lange\ \-\ SP",
"55543398", "Charrua\ \-\ RS",
"55633446", "Sítio\ Novo\ do\ Tocantins\ \-\ TO",
"5564392", "Itumbiara\ \-\ GO",
"55493536", "Salto\ Veloso\ \-\ SC",
"55613554", "Brasília\ \-\ DF",
"55843553", "Jandaíra\ \-\ RN",
"5571301", "Salvador\ \-\ BA",
"55853373", "Acarape\ \-\ CE",
"5519353", "Rio\ Claro\ \-\ SP",
"55193032", "Campinas\ \-\ SP",
"553139", "Minas\ Gerais",
"55653371", "Nova\ Mutum\ \-\ MT",
"55373426", "Campos\ Altos\ \-\ MG",
"55333581", "Nova\ Módica\ \-\ MG",
"5577308", "Vitória\ da\ Conquista\ \-\ BA",
"5521329", "Rio\ de\ Janeiro\ \-\ RJ",
"55273752", "Nova\ Venécia\ \-\ ES",
"55123159", "Lorena\ \-\ SP",
"55322101", "Juiz\ de\ Fora\ \-\ MG",
"55142107", "Bauru\ \-\ SP",
"55443219", "Maringá\ \-\ PR",
"55313332", "Minas\ Gerais",
"55613362", "Guará\ \-\ DF",
"55663601", "Nova\ Fronteira\ \-\ MT",
"55613190", "Brasília\ \-\ DF",
"55473336", "Blumenau\ \-\ SC",
"55483534", "Santa\ Rosa\ do\ Sul\ \-\ SC",
"55443447", "Alto\ Paraná\ \-\ PR",
"55192533", "Piracicaba\ \-\ SP",
"55212685", "Mangaratiba\ \-\ RJ",
"55173251", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55243335", "Rio\ Claro\ \-\ RJ",
"55812101", "Recife\ \-\ PE",
"55843011", "Natal\ \-\ RN",
"55193473", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55793224", "Aracaju\ \-\ SE",
"55993536", "Governador\ Edison\ Lobão\ \-\ MA",
"55553027", "Santa\ Maria\ \-\ RS",
"55513747", "Arroio\ do\ Tigre\ \-\ RS",
"55833613", "Campina\ Grande\ \-\ PB",
"55853365", "Canindé\ \-\ CE",
"55913556", "Senador\ José\ Porfírio\ \-\ PA",
"55663385", "Nova\ Brasilândia\ \-\ MT",
"55733013", "Teixeira\ de\ Freitas\ \-\ BA",
"55114034", "Bragança\ Paulista\ \-\ SP",
"55893538", "Colônia\ do\ Gurguéia\ \-\ PI",
"55453031", "Foz\ do\ Iguaçu\ \-\ PR",
"55823332", "Maceió\ \-\ AL",
"55773684", "Roda\ Velha\ \-\ BA",
"55212301", "Rio\ de\ Janeiro\ \-\ RJ",
"55133324", "Santos\ \-\ SP",
"55443272", "Fênix\ \-\ PR",
"55323351", "Barroso\ \-\ MG",
"55143357", "Óleo\ \-\ SP",
"55833379", "Cacimba\ de\ Dentro\ \-\ PB",
"55813080", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"5532323", "Juiz\ de\ Fora\ \-\ MG",
"55343243", "Amanhece\ \-\ MG",
"55133828", "Registro\ \-\ SP",
"55813661", "Palmares\ \-\ PE",
"55863302", "Teresina\ \-\ PI",
"55773478", "Ribeirão\ do\ Largo\ \-\ BA",
"55163902", "Ribeirão\ Preto\ \-\ SP",
"55843664", "Natal\ \-\ RN",
"55153577", "Barra\ do\ Turvo\ \-\ SP",
"55433162", "Apucarana\ \-\ PR",
"55433066", "Londrina\ \-\ PR",
"55183997", "Taciba\ \-\ SP",
"55643647", "Maurilândia\ \-\ GO",
"55483212", "Florianópolis\ \-\ SC",
"55513133", "Novo\ Hamburgo\ \-\ RS",
"55114493", "Várzea\ Paulista\ \-\ SP",
"55353732", "Ipuiúna\ \-\ MG",
"55212016", "Rio\ de\ Janeiro\ \-\ RJ",
"55663539", "Novo\ Mundo\ \-\ MT",
"55313267", "Belo\ Horizonte\ \-\ MG",
"55993645", "Esperantinópolis\ \-\ MA",
"55753433", "Subaúma\ \-\ BA",
"55553347", "Santa\ Maria\ \-\ RS",
"55623631", "Jataí\ \-\ GO",
"55143667", "Itaju\ \-\ SP",
"55993073", "Imperatriz\ \-\ MA",
"55663451", "Dom\ Aquino\ \-\ MT",
"55373522", "Bom\ Despacho\ \-\ MG",
"55112828", "Santo\ André\ \-\ SP",
"55483279", "Palhoça\ \-\ SC",
"55183355", "Presidente\ Prudente\ \-\ SP",
"55813351", "Recife\ \-\ PE",
"55493432", "Irani\ \-\ SC",
"55633542", "Silvanópolis\ \-\ TO",
"5511352", "São\ Paulo\ \-\ SP",
"55613353", "Taguatinga\ \-\ DF",
"55843354", "Encanto\ \-\ RN",
"55843395", "Almino\ Afonso\ \-\ RN",
"55843523", "Alto\ do\ Rodrigues\ \-\ RN",
"55213448", "Rio\ de\ Janeiro\ \-\ RJ",
"55823267", "Coqueiro\ Seco\ \-\ AL",
"55192119", "Hortolândia\ \-\ SP",
"55643521", "Itumbiara\ \-\ GO",
"55963621", "Laranjal\ do\ Jari\ \-\ AP",
"55743542", "Senhor\ do\ Bonfim\ \-\ BA",
"55513692", "Camaquã\ \-\ RS",
"55193882", "Cosmópolis\ \-\ SP",
"55423246", "Caetano\ Mendes\ \-\ PR",
"55273763", "São\ Mateus\ \-\ ES",
"55313096", "Ipatinga\ \-\ MG",
"55413452", "Matinhos\ \-\ PR",
"55483333", "Florianópolis\ \-\ SC",
"55983212", "São\ Luís\ \-\ MA",
"55273722", "Colatina\ \-\ ES",
"55193681", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55443639", "Umuarama\ \-\ PR",
"55733296", "Medeiros\ Neto\ \-\ BA",
"55733668", "Trancoso\ \-\ BA",
"55173837", "Sebastianópolis\ do\ Sul\ \-\ SP",
"55112523", "São\ Paulo\ \-\ SP",
"55493645", "Guaraciaba\ \-\ SC",
"55913783", "Breves\ \-\ PA",
"55353835", "Cristais\ \-\ MG",
"55413291", "Campo\ Largo\ \-\ PR",
"55463547", "Ampére\ \-\ PR",
"55513476", "Canoas\ \-\ RS",
"55313248", "Belo\ Horizonte\ \-\ MG",
"55193396", "Sumaré\ \-\ SP",
"55112354", "São\ Paulo\ \-\ SP",
"55353441", "Ouro\ Fino\ \-\ MG",
"55753025", "Feira\ de\ Santana\ \-\ BA",
"55143379", "Ribeirão\ do\ Sul\ \-\ SP",
"55833357", "São\ Domingos\ do\ Cariri\ \-\ PB",
"55114145", "Itapevi\ \-\ SP",
"55443255", "Maringá\ \-\ PR",
"55884141", "Juazeiro\ do\ Norte\ \-\ CE",
"55115933", "São\ Paulo\ \-\ SP",
"55643668", "Serranópolis\ \-\ GO",
"55273256", "Aracruz\ \-\ ES",
"55623981", "Aparecida\ de\ Goiânia\ \-\ GO",
"55123115", "Arapeí\ \-\ SP",
"55333261", "Conselheiro\ Pena\ \-\ MG",
"55773262", "Itapetinga\ \-\ BA",
"55153431", "Itararé\ \-\ SP",
"55793254", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55513555", "Rio\ Grande\ do\ Sul",
"55613043", "Brasília\ \-\ DF",
"55813099", "Olinda\ \-\ PE",
"55483081", "Criciúma\ \-\ SC",
"55873834", "Poção\ \-\ PE",
"55193305", "Campinas\ \-\ SP",
"55213890", "Rio\ de\ Janeiro\ \-\ RJ",
"55543717", "Nova\ Prata\ \-\ RS",
"55413070", "Fazenda\ Rio\ Grande\ \-\ PR",
"55483257", "São\ José\ \-\ SC",
"55112664", "Barueri\ \-\ SP",
"55613622", "Luziânia\ \-\ GO",
"55713641", "Catu\ \-\ BA",
"55713699", "Saubara\ \-\ BA",
"55553281", "Caçapava\ do\ Sul\ \-\ RS",
"55743644", "Itaguaçu\ da\ Bahia\ \-\ BA",
"55733205", "Argolo\ \-\ BA",
"55513594", "Novo\ Hamburgo\ \-\ RS",
"55514003", "Porto\ Alegre\ \-\ RS",
"55513488", "Gravataí\ \-\ RS",
"55413721", "Paranaguá\ \-\ PR",
"55513502", "Capão\ da\ Canoa\ \-\ RS",
"55112493", "Atibaia\ \-\ SP",
"55114912", "São\ Paulo\ \-\ SP",
"55753418", "Alagoinhas\ \-\ BA",
"55873964", "Serrolândia\ \-\ PE",
"55114044", "Diadema\ \-\ SP",
"55413672", "Quatro\ Barras\ \-\ PR",
"55193352", "Araras\ \-\ SP",
"55483062", "Florianópolis\ \-\ SC",
"5521375", "São\ João\ de\ Meriti\ \-\ RJ",
"55123014", "Jacareí\ \-\ SP",
"55483435", "Siderópolis\ \-\ SC",
"55823342", "Maceió\ \-\ AL",
"55143218", "Bauru\ \-\ SP",
"55693642", "São\ Miguel\ do\ Guaporé\ \-\ RO",
"55463254", "Coronel\ Domingos\ Soares\ \-\ PR",
"55873811", "Jirau\ \-\ PE",
"55623512", "Senador\ Canedo\ \-\ GO",
"5521", "Rio\ de\ Janeiro",
"55553262", "Paraíso\ do\ Sul\ \-\ RS",
"55513737", "Rio\ Grande\ do\ Sul",
"55353529", "Passos\ \-\ MG",
"55833469", "Várzea\ \-\ PB",
"55473346", "Itajaí\ \-\ SC",
"55183916", "Presidente\ Prudente\ \-\ SP",
"55623579", "Goiânia\ \-\ GO",
"55193662", "Caconde\ \-\ SP",
"55313342", "Belo\ Horizonte\ \-\ MG",
"55483544", "Morro\ Grande\ \-\ SC",
"55413625", "Contenda\ \-\ PR",
"55443437", "Amaporã\ \-\ PR",
"55133493", "Praia\ Grande\ \-\ SP",
"55114979", "Santo\ André\ \-\ SP",
"55543421", "Gramado\ \-\ RS",
"55513424", "Rio\ Grande\ do\ Sul",
"55773658", "Ibitiara\ \-\ BA",
"55173695", "Marinópolis\ \-\ SP",
"55313470", "Minas\ Gerais",
"55652121", "Cuiabá\ \-\ MT",
"55683546", "Brasiléia\ \-\ AC",
"55353697", "Poços\ de\ Caldas\ \-\ MG",
"55793547", "Arauá\ \-\ SE",
"55333324", "Vargem\ Alegre\ \-\ MG",
"55543601", "Passo\ Fundo\ \-\ RS",
"55443571", "Luiziana\ \-\ PR",
"55173283", "Jaci\ \-\ SP",
"55493546", "Monte\ Carlo\ \-\ SC",
"55343327", "Conceição\ das\ Alagoas\ \-\ MG",
"55513604", "Rio\ Grande\ do\ Sul",
"55123321", "São\ José\ dos\ Campos\ \-\ SP",
"55183302", "Assis\ \-\ SP",
"55472111", "Blumenau\ \-\ SC",
"55623923", "Goiânia\ \-\ GO",
"55193042", "Piracicaba\ \-\ SP",
"55893567", "Ribeiro\ Gonçalves\ \-\ PI",
"55213974", "Rio\ de\ Janeiro\ \-\ RJ",
"55693544", "Nova\ Mamoré\ \-\ RO",
"55913721", "Castanhal\ \-\ PA",
"55163397", "Araraquara\ \-\ SP",
"5584321", "Natal\ \-\ RN",
"55753269", "Riachão\ do\ Jacuípe\ \-\ BA",
"55123107", "Areias\ \-\ SP",
"55413405", "São\ José\ dos\ Pinhais\ \-\ PR",
"55193623", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55193861", "Mogi\-Guaçu\ \-\ SP",
"55543385", "Tapera\ \-\ RS",
"55173552", "Urupês\ \-\ SP",
"55212730", "Rio\ de\ Janeiro\ \-\ RJ",
"5511349", "São\ Paulo\ \-\ SP",
"55753335", "Andaraí\ \-\ BA",
"55483642", "Gravatal\ \-\ SC",
"55114786", "Taboão\ da\ Serra\ \-\ SP",
"55813682", "Joaquim\ Nabuco\ \-\ PE",
"55713186", "Salvador\ \-\ BA",
"55112884", "Mogi\ das\ Cruzes\ \-\ SP",
"55513656", "Arroio\ dos\ Ratos\ \-\ RS",
"55114664", "Embu\-Guaçu\ \-\ SP",
"55212753", "São\ João\ de\ Meriti\ \-\ RJ",
"55473056", "Balneário\ Camboriú\ \-\ SC",
"55473152", "Gaspar\ Alto\ \-\ SC",
"55433545", "Curiúva\ \-\ PR",
"55693435", "Novo\ Horizonte\ do\ Oeste\ \-\ RO",
"55623557", "Campestre\ de\ Goiás\ \-\ GO",
"55653301", "Chapada\ dos\ Guimarães\ \-\ MT",
"55973346", "Uarini\ \-\ AM",
"55513271", "Novo\ Hamburgo\ \-\ RS",
"55483023", "Palhoça\ \-\ SC",
"55643491", "Ipameri\ \-\ GO",
"55173426", "Votuporanga\ \-\ SP",
"551139", "São\ Paulo\ \-\ SP",
"55793276", "Pirambu\ \-\ SE",
"55114011", "Piracaia\ \-\ SP",
"55452101", "Cascavel\ \-\ PR",
"55743634", "Caldeirão\ Grande\ \-\ BA",
"55222106", "Macaé\ \-\ RJ",
"55713631", "Itaparica\ \-\ BA",
"55813031", "Recife\ \-\ PE",
"55383673", "Guarda\-Mor\ \-\ MG",
"55873844", "São\ José\ do\ Egito\ \-\ PE",
"55613605", "Cidade\ Ocidental\ \-\ GO",
"55463224", "Pato\ Branco\ \-\ PR",
"55843034", "Natal\ \-\ RN",
"5543337", "Londrina\ \-\ PR",
"55183603", "Luiziânia\ \-\ SP",
"55793651", "Salgado\ \-\ SE",
"55733222", "Ilhéus\ \-\ BA",
"55373221", "Divinópolis\ \-\ MG",
"55123862", "São\ Sebastião\ \-\ SP",
"55353559", "Guaxupé\ \-\ MG",
"55513406", "Rio\ Grande\ do\ Sul",
"55173563", "Cajobi\ \-\ SP",
"55423414", "Rio\ da\ Areia\ \-\ PR",
"55114135", "Taboão\ da\ Serra\ \-\ SP",
"55173624", "Jales\ \-\ SP",
"55133261", "Santos\ \-\ SP",
"55353431", "Cambuí\ \-\ MG",
"55115817", "São\ Paulo\ \-\ SP",
"55853463", "Fortaleza\ \-\ CE",
"55313238", "Belo\ Horizonte\ \-\ MG",
"55333523", "Teófilo\ Otoni\ \-\ MG",
"5511263", "São\ Paulo\ \-\ SP",
"55134104", "São\ Vicente\ \-\ SP",
"55793288", "Areia\ Branca\ \-\ SE",
"55273385", "Serra\ \-\ ES",
"55193375", "Piracicaba\ \-\ SP",
"55513495", "Sertão\ Santana\ \-\ RS",
"55773628", "Luis\ Eduardo\ Magalhães\ \-\ BA",
"55443649", "Palotina\ \-\ PR",
"55613381", "Guará\ \-\ DF",
"55513454", "Esteio\ \-\ RS",
"55483343", "São\ José\ \-\ SC",
"55543451", "Bento\ Gonçalves\ \-\ RS",
"5587386", "Petrolina\ \-\ PE",
"55333354", "Bom\ Jesus\ do\ Galho\ \-\ MG",
"55793361", "Amparo\ de\ São\ Francisco\ \-\ SE",
"55323031", "Juiz\ de\ Fora\ \-\ MG",
"55463537", "Boa\ Esperança\ do\ Iguaçu\ \-\ PR",
"55193798", "Campinas\ \-\ SP",
"55613701", "Brasília\ \-\ DF",
"55173847", "Floreal\ \-\ SP",
"55115852", "São\ Paulo\ \-\ SP",
"55123351", "Jacareí\ \-\ SP",
"55133034", "Praia\ Grande\ \-\ SP",
"55543292", "Flores\ da\ Cunha\ \-\ RS",
"55163972", "Bonfim\ Paulista\ \-\ SP",
"55423236", "Ponta\ Grossa\ \-\ PR",
"55813510", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55833309", "São\ José\ dos\ Cordeiros\ \-\ PB",
"55453321", "Cascavel\ \-\ PR",
"55693343", "Corumbiara\ \-\ RO",
"55633387", "Jaú\ do\ Tocantins\ \-\ TO",
"55192102", "Campinas\ \-\ SP",
"55843376", "Viçosa\ \-\ RN",
"55833638", "Nova\ Palmeira\ \-\ PB",
"55743532", "Pilar\ \-\ BA",
"55113633", "São\ Paulo\ \-\ SP",
"55324101", "Barbacena\ \-\ MG",
"55913751", "Abaetetuba\ \-\ PA",
"55823643", "Olho\ d\'Água\ do\ Casado\ \-\ AL",
"55183286", "Anhumas\ \-\ SP",
"55753443", "Crisópolis\ \-\ BA",
"55323264", "Guarará\ \-\ MG",
"55193653", "Aguaí\ \-\ SP",
"55493442", "Concórdia\ \-\ SC",
"55843388", "Major\ Sales\ \-\ RN",
"55913694", "Anapu\ \-\ PA",
"55643637", "Aparecida\ do\ Rio\ Doce\ \-\ GO",
"55733263", "Teixeira\ de\ Freitas\ \-\ BA",
"55113192", "São\ Paulo\ \-\ SP",
"55173522", "Catanduva\ \-\ SP",
"55993635", "Lago\ Verde\ \-\ MA",
"55513626", "Torres\ \-\ RS",
"55353742", "Bandeira\ do\ Sul\ \-\ MG",
"55483030", "Florianópolis\ \-\ SC",
"55853475", "Caucaia\ \-\ CE",
"55943386", "Lindoeste\ \-\ PA",
"55843261", "Maxaranguape\ \-\ RN",
"55623527", "Araçu\ \-\ GO",
"55114282", "São\ Paulo\ \-\ SP",
"5521387", "Rio\ de\ Janeiro\ \-\ RJ",
"55193363", "Paulínia\ \-\ SP",
"55183278", "Caiuá\ \-\ SP",
"55423903", "União\ da\ Vitória\ \-\ PR",
"55673489", "Indápolis\ \-\ MS",
"55493277", "Bom\ Retiro\ \-\ SC",
"55483053", "Tubarão\ \-\ SC",
"55614103", "Brasília\ \-\ DF",
"55923362", "Careiro\ \-\ AM",
"55543343", "Sananduva\ \-\ RS",
"55713625", "Dias\ d\'Ávila\ \-\ BA",
"5522382", "Itaperuna\ \-\ RJ",
"55493719", "Capinzal\ \-\ SC",
"55353472", "Cachoeira\ de\ Minas\ \-\ MG",
"55613577", "Brasília\ \-\ DF",
"55913082", "Belém\ \-\ PA",
"55163396", "Santa\ Lúcia\ \-\ SP",
"55123106", "Silveiras\ \-\ SP",
"5511272", "São\ Paulo\ \-\ SP",
"55114039", "Campo\ Limpo\ Paulista\ \-\ SP",
"55423617", "Santa\ Maria\ do\ Oeste\ \-\ PR",
"55373235", "Pará\ de\ Minas\ \-\ MG",
"55183021", "Birigui\ \-\ SP",
"55493547", "Celso\ Ramos\ \-\ SC",
"55633437", "Cachoeirinha\ \-\ TO",
"55222773", "Macaé\ \-\ RJ",
"55543511", "Vacaria\ \-\ RS",
"55793215", "Aracaju\ \-\ SE",
"55893566", "Redenção\ do\ Gurguéia\ \-\ PI",
"55773689", "Rosário\ \-\ BA",
"55153353", "Votorantim\ \-\ SP",
"55513260", "Rio\ Grande\ do\ Sul",
"55173245", "José\ Bonifácio\ \-\ SP",
"55833565", "João\ Pessoa\ \-\ PB",
"55163258", "Fernando\ Prestes\ \-\ SP",
"55423323", "Ponta\ Grossa\ \-\ PR",
"55153330", "Sorocaba\ \-\ SP",
"55323025", "Juiz\ de\ Fora\ \-\ MG",
"55423554", "Cruz\ Machado\ \-\ PR",
"55663212", "Sorriso\ \-\ MT",
"55354103", "Passos\ \-\ MG",
"55493621", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55433252", "Arapongas\ \-\ PR",
"55114787", "Taboão\ da\ Serra\ \-\ SP",
"55153524", "Itapeva\ \-\ SP",
"55843438", "Tenente\ Laurentino\ Cruz\ \-\ RN",
"55163305", "Araraquara\ \-\ SP",
"55513657", "Vendinha\ \-\ RS",
"55483539", "São\ João\ do\ Sul\ \-\ SC",
"55993547", "São\ Raimundo\ das\ Mangabeiras\ \-\ MA",
"55623463", "Mimoso\ de\ Goiás\ \-\ GO",
"55693539", "Rio\ Crespo\ \-\ RO",
"55212005", "Rio\ de\ Janeiro\ \-\ RJ",
"55643545", "Itumbiara\ \-\ GO",
"55883623", "Barroquinha\ \-\ CE",
"55513736", "Estrêla\ \-\ RS",
"55212633", "Magé\ \-\ RJ",
"55383833", "Jaíba\ \-\ MG",
"55843329", "Felipe\ Guerra\ \-\ RN",
"55222765", "Macaé\ \-\ RJ",
"55833392", "Queimadas\ \-\ PB",
"55613559", "Samambaia\ Sul\ \-\ DF",
"55983451", "Santa\ Rita\ \-\ MA",
"55513348", "Rio\ Grande\ do\ Sul",
"55193902", "Holambra\ \-\ SP",
"55513612", "Doutor\ Ricardo\ \-\ RS",
"55342106", "Patos\ de\ Minas\ \-\ MG",
"5577342", "Vitória\ da\ Conquista\ \-\ BA",
"55163931", "Ribeirão\ Preto\ \-\ SP",
"55222661", "Araruama\ \-\ RJ",
"55993621", "Bacabal\ \-\ MA",
"55923018", "Manaus\ \-\ AM",
"55143886", "Pardinho\ \-\ SP",
"55513679", "Sentinela\ do\ Sul\ \-\ RS",
"55793546", "Umbaúba\ \-\ SE",
"55813433", "Paulista\ \-\ PE",
"55643434", "Cachoeira\ Dourada\ \-\ GO",
"55353696", "Guaxupé\ \-\ MG",
"55183917", "Presidente\ Prudente\ \-\ SP",
"55473347", "Piçarras\ \-\ SC",
"55453269", "Vila\ Nova\ \-\ PR",
"55353701", "Alfenas\ \-\ MG",
"55313508", "Belo\ Horizonte\ \-\ MG",
"55883564", "Cedro\ \-\ CE",
"55423652", "Boa\ Ventura\ de\ São\ Roque\ \-\ PR",
"55113109", "Jundiaí\ \-\ SP",
"55923323", "Pitinga\ \-\ AM",
"55633571", "Palmas\ \-\ TO",
"55893453", "Pio\ Ix\ \-\ PI",
"55113578", "São\ Paulo\ \-\ SP",
"55443436", "Itaúna\ do\ Sul\ \-\ PR",
"55693451", "Pimenta\ Bueno\ \-\ RO",
"55873839", "Alagoinha\ \-\ PE",
"55813094", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55442033", "Palotina\ \-\ PR",
"55713655", "São\ Sebastião\ do\ Passé\ \-\ BA",
"55614501", "Brasília\ \-\ DF",
"55793259", "Aracaju\ \-\ SE",
"55983385", "Bequimão\ \-\ MA",
"55893462", "Oeiras\ \-\ PI",
"55553336", "Catuípe\ \-\ RS",
"55183287", "Campinal\ \-\ SP",
"55513313", "Nova\ Santa\ Rita\ \-\ RS",
"55633691", "Rio\ da\ Conceição\ \-\ TO",
"55923675", "Manaus\ \-\ AM",
"55423663", "Palmeirinha\ \-\ PR",
"55333413", "Paulistas\ \-\ MG",
"55493361", "Chapecó\ \-\ SC",
"55623303", "Montes\ Claros\ de\ Goiás\ \-\ GO",
"55343356", "Nova\ Ponte\ \-\ MG",
"55793635", "Lagarto\ \-\ SE",
"55312", "Minas\ Gerais",
"55983274", "Paço\ do\ Lumiar\ \-\ MA",
"55553748", "Erval\ Seco\ \-\ RS",
"55513541", "Taquara\ \-\ RS",
"55743649", "Uibaí\ \-\ BA",
"55423237", "Piraí\ do\ Sul\ \-\ PR",
"55513599", "Sapiranga\ \-\ RS",
"55543544", "Entre\ Rios\ do\ Sul\ \-\ RS",
"55633386", "Palmeirópolis\ \-\ TO",
"55433275", "Arapongas\ \-\ PR",
"55843377", "Portalegre\ \-\ RN",
"55313685", "Nova\ União\ \-\ MG",
"55143285", "Cabrália\ Paulista\ \-\ SP",
"55973561", "Coari\ \-\ AM",
"55443634", "São\ Jorge\ do\ Patrocínio\ \-\ PR",
"55653052", "Cuiabá\ \-\ MT",
"55853923", "Fortaleza\ \-\ CE",
"55623526", "Goiânia\ \-\ GO",
"55752101", "Feira\ de\ Santana\ \-\ BA",
"55114448", "Cajamar\ \-\ SP",
"55353455", "São\ João\ da\ Mata\ \-\ MG",
"55213540", "Nova\ Iguaçu\ \-\ RJ",
"55643636", "Jataí\ \-\ GO",
"55633378", "Ponte\ Alta\ do\ Tocantins\ \-\ TO",
"55143374", "Caporanga\ \-\ SP",
"55423524", "União\ da\ Vitória\ \-\ PR",
"55115635", "São\ Paulo\ \-\ SP",
"55113371", "São\ Paulo\ \-\ SP",
"55543435", "Boa\ Vista\ do\ Sul\ \-\ RS",
"55343304", "Uberlândia\ \-\ MG",
"55513627", "Imbé\ \-\ RS",
"55153554", "Barra\ do\ Chapéu\ \-\ SP",
"55483274", "Angelina\ \-\ SC",
"5531341", "Belo\ Horizonte\ \-\ MG",
"55883630", "Miraíma\ \-\ CE",
"55133377", "Cubatão\ \-\ SP",
"55843359", "Água\ Nova\ \-\ RN",
"55513407", "Porto\ Alegre\ \-\ RS",
"55883653", "Ibiapina\ \-\ CE",
"55823293", "Paripueira\ \-\ AL",
"55383083", "Montes\ Claros\ \-\ MG",
"55793277", "Carmópolis\ \-\ SE",
"55192114", "Limeira\ \-\ SP",
"55822121", "Maceió\ \-\ AL",
"55183341", "Cândido\ Mota\ \-\ SP",
"55923663", "Manaus\ \-\ AM",
"55423675", "Copel\ \-\ PR",
"5584", "Rio\ Grande\ do\ Norte",
"55923524", "Urucurituba\ \-\ AM",
"55753321", "Feira\ de\ Santana\ \-\ BA",
"551121", "São\ Paulo\ \-\ SP",
"55933222", "Santarém\ \-\ PA",
"55833374", "Nova\ Floresta\ \-\ PB",
"5586322", "Teresina\ \-\ PI",
"55443532", "Moreira\ Sales\ \-\ PR",
"55463536", "Dois\ Vizinhos\ \-\ PR",
"55653342", "Denise\ \-\ MT",
"55173846", "Mira\ Estrela\ \-\ SP",
"55833285", "Gurinhém\ \-\ PB",
"55793442", "Malhador\ \-\ SE",
"55613697", "Taboquinha\ \-\ GO",
"55115816", "São\ Paulo\ \-\ SP",
"55663534", "Terra\ Nova\ do\ Norte\ \-\ MT",
"55693421", "Ji\-Paraná\ \-\ RO",
"55323345", "Alto\ Rio\ Doce\ \-\ MG",
"55513580", "Novo\ Hamburgo\ \-\ RS",
"55113112", "São\ Paulo\ \-\ SP",
"55384009", "Montes\ Claros\ \-\ MG",
"55893440", "Ipiranga\ do\ Piauí\ \-\ PI",
"55313865", "Coronel\ Fabriciano\ \-\ MG",
"55473337", "Blumenau\ \-\ SC",
"55873201", "Petrolina\ \-\ PE",
"55114669", "Itapecerica\ da\ Serra\ \-\ SP",
"55663511", "Sinop\ \-\ MT",
"55443446", "Paranavaí\ \-\ PR",
"55433551", "Ribeirão\ do\ Pinhal\ \-\ PR",
"55273227", "Vitória\ \-\ ES",
"55314", "Minas\ Gerais",
"55163941", "Ribeirão\ Preto\ \-\ SP",
"55543279", "Linha\ Oitenta\ \-\ RS",
"55162102", "Ribeirão\ Preto\ \-\ SP",
"55142106", "Bauru\ \-\ SP",
"55643444", "Buriti\ Alegre\ \-\ GO",
"55383567", "Varjão\ de\ Minas\ \-\ MG",
"55194007", "Campinas\ \-\ SP",
"55133448", "Mongaguá\ \-\ SP",
"55513609", "Rio\ Grande\ do\ Sul",
"55413579", "Curitiba\ \-\ PR",
"55713504", "Lauro\ de\ Freitas\ \-\ BA",
"55213828", "Rio\ de\ Janeiro\ \-\ RJ",
"55623625", "Aparecida\ de\ Goiânia\ \-\ GO",
"55313723", "Casa\ Grande\ \-\ MG",
"55153268", "Boituva\ \-\ SP",
"55733535", "Jitaúna\ \-\ BA",
"55633468", "Couto\ de\ Magalhães\ \-\ TO",
"55754101", "Feira\ de\ Santana\ \-\ BA",
"55993537", "Senador\ La\ Roque\ \-\ MA",
"55453345", "Portão\ Ocoi\ \-\ PR",
"55383843", "Novorizonte\ \-\ MG",
"55212643", "Teresópolis\ \-\ RJ",
"55553026", "Santa\ Maria\ \-\ RS",
"55533254", "Cerrito\ \-\ RS",
"55513746", "Rio\ Grande\ do\ Sul",
"55753264", "Riachão\ do\ Jacuípe\ \-\ BA",
"55353622", "Itajubá\ \-\ MG",
"55313578", "Piedade\ dos\ Gerais\ \-\ MG",
"55884102", "Crato\ \-\ CE",
"55673686", "Bonito\ \-\ MS",
"55333315", "Inhapim\ \-\ MG",
"55353663", "Pedralva\ \-\ MG",
"55353821", "Lavras\ \-\ MG",
"55613616", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55483591", "Jacinto\ Machado\ \-\ SC",
"55923020", "Manaus\ \-\ AM",
"55983483", "Magalhães\ de\ Almeida\ \-\ MA",
"55832106", "João\ Pessoa\ \-\ PB",
"55513415", "Canoas\ \-\ RS",
"55243351", "Itatiaia\ \-\ RJ",
"55513429", "Canoas\ \-\ RS",
"55313762", "Conselheiro\ Lafaiete\ \-\ MG",
"55313873", "Matipó\ \-\ MG",
"55353237", "São\ Thomé\ das\ Letras\ \-\ MG",
"55143326", "Ourinhos\ \-\ SP",
"55413614", "Araucária\ \-\ PR",
"55163322", "Araraquara\ \-\ SP",
"55483717", "Florianópolis\ \-\ SC",
"55333329", "Caratinga\ \-\ MG",
"55753031", "Alagoinhas\ \-\ BA",
"55713602", "Candeias\ \-\ BA",
"55813106", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55633447", "São\ Miguel\ do\ Tocantins\ \-\ TO",
"55153247", "Votorantim\ \-\ SP",
"55493537", "Treze\ Tílias\ \-\ SC",
"55114091", "Diadema\ \-\ SP",
"55114049", "Diadema\ \-\ SP",
"55123019", "São\ José\ dos\ Campos\ \-\ SP",
"55123025", "Taubaté\ \-\ SP",
"55543333", "Chapada\ \-\ RS",
"55493382", "Xanxerê\ \-\ SC",
"55213664", "Belford\ Roxo\ \-\ RJ",
"55353524", "São\ João\ Batista\ do\ Glória\ \-\ MG",
"55833464", "Junco\ do\ Seridó\ \-\ PB",
"55673410", "Dourados\ \-\ MS",
"55453055", "Toledo\ \-\ PR",
"55222031", "Saquarema\ \-\ RJ",
"55793432", "Itabaiana\ \-\ SE",
"55513477", "Canoas\ \-\ RS",
"55833356", "Cabaceiras\ \-\ PB",
"55864009", "Teresina\ \-\ PI",
"55313482", "Minas\ Gerais",
"55333377", "São\ João\ do\ Manhuaçu\ \-\ MG",
"55433521", "Londrina\ \-\ PR",
"55273257", "Ibiraçu\ \-\ ES",
"55623365", "Crixás\ \-\ GO",
"55323335", "Piedade\ do\ Rio\ Grande\ \-\ MG",
"55663544", "Sorriso\ \-\ MT",
"55163146", "Itirapuã\ \-\ SP",
"55193743", "Campinas\ \-\ SP",
"55443542", "Campina\ da\ Lagoa\ \-\ PR",
"55163042", "Sertãozinho\ \-\ SP",
"55933067", "Santarém\ \-\ PA",
"55813269", "Recife\ \-\ PE",
"5511472", "Mogi\ das\ Cruzes\ \-\ SP",
"55713452", "Salvador\ \-\ BA",
"55844109", "Mossoró\ \-\ RN",
"55173836", "Cosmorama\ \-\ SP",
"55733297", "Caravelas\ \-\ BA",
"55273081", "Vitória\ \-\ ES",
"55653332", "Nova\ Olímpia\ \-\ MT",
"55673484", "Caarapó\ \-\ MS",
"55673029", "Campo\ Grande\ \-\ MS",
"55643411", "Catalão\ \-\ GO",
"55463546", "Nova\ Esperança\ do\ Sudoeste\ \-\ PR",
"55483256", "Anitápolis\ \-\ SC",
"55112787", "São\ Paulo\ \-\ SP",
"55823482", "Arapiraca\ \-\ AL",
"55733162", "Porto\ Seguro\ \-\ BA",
"55313730", "Minas\ Gerais",
"55753682", "Gavião\ \-\ BA",
"55833298", "Conde\ \-\ PB",
"55663435", "Tesouro\ \-\ MT",
"55313753", "Rio\ Espera\ \-\ MG",
"55833304", "São\ Sebastião\ do\ Umbuzeiro\ \-\ PB",
"55352103", "Pouso\ Alegre\ \-\ MG",
"55543632", "Passo\ Fundo\ \-\ RS",
"55883640", "Alcântaras\ \-\ CE",
"55193955", "Socorro\ \-\ SP",
"55273350", "Vila\ Velha\ \-\ ES",
"55923247", "Manaus\ \-\ AM",
"55533224", "Morro\ Redondo\ \-\ RS",
"55273333", "Vitória\ \-\ ES",
"55413061", "Curitiba\ \-\ PR",
"55242220", "Petrópolis\ \-\ RJ",
"55353851", "Boa\ Esperança\ \-\ MG",
"55183996", "Marabá\ Paulista\ \-\ SP",
"55115645", "São\ Paulo\ \-\ SP",
"55493254", "Ponte\ Alta\ do\ Norte\ \-\ SC",
"55543445", "Fagundes\ Varela\ \-\ RS",
"55213553", "Rio\ de\ Janeiro\ \-\ RJ",
"55313266", "Minas\ Gerais",
"55674001", "Campo\ Grande\ \-\ MS",
"5545357", "Foz\ do\ Iguaçu\ \-\ PR",
"55143356", "Manduri\ \-\ SP",
"55413699", "Almirante\ Tamandaré\ \-\ PR",
"55443644", "São\ Manoel\ do\ Paraná\ \-\ PR",
"55983398", "Cedral\ \-\ MA",
"55513459", "Esteio\ \-\ RS",
"55243321", "Resende\ \-\ RJ",
"55623373", "Jussara\ \-\ GO",
"55933521", "Vila\ Residencial\ Belo\ Monte\ \-\ PA",
"55123971", "São\ Bento\ do\ Sapucaí\ \-\ SP",
"55443231", "Itambé\ \-\ PR",
"55663023", "Rondonópolis\ \-\ MT",
"55163352", "Ibitinga\ \-\ SP",
"55353323", "São\ Vicente\ de\ Minas\ \-\ MG",
"55793645", "Boquim\ \-\ SE",
"55823266", "Satuba\ \-\ AL",
"55713291", "Salvador\ \-\ BA",
"55543534", "Caxias\ do\ Sul\ \-\ RS",
"55553738", "Caiçara\ \-\ RS",
"55423247", "Ivaí\ \-\ PR",
"55743639", "Várzea\ do\ Poço\ \-\ BA",
"55713417", "Salvador\ \-\ BA",
"55143666", "Bocaina\ \-\ SP",
"55143298", "Macatuba\ \-\ SP",
"55153494", "Ibiúna\ \-\ SP",
"55163403", "Franca\ \-\ SP",
"55623592", "Goiânia\ \-\ GO",
"5533", "Minas\ Gerais",
"55313371", "Minas\ Gerais",
"55873891", "Moreilândia\ \-\ PE",
"55873849", "Itaíba\ \-\ PE",
"55123600", "São\ José\ dos\ Campos\ \-\ SP",
"55113301", "São\ Paulo\ \-\ SP",
"55453025", "Foz\ do\ Iguaçu\ \-\ PR",
"55353554", "São\ Pedro\ da\ União\ \-\ MG",
"55163662", "Batatais\ \-\ SP",
"55185821", "Dracena\ \-\ SP",};
my $timezones = {
               '' => [
                       'America/Manaus',
                       'America/Noronha',
                       'America/Rio_Branco',
                       'America/Sao_Paulo'
                     ],
               '1' => [
                        'America/Sao_Paulo'
                      ],
               '2' => [
                        'America/Sao_Paulo'
                      ],
               '3' => [
                        'America/Sao_Paulo'
                      ],
               '4' => [
                        'America/Sao_Paulo'
                      ],
               '50' => [
                         'America/Sao_Paulo'
                       ],
               '51' => [
                         'America/Sao_Paulo'
                       ],
               '53' => [
                         'America/Sao_Paulo'
                       ],
               '54' => [
                         'America/Sao_Paulo'
                       ],
               '55' => [
                         'America/Sao_Paulo'
                       ],
               '553682' => [
                             'America/Manaus'
                           ],
               '61' => [
                         'America/Sao_Paulo'
                       ],
               '62' => [
                         'America/Sao_Paulo'
                       ],
               '63' => [
                         'America/Sao_Paulo'
                       ],
               '64' => [
                         'America/Sao_Paulo'
                       ],
               '65' => [
                         'America/Manaus'
                       ],
               '66' => [
                         'America/Manaus'
                       ],
               '67' => [
                         'America/Manaus'
                       ],
               '673480' => [
                             'America/Sao_Paulo'
                           ],
               '68' => [
                         'America/Rio_Branco'
                       ],
               '69' => [
                         'America/Manaus'
                       ],
               '693527' => [
                             'America/Sao_Paulo'
                           ],
               '7' => [
                        'America/Sao_Paulo'
                      ],
               '8' => [
                        'America/Sao_Paulo'
                      ],
               '812' => [
                          'America/Noronha'
                        ],
               '81300' => [
                            'America/Noronha'
                          ],
               '813013' => [
                             'America/Noronha'
                           ],
               '813016' => [
                             'America/Noronha'
                           ],
               '813017' => [
                             'America/Noronha'
                           ],
               '813018' => [
                             'America/Noronha'
                           ],
               '813022' => [
                             'America/Noronha'
                           ],
               '813024' => [
                             'America/Noronha'
                           ],
               '813027' => [
                             'America/Noronha'
                           ],
               '813029' => [
                             'America/Noronha'
                           ],
               '813042' => [
                             'America/Noronha'
                           ],
               '813043' => [
                             'America/Noronha'
                           ],
               '813044' => [
                             'America/Noronha'
                           ],
               '813047' => [
                             'America/Noronha'
                           ],
               '813054' => [
                             'America/Noronha'
                           ],
               '813056' => [
                             'America/Noronha'
                           ],
               '813057' => [
                             'America/Noronha'
                           ],
               '813058' => [
                             'America/Noronha'
                           ],
               '81306' => [
                            'America/Noronha'
                          ],
               '813070' => [
                             'America/Noronha'
                           ],
               '813085' => [
                             'America/Noronha'
                           ],
               '813098' => [
                             'America/Noronha'
                           ],
               '8131' => [
                           'America/Noronha'
                         ],
               '813200' => [
                             'America/Noronha'
                           ],
               '813206' => [
                             'America/Noronha'
                           ],
               '813208' => [
                             'America/Noronha'
                           ],
               '813209' => [
                             'America/Noronha'
                           ],
               '813210' => [
                             'America/Noronha'
                           ],
               '813211' => [
                             'America/Noronha'
                           ],
               '813215' => [
                             'America/Noronha'
                           ],
               '813218' => [
                             'America/Noronha'
                           ],
               '813219' => [
                             'America/Noronha'
                           ],
               '813220' => [
                             'America/Noronha'
                           ],
               '81323' => [
                            'America/Noronha'
                          ],
               '813240' => [
                             'America/Noronha'
                           ],
               '813245' => [
                             'America/Noronha'
                           ],
               '813246' => [
                             'America/Noronha'
                           ],
               '813247' => [
                             'America/Noronha'
                           ],
               '813248' => [
                             'America/Noronha'
                           ],
               '813250' => [
                             'America/Noronha'
                           ],
               '813258' => [
                             'America/Noronha'
                           ],
               '813259' => [
                             'America/Noronha'
                           ],
               '813260' => [
                             'America/Noronha'
                           ],
               '813261' => [
                             'America/Noronha'
                           ],
               '813262' => [
                             'America/Noronha'
                           ],
               '813263' => [
                             'America/Noronha'
                           ],
               '81327' => [
                            'America/Noronha'
                          ],
               '81328' => [
                            'America/Noronha'
                          ],
               '81329' => [
                            'America/Noronha'
                          ],
               '813300' => [
                             'America/Noronha'
                           ],
               '813306' => [
                             'America/Noronha'
                           ],
               '813307' => [
                             'America/Noronha'
                           ],
               '813308' => [
                             'America/Noronha'
                           ],
               '813309' => [
                             'America/Noronha'
                           ],
               '813310' => [
                             'America/Noronha'
                           ],
               '813313' => [
                             'America/Noronha'
                           ],
               '813315' => [
                             'America/Noronha'
                           ],
               '813321' => [
                             'America/Noronha'
                           ],
               '813324' => [
                             'America/Noronha'
                           ],
               '813329' => [
                             'America/Noronha'
                           ],
               '81333' => [
                            'America/Noronha'
                          ],
               '813340' => [
                             'America/Noronha'
                           ],
               '813346' => [
                             'America/Noronha'
                           ],
               '813347' => [
                             'America/Noronha'
                           ],
               '813348' => [
                             'America/Noronha'
                           ],
               '813349' => [
                             'America/Noronha'
                           ],
               '81335' => [
                            'America/Noronha'
                          ],
               '81336' => [
                            'America/Noronha'
                          ],
               '813370' => [
                             'America/Noronha'
                           ],
               '813373' => [
                             'America/Noronha'
                           ],
               '813374' => [
                             'America/Noronha'
                           ],
               '81338' => [
                            'America/Noronha'
                          ],
               '81339' => [
                            'America/Noronha'
                          ],
               '81340' => [
                            'America/Noronha'
                          ],
               '813410' => [
                             'America/Noronha'
                           ],
               '813415' => [
                             'America/Noronha'
                           ],
               '813417' => [
                             'America/Noronha'
                           ],
               '813418' => [
                             'America/Noronha'
                           ],
               '813420' => [
                             'America/Noronha'
                           ],
               '813430' => [
                             'America/Noronha'
                           ],
               '813440' => [
                             'America/Noronha'
                           ],
               '813450' => [
                             'America/Noronha'
                           ],
               '813460' => [
                             'America/Noronha'
                           ],
               '813470' => [
                             'America/Noronha'
                           ],
               '813480' => [
                             'America/Noronha'
                           ],
               '813485' => [
                             'America/Noronha'
                           ],
               '813488' => [
                             'America/Noronha'
                           ],
               '813489' => [
                             'America/Noronha'
                           ],
               '813490' => [
                             'America/Noronha'
                           ],
               '813496' => [
                             'America/Noronha'
                           ],
               '8135' => [
                           'America/Noronha'
                         ],
               '81360' => [
                            'America/Noronha'
                          ],
               '81361' => [
                            'America/Noronha'
                          ],
               '813620' => [
                             'America/Noronha'
                           ],
               '813623' => [
                             'America/Noronha'
                           ],
               '813630' => [
                             'America/Noronha'
                           ],
               '813632' => [
                             'America/Noronha'
                           ],
               '813640' => [
                             'America/Noronha'
                           ],
               '813650' => [
                             'America/Noronha'
                           ],
               '813659' => [
                             'America/Noronha'
                           ],
               '81366' => [
                            'America/Noronha'
                          ],
               '813670' => [
                             'America/Noronha'
                           ],
               '813672' => [
                             'America/Noronha'
                           ],
               '813674' => [
                             'America/Noronha'
                           ],
               '813677' => [
                             'America/Noronha'
                           ],
               '813680' => [
                             'America/Noronha'
                           ],
               '813690' => [
                             'America/Noronha'
                           ],
               '813696' => [
                             'America/Noronha'
                           ],
               '813697' => [
                             'America/Noronha'
                           ],
               '813698' => [
                             'America/Noronha'
                           ],
               '8137' => [
                           'America/Noronha'
                         ],
               '8138' => [
                           'America/Noronha'
                         ],
               '8139' => [
                           'America/Noronha'
                         ],
               '814' => [
                          'America/Noronha'
                        ],
               '815' => [
                          'America/Noronha'
                        ],
               '817' => [
                          'America/Noronha'
                        ],
               '819' => [
                          'America/Noronha'
                        ],
               '9' => [
                        'America/Manaus'
                      ],
               '90' => [
                         'America/Sao_Paulo'
                       ],
               '912121' => [
                             'America/Sao_Paulo'
                           ],
               '912122' => [
                             'America/Sao_Paulo'
                           ],
               '912123' => [
                             'America/Sao_Paulo'
                           ],
               '912992' => [
                             'America/Sao_Paulo'
                           ],
               '913004' => [
                             'America/Sao_Paulo'
                           ],
               '91301' => [
                            'America/Sao_Paulo'
                          ],
               '913028' => [
                             'America/Sao_Paulo'
                           ],
               '913031' => [
                             'America/Sao_Paulo'
                           ],
               '913032' => [
                             'America/Sao_Paulo'
                           ],
               '913033' => [
                             'America/Sao_Paulo'
                           ],
               '913038' => [
                             'America/Sao_Paulo'
                           ],
               '913039' => [
                             'America/Sao_Paulo'
                           ],
               '913072' => [
                             'America/Sao_Paulo'
                           ],
               '913073' => [
                             'America/Sao_Paulo'
                           ],
               '913075' => [
                             'America/Sao_Paulo'
                           ],
               '91308' => [
                            'America/Sao_Paulo'
                          ],
               '91311' => [
                            'America/Sao_Paulo'
                          ],
               '913120' => [
                             'America/Sao_Paulo'
                           ],
               '913121' => [
                             'America/Sao_Paulo'
                           ],
               '913131' => [
                             'America/Sao_Paulo'
                           ],
               '913181' => [
                             'America/Sao_Paulo'
                           ],
               '913182' => [
                             'America/Sao_Paulo'
                           ],
               '913184' => [
                             'America/Sao_Paulo'
                           ],
               '913194' => [
                             'America/Sao_Paulo'
                           ],
               '913199' => [
                             'America/Sao_Paulo'
                           ],
               '9132' => [
                           'America/Sao_Paulo'
                         ],
               '913311' => [
                             'America/Sao_Paulo'
                           ],
               '913321' => [
                             'America/Sao_Paulo'
                           ],
               '913322' => [
                             'America/Sao_Paulo'
                           ],
               '913323' => [
                             'America/Sao_Paulo'
                           ],
               '91334' => [
                            'America/Sao_Paulo'
                          ],
               '913351' => [
                             'America/Sao_Paulo'
                           ],
               '913352' => [
                             'America/Sao_Paulo'
                           ],
               '913353' => [
                             'America/Sao_Paulo'
                           ],
               '913355' => [
                             'America/Sao_Paulo'
                           ],
               '913366' => [
                             'America/Sao_Paulo'
                           ],
               '913397' => [
                             'America/Sao_Paulo'
                           ],
               '913411' => [
                             'America/Sao_Paulo'
                           ],
               '913412' => [
                             'America/Sao_Paulo'
                           ],
               '913423' => [
                             'America/Sao_Paulo'
                           ],
               '913425' => [
                             'America/Sao_Paulo'
                           ],
               '913429' => [
                             'America/Sao_Paulo'
                           ],
               '913434' => [
                             'America/Sao_Paulo'
                           ],
               '91344' => [
                            'America/Sao_Paulo'
                          ],
               '913456' => [
                             'America/Sao_Paulo'
                           ],
               '91346' => [
                            'America/Sao_Paulo'
                          ],
               '913481' => [
                             'America/Sao_Paulo'
                           ],
               '913482' => [
                             'America/Sao_Paulo'
                           ],
               '913483' => [
                             'America/Sao_Paulo'
                           ],
               '913484' => [
                             'America/Sao_Paulo'
                           ],
               '913485' => [
                             'America/Sao_Paulo'
                           ],
               '913494' => [
                             'America/Sao_Paulo'
                           ],
               '913521' => [
                             'America/Sao_Paulo'
                           ],
               '913556' => [
                             'America/Sao_Paulo'
                           ],
               '913605' => [
                             'America/Sao_Paulo'
                           ],
               '913606' => [
                             'America/Sao_Paulo'
                           ],
               '913617' => [
                             'America/Sao_Paulo'
                           ],
               '913621' => [
                             'America/Sao_Paulo'
                           ],
               '913633' => [
                             'America/Sao_Paulo'
                           ],
               '913636' => [
                             'America/Sao_Paulo'
                           ],
               '913637' => [
                             'America/Sao_Paulo'
                           ],
               '913658' => [
                             'America/Sao_Paulo'
                           ],
               '913661' => [
                             'America/Sao_Paulo'
                           ],
               '913662' => [
                             'America/Sao_Paulo'
                           ],
               '913665' => [
                             'America/Sao_Paulo'
                           ],
               '913692' => [
                             'America/Sao_Paulo'
                           ],
               '913694' => [
                             'America/Sao_Paulo'
                           ],
               '913711' => [
                             'America/Sao_Paulo'
                           ],
               '913712' => [
                             'America/Sao_Paulo'
                           ],
               '91372' => [
                            'America/Sao_Paulo'
                          ],
               '91373' => [
                            'America/Sao_Paulo'
                          ],
               '913741' => [
                             'America/Sao_Paulo'
                           ],
               '913744' => [
                             'America/Sao_Paulo'
                           ],
               '913746' => [
                             'America/Sao_Paulo'
                           ],
               '91375' => [
                            'America/Sao_Paulo'
                          ],
               '913764' => [
                             'America/Sao_Paulo'
                           ],
               '913765' => [
                             'America/Sao_Paulo'
                           ],
               '913767' => [
                             'America/Sao_Paulo'
                           ],
               '91377' => [
                            'America/Sao_Paulo'
                          ],
               '913781' => [
                             'America/Sao_Paulo'
                           ],
               '913783' => [
                             'America/Sao_Paulo'
                           ],
               '913784' => [
                             'America/Sao_Paulo'
                           ],
               '913795' => [
                             'America/Sao_Paulo'
                           ],
               '913796' => [
                             'America/Sao_Paulo'
                           ],
               '913798' => [
                             'America/Sao_Paulo'
                           ],
               '913802' => [
                             'America/Sao_Paulo'
                           ],
               '913803' => [
                             'America/Sao_Paulo'
                           ],
               '913809' => [
                             'America/Sao_Paulo'
                           ],
               '913811' => [
                             'America/Sao_Paulo'
                           ],
               '913812' => [
                             'America/Sao_Paulo'
                           ],
               '913817' => [
                             'America/Sao_Paulo'
                           ],
               '913821' => [
                             'America/Sao_Paulo'
                           ],
               '913822' => [
                             'America/Sao_Paulo'
                           ],
               '913823' => [
                             'America/Sao_Paulo'
                           ],
               '913829' => [
                             'America/Sao_Paulo'
                           ],
               '91400' => [
                            'America/Sao_Paulo'
                          ],
               '914040' => [
                             'America/Sao_Paulo'
                           ],
               '914042' => [
                             'America/Sao_Paulo'
                           ],
               '914103' => [
                             'America/Sao_Paulo'
                           ],
               '914104' => [
                             'America/Sao_Paulo'
                           ],
               '914107' => [
                             'America/Sao_Paulo'
                           ],
               '914141' => [
                             'America/Sao_Paulo'
                           ],
               '9198' => [
                           'America/Sao_Paulo'
                         ],
               '91991' => [
                            'America/Sao_Paulo'
                          ],
               '91992' => [
                            'America/Sao_Paulo'
                          ],
               '91993' => [
                            'America/Sao_Paulo'
                          ],
               '919960' => [
                             'America/Sao_Paulo'
                           ],
               '919961' => [
                             'America/Sao_Paulo'
                           ],
               '919962' => [
                             'America/Sao_Paulo'
                           ],
               '919963' => [
                             'America/Sao_Paulo'
                           ],
               '919964' => [
                             'America/Sao_Paulo'
                           ],
               '91998' => [
                            'America/Sao_Paulo'
                          ],
               '91999' => [
                            'America/Sao_Paulo'
                          ],
               '925009' => [
                             'America/Sao_Paulo'
                           ],
               '932101' => [
                             'America/Sao_Paulo'
                           ],
               '932122' => [
                             'America/Sao_Paulo'
                           ],
               '933016' => [
                             'America/Sao_Paulo'
                           ],
               '933017' => [
                             'America/Sao_Paulo'
                           ],
               '933062' => [
                             'America/Sao_Paulo'
                           ],
               '933063' => [
                             'America/Sao_Paulo'
                           ],
               '933064' => [
                             'America/Sao_Paulo'
                           ],
               '933067' => [
                             'America/Sao_Paulo'
                           ],
               '933222' => [
                             'America/Sao_Paulo'
                           ],
               '933502' => [
                             'America/Sao_Paulo'
                           ],
               '933505' => [
                             'America/Sao_Paulo'
                           ],
               '933512' => [
                             'America/Sao_Paulo'
                           ],
               '933514' => [
                             'America/Sao_Paulo'
                           ],
               '933515' => [
                             'America/Sao_Paulo'
                           ],
               '933517' => [
                             'America/Sao_Paulo'
                           ],
               '933518' => [
                             'America/Sao_Paulo'
                           ],
               '93352' => [
                            'America/Sao_Paulo'
                          ],
               '93353' => [
                            'America/Sao_Paulo'
                          ],
               '93354' => [
                            'America/Sao_Paulo'
                          ],
               '933552' => [
                             'America/Sao_Paulo'
                           ],
               '933557' => [
                             'America/Sao_Paulo'
                           ],
               '933558' => [
                             'America/Sao_Paulo'
                           ],
               '933559' => [
                             'America/Sao_Paulo'
                           ],
               '933563' => [
                             'America/Sao_Paulo'
                           ],
               '933574' => [
                             'America/Sao_Paulo'
                           ],
               '933582' => [
                             'America/Sao_Paulo'
                           ],
               '933589' => [
                             'America/Sao_Paulo'
                           ],
               '933593' => [
                             'America/Sao_Paulo'
                           ],
               '933596' => [
                             'America/Sao_Paulo'
                           ],
               '933597' => [
                             'America/Sao_Paulo'
                           ],
               '933598' => [
                             'America/Sao_Paulo'
                           ],
               '933735' => [
                             'America/Sao_Paulo'
                           ],
               '933736' => [
                             'America/Sao_Paulo'
                           ],
               '933737' => [
                             'America/Sao_Paulo'
                           ],
               '933793' => [
                             'America/Sao_Paulo'
                           ],
               '939810' => [
                             'America/Sao_Paulo'
                           ],
               '939811' => [
                             'America/Sao_Paulo'
                           ],
               '939812' => [
                             'America/Sao_Paulo'
                           ],
               '939813' => [
                             'America/Sao_Paulo'
                           ],
               '939840' => [
                             'America/Sao_Paulo'
                           ],
               '939841' => [
                             'America/Sao_Paulo'
                           ],
               '939880' => [
                             'America/Sao_Paulo'
                           ],
               '939881' => [
                             'America/Sao_Paulo'
                           ],
               '93991' => [
                            'America/Sao_Paulo'
                          ],
               '939920' => [
                             'America/Sao_Paulo'
                           ],
               '939921' => [
                             'America/Sao_Paulo'
                           ],
               '939922' => [
                             'America/Sao_Paulo'
                           ],
               '939923' => [
                             'America/Sao_Paulo'
                           ],
               '939924' => [
                             'America/Sao_Paulo'
                           ],
               '939965' => [
                             'America/Sao_Paulo'
                           ],
               '939990' => [
                             'America/Sao_Paulo'
                           ],
               '939991' => [
                             'America/Sao_Paulo'
                           ],
               '939995' => [
                             'America/Sao_Paulo'
                           ],
               '939997' => [
                             'America/Sao_Paulo'
                           ],
               '942101' => [
                             'America/Sao_Paulo'
                           ],
               '942103' => [
                             'America/Sao_Paulo'
                           ],
               '943012' => [
                             'America/Sao_Paulo'
                           ],
               '943013' => [
                             'America/Sao_Paulo'
                           ],
               '943016' => [
                             'America/Sao_Paulo'
                           ],
               '943018' => [
                             'America/Sao_Paulo'
                           ],
               '943222' => [
                             'America/Sao_Paulo'
                           ],
               '943301' => [
                             'America/Sao_Paulo'
                           ],
               '943309' => [
                             'America/Sao_Paulo'
                           ],
               '943311' => [
                             'America/Sao_Paulo'
                           ],
               '943312' => [
                             'America/Sao_Paulo'
                           ],
               '943315' => [
                             'America/Sao_Paulo'
                           ],
               '943319' => [
                             'America/Sao_Paulo'
                           ],
               '94332' => [
                            'America/Sao_Paulo'
                          ],
               '943331' => [
                             'America/Sao_Paulo'
                           ],
               '943332' => [
                             'America/Sao_Paulo'
                           ],
               '943333' => [
                             'America/Sao_Paulo'
                           ],
               '943335' => [
                             'America/Sao_Paulo'
                           ],
               '943337' => [
                             'America/Sao_Paulo'
                           ],
               '94334' => [
                            'America/Sao_Paulo'
                          ],
               '94335' => [
                            'America/Sao_Paulo'
                          ],
               '943364' => [
                             'America/Sao_Paulo'
                           ],
               '943365' => [
                             'America/Sao_Paulo'
                           ],
               '943366' => [
                             'America/Sao_Paulo'
                           ],
               '943379' => [
                             'America/Sao_Paulo'
                           ],
               '943382' => [
                             'America/Sao_Paulo'
                           ],
               '943385' => [
                             'America/Sao_Paulo'
                           ],
               '943386' => [
                             'America/Sao_Paulo'
                           ],
               '943392' => [
                             'America/Sao_Paulo'
                           ],
               '94342' => [
                            'America/Sao_Paulo'
                          ],
               '943431' => [
                             'America/Sao_Paulo'
                           ],
               '943432' => [
                             'America/Sao_Paulo'
                           ],
               '943433' => [
                             'America/Sao_Paulo'
                           ],
               '943434' => [
                             'America/Sao_Paulo'
                           ],
               '943435' => [
                             'America/Sao_Paulo'
                           ],
               '943491' => [
                             'America/Sao_Paulo'
                           ],
               '943778' => [
                             'America/Sao_Paulo'
                           ],
               '943779' => [
                             'America/Sao_Paulo'
                           ],
               '943785' => [
                             'America/Sao_Paulo'
                           ],
               '943786' => [
                             'America/Sao_Paulo'
                           ],
               '943787' => [
                             'America/Sao_Paulo'
                           ],
               '94981' => [
                            'America/Sao_Paulo'
                          ],
               '949840' => [
                             'America/Sao_Paulo'
                           ],
               '949841' => [
                             'America/Sao_Paulo'
                           ],
               '949842' => [
                             'America/Sao_Paulo'
                           ],
               '949880' => [
                             'America/Sao_Paulo'
                           ],
               '949881' => [
                             'America/Sao_Paulo'
                           ],
               '94991' => [
                            'America/Sao_Paulo'
                          ],
               '94992' => [
                            'America/Sao_Paulo'
                          ],
               '949930' => [
                             'America/Sao_Paulo'
                           ],
               '949966' => [
                             'America/Sao_Paulo'
                           ],
               '949990' => [
                             'America/Sao_Paulo'
                           ],
               '949991' => [
                             'America/Sao_Paulo'
                           ],
               '949992' => [
                             'America/Sao_Paulo'
                           ],
               '949995' => [
                             'America/Sao_Paulo'
                           ],
               '949997' => [
                             'America/Sao_Paulo'
                           ],
               '96' => [
                         'America/Sao_Paulo'
                       ],
               '98' => [
                         'America/Sao_Paulo'
                       ],
               '99' => [
                         'America/Sao_Paulo'
                       ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+55|\D)//g;
      my $self = bless({ country_code => '55', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(?:0|90)(?:(1[245]|2[1-35]|31|4[13]|[56]5|99)(\d{10,11}))?)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$2/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '55', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;