use strict;
use warnings;
use Test::More;
use lib qw(./lib ./blib/lib);
require './t/600-lhost-code';

my $enginename = 'V5sendmail';
my $samplepath = sprintf("./set-of-emails/private/lhost-%s", lc $enginename);
my $enginetest = Sisimai::Lhost::Code->makeinquiry;
my $isexpected = {
    # INDEX => [['D.S.N.', 'replycode', 'REASON', 'hardbounce'], [...]]
    '01001' => [['5.0.911', '550', 'userunknown',     1]],
    '01002' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01003' => [['5.0.912', '550', 'hostunknown',     1]],
    '01004' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01005' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01006' => [['5.0.912', '550', 'hostunknown',     1]],
    '01007' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01008' => [['5.0.912', '550', 'hostunknown',     1]],
    '01009' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
    '01010' => [['5.0.912', '550', 'hostunknown',     1]],
    '01011' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01012' => [['5.0.911', '550', 'userunknown',     1]],
    '01013' => [['5.0.911', '550', 'userunknown',     1]],
    '01014' => [['5.0.912', '550', 'hostunknown',     1]],
    '01015' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01016' => [['5.0.912', '550', 'hostunknown',     1]],
    '01017' => [['5.0.911', '550', 'userunknown',     1]],
    '01018' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01019' => [['5.0.910', '550', 'filtered',        0]],
    '01020' => [['5.0.911', '550', 'userunknown',     1]],
    '01021' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01022' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01023' => [['5.0.912', '550', 'hostunknown',     1]],
    '01024' => [['5.0.912', '550', 'hostunknown',     1]],
    '01025' => [['5.0.912', '550', 'hostunknown',     1]],
    '01026' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01027' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01028' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '553', 'userunknown',     1]],
    '01029' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01030' => [['5.0.912', '550', 'hostunknown',     1]],
    '01031' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01032' => [['5.0.911', '550', 'userunknown',     1]],
    '01033' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01034' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01035' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01036' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
    '01037' => [['5.0.912', '550', 'hostunknown',     1]],
    '01038' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
    '01039' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01040' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01041' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01042' => [['5.0.912', '550', 'hostunknown',     1]],
    '01043' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01044' => [['5.0.912', '550', 'hostunknown',     1]],
    '01045' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01046' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01047' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01048' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01049' => [['5.0.911', '550', 'userunknown',     1]],
    '01050' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.901', '553', 'onhold',          0]],
    '01051' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01052' => [['5.0.971', '550', 'blocked',         0],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
    '01053' => [['5.0.911', '550', 'userunknown',     1]],
    '01054' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '553', 'userunknown',     1]],
    '01055' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01056' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01057' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01058' => [['5.0.911', '550', 'userunknown',     1]],
    '01059' => [['5.0.912', '550', 'hostunknown',     1]],
    '01060' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
    '01061' => [['5.0.911', '553', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
#   '01063' => [['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1],
#               ['5.0.912', '550', 'hostunknown',     1]],
    '01064' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
    '01065' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01066' => [['5.0.911', '550', 'userunknown',     1],
                ['5.7.1',   '553', 'norelaying',      0]],
    '01067' => [['5.0.912', '550', 'hostunknown',     1]],
    '01068' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01069' => [['5.0.910', '550', 'filtered',        0]],
    '01071' => [['5.0.912', '550', 'hostunknown',     1]],
    '01072' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
    '01073' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01074' => [['4.0.930', '421', 'systemerror',     0],
                ['5.0.911', '550', 'userunknown',     1]],
    '01075' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01076' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01077' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01078' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01079' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01080' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01081' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01082' => [['5.0.911', '550', 'userunknown',     1]],
    '01083' => [['5.0.912', '550', 'hostunknown',     1]],
    '01084' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01085' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01086' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01087' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01088' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01089' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01090' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
    '01091' => [['5.0.912', '550', 'hostunknown',     1]],
    '01092' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01093' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01094' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01095' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01096' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01097' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '553', 'userunknown',     1],
                ['5.0.911', '553', 'userunknown',     1]],
    '01098' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.971', '501', 'blocked',         0]],
    '01100' => [['5.0.911', '553', 'userunknown',     1]],
    '01101' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01102' => [['5.0.912', '550', 'hostunknown',     1]],
    '01103' => [['5.0.912', '550', 'hostunknown',     1]],
    '01104' => [['5.0.911', '550', 'userunknown',     1]],
    '01105' => [['5.0.912', '550', 'hostunknown',     1]],
    '01106' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
    '01107' => [['5.0.911', '550', 'userunknown',     1]],
    '01108' => [['5.0.912', '550', 'hostunknown',     1]],
    '01109' => [['5.0.912', '550', 'hostunknown',     1]],
    '01110' => [['5.0.912', '550', 'hostunknown',     1]],
    '01111' => [['5.0.911', '550', 'userunknown',     1]],
    '01112' => [['5.0.911', '550', 'userunknown',     1]],
    '01113' => [['4.0.971', '421', 'blocked',         0]],
    '01114' => [['5.0.912', '550', 'hostunknown',     1]],
    '01115' => [['4.0.944', '421', 'networkerror',    0]],
    '01116' => [['5.0.912', '550', 'hostunknown',     1]],
    '01117' => [['4.0.971', '421', 'blocked',         0]],
    '01118' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01119' => [['4.0.947', '421', 'expired',         0]],
    '01120' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
    '01121' => [['5.0.912', '550', 'hostunknown',     1]],
    '01122' => [['4.0.971', '421', 'blocked',         0]],
    '01123' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01124' => [['4.0.947', '421', 'expired',         0]],
    '01125' => [['4.0.947', '421', 'expired',         0]],
    '01126' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
    '01127' => [['4.0.947', '421', 'expired',         0]],
    '01128' => [['5.0.909', '550', 'norelaying',      0]],
    '01129' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01130' => [['4.0.947', '421', 'expired',         0]],
    '01131' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
    '01132' => [['5.0.910', '550', 'filtered',        0]],
    '01133' => [['5.0.912', '550', 'hostunknown',     1]],
    '01134' => [['4.0.947', '421', 'expired',         0]],
    '01135' => [['5.0.912', '550', 'hostunknown',     1]],
    '01136' => [['5.0.912', '550', 'hostunknown',     1]],
    '01137' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01138' => [['5.0.911', '550', 'userunknown',     1]],
    '01139' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01140' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01141' => [['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1]],
    '01142' => [['4.0.930', '421', 'systemerror',     0],
                ['5.0.911', '550', 'userunknown',     1]],
    '01143' => [['5.0.912', '550', 'hostunknown',     1]],
    '01144' => [['5.0.911', '550', 'userunknown',     1],
                ['5.0.912', '550', 'hostunknown',     1],
                ['5.0.911', '550', 'userunknown',     1]],
};

plan 'skip_all', sprintf("%s not found", $samplepath) unless -d $samplepath;
$enginetest->($enginename, $isexpected, 1, 0);
done_testing;

