package LCFG::DB;  # -*-perl-*-

#######################################################################
#
# This package contains DB_File routines for the LCFG Adaptors
#
# Stephen Quinney <squinney@inf.ed.ac.uk>
# Version 1.13.5 : 01/02/19 09:58:14
#
# $Id: DB_File.pm.cin 29160 2015-11-06 17:38:41Z squinney@INF.ED.AC.UK $
# $Source: /var/cvs/dice/LCFG-Utils-Perl/lib/LCFG/DB_File.pm.cin,v $
# $Revision: 29160 $
# $HeadURL: https://svn.lcfg.org/svn/source/tags/LCFG-Utils-Perl/LCFG_Utils_Perl_1_13_5/lib/LCFG/DB_File.pm.cin $
# $Date: 2015-11-06 17:38:41 +0000 (Fri, 06 Nov 2015) $
#
#######################################################################

use strict;

our $VERSION = '1.13.5';

use Exporter ();
use DB_File;

$LCFG::DB::dbext = "DB2.db";

#######################################################################
sub TieReadWrite ($$) {
#######################################################################

  my $file = shift;
  my $hash = shift;

  return tie ( %$hash, 'DB_File', $file, O_RDWR|O_CREAT, 0644, $DB_HASH );
}

#######################################################################
sub TieReadOnly ($$) {
#######################################################################

  my $file = shift;
  my $hash = shift;

  return tie ( %$hash, 'DB_File', $file, O_RDONLY, 0644, $DB_HASH )
}

#######################################################################
sub UnTie ($) {
#######################################################################

  my $hash = shift;

  return untie %$hash;
}

1;
