


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Pcap - libpcap bindings

SYNOPSIS
========

    use Net::Pcap;
    use Net::Packet :short;

    # Live capturing
    my $pcap = Net::Pcap.create("eth0");
    $pcap.filter('portrange 1-1024');
    $pcap.activate;

    # Read from file
    my $pcap = Net::Pcap.offline_open('./capture.pcap');

    loop $pcap.next_ex -> ($hdr, $frame) {
        my $eth = Ethernet.decode($frame);

        say sprintf 'Time:   %.3f', $hdr.seconds;
        say sprintf 'Length: %d (%d captured)', $hdr.len, $hdr.caplen;
        say sprintf 'Ethernet:';
        say sprintf '  Source:      %s', $eth.src;
        say sprintf '  Destination: %s', $eth.dst;

        if $eth.pl ~~ IPv4 {
     	    say sprintf 'IPv4:';
	    say sprintf '  Source:      %s', $eth.pl.src;
	    say sprintf '  Destination: %s', $eth.pl.dst;
        }
    }

EXPORTS
=======

    class Net::Pcap

DESCRIPTION
===========



class Net::Pcap::pcap_pkthdr_t
------------------------------

    is repr('CStruct')

    Implements `pcap_pkthdr_t`.

### Attributes

    $.tv_sec   is int
    $.tv_usec  is int
    $.caplen   is int
    $.len      is int

### Methods

    .seconds() returns Real
      Combines the $.tv_sec and $.tv_usec fields to one Real.

    .clone() returns Net::Pcap::pcap_pkthdr_t
      Returns a copy of this structure.

class Net::Pcap
---------------

    is repr('CPointer')

    Implements `pcap_t`.

### Methods

    .create(Str $source="any") returns Net::Pcap
      Constructor for Net::Pcap for live-capturing, uses pcap_create(). Use .activate() on it.

    .open_offline(Str $fname) returns Net::Pcap
      Constructor for Net::Pcap to open capture files, uses pcap_open_offline().

    .open_dead(Int $linktype, Int $snaplen) returns Net::Pcap
      Constructor for creating a fake Net::Pcap.

    .close()
      Calls pcap_close().

    .activate()
      Activates the capture devices, uses pcap_activate().

    .next() returns Parcel
      Get next frame.

      *Usage of .next_ex() is preferred due to better error messages!*

      Returns a parcel with two elements:
      - Net::Pcap::pcap_pkthdr_t structure
      - Net::Pcap::C_Buf containing the frame.
      Uses pcap_next().

    .next_ex() returns Parcel
      Get next frame.

      Returns a parcel with two elements:
      - Net::Pcap::pcap_pkthdr_t structure
      - Net::Pcap::C_Buf containing the frame.
      Uses pcap_next_ex().

    .filter(Str $str, Int $optimize = 0, Int $netmask = 0xFFFFFFFF)
      Apply filter $str.

      Calls pcap_compile(), pcap_freecode() and pcap_setfilter().

    .findalldevs() returns Array
      Find all available capture devices. Uses pcap_findalldevs().

      Returns an array of hashes, each hash contains the keys:
      - name
      - description
      - flags


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Pcap::C_Buf;

SYNOPSIS
========

    use NativeCall;
    use Net::Pcap::C_Buf :short :util;

    sub strerror_r(int $err, OpaquePointer $buf, int $len) returns int is native { * };

    my $buf = C_Buf.calloc(256);
    strerror_r(0xFFFFFFFF, $buf, 256);
    say $buf.decode('ascii');

EXPORTS
=======

    class Net::Pcap::C_Buf

:short trait exports:

    constant C_Buf ::= Net::Pcap::C_Buf;

:util trait exports:

    sub C_calloc(...);
    sub C_malloc(...);
    sub C_memcpy(...);
    sub C_free(...);

DESCRIPTION
===========



Constants
---------

    constant uint8p = CArray[uint8];

Subroutines
-----------

    C_calloc(int $nelem, int $elsize) returns OpaquePointer
        is export(:util)
      Interface to the C calloc() function.

    C_malloc(int $size) returns OpaquePointer
        is export(:util)
      Interface to the C malloc() function.

    C_memcpy(OpaquePointer $dst, OpaquePointer $src, int $n) returns OpaquePointer
        is export(:util)
      Interface to the C memcpy() function.

    C_free(OpaquePointer $ptr)
        is export(:util)
      Interface to the C free() function

class Net::Pcap::C_Buf
----------------------

    does Positional

### Attributes

    $.ptr             is OpaquePointer
    $.carray          is uint8p
      Pointer to the C buffer
      $.carray contains this pointer cast to uint8p

    $.elems           is Int
      Number of elements (bytes) in the buffer.

    $.is_owner        is Bool
      Set if the Perl6 garbage collector needs to free the buffer before object destruction.

    $.is_freed  is rw is Bool
      Set if the buffer has been free()'d.

### Methods

    .new(OpaquePointer $ptr, Int $elems, Bool $is_owner = True) returns C_Buf
    .new(Buf $buf) returns C_Buf
      C_Buf constructor.

    .free()
      Free the buffer

    .malloc(int $size) returns C_Buf
      Calls malloc and constructs a C_Buf for the return pointer.

    .calloc(int $size) returns C_Buf
      Calls calloc and constructs a C_Buf for the return pointer.

    .clone() returns C_Buf
      Copies the buffer to a newly allocated area of memory and returns a C_Buf for the new buffer.

    .Buf() returns Buf
      Converts the C buffer to the builtin Buf type.

    .unpack_n(Int $i) returns Int
      Unpacks a 16-bit integer from the buffer, starting at position $i.

    .unpack_N(Int $i) returns Int
      Unpacks a 32-bit integer from the buffer, starting at position $i.

    .unpack(Str $str)
    .unpack(Int $start, Str $str)
      Calls unpack($str) on the buffer.
      If $start is given, start unpacking at position $start.

    .subbuf(Int $from, Int $len = slef.elems) returns C_Buf
      Copy part of the buffer to a newly allocated memory region.

    .decode($encoding = 'utf-8') returns Str
      Converts the buffer to the builtin Buf type and calls .decode($encoding) on it.
      It is C-string aware, so if ($encoding eq 'ascii') it will stop decoding when it
      finds a 0x00 byte.

    .at_pos(Int $pos) returns Int
      Returns the byte at position $pos. C_Buf does Positional so this code is called if C_Buf
      called with brackets like so $buf[1].

    .assign_pos(Int $pos, $assignee)
      Assignes the byte $assignee to position $pos. C_Buf does Positional so this code is called
      if the buffer is called with brackets to assign, like so: $buf[1] = 0;

    .bytes() returns Int
      Returns the number of bytes in the buffer.


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Pcap::Linktype

SYNOPSYS
========

    use Net::Pcap::Linktype :short;

    say Linktype::Ethernet.value;

EXPORTS
=======

    enum Net::Pcap::Linktype;

:short trait adds exports:

    constant Linktype ::= Net::Pcap::Linktype;

DESCRIPTION
===========



enum Net::Pcap::Linktype
------------------------

Enumerator for libpcaps link-layer type.


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Pcap::Dump - Write packets to file.

SYNOPSIS
========

    use Net::Pcap::Dump :short;
    use Net::Pcap::Linktype :short;
    use Net::Pcap::C_Buf :short;

    my $data = C_Buf.new(Buf.new([0x00, 0x01, 0x02, 0x03]));
    my $dump = Dumper.open('dump.pcap', Linktype::Ethernet, 1500);
    $dump.dump($data);

EXPORTS
=======

    class Net::Pcap::Dump;

:short trait adds export:

    constant Dump ::= Net::Pcap::Dump;

DESCRIPTION
===========



class Net::Pcap::Dump
---------------------

    Implements `pcap_dump_t`.

### Attributes

    $.pcap_dump  is rw  is OpaquePointer
      Pointer to the pcap_dump_t structure.

    $.pcap       is rw  is Net::Pcap
      Parent pcap_t structure.

### Methods

    .open(Net::Pcap $p, Str $fname) returns Net::Pcap::Dump
      Constructor for Net::Pcap::Dump. Calls pcap_dump_open($p, $fname).

    .open(Str $fname, Net::Pcap::Linktype $linktype, Int $snaplen) returns Net::Pcap::Dump
      Constructor for Net::Pcap::Dump. Calls pcap_open_dead and pcap_dump_open.

    .close()
      Closes the pcap_dump_t, and (if constructed by .open()) closes the parent pcap_t.

    .dump(Net::Pcap::C_Buf $data, Real $seconds)
      Write packet to file. Constructs a pcap_pkthdr_t with caplen and len from C_Buf.elems,
      and tv_usec and tv_sec from $seconds. Then calls pcap_dump on the data and the pcap_pkthdr_t
      structure.
