<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::Ethernet

SYNOPSIS
========

    use Net::Packet::Ethernet :short;

    my $frame = Buf.new([...]);
    my $eth = Ethernet.decode($frame);

    say sprintf '%s -> %s: %s',
        $eth.src.Str, $eth.src.Str, $eth.type;

Prints: 66:77:88:99:AA:BB -> 66:77:88:99:AA:BB: IPv4

EXPORTS
=======

    Net::Packet::Ethernet

:short trait adds exports:

    constant Ethernet  ::= Net::Packet::Ethernet;
    constant MAC_addr  ::= Net::Packet::MAC_addr;
    constnat EtherType ::= Net::Packet::EtherType;

DESCRIPTION
===========

Net::Packet::Ethernet takes a byte buffer and returns a corresponding packet object. The byte buffer can be of the builtin Buf type or the C_Buf type of Net::Pcap.

class Net::Packet::Ethernet
---------------------------

    is Net::Packet::Base;

### Attributes

     $.src         is rw is Net::Packet::Ethernet::MAC_addr
    $.dst         is rw is Net::Packet::Ethernet::MAC_addr
      Source/destination MAC address

    $.type        is rw is Net::Packet::Ethernet::EtherType
      Payload type.

    $.is_802_1Q   is rw is Bool
      Set if packet is of type IEE802.1Q.
      
    $.pcp         is rw is Int
    $.dei         is rw is Int
    $.vid         is rw is Int
      PCP/DEI/VID field. Only used if $.is_802_1Q is set.

    $.is_802_1ad  is rw is Bool
      Set if packet is of type IEEE802.1ad.

    $.s-vid       is rw is Int
    $.s-dei       is rw is Int
    $.s-pcp       is rw is Int
      PCP/DEI/VID field of the service provider. Only used if IEEE802.1ad is set.

### Methods

    .decode($frame, Net::Packet::Base $parent?) returns Net::Packet::Ethernet
      Returns the Ethernet packet corresponding to $frame.

    .encode()
      Writes the packet to $.frame buffer, including the payload.

    .pl() returns Proxy is rw
      Returns a Proxy for the payload of this packet.
      Usage:
        $eth.pl = ...
        my $ip = $eth.pl.
