unit module Geo::Region::Enum;

enum Region is export (
    Africa            => '002',
    Americas          => '019',
    Asia              => '142',
    Australasia       => '053',
    Caribbean         => '029',
    CentralAmerica    => '013',
    CentralAsia       => '143',
    EasternAfrica     => '014',
    EasternAsia       => '030',
    EasternEurope     => '151',
    Europe            => '150',
    EuropeanUnion     => 'EU',
    LatinAmerica      => '419',
    Melanesia         => '054',
    MicronesianRegion => '057',
    MiddleAfrica      => '017',
    NorthAmerica      => '003',
    NorthernAfrica    => '015',
    NorthernAmerica   => '021',
    NorthernEurope    => '154',
    Oceania           => '009',
    OutlyingOceania   => 'QO',
    Polynesia         => '061',
    SouthAmerica      => '005',
    SoutheastAsia     => '035',
    SouthernAfrica    => '018',
    SouthernAsia      => '034',
    SouthernEurope    => '039',
    WesternAfrica     => '011',
    WesternAsia       => '145',
    WesternEurope     => '155',
    World             => '001',
);

enum Country is export (
    Afghanistan                      => 'AF',
    ÅlandIslands                     => 'AX',
    Albania                          => 'AL',
    Algeria                          => 'DZ',
    AmericanSamoa                    => 'AS',
    Andorra                          => 'AD',
    Angola                           => 'AO',
    Anguilla                         => 'AI',
    Antarctica                       => 'AQ',
    AntiguaBarbuda                   => 'AG',
    Argentina                        => 'AR',
    Armenia                          => 'AM',
    Aruba                            => 'AW',
    Australia                        => 'AU',
    Austria                          => 'AT',
    Azerbaijan                       => 'AZ',
    Bahamas                          => 'BS',
    Bahrain                          => 'BH',
    Bangladesh                       => 'BD',
    Barbados                         => 'BB',
    Belarus                          => 'BY',
    Belgium                          => 'BE',
    Belize                           => 'BZ',
    Benin                            => 'BJ',
    Bermuda                          => 'BM',
    Bhutan                           => 'BT',
    Bolivia                          => 'BO',
    Bosnia                           => 'BA',
    Botswana                         => 'BW',
    BouvetIsland                     => 'BV',
    Brazil                           => 'BR',
    BritishIndianOceanTerritory      => 'IO',
    BritishVirginIslands             => 'VG',
    Brunei                           => 'BN',
    Bulgaria                         => 'BG',
    BurkinaFaso                      => 'BF',
    Burundi                          => 'BI',
    Cambodia                         => 'KH',
    Cameroon                         => 'CM',
    Canada                           => 'CA',
    CapeVerde                        => 'CV',
    CaribbeanNetherlands             => 'BQ',
    CaymanIslands                    => 'KY',
    CentralAfricanRepublic           => 'CF',
    Chad                             => 'TD',
    Chile                            => 'CL',
    China                            => 'CN',
    ChristmasIsland                  => 'CX',
    CocosIslands                     => 'CC',
    Colombia                         => 'CO',
    Comoros                          => 'KM',
    CongoDRC                         => 'CD',
    CongoRepublic                    => 'CG',
    CookIslands                      => 'CK',
    CostaRica                        => 'CR',
    Croatia                          => 'HR',
    Cuba                             => 'CU',
    Curaçao                          => 'CW',
    Cyprus                           => 'CY',
    CzechRepublic                    => 'CZ',
    Denmark                          => 'DK',
    Djibouti                         => 'DJ',
    Dominica                         => 'DM',
    DominicanRepublic                => 'DO',
    EastTimor                        => 'TL',
    Ecuador                          => 'EC',
    Egypt                            => 'EG',
    ElSalvador                       => 'SV',
    EquatorialGuinea                 => 'GQ',
    Eritrea                          => 'ER',
    Estonia                          => 'EE',
    Ethiopia                         => 'ET',
    FalklandIslands                  => 'FK',
    FaroeIslands                     => 'FO',
    Fiji                             => 'FJ',
    Finland                          => 'FI',
    France                           => 'FR',
    FrenchGuiana                     => 'GF',
    FrenchPolynesia                  => 'PF',
    FrenchSouthernTerritories        => 'TF',
    Gabon                            => 'GA',
    Gambia                           => 'GM',
    Georgia                          => 'GE',
    Germany                          => 'DE',
    Ghana                            => 'GH',
    Gibraltar                        => 'GI',
    Greece                           => 'GR',
    Greenland                        => 'GL',
    Grenada                          => 'GD',
    Guadeloupe                       => 'GP',
    Guam                             => 'GU',
    Guatemala                        => 'GT',
    Guernsey                         => 'GG',
    Guinea                           => 'GN',
    GuineaBissau                     => 'GW',
    Guyana                           => 'GY',
    Haiti                            => 'HT',
    HeardMcDonaldIslands             => 'HM',
    Honduras                         => 'HN',
    HongKong                         => 'HK',
    Hungary                          => 'HU',
    Iceland                          => 'IS',
    India                            => 'IN',
    Indonesia                        => 'ID',
    Iran                             => 'IR',
    Iraq                             => 'IQ',
    Ireland                          => 'IE',
    IsleofMan                        => 'IM',
    Israel                           => 'IL',
    Italy                            => 'IT',
    IvoryCoast                       => 'CI',
    Jamaica                          => 'JM',
    Japan                            => 'JP',
    Jersey                           => 'JE',
    Jordan                           => 'JO',
    Kazakhstan                       => 'KZ',
    Kenya                            => 'KE',
    Kiribati                         => 'KI',
    Kuwait                           => 'KW',
    Kyrgyzstan                       => 'KG',
    Laos                             => 'LA',
    Latvia                           => 'LV',
    Lebanon                          => 'LB',
    Lesotho                          => 'LS',
    Liberia                          => 'LR',
    Libya                            => 'LY',
    Liechtenstein                    => 'LI',
    Lithuania                        => 'LT',
    Luxembourg                       => 'LU',
    Macau                            => 'MO',
    Macedonia                        => 'MK',
    Madagascar                       => 'MG',
    Malawi                           => 'MW',
    Malaysia                         => 'MY',
    Maldives                         => 'MV',
    Mali                             => 'ML',
    Malta                            => 'MT',
    MarshallIslands                  => 'MH',
    Martinique                       => 'MQ',
    Mauritania                       => 'MR',
    Mauritius                        => 'MU',
    Mayotte                          => 'YT',
    Mexico                           => 'MX',
    Micronesia                       => 'FM',
    Moldova                          => 'MD',
    Monaco                           => 'MC',
    Mongolia                         => 'MN',
    Montenegro                       => 'ME',
    Montserrat                       => 'MS',
    Morocco                          => 'MA',
    Mozambique                       => 'MZ',
    Myanmar                          => 'MM',
    Namibia                          => 'NA',
    Nauru                            => 'NR',
    Nepal                            => 'NP',
    Netherlands                      => 'NL',
    NewCaledonia                     => 'NC',
    NewZealand                       => 'NZ',
    Nicaragua                        => 'NI',
    Niger                            => 'NE',
    Nigeria                          => 'NG',
    Niue                             => 'NU',
    NorfolkIsland                    => 'NF',
    NorthernMarianaIslands           => 'MP',
    NorthKorea                       => 'KP',
    Norway                           => 'NO',
    Oman                             => 'OM',
    Pakistan                         => 'PK',
    Palau                            => 'PW',
    Palestine                        => 'PS',
    Panama                           => 'PA',
    PapuaNewGuinea                   => 'PG',
    Paraguay                         => 'PY',
    Peru                             => 'PE',
    Philippines                      => 'PH',
    PitcairnIslands                  => 'PN',
    Poland                           => 'PL',
    Portugal                         => 'PT',
    PuertoRico                       => 'PR',
    Qatar                            => 'QA',
    Réunion                          => 'RE',
    Romania                          => 'RO',
    Russia                           => 'RU',
    Rwanda                           => 'RW',
    Samoa                            => 'WS',
    SanMarino                        => 'SM',
    SãoToméPríncipe                  => 'ST',
    SaudiArabia                      => 'SA',
    Senegal                          => 'SN',
    Serbia                           => 'RS',
    Seychelles                       => 'SC',
    SierraLeone                      => 'SL',
    Singapore                        => 'SG',
    SintMaarten                      => 'SX',
    Slovakia                         => 'SK',
    Slovenia                         => 'SI',
    SolomonIslands                   => 'SB',
    Somalia                          => 'SO',
    SouthAfrica                      => 'ZA',
    SouthGeorgiaSouthSandwichIslands => 'GS',
    SouthKorea                       => 'KR',
    SouthSudan                       => 'SS',
    Spain                            => 'ES',
    SriLanka                         => 'LK',
    StBarthélemy                     => 'BL',
    StHelena                         => 'SH',
    StKittsNevis                     => 'KN',
    StLucia                          => 'LC',
    StMartin                         => 'MF',
    StPierreMiquelon                 => 'PM',
    StVincentGrenadines              => 'VC',
    Sudan                            => 'SD',
    Suriname                         => 'SR',
    SvalbardJanMayen                 => 'SJ',
    Swaziland                        => 'SZ',
    Sweden                           => 'SE',
    Switzerland                      => 'CH',
    Syria                            => 'SY',
    Taiwan                           => 'TW',
    Tajikistan                       => 'TJ',
    Tanzania                         => 'TZ',
    Thailand                         => 'TH',
    Togo                             => 'TG',
    Tokelau                          => 'TK',
    Tonga                            => 'TO',
    TrinidadTobago                   => 'TT',
    Tunisia                          => 'TN',
    Turkey                           => 'TR',
    Turkmenistan                     => 'TM',
    TurksCaicosIslands               => 'TC',
    Tuvalu                           => 'TV',
    Uganda                           => 'UG',
    Ukraine                          => 'UA',
    UnitedArabEmirates               => 'AE',
    UnitedKingdom                    => 'GB',
    UnitedStates                     => 'US',
    Uruguay                          => 'UY',
    USOutlyingIslands                => 'UM',
    USVirginIslands                  => 'VI',
    Uzbekistan                       => 'UZ',
    Vanuatu                          => 'VU',
    VaticanCity                      => 'VA',
    Venezuela                        => 'VE',
    Vietnam                          => 'VN',
    WallisFutuna                     => 'WF',
    WesternSahara                    => 'EH',
    Yemen                            => 'YE',
    Zambia                           => 'ZM',
    Zimbabwe                         => 'ZW',
);

=begin pod

=head1 NAME

Geo::Region::Enum - Enumerations for UN M.49 and CLDR region codes

=head1 VERSION

This document describes Geo::Region::Enum for Perl 6, built with Unicode CLDR
v26.

=head1 SYNOPSIS

    use Geo::Region::Enum;

    Region::LatinAmerica   # '419'
    Region::EuropeanUnion  # 'EU'
    Country::Japan         # 'JP'

=head1 DESCRIPTION

Exportable constants for region and country codes, designed for use with
L<Geo::Region> but available for standalone use as well.

=head2 Enumerations

=begin item
C<Region>

The UN M.49 region codes plus CLDR extensions B<EU> and B<QO>.

    World                  001
    • Africa               002
      ◦ EasternAfrica      014
      ◦ MiddleAfrica       017
      ◦ NorthernAfrica     015
      ◦ SouthernAfrica     018
      ◦ WesternAfrica      011
    • Americas             019
      ◦ Caribbean          029
      ◦ CentralAmerica     013
      ◦ LatinAmerica       419
      ◦ NorthAmerica       003
      ◦ NorthernAmerica    021
      ◦ SouthAmerica       005
    • Asia                 142
      ◦ CentralAsia        143
      ◦ EasternAsia        030
      ◦ SoutheastAsia      035
      ◦ SouthernAsia       034
      ◦ WesternAsia        145
    • Europe               150
      ◦ EasternEurope      151
      ◦ EuropeanUnion      EU
      ◦ NorthernEurope     154
      ◦ SouthernEurope     039
      ◦ WesternEurope      155
    • Oceania              009
      ◦ Australasia        053
      ◦ Melanesia          054
      ◦ MicronesianRegion  057
      ◦ OutlyingOceania    QO
      ◦ Polynesia          061

=end item

=begin item
C<Country>

The 249 officially assigned ISO 3166-1 alpha-2 codes.

    Afghanistan                       AF
    ÅlandIslands                      AX
    Albania                           AL
    Algeria                           DZ
    AmericanSamoa                     AS
    Andorra                           AD
    Angola                            AO
    Anguilla                          AI
    Antarctica                        AQ
    AntiguaBarbuda                    AG
    Argentina                         AR
    Armenia                           AM
    Aruba                             AW
    Australia                         AU
    Austria                           AT
    Azerbaijan                        AZ
    Bahamas                           BS
    Bahrain                           BH
    Bangladesh                        BD
    Barbados                          BB
    Belarus                           BY
    Belgium                           BE
    Belize                            BZ
    Benin                             BJ
    Bermuda                           BM
    Bhutan                            BT
    Bolivia                           BO
    Bosnia                            BA
    Botswana                          BW
    BouvetIsland                      BV
    Brazil                            BR
    BritishIndianOceanTerritory       IO
    BritishVirginIslands              VG
    Brunei                            BN
    Bulgaria                          BG
    BurkinaFaso                       BF
    Burundi                           BI
    Cambodia                          KH
    Cameroon                          CM
    Canada                            CA
    CapeVerde                         CV
    CaribbeanNetherlands              BQ
    CaymanIslands                     KY
    CentralAfricanRepublic            CF
    Chad                              TD
    Chile                             CL
    China                             CN
    ChristmasIsland                   CX
    CocosIslands                      CC
    Colombia                          CO
    Comoros                           KM
    CongoDRC                          CD
    CongoRepublic                     CG
    CookIslands                       CK
    CostaRica                         CR
    Croatia                           HR
    Cuba                              CU
    Curaçao                           CW
    Cyprus                            CY
    CzechRepublic                     CZ
    Denmark                           DK
    Djibouti                          DJ
    Dominica                          DM
    DominicanRepublic                 DO
    EastTimor                         TL
    Ecuador                           EC
    Egypt                             EG
    ElSalvador                        SV
    EquatorialGuinea                  GQ
    Eritrea                           ER
    Estonia                           EE
    Ethiopia                          ET
    FalklandIslands                   FK
    FaroeIslands                      FO
    Fiji                              FJ
    Finland                           FI
    France                            FR
    FrenchGuiana                      GF
    FrenchPolynesia                   PF
    FrenchSouthernTerritories         TF
    Gabon                             GA
    Gambia                            GM
    Georgia                           GE
    Germany                           DE
    Ghana                             GH
    Gibraltar                         GI
    Greece                            GR
    Greenland                         GL
    Grenada                           GD
    Guadeloupe                        GP
    Guam                              GU
    Guatemala                         GT
    Guernsey                          GG
    Guinea                            GN
    GuineaBissau                      GW
    Guyana                            GY
    Haiti                             HT
    HeardMcDonaldIslands              HM
    Honduras                          HN
    HongKong                          HK
    Hungary                           HU
    Iceland                           IS
    India                             IN
    Indonesia                         ID
    Iran                              IR
    Iraq                              IQ
    Ireland                           IE
    IsleofMan                         IM
    Israel                            IL
    Italy                             IT
    IvoryCoast                        CI
    Jamaica                           JM
    Japan                             JP
    Jersey                            JE
    Jordan                            JO
    Kazakhstan                        KZ
    Kenya                             KE
    Kiribati                          KI
    Kuwait                            KW
    Kyrgyzstan                        KG
    Laos                              LA
    Latvia                            LV
    Lebanon                           LB
    Lesotho                           LS
    Liberia                           LR
    Libya                             LY
    Liechtenstein                     LI
    Lithuania                         LT
    Luxembourg                        LU
    Macau                             MO
    Macedonia                         MK
    Madagascar                        MG
    Malawi                            MW
    Malaysia                          MY
    Maldives                          MV
    Mali                              ML
    Malta                             MT
    MarshallIslands                   MH
    Martinique                        MQ
    Mauritania                        MR
    Mauritius                         MU
    Mayotte                           YT
    Mexico                            MX
    Micronesia                        FM
    Moldova                           MD
    Monaco                            MC
    Mongolia                          MN
    Montenegro                        ME
    Montserrat                        MS
    Morocco                           MA
    Mozambique                        MZ
    Myanmar                           MM
    Namibia                           NA
    Nauru                             NR
    Nepal                             NP
    Netherlands                       NL
    NewCaledonia                      NC
    NewZealand                        NZ
    Nicaragua                         NI
    Niger                             NE
    Nigeria                           NG
    Niue                              NU
    NorfolkIsland                     NF
    NorthernMarianaIslands            MP
    NorthKorea                        KP
    Norway                            NO
    Oman                              OM
    Pakistan                          PK
    Palau                             PW
    Palestine                         PS
    Panama                            PA
    PapuaNewGuinea                    PG
    Paraguay                          PY
    Peru                              PE
    Philippines                       PH
    PitcairnIslands                   PN
    Poland                            PL
    Portugal                          PT
    PuertoRico                        PR
    Qatar                             QA
    Réunion                           RE
    Romania                           RO
    Russia                            RU
    Rwanda                            RW
    Samoa                             WS
    SanMarino                         SM
    SãoToméPríncipe                   ST
    SaudiArabia                       SA
    Senegal                           SN
    Serbia                            RS
    Seychelles                        SC
    SierraLeone                       SL
    Singapore                         SG
    SintMaarten                       SX
    Slovakia                          SK
    Slovenia                          SI
    SolomonIslands                    SB
    Somalia                           SO
    SouthAfrica                       ZA
    SouthGeorgiaSouthSandwichIslands  GS
    SouthKorea                        KR
    SouthSudan                        SS
    Spain                             ES
    SriLanka                          LK
    StBarthélemy                      BL
    StHelena                          SH
    StKittsNevis                      KN
    StLucia                           LC
    StMartin                          MF
    StPierreMiquelon                  PM
    StVincentGrenadines               VC
    Sudan                             SD
    Suriname                          SR
    SvalbardJanMayen                  SJ
    Swaziland                         SZ
    Sweden                            SE
    Switzerland                       CH
    Syria                             SY
    Taiwan                            TW
    Tajikistan                        TJ
    Tanzania                          TZ
    Thailand                          TH
    Togo                              TG
    Tokelau                           TK
    Tonga                             TO
    TrinidadTobago                    TT
    Tunisia                           TN
    Turkey                            TR
    Turkmenistan                      TM
    TurksCaicosIslands                TC
    Tuvalu                            TV
    Uganda                            UG
    Ukraine                           UA
    UnitedArabEmirates                AE
    UnitedKingdom                     GB
    UnitedStates                      US
    Uruguay                           UY
    USOutlyingIslands                 UM
    USVirginIslands                   VI
    Uzbekistan                        UZ
    Vanuatu                           VU
    VaticanCity                       VA
    Venezuela                         VE
    Vietnam                           VN
    WallisFutuna                      WF
    WesternSahara                     EH
    Yemen                             YE
    Zambia                            ZM
    Zimbabwe                          ZW

=end item

=head1 SEE ALSO

=item L<Geo::Region> — Geographical regions and groupings using UN M.49 and CLDR
data
=item L<Unicode CLDR: UN M.49 Territory
Containment|http://unicode.org/cldr/charts/26/supplemental/territory_containment_un_m_49.html>
=item L<United Nations: UN M.49 Standard Country, Area, & Region
Codes|http://unstats.un.org/unsd/methods/m49/m49regin.htm>
=item L<Geo::Region::Constant|https://metacpan.org/pod/Geo::Region::Constant>
for Perl 5

=head1 AUTHOR

Nick Patch <patch@cpan.org>

=head1 COPYRIGHT AND LICENSE

© 2014 Nick Patch

This library is free software; you can redistribute it and/or modify it under
the same terms as Perl 6 itself.

=end pod
