# Generated by default/object.tt
package Paws::LookoutMetrics::VpcConfiguration;
  use Moose;
  has SecurityGroupIdList => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has SubnetIdList => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::VpcConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::VpcConfiguration object:

  $service_obj->Method(Att1 => { SecurityGroupIdList => $value, ..., SubnetIdList => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::VpcConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->SecurityGroupIdList

=head1 DESCRIPTION

Contains configuration information about the Amazon Virtual Private
Cloud (VPC).

=head1 ATTRIBUTES


=head2 B<REQUIRED> SecurityGroupIdList => ArrayRef[Str|Undef]

An array of strings containing the list of security groups.


=head2 B<REQUIRED> SubnetIdList => ArrayRef[Str|Undef]

An array of strings containing the Amazon VPC subnet IDs (e.g.,
C<subnet-0bb1c79de3EXAMPLE>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

