package Grpc::Constants;

use strict;
use warnings;

use Grpc::XS::Constants;

use base qw(Exporter);

our @EXPORT_OK = qw(
  GRPC_CALL_OK
  GRPC_CALL_ERROR
  GRPC_CALL_ERROR_NOT_ON_SERVER
  GRPC_CALL_ERROR_NOT_ON_CLIENT
  GRPC_CALL_ERROR_ALREADY_INVOKED
  GRPC_CALL_ERROR_NOT_INVOKED
  GRPC_CALL_ERROR_ALREADY_FINISHED
  GRPC_CALL_ERROR_TOO_MANY_OPERATIONS
  GRPC_CALL_ERROR_INVALID_FLAGS
  GRPC_WRITE_BUFFER_HINT
  GRPC_WRITE_NO_COMPRESS
  GRPC_STATUS_OK
  GRPC_STATUS_CANCELLED
  GRPC_STATUS_UNKNOWN
  GRPC_STATUS_INVALID_ARGUMENT
  GRPC_STATUS_DEADLINE_EXCEEDED
  GRPC_STATUS_NOT_FOUND
  GRPC_STATUS_ALREADY_EXISTS
  GRPC_STATUS_PERMISSION_DENIED
  GRPC_STATUS_UNAUTHENTICATED
  GRPC_STATUS_RESOURCE_EXHAUSTED
  GRPC_STATUS_FAILED_PRECONDITION
  GRPC_STATUS_ABORTED
  GRPC_STATUS_OUT_OF_RANGE
  GRPC_STATUS_UNIMPLEMENTED
  GRPC_STATUS_INTERNAL
  GRPC_STATUS_UNAVAILABLE
  GRPC_STATUS_DATA_LOSS
  GRPC_OP_SEND_INITIAL_METADATA
  GRPC_OP_SEND_MESSAGE
  GRPC_OP_SEND_CLOSE_FROM_CLIENT
  GRPC_OP_SEND_STATUS_FROM_SERVER
  GRPC_OP_RECV_INITIAL_METADATA
  GRPC_OP_RECV_MESSAGE
  GRPC_OP_RECV_STATUS_ON_CLIENT
  GRPC_OP_RECV_CLOSE_ON_SERVER
  GRPC_CHANNEL_IDLE
  GRPC_CHANNEL_CONNECTING
  GRPC_CHANNEL_READY
  GRPC_CHANNEL_TRANSIENT_FAILURE
  GRPC_CHANNEL_SHUTDOWN
  GPR_CLOCK_MONOTONIC
  GPR_CLOCK_REALTIME
  GPR_CLOCK_PRECISE
  GPR_TIMESPAN
);

sub GRPC_CALL_OK { return Grpc::XS::Constants::CALL_OK; }
sub GRPC_CALL_ERROR { return Grpc::XS::Constants::CALL_ERROR; }
sub GRPC_CALL_ERROR_NOT_ON_SERVER { return Grpc::XS::Constants::CALL_ERROR_NOT_ON_SERVER; }
sub GRPC_CALL_ERROR_NOT_ON_CLIENT { return Grpc::XS::Constants::CALL_ERROR_NOT_ON_CLIENT; }
sub GRPC_CALL_ERROR_ALREADY_INVOKED { return Grpc::XS::Constants::CALL_ERROR_ALREADY_INVOKED; }
sub GRPC_CALL_ERROR_NOT_INVOKED { return Grpc::XS::Constants::CALL_ERROR_NOT_INVOKED; }
sub GRPC_CALL_ERROR_ALREADY_FINISHED { return Grpc::XS::Constants::CALL_ERROR_ALREADY_FINISHED; }
sub GRPC_CALL_ERROR_TOO_MANY_OPERATIONS { return Grpc::XS::Constants::CALL_ERROR_TOO_MANY_OPERATIONS; }
sub GRPC_CALL_ERROR_INVALID_FLAGS { return Grpc::XS::Constants::CALL_ERROR_INVALID_FLAGS; }
sub GRPC_WRITE_BUFFER_HINT { return Grpc::XS::Constants::WRITE_BUFFER_HINT; }
sub GRPC_WRITE_NO_COMPRESS { return Grpc::XS::Constants::WRITE_NO_COMPRESS; }
sub GRPC_STATUS_OK { return Grpc::XS::Constants::STATUS_OK; }
sub GRPC_STATUS_CANCELLED { return Grpc::XS::Constants::STATUS_CANCELLED; }
sub GRPC_STATUS_UNKNOWN { return Grpc::XS::Constants::STATUS_UNKNOWN; }
sub GRPC_STATUS_INVALID_ARGUMENT { return Grpc::XS::Constants::STATUS_INVALID_ARGUMENT; }
sub GRPC_STATUS_DEADLINE_EXCEEDED { return Grpc::XS::Constants::STATUS_DEADLINE_EXCEEDED; }
sub GRPC_STATUS_NOT_FOUND { return Grpc::XS::Constants::STATUS_NOT_FOUND; }
sub GRPC_STATUS_ALREADY_EXISTS { return Grpc::XS::Constants::STATUS_ALREADY_EXISTS; }
sub GRPC_STATUS_PERMISSION_DENIED { return Grpc::XS::Constants::STATUS_PERMISSION_DENIED; }
sub GRPC_STATUS_UNAUTHENTICATED { return Grpc::XS::Constants::STATUS_UNAUTHENTICATED; }
sub GRPC_STATUS_RESOURCE_EXHAUSTED { return Grpc::XS::Constants::STATUS_RESOURCE_EXHAUSTED; }
sub GRPC_STATUS_FAILED_PRECONDITION { return Grpc::XS::Constants::STATUS_FAILED_PRECONDITION; }
sub GRPC_STATUS_ABORTED { return Grpc::XS::Constants::STATUS_ABORTED; }
sub GRPC_STATUS_OUT_OF_RANGE { return Grpc::XS::Constants::STATUS_OUT_OF_RANGE; }
sub GRPC_STATUS_UNIMPLEMENTED { return Grpc::XS::Constants::STATUS_UNIMPLEMENTED; }
sub GRPC_STATUS_INTERNAL { return Grpc::XS::Constants::STATUS_INTERNAL; }
sub GRPC_STATUS_UNAVAILABLE { return Grpc::XS::Constants::STATUS_UNAVAILABLE; }
sub GRPC_STATUS_DATA_LOSS { return Grpc::XS::Constants::STATUS_DATA_LOSS; }
sub GRPC_OP_SEND_INITIAL_METADATA { return Grpc::XS::Constants::OP_SEND_INITIAL_METADATA; }
sub GRPC_OP_SEND_MESSAGE { return Grpc::XS::Constants::OP_SEND_MESSAGE; }
sub GRPC_OP_SEND_CLOSE_FROM_CLIENT { return Grpc::XS::Constants::OP_SEND_CLOSE_FROM_CLIENT; }
sub GRPC_OP_SEND_STATUS_FROM_SERVER { return Grpc::XS::Constants::OP_SEND_STATUS_FROM_SERVER; }
sub GRPC_OP_RECV_INITIAL_METADATA { return Grpc::XS::Constants::OP_RECV_INITIAL_METADATA; }
sub GRPC_OP_RECV_MESSAGE { return Grpc::XS::Constants::OP_RECV_MESSAGE; }
sub GRPC_OP_RECV_STATUS_ON_CLIENT { return Grpc::XS::Constants::OP_RECV_STATUS_ON_CLIENT; }
sub GRPC_OP_RECV_CLOSE_ON_SERVER { return Grpc::XS::Constants::OP_RECV_CLOSE_ON_SERVER; }
sub GRPC_CHANNEL_IDLE { return Grpc::XS::Constants::CHANNEL_IDLE; }
sub GRPC_CHANNEL_CONNECTING { return Grpc::XS::Constants::CHANNEL_CONNECTING; }
sub GRPC_CHANNEL_READY { return Grpc::XS::Constants::CHANNEL_READY; }
sub GRPC_CHANNEL_TRANSIENT_FAILURE { return Grpc::XS::Constants::CHANNEL_TRANSIENT_FAILURE; }
sub GRPC_CHANNEL_SHUTDOWN { return Grpc::XS::Constants::CHANNEL_FATAL_FAILURE; }
sub GPR_CLOCK_MONOTONIC { return Grpc::XS::Constants::XS_GPR_CLOCK_MONOTONIC; }
sub GPR_CLOCK_REALTIME { return Grpc::XS::Constants::XS_GPR_CLOCK_REALTIME; }
sub GPR_CLOCK_PRECISE { return Grpc::XS::Constants::XS_GPR_CLOCK_PRECISE; }
sub GPR_TIMESPAN { return Grpc::XS::Constants::XS_GPR_TIMESPAN; }

1;
