=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::SlideShowTransition;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;


use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Slide Show Transition.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Slide Show Transition.',
                                  class => 'SlideShowTransition',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'type' => {
    	datatype => 'string',
    	base_name => 'Type',
    	description => 'Transition Type',
    	format => '',
    	read_only => '',
    		},
    'advance_after' => {
    	datatype => 'boolean',
    	base_name => 'AdvanceAfter',
    	description => 'Advance After',
    	format => '',
    	read_only => '',
    		},
    'advance_after_time' => {
    	datatype => 'int',
    	base_name => 'AdvanceAfterTime',
    	description => 'Advance After Time',
    	format => '',
    	read_only => '',
    		},
    'advance_on_click' => {
    	datatype => 'boolean',
    	base_name => 'AdvanceOnClick',
    	description => 'Advance On Click',
    	format => '',
    	read_only => '',
    		},
    'sound_is_built_in' => {
    	datatype => 'boolean',
    	base_name => 'SoundIsBuiltIn',
    	description => 'Sound Is Built In',
    	format => '',
    	read_only => '',
    		},
    'sound_loop' => {
    	datatype => 'boolean',
    	base_name => 'SoundLoop',
    	description => 'Sound Loop',
    	format => '',
    	read_only => '',
    		},
    'sound_mode' => {
    	datatype => 'string',
    	base_name => 'SoundMode',
    	description => 'Sound Mode',
    	format => '',
    	read_only => '',
    		},
    'sound_name' => {
    	datatype => 'string',
    	base_name => 'SoundName',
    	description => 'Sound Name',
    	format => '',
    	read_only => '',
    		},
    'speed' => {
    	datatype => 'string',
    	base_name => 'Speed',
    	description => 'Speed',
    	format => '',
    	read_only => '',
    		},
    'corner_direction' => {
    	datatype => 'string',
    	base_name => 'CornerDirection',
    	description => 'Corner Direction.',
    	format => '',
    	read_only => '',
    		},
    'eight_direction' => {
    	datatype => 'string',
    	base_name => 'EightDirection',
    	description => 'Eight Direction.',
    	format => '',
    	read_only => '',
    		},
    'in_out_direction' => {
    	datatype => 'string',
    	base_name => 'InOutDirection',
    	description => 'In/Out Direction.',
    	format => '',
    	read_only => '',
    		},
    'has_bounce' => {
    	datatype => 'boolean',
    	base_name => 'HasBounce',
    	description => 'Has Bounce.',
    	format => '',
    	read_only => '',
    		},
    'side_direction' => {
    	datatype => 'string',
    	base_name => 'SideDirection',
    	description => 'Side Direction.',
    	format => '',
    	read_only => '',
    		},
    'pattern' => {
    	datatype => 'string',
    	base_name => 'Pattern',
    	description => 'Pattern.',
    	format => '',
    	read_only => '',
    		},
    'left_right_direction' => {
    	datatype => 'string',
    	base_name => 'LeftRightDirection',
    	description => 'Left/Right Direction.',
    	format => '',
    	read_only => '',
    		},
    'morph_type' => {
    	datatype => 'string',
    	base_name => 'MorphType',
    	description => 'Morph Type.',
    	format => '',
    	read_only => '',
    		},
    'from_black' => {
    	datatype => 'boolean',
    	base_name => 'FromBlack',
    	description => 'From Black.',
    	format => '',
    	read_only => '',
    		},
    'orientation_direction' => {
    	datatype => 'string',
    	base_name => 'OrientationDirection',
    	description => 'Orientation Direction.',
    	format => '',
    	read_only => '',
    		},
    'through_black' => {
    	datatype => 'boolean',
    	base_name => 'ThroughBlack',
    	description => 'Through Black.',
    	format => '',
    	read_only => '',
    		},
    'corner_and_center_direction' => {
    	datatype => 'string',
    	base_name => 'CornerAndCenterDirection',
    	description => 'Orientation.',
    	format => '',
    	read_only => '',
    		},
    'shred_pattern' => {
    	datatype => 'string',
    	base_name => 'ShredPattern',
    	description => 'Shred Pattern.',
    	format => '',
    	read_only => '',
    		},
    'orientation' => {
    	datatype => 'string',
    	base_name => 'Orientation',
    	description => 'Orientation.',
    	format => '',
    	read_only => '',
    		},
    'spokes' => {
    	datatype => 'int',
    	base_name => 'Spokes',
    	description => 'Spokes.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'type' => 'string',
    'advance_after' => 'boolean',
    'advance_after_time' => 'int',
    'advance_on_click' => 'boolean',
    'sound_is_built_in' => 'boolean',
    'sound_loop' => 'boolean',
    'sound_mode' => 'string',
    'sound_name' => 'string',
    'speed' => 'string',
    'corner_direction' => 'string',
    'eight_direction' => 'string',
    'in_out_direction' => 'string',
    'has_bounce' => 'boolean',
    'side_direction' => 'string',
    'pattern' => 'string',
    'left_right_direction' => 'string',
    'morph_type' => 'string',
    'from_black' => 'boolean',
    'orientation_direction' => 'string',
    'through_black' => 'boolean',
    'corner_and_center_direction' => 'string',
    'shred_pattern' => 'string',
    'orientation' => 'string',
    'spokes' => 'int'
} );

__PACKAGE__->attribute_map( {
    'type' => 'Type',
    'advance_after' => 'AdvanceAfter',
    'advance_after_time' => 'AdvanceAfterTime',
    'advance_on_click' => 'AdvanceOnClick',
    'sound_is_built_in' => 'SoundIsBuiltIn',
    'sound_loop' => 'SoundLoop',
    'sound_mode' => 'SoundMode',
    'sound_name' => 'SoundName',
    'speed' => 'Speed',
    'corner_direction' => 'CornerDirection',
    'eight_direction' => 'EightDirection',
    'in_out_direction' => 'InOutDirection',
    'has_bounce' => 'HasBounce',
    'side_direction' => 'SideDirection',
    'pattern' => 'Pattern',
    'left_right_direction' => 'LeftRightDirection',
    'morph_type' => 'MorphType',
    'from_black' => 'FromBlack',
    'orientation_direction' => 'OrientationDirection',
    'through_black' => 'ThroughBlack',
    'corner_and_center_direction' => 'CornerAndCenterDirection',
    'shred_pattern' => 'ShredPattern',
    'orientation' => 'Orientation',
    'spokes' => 'Spokes'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
