/* Copyright (C) 1991, 1996, 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <errno.h>
#define __USE_GNU
#include <signal.h>
#define __need_NULL
#include <stddef.h>

/* Combine sets LEFT and RIGHT by logical OR and place result in DEST.  */
int sigorset (sigset_t *dest, const sigset_t *left, const sigset_t *right)
{
    if (dest == NULL || left == NULL || right == NULL)
    {
	__set_errno (EINVAL);
	return -1;
    }

    return __sigorset (dest, left, right);
}
