/*
 *    regchecker - watch out for registers that are not correctly saved/restored
 *    Copyright (C) 2005  Tony Luck, Intel Corporation
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>

#define SAVESZ	((128*2 + 32 + 8 + 6 + 1) * 8) /* FP + r0-r31 + BR + AR + PR */
#define RANDSZ	((128*2 + 32 + 40 + 8 + 6 + 1) * 8) /* FP + r0-r31 + OUT + BR + AR + PR */

extern long *regcheck(long *, long *);

int
main(int argc, char **argv)
{
	long *save = malloc(SAVESZ);
	long *rand = malloc(RANDSZ);
	long *r;
	int	i, fd = open("/dev/urandom", 0);

	if (save == NULL || rand == NULL) {
		fprintf(stderr, "Can't allocate buffers\n");
		return 1;
	}
	if (fd == -1) {
		fprintf(stderr, "Can't read /dev/urandom\n");
		return 1;
	}

	for (i = 0; i < 10000; i++) {
		if (read(fd, rand, RANDSZ) != RANDSZ) {
			perror("read(/dev/urandom)");
			return 1;
		}
		if (r = regcheck(save, rand)) {
			int reg = r - rand;
			if (reg < 256) {
				fprintf(stderr, "f%d\n", reg/2);
				return 1;
			}
			reg -= 256;
			if (reg < 32) {
				fprintf(stderr, "r%d\n", reg);
				return 1;
			}
			reg -= 32;
			if (reg < 40) {
				fprintf(stderr, "out%d\n", reg);
				return 1;
			}
			reg -= 40;
			if (reg < 8) {
				fprintf(stderr, "b%d\n", reg);
				return 1;
			}
			reg -= 8;
			switch (reg) {
			case 0: fprintf(stderr, "ar.csd\n"); return 1;
			case 1: fprintf(stderr, "ar.ssd\n"); return 1;
			case 2: fprintf(stderr, "ar.ccv\n"); return 1;
			case 3: fprintf(stderr, "ar.unat\n"); return 1;
			case 4: fprintf(stderr, "ar.lc\n"); return 1;
			case 5: fprintf(stderr, "ar.ec\n"); return 1;
			case 6: fprintf(stderr, "pr\n"); return 1;
			default: fprintf(stderr, "! %d\n", r - rand); return 1;
			}
		}
	}
	return 0;
}
