#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>

#include <uri.h>
#include <salloc.h>
#include <md5str.h>
#include <file_exists.h>
#include <mkdirp.h>
#include <split.h>
#include <errno.h>

static int fileok(char* file, int file_length);

static void furi2md5(char* path)
{
  uri_t* uri = uri_alloc("/", 1);
  FILE* fp = fopen(path, "r");
#define BUFSIZE 50 * 1024
  char buffer[BUFSIZE];
  char* furi_md5 = 0;
  int furi_md5_size = 0;
  char* furi = 0;
  int furi_size = 0;
  char* dir = getenv("WLROOT");
  int dir_length = dir ? strlen(dir) : 0;
  char* slash = dir ? "/" : "";

  if(fp == 0) {
    perror("");
    exit(1);
  }
  while(fgets(buffer, BUFSIZE, fp)) {
    /* Strip newline */
    int buffer_length = strlen(buffer) - 1;
    buffer[buffer_length] = '\0';
    if(uri_realloc(uri, buffer, buffer_length) == URI_CANNONICAL &&
       !(uri_info(uri) & URI_INFO_RELATIVE)) {
      char* from;
      char* to;

      uri_string(uri, &furi, &furi_size, URI_STRING_FURI_STYLE);
      from = smalloc(dir_length + strlen(furi) + 16);
      sprintf(from, "%s%s%s.store", (dir ? dir : ""), slash, furi);

      uri_string(uri, &furi_md5, &furi_md5_size, URI_STRING_FURI_STYLE|URI_STRING_FURI_MD5);
      to = smalloc(dir_length + strlen(furi_md5) + 16);
      sprintf(to, "%s%s%s.store", (dir ? dir : ""), slash, furi_md5);

      if(fileok(from, strlen(from)) && file_exists(from)) {
	/*
	 * Build directory
	 */
	{
	  char* slash = strrchr(to, '/');
	  if(!slash) {
	    fprintf(stderr, "could not find last / in %s\n", to);
	    exit(1);
	  }
	  *slash = '\0';
	  mkdirp(to, 0777);
	  *slash = '/';
	}
	/*
	 * Move file
	 */
	if(rename(from, to)) {
	  fprintf(stderr, "# failed mv %s %s ", from, to);
	  perror("");
	} else {
	  fprintf(stderr, "mv %s %s\n", from, to);
	}
      } else {
	/*
	 * Skip non existent files or file with name to
	 */
	fprintf(stderr, "# %s\n", from);
      }
      free(from);
      free(to);
    } else {
      fprintf(stderr, "%s not cannonical\n", buffer);
    }
  }
  fclose(fp);
}

static int fileok(char* file, int file_length)
{
  char** splitted;
  int count;
  int i;

  if(file_length == 0)
    return 0;

  split(file, file_length, &splitted, &count, '/', SPLIT_TRIM);

  for(i = 0; i < count; i++) {
    if(strlen(splitted[i]) >= MAXNAMLEN)
      return 0;
  }

  return 1;
}

int main(int argc, char** argv)
{
  if(argc != 2 || !file_exists(argv[1])) {
    fprintf(stderr, "usage: furi2md5 path\n\
rename all files in $WLROOT/FURI into $WLROOT/FURI_MD5. The list\n\
of files is built from the URLs found in path, one per line.\n\
See uri(3) for information about FURI and FURI using MD5 key.\n\
\n\
This usage is shown if no argument was given, if more than one argument\n\
was given or if the path is not an existing file.\n\
");
  } else {
    furi2md5(argv[1]);
  }
  return 0;
}
