/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 text.c - textview print functions

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "text.h"

GtkTextTag* tag[TAG_N];
GtkTextTagTable* text_table;

static void text_table_init(void) {
  int i;

  text_table = gtk_text_tag_table_new();

  for (i = TAG_NORMAL; i < TAG_N; i++) {
    gtk_text_tag_table_add(text_table, tag[i]);
  }
}

void text_init(void) {

  tag[TAG_NONE] = NULL;

  tag[TAG_NORMAL] = gtk_text_tag_new(NULL);
  g_object_set(G_OBJECT(tag[TAG_NORMAL]), NULL);

  tag[TAG_STDOUT] = gtk_text_tag_new(NULL);
  g_object_set(G_OBJECT(tag[TAG_STDOUT]), NULL);

  tag[TAG_STDERR] = gtk_text_tag_new(NULL);
  g_object_set(G_OBJECT(tag[TAG_STDERR]),
	       "foreground", "red", "foreground-set", TRUE, NULL);

  tag[TAG_SPAWN] = gtk_text_tag_new(NULL);
  g_object_set(G_OBJECT(tag[TAG_SPAWN]), 
	       "weight", PANGO_WEIGHT_BOLD, "weight-set", TRUE, 
	       "pixels-above-lines", bw/2, "pixels-above-lines-set", TRUE,
	       "pixels-below-lines", bw/2, "pixels-below-lines-set", TRUE,
	       NULL);

  text_table_init();
}

void text_print(GtkTextView* view, char* newtext, int tidx) {
  GtkTextBuffer* txt;
  GtkTextIter start; gint offset;
  GtkTextIter end;

  txt = gtk_text_view_get_buffer(GTK_TEXT_VIEW(view));

  gtk_text_buffer_get_end_iter(txt, &start);
  offset = gtk_text_iter_get_offset(&start);

  if (newtext)
    gtk_text_buffer_insert(txt, &start, newtext, strlen(newtext));

  if (tidx != TAG_NONE) {
    gtk_text_buffer_get_iter_at_offset(txt, &start, offset);
    gtk_text_buffer_get_end_iter(txt, &end);

    gtk_text_buffer_apply_tag(txt, tag[tidx], &start, &end);
  }
}

GtkWidget* text_new(void) {
  GtkWidget* view;
  GtkTextBuffer* buffer;

  buffer = gtk_text_buffer_new(text_table);
  view = gtk_text_view_new_with_buffer(buffer);
  return view;
} 
