/*
 * GNU POC (passwords on card) - manage passwords on smartcards
 * Copyright (C) 2001 Henning Koester <henning@crackinghacking.de>
 *
 * Please report bugs to bug-poc@gnu.org
 *
 * This file is part of POC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: missing_libs.h,v 1.2 2001/08/18 16:15:18 henning Exp $ */

#ifndef _MISSING_LIBS_H_
#define _MISSING_LIBS_H_

#ifndef HAVE_STRCASECMP
int strcasecmp (const char *, const char *);
int strncasecmp (const char *, const char *, size_t);
#endif

#ifndef HAVE_STRTOK
char *strtok (char *, const char *);
#endif

#ifndef HAVE_BYTESWAP_H
#define bswap_16(x) __bswap_16 (x)
#if defined __GNUC__ && __GNUC__ >= 2
/* Return a value with all bytes in the 64 bit argument swapped.  */
# define bswap_64(x) __bswap_64 (x)
#endif 

/* Swap bytes in 16 bit value.  */
#define __bswap_constant_16(x) \
     ((((x) >> 8) & 0xff) | (((x) & 0xff) << 8))

#if defined __GNUC__ && __GNUC__ >= 2
# define __bswap_16(x) \
     (__extension__                                                           \
      ({ register unsigned short int __v;                                     \
         if (__builtin_constant_p (x))                                        \
           __v = __bswap_constant_16 (x);                                     \
         else                                                                 \
           __asm__ __volatile__ ("rorw $8, %w0"                               \
                                 : "=r" (__v)                                 \
                                 : "0" ((unsigned short int) (x))             \
                                 : "cc");                                     \
         __v; }))
#else
/* This is better than nothing.  */
# define __bswap_16(x) __bswap_constant_16 (x)
#endif

#define __bswap_64(x) \
     ((((x) & 0xff00000000000000ull) >> 56)                                   \
      | (((x) & 0x00ff000000000000ull) >> 40)                                 \
      | (((x) & 0x0000ff0000000000ull) >> 24)                                 \
      | (((x) & 0x000000ff00000000ull) >> 8)                                  \
      | (((x) & 0x00000000ff000000ull) << 8)                                  \
      | (((x) & 0x0000000000ff0000ull) << 24)                                 \
      | (((x) & 0x000000000000ff00ull) << 40)                                 \
      | (((x) & 0x00000000000000ffull) << 56))

#endif /* _HAVE_BYTESWAP_H_ */

#endif /* _MISSING_LIBS_H_ */
