/*
 * GNU POC (passwords on card) - manage passwords on smartcards
 * Copyright (C) 2001 Henning Koester <henning@crackinghacking.de>
 *
 * Please report bugs to bug-poc@gnu.org
 *
 * This file is part of POC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: card.h,v 1.4 2001/08/18 16:07:00 henning Exp $ */

#ifndef _CARD_H_
#define _CARD_H_

#include "poc_types.h"

/* CT-API */
#define CARD          0  /* card */
#define TERMINAL      1  /* card reader */ 
#define HOST          2  /* host */

/* return of REQUEST_ICC */
#define MEMORY_CARD     0x9000

bool card_init_terminal (const u16, const u16);
void card_close_terminal (const u16);
u16 card_request_icc (const u16);
bool card_reset_terminal (const u16);
char card_read_data (const u16, u16, int, u8 * const);
char card_write_data (const u16, u16, int, u8 * const);
char card_select_file (const u16);

#endif /* _CARD_H_ */

