# Typist v2.2 - improved typing tutor program for UNIX systems
# Copyright (C) 1998  Simon Baldwin (simonb@sco.com)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#

#------------------------------------------------------------------------------
# Series T
#------------------------------------------------------------------------------
G:_T_MENU
*:_T_NO_MENU
#------------------------------------------------------------------------------
# Lesson T1
#------------------------------------------------------------------------------
*:T1
*:_T_S_T1
*:_T_R_L0
#                                                              ../orig/t.typ:21
T:			Welcome to lesson T1.
 :
 :In the T series of lessons, we will be learning to touch-type on the standard
 :keyboard.  I will introduce you to each letter on the keyboard, one at a time.
 :By the time you have completed this series, you will be able to type the entire
 :alphabet, the numbers, and most of the punctuation keys by touch.
 :
 :If you have never taken any lessons in typing before, please be patient.  Typing
 :is not difficult but it does take a lot of practice.  Avoid the tendency to
 :look down at your fingers while typing.  This is a very bad habit and is hard
 :to break later.  If you hit the wrong key, I will let you know.  (But, I won't
 :tell anyone else, so don't worry about it.)
 :
 :If you have always used the hunt-and-peck method, you will have an even harder
 :time keeping yourself from looking.  Don't be surprised if you find touch
 :typing slower than your old ways.  It may be slower when you first start.
 :But, touch typing is far faster once you get the hang of it.
 :
 :If you can already touch type, you should be able to go through these lessons
 :fairly quickly.  Or, you may want to go directly to the S series.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L0

*:_T_R_L1
#                                                              ../orig/t.typ:42
T:
 :			The HOME Keys.
 :
 :In order to hit the correct keys by touch alone, you must always know where your
 :fingers are.  The way to do this is to have a special place for each finger.
 :This key is called the HOME position.
 :
 :Place the first finger of your right hand on the J-key.  Now, place your second
 :finger on the K-key, your third finger on the L-key, and your fourth-finger on
 :the ;-key (the one with the : and ; on it).
 :
 :Similarly place the four fingers of your left hand on the F, D, S, and A-keys.
 :Place your right thumb over the SPACE bar.  (Henceforth, always hit the SPACE
 :bar with this thumb.)  Now, lift all your fingers slightly so that they are
 :poised just over the keys.  Each finger should be just barely touching its home
 :key.  This is an electronic keyboard and does not take much pressure to ac-
 :cidentally press the key down.
 :
 :Learn these positions well.  Whenever you are about to type a line, look at your
 :fingers and make sure they are in the HOME position.  Then don't look at them
 :again.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L1

*:_T_R_L2
#                                                              ../orig/t.typ:63
T:
 :			DRILL PATTERNS
 :
 :For the rest of this lesson, I will display a line of text in the middle of the
 :screen and instructions at the top of the screen.
 :
 :All you have to do is type in the characters that you see in the middle of
 :the screen.  If you hit the correct key, I will not do anything.  If you make
 :a mistake, I will display a large X under the letter that you got wrong and 
 :beep the terminal. In either event, just keep going by typing the next letter.
 :
 :When you have finished typing the line, hit the RETURN key.  To do this, extend
 :the little finger of your right hand over to the RETURN key.  Hit the key and
 :zip the finger back to its home position.  Be careful not to let your other
 :fingers move far from their home positions in the process.  Also, be careful
 :not to type an extra space at the end of the line.
 :
 :If you made no mistakes on the line, I will display the next drill pattern.  If
 :you did make a mistake, I will beep at you and make you do the line again.  If
 :on the second try you made more than two mistakes, I will beep again and make
 :you try again, etc.  Don't forget to use your right thumb for the SPACE bar.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L2

#                                                              ../orig/t.typ:64
I:Hit the F-key four times with the first finger of your left hand.
*:_T_R_L3
#                                                              ../orig/t.typ:65
O:ffff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L3

#                                                              ../orig/t.typ:66
I:Alternately, hit the F-key and the SPACE bar.
*:_T_R_L4
#                                                              ../orig/t.typ:67
O:fff fff fff ff ff ff f f f
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L4

#                                                              ../orig/t.typ:68
I:Don't look at your hands!
#                                                              ../orig/t.typ:69
 :Hit the J-key with the first finger of your right hand.
*:_T_R_L5
#                                                              ../orig/t.typ:70
O:jjj jjj jjj jj jj jj j j j
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L5

#                                                              ../orig/t.typ:71
I:Use the left hand for the F and the right hand for the J.
*:_T_R_L6
#                                                              ../orig/t.typ:72
O:fff jjj fff jj ff jj f j f j
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L6

#                                                              ../orig/t.typ:73
I:Now intermix them.
*:_T_R_L7
#                                                              ../orig/t.typ:74
O:ffjj jjff fjf fjf jfj jfj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L7

#                                                              ../orig/t.typ:75
I:Use the second finger of the left hand for the D-key.
*:_T_R_L8
#                                                              ../orig/t.typ:76
O:ddd ddd ddd dd dd dd d d d
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L8

#                                                              ../orig/t.typ:77
I:Use the second finger of the right hand for the K-key.
*:_T_R_L9
#                                                              ../orig/t.typ:78
O:kkk kkk kkk kk kk kk k k k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L9

#                                                              ../orig/t.typ:80
I:Now both.
*:_T_R_L10
#                                                              ../orig/t.typ:81
O:ddd kkk dd kk dkd kdk ddd kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L10

#                                                              ../orig/t.typ:82
I:Use the third fingers of the each hand for the S and L-keys.
*:_T_R_L11
#                                                              ../orig/t.typ:83
O:sss lll sss lll sss ss ll ss ll s l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L11

#                                                              ../orig/t.typ:84
I:Use the fourth fingers for the A and ;-keys.
*:_T_R_L12
#                                                              ../orig/t.typ:85
O:aaa ;;; aaa ;;; aa ;; aa ;; a ;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L12

#                                                              ../orig/t.typ:86
I:That's enough keys for today.  Let's review them.
*:_T_R_L13
#                                                              ../orig/t.typ:87
O:fff jjj ddd kkk sss lll aaa ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L13

#                                                              ../orig/t.typ:88
I:Again.
*:_T_R_L14
#                                                              ../orig/t.typ:89
O:fff jjj ddd kkk sss lll aaa ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L14

#                                                              ../orig/t.typ:90
I:Try mixing them together.
*:_T_R_L15
#                                                              ../orig/t.typ:91
O:asdf jkl; asdf jkl; asdf jkl;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L15

#                                                              ../orig/t.typ:92
I:And still more.
*:_T_R_L16
#                                                              ../orig/t.typ:93
O:fjf kdk sls ;a;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L16

#                                                              ../orig/t.typ:94
I:Before, we finish, let's try some words.
*:_T_R_L17
#                                                              ../orig/t.typ:95
O:sad add all; alas flask fad
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L17

#                                                              ../orig/t.typ:96
I:How about a sentence.
*:_T_R_L18
#                                                              ../orig/t.typ:97
O:ask a sad lad
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L18

#                                                              ../orig/t.typ:98
I:Sentences are kind of limited with only one vowel!
*:_T_R_L19
#                                                              ../orig/t.typ:99
O:dad asks a lad; a lass falls
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L19

G:_T_E_T1
#------------------------------------------------------------------------------
# Lesson T2
#------------------------------------------------------------------------------
*:T2
*:_T_S_T2
*:_T_R_L20
#                                                             ../orig/t.typ:114
T:
 :In this lesson, we will review the letters that you have already practiced
 :and will add the letters E, G, and H and the period.
 :
 :When you reach for any of these keys, be sure to return your finger to its
 :home position.  For example, to hit the H-key, move the first finger of your
 :right hand (the J-finger) slightly to the left.  Tap the H-key and immediately
 :bring your finger back over the J.
 :
 :If you lose track of where your fingers are guess.  Don't look!
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L20

#                                                             ../orig/t.typ:115
I:First let's review
*:_T_R_L21
#                                                             ../orig/t.typ:116
O:fff jjj ddd kkk sss lll aaa ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L21

*:_T_R_L22
#                                                             ../orig/t.typ:120
O:asdf jkl; fdsa ;lkj
 :fjf jfj dkd kdk sls lsl a;a ;a;
 :jkj jlj j;j fdf fsf faf
 :a sad lass; ask dad;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L22

#                                                             ../orig/t.typ:121
I:Use your J-finger for the H key.
*:_T_R_L23
#                                                             ../orig/t.typ:122
O:jjj jhj jjj jhj jjj jhj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L23

*:_T_R_L24
#                                                             ../orig/t.typ:125
O:jjj hhh jjj hhh jj hh j h j h
 :jjj had jjj ash jjj has jjj
 :jjj sash jjj hash jjj hall jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L24

#                                                             ../orig/t.typ:126
I:Use your F-finger for the G-key.
*:_T_R_L25
#                                                             ../orig/t.typ:127
O:fff fgf fff fgf fff fgf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L25

*:_T_R_L26
#                                                             ../orig/t.typ:130
O:fff ggg fff ggg fff ggg
 :fff gag fff lag fff flag fff
 :fff sag fff slag fff hag fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L26

#                                                             ../orig/t.typ:131
I:Use your D-finger for the E-key
*:_T_R_L27
#                                                             ../orig/t.typ:132
O:ddd ded ddd ded ddd ded ddd
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L27

*:_T_R_L28
#                                                             ../orig/t.typ:135
O:ddd eee ddd eee dd ee dd ee d e
 :ddd fee ddd see ddd elf ddd
 :lake asked fake gale egg
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L28

#                                                             ../orig/t.typ:136
I:Use your K-finger for the comma.
*:_T_R_L29
#                                                             ../orig/t.typ:137
O:kkk k,k kkk k,k kkk k,k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L29

*:_T_R_L30
#                                                             ../orig/t.typ:138
O:kkk ,,, kkk ,,, kkk ,,, kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L30

#                                                             ../orig/t.typ:139
I:Let's finish with some sentences.
*:_T_R_L31
#                                                             ../orig/t.typ:140
O:a lad had a flask, dad had a keg
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L31

*:_T_R_L32
#                                                             ../orig/t.typ:141
O:she had a fake egg, he had a salad
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L32

G:_T_E_T2
#------------------------------------------------------------------------------
# Lesson T3
#------------------------------------------------------------------------------
*:T3
*:_T_S_T3
#                                                             ../orig/t.typ:145
I:Let's review first.
*:_T_R_L33
#                                                             ../orig/t.typ:146
O:fff jjj ddd kkk sss lll aaa ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L33

*:_T_R_L34
#                                                             ../orig/t.typ:147
O:fgf jhj ded k,k fgf jhj ded k,k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L34

#                                                             ../orig/t.typ:149
I:Use your K-finger for the I key.
*:_T_R_L35
#                                                             ../orig/t.typ:150
O:kkk kik kkk kik kkk iii kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L35

*:_T_R_L36
#                                                             ../orig/t.typ:154
O:kkk iii kkk iii kk ii kk ii
 :kkk lid kkk hill kkk did kkk
 :kkk kill kkk kid kkk like kkk
 :kkk kiss kkk hide kkk fill kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L36

#                                                             ../orig/t.typ:155
I:Use your F-finger for the R key.
*:_T_R_L37
#                                                             ../orig/t.typ:156
O:fff frf fff frf fff frf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L37

*:_T_R_L38
#                                                             ../orig/t.typ:160
O:fff rrr fff rrr ff rr ff rr
 :fff rake fff rag fff her fff
 :fff red fff read fff rage fff
 :fff far fff red fff jar fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L38

*:_T_R_L39
#                                                             ../orig/t.typ:161
O:fff fare fff rare fff rake fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L39

*:_T_R_L40
#                                                             ../orig/t.typ:162
O:fff rid fff ire fff fair fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L40

#                                                             ../orig/t.typ:163
I:Use your L-finger for the period.
*:_T_R_L41
#                                                             ../orig/t.typ:164
O:lll l.l lll l.l lll l.l lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L41

*:_T_R_L42
#                                                             ../orig/t.typ:167
O:lll ... lll ... ll .. ll .. l .
 :lll adj. lll id. lll
 :lll eg. lll i.e. lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L42

*:_T_R_L43
#                                                             ../orig/t.typ:179
T:The next key we are going to practice is the right shift key.
 :
 :Whenever you want to capitalize a key on the left side, you must use the
 :right shift-key.  To do so, follow these steps:
 :
 :	a.)  Without moving your first finger from the J-key, swing the
 :	     fourth finger of your right hand over to the SHIFT-key and
 :	     hold it down.
 :
 :	b.)  Strike the key that you want to type with your left hand.
 :
 :	c.)  Immediately bring your fourth finger back to the ;-key.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L43

#                                                             ../orig/t.typ:180
I:Don't look at your fingers!
*:_T_R_L44
#                                                             ../orig/t.typ:181
O:;;; ;A; ;;; ;F; ;;; ;D; ;;; ;S;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L44

*:_T_R_L45
#                                                             ../orig/t.typ:182
O:;;; Dear ;;; Sir ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L45

*:_T_R_L46
#                                                             ../orig/t.typ:183
O:;;; Fred ;;; Gail ;;; Alf ;;; Dale ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L46

*:_T_R_L47
#                                                             ../orig/t.typ:185
O:;;; Ada ;;; Al ;;; Greg ;;;
 :jjj Dr. jjj Sr. jjj Fr. jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L47

#                                                             ../orig/t.typ:186
I:Let's try some (strange) sentences.
*:_T_R_L48
#                                                             ../orig/t.typ:187
O:Sir, idle disks seek flags.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L48

*:_T_R_L49
#                                                             ../orig/t.typ:191
O:She sells seashells.
 :Sailfish sail idle seas.
 :She seeks a fig leaf.
 :Red hair is like a fire.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L49

#                                                             ../orig/t.typ:192
I:Always double space after a period.
*:_T_R_L50
#                                                             ../orig/t.typ:193
O:A free red jade is fake.  Girls like silk.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L50

*:_T_R_L51
#                                                             ../orig/t.typ:195
O:She seeks a safe reef, if she sails.  A gale is rare.
 :Alf fed her egg salad.  Gail likes hash.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L51

G:_T_E_T3
#------------------------------------------------------------------------------
# Lesson T4
#------------------------------------------------------------------------------
*:T4
*:_T_S_T4
#                                                             ../orig/t.typ:199
I:First a quick review:
*:_T_R_L52
#                                                             ../orig/t.typ:200
O:jkl; fdsa ded fgf jhj k,k kik frf l.l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L52

#                                                             ../orig/t.typ:202
I:Use your L-finger for the O-key.
*:_T_R_L53
#                                                             ../orig/t.typ:203
O:lll lol lll ooo lll lol
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L53

*:_T_R_L53A
#                                                             ../orig/t.typ:206
O:lll log lll rod lll for lll
 :lll load lll roll lll oleo lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L53A

#
I:Use your ;-finger for the P-key.
*:_T_R_L54
#                                                             ../orig/t.typ:207
O:;;; ;p; ;;; ppp ;;; ;p; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L54

*:_T_R_L55
#                                                             ../orig/t.typ:210
O:;;; pad ;;; peg ;;; ape ;;;
 :;;; poke ;;; pear ;;; peek ;;;
 :;;; opera ;;; hope ;;; drape ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L55

*:_T_R_L56
#                                                             ../orig/t.typ:219
T:			The Left-Shift key.
 :
 :To capitalize letters on the right-side of the keyboard:
 :
 :	1.)  Move your A-finger to the LEFT-shift key and hold it down.
 :
 :	2.)  Strike the key that you want to capitalize with your right hand.
 :
 :	3.)  Immediately swing your A-finger back to its home position.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L56

*:_T_R_L57
#                                                             ../orig/t.typ:220
O:aaa Pi aaa Lord aaa Jill aaa
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L57

#                                                             ../orig/t.typ:221
I:Try capitalizing each of the keys on the right-side:
*:_T_R_L58
#                                                             ../orig/t.typ:222
O:Joe Kip Leif Peg Olaf Ira Heidi
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L58

#                                                             ../orig/t.typ:223
I:Don't forget to use your right-shift key for letters on the left side:
*:_T_R_L59
#                                                             ../orig/t.typ:224
O:a;a P.S. a;a I.R.S. a;a
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L59

#                                                             ../orig/t.typ:225
I:Use your ;-finger for the ?-key.
*:_T_R_L60
#                                                             ../orig/t.typ:226
O:;;; ;?; ;;; ??? ;;; ;?; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L60

*:_T_R_L61
#                                                             ../orig/t.typ:227
O:;;; He? ;;; She? ;;; I? ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L61

#                                                             ../orig/t.typ:228
I:Let's try some sentences.
*:_T_R_L62
#                                                             ../orig/t.typ:229
O:Dad fell off a ladder.  Is he safe?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L62

#                                                             ../orig/t.typ:230
I:Always double space after a question mark.
*:_T_R_L63
#                                                             ../orig/t.typ:231
O:Is he here?  Sal said he fell hard.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L63

*:_T_R_L64
#                                                             ../orig/t.typ:233
O:Did she see his fall?  Jake heard he is OK.
 :I hope people keep off high ladders.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L64

G:_T_E_T4
#------------------------------------------------------------------------------
# Lesson T5
#------------------------------------------------------------------------------
*:T5
*:_T_S_T5
#                                                             ../orig/t.typ:237
I:As always, let's start with a review:
*:_T_R_L65
#                                                             ../orig/t.typ:238
O:ade fgh ijk lop rs; ?.,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L65

#                                                             ../orig/t.typ:239
I:Again.
*:_T_R_L66
#                                                             ../orig/t.typ:240
O:ade fgh ijk lop rs; ?.,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L66

#                                                             ../orig/t.typ:242
I:Use your F-finger for the T-key.
*:_T_R_L67
#                                                             ../orig/t.typ:243
O:fff ftf fff ttt fff ftf fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L67

*:_T_R_L68
#                                                             ../orig/t.typ:244
O:ftf the ftf top ftf ate ftf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L68

*:_T_R_L69
#                                                             ../orig/t.typ:245
O:ftf three ftf often ftf there
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L69

*:_T_R_L70
#                                                             ../orig/t.typ:246
O:The talk is that those three are threatening her.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L70

#                                                             ../orig/t.typ:247
I:Use your J-finger for the N-key.
*:_T_R_L71
#                                                             ../orig/t.typ:248
O:jjj jnj jjj nnn jjj jnj jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L71

*:_T_R_L72
#                                                             ../orig/t.typ:251
O:jnj not jnj ton jnj one jnj
 :jnj neither jnj opening jnj kneeling jnj
 :No one has an interest in it.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L72

#                                                             ../orig/t.typ:252
I:Use your ;-finger for the :-key.
*:_T_R_L73
#                                                             ../orig/t.typ:253
O:;;; ;:; ;;; ::: ;;; ;:; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L73

#                                                             ../orig/t.typ:254
I:Always double space after a colon.
*:_T_R_L74
#                                                             ../orig/t.typ:255
O:Dear Sirs:  Dear John:  Dear Alfred:
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L74

*:_T_R_L75
#                                                             ../orig/t.typ:256
O:Dear Dr. Stone:  To Heathkit:
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L75

*:_T_R_L76
#                                                             ../orig/t.typ:271
T:			SPEED EXERCISES
 :
 :From now on, I will be mixing speed exercises in with the lessons.  In the
 :drills that you have been doing, I make you keep practicing a line until
 :you get it right.  In a speed exercise, I will only display the text once.
 :
 :What will be different is that I will be timing you.  From the time you type
 :the first letter of the line until you hit the final carriage return, my
 :stopwatch will be running.  When you finish, I will calculate your typing speed
 :and convert it to words per minute (WPM).  I will also count each of the
 :mistakes you make and display the total number of errors.
 :
 :If you make a mistake, I will beep at you and light up the letter that you
 :should have typed in inverse video (a black letter on a white background).
 :Just keep going and try to make as few errors as possible.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L76

#                                                             ../orig/t.typ:272
I:Try this sentence:
*:_T_R_L77
#                                                             ../orig/t.typ:273
P:Sarah has liked knitting all her life.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L77

#                                                             ../orig/t.typ:274
I:Try a little longer sentence.
*:_T_R_L78
#                                                             ../orig/t.typ:275
P:She looked past her garden to the fields and longed to see the other side.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L78

#                                                             ../orig/t.typ:277
I:When you type a multi-line paragraph, you will have to hit the RETURN-key at
 :the end of each line.
*:_T_R_L79
#                                                             ../orig/t.typ:280
P:All the sane people in this area sold their gold
 :right at the start.  The insane ones held their
 :gold and later it paid off.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L79

*:_T_R_L80
#                                                             ../orig/t.typ:285
P:One fine afternoon the king had an idea.  He
 :sent a letter to all the lords and ladies of
 :his land.  He asked for a great feast.  His
 :people prepared roasts.  His jester did a jig.
 :All the people left hoping to do it again.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L80

G:_T_E_T5
#------------------------------------------------------------------------------
# Lesson T6
#------------------------------------------------------------------------------
*:T6
*:_T_S_T6
#                                                             ../orig/t.typ:289
I:Let's review the letters we've already learned.
*:_T_R_L81
#                                                             ../orig/t.typ:290
O:jkj fdf jlj fsf j;j faf kik ded frf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L81

*:_T_R_L82
#                                                             ../orig/t.typ:293
O:fgf jhj k,k l.l A;A F;F E;E
 :lol ;p; JaJ :a: ftf jnj ;:;
 :jug ton knot poison the neither often
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L82

#                                                             ../orig/t.typ:295
I:Use your F-finger for the B-key.
*:_T_R_L83
#                                                             ../orig/t.typ:296
O:fff fbf fff bbb fff fbf fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L83

#                                                             ../orig/t.typ:297
I:The B-key is the longest reach we've seen so far.  Let's try it again.
*:_T_R_L84
#                                                             ../orig/t.typ:298
O:fff fbf fff bbb fff fbf fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L84

*:_T_R_L84A
#                                                             ../orig/t.typ:301
O:frf bar frf rib frf pub frf
 :frf bring frf abort frf brother frf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L84A

#
I:Use your J-finger for the U-key.
*:_T_R_L85
#                                                             ../orig/t.typ:302
O:jjj juj jjj uuu jjj juj jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L85

*:_T_R_L86
#                                                             ../orig/t.typ:305
O:juj jug juj use juj hug juj
 :juj tulip juj turn juj under juj
 :Please pass the butter and salt, but not the pepper.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L86

#                                                             ../orig/t.typ:306
I:Use your ;-finger for the /-key.
*:_T_R_L87
#                                                             ../orig/t.typ:307
O:;;; ;/; ;;; /// ;;; ;/; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L87

*:_T_R_L88
#                                                             ../orig/t.typ:311
O:;/; n/a ;/; and/or ;/; left/right
 :In this era of E.R.A., I hope he/she likes his/her job.
 :He/she should bring his/her spouse at about noon or just before.
 :Should I be here alone?  Is Bernie and/or Julie going to be here, too?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L88

#                                                             ../orig/t.typ:312
I:Try your speed on some paragraphs:
*:_T_R_L89
#                                                             ../orig/t.typ:315
P:All bills are to be paid in full.  If
 :there is no fee to be paid, return the
 :bill and put n/a in the total due part.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L89

#                                                             ../orig/t.typ:316
I:You should be aiming for 15 WPM.  (If you did better, work on accuracy.)
*:_T_R_L90
#                                                             ../orig/t.typ:319
P:In baseball, bunting is a kind of hit.  But, bunting also
 :refers to a kind of bird and the stuff that is used in
 :flags.  English sure is a strange language.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L90

G:_T_E_T6
#------------------------------------------------------------------------------
# Lesson T7
#------------------------------------------------------------------------------
*:T7
*:_T_S_T7
#                                                             ../orig/t.typ:323
I:First a review of the letters we've learned before:
*:_T_R_L91
#                                                             ../orig/t.typ:324
O:juj ded kik frf lol fgf ;p; jhj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L91

*:_T_R_L92
#                                                             ../orig/t.typ:325
O:ftf jnj ftf jnj fbf juj ;?; l.l k,k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L92

#                                                             ../orig/t.typ:327
I:Use your D-finger for the C-key.
*:_T_R_L93
#                                                             ../orig/t.typ:328
O:ddd dcd ddd ccc ddd dcd
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L93

*:_T_R_L94
#                                                             ../orig/t.typ:331
O:ddd cat ddd cup ddd can
 :dcd duck dcd card dcd pack dcd
 :dcd crate dcd scrap dcd trick dcd
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L94

#                                                             ../orig/t.typ:332
I:Use your J-finger for the M-key
*:_T_R_L95
#                                                             ../orig/t.typ:333
O:jjj jmj jjj mmm jjj jmj jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L95

*:_T_R_L96
#                                                             ../orig/t.typ:337
O:jjj met jjj rim jjj map jjj
 :jmj man jmj men jmj ham jjj
 :jmj Mr. jmj Mrs. jmj Ms. jmj
 :jmj number jmj stream jmj mankind jmj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L96

#                                                             ../orig/t.typ:338
I:Use your ;-finger for the hyphen.
*:_T_R_L97
#                                                             ../orig/t.typ:339
O:;;; ;-; ;;; --- ;;; ;-; ;;; ;-;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L97

*:_T_R_L98
#                                                             ../orig/t.typ:341
O:;;; one-third ;;; one-half ;;; three-fifths ;;;
 :;;; part-time ;;; self-made ;;; all-American ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L98

#                                                             ../orig/t.typ:342
I:Let's try some sentences:
*:_T_R_L99
#                                                             ../orig/t.typ:343
O:Peter Piper picked a peck of pickled peppers.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L99

*:_T_R_L100
#                                                             ../orig/t.typ:344
O:Motion pictures often depict macabre scenes.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L100

*:_T_R_L101
#                                                             ../orig/t.typ:345
O:Once upon a time, marriages lasted longer than mortgages.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L101

#                                                             ../orig/t.typ:346
I:There are three uses of the hyphen.  It can be used to combine two words:
*:_T_R_L102
#                                                             ../orig/t.typ:347
O:She had on a bluish-green dress.  But, no one noticed.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L102

#                                                             ../orig/t.typ:348
I:To divide a word:
*:_T_R_L103
#                                                             ../orig/t.typ:350
O:At macrame class last night, I made a hanging basket for the philo-
 :dendron in our dining room.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L103

#                                                             ../orig/t.typ:351
I:Or, to form a dash:
*:_T_R_L104
#                                                             ../orig/t.typ:352
O:Fifteen dollars a month--measured in current dollars--is a good rate.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L104

#                                                             ../orig/t.typ:353
I:Let's try a speed drill on these sentences:
*:_T_R_L105
#                                                             ../orig/t.typ:355
P:The clock ran out, signaling the end of
 :the second-half.  The game had been lost.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L105

*:_T_R_L106
#                                                             ../orig/t.typ:364
P:The paper just made an announce-
 :ment about a commotion at the
 :college.  Someone has just
 :produced a micro-organism in the
 :DNA-research lab.  It is a
 :special kind of bacteria that
 :consumes crude oil.  The talk is
 :that it is being patented for use
 :on oil spills at sea.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L106

#                                                             ../orig/t.typ:365
I:Hit the return key twice for blank lines:
*:_T_R_L107
#                                                             ../orig/t.typ:374
P:Dear Mr. Mandrake:
 :
 :All of us appreciated the fine performance of those magic
 :tricks.  Please arrange to come to another of our meet-
 :ings, if possible.  Perhaps our Christmas meeting?
 :
 :Thanks,
 :
 :Mrs. Carmichael
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L107

G:_T_E_T7
#------------------------------------------------------------------------------
# Lesson T8
#------------------------------------------------------------------------------
*:T8
*:_T_S_T8
#                                                             ../orig/t.typ:378
I:As always, we will start with a quick review
*:_T_R_L108
#                                                             ../orig/t.typ:379
O:jfj dkd lsl a;a dcd jmj ;-; fbf juj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L108

#                                                             ../orig/t.typ:381
I:Let's try some long words.
*:_T_R_L109
#                                                             ../orig/t.typ:382
O:meteorology camera bituminous chimera phosphates
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L109

#                                                             ../orig/t.typ:383
I:Use your S-finger for the W-key.
*:_T_R_L110
#                                                             ../orig/t.typ:384
O:sss sws sss www sss sws sss
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L110

*:_T_R_L111
#                                                             ../orig/t.typ:385
O:sss wet sss who sss was sss
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L111

*:_T_R_L112
#                                                             ../orig/t.typ:387
O:sws who sws what sws when sws where sws
 :knowledge whatever Wimbledon know-it-all
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L112

*:_T_R_L113
#                                                             ../orig/t.typ:391
P:How much wood could a woodchuck chuck if a
 :woodchuck could chuck wood?  A woodchuck
 :would chuck all the wood that a woodchuck
 :could chuck, if a woodchuck could chuck wood.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L113

#                                                             ../orig/t.typ:392
I:Use your J-finger for the Y-key.
*:_T_R_L114
#                                                             ../orig/t.typ:393
O:jjj jyj jjj yyy jjj jyj jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L114

*:_T_R_L115
#                                                             ../orig/t.typ:396
O:jjj why jjj you jjj try jjj rye jjj
 :jjj year jjj July jjj your jjj jury jjj
 :Were your yard sales much better last year?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L115

#                                                             ../orig/t.typ:397
I:Try your speed on this sentence:
*:_T_R_L116
#                                                             ../orig/t.typ:398
P:Why are you typing so slowly?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L116

#                                                             ../orig/t.typ:399
I:Use your F-finger for the V-key.
*:_T_R_L117
#                                                             ../orig/t.typ:400
O:fff fvf fff vvv fff fvf fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L117

*:_T_R_L118
#                                                             ../orig/t.typ:401
O:fff vat fff eve fff vow fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L118

*:_T_R_L119
#                                                             ../orig/t.typ:402
O:fvf vine fvf dove fvf ever fvf very fvf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L119

*:_T_R_L120
#                                                             ../orig/t.typ:405
O:driven vertical advent ventrical
 :What a fine vineyard you have.
 :Do you intend to play adventure every night?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L120

*:_T_R_L121
#                                                             ../orig/t.typ:419
T:			THE BACKSPACE
 :
 :Most of the programs that you use will allow you to correct your mistakes by
 :using the BACKSPACE and/or DELETE keys.  These keys will generally delete the
 :previous character that you typed.  (This feature is one of the principal
 :advantages of a word-processing system over a conventional typewriter.)
 :
 :I refuse to accept either of these keys during a drill pattern.  (You should
 :keep practicing until you get it right!)  But, I will accept either a BACK-
 :SPACE or a DELETE during a speed drill.  (I will remove the white error
 :markers but I still count it as an error in my totals.)
 :
 :If you do chose to use the DELETE or BACKSPACE keys, hit the key with your
 :;-finger and immediately return your fingers to the home position.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L121

#                                                             ../orig/t.typ:420
I:Let's try our speed on some nursery rhymes!
*:_T_R_L122
#                                                             ../orig/t.typ:424
P:Mary had a little lamb
 :Its fleece was white as snow
 :And every where that Mary went
 :The lamb was sure to go.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L122

*:_T_R_L123
#                                                             ../orig/t.typ:426
P:Jack and Jill went up a hill to fetch a pail of water.
 :Jack fell down and broke his crown and Jill came tumbling after.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L123

*:_T_R_L124
#                                                             ../orig/t.typ:431
P:Little Miss Muffet sat on a tuffet
 :Eating her curds and whey.
 :Along came a spider
 :Who sat down beside her
 :And frightened Miss Muffet away.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L124

*:_T_R_L125
#                                                             ../orig/t.typ:436
P:Hey, diddle diddle--
 :The cat and the fiddle
 :The cow jumped over the moon.
 :The little dog laughed to see such sport,
 :And the dish ran away with the spoon.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L125

G:_T_E_T8
#------------------------------------------------------------------------------
# Lesson T9
#------------------------------------------------------------------------------
*:T9
*:_T_S_T9
#                                                             ../orig/t.typ:440
I:First, a review.
*:_T_R_L126
#                                                             ../orig/t.typ:441
O:a;a sls dkd fjf sws jyj fvf dcd jmj ;-;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L126

#                                                             ../orig/t.typ:443
I:Notice that the only letters left to go are the Q, X, and Z!
*:_T_R_L127
#                                                             ../orig/t.typ:444
O:abcdefghijklmnoprstuvwy
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L127

#                                                             ../orig/t.typ:445
I:Use your A-finger for the Q-key.
*:_T_R_L128
#                                                             ../orig/t.typ:446
O:aaa aqa aaa qqq aaa aqa aaa
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L128

*:_T_R_L128A
#                                                             ../orig/t.typ:450
O:aaa quit aaa quad aaa quip aaa
 :lacquer inquiry squirt quart
 :quail quiver inquest marquis
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L128A

#
I:Use your S-finger for the X-key.
*:_T_R_L129
#                                                             ../orig/t.typ:451
O:sss sxs sss xxx sss sxs sss
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L129

*:_T_R_L129A
#                                                             ../orig/t.typ:455
O:sss ax sss ox sss vex sss wax xxx
 :examine ex-wife excellent boxer sixteen
 :exactly sphinx oxygen except thorax
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L129A

#
I:Use your A-finger for the Z-key.
*:_T_R_L130
#                                                             ../orig/t.typ:456
O:aaa aza aaa zzz aaa aza aaa
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L130

*:_T_R_L131
#                                                             ../orig/t.typ:459
O:aaa adz aaa azo aaa coz aaa
 :quiz jazz quartz zinc dozen
 :oxidize squeeze azimuth zoology
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L131

#                                                             ../orig/t.typ:460
I:The big event!!!!!!!!!!!!!!!!!!
*:_T_R_L132
#                                                             ../orig/t.typ:461
O:abcdefghijklmnopqrstuvwxyz
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L132

*:_T_R_L132A
#                                                             ../orig/t.typ:463
O:zyxwvutsrqponmlkjihgfedcba
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L132A

#
I:Let's try some sentences:
*:_T_R_L133
#                                                             ../orig/t.typ:464
O:A dozen zebras were grazing quietly nearby.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L133

*:_T_R_L134
#                                                             ../orig/t.typ:465
O:The zeppelin zigzagged quickly from the horizon up to the zenith.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L134

*:_T_R_L135
#                                                             ../orig/t.typ:466
O:Never trust a quack doctor who cannot distinguish oxygen from nitrogen.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L135

*:_T_R_L136
#                                                             ../orig/t.typ:467
O:Imagine having a sextet of sexagenarian sextons?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L136

*:_T_R_L137
#                                                             ../orig/t.typ:469
O:Remember when queer used to mean zany?
 :Quartz crystal watches were at one time extremely expensive.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L137

#                                                             ../orig/t.typ:470
I:Let's try a sentence that contains every letter of the alphabet.
*:_T_R_L138
#                                                             ../orig/t.typ:471
O:A quick brown fox jumped over the lazy dogs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L138

#                                                             ../orig/t.typ:472
I:Again,
*:_T_R_L139
#                                                             ../orig/t.typ:473
O:A quick brown fox jumped over the lazy dogs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L139

#                                                             ../orig/t.typ:474
I:See how fast you can type it this time:
*:_T_R_L140
#                                                             ../orig/t.typ:475
P:A quick brown fox jumped over the lazy dogs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L140

#                                                             ../orig/t.typ:476
I:Again,
*:_T_R_L141
#                                                             ../orig/t.typ:477
P:A quick brown fox jumped over the lazy dogs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L141

G:_T_E_T9
#------------------------------------------------------------------------------
# Lesson T10
#------------------------------------------------------------------------------
*:T10
*:_T_S_T10
#                                                             ../orig/t.typ:481
I:Let's review the entire alphabet before starting the number keys.
*:_T_R_L142
#                                                             ../orig/t.typ:482
O:abcd efg hijk lmnop qrs tuv wx yz
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L142

#                                                             ../orig/t.typ:484
I:Once more
*:_T_R_L143
#                                                             ../orig/t.typ:485
O:abcdefghijklmnopqrstuvwxyz
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L143

#                                                             ../orig/t.typ:486
I:Use the shift key for each letter (Do not use the CAPS LOCK key)
*:_T_R_L144
#                                                             ../orig/t.typ:487
O:ABCDEFGHIJKLMNOPQRSTUVWXYZ
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L144

#                                                             ../orig/t.typ:488
I:Now, review the punctuations that you've had.
*:_T_R_L145
#                                                             ../orig/t.typ:489
O:l;l l:l k,k l.l ;/; ;?; :?: ;-;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L145

*:_T_R_L146
#                                                             ../orig/t.typ:509
T:
 :			NUMERIC KEYS
 :
 :The terminal has two sets of numeric keys.  One set--directly above the
 :alphabetic keys--conforms to the standard for typewriter keyboards.  The other
 :set--to your right--resembles a calculator keypad.  In this typing series we
 :will be concerned only with the standard numeric keys on the main keyboard.
 :(If you would like to learn to touch type on a numeric keypad, use the N-series
 :lessons instead.)
 :
 :NOTE - not all terminals have the numeric keys in a separate keypad
 :
 :The numeric keys, like all the keys you will be learning from now on, vary
 :somewhat from machine to machine.  The 2 through 0 keys are always in exactly
 :the same place on all typewriter keyboards.  (On keypunch machines and some
 :terminals, however, they are located over the U, I, O, J, K, L, M, comma and
 :period keys.  We will not be concerned with these layouts in this series.)
 :Even if a typewriter or terminal has the standard 2 through 0 keys, it may not
 :have a 1 key.  If it does, the 1 will always be next to the 2.  If it does not,
 :you will have to use the L-key.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L146

#                                                             ../orig/t.typ:510
I:Let's start by using the 1-key, since we have one.  (Use your A-finger.)
*:_T_R_L147
#                                                             ../orig/t.typ:511
O:aaa a1a aaa 111 aaa a1a
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L147

*:_T_R_L148
#                                                             ../orig/t.typ:514
O:a1q qa1 qz1 az1 aq1 a1z
 :111 and 111 ate 111 any 111
 :If 11 men each catch 11 fish in 11 days, how many fish were caught?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L148

#                                                             ../orig/t.typ:515
I:Use your S-finger for the 2-key.
*:_T_R_L149
#                                                             ../orig/t.typ:516
O:sss s2s sss s2s sss s2s
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L149

*:_T_R_L149A
#                                                             ../orig/t.typ:520
O:sss s2w sss 2xw sss w2x sss
 :222 saw 222 was 222 wet 222
 :The 2 men were 2 late 2 catch the 2 PM train.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L149A

#
I:Use your D-finger for the 3-key.
*:_T_R_L150
#                                                             ../orig/t.typ:521
O:ddd d3d ddd d3d ddd d3d ddd
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L150

*:_T_R_L151
#                                                             ../orig/t.typ:524
O:ddd d3e ddd d3c ddd e3c ddd
 :333 did 333 cat 333 eat 333
 :1 plus 2 is 3.  11 plus 22 is 33.  111 plus 222 is 333.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L151

#                                                             ../orig/t.typ:525
I:The last number we will practice today is the 4-key.  (Use your F-finger.)
*:_T_R_L152
#                                                             ../orig/t.typ:526
O:fff f4f fff f4f fff f4f
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L152

*:_T_R_L153
#                                                             ../orig/t.typ:531
O:fff f4r fff 4vr fff 4vr fff
 :444 for fff rat 444 vet 444
 :Flight 423 leaves from gate 42 at 4:24.
 :As the 3 musketeers say: 1 4 all, and all 4 1.
 :If 1/4 plus 2/3 is 11/12, what is 1/2 plus 1/3?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L153

#                                                             ../orig/t.typ:532
I:Try your speed on this line:
*:_T_R_L154
#                                                             ../orig/t.typ:533
P:Our team won 1st, 2nd, and 3rd place at the 12th annual outing.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L154

#                                                             ../orig/t.typ:535
I:As we stated earlier, many typewriters do not have a 1 key.  Let's practice
 :using the L-key as a 1, so you can use any kind of typewriter.
*:_T_R_L155
#                                                             ../orig/t.typ:536
O:One dozen is l2.  A gross is l2 dozen or l44.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L155

*:_T_R_L156
#                                                             ../orig/t.typ:538
O:In both octal and decimal, ll times ll is l2l.  And, 3 minus 4 is -l.
 :But in octal, l2 is not divisible by 3.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L156

G:_T_E_T10
#------------------------------------------------------------------------------
# Lesson T11
#------------------------------------------------------------------------------
*:T11
*:_T_S_T11
#                                                             ../orig/t.typ:542
I:Let's review the numbers that you have already learned.
*:_T_R_L157
#                                                             ../orig/t.typ:543
O:a1a s2s d3d f4f 234 413
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L157

*:_T_R_L158
#                                                             ../orig/t.typ:544
O:f4r d3e s2w a1q az1 sx2 dc3 fv4
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L158

#                                                             ../orig/t.typ:546
I:Use your J-finger for the 7-key
*:_T_R_L159
#                                                             ../orig/t.typ:547
O:jjj j7j jjj j7j jjj j7j jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L159

*:_T_R_L160
#                                                             ../orig/t.typ:551
O:jjj j7u jjj 7um jjj u7m jjj
 :777 map 777 jug 777 rum 777
 :Is flight number 377 for Florida a 707, a 727 or a 747?
 :It is a 727 with 4 stops.  With all those stops it takes almost 7 hours.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L160

#                                                             ../orig/t.typ:552
I:Use your K-finger for the 8-key.
*:_T_R_L161
#                                                             ../orig/t.typ:553
O:kkk k8k kkk k8k kkk k8k kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L161

*:_T_R_L162
#                                                             ../orig/t.typ:557
O:kkk k8i kkk 8,i kkk ,i8 kkk
 :888 kick 888 sink 888 keep 888
 :Agent 88 was supposed to check in at 8:14.  She is 38 minutes late.
 :Her team was assigned to zone 8 of quadrant 828.  Send 8 more agents.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L162

#                                                             ../orig/t.typ:558
I:Use your L-finger for the 9-key.
*:_T_R_L163
#                                                             ../orig/t.typ:559
O:lll l9l lll l9l lll l9l lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L163

*:_T_R_L164
#                                                             ../orig/t.typ:563
O:lll 9.o lll o9. lll l9. lll
 :999 Jr. 999 log 999 old 999
 :Oh, 99 bottles of beer on the wall, 99 bottles of beer.
 :If 9 of us take 9 each, there will still be 18 left for the song.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L164

#                                                             ../orig/t.typ:564
I:Use your ;-finger for the 0-key.
*:_T_R_L165
#                                                             ../orig/t.typ:565
O:;;; ;0; ;;; ;0; ;;; ;0; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L165

*:_T_R_L166
#                                                             ../orig/t.typ:570
O:;;; ;0p ;;; /0p ;;; 0/p ;;;
 :000 a/c 000 pup 000 me? 000
 :Dear Sirs:  The 10:00 meeting on March 10 has been postponed until 10:30.
 :The 10:30 meeting was moved to 11:00 in Room 302.
 :But, Room 302 can only hold 10 people.  We will need Conference Room 10.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L166

#                                                             ../orig/t.typ:571
I:Let's try some paragraphs.
*:_T_R_L167
#                                                             ../orig/t.typ:580
P:Zip codes are arranged so that the first 3 digits
 :designate the regional office and the last 2
 :digits designate the local branch.  The numbering
 :is roughly east to west.  That is, numbers
 :starting with 0 are in New England, numbers
 :starting with 1 are the New York area, etc.
 :There are notable exceptions to this rule,
 :however.  The Virgin Islands are south of
 :Florida, but their Zip Codes start with 00.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L167

*:_T_R_L168
#                                                             ../orig/t.typ:587
P:The new nine digit zip codes have upset quite a
 :few people.  It was bad enough being referred to
 :as 73218.  But now, we will have to remember
 :numbers like 73218-4208.  The worst hit will be
 :the companies whose mailing list programs were
 :poorly designed.  Those unstructured programs
 :will be very difficult to change.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L168

G:_T_E_T11
#------------------------------------------------------------------------------
# Lesson T12
#------------------------------------------------------------------------------
*:T12
*:_T_S_T12
#                                                             ../orig/t.typ:591
I:Let's review the numbers that you have learned so far.
*:_T_R_L169
#                                                             ../orig/t.typ:592
O:j7j f4f k8k d3d l9l s2s ;0; a1a
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L169

*:_T_R_L170
#                                                             ../orig/t.typ:593
O:4f4 7j7 3d3 8k8 2s2 9l9 1a1 0;0
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L170

#                                                             ../orig/t.typ:595
I:Use your F-finger for the 5-key.
*:_T_R_L171
#                                                             ../orig/t.typ:596
O:fff f5f fff 555 fff f5f fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L171

*:_T_R_L172
#                                                             ../orig/t.typ:599
O:f5f f54 f5f t5g f5f t5r f5f
 :f5f five f5f two f5f four f5f
 :f5f 453 f5f 585 f5f 475 f5f
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L172

*:_T_R_L173
#                                                             ../orig/t.typ:600
P:The 5 of us each carried 50 pound packs all 45 miles of the trip.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L173

#                                                             ../orig/t.typ:601
I:And now, the longest reach of all!  Use your J-finger for the 6-key.
*:_T_R_L174
#                                                             ../orig/t.typ:602
O:jjj j6j jjj 666 jjj j6j jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L174

*:_T_R_L175
#                                                             ../orig/t.typ:605
O:j6j June j6j much j6j hum j6j
 :j6j y6n j6j u6m j6j h76 j6j
 :j6j 4567 j6j 7654 j6j 6754 j6j
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L175

#                                                             ../orig/t.typ:606
I:The open parenthesis is the shift of the 9-key.  (Use your L-finger).
*:_T_R_L176
#                                                             ../orig/t.typ:607
O:lll l(l lll ((( lll l(l lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L176

*:_T_R_L177
#                                                             ../orig/t.typ:608
O:l(l (.l l(l 9(9 l(l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L177

*:_T_R_L178
#                                                             ../orig/t.typ:609
O:l(l loop l(l oil l(l only l(l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L178

#                                                             ../orig/t.typ:610
I:The close parenthesis is the shift of the 0-key.  (Use your ;-finger).
*:_T_R_L179
#                                                             ../orig/t.typ:611
O:;;; ;); ;;; ;); ;;; ;);
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L179

*:_T_R_L180
#                                                             ../orig/t.typ:613
O:;;; (.) ;;; (.) ;;; (,) ;;;
 :;); pole ;); loop ;); pile ;);
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L180

*:_T_R_L181
#                                                             ../orig/t.typ:614
O:You (the buyer) should ask him (the seller) for the price (of the goods).
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L181

*:_T_R_L182
#                                                             ../orig/t.typ:615
O:If (X-5) / (X-6) is 56, then what is (X/5) - (X/6)?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L182

*:_T_R_L183
#                                                             ../orig/t.typ:616
O:1 2 3 4 5 6 7 8 9 10
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L183

#                                                             ../orig/t.typ:617
I:Try your speed on this song.
*:_T_R_L184
#                                                             ../orig/t.typ:621
P:1 little, 2 little, 3 little Indians,
 :4 little, 5 little, 6 little Indians,
 :7 little, 8 little, 9 little Indians,
 :10 little Indian boys.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L184

*:_T_R_L185
#                                                             ../orig/t.typ:625
P:If we want to catch the 6:15 flight to Phoenix (which is the
 :non-stop), we will have to leave by 5:00 at the latest (in
 :case we run into traffic).  Otherwise, we will have to take
 :the 6:45 flight (which makes 5 stops).
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L185

#                                                             ../orig/t.typ:626
I:Use the main keyboard keys.  Don't cheat and use the auxilliary keypad!
#                                                             ../orig/t.typ:627
 :Try entering straight numbers: 
*:_T_R_L186
#                                                             ../orig/t.typ:628
O:423 475 925 235 295 175 650
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L186

*:_T_R_L187
#                                                             ../orig/t.typ:630
O:598 693 602 672 315 604 587 307
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L187

*:_T_R_L188
#                                                             ../orig/t.typ:631
O:12.00 67.50 99.95 38.75 19.99
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L188

#                                                             ../orig/t.typ:632
I:Now let's try for some speed.
*:_T_R_L189
#                                                             ../orig/t.typ:633
P:353 648 604 592 468 501 296
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L189

*:_T_R_L190
#                                                             ../orig/t.typ:641
P:3574
 :1937
 :2586
 :1904
 :1837
 :9003
 :7283
 :6745
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L190

G:_T_E_T12
#------------------------------------------------------------------------------
# Lesson T13
#------------------------------------------------------------------------------
*:T13
*:_T_S_T13
*:_T_R_L191
#                                                             ../orig/t.typ:657
T:
 :There is no Lesson 13!  Don't you know that 13 is an unlucky number?
 :
 :If you have completed Lessons T1 through T12, then you are now ready
 :to call yourself a touch typist.  You have learned to touch type all
 :of the keys which are standardized!  You can now begin the SPEED
 :series of lessons if you would like.  (If you come across a punctua-
 :tion symbol which you have not learned, simply look for it.  Use the
 :appropriate finger for the shifted numeric keys.  Use your ;-finger
 :for all the keys on the right-hand side.)
 :
 :We will practice touch typing on the keyboard layout for the remaining
 :lessons.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L191

G:_T_E_T13
#------------------------------------------------------------------------------
# Lesson T14
#------------------------------------------------------------------------------
*:T14
*:_T_S_T14
#                                                             ../orig/t.typ:661
I:Use your ;-finger for the apostrophe.
*:_T_R_L192
#                                                             ../orig/t.typ:662
O:;;; ;'; ;;; ''' ;;; ;'; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L192

*:_T_R_L193
#                                                             ../orig/t.typ:664
O:;'; it's ;'; 'till ;'; won't ;';
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L193

*:_T_R_L194
#                                                             ../orig/t.typ:667
O:;'; 'tis ;'; isn't ;'; 'tis too ;';
 :What's this I've got?  Isn't this yesterday's paper?  Where's today's?
 :Can't you find anything?  It's right next to Dad's chair.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L194

#                                                             ../orig/t.typ:668
I:Shift the apostrophe for the quote key.
*:_T_R_L195
#                                                             ../orig/t.typ:669
O:;;; ;"; ;;; """ ;;; ;"; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L195

*:_T_R_L196
#                                                             ../orig/t.typ:673
O:;"; "." ;"; ":" ;"; "," ;";
 :"What was that I saw you take from the teacher desk?" asked Tom.
 :"It's the answers to tomorrow's quiz", answered Suzy.
 :"If you promise not to tell," she continued, "I'll give you a copy."
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L196

#                                                             ../orig/t.typ:674
I:Use your A-finger for the exclamation point.
*:_T_R_L197
#                                                             ../orig/t.typ:675
O:aaa a!a aaa !!! aaa a!a aaa
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L197

*:_T_R_L198
#                                                             ../orig/t.typ:676
O:a!a Ah! a!a What! a!a Oh! a!a
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L198

#                                                             ../orig/t.typ:677
I:Always double space after an exclamation point.
*:_T_R_L199
#                                                             ../orig/t.typ:678
O:Tomorrow's quiz!  What if we get caught?  We'll be expelled!
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L199

*:_T_R_L200
#                                                             ../orig/t.typ:679
O:He'll never suspect a thing!  We'll get some answers wrong to fool him.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L200

G:_T_E_T14
#------------------------------------------------------------------------------
# Lesson T15
#------------------------------------------------------------------------------
*:T15
*:_T_S_T15
*:_T_R_L201
#                                                             ../orig/t.typ:688
T:
 :
 :In this lesson we will be practicing the special symbols which you will need
 :for BASIC or other programming languages.  I won't give you too much practice
 :with these symbols right now.  (You should be able to get plenty of exercise by
 :simply typing in programs.)
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L201

#                                                             ../orig/t.typ:690
I:Use your ;-finger for the equals key.
*:_T_R_L202
#                                                             ../orig/t.typ:691
O:;;; ;=; ;;; ;=; ;;; ;=; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L202

*:_T_R_L203
#                                                             ../orig/t.typ:693
O:;=; -=- ;=; '=' ;=; :=: ;=;
 :;=; X=2 ;=; Y=3 ;=; Z=0 ;=;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L203

#                                                             ../orig/t.typ:694
I:Use your K-finger for the asterisk key.
*:_T_R_L204
#                                                             ../orig/t.typ:695
O:kkk k*k kkk k*k kkk k*k kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L204

*:_T_R_L205
#                                                             ../orig/t.typ:697
O:k*k 3*2 k*k 5*6 k*k 9*7 k*k
 :k*k i*i k*k *,* k*k 8*8 k*k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L205

#                                                             ../orig/t.typ:698
I:Use your ;-finger for the plus sign.
*:_T_R_L206
#                                                             ../orig/t.typ:699
O:;;; ;+; ;;; ;+; ;;; ;+; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L206

*:_T_R_L207
#                                                             ../orig/t.typ:701
O:;+; 2+4 ;+; 7+5 ;+; 8+0 ;+;
 :;+; +=+ ;+; -+- ;+; /+/ ;+;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L207

#                                                             ../orig/t.typ:702
I:Use your L-finger for the greater-than key.
*:_T_R_L208
#                                                             ../orig/t.typ:703
O:lll l>l lll l>l lll l>l lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L208

*:_T_R_L209
#                                                             ../orig/t.typ:705
O:l>l X>3 l>l Y>7 l>l Z>0 l>l
 :l>l >>> l>l 9>9 l>l .>. l>l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L209

#                                                             ../orig/t.typ:706
I:Use your K-finger for the less-than key.
*:_T_R_L210
#                                                             ../orig/t.typ:707
O:kkk k<k kkk k<k kkk k<k kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L210

*:_T_R_L211
#                                                             ../orig/t.typ:709
O:k<k X<0 k<k Y<2 k<k Z<8 k<k
 :k<k <.> k<k >.< k<k <<< k<k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L211

#                                                             ../orig/t.typ:710
I:Use your J-finger for the up-arrow key.
*:_T_R_L212
#                                                             ../orig/t.typ:711
O:jjj j^j jjj ^^^ jjj j^j jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L212

*:_T_R_L213
#                                                             ../orig/t.typ:713
O:j^j X^2 j^j Y^3 j^j Z^4 j^j
 :j^j <^> j^j .^. j^j "^" j^j
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L213

#                                                             ../orig/t.typ:714
I:Try entering this BASIC program:
*:_T_R_L214
#                                                             ../orig/t.typ:719
P:10 LET x=10
 :20 LET y=20
 :30 PRINT x+y/3
 :40 PRINT y/x*5
 :50 STOP
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L214

#                                                             ../orig/t.typ:720
I:And another:
*:_T_R_L215
#                                                             ../orig/t.typ:728
P:10 REM Program to find square roots with using ^.5 feature
 :20 INPUT "What number do you want the square root of? ";s
 :30 x = 2
 :40 y = s/x
 :50 x = (x+y)/2
 :60 IF ABS(x^2 - s) > s/1000 THEN 40
 :70 PRINT "The square root of ";s;" is ";x
 :80 STOP
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L215

#                                                             ../orig/t.typ:729
I:Press down the CAPS LOCK key to simplify typing in this BASIC program:
*:_T_R_L216
#                                                             ../orig/t.typ:744
P:100 REM PROGRAM TO SOLVE QUADRATIC EQUATION
 :125 PRINT "ENTER THE VALUES OF A, B, AND C WHERE:"
 :150 PRINT
 :175 PRINT "AX^2 + BX + C = 0"
 :200 INPUT A,B,C
 :210 IF A = 0 THEN 400
 :225 D = B^2 - 4*A*C
 :250 IF D < 0 THEN 500
 :275 PRINT "ONE ROOT IS: ";-B+SQR(D)/2/A
 :300 PRINT "THE OTHER IS: ";-B-SQR(D)/2/A
 :325 STOP
 :400 PRINT "NOT A QUADRATIC.  TRY AGAIN."
 :425 GOTO 100
 :500 PRINT "COMPLEX ROOTS.  TRY AGAIN."
 :525 GOTO 125
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L216

G:_T_E_T15
#------------------------------------------------------------------------------
# Lesson T16
#------------------------------------------------------------------------------
*:T16
*:_T_S_T16
*:_T_R_L217
#                                                             ../orig/t.typ:760
T:
 :In this lesson we will be practicing the shifted numeric keys on the
 :terminal keyboard.  I will only be giving you practice in the keystroke
 :motions.  Very few sentence drills or speed exercises are included, since these
 :keys are used so infrequently.
 :
 :If you are typing something which includes one of these special characters and
 :you cannot remember where a key is, look.  But, always make sure to hit the key
 :with the correct finger.  (If you do use the key often, you will eventually
 :learn where it is without looking.)  Since these keys are used infrequently and
 :are in different places on most other keyboards or are totally missing, speed
 :is not important.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L217

#                                                             ../orig/t.typ:761
I:Use your S-finger for the at-sign.
*:_T_R_L218
#                                                             ../orig/t.typ:762
O:sss s@s sss s@s sss s@s sss
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L218

*:_T_R_L219
#                                                             ../orig/t.typ:764
O:s@s at@ s@s w@x s@s S@w s@s
 :s@s wax s@s mix s@s @we s@s
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L219

#                                                             ../orig/t.typ:765
I:Use your D-finger for the pound-sign (also called the number-sign).
*:_T_R_L220
#                                                             ../orig/t.typ:766
O:ddd d#d ddd d#d ddd d#d ddd
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L220

*:_T_R_L221
#                                                             ../orig/t.typ:768
O:d#d d#e d#d 3#c d#d #c# d#d
 :d#d cat d#d dog d#d eat d#d
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L221

#                                                             ../orig/t.typ:769
I:Use your F-finger for the dollar-sign.
*:_T_R_L222
#                                                             ../orig/t.typ:770
O:fff f$f fff f$f fff f$f fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L222

*:_T_R_L223
#                                                             ../orig/t.typ:773
O:f$f r$v f$f v$4 f$f 4$r f$f
 :f$f rave f$f fare f$f $10.00 f$f
 :Joe keeps cryptic inventory bills like:  4# @ $5.00/# or 6# @ $4.50/#.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L223

#                                                             ../orig/t.typ:774
I:Use your F-finger for the percent sign as well.
*:_T_R_L224
#                                                             ../orig/t.typ:775
O:fff f%f fff f%f fff f%f fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L224

*:_T_R_L225
#                                                             ../orig/t.typ:779
O:f%f 12% f%f 10% f%f 20% f%f
 :f%f two f%f ran f%f bug f%f
 :If a $25.00 item is sold at a 10% discount, it will cost $22.50.
 :But, a 10% markup on a item selling for $22.50 is only $24.75!  How come?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L225

#                                                             ../orig/t.typ:780
I:Use your J-finger for the ampersand.
*:_T_R_L226
#                                                             ../orig/t.typ:781
O:jjj j&j jjj j&j jjj j&j jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L226

*:_T_R_L227
#                                                             ../orig/t.typ:782
O:j&j 2&4 j&j 9&5 j&j 7&7 j&j
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L227

*:_T_R_L228
#                                                             ../orig/t.typ:783
O:j&j you&me j&j he&she j&j M&M j&j
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L228

*:_T_R_L229
#                                                             ../orig/t.typ:801
T:				THE END
 :
 :You have now completed the T-series of these lessons.  If you have not already
 :done so, you should now start the N-series or S-series.
 :
 :There are a few keys which we have not studied.  If you decide to touch-type
 :these keys, use the closest finger.  Thus, the ESC, TAB, CAPS LOCK, and SCROLL
 :keys use the A-finger.  And, the keys to the far right (BACKSPACE, DELETE, LINE
 :FEED, RETURN, }, {, etc.) use the ;-finger.  The upper keys (f1, f2, etc.) are
 :not usually touch typed as the reach is too far.  If you can, fine.
 :
 :The CONTROL and REPEAT keys are difficult to touch type, but are treated like
 :the SHIFT keys whenever possible.  For example, to REPEAT an exclamation point,
 :hold the REPEAT key down with your ;-finger and then hit the ! with your A-
 :finger.  Certain command sequences, such as Control/S, are hard to do this way.
 :Many people simply hold the CONTROL-key down with their A-finger and then hit
 :the other key with whatever finger is convenient (usually the F-finger in this
 :case).
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L229

G:_T_E_T16
#------------------------------------------------------------------------------
# Lesson series T jump tables
#------------------------------------------------------------------------------
*:_T_E_T1
Q: Do you want to continue to lesson T2 [Y/N] ? 
N:_T_MENU
G:_T_M_T2
*:_T_E_T2
Q: Do you want to continue to lesson T3 [Y/N] ? 
N:_T_MENU
G:_T_M_T3
*:_T_E_T3
Q: Do you want to continue to lesson T4 [Y/N] ? 
N:_T_MENU
G:_T_M_T4
*:_T_E_T4
Q: Do you want to continue to lesson T5 [Y/N] ? 
N:_T_MENU
G:_T_M_T5
*:_T_E_T5
Q: Do you want to continue to lesson T6 [Y/N] ? 
N:_T_MENU
G:_T_M_T6
*:_T_E_T6
Q: Do you want to continue to lesson T7 [Y/N] ? 
N:_T_MENU
G:_T_M_T7
*:_T_E_T7
Q: Do you want to continue to lesson T8 [Y/N] ? 
N:_T_MENU
G:_T_M_T8
*:_T_E_T8
Q: Do you want to continue to lesson T9 [Y/N] ? 
N:_T_MENU
G:_T_M_T9
*:_T_E_T9
Q: Do you want to continue to lesson T10 [Y/N] ? 
N:_T_MENU
G:_T_M_T10
*:_T_E_T10
Q: Do you want to continue to lesson T11 [Y/N] ? 
N:_T_MENU
G:_T_M_T11
*:_T_E_T11
Q: Do you want to continue to lesson T12 [Y/N] ? 
N:_T_MENU
G:_T_M_T12
*:_T_E_T12
Q: Do you want to continue to lesson T13 [Y/N] ? 
N:_T_MENU
G:_T_M_T13
*:_T_E_T13
Q: Do you want to continue to lesson T14 [Y/N] ? 
N:_T_MENU
G:_T_M_T14
*:_T_E_T14
Q: Do you want to continue to lesson T15 [Y/N] ? 
N:_T_MENU
G:_T_M_T15
*:_T_E_T15
Q: Do you want to continue to lesson T16 [Y/N] ? 
N:_T_MENU
G:_T_M_T16
*:_T_E_T16
G:_T_MENU

*:_T_M_T1
B:                             Lesson T1
K:12:_T_MENU
G:_T_S_T1
*:_T_M_T2
B:                             Lesson T2
K:12:_T_MENU
G:_T_S_T2
*:_T_M_T3
B:                             Lesson T3
K:12:_T_MENU
G:_T_S_T3
*:_T_M_T4
B:                             Lesson T4
K:12:_T_MENU
G:_T_S_T4
*:_T_M_T5
B:                             Lesson T5
K:12:_T_MENU
G:_T_S_T5
*:_T_M_T6
B:                             Lesson T6
K:12:_T_MENU
G:_T_S_T6
*:_T_M_T7
B:                             Lesson T7
K:12:_T_MENU
G:_T_S_T7
*:_T_M_T8
B:                             Lesson T8
K:12:_T_MENU
G:_T_S_T8
*:_T_M_T9
B:                             Lesson T9
K:12:_T_MENU
G:_T_S_T9
*:_T_M_T10
B:                            Lesson T10
K:12:_T_MENU
G:_T_S_T10
*:_T_M_T11
B:                            Lesson T11
K:12:_T_MENU
G:_T_S_T11
*:_T_M_T12
B:                            Lesson T12
K:12:_T_MENU
G:_T_S_T12
*:_T_M_T13
B:                            Lesson T13
K:12:_T_MENU
G:_T_S_T13
*:_T_M_T14
B:                            Lesson T14
K:12:_T_MENU
G:_T_S_T14
*:_T_M_T15
B:                            Lesson T15
K:12:_T_MENU
G:_T_S_T15
*:_T_M_T16
B:                            Lesson T16
K:12:_T_MENU
G:_T_S_T16
#------------------------------------------------------------------------------
# Lesson series T menu
#------------------------------------------------------------------------------
*:_T_MENU
*:_T_MENU_PAGE0
B:                 Lesson selection menu - series T [page 1 of 2]
K:1:_T_M_T1
K:2:_T_M_T2
K:3:_T_M_T3
K:4:_T_M_T4
K:5:_T_M_T5
K:6:_T_M_T6
K:7:_T_M_T7
K:8:_T_M_T8
K:9:_T_M_T9
K:10:_T_M_T10
K:11:_T_MENU_PAGE1
K:12:_T_QEXIT
T:The T series contains the following 16 lessons:
 :
 :        Fkey 1 - Lesson T1     a s d f g h j k l ;
 :        Fkey 2 - Lesson T2     e g h ,
 :        Fkey 3 - Lesson T3     i r . shift
 :        Fkey 4 - Lesson T4     o p shift ?
 :        Fkey 5 - Lesson T5     t n :
 :        Fkey 6 - Lesson T6     b u /
 :        Fkey 7 - Lesson T7     c m -
 :        Fkey 8 - Lesson T8     w y v backspace
 :        Fkey 9 - Lesson T9     q x z
 :        Fkey10 - Lesson T10    1 2 3 4
 :
 :        Fkey11 - Next menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_T_MENU_PAGE0
*:_T_MENU_PAGE1
B:                 Lesson selection menu - series T [page 2 of 2]
K:1:_T_M_T11
K:2:_T_M_T12
K:3:_T_M_T13
K:4:_T_M_T14
K:5:_T_M_T15
K:6:_T_M_T16
K:7:NULL
K:8:NULL
K:9:NULL
K:10:NULL
K:11:_T_MENU_PAGE0
K:12:_T_QEXIT
T:The T series contains the following 16 lessons:
 :
 :        Fkey 1 - Lesson T11    7 8 9 0
 :        Fkey 2 - Lesson T12    5 6 ( )
 :        Fkey 3 - Lesson T13
 :        Fkey 4 - Lesson T14    ' " !
 :        Fkey 5 - Lesson T15    = * + > < ^
 :        Fkey 6 - Lesson T16    @ # $ % &
 :
 :
 :
 :
 :
 :        Fkey11 - First menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_T_MENU_PAGE1
*:_T_QEXIT
Q: Do you want to leave this lesson series? [Y/N] ? 
N:_T_MENU
G:_T_EXIT
*:_T_EXIT
#------------------------------------------------------------------------------
